// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file primitives_structCdrAux.ipp
 * This source file contains some declarations of CDR related functions.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__PRIMITIVES_STRUCTCDRAUX_IPP
#define FAST_DDS_GENERATED__PRIMITIVES_STRUCTCDRAUX_IPP

#include "primitives_structCdrAux.hpp"

#include <fastcdr/Cdr.h>
#include <fastcdr/CdrSizeCalculator.hpp>


#include <fastcdr/exceptions/BadParamException.h>
using namespace eprosima::fastcdr::exception;

namespace eprosima {
namespace fastcdr {

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const PrimitivesStruct& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.my_bool(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.my_octet(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.my_char(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.my_wchar(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(4),
                data.my_long(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(5),
                data.my_ulong(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(6),
                data.my_int8(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(7),
                data.my_uint8(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(8),
                data.my_short(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(9),
                data.my_ushort(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(10),
                data.my_longlong(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(11),
                data.my_ulonglong(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(12),
                data.my_float(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(13),
                data.my_double(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(14),
                data.my_longdouble(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const PrimitivesStruct& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.my_bool()
        << eprosima::fastcdr::MemberId(1) << data.my_octet()
        << eprosima::fastcdr::MemberId(2) << data.my_char()
        << eprosima::fastcdr::MemberId(3) << data.my_wchar()
        << eprosima::fastcdr::MemberId(4) << data.my_long()
        << eprosima::fastcdr::MemberId(5) << data.my_ulong()
        << eprosima::fastcdr::MemberId(6) << data.my_int8()
        << eprosima::fastcdr::MemberId(7) << data.my_uint8()
        << eprosima::fastcdr::MemberId(8) << data.my_short()
        << eprosima::fastcdr::MemberId(9) << data.my_ushort()
        << eprosima::fastcdr::MemberId(10) << data.my_longlong()
        << eprosima::fastcdr::MemberId(11) << data.my_ulonglong()
        << eprosima::fastcdr::MemberId(12) << data.my_float()
        << eprosima::fastcdr::MemberId(13) << data.my_double()
        << eprosima::fastcdr::MemberId(14) << data.my_longdouble()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        PrimitivesStruct& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.my_bool();
                                            break;

                                        case 1:
                                                dcdr >> data.my_octet();
                                            break;

                                        case 2:
                                                dcdr >> data.my_char();
                                            break;

                                        case 3:
                                                dcdr >> data.my_wchar();
                                            break;

                                        case 4:
                                                dcdr >> data.my_long();
                                            break;

                                        case 5:
                                                dcdr >> data.my_ulong();
                                            break;

                                        case 6:
                                                dcdr >> data.my_int8();
                                            break;

                                        case 7:
                                                dcdr >> data.my_uint8();
                                            break;

                                        case 8:
                                                dcdr >> data.my_short();
                                            break;

                                        case 9:
                                                dcdr >> data.my_ushort();
                                            break;

                                        case 10:
                                                dcdr >> data.my_longlong();
                                            break;

                                        case 11:
                                                dcdr >> data.my_ulonglong();
                                            break;

                                        case 12:
                                                dcdr >> data.my_float();
                                            break;

                                        case 13:
                                                dcdr >> data.my_double();
                                            break;

                                        case 14:
                                                dcdr >> data.my_longdouble();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const PrimitivesStruct& data)
{

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.my_bool();

                        scdr << data.my_octet();

                        scdr << data.my_char();

                        scdr << data.my_wchar();

                        scdr << data.my_long();

                        scdr << data.my_ulong();

                        scdr << data.my_int8();

                        scdr << data.my_uint8();

                        scdr << data.my_short();

                        scdr << data.my_ushort();

                        scdr << data.my_longlong();

                        scdr << data.my_ulonglong();

                        scdr << data.my_float();

                        scdr << data.my_double();

                        scdr << data.my_longdouble();

}



} // namespace fastcdr
} // namespace eprosima

#endif // FAST_DDS_GENERATED__PRIMITIVES_STRUCTCDRAUX_IPP

