/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.MathType;
import visad.ProductSet;
import visad.SampledSet;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryErrorEstimate;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryIntegerArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySampledSet;
import visad.data.visad.object.BinarySetType;
import visad.data.visad.object.BinaryUnit;
import visad.data.visad.object.BinaryUnknown;

public class BinaryProductSet
implements BinaryObject {
    public static final int computeBytes(SampledSet[] sets, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors) {
        int unitsLen = BinaryUnit.computeBytes(units);
        int errorsLen = BinaryErrorEstimate.computeBytes(errors);
        return 10 + BinarySampledSet.computeBytes(sets) + (cs == null ? 0 : 5) + (unitsLen == 0 ? 0 : unitsLen + 1) + (errorsLen == 0 ? 0 : errorsLen + 1) + 1;
    }

    public static final ProductSet read(BinaryReader reader) throws IOException, VisADException {
        BinaryObjectCache cSysCache = reader.getCoordinateSystemCache();
        BinaryObjectCache typeCache = reader.getTypeCache();
        DataInput file = reader.getInput();
        int typeIndex = file.readInt();
        SetType st = (SetType)typeCache.get(typeIndex);
        SampledSet[] sets = null;
        CoordinateSystem cs = null;
        Unit[] units = null;
        ErrorEstimate[] errs = null;
        boolean reading = true;
        block9: while (reading) {
            byte directive;
            try {
                directive = file.readByte();
            }
            catch (EOFException eofe) {
                return null;
            }
            switch (directive) {
                case 11: {
                    sets = BinarySampledSet.readList(reader);
                    continue block9;
                }
                case 32: {
                    int index = file.readInt();
                    cs = (CoordinateSystem)cSysCache.get(index);
                    continue block9;
                }
                case 40: {
                    units = BinaryUnit.readList(reader);
                    continue block9;
                }
                case 41: {
                    errs = BinaryErrorEstimate.readList(reader);
                    continue block9;
                }
                case 80: {
                    reading = false;
                    continue block9;
                }
            }
            throw new IOException("Unknown ProductSet directive " + directive);
        }
        if (st == null) {
            throw new IOException("No SetType found for ProductSet");
        }
        if (sets == null) {
            throw new IOException("No sets found for ProductSet");
        }
        return new ProductSet((MathType)st, sets, cs, units, errs);
    }

    public static final void writeDependentData(BinaryWriter writer, SetType type, SampledSet[] sets, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, ProductSet set, Object token) throws IOException {
        if (!(set.getClass().equals(ProductSet.class) || set instanceof ProductSet && set instanceof Saveable)) {
            return;
        }
        Object dependToken = token == SAVE_DEPEND_BIG ? token : SAVE_DEPEND;
        BinarySetType.write(writer, type, set, SAVE_DATA);
        if (cs != null) {
            BinaryCoordinateSystem.write(writer, cs, SAVE_DATA);
        }
        if (units != null) {
            BinaryUnit.writeList(writer, units, SAVE_DATA);
        }
        if (errors != null) {
            BinaryErrorEstimate.writeList(writer, errors, SAVE_DATA);
        }
        if (sets != null) {
            for (int i = 0; i < sets.length; ++i) {
                BinaryGeneric.write(writer, sets[i], dependToken);
            }
        }
    }

    public static final void write(BinaryWriter writer, SetType type, SampledSet[] sets, CoordinateSystem cs, Unit[] units, ErrorEstimate[] errors, ProductSet set, Object token) throws IOException {
        BinaryProductSet.writeDependentData(writer, type, sets, cs, units, errors, set, token);
        if (token == SAVE_DEPEND || token == SAVE_DEPEND_BIG) {
            return;
        }
        if (!(set.getClass().equals(ProductSet.class) || set instanceof ProductSet && set instanceof Saveable)) {
            BinaryUnknown.write(writer, set, token);
            return;
        }
        int typeIndex = writer.getTypeCache().getIndex(type);
        if (typeIndex < 0) {
            throw new IOException("SetType " + type + " not cached");
        }
        int csIndex = -1;
        if (cs != null && (csIndex = writer.getCoordinateSystemCache().getIndex(cs)) < 0) {
            throw new IOException("CoordinateSystem " + cs + " not cached");
        }
        int[] unitsIndex = null;
        if (units != null) {
            unitsIndex = BinaryUnit.lookupList(writer.getUnitCache(), units);
        }
        int[] errorsIndex = null;
        if (errors != null) {
            errorsIndex = BinaryErrorEstimate.lookupList(writer.getErrorEstimateCache(), errors);
        }
        int objLen = BinaryProductSet.computeBytes(sets, cs, units, errors);
        DataOutput file = writer.getOutput();
        file.writeByte(2);
        file.writeInt(objLen);
        file.writeByte(38);
        file.writeInt(typeIndex);
        BinarySampledSet.writeList(writer, sets, token);
        if (csIndex >= 0) {
            file.writeByte(32);
            file.writeInt(csIndex);
        }
        if (unitsIndex != null) {
            file.writeByte(40);
            BinaryIntegerArray.write(writer, unitsIndex, token);
        }
        if (errorsIndex != null) {
            file.writeByte(41);
            BinaryIntegerArray.write(writer, errorsIndex, token);
        }
        file.writeByte(80);
    }
}

