[![Dev](https://img.shields.io/badge/docs-dev-blue.svg)](https://flintlib.org/doc/#)
[![CI](https://github.com/flintlib/flint/actions/workflows/CI.yml/badge.svg)](https://github.com/flintlib/flint/actions/workflows/CI.yml)
[![codecov](https://codecov.io/gh/flintlib/flint/graph/badge.svg?token=qKHycWTpUP)](https://codecov.io/gh/flintlib/flint)

# FLINT (Fast Library for Number Theory)

Website: https://flintlib.org

Mailing list: https://groups.google.com/g/flint-devel

## Overview

FLINT is a C library in support of computations in number theory.
It's also a research project into algorithms in number theory.
FLINT consists mainly of fast scalar and polynomial 
arithmetic, factorization and linear algebra over many basic rings
(integers, rationals, reals, finite fields, number
fields, p-adics).
It includes some higher-level functionality for
algebraic and analytic number theory.

FLINT 2.0, released in 2011 was a complete rewrite of FLINT 1.x from scratch.
FLINT 3, currently in development, incorporates
the [Arb](https://arblib.org/), [Antic](https://github.com/flintlib/antic),
[Calcium](https://fredrikj.net/calcium/)
and [Generic-Rings](https://github.com/fredrik-johansson/generic-rings)
libraries, formerly developed separately.

## Documentation

FLINT's online documentation: https://flintlib.org/doc/

## Authors

FLINT was started in 2007 by [David Harvey](https://web.maths.unsw.edu.au/~davidharvey/)
and [William Hart](https://www.dpmms.cam.ac.uk/person/wh369).
Later maintenance of the library was taken over solely by
William Hart. Since 2022, FLINT is maintained by
[Fredrik Johansson](https://fredrikj.net/).

A large number of authors have contributed to FLINT.
For a complete list, see: https://flintlib.org/authors.html

## License

FLINT is distributed under LGPL 2.1 (GNU Lesser General Public License).
See the LICENSE file.

