// Copyright 2007 "Gilles Degottex"

// This file is part of "CppAddons"

// "CppAddons" is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation; either version 2.1 of the License, or
// (at your option) any later version.
//
// "CppAddons" is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _polar_h_
#define _polar_h_

#include <cmath>
#include <complex>

#undef min
#undef max

namespace Math
{
	template<typename Type>
	struct polar
	{
		Type mod;
		Type arg;

		polar(Type m, Type a) : mod(m), arg(a) {}

		polar(const std::complex<Type>& c){*this=c;}
		polar(){}

		polar<Type>& operator = (const std::complex<Type>& c){mod = sqrt(std::norm(c)); arg = std::arg(c); return *this;}
	};

	//! convert cartesian coordinates to polar coordinates
// 	inline pair<double, double> cart2pol(double x, double y)
// 	{
// 		double m = sqrt(x*x+y*y);
//
// 		if(m == 0.0)	return make_pair(m, 0.0);
//
// 		double a = acos(x/m);
//
// 		if(y < 0.0)		return make_pair(m, -a);
//
// 		return make_pair(m, a);
// 	}

	template<typename Type>	std::complex<Type> make_complex(const polar<Type>& p){return std::complex<Type>(p.mod*cos(p.arg), p.mod*sin(p.arg));}
}

#endif
