## Help make Font Custom better!

This project was born out of an overheard conversation between two devs in a
NYC coffee shop — it's come a long ways thanks to your support. Here's what's
on the menu:

* **Ruby on Rails integration**
* **Compass integration**
* Templates for LESS, stylus, etc.
* Ligature support
* Windows support
* Make better use of Thor

Just [file an issue](https://github.com/FontCustom/fontcustom/issues) if you
have an idea or would like to claim one.

### Rules of Thumb

If you catch a typo or a block of code that could be more elegant — please let
us know. No such thing as too small of an improvement.

* Spaces instead of tabs, please.
* Develop in a topic branch.
* Include passing tests if applicable.
* Follow the [Github ruby styleguide](https://github.com/styleguide/ruby) as
  much as possible.

### Getting Started

You'll need:

* Fontforge with Python scripting (easiest via [Homebrew](http://brew.sh/) on Mac)
* Ruby 1.9.3+ (via [rbenv](https://github.com/sstephenson/rbenv), [RVM](https://rvm.io/), etc.)
* Rubygems
  * Bundler
  * Rake
  * Rspec

Some helpful links:

* http://createdbypete.com/articles/ruby-on-rails-development-with-mac-os-x-mountain-lion/
* http://guides.rubygems.org/make-your-own-gem/

---

That's all there is to it. Thanks again, and please don't hesitate to reach out:

[Github Issues](https://github.com/FontCustom/fontcustom/issues)<br>
[@kaizau](https://twitter.com/kaizau)<br>
[@endtwist](https://twitter.com/endtwist)
