# Πρόγραμμα Εκμάθησης #

Πλήρης τεκμηρίωση των μεθόδων:  [`fpdf.FPDF` API doc](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF)

[TOC]

## Μάθημα 1 - Απλό Παράδειγμα ##

Ας ξεκινήσουμε με ένα κλασσικό παράδειγμα:

```python
{% include "../tutorial/tuto1.py" %}
```

[Παραγόμενο PDF](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto1.pdf)

Αφού συμπεριλάβουμε το αρχείο βιβλιοθήκης, δημιουργούμε ένα αντικείμενο `FPDF`. Ο κατασκευαστής [FPDF](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF) χρησιμοποιείται στην προκειμένη περίπτωση με τις προκαθορισμένες τιμές: οι σελίδες έχουν διαστάσεις Α4 και η μονάδας μέτρησης είναι το χιλιοστόμετρο. Οι συγκεκριμένες τιμές μπορούν να προσδιοριστούν αναλυτικά ως εξής:

```python
pdf = FPDF(orientation="P", unit="mm", format="A4")
```

Δίνεται η δυνατότητα να ορίσουμε το PDF σε λειτουργία τοπίου (`L`) ή να χρησιμοποιήσουμε άλλες μορφοποιήσεις σελίδας (όπως `Letter` και `Legal`) και μονάδες μέτρησης (`pt`, `cm`, `in`).

Προς το παρόν δεν υπάρχει σελίδα, οπότε θα προσθέσουμε μία με την μέθοδο [add_page](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.add_page). Η αρχή βρίσκεται στην αριστερή άνω γωνία και η τρέχουσα θέση τοποθετείται, από προεπιλογή, σε απόσταση 1 cm από το περίγραμμα. Τα περιθώρια μπορούν να οριστούν με [set_margins](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_margins).

Πρωτού μπορέσουμε να εκτυπώσουμε κείμενο, είναι υποχρεωτικό να επιλέξουμε γραμματοσειρά με [set_font](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_font), αλλιώς το αρχείο δεν θα είναι έγκυρο. Επιλέγουμε τη γραμματοσειρά Helvetica bold 16:

```python
pdf.set_font('Helvetica', style='B', size=16)
```

Μπορούμε να επιλέξουμε πλάγια γραφή με `I`, υπογράμμιση με `U` η μία απλή γραμματοσειρά με μία κενή συμβολοσειρά (ή οποιονδήποτε συνδιασμό). Αξίζει να σημειωθεί ότι το μέγεθος της γραμματοσειράς δίνεται σε σημεία, όχι χιλιοστόμετρα (ή κάποια άλλη μονάδα μέτρησης). Το παραπάνω αποτελεί τη μοναδική εξαίρεση. Οι υπόλοιπες ενσωματωμένες γραμματοσείρες είναι `Times`, `Courier`, `Symbol` and `ZapfDingbats`.

Πλέον, μπορούμε να εκτυπώσουμε ένα κελί [cell](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.cell). Ένα κελί αποτελεί μία ορθογώνια επιφάνεια, πιθανώς πλαισιωμένη, η οποία περιέχει κείμενο. Απεικονίζεται στην τρέχουσα θέση. Ορίζουμε τις διαστάσεις της, το κείμενό της (κεντραρισμένο ή ευθυγραμμισμένο), εάν επιθυμούμε εμφάνιση του περιγράμματος, και που θα μετακινηθεί η τρέχουσα θέση μετά από αυτή (στα δεξιά της ορθογώνιας επιφάνειας, από κάτω της ή στην αφετηρία της επόμενης γραμμής). Μπορούμε να προσθέσουμε ένα πλαίσιο ως εξής:

```python
pdf.cell(40, 10, 'Hello World!', 1)
```

Για να προσθέσουμε ένα νέο κελί δίπλα στο αρχικό με κεντραρισμένο κείμενο και στη συνέχεια να μεταβούμε στην επόμενη γραμμή, χρησιμοποιούμε:

```python
pdf.cell(60, 10, 'Powered by FPDF.', new_x="LMARGIN", new_y="NEXT", align='C')
```

**Παρατήρηση**: η αλλαγή γραμμής μπορεί να πραγματοποιηθεί και με  [ln](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.ln). Αυτή η μέθοδος επιτρέπει επίσης τον προσδιορισμό του ύψους της αλλαγής γραμμής.

Εν τέλει, το αρχείο μας είναι κλειστό και έχει αποθηκευτεί στην παρεχόμενη διαδρομή αρχείου χρησιμοποιώντας [output](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.output). Αν δεν παρέχουμε παραμέτρους, η μέθοδος `output()` επιστρέφει το αρχείο PDF σε μορφή `bytearray`.

## Μάθημα 2 - Επικεφαλίδα, υποσέλιδο, αλλαγή σελίδας και εικόνα ##

Παρακάτω, παρουσιάζεται ένα παράδειγμα με τη χρήση επικεφαλίδας, υποσέλιδου και λογότυπου:

```python
{% include "../tutorial/tuto2.py" %}
```

[Παραγόμενο PDF](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto2.pdf)

Στο συγκεκριμένο παράδειγμα γίνεται χρήση των μεθόδων [header](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.header) και 
[footer](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.footer) έτσι ώστε να επεξεργαστούμε τις επικεφαλίδες και τα υποσέλιδα των σελίδων ενός αρχείου. Η κλήση τους γίνεται αυτόματα. Υπάρχουν ήδη στην κλάση FPDF αλλά δεν προσφέρουν καμία λειτουργία, επομένως χρειάζεται να επεκτείνουμε την κλάση και να τις υπερκαλύψουμε.

Το λογότυπο εκτυπώνεται με την μέθοδο [image](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.image) διευκρινίζοντας την αριστερή άνω γωνία και το πλάτος του. Το ύψος της υπολογίζεται αυτόματα λαμβάνοντας υπόψη τις αναλογίες της εικόνας.

Για να εκτυπώσουμε τον αριθμό της σελίδας, χρειάζεται να περάσουμε την μηδενική τιμή στην παράμετρο του πλάτους κελιού. Αυτό σημαίνει ότι το κελί θα επεκταθεί μέχρι και το δεξί περιθώριο της σελίδας, το οποίο βολεύει στο κεντράρισμα του κειμένου. Ο αριθμός της τωρινής σελίδας παρέχεται από την μέθοδο [page_no](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.page_no). Ο συνολικός αριθμός σελίδων του κειμένου είναι διαθέσιμος μέσω της ειδικής μεταβλητής `{nb}`, η οποία ορίζεται με το κλείσιμο του αρχείου. Αυτή η ειδική τιμή μπορεί να τροποποιηθεί μέσω της μεθόδου [alias_nb_pages()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.alias_nb_pages). Αξίζει να σημειωθεί ότι η μέθοδος [set_y](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_y) επιτρέπει τον ορισμό της τρέχουσας θέσης σε οποιαδήποτε τοποθεσία στη σελίδα, ξεκινώντας από την κορυφή ή το τέλος της σελίδας.

Ένα ακόμη ενδιαφέρον χαρακτηριστικό παρουσιάζεται στην συγκεκριμένη περίπτωση: η αυτόματη αλλαγή σελίδας. Μόλις ένα κελί ξεπεράσει ένα προκαθορισμένο όριο στη σελίδα (2 εκατοστά από το κάτω μέρος της σελίδας εξ ορισμού), πραγματοποιείται αλλαγή γραμμής και η γραμματοσειρά επαναφέρεται. Παρόλο που η επικεφαλίδα και το υποσέλιδο επιλέγουν την δικιά τους γραμματοσειρά (`helvetica`), το κύριο τμήμα του κειμένου συνεχίζει με τη γραμματοσειρά `Times`. Αυτός ο μηχανισμός της αυτόματης επαναφοράς εφαρμόζεται επιπλέον στο χρώμα και στο πλάτος γραμμής. Το όριο που προκαλεί την αλλαγή σελίδας μπορεί να οριστεί μέσω της μεθόδου [set_auto_page_break](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_auto_page_break).


## Μάθημα 3 - Αλλαγές γραμμής και χρώματα ##

Ας συνεχίσουμε με ένα παράδειγμα το οποίο εκτυπώνει ευθυγραμμισμένες παραγράφους. Επίσης επεξηγεί τη χρήση χρωμάτων.

```python
{% include "../tutorial/tuto3.py" %}
```

[Παραγόμενο PDF](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto3.pdf)

[Κείμενο του Jules Verne](https://github.com/py-pdf/fpdf2/raw/master/tutorial/20k_c1.txt)

Η μέθοδος [get_string_width](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.get_string_width) επιτρέπει τον καθορισμό του μήκους μίας συμβολοσειράς στην τωρινή γραμματοσειρά, το οποίο χρησιμοποιείται στη συγκεκριμένη περίπτωση για τον υπολογισμό της θέσης και του πλάτους του πλαισίου που περιβάλλει τον τίτλο. Έπειτα ορίζονται τα χρώματα
(μέσω [set_draw_color](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_draw_color),   [set_fill_color](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_fill_color) και 
[set_text_color](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_text_color)) και το πάχος της γραμμής ορίζεται ως 1 χιλιοστόμετρο (αντιθέτως της προκαθορισμένης τιμής 0.2) μέσω της μεθόδου [set_line_width](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_line_width). Τελικά, εκτυπώνουμε το κελί (η τελευταία παράμετρος ίση με true υποδηλώνει την κάλυψη του υπόβαθρου).

Για την εκτύπωση των παραγράφων χρησιμοποιήσαμε την μέθοδο [multi_cell](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.multi_cell). Το κείμενο ευθυγραμμίζεται αυτόματα. Κάθε φορά που μία γραμμή φτάνει στην ακραία δεξιά θέση του κελιού ή συναντάται χαρακτήρας επιστροφής φορέα (`\n`), καλείται αλλαγή γραμμής και ένα νέο κελί δημιουργείται αυτόματα κάτω από το τωρινό. Μία αυτόματη αλλαγή γραμμής πραγματοποιείται στο σημείο με το πλησιέστερο χαρακτήρα κενού ή ενωτικού συλλαβής (`\u00ad`) πριν την ακραία δεξιά θέση. Ένα ενωτικό συλλαβής θα αντικατασταθεί από ένα απλό ενωτικό όταν πραγματοποιείται αλλαγή γραμμής, αλλιώς θα αγνοηθεί.

Ορίζονται δύο ιδιότητες αρχείου: ο τίτλος ([set_title](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_title)) και ο συγγραφέας 
([set_author](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_author)). Οι ιδιότητες μπορούν να προβληθούν με δύο τρόπους. Πρώτον, μπορούμε να ανοίξουμε το αρχείο απευθείας μέσω Acrobat Reader, να κατευθυνθούμε στο Μενού Αρχείων και να επιλέξουμε την επιλογή Ιδιότητες Αρχείου. Δεύτερον, μπορούμε απευθείας να κάνουμε δεξί κλικ στο εικονίδιο αρχείου και να επιλέξουμε τις Ιδιότητες Αρχείου.

## Μάθημα 4 - Πολλαπλές Στήλες ##

Αυτό το παράδειγμα αποτελεί μία παραλλαγή του προηγούμενου και μας παρουσιάζει πως να κατανέμουμε το κείμενό μας σε πολλαπλές στήλες.

```python
{% include "../tutorial/tuto4.py" %}
```

[Παραγόμενο PDF](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto4.pdf)

[Κείμενο του Jules Verne](https://github.com/py-pdf/fpdf2/raw/master/tutorial/20k_c1.txt)

_⚠️ This section has changed a lot and requires a new translation: <https://github.com/py-pdf/fpdf2/issues/267>_

English versions:

* [Tuto 4 - Multi Columns](https://py-pdf.github.io/fpdf2/Tutorial.html#tuto-4-multi-columns)
* [Documentation on TextColumns](https://py-pdf.github.io/fpdf2/TextColumns.html


## Μάθημα 5 - Δημιουργία Πινάκων ##

```python
{% include "../tutorial/tuto5.py" %}
```

[Παραγόμενο PDF](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto5.pdf) -
[Κείμενο Χωρών](https://github.com/py-pdf/fpdf2/raw/master/tutorial/countries.txt)

_⚠️ This section has changed a lot and requires a new translation: <https://github.com/py-pdf/fpdf2/issues/267>_

English versions:

* [Tuto 5 - Creating Tables](https://py-pdf.github.io/fpdf2/Tutorial.html#tuto-5-creating-tables)
* [Documentation on tables](https://py-pdf.github.io/fpdf2/Tables.html)

## Μάθημα 6 - Δημιουργία συνδέσμων και μίξη στυλ κειμένου ##

Σε αυτό το μάθημα θα εξηγήσουμε πολλαπλούς τρόπους εισαγωγής εσωτερικών αλλα και εξωτερικών συνδέσμων σε ένα αρχείο pdf.

Θα αναλύσουμε επίσης πως μπορούμε να χρησιμοποιήσουμε διάφορα στυλ κειμένου (έντονη γραφή, πλάγια γραφή, υπογράμμιση) εντός του ίδιου κειμένου.

```python
{% include "../tutorial/tuto6.py" %}
```

[Παραγόμενο PDF](https://github.com/py-pdf/fpdf2/raw/master/tutorial/tuto6.pdf) -
[fpdf2-logo](https://raw.githubusercontent.com/py-pdf/fpdf2/master/docs/fpdf2-logo.png)

Παρατηρούμε μία νέα μέθοδο για την εκτύπωση κειμένου, την
 [write()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.write)
. Η μέθοδος αυτή, θυμίζει αρκετά την
 [multi_cell()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.multi_cell)
 , παρόλα αυτά εμφανίζει τις εξής διαφορές:

- Το τέλος της γραμμής βρίσκεται στο δεξί περιθώριο και η επόμενη γραμμή ξεκινάει στο αριστερό περιθώριο.
- Η τρέχουσα θέση μετακινείται στο τέλος του κειμένου.

Αυτή η μέθοδος, επομένως μας επιτρέπει να γράψουμε ένα κομμάτι κειμένου, να αλλάξουμε τη γραμματοσειρά, και να συνεχίσουμε ακριβώς στο σημείο που είχαμε απομείνει. Από την άλλη πλευρά, το βασικό της μειονέκτημα είναι ότι δεν μπορούμε να ευθυγραμμίσουμε το κείμενο όπως με την μέθοδο [multi_cell()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.multi_cell).

Στην πρώτη σελίδα του παραδείγματος χρησιμοποιήσαμε την μέθοδο [write()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.write) για αυτό το σκοπό. Το πρώτο κομμάτι της πρότασης είναι γραμμένο ως απλό κείμενο, ενώ στη συνέχεια, αφού χρησιμοποιήσαμε την μέθοδο [set_font()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.set_font), αλλάξαμε το στυλ κειμένου σε υπογράμμιση και κλείσαμε την πρόταση.

Για να προσθέσουμε έναν εσωτερικό σύνδεσμο ο οποίος θα κατευθύνει στην επόμενη σελίδα, χρησιμοποιήσαμε την μέθοδο 
 [add_link()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.add_link), η οποία δημιουργεί μία επιφανεία με όνομα "link". Αν κλικάρουμε την επιφάνεια αυτή μεταφερόμαστε σε μία άλλη τοποθεσία του αρχείου.

Για να δημιουργήσουμε έναν εξωτερικό σύνδεσμο μέσω μιας εικόνας, θα χρησιμοποιήσουμε την μέθοδο [image()](https://py-pdf.github.io/fpdf2/fpdf/fpdf.html#fpdf.fpdf.FPDF.image). Αυτή η μέθοδος μας δίνει την επιλογή να περάσουμε έναν σύνδεσμο ως τιμή σε μία από τις παραμέτρους της. Ο σύνδεσμος μπορεί να είναι εσωτερικός ή εξωτερικός.

Εναλλακτικά, μία ακόμη επιλογή για να αλλάξουμε το στυλ κειμένου και να προσθέσουμε συνδέσμους είναι η χρήση της μεθόδου  `write_html()`. Η μέθοδος αυτή, αποτελεί έναν αναλυτή html ο οποίος επιτρέπει την προσθήκη κειμένου, την αλλαγή γραμματοσειράς και την προσθήκη συνδέσμων με την χρήση της html.

