<!----------------------------------------------------------------------------------->
<!--- This file is part of FreeFEM.                                               --->
<!--- Laboratoire Jacques-Louis Lions                                             --->
<!--- Sorbonne Université, UMR 7598, Paris, F-75005 France                        --->
<!---                                                                             --->
<!--- FreeFEM is free software: you can redistribute it and/or modify             --->
<!--- it under the terms of the GNU Lesser General Public License as published by --->
<!--- the Free Software Foundation, either version 3 of the License, or           --->
<!--- (at your option) any later version.                                         --->
<!---                                                                             --->
<!--- FreeFEM is distributed in the hope that it will be useful,                  --->
<!--- but WITHOUT ANY WARRANTY; without even the implied warranty of              --->
<!--- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               --->
<!--- GNU Lesser General Public License for more details.                         --->
<!---                                                                             --->
<!--- You should have received a copy of the GNU Lesser General Public License    --->
<!--- along with FreeFEM.  If not, see <http://www.gnu.org/licenses/>.            --->
<!----------------------------------------------------------------------------------->


# Using git for FreeFem++ source files management
_april 2018_

The main difference with the previous CVS setup or mercurial is that every working
copy of FreeFem++ contains a complete git database of all source files
(in a subdirectory called `.git`).

See [git - the simple guide](http://rogerdudler.github.io/git-guide/).

## Create a local copy of the FreeFem++ repository

### From the web in directory ff-git

```
git clone https://github.com/FreeFem/FreeFem-sources ff-git
```

## Create the ~/.gitconfig file for commit like:

Change to your own name:

```[user]
	name = Frederic Hecht
	email = frederic.hecht@upmc.fr
[push]
	default = simple
```

## Working with a repository

All the commands below should be run from a directory of the current
working copy.

### Adding a file

```git add filename
```

### Deleting a file

```git rm filename
```

### Deleting a file only from the Git repository

```git rm --cached filename```

### Commiting all local changes to the local repository

```git commit -a -m "description of changes"```

### Checking if there are some uncommitted local changes

```git status```

## Expanding changes with other repositories

** Pulling changes from another (readable) repository

### Pushing changes into another (writable) repository branch

```git push origin master```
Change master to whatever branch you want to push your changes to.

### Connect your repository to a remote server

```git remote add origin <server>```

### Create a new branch named `feature_x` and switch to it using

```git checkout -b feature_x```

### Switch back to master

```git checkout master```

### Delete the `feature_x` branch

```git branch -d feature_x```

### A branch is not available to others unless you push the branch

```git push origin <branch>```

## External developers

Developers that are not part of the official FreeFem++ team can fork
the FreeFem-sources repository on their GitHub account, make modifications
locally and submit a pull request to the FreeFem-sources repository.

# Compile FreeFem++

First to restore build file:

 * use `automake` (>1.13)
	```	autoreconf -i```
 * or extract build file using
	```	tar zxvf AutoGeneratedFile.tar.gz```

Build the Makefile:
```./configure --enable-download```

Optionnaly, compile PETSc/SLEPc if needed (more than 30 min):

```cd 3rdparty/ff-petsc
make petsc-slepc [SUDO=sudo]
./reconfigure```

Build:
```make```

Check (warning some tests fail):
```make check```

Install:```sudo make install```
or
```make install```
