/*
 * Copyright (C) 2023 Chris Talbot
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <adwaita.h>
#include <shumate/shumate.h>

G_BEGIN_DECLS

#define GEOCLUE_STUMBLER_TYPE_MAPS_PAGE (geoclue_stumbler_maps_page_get_type())
G_DECLARE_FINAL_TYPE (GeoclueStumblerMapsPage, geoclue_stumbler_maps_page, GEOCLUE_STUMBLER, MAPS_PAGE, AdwBin)

void geoclue_stumbler_maps_page_set_subission_marker (GeoclueStumblerMapsPage *self,
                                                      double lat,
                                                      double lng,
                                                      const char *time_str,
                                                      unsigned int wifi_aps,
                                                      unsigned int cell_towers);

void  geoclue_stumbler_maps_page_update_marker (GeoclueStumblerMapsPage *self,
                                                double lat,
                                                double lng,
                                                double heading);

double maps_page_adjust_heading (ShumateLocation *prev_location,
                                 double lat,
                                 double lng);

void
geoclue_stumbler_maps_page_reset_path (GeoclueStumblerMapsPage *self);

void
geoclue_stumbler_maps_page_reset_submission_markers (GeoclueStumblerMapsPage *self);

void
geoclue_stumbler_maps_page_set_path_page (GeoclueStumblerMapsPage *self,
                                          GtkWidget               *path_page_bin);

void
geoclue_stumbler_maps_page_update_marker_no_fix (GeoclueStumblerMapsPage *self,
                                                 double lat,
                                                 double lng,
                                                 double accuracy_in_meters);

G_END_DECLS
