#"
# Copyright (C) 2005, 2006, 2007, 2009, 2010 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#!/bin/sh -x


if [ -z "$3" ]; then
	echo "Usage: `basename %0` <gnash_builddir> <gnash_srcdir> <swfdec_tracedir> [<startingcharacters>]" >&2
	exit 1
fi

BUILDDIR="$1"
SRCDIR="$2"
SWFDECTRACEDIR="$3"
STARTPATTERN="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
if [ -n "$4" ]; then
	STARTPATTERN="$4"
fi
NOW=`date`
if [ -x /bin/md5 ]; then
	MD5="md5"
	CUT="4"
else
	MD5="md5sum"
	CUT="1"
fi

GPROCESSOR="${BUILDDIR}/utilities/gprocessor"
GNASHRC="${BUILDDIR}/testsuite/gnashrc"
GNASH_PLAYER="${BUILDDIR}/gui/gnash"
SWFDEC_GNASH_TESTER="${SRCDIR}/swfdec_gnash_tester"

cat<<EOF 
#!/bin/sh

# Generated by gen_run_swfdec_testsuite.sh on
# $NOW

# The trace output of the Date object in the testsuite has timezone as GMT.
export TZ=GMT
export GNASHRC=${GNASHRC}
export GPROCESSOR=${GPROCESSOR}
EXPECTPASS=${SRCDIR}/PASSING
REALTIME=${SRCDIR}/REALTIME

for test in \`ls ${SWFDECTRACEDIR}/[$STARTPATTERN]*.swf\`; do
	testname=\`basename \${test}\`
	md5=\`$MD5 \${test} | cut -d' ' -f$CUT\`
	testid="\${testname}:\${md5}"

	if [ -f \${test}.act ]; then
		echo "NOTE: skipping \${testname} (unsupported user interaction)"
		echo "UNTESTED: \${testid} (requires unsupported user interaction)"
		continue
	fi

	usedtopass=no
	expectpass=no
	expectpasslabel=no
	if grep -q "^\${testid}\$" \${EXPECTPASS}; then
		expectpass="yes"
		expectpasslabel=yes
	else
		if grep -q "^\${testname}:" \${EXPECTPASS}; then
			usedtopass="yes"
			expectpasslabel="not anymore"
		else
			expectpasslabel=no
		fi
	fi
	flags=
	if grep -q "^\${testname}\$" \${REALTIME}; then
		flags="-d -1"
		echo "NOTE: running \${testname} (realtime - expect pass: \${expectpasslabel})"
	else
		echo "NOTE: running \${testname} (expect pass: \${expectpasslabel})"
	fi

	${SWFDEC_GNASH_TESTER} \${test} \${flags} > \${testname}.log
	ret=\$?
	#echo "NOTE: ${SWFDEC_GNASH_TESTER} \${test} returned \$ret"
	if [ \$ret -eq 0 ]; then
		if [ "\${expectpass}" = "yes" ]; then
			echo "PASSED: \${testid}"
		else
			echo "XPASSED: \${testid}"
		fi	
	elif [ \$ret -eq 1 ]; then
			if [ "\${expectpass}" = "yes" ]; then
				echo "FAILED: \${testid} (traces in \${testname}.trace-gnash, log in \${testname}.log)"
			else
				if [ "\${usedtopass}" = "yes" ]; then
					echo "XFAILED: \${testid} (USED TO PASS! traces in \${testname}.trace-gnash, log in \${testname}.log)"
				else
					echo "XFAILED: \${testid} (traces in \${testname}.trace-gnash, log in \${testname}.log)"
				fi
			fi
	else
		echo "FAILED: \${testid} crashed gnash (stdout in \${testname}.out, stderr in \${testname}.err)"
	fi
done

EOF

