/* ide-vala-locator.c generated by valac 0.30.0, the Vala compiler
 * generated from ide-vala-locator.vala, do not modify */

/*
 * Copyright (C) 2008 Abderrahim Kitouni
 * Copyright (C) 2015 Christian Hergert <christian@hergert.me>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* Finds the innermost block containing the given location */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <string.h>


#define IDE_TYPE_VALA_LOCATOR (ide_vala_locator_get_type ())
#define IDE_VALA_LOCATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IDE_TYPE_VALA_LOCATOR, IdeValaLocator))
#define IDE_VALA_LOCATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IDE_TYPE_VALA_LOCATOR, IdeValaLocatorClass))
#define IDE_IS_VALA_LOCATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IDE_TYPE_VALA_LOCATOR))
#define IDE_IS_VALA_LOCATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IDE_TYPE_VALA_LOCATOR))
#define IDE_VALA_LOCATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IDE_TYPE_VALA_LOCATOR, IdeValaLocatorClass))

typedef struct _IdeValaLocator IdeValaLocator;
typedef struct _IdeValaLocatorClass IdeValaLocatorClass;
typedef struct _IdeValaLocatorPrivate IdeValaLocatorPrivate;

#define IDE_VALA_LOCATOR_TYPE_LOCATION (ide_vala_locator_location_get_type ())
typedef struct _IdeValaLocatorLocation IdeValaLocatorLocation;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _IdeValaLocator {
	ValaCodeVisitor parent_instance;
	IdeValaLocatorPrivate * priv;
};

struct _IdeValaLocatorClass {
	ValaCodeVisitorClass parent_class;
};

struct _IdeValaLocatorLocation {
	gint line;
	gint column;
};

struct _IdeValaLocatorPrivate {
	IdeValaLocatorLocation location;
	ValaSymbol* innermost;
	IdeValaLocatorLocation innermost_begin;
	IdeValaLocatorLocation innermost_end;
};


static gpointer ide_vala_locator_parent_class = NULL;
static GType ide_vala_locator_type_id = 0;

GType ide_vala_locator_get_type (void) G_GNUC_CONST;
GType ide_vala_locator_register_type (GTypeModule * module);
static GType ide_vala_locator_location_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static IdeValaLocatorLocation* ide_vala_locator_location_dup (const IdeValaLocatorLocation* self);
static void ide_vala_locator_location_free (IdeValaLocatorLocation* self);
#define IDE_VALA_LOCATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), IDE_TYPE_VALA_LOCATOR, IdeValaLocatorPrivate))
enum  {
	IDE_VALA_LOCATOR_DUMMY_PROPERTY
};
ValaSymbol* ide_vala_locator_locate (IdeValaLocator* self, ValaSourceFile* file, gint line, gint column);
static void ide_vala_locator_location_init (IdeValaLocatorLocation *self, gint line, gint column);
static gboolean ide_vala_locator_update_location (IdeValaLocator* self, ValaSymbol* s);
static gboolean ide_vala_locator_location_inside (IdeValaLocatorLocation *self, ValaSourceReference* src);
static gboolean ide_vala_locator_location_before (IdeValaLocatorLocation *self, IdeValaLocatorLocation* other);
static void ide_vala_locator_real_visit_block (ValaCodeVisitor* base, ValaBlock* b);
static void ide_vala_locator_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void ide_vala_locator_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void ide_vala_locator_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void ide_vala_locator_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void ide_vala_locator_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static void ide_vala_locator_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static void ide_vala_locator_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void ide_vala_locator_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc);
static void ide_vala_locator_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c);
static void ide_vala_locator_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d);
static void ide_vala_locator_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt);
static void ide_vala_locator_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt);
static void ide_vala_locator_real_visit_switch_section (ValaCodeVisitor* base, ValaSwitchSection* section);
static void ide_vala_locator_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt);
static void ide_vala_locator_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt);
static void ide_vala_locator_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt);
static void ide_vala_locator_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt);
static void ide_vala_locator_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt);
static void ide_vala_locator_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause);
static void ide_vala_locator_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt);
static void ide_vala_locator_real_visit_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* expr);
IdeValaLocator* ide_vala_locator_new (void);
IdeValaLocator* ide_vala_locator_construct (GType object_type);
static void ide_vala_locator_finalize (ValaCodeVisitor* obj);


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


ValaSymbol* ide_vala_locator_locate (IdeValaLocator* self, ValaSourceFile* file, gint line, gint column) {
	ValaSymbol* result = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	ValaSourceFile* _tmp2_ = NULL;
	ValaSymbol* _tmp3_ = NULL;
	ValaSymbol* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = line;
	_tmp1_ = column;
	ide_vala_locator_location_init (&self->priv->location, _tmp0_, _tmp1_);
	_vala_code_node_unref0 (self->priv->innermost);
	self->priv->innermost = NULL;
	_tmp2_ = file;
	vala_source_file_accept_children (_tmp2_, (ValaCodeVisitor*) self);
	_tmp3_ = self->priv->innermost;
	_tmp4_ = _vala_code_node_ref0 (_tmp3_);
	result = _tmp4_;
	return result;
}


static gboolean ide_vala_locator_update_location (IdeValaLocator* self, ValaSymbol* s) {
	gboolean result = FALSE;
	ValaSymbol* _tmp0_ = NULL;
	ValaSourceReference* _tmp1_ = NULL;
	ValaSourceReference* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	IdeValaLocatorLocation begin = {0};
	ValaSymbol* _tmp4_ = NULL;
	ValaSourceReference* _tmp5_ = NULL;
	ValaSourceReference* _tmp6_ = NULL;
	ValaSourceLocation _tmp7_ = {0};
	ValaSourceLocation _tmp8_ = {0};
	gint _tmp9_ = 0;
	ValaSymbol* _tmp10_ = NULL;
	ValaSourceReference* _tmp11_ = NULL;
	ValaSourceReference* _tmp12_ = NULL;
	ValaSourceLocation _tmp13_ = {0};
	ValaSourceLocation _tmp14_ = {0};
	gint _tmp15_ = 0;
	IdeValaLocatorLocation end = {0};
	ValaSymbol* _tmp16_ = NULL;
	ValaSourceReference* _tmp17_ = NULL;
	ValaSourceReference* _tmp18_ = NULL;
	ValaSourceLocation _tmp19_ = {0};
	ValaSourceLocation _tmp20_ = {0};
	gint _tmp21_ = 0;
	ValaSymbol* _tmp22_ = NULL;
	ValaSourceReference* _tmp23_ = NULL;
	ValaSourceReference* _tmp24_ = NULL;
	ValaSourceLocation _tmp25_ = {0};
	ValaSourceLocation _tmp26_ = {0};
	gint _tmp27_ = 0;
	gboolean _tmp28_ = FALSE;
	ValaSymbol* _tmp29_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (s != NULL, FALSE);
	_tmp0_ = s;
	_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = ide_vala_locator_location_inside (&self->priv->location, _tmp2_);
	if (!_tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = s;
	_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp4_);
	_tmp6_ = _tmp5_;
	vala_source_reference_get_begin (_tmp6_, &_tmp7_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_.line;
	_tmp10_ = s;
	_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp10_);
	_tmp12_ = _tmp11_;
	vala_source_reference_get_begin (_tmp12_, &_tmp13_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_.column;
	ide_vala_locator_location_init (&begin, _tmp9_, _tmp15_);
	_tmp16_ = s;
	_tmp17_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp16_);
	_tmp18_ = _tmp17_;
	vala_source_reference_get_end (_tmp18_, &_tmp19_);
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp20_.line;
	_tmp22_ = s;
	_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp22_);
	_tmp24_ = _tmp23_;
	vala_source_reference_get_end (_tmp24_, &_tmp25_);
	_tmp26_ = _tmp25_;
	_tmp27_ = _tmp26_.column;
	ide_vala_locator_location_init (&end, _tmp21_, _tmp27_);
	_tmp29_ = self->priv->innermost;
	if (_tmp29_ == NULL) {
		_tmp28_ = TRUE;
	} else {
		gboolean _tmp30_ = FALSE;
		IdeValaLocatorLocation _tmp31_ = {0};
		gboolean _tmp32_ = FALSE;
		_tmp31_ = begin;
		_tmp32_ = ide_vala_locator_location_before (&self->priv->innermost_begin, &_tmp31_);
		if (_tmp32_) {
			IdeValaLocatorLocation _tmp33_ = {0};
			gboolean _tmp34_ = FALSE;
			_tmp33_ = self->priv->innermost_end;
			_tmp34_ = ide_vala_locator_location_before (&end, &_tmp33_);
			_tmp30_ = _tmp34_;
		} else {
			_tmp30_ = FALSE;
		}
		_tmp28_ = _tmp30_;
	}
	if (_tmp28_) {
		ValaSymbol* _tmp35_ = NULL;
		ValaSymbol* _tmp36_ = NULL;
		IdeValaLocatorLocation _tmp37_ = {0};
		IdeValaLocatorLocation _tmp38_ = {0};
		_tmp35_ = s;
		_tmp36_ = _vala_code_node_ref0 (_tmp35_);
		_vala_code_node_unref0 (self->priv->innermost);
		self->priv->innermost = _tmp36_;
		_tmp37_ = begin;
		self->priv->innermost_begin = _tmp37_;
		_tmp38_ = end;
		self->priv->innermost_end = _tmp38_;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void ide_vala_locator_real_visit_block (ValaCodeVisitor* base, ValaBlock* b) {
	IdeValaLocator * self;
	ValaBlock* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	self = (IdeValaLocator*) base;
	g_return_if_fail (b != NULL);
	_tmp0_ = b;
	_tmp1_ = ide_vala_locator_update_location (self, (ValaSymbol*) _tmp0_);
	if (_tmp1_) {
		ValaBlock* _tmp2_ = NULL;
		_tmp2_ = b;
		vala_code_node_accept_children ((ValaCodeNode*) _tmp2_, (ValaCodeVisitor*) self);
	}
}


static void ide_vala_locator_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns) {
	IdeValaLocator * self;
	ValaNamespace* _tmp0_ = NULL;
	ValaNamespace* _tmp1_ = NULL;
	self = (IdeValaLocator*) base;
	g_return_if_fail (ns != NULL);
	_tmp0_ = ns;
	ide_vala_locator_update_location (self, (ValaSymbol*) _tmp0_);
	_tmp1_ = ns;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
}


static void ide_vala_locator_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	IdeValaLocator * self;
	ValaClass* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	ValaClass* _tmp2_ = NULL;
	self = (IdeValaLocator*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = cl;
	_tmp1_ = ide_vala_locator_update_location (self, (ValaSymbol*) _tmp0_);
	if (_tmp1_) {
		return;
	}
	_tmp2_ = cl;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp2_, (ValaCodeVisitor*) self);
}


static void ide_vala_locator_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	IdeValaLocator * self;
	ValaStruct* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	ValaStruct* _tmp2_ = NULL;
	self = (IdeValaLocator*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = st;
	_tmp1_ = ide_vala_locator_update_location (self, (ValaSymbol*) _tmp0_);
	if (_tmp1_) {
		return;
	}
	_tmp2_ = st;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp2_, (ValaCodeVisitor*) self);
}


static void ide_vala_locator_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	IdeValaLocator * self;
	ValaInterface* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	ValaInterface* _tmp2_ = NULL;
	self = (IdeValaLocator*) base;
	g_return_if_fail (iface != NULL);
	_tmp0_ = iface;
	_tmp1_ = ide_vala_locator_update_location (self, (ValaSymbol*) _tmp0_);
	if (_tmp1_) {
		return;
	}
	_tmp2_ = iface;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp2_, (ValaCodeVisitor*) self);
}


static void ide_vala_locator_real_visit_method (ValaCodeVisitor* base, ValaMethod* m) {
	IdeValaLocator * self;
	ValaMethod* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	ValaMethod* _tmp2_ = NULL;
	self = (IdeValaLocator*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	_tmp1_ = ide_vala_locator_update_location (self, (ValaSymbol*) _tmp0_);
	if (_tmp1_) {
		return;
	}
	_tmp2_ = m;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp2_, (ValaCodeVisitor*) self);
}


static void ide_vala_locator_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m) {
	IdeValaLocator * self;
	ValaCreationMethod* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	ValaCreationMethod* _tmp2_ = NULL;
	self = (IdeValaLocator*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	_tmp1_ = ide_vala_locator_update_location (self, (ValaSymbol*) _tmp0_);
	if (_tmp1_) {
		return;
	}
	_tmp2_ = m;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp2_, (ValaCodeVisitor*) self);
}


static void ide_vala_locator_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop) {
	IdeValaLocator * self;
	ValaProperty* _tmp0_ = NULL;
	self = (IdeValaLocator*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = prop;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void ide_vala_locator_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc) {
	IdeValaLocator * self;
	ValaPropertyAccessor* _tmp0_ = NULL;
	self = (IdeValaLocator*) base;
	g_return_if_fail (acc != NULL);
	_tmp0_ = acc;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void ide_vala_locator_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c) {
	IdeValaLocator * self;
	ValaConstructor* _tmp0_ = NULL;
	self = (IdeValaLocator*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void ide_vala_locator_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d) {
	IdeValaLocator * self;
	ValaDestructor* _tmp0_ = NULL;
	self = (IdeValaLocator*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = d;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void ide_vala_locator_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt) {
	IdeValaLocator * self;
	ValaIfStatement* _tmp0_ = NULL;
	self = (IdeValaLocator*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void ide_vala_locator_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt) {
	IdeValaLocator * self;
	ValaSwitchStatement* _tmp0_ = NULL;
	self = (IdeValaLocator*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void ide_vala_locator_real_visit_switch_section (ValaCodeVisitor* base, ValaSwitchSection* section) {
	IdeValaLocator * self;
	ValaSwitchSection* _tmp0_ = NULL;
	self = (IdeValaLocator*) base;
	g_return_if_fail (section != NULL);
	_tmp0_ = section;
	vala_code_visitor_visit_block ((ValaCodeVisitor*) self, (ValaBlock*) _tmp0_);
}


static void ide_vala_locator_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt) {
	IdeValaLocator * self;
	ValaWhileStatement* _tmp0_ = NULL;
	self = (IdeValaLocator*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void ide_vala_locator_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt) {
	IdeValaLocator * self;
	ValaDoStatement* _tmp0_ = NULL;
	self = (IdeValaLocator*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void ide_vala_locator_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt) {
	IdeValaLocator * self;
	ValaForStatement* _tmp0_ = NULL;
	self = (IdeValaLocator*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void ide_vala_locator_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt) {
	IdeValaLocator * self;
	ValaForeachStatement* _tmp0_ = NULL;
	self = (IdeValaLocator*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void ide_vala_locator_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt) {
	IdeValaLocator * self;
	ValaTryStatement* _tmp0_ = NULL;
	self = (IdeValaLocator*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void ide_vala_locator_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause) {
	IdeValaLocator * self;
	ValaCatchClause* _tmp0_ = NULL;
	self = (IdeValaLocator*) base;
	g_return_if_fail (clause != NULL);
	_tmp0_ = clause;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void ide_vala_locator_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt) {
	IdeValaLocator * self;
	ValaLockStatement* _tmp0_ = NULL;
	self = (IdeValaLocator*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void ide_vala_locator_real_visit_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* expr) {
	IdeValaLocator * self;
	ValaLambdaExpression* _tmp0_ = NULL;
	self = (IdeValaLocator*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = expr;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


IdeValaLocator* ide_vala_locator_construct (GType object_type) {
	IdeValaLocator* self = NULL;
	self = (IdeValaLocator*) vala_code_visitor_construct (object_type);
	return self;
}


IdeValaLocator* ide_vala_locator_new (void) {
	return ide_vala_locator_construct (IDE_TYPE_VALA_LOCATOR);
}


static void ide_vala_locator_location_init (IdeValaLocatorLocation *self, gint line, gint column) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	memset (self, 0, sizeof (IdeValaLocatorLocation));
	_tmp0_ = line;
	(*self).line = _tmp0_;
	_tmp1_ = column;
	(*self).column = _tmp1_;
}


static gboolean ide_vala_locator_location_inside (IdeValaLocatorLocation *self, ValaSourceReference* src) {
	gboolean result = FALSE;
	IdeValaLocatorLocation begin = {0};
	ValaSourceReference* _tmp0_ = NULL;
	ValaSourceLocation _tmp1_ = {0};
	ValaSourceLocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	ValaSourceReference* _tmp4_ = NULL;
	ValaSourceLocation _tmp5_ = {0};
	ValaSourceLocation _tmp6_ = {0};
	gint _tmp7_ = 0;
	IdeValaLocatorLocation end = {0};
	ValaSourceReference* _tmp8_ = NULL;
	ValaSourceLocation _tmp9_ = {0};
	ValaSourceLocation _tmp10_ = {0};
	gint _tmp11_ = 0;
	ValaSourceReference* _tmp12_ = NULL;
	ValaSourceLocation _tmp13_ = {0};
	ValaSourceLocation _tmp14_ = {0};
	gint _tmp15_ = 0;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	g_return_val_if_fail (src != NULL, FALSE);
	_tmp0_ = src;
	vala_source_reference_get_begin (_tmp0_, &_tmp1_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_.line;
	_tmp4_ = src;
	vala_source_reference_get_begin (_tmp4_, &_tmp5_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_.column;
	ide_vala_locator_location_init (&begin, _tmp3_, _tmp7_);
	_tmp8_ = src;
	vala_source_reference_get_end (_tmp8_, &_tmp9_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_.line;
	_tmp12_ = src;
	vala_source_reference_get_end (_tmp12_, &_tmp13_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_.column;
	ide_vala_locator_location_init (&end, _tmp11_, _tmp15_);
	_tmp17_ = ide_vala_locator_location_before (&begin, &(*self));
	if (_tmp17_) {
		IdeValaLocatorLocation _tmp18_ = {0};
		gboolean _tmp19_ = FALSE;
		_tmp18_ = end;
		_tmp19_ = ide_vala_locator_location_before (&(*self), &_tmp18_);
		_tmp16_ = _tmp19_;
	} else {
		_tmp16_ = FALSE;
	}
	result = _tmp16_;
	return result;
}


static gboolean ide_vala_locator_location_before (IdeValaLocatorLocation *self, IdeValaLocatorLocation* other) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	IdeValaLocatorLocation _tmp1_ = {0};
	gint _tmp2_ = 0;
	g_return_val_if_fail (other != NULL, FALSE);
	_tmp0_ = (*self).line;
	_tmp1_ = *other;
	_tmp2_ = _tmp1_.line;
	if (_tmp0_ > _tmp2_) {
		result = FALSE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gint _tmp4_ = 0;
		IdeValaLocatorLocation _tmp5_ = {0};
		gint _tmp6_ = 0;
		_tmp4_ = (*self).line;
		_tmp5_ = *other;
		_tmp6_ = _tmp5_.line;
		if (_tmp4_ == _tmp6_) {
			gint _tmp7_ = 0;
			IdeValaLocatorLocation _tmp8_ = {0};
			gint _tmp9_ = 0;
			_tmp7_ = (*self).column;
			_tmp8_ = *other;
			_tmp9_ = _tmp8_.column;
			_tmp3_ = _tmp7_ > _tmp9_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


static IdeValaLocatorLocation* ide_vala_locator_location_dup (const IdeValaLocatorLocation* self) {
	IdeValaLocatorLocation* dup;
	dup = g_new0 (IdeValaLocatorLocation, 1);
	memcpy (dup, self, sizeof (IdeValaLocatorLocation));
	return dup;
}


static void ide_vala_locator_location_free (IdeValaLocatorLocation* self) {
	g_free (self);
}


static GType ide_vala_locator_location_get_type (void) {
	static volatile gsize ide_vala_locator_location_type_id__volatile = 0;
	if (g_once_init_enter (&ide_vala_locator_location_type_id__volatile)) {
		GType ide_vala_locator_location_type_id;
		ide_vala_locator_location_type_id = g_boxed_type_register_static ("IdeValaLocatorLocation", (GBoxedCopyFunc) ide_vala_locator_location_dup, (GBoxedFreeFunc) ide_vala_locator_location_free);
		g_once_init_leave (&ide_vala_locator_location_type_id__volatile, ide_vala_locator_location_type_id);
	}
	return ide_vala_locator_location_type_id__volatile;
}


static void ide_vala_locator_class_init (IdeValaLocatorClass * klass) {
	ide_vala_locator_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = ide_vala_locator_finalize;
	g_type_class_add_private (klass, sizeof (IdeValaLocatorPrivate));
	((ValaCodeVisitorClass *) klass)->visit_block = ide_vala_locator_real_visit_block;
	((ValaCodeVisitorClass *) klass)->visit_namespace = ide_vala_locator_real_visit_namespace;
	((ValaCodeVisitorClass *) klass)->visit_class = ide_vala_locator_real_visit_class;
	((ValaCodeVisitorClass *) klass)->visit_struct = ide_vala_locator_real_visit_struct;
	((ValaCodeVisitorClass *) klass)->visit_interface = ide_vala_locator_real_visit_interface;
	((ValaCodeVisitorClass *) klass)->visit_method = ide_vala_locator_real_visit_method;
	((ValaCodeVisitorClass *) klass)->visit_creation_method = ide_vala_locator_real_visit_creation_method;
	((ValaCodeVisitorClass *) klass)->visit_property = ide_vala_locator_real_visit_property;
	((ValaCodeVisitorClass *) klass)->visit_property_accessor = ide_vala_locator_real_visit_property_accessor;
	((ValaCodeVisitorClass *) klass)->visit_constructor = ide_vala_locator_real_visit_constructor;
	((ValaCodeVisitorClass *) klass)->visit_destructor = ide_vala_locator_real_visit_destructor;
	((ValaCodeVisitorClass *) klass)->visit_if_statement = ide_vala_locator_real_visit_if_statement;
	((ValaCodeVisitorClass *) klass)->visit_switch_statement = ide_vala_locator_real_visit_switch_statement;
	((ValaCodeVisitorClass *) klass)->visit_switch_section = ide_vala_locator_real_visit_switch_section;
	((ValaCodeVisitorClass *) klass)->visit_while_statement = ide_vala_locator_real_visit_while_statement;
	((ValaCodeVisitorClass *) klass)->visit_do_statement = ide_vala_locator_real_visit_do_statement;
	((ValaCodeVisitorClass *) klass)->visit_for_statement = ide_vala_locator_real_visit_for_statement;
	((ValaCodeVisitorClass *) klass)->visit_foreach_statement = ide_vala_locator_real_visit_foreach_statement;
	((ValaCodeVisitorClass *) klass)->visit_try_statement = ide_vala_locator_real_visit_try_statement;
	((ValaCodeVisitorClass *) klass)->visit_catch_clause = ide_vala_locator_real_visit_catch_clause;
	((ValaCodeVisitorClass *) klass)->visit_lock_statement = ide_vala_locator_real_visit_lock_statement;
	((ValaCodeVisitorClass *) klass)->visit_lambda_expression = ide_vala_locator_real_visit_lambda_expression;
}


static void ide_vala_locator_instance_init (IdeValaLocator * self) {
	self->priv = IDE_VALA_LOCATOR_GET_PRIVATE (self);
}


static void ide_vala_locator_finalize (ValaCodeVisitor* obj) {
	IdeValaLocator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, IDE_TYPE_VALA_LOCATOR, IdeValaLocator);
	_vala_code_node_unref0 (self->priv->innermost);
	VALA_CODE_VISITOR_CLASS (ide_vala_locator_parent_class)->finalize (obj);
}


GType ide_vala_locator_get_type (void) {
	return ide_vala_locator_type_id;
}


GType ide_vala_locator_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (IdeValaLocatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ide_vala_locator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IdeValaLocator), 0, (GInstanceInitFunc) ide_vala_locator_instance_init, NULL };
	ide_vala_locator_type_id = g_type_module_register_type (module, VALA_TYPE_CODE_VISITOR, "IdeValaLocator", &g_define_type_info, 0);
	return ide_vala_locator_type_id;
}



