/* mame-game-uri-adapter.c generated by valac 0.36.9, the Vala compiler
 * generated from mame-game-uri-adapter.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <libgnome-games.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define GAMES_TYPE_MAME_GAME_URI_ADAPTER (games_mame_game_uri_adapter_get_type ())
#define GAMES_MAME_GAME_URI_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_MAME_GAME_URI_ADAPTER, GamesMameGameUriAdapter))
#define GAMES_MAME_GAME_URI_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_MAME_GAME_URI_ADAPTER, GamesMameGameUriAdapterClass))
#define GAMES_IS_MAME_GAME_URI_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_MAME_GAME_URI_ADAPTER))
#define GAMES_IS_MAME_GAME_URI_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_MAME_GAME_URI_ADAPTER))
#define GAMES_MAME_GAME_URI_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_MAME_GAME_URI_ADAPTER, GamesMameGameUriAdapterClass))

typedef struct _GamesMameGameUriAdapter GamesMameGameUriAdapter;
typedef struct _GamesMameGameUriAdapterClass GamesMameGameUriAdapterClass;
typedef struct _GamesMameGameUriAdapterPrivate GamesMameGameUriAdapterPrivate;
#define _games_uri_unref0(var) ((var == NULL) ? NULL : (var = (games_uri_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAMES_TYPE_MAME_GAME_INFO (games_mame_game_info_get_type ())
typedef struct _GamesMameGameInfo GamesMameGameInfo;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _games_mame_game_info_free0(var) ((var == NULL) ? NULL : (var = (games_mame_game_info_free (var), NULL)))
typedef struct _GamesMameGameUriAdapterGameForUriData GamesMameGameUriAdapterGameForUriData;

struct _GamesMameGameUriAdapter {
	GObject parent_instance;
	GamesMameGameUriAdapterPrivate * priv;
};

struct _GamesMameGameUriAdapterClass {
	GObjectClass parent_class;
};

struct _GamesMameGameInfo {
	gchar* id;
	gchar* name;
};

typedef enum  {
	GAMES_MAME_ERROR_INVALID_GAME_ID
} GamesMameError;
#define GAMES_MAME_ERROR games_mame_error_quark ()
struct _GamesMameGameUriAdapterGameForUriData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	GamesMameGameUriAdapter* self;
	GamesUri* uri;
	GamesGame* result;
	GHashTable* supported_games;
	GHashTable* _tmp0_;
	GFile* file;
	GamesUri* _tmp1_;
	GFile* _tmp2_;
	gchar* game_id;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GHashTable* _tmp12_;
	const gchar* _tmp13_;
	gboolean _tmp14_;
	const gchar* _tmp15_;
	GamesUri* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GError* _tmp19_;
	GError* _tmp20_;
	gchar* uid_string;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GamesGenericUid* uid;
	const gchar* _tmp27_;
	GamesGenericUid* _tmp28_;
	GamesMameGameInfo* info;
	GHashTable* _tmp29_;
	const gchar* _tmp30_;
	gconstpointer _tmp31_;
	GamesMameGameInfo* _tmp32_;
	gchar* title_string;
	GamesMameGameInfo* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar** _tmp37_;
	gchar** _tmp38_;
	gchar** _tmp39_;
	gint _tmp39__length1;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	GamesGenericTitle* title;
	const gchar* _tmp44_;
	GamesGenericTitle* _tmp45_;
	GamesDummyIcon* icon;
	GamesDummyIcon* _tmp46_;
	GamesLocalCover* cover;
	GamesUri* _tmp47_;
	GamesLocalCover* _tmp48_;
	GamesRetroCoreSource* core_source;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar** _tmp51_;
	gchar** _tmp52_;
	gint _tmp52__length1;
	GamesRetroCoreSource* _tmp53_;
	GamesRetroCoreSource* _tmp54_;
	GamesRetroRunner* runner;
	GamesRetroCoreSource* _tmp55_;
	GamesUri* _tmp56_;
	GamesGenericUid* _tmp57_;
	GamesGenericTitle* _tmp58_;
	GamesRetroRunner* _tmp59_;
	GamesGenericTitle* _tmp60_;
	GamesDummyIcon* _tmp61_;
	GamesLocalCover* _tmp62_;
	GamesRetroRunner* _tmp63_;
	GamesGenericGame* _tmp64_;
	GError * _inner_error_;
};


static gpointer games_mame_game_uri_adapter_parent_class = NULL;
static GamesGameUriAdapterIface * games_mame_game_uri_adapter_games_game_uri_adapter_parent_iface = NULL;
static GType games_mame_game_uri_adapter_type_id = 0;

GType games_mame_game_uri_adapter_get_type (void) G_GNUC_CONST;
enum  {
	GAMES_MAME_GAME_URI_ADAPTER_0_PROPERTY
};
#define GAMES_MAME_GAME_URI_ADAPTER_SEARCHED_MIME_TYPE "application/zip"
#define GAMES_MAME_GAME_URI_ADAPTER_SPECIFIC_MIME_TYPE "application/x-mame-rom"
#define GAMES_MAME_GAME_URI_ADAPTER_PLATFORM "MAME"
static void games_mame_game_uri_adapter_real_game_for_uri_data_free (gpointer _data);
static void games_mame_game_uri_adapter_real_game_for_uri_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void games_mame_game_uri_adapter_real_game_for_uri (GamesGameUriAdapter* base, GamesUri* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean games_mame_game_uri_adapter_real_game_for_uri_co (GamesMameGameUriAdapterGameForUriData* _data_);
GType games_mame_game_info_get_type (void) G_GNUC_CONST;
GamesMameGameInfo* games_mame_game_info_dup (const GamesMameGameInfo* self);
void games_mame_game_info_free (GamesMameGameInfo* self);
void games_mame_game_info_copy (const GamesMameGameInfo* self, GamesMameGameInfo* dest);
void games_mame_game_info_destroy (GamesMameGameInfo* self);
void games_mame_game_info_get_supported_games (GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable* games_mame_game_info_get_supported_games_finish (GAsyncResult* _res_, GError** error);
static void games_mame_game_uri_adapter_game_for_uri_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GQuark games_mame_error_quark (void);
static gboolean _games_mame_game_uri_adapter_real_game_for_uri_co_gsource_func (gpointer self);
GamesMameGameUriAdapter* games_mame_game_uri_adapter_new (void);
GamesMameGameUriAdapter* games_mame_game_uri_adapter_construct (GType object_type);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static GRegex* _tmp_regex_0 = NULL;

static void games_mame_game_uri_adapter_real_game_for_uri_data_free (gpointer _data) {
	GamesMameGameUriAdapterGameForUriData* _data_;
	_data_ = _data;
	_games_uri_unref0 (_data_->uri);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesMameGameUriAdapterGameForUriData, _data_);
}


static void games_mame_game_uri_adapter_real_game_for_uri_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	GamesMameGameUriAdapterGameForUriData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _games_uri_ref0 (gpointer self) {
	return self ? games_uri_ref (self) : NULL;
}


static void games_mame_game_uri_adapter_real_game_for_uri (GamesGameUriAdapter* base, GamesUri* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GamesMameGameUriAdapter * self;
	GamesMameGameUriAdapterGameForUriData* _data_;
	GamesMameGameUriAdapter* _tmp0_;
	GamesUri* _tmp1_;
	GamesUri* _tmp2_;
	self = (GamesMameGameUriAdapter*) base;
	_data_ = g_slice_new0 (GamesMameGameUriAdapterGameForUriData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, games_mame_game_uri_adapter_real_game_for_uri_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, games_mame_game_uri_adapter_real_game_for_uri_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = uri;
	_tmp2_ = _games_uri_ref0 (_tmp1_);
	_games_uri_unref0 (_data_->uri);
	_data_->uri = _tmp2_;
	games_mame_game_uri_adapter_real_game_for_uri_co (_data_);
}


static GamesGame* games_mame_game_uri_adapter_real_game_for_uri_finish (GamesGameUriAdapter* base, GAsyncResult* _res_, GError** error) {
	GamesGame* result;
	GamesMameGameUriAdapterGameForUriData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void games_mame_game_uri_adapter_game_for_uri_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GamesMameGameUriAdapterGameForUriData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	games_mame_game_uri_adapter_real_game_for_uri_co (_data_);
}


static inline GRegex* _thread_safe_regex_init (GRegex** re, const gchar * pattern, GRegexMatchFlags match_options) {
	if (g_once_init_enter ((volatile gsize*) re)) {
		GRegex* val = g_regex_new (pattern, match_options, 0, NULL);
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
	}
	return *re;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gpointer _games_mame_game_info_dup0 (gpointer self) {
	return self ? games_mame_game_info_dup (self) : NULL;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gboolean _games_mame_game_uri_adapter_real_game_for_uri_co_gsource_func (gpointer self) {
	gboolean result;
	result = games_mame_game_uri_adapter_real_game_for_uri_co (self);
	return result;
}


static gboolean games_mame_game_uri_adapter_real_game_for_uri_co (GamesMameGameUriAdapterGameForUriData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	games_mame_game_info_get_supported_games (games_mame_game_uri_adapter_game_for_uri_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = games_mame_game_info_get_supported_games_finish (_data_->_res_, &_data_->_inner_error_);
	_data_->supported_games = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->uri;
	_data_->_tmp2_ = games_uri_to_file (_data_->_tmp1_);
	_data_->file = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->file;
	_data_->_tmp4_ = g_file_get_basename (_data_->_tmp3_);
	_data_->game_id = _data_->_tmp4_;
	_data_->_tmp6_ = _data_->game_id;
	_data_->_tmp7_ = _data_->game_id;
	_data_->_tmp8_ = strlen (_data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = g_regex_replace (_thread_safe_regex_init (&_tmp_regex_0, "\\.zip$", 0), _data_->_tmp6_, (gssize) _data_->_tmp9_, 0, "", 0, &_data_->_inner_error_);
	_data_->_tmp5_ = _data_->_tmp10_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_free0 (_data_->game_id);
		_g_object_unref0 (_data_->file);
		_g_hash_table_unref0 (_data_->supported_games);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = _data_->_tmp5_;
	_data_->_tmp5_ = NULL;
	_g_free0 (_data_->game_id);
	_data_->game_id = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->supported_games;
	_data_->_tmp13_ = _data_->game_id;
	_data_->_tmp14_ = g_hash_table_contains (_data_->_tmp12_, _data_->_tmp13_);
	if (!_data_->_tmp14_) {
		_data_->_tmp15_ = _data_->game_id;
		_data_->_tmp16_ = _data_->uri;
		_data_->_tmp17_ = games_uri_to_string (_data_->_tmp16_);
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp19_ = g_error_new (GAMES_MAME_ERROR, GAMES_MAME_ERROR_INVALID_GAME_ID, _ ("Invalid MAME game id “%s” for “%s”."), _data_->_tmp15_, _data_->_tmp18_);
		_data_->_tmp20_ = _data_->_tmp19_;
		_g_free0 (_data_->_tmp18_);
		_data_->_inner_error_ = _data_->_tmp20_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_free0 (_data_->_tmp5_);
		_g_free0 (_data_->game_id);
		_g_object_unref0 (_data_->file);
		_g_hash_table_unref0 (_data_->supported_games);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp21_ = _data_->game_id;
	_data_->_tmp22_ = string_to_string (_data_->_tmp21_);
	_data_->_tmp23_ = g_strconcat ("mame-", _data_->_tmp22_, NULL);
	_data_->_tmp24_ = _data_->_tmp23_;
	_data_->_tmp25_ = g_utf8_strdown (_data_->_tmp24_, (gssize) -1);
	_data_->_tmp26_ = _data_->_tmp25_;
	_g_free0 (_data_->_tmp24_);
	_data_->uid_string = _data_->_tmp26_;
	_data_->_tmp27_ = _data_->uid_string;
	_data_->_tmp28_ = games_generic_uid_new (_data_->_tmp27_);
	_data_->uid = _data_->_tmp28_;
	_data_->_tmp29_ = _data_->supported_games;
	_data_->_tmp30_ = _data_->game_id;
	_data_->_tmp31_ = g_hash_table_lookup (_data_->_tmp29_, _data_->_tmp30_);
	_data_->_tmp32_ = _games_mame_game_info_dup0 ((GamesMameGameInfo*) _data_->_tmp31_);
	_data_->info = _data_->_tmp32_;
	_data_->_tmp33_ = _data_->info;
	_data_->_tmp34_ = (*_data_->_tmp33_).name;
	_data_->_tmp35_ = g_strdup (_data_->_tmp34_);
	_data_->title_string = _data_->_tmp35_;
	_data_->_tmp36_ = _data_->title_string;
	_data_->_tmp38_ = _data_->_tmp37_ = g_strsplit (_data_->_tmp36_, "(", 0);
	_data_->_tmp39_ = _data_->_tmp38_;
	_data_->_tmp39__length1 = _vala_array_length (_data_->_tmp37_);
	_data_->_tmp40_ = _data_->_tmp39_[0];
	_data_->_tmp41_ = g_strdup (_data_->_tmp40_);
	_g_free0 (_data_->title_string);
	_data_->title_string = _data_->_tmp41_;
	_data_->_tmp39_ = (_vala_array_free (_data_->_tmp39_, _data_->_tmp39__length1, (GDestroyNotify) g_free), NULL);
	_data_->_tmp42_ = _data_->title_string;
	_data_->_tmp43_ = string_strip (_data_->_tmp42_);
	_g_free0 (_data_->title_string);
	_data_->title_string = _data_->_tmp43_;
	_data_->_tmp44_ = _data_->title_string;
	_data_->_tmp45_ = games_generic_title_new (_data_->_tmp44_);
	_data_->title = _data_->_tmp45_;
	_data_->_tmp46_ = games_dummy_icon_new ();
	_data_->icon = _data_->_tmp46_;
	_data_->_tmp47_ = _data_->uri;
	_data_->_tmp48_ = games_local_cover_new (_data_->_tmp47_);
	_data_->cover = _data_->_tmp48_;
	_data_->_tmp49_ = g_strdup (GAMES_MAME_GAME_URI_ADAPTER_SEARCHED_MIME_TYPE);
	_data_->_tmp50_ = g_strdup (GAMES_MAME_GAME_URI_ADAPTER_SPECIFIC_MIME_TYPE);
	_data_->_tmp51_ = g_new0 (gchar*, 2 + 1);
	_data_->_tmp51_[0] = _data_->_tmp49_;
	_data_->_tmp51_[1] = _data_->_tmp50_;
	_data_->_tmp52_ = _data_->_tmp51_;
	_data_->_tmp52__length1 = 2;
	_data_->_tmp53_ = games_retro_core_source_new (GAMES_MAME_GAME_URI_ADAPTER_PLATFORM, _data_->_tmp52_, 2);
	_data_->_tmp54_ = _data_->_tmp53_;
	_data_->_tmp52_ = (_vala_array_free (_data_->_tmp52_, _data_->_tmp52__length1, (GDestroyNotify) g_free), NULL);
	_data_->core_source = _data_->_tmp54_;
	_data_->_tmp55_ = _data_->core_source;
	_data_->_tmp56_ = _data_->uri;
	_data_->_tmp57_ = _data_->uid;
	_data_->_tmp58_ = _data_->title;
	_data_->_tmp59_ = games_retro_runner_new (_data_->_tmp55_, _data_->_tmp56_, (GamesUid*) _data_->_tmp57_, (GamesTitle*) _data_->_tmp58_);
	_data_->runner = _data_->_tmp59_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _games_mame_game_uri_adapter_real_game_for_uri_co_gsource_func, _data_, NULL);
	_data_->_state_ = 2;
	return FALSE;
	_state_2:
	;
	_data_->_tmp60_ = _data_->title;
	_data_->_tmp61_ = _data_->icon;
	_data_->_tmp62_ = _data_->cover;
	_data_->_tmp63_ = _data_->runner;
	_data_->_tmp64_ = games_generic_game_new ((GamesTitle*) _data_->_tmp60_, (GamesIcon*) _data_->_tmp61_, (GamesCover*) _data_->_tmp62_, (GamesRunner*) _data_->_tmp63_);
	_data_->result = (GamesGame*) _data_->_tmp64_;
	_g_object_unref0 (_data_->runner);
	_g_object_unref0 (_data_->core_source);
	_g_object_unref0 (_data_->cover);
	_g_object_unref0 (_data_->icon);
	_g_object_unref0 (_data_->title);
	_g_free0 (_data_->title_string);
	_games_mame_game_info_free0 (_data_->info);
	_g_object_unref0 (_data_->uid);
	_g_free0 (_data_->uid_string);
	_g_free0 (_data_->_tmp5_);
	_g_free0 (_data_->game_id);
	_g_object_unref0 (_data_->file);
	_g_hash_table_unref0 (_data_->supported_games);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


GamesMameGameUriAdapter* games_mame_game_uri_adapter_construct (GType object_type) {
	GamesMameGameUriAdapter * self = NULL;
	self = (GamesMameGameUriAdapter*) g_object_new (object_type, NULL);
	return self;
}


GamesMameGameUriAdapter* games_mame_game_uri_adapter_new (void) {
	return games_mame_game_uri_adapter_construct (GAMES_TYPE_MAME_GAME_URI_ADAPTER);
}


static void games_mame_game_uri_adapter_class_init (GamesMameGameUriAdapterClass * klass) {
	games_mame_game_uri_adapter_parent_class = g_type_class_peek_parent (klass);
}


static void games_mame_game_uri_adapter_games_game_uri_adapter_interface_init (GamesGameUriAdapterIface * iface) {
	games_mame_game_uri_adapter_games_game_uri_adapter_parent_iface = g_type_interface_peek_parent (iface);
	iface->game_for_uri = (void (*) (GamesGameUriAdapter *, GamesUri*, GAsyncReadyCallback, gpointer)) games_mame_game_uri_adapter_real_game_for_uri;
	iface->game_for_uri_finish = (GamesGame* (*) (GamesGameUriAdapter *, GAsyncResult*, GError**)) games_mame_game_uri_adapter_real_game_for_uri_finish;
}


static void games_mame_game_uri_adapter_instance_init (GamesMameGameUriAdapter * self) {
}


GType games_mame_game_uri_adapter_get_type (void) {
	return games_mame_game_uri_adapter_type_id;
}


GType games_mame_game_uri_adapter_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GamesMameGameUriAdapterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_mame_game_uri_adapter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesMameGameUriAdapter), 0, (GInstanceInitFunc) games_mame_game_uri_adapter_instance_init, NULL };
	static const GInterfaceInfo games_game_uri_adapter_info = { (GInterfaceInitFunc) games_mame_game_uri_adapter_games_game_uri_adapter_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	games_mame_game_uri_adapter_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesMameGameUriAdapter", &g_define_type_info, 0);
	g_type_module_add_interface (module, games_mame_game_uri_adapter_type_id, GAMES_TYPE_GAME_URI_ADAPTER, &games_game_uri_adapter_info);
	return games_mame_game_uri_adapter_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



