// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/recommendationengine/v1beta1/import.proto

package recommendationengine

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Google Cloud Storage location for input content.
// format.
type GcsSource struct {
	// Required. Google Cloud Storage URIs to input files. URI can be up to
	// 2000 characters long. URIs can match the full object path (for example,
	// gs://bucket/directory/object.json) or a pattern matching one or more
	// files, such as gs://bucket/directory/*.json. A request can
	// contain at most 100 files, and each file can be up to 500 MB. See
	// [Importing catalog information](/recommendations-ai/docs/upload-catalog)
	// for the expected file format and setup instructions.
	InputUris            []string `protobuf:"bytes,1,rep,name=input_uris,json=inputUris,proto3" json:"input_uris,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GcsSource) Reset()         { *m = GcsSource{} }
func (m *GcsSource) String() string { return proto.CompactTextString(m) }
func (*GcsSource) ProtoMessage()    {}
func (*GcsSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_152d6e7da409eb0d, []int{0}
}

func (m *GcsSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsSource.Unmarshal(m, b)
}
func (m *GcsSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsSource.Marshal(b, m, deterministic)
}
func (m *GcsSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsSource.Merge(m, src)
}
func (m *GcsSource) XXX_Size() int {
	return xxx_messageInfo_GcsSource.Size(m)
}
func (m *GcsSource) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsSource.DiscardUnknown(m)
}

var xxx_messageInfo_GcsSource proto.InternalMessageInfo

func (m *GcsSource) GetInputUris() []string {
	if m != nil {
		return m.InputUris
	}
	return nil
}

// The inline source for the input config for ImportCatalogItems method.
type CatalogInlineSource struct {
	// Optional. A list of catalog items to update/create. Recommended max of 10k
	// items.
	CatalogItems         []*CatalogItem `protobuf:"bytes,1,rep,name=catalog_items,json=catalogItems,proto3" json:"catalog_items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *CatalogInlineSource) Reset()         { *m = CatalogInlineSource{} }
func (m *CatalogInlineSource) String() string { return proto.CompactTextString(m) }
func (*CatalogInlineSource) ProtoMessage()    {}
func (*CatalogInlineSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_152d6e7da409eb0d, []int{1}
}

func (m *CatalogInlineSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CatalogInlineSource.Unmarshal(m, b)
}
func (m *CatalogInlineSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CatalogInlineSource.Marshal(b, m, deterministic)
}
func (m *CatalogInlineSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CatalogInlineSource.Merge(m, src)
}
func (m *CatalogInlineSource) XXX_Size() int {
	return xxx_messageInfo_CatalogInlineSource.Size(m)
}
func (m *CatalogInlineSource) XXX_DiscardUnknown() {
	xxx_messageInfo_CatalogInlineSource.DiscardUnknown(m)
}

var xxx_messageInfo_CatalogInlineSource proto.InternalMessageInfo

func (m *CatalogInlineSource) GetCatalogItems() []*CatalogItem {
	if m != nil {
		return m.CatalogItems
	}
	return nil
}

// The inline source for the input config for ImportUserEvents method.
type UserEventInlineSource struct {
	// Optional. A list of user events to import. Recommended max of 10k items.
	UserEvents           []*UserEvent `protobuf:"bytes,1,rep,name=user_events,json=userEvents,proto3" json:"user_events,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *UserEventInlineSource) Reset()         { *m = UserEventInlineSource{} }
func (m *UserEventInlineSource) String() string { return proto.CompactTextString(m) }
func (*UserEventInlineSource) ProtoMessage()    {}
func (*UserEventInlineSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_152d6e7da409eb0d, []int{2}
}

func (m *UserEventInlineSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserEventInlineSource.Unmarshal(m, b)
}
func (m *UserEventInlineSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserEventInlineSource.Marshal(b, m, deterministic)
}
func (m *UserEventInlineSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserEventInlineSource.Merge(m, src)
}
func (m *UserEventInlineSource) XXX_Size() int {
	return xxx_messageInfo_UserEventInlineSource.Size(m)
}
func (m *UserEventInlineSource) XXX_DiscardUnknown() {
	xxx_messageInfo_UserEventInlineSource.DiscardUnknown(m)
}

var xxx_messageInfo_UserEventInlineSource proto.InternalMessageInfo

func (m *UserEventInlineSource) GetUserEvents() []*UserEvent {
	if m != nil {
		return m.UserEvents
	}
	return nil
}

// Configuration of destination for Import related errors.
type ImportErrorsConfig struct {
	// Required. Errors destination.
	//
	// Types that are valid to be assigned to Destination:
	//	*ImportErrorsConfig_GcsPrefix
	Destination          isImportErrorsConfig_Destination `protobuf_oneof:"destination"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *ImportErrorsConfig) Reset()         { *m = ImportErrorsConfig{} }
func (m *ImportErrorsConfig) String() string { return proto.CompactTextString(m) }
func (*ImportErrorsConfig) ProtoMessage()    {}
func (*ImportErrorsConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_152d6e7da409eb0d, []int{3}
}

func (m *ImportErrorsConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportErrorsConfig.Unmarshal(m, b)
}
func (m *ImportErrorsConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportErrorsConfig.Marshal(b, m, deterministic)
}
func (m *ImportErrorsConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportErrorsConfig.Merge(m, src)
}
func (m *ImportErrorsConfig) XXX_Size() int {
	return xxx_messageInfo_ImportErrorsConfig.Size(m)
}
func (m *ImportErrorsConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportErrorsConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ImportErrorsConfig proto.InternalMessageInfo

type isImportErrorsConfig_Destination interface {
	isImportErrorsConfig_Destination()
}

type ImportErrorsConfig_GcsPrefix struct {
	GcsPrefix string `protobuf:"bytes,1,opt,name=gcs_prefix,json=gcsPrefix,proto3,oneof"`
}

func (*ImportErrorsConfig_GcsPrefix) isImportErrorsConfig_Destination() {}

func (m *ImportErrorsConfig) GetDestination() isImportErrorsConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *ImportErrorsConfig) GetGcsPrefix() string {
	if x, ok := m.GetDestination().(*ImportErrorsConfig_GcsPrefix); ok {
		return x.GcsPrefix
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ImportErrorsConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ImportErrorsConfig_GcsPrefix)(nil),
	}
}

// Request message for Import methods.
type ImportCatalogItemsRequest struct {
	// Required. "projects/1234/locations/global/catalogs/default_catalog"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Unique identifier provided by client, within the ancestor
	// dataset scope. Ensures idempotency and used for request deduplication.
	// Server-generated if unspecified. Up to 128 characters long. This is
	// returned as google.longrunning.Operation.name in the response.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Required. The desired input location of the data.
	InputConfig *InputConfig `protobuf:"bytes,3,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// Optional. The desired location of errors incurred during the Import.
	ErrorsConfig         *ImportErrorsConfig `protobuf:"bytes,4,opt,name=errors_config,json=errorsConfig,proto3" json:"errors_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ImportCatalogItemsRequest) Reset()         { *m = ImportCatalogItemsRequest{} }
func (m *ImportCatalogItemsRequest) String() string { return proto.CompactTextString(m) }
func (*ImportCatalogItemsRequest) ProtoMessage()    {}
func (*ImportCatalogItemsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_152d6e7da409eb0d, []int{4}
}

func (m *ImportCatalogItemsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportCatalogItemsRequest.Unmarshal(m, b)
}
func (m *ImportCatalogItemsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportCatalogItemsRequest.Marshal(b, m, deterministic)
}
func (m *ImportCatalogItemsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportCatalogItemsRequest.Merge(m, src)
}
func (m *ImportCatalogItemsRequest) XXX_Size() int {
	return xxx_messageInfo_ImportCatalogItemsRequest.Size(m)
}
func (m *ImportCatalogItemsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportCatalogItemsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportCatalogItemsRequest proto.InternalMessageInfo

func (m *ImportCatalogItemsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ImportCatalogItemsRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *ImportCatalogItemsRequest) GetInputConfig() *InputConfig {
	if m != nil {
		return m.InputConfig
	}
	return nil
}

func (m *ImportCatalogItemsRequest) GetErrorsConfig() *ImportErrorsConfig {
	if m != nil {
		return m.ErrorsConfig
	}
	return nil
}

// Request message for the ImportUserEvents request.
type ImportUserEventsRequest struct {
	// Required.
	// "projects/1234/locations/global/catalogs/default_catalog/eventStores/default_event_store"
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Unique identifier provided by client, within the ancestor
	// dataset scope. Ensures idempotency for expensive long running operations.
	// Server-generated if unspecified. Up to 128 characters long. This is
	// returned as google.longrunning.Operation.name in the response. Note that
	// this field must not be set if the desired input config is
	// catalog_inline_source.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Required. The desired input location of the data.
	InputConfig *InputConfig `protobuf:"bytes,3,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// Optional. The desired location of errors incurred during the Import.
	ErrorsConfig         *ImportErrorsConfig `protobuf:"bytes,4,opt,name=errors_config,json=errorsConfig,proto3" json:"errors_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ImportUserEventsRequest) Reset()         { *m = ImportUserEventsRequest{} }
func (m *ImportUserEventsRequest) String() string { return proto.CompactTextString(m) }
func (*ImportUserEventsRequest) ProtoMessage()    {}
func (*ImportUserEventsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_152d6e7da409eb0d, []int{5}
}

func (m *ImportUserEventsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportUserEventsRequest.Unmarshal(m, b)
}
func (m *ImportUserEventsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportUserEventsRequest.Marshal(b, m, deterministic)
}
func (m *ImportUserEventsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportUserEventsRequest.Merge(m, src)
}
func (m *ImportUserEventsRequest) XXX_Size() int {
	return xxx_messageInfo_ImportUserEventsRequest.Size(m)
}
func (m *ImportUserEventsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportUserEventsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportUserEventsRequest proto.InternalMessageInfo

func (m *ImportUserEventsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ImportUserEventsRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *ImportUserEventsRequest) GetInputConfig() *InputConfig {
	if m != nil {
		return m.InputConfig
	}
	return nil
}

func (m *ImportUserEventsRequest) GetErrorsConfig() *ImportErrorsConfig {
	if m != nil {
		return m.ErrorsConfig
	}
	return nil
}

// The input config source.
type InputConfig struct {
	// Required. The source of the input.
	//
	// Types that are valid to be assigned to Source:
	//	*InputConfig_CatalogInlineSource
	//	*InputConfig_GcsSource
	//	*InputConfig_UserEventInlineSource
	Source               isInputConfig_Source `protobuf_oneof:"source"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *InputConfig) Reset()         { *m = InputConfig{} }
func (m *InputConfig) String() string { return proto.CompactTextString(m) }
func (*InputConfig) ProtoMessage()    {}
func (*InputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_152d6e7da409eb0d, []int{6}
}

func (m *InputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InputConfig.Unmarshal(m, b)
}
func (m *InputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InputConfig.Marshal(b, m, deterministic)
}
func (m *InputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InputConfig.Merge(m, src)
}
func (m *InputConfig) XXX_Size() int {
	return xxx_messageInfo_InputConfig.Size(m)
}
func (m *InputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_InputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_InputConfig proto.InternalMessageInfo

type isInputConfig_Source interface {
	isInputConfig_Source()
}

type InputConfig_CatalogInlineSource struct {
	CatalogInlineSource *CatalogInlineSource `protobuf:"bytes,1,opt,name=catalog_inline_source,json=catalogInlineSource,proto3,oneof"`
}

type InputConfig_GcsSource struct {
	GcsSource *GcsSource `protobuf:"bytes,2,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type InputConfig_UserEventInlineSource struct {
	UserEventInlineSource *UserEventInlineSource `protobuf:"bytes,3,opt,name=user_event_inline_source,json=userEventInlineSource,proto3,oneof"`
}

func (*InputConfig_CatalogInlineSource) isInputConfig_Source() {}

func (*InputConfig_GcsSource) isInputConfig_Source() {}

func (*InputConfig_UserEventInlineSource) isInputConfig_Source() {}

func (m *InputConfig) GetSource() isInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *InputConfig) GetCatalogInlineSource() *CatalogInlineSource {
	if x, ok := m.GetSource().(*InputConfig_CatalogInlineSource); ok {
		return x.CatalogInlineSource
	}
	return nil
}

func (m *InputConfig) GetGcsSource() *GcsSource {
	if x, ok := m.GetSource().(*InputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (m *InputConfig) GetUserEventInlineSource() *UserEventInlineSource {
	if x, ok := m.GetSource().(*InputConfig_UserEventInlineSource); ok {
		return x.UserEventInlineSource
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*InputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*InputConfig_CatalogInlineSource)(nil),
		(*InputConfig_GcsSource)(nil),
		(*InputConfig_UserEventInlineSource)(nil),
	}
}

// Metadata related to the progress of the Import operation. This will be
// returned by the google.longrunning.Operation.metadata field.
type ImportMetadata struct {
	// Name of the operation.
	OperationName string `protobuf:"bytes,5,opt,name=operation_name,json=operationName,proto3" json:"operation_name,omitempty"`
	// Id of the request / operation. This is parroting back the requestId that
	// was passed in the request.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Operation create time.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Count of entries that were processed successfully.
	SuccessCount int64 `protobuf:"varint,1,opt,name=success_count,json=successCount,proto3" json:"success_count,omitempty"`
	// Count of entries that encountered errors while processing.
	FailureCount int64 `protobuf:"varint,2,opt,name=failure_count,json=failureCount,proto3" json:"failure_count,omitempty"`
	// Operation last update time. If the operation is done, this is also the
	// finish time.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ImportMetadata) Reset()         { *m = ImportMetadata{} }
func (m *ImportMetadata) String() string { return proto.CompactTextString(m) }
func (*ImportMetadata) ProtoMessage()    {}
func (*ImportMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_152d6e7da409eb0d, []int{7}
}

func (m *ImportMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportMetadata.Unmarshal(m, b)
}
func (m *ImportMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportMetadata.Marshal(b, m, deterministic)
}
func (m *ImportMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportMetadata.Merge(m, src)
}
func (m *ImportMetadata) XXX_Size() int {
	return xxx_messageInfo_ImportMetadata.Size(m)
}
func (m *ImportMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ImportMetadata proto.InternalMessageInfo

func (m *ImportMetadata) GetOperationName() string {
	if m != nil {
		return m.OperationName
	}
	return ""
}

func (m *ImportMetadata) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

func (m *ImportMetadata) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *ImportMetadata) GetSuccessCount() int64 {
	if m != nil {
		return m.SuccessCount
	}
	return 0
}

func (m *ImportMetadata) GetFailureCount() int64 {
	if m != nil {
		return m.FailureCount
	}
	return 0
}

func (m *ImportMetadata) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// Response of the ImportCatalogItemsRequest. If the long running
// operation is done, then this message is returned by the
// google.longrunning.Operations.response field if the operation was successful.
type ImportCatalogItemsResponse struct {
	// A sample of errors encountered while processing the request.
	ErrorSamples []*status.Status `protobuf:"bytes,1,rep,name=error_samples,json=errorSamples,proto3" json:"error_samples,omitempty"`
	// Echoes the optional destination for the complete errors in the request if
	// set.
	ErrorsConfig         *ImportErrorsConfig `protobuf:"bytes,2,opt,name=errors_config,json=errorsConfig,proto3" json:"errors_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ImportCatalogItemsResponse) Reset()         { *m = ImportCatalogItemsResponse{} }
func (m *ImportCatalogItemsResponse) String() string { return proto.CompactTextString(m) }
func (*ImportCatalogItemsResponse) ProtoMessage()    {}
func (*ImportCatalogItemsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_152d6e7da409eb0d, []int{8}
}

func (m *ImportCatalogItemsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportCatalogItemsResponse.Unmarshal(m, b)
}
func (m *ImportCatalogItemsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportCatalogItemsResponse.Marshal(b, m, deterministic)
}
func (m *ImportCatalogItemsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportCatalogItemsResponse.Merge(m, src)
}
func (m *ImportCatalogItemsResponse) XXX_Size() int {
	return xxx_messageInfo_ImportCatalogItemsResponse.Size(m)
}
func (m *ImportCatalogItemsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportCatalogItemsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ImportCatalogItemsResponse proto.InternalMessageInfo

func (m *ImportCatalogItemsResponse) GetErrorSamples() []*status.Status {
	if m != nil {
		return m.ErrorSamples
	}
	return nil
}

func (m *ImportCatalogItemsResponse) GetErrorsConfig() *ImportErrorsConfig {
	if m != nil {
		return m.ErrorsConfig
	}
	return nil
}

// Response of the ImportUserEventsRequest. If the long running
// operation was successful, then this message is returned by the
// google.longrunning.Operations.response field if the operation was successful.
type ImportUserEventsResponse struct {
	// A sample of errors encountered while processing the request.
	ErrorSamples []*status.Status `protobuf:"bytes,1,rep,name=error_samples,json=errorSamples,proto3" json:"error_samples,omitempty"`
	// Echoes the optional destination for the complete errors if this field was
	// set in the request.
	ErrorsConfig *ImportErrorsConfig `protobuf:"bytes,2,opt,name=errors_config,json=errorsConfig,proto3" json:"errors_config,omitempty"`
	// Aggregated statistics of user event import status.
	ImportSummary        *UserEventImportSummary `protobuf:"bytes,3,opt,name=import_summary,json=importSummary,proto3" json:"import_summary,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *ImportUserEventsResponse) Reset()         { *m = ImportUserEventsResponse{} }
func (m *ImportUserEventsResponse) String() string { return proto.CompactTextString(m) }
func (*ImportUserEventsResponse) ProtoMessage()    {}
func (*ImportUserEventsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_152d6e7da409eb0d, []int{9}
}

func (m *ImportUserEventsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportUserEventsResponse.Unmarshal(m, b)
}
func (m *ImportUserEventsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportUserEventsResponse.Marshal(b, m, deterministic)
}
func (m *ImportUserEventsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportUserEventsResponse.Merge(m, src)
}
func (m *ImportUserEventsResponse) XXX_Size() int {
	return xxx_messageInfo_ImportUserEventsResponse.Size(m)
}
func (m *ImportUserEventsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportUserEventsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ImportUserEventsResponse proto.InternalMessageInfo

func (m *ImportUserEventsResponse) GetErrorSamples() []*status.Status {
	if m != nil {
		return m.ErrorSamples
	}
	return nil
}

func (m *ImportUserEventsResponse) GetErrorsConfig() *ImportErrorsConfig {
	if m != nil {
		return m.ErrorsConfig
	}
	return nil
}

func (m *ImportUserEventsResponse) GetImportSummary() *UserEventImportSummary {
	if m != nil {
		return m.ImportSummary
	}
	return nil
}

// A summary of import result. The UserEventImportSummary summarizes
// the import status for user events.
type UserEventImportSummary struct {
	// Count of user events imported with complete existing catalog information.
	JoinedEventsCount int64 `protobuf:"varint,1,opt,name=joined_events_count,json=joinedEventsCount,proto3" json:"joined_events_count,omitempty"`
	// Count of user events imported, but with catalog information not found
	// in the imported catalog.
	UnjoinedEventsCount  int64    `protobuf:"varint,2,opt,name=unjoined_events_count,json=unjoinedEventsCount,proto3" json:"unjoined_events_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UserEventImportSummary) Reset()         { *m = UserEventImportSummary{} }
func (m *UserEventImportSummary) String() string { return proto.CompactTextString(m) }
func (*UserEventImportSummary) ProtoMessage()    {}
func (*UserEventImportSummary) Descriptor() ([]byte, []int) {
	return fileDescriptor_152d6e7da409eb0d, []int{10}
}

func (m *UserEventImportSummary) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserEventImportSummary.Unmarshal(m, b)
}
func (m *UserEventImportSummary) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserEventImportSummary.Marshal(b, m, deterministic)
}
func (m *UserEventImportSummary) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserEventImportSummary.Merge(m, src)
}
func (m *UserEventImportSummary) XXX_Size() int {
	return xxx_messageInfo_UserEventImportSummary.Size(m)
}
func (m *UserEventImportSummary) XXX_DiscardUnknown() {
	xxx_messageInfo_UserEventImportSummary.DiscardUnknown(m)
}

var xxx_messageInfo_UserEventImportSummary proto.InternalMessageInfo

func (m *UserEventImportSummary) GetJoinedEventsCount() int64 {
	if m != nil {
		return m.JoinedEventsCount
	}
	return 0
}

func (m *UserEventImportSummary) GetUnjoinedEventsCount() int64 {
	if m != nil {
		return m.UnjoinedEventsCount
	}
	return 0
}

func init() {
	proto.RegisterType((*GcsSource)(nil), "google.cloud.recommendationengine.v1beta1.GcsSource")
	proto.RegisterType((*CatalogInlineSource)(nil), "google.cloud.recommendationengine.v1beta1.CatalogInlineSource")
	proto.RegisterType((*UserEventInlineSource)(nil), "google.cloud.recommendationengine.v1beta1.UserEventInlineSource")
	proto.RegisterType((*ImportErrorsConfig)(nil), "google.cloud.recommendationengine.v1beta1.ImportErrorsConfig")
	proto.RegisterType((*ImportCatalogItemsRequest)(nil), "google.cloud.recommendationengine.v1beta1.ImportCatalogItemsRequest")
	proto.RegisterType((*ImportUserEventsRequest)(nil), "google.cloud.recommendationengine.v1beta1.ImportUserEventsRequest")
	proto.RegisterType((*InputConfig)(nil), "google.cloud.recommendationengine.v1beta1.InputConfig")
	proto.RegisterType((*ImportMetadata)(nil), "google.cloud.recommendationengine.v1beta1.ImportMetadata")
	proto.RegisterType((*ImportCatalogItemsResponse)(nil), "google.cloud.recommendationengine.v1beta1.ImportCatalogItemsResponse")
	proto.RegisterType((*ImportUserEventsResponse)(nil), "google.cloud.recommendationengine.v1beta1.ImportUserEventsResponse")
	proto.RegisterType((*UserEventImportSummary)(nil), "google.cloud.recommendationengine.v1beta1.UserEventImportSummary")
}

func init() {
	proto.RegisterFile("google/cloud/recommendationengine/v1beta1/import.proto", fileDescriptor_152d6e7da409eb0d)
}

var fileDescriptor_152d6e7da409eb0d = []byte{
	// 835 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x56, 0xdd, 0x6a, 0x24, 0x45,
	0x14, 0xde, 0xe9, 0xb8, 0xc1, 0x39, 0x9d, 0x09, 0xd8, 0x21, 0xbb, 0x63, 0x50, 0x36, 0xb4, 0x08,
	0xbb, 0x82, 0xdd, 0x24, 0xca, 0x2e, 0x18, 0x14, 0x37, 0x63, 0xd8, 0x9d, 0x0b, 0x65, 0xe9, 0x18,
	0x41, 0x45, 0x9a, 0x9a, 0xea, 0x33, 0x9d, 0x92, 0xee, 0xaa, 0xb6, 0x7e, 0x82, 0xa2, 0xef, 0x20,
	0xde, 0x7a, 0xa7, 0x97, 0xbe, 0x81, 0xf7, 0xbe, 0x88, 0x6f, 0x22, 0x5d, 0x55, 0x3d, 0x33, 0x99,
	0x0c, 0x38, 0x13, 0xbc, 0x91, 0xbd, 0x9b, 0x3a, 0xf5, 0x9d, 0xdf, 0xfa, 0xbe, 0x33, 0x0d, 0x8f,
	0x4b, 0x21, 0xca, 0x0a, 0x53, 0x5a, 0x09, 0x53, 0xa4, 0x12, 0xa9, 0xa8, 0x6b, 0xe4, 0x05, 0xd1,
	0x4c, 0x70, 0xe4, 0x25, 0xe3, 0x98, 0x5e, 0x1d, 0x4d, 0x50, 0x93, 0xa3, 0x94, 0xd5, 0x8d, 0x90,
	0x3a, 0x69, 0xa4, 0xd0, 0x22, 0x7a, 0xe4, 0xfc, 0x12, 0xeb, 0x97, 0xac, 0xf2, 0x4b, 0xbc, 0xdf,
	0xc1, 0x1b, 0x3e, 0x05, 0x69, 0x58, 0x4a, 0x38, 0x17, 0xda, 0x82, 0x94, 0x0b, 0x74, 0xf0, 0x60,
	0xe1, 0x76, 0xca, 0xb0, 0x2a, 0xf2, 0x09, 0x5e, 0x92, 0x2b, 0x26, 0xa4, 0x07, 0x3c, 0x59, 0xbf,
	0x42, 0x4a, 0x34, 0xa9, 0x44, 0xe9, 0x1d, 0x3f, 0x58, 0xdf, 0xd1, 0x28, 0x94, 0x39, 0x5e, 0x21,
	0xd7, 0x4b, 0x55, 0xd9, 0xd3, 0xc4, 0x4c, 0x53, 0xcd, 0x6a, 0x54, 0x9a, 0xd4, 0x8d, 0x07, 0xdc,
	0xf7, 0x00, 0xd9, 0xd0, 0x54, 0x69, 0xa2, 0x8d, 0xef, 0x27, 0x7e, 0x07, 0xfa, 0xcf, 0xa8, 0x3a,
	0x17, 0x46, 0x52, 0x8c, 0xde, 0x04, 0x60, 0xbc, 0x31, 0x3a, 0x37, 0x92, 0xa9, 0x61, 0xef, 0x70,
	0xeb, 0x61, 0x3f, 0xeb, 0x5b, 0xcb, 0x85, 0x64, 0x2a, 0x96, 0xb0, 0x37, 0x72, 0x25, 0x8f, 0x79,
	0xc5, 0x38, 0x7a, 0xaf, 0xaf, 0x61, 0xe0, 0x3b, 0xc9, 0x99, 0xc6, 0xda, 0x39, 0x86, 0xc7, 0x8f,
	0x93, 0xb5, 0x67, 0x9e, 0x74, 0x61, 0x35, 0xd6, 0xd9, 0x0e, 0x9d, 0x1f, 0x54, 0xcc, 0x61, 0xff,
	0x42, 0xa1, 0x3c, 0x6b, 0x9b, 0xbd, 0x96, 0xf5, 0x02, 0xc2, 0xf9, 0x18, 0xba, 0x9c, 0xef, 0x6f,
	0x90, 0x73, 0x16, 0x36, 0x03, 0xd3, 0xfd, 0x54, 0xf1, 0x27, 0x10, 0x8d, 0x2d, 0x71, 0xce, 0xa4,
	0x14, 0x52, 0x8d, 0x04, 0x9f, 0xb2, 0x32, 0x7a, 0x00, 0x50, 0x52, 0x95, 0x37, 0x12, 0xa7, 0xec,
	0xfb, 0x61, 0xef, 0xb0, 0xf7, 0xb0, 0xff, 0xfc, 0x4e, 0xd6, 0x2f, 0xa9, 0x7a, 0x61, 0x4d, 0xa7,
	0x03, 0x08, 0x0b, 0x54, 0x9a, 0x71, 0x9b, 0x29, 0xfe, 0x25, 0x80, 0xd7, 0x5d, 0x98, 0x85, 0xce,
	0x54, 0x86, 0xdf, 0x19, 0x54, 0x3a, 0xba, 0x07, 0xdb, 0x0d, 0x91, 0xc8, 0xb5, 0x8b, 0x94, 0xf9,
	0x53, 0x3b, 0x7e, 0xe9, 0x20, 0x39, 0x2b, 0x86, 0x81, 0xbd, 0xeb, 0x7b, 0xcb, 0xb8, 0x88, 0xbe,
	0x84, 0x1d, 0xf7, 0x3a, 0xd4, 0x16, 0x35, 0xdc, 0x3a, 0xec, 0x6d, 0x38, 0xe6, 0x71, 0xeb, 0xee,
	0x5a, 0xca, 0x42, 0x36, 0x3f, 0x44, 0x13, 0x18, 0xa0, 0xed, 0xb7, 0x8b, 0xfd, 0x8a, 0x8d, 0xfd,
	0xe1, 0x26, 0xb1, 0x6f, 0x4c, 0x2d, 0xdb, 0xc1, 0x85, 0x53, 0xfc, 0x73, 0x00, 0xf7, 0x1d, 0x68,
	0x36, 0xf9, 0x97, 0x7c, 0x22, 0x7f, 0x07, 0x10, 0x2e, 0x14, 0x10, 0x69, 0xd8, 0x9f, 0x09, 0xc9,
	0x52, 0x3d, 0x57, 0x96, 0xeb, 0x76, 0x28, 0xe1, 0xf1, 0x47, 0xb7, 0x10, 0xd4, 0x82, 0x62, 0x9e,
	0xdf, 0xc9, 0xf6, 0xe8, 0x0a, 0xf9, 0x5e, 0x38, 0x6e, 0xfb, 0x54, 0x81, 0x4d, 0xb5, 0x89, 0x8e,
	0x66, 0xeb, 0xc3, 0x2b, 0xc2, 0x87, 0xfd, 0x11, 0x86, 0x73, 0x7d, 0x2e, 0xf5, 0xe3, 0xde, 0xe9,
	0xe3, 0xdb, 0x88, 0x75, 0xa9, 0xa3, 0x7d, 0xb3, 0xea, 0xe2, 0xf4, 0x55, 0xd8, 0x76, 0xa9, 0xe2,
	0x5f, 0x03, 0xd8, 0x75, 0x0f, 0xf1, 0x29, 0x6a, 0x52, 0x10, 0x4d, 0xa2, 0xb7, 0x61, 0x57, 0x34,
	0x28, 0x6d, 0x9a, 0x9c, 0x93, 0x1a, 0x87, 0x77, 0x2d, 0xb1, 0x06, 0x33, 0xeb, 0x67, 0xa4, 0xc6,
	0x25, 0xee, 0x6d, 0x2d, 0x73, 0xef, 0x04, 0x42, 0x2a, 0x91, 0x68, 0xcc, 0xdb, 0x5d, 0xeb, 0xe9,
	0x71, 0xd0, 0xb5, 0xd4, 0x2d, 0xe2, 0xe4, 0xf3, 0x6e, 0x11, 0x67, 0xe0, 0xe0, 0xad, 0x21, 0x7a,
	0x0b, 0x06, 0xca, 0x50, 0x8a, 0xaa, 0xa5, 0x97, 0xf1, 0xb4, 0xdf, 0xca, 0x76, 0xbc, 0x71, 0xd4,
	0xda, 0x5a, 0xd0, 0x94, 0xb0, 0xca, 0x48, 0xf4, 0xa0, 0xc0, 0x81, 0xbc, 0xd1, 0x81, 0x4e, 0x20,
	0x34, 0x4d, 0x31, 0x2b, 0x63, 0xfb, 0xdf, 0xcb, 0x70, 0xf0, 0xd6, 0x10, 0xff, 0xd9, 0x83, 0x83,
	0x55, 0x6b, 0x4a, 0x35, 0x82, 0x2b, 0x8c, 0x9e, 0x78, 0x0d, 0xe4, 0x8a, 0xd4, 0x4d, 0x85, 0xdd,
	0x92, 0x8d, 0xba, 0xe8, 0xb2, 0xa1, 0xc9, 0xb9, 0xfd, 0x33, 0xf1, 0xc4, 0x3e, 0x77, 0xb8, 0x9b,
	0xe2, 0x09, 0xfe, 0x7b, 0xf1, 0xfc, 0x16, 0xc0, 0xf0, 0xe6, 0x3a, 0xf9, 0x1f, 0x54, 0x1e, 0x5d,
	0xc2, 0xae, 0xfb, 0x36, 0xc9, 0x95, 0xa9, 0x6b, 0x22, 0x7f, 0xf0, 0x7a, 0x78, 0x7a, 0x2b, 0x3d,
	0xd8, 0x48, 0xe7, 0x2e, 0x50, 0x36, 0x60, 0x8b, 0xc7, 0xf8, 0x27, 0xb8, 0xb7, 0x1a, 0x18, 0x25,
	0xb0, 0xf7, 0xad, 0x60, 0x1c, 0x0b, 0xff, 0xff, 0x79, 0x8d, 0x86, 0xaf, 0xb9, 0x2b, 0x37, 0x53,
	0x47, 0xb3, 0x63, 0xd8, 0x37, 0x7c, 0x95, 0x87, 0xe3, 0xe4, 0x5e, 0x77, 0xb9, 0xe0, 0x73, 0xfa,
	0x57, 0x0f, 0xde, 0xa5, 0xa2, 0x5e, 0xbf, 0xab, 0x17, 0xbd, 0xaf, 0xbe, 0xf1, 0xe0, 0x52, 0x54,
	0x84, 0x97, 0x89, 0x90, 0x65, 0x5a, 0x22, 0xb7, 0x34, 0x4e, 0xdd, 0x15, 0x69, 0x98, 0x5a, 0xe3,
	0x1b, 0xe9, 0x64, 0xd5, 0xe5, 0xef, 0xc1, 0xdd, 0xec, 0x6c, 0xf4, 0x74, 0xfc, 0x47, 0xf0, 0xe8,
	0x99, 0xcb, 0x33, 0xb2, 0x45, 0x65, 0xd7, 0xb0, 0x67, 0xae, 0xa8, 0x2f, 0x8e, 0x4e, 0xdb, 0x40,
	0x93, 0x6d, 0x9b, 0xfd, 0xbd, 0x7f, 0x02, 0x00, 0x00, 0xff, 0xff, 0x7a, 0x8b, 0x03, 0xd0, 0x7b,
	0x0a, 0x00, 0x00,
}
