// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_RINGBUFFER_H
#define _GSTREAMERMM_RINGBUFFER_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2009 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/audio/gstringbuffer.h>
#include <gstreamermm/caps.h>
#include <gstreamermm/object.h>
#include <gstreamermm/format.h>
#include <glibmm/arrayhandle.h>
#include <memory>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstRingBuffer GstRingBuffer;
typedef struct _GstRingBufferClass GstRingBufferClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class RingBuffer_Class; } // namespace Gst
namespace Gst
{

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/**
 * @ingroup gstreamermmEnums
 */
enum RingBufferSegState
{
  SEGSTATE_INVALID,
  SEGSTATE_EMPTY,
  SEGSTATE_FILLED,
  SEGSTATE_PARTIAL
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::RingBufferSegState> : public Glib::Value_Enum<Gst::RingBufferSegState>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{

/**
 * @ingroup gstreamermmEnums
 */
enum RingBufferState
{
  RING_BUFFER_STATE_STOPPED,
  RING_BUFFER_STATE_PAUSED,
  RING_BUFFER_STATE_STARTED
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::RingBufferState> : public Glib::Value_Enum<Gst::RingBufferState>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{

/**
 * @ingroup gstreamermmEnums
 */
enum BufferFormat
{
  UNKNOWN,
  S8,
  U8,
  S16_LE,
  S16_BE,
  U16_LE,
  U16_BE,
  S24_LE,
  S24_BE,
  U24_LE,
  U24_BE,
  S32_LE,
  S32_BE,
  U32_LE,
  U32_BE,
  S24_3LE,
  S24_3BE,
  U24_3LE,
  U24_3BE,
  S20_3LE,
  S20_3BE,
  U20_3LE,
  U20_3BE,
  S18_3LE,
  S18_3BE,
  U18_3LE,
  U18_3BE,
  FLOAT32_LE,
  FLOAT32_BE,
  FLOAT64_LE,
  FLOAT64_BE,
  MU_LAW,
  A_LAW,
  IMA_ADPCM,
  MPEG,
  GSM,
  IEC958,
  AC3,
  EAC3,
  DTS,
  MPEG2_AAC,
  MPEG4_AAC
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::BufferFormat> : public Glib::Value_Enum<Gst::BufferFormat>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{

/**
 * @ingroup gstreamermmEnums
 */
enum BufferFormatType
{
  BUFTYPE_LINEAR,
  BUFTYPE_FLOAT,
  BUFTYPE_MU_LAW,
  BUFTYPE_A_LAW,
  BUFTYPE_IMA_ADPCM,
  BUFTYPE_MPEG,
  BUFTYPE_GSM,
  BUFTYPE_IEC958,
  BUFTYPE_AC3,
  BUFTYPE_EAC3,
  BUFTYPE_DTS,
  BUFTYPE_MPEG2_AAC,
  BUFTYPE_MPEG4_AAC
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::BufferFormatType> : public Glib::Value_Enum<Gst::BufferFormatType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{


/** A class containing the format specification of a Gst::RingBuffer.
 * Gst::RingBufferSpec contains the format specification of a Gst::RingBuffer.
 * The "in" members should be specified by the caller of the
 * Gst::RingBuffer::acquire() method while the "in/out" members may be set by
 * the caller but are also modifiable by Gst::RingBuffer::acquire().  The
 * "out" members are generated as a result of the call to
 * Gst::RingBuffer::acquire().
 * @see Gst::RingBuffer::acquire().
 */
class RingBufferSpec
{
    public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef RingBufferSpec CppObjectType;
  typedef GstRingBufferSpec BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
  /** Default constructor.
   * @throw std::runtime_error if memory is unavailable for the new
   * Gst::RingBufferSpec.
   */
  RingBufferSpec();

  /** Fully construct a Gst::RingBufferSpec.  Only the "(in)" parameters are
   * required.  The "(in/out)" parameters are optional and may be modified by
   * the call to the Gst::RingBuffer::acquire() method.
   * @param caps The caps of the buffer (in).
   * @param type The sample type (in/out).
   * @param format The sample format (in/out).
   * @param sign The sample sign (in/out).
   * @param bigend The endianness of the samples (in/out).
   * @param width The width of the samples (in/out).
   * @param depth The depth of the samples (in/out).
   * @param rate The sample rate (in/out).
   * @param channels The number of channels (in/out).
   * @param latency_time The latency in microseconds (in/out).
   * @param buffer_time The total buffer size in microseconds (in/out).
   * @param segsize The size of one segment in bytes (in/out).
   * @param segtotal The total number of segments (in/out).
   * @param seglatency Number of segments queued in the lower level device,
   * defaults to @a segtotal in the C API (in/out).
   *
   * @throw std::runtime_error if memory is unavailable for the new
   * Gst::RingBufferSpec.
   */
  RingBufferSpec(const Glib::RefPtr<Gst::Caps>& caps,
    Gst::BufferFormatType type = Gst::BUFTYPE_LINEAR,
    Gst::BufferFormat format = Gst::UNKNOWN, bool sign = false,
    bool bigend = false, int width = 0, int depth = 0, int rate = 0,
    int channels = 0, guint64 latency_time = 0, guint64 buffer_time = 0,
    int segsize = 0, int segtotal = 0, int seglatency = 0);

  /// Construct a Gst::RingBufferSpec from a GstRingBufferSpec.
  explicit RingBufferSpec(GstRingBufferSpec& castitem,
    bool take_ownership = false);

  /** Copy constructor.
   *
   * @throw std::runtime_error if memory is unavailable for the new
   * Gst::RingBufferSpec.
   */
  RingBufferSpec(const RingBufferSpec& other);

  /// Assignment operator.
  RingBufferSpec& operator=(const RingBufferSpec& other);

  /// Destructor.
  virtual ~RingBufferSpec();

  void swap(RingBufferSpec& other);

  /// Gets the underlying gobject.
  GstRingBufferSpec* gobj() { return m_spec; };

  /// Gets the underlying gobject.
  const GstRingBufferSpec* gobj() const { return m_spec; };

  /** Get the caps of the buffer (in). */
   Glib::RefPtr<Gst::Caps> get_caps();
  Glib::RefPtr<const Gst::Caps> get_caps() const;
 
  /** Set the caps of the buffer (in). */
   void set_caps(const Glib::RefPtr<Gst::Caps>& value);
 
  /** Get the sample type (in/out).
   */
   Gst::BufferFormatType get_type() const;
 
  /** Set the sample type (in/out).
   */
   void set_type(const Gst::BufferFormatType& value);
 
  /** Get the sample format (in/out).
   */
   Gst::BufferFormat get_format() const;
 
  /** Set the sample format (in/out).
   */
   void set_format(const Gst::BufferFormat& value);
 
  /** Get the sample sign (in/out).
   */
   bool get_sign() const;
 
  /** Set the sample sign (in/out).
   */
   void set_sign(const bool& value);
 
  /** Get the endianness of the samples (in/out).
   */
   bool get_bigend() const;
 
  /** Set the endianness of the samples (in/out).
   */
   void set_bigend(const bool& value);
 
  /** Get the width of the samples (in/out).
   */
   int get_width() const;
 
  /** Set the width of the samples (in/out).
   */
   void set_width(const int& value);
 
  /** Get the depth of the samples (in/out).
   */
   int get_depth() const;
 
  /** Set the depth of the samples (in/out).
   */
   void set_depth(const int& value);
 
  /** Get the samplerate (in/out).
   */
   int get_rate() const;
 
  /** Set the samplerate (in/out).
   */
   void set_rate(const int& value);
 
  /** Get the number of channels (in/out).
   */
   int get_channels() const;
 
  /** Set the number of channels (in/out).
   */
   void set_channels(const int& value);
 
  /** Get the latency in microseconds (in/out).
   */
   guint64 get_latency_time() const;
 
  /** Set the latency in microseconds (in/out).
   */
   void set_latency_time(const guint64& value);
 
  /** Get the total buffer size in microseconds (in/out).
   */
   guint64 get_buffer_time() const;
 
  /** Set the total buffer size in microseconds (in/out).
   */
   void set_buffer_time(const guint64& value);
 
  /** Get the size of one segment in bytes (in/out).
   */
   int get_segsize() const;
 
  /** Set the size of one segment in bytes (in/out).
   */
   void set_segsize(const int& value);
 
  /** Get the total number of segments (in/out).
   */
   int get_segtotal() const;
 
  /** Set the total number of segments (in/out).
   */
   void set_segtotal(const int& value);
 
  /** Get the number of segments queued in the lower level device, defaults to
   * segtotal (in/out).
   */
   int get_seglatency() const;
 
  /** Set the number of segments queued in the lower level device, defaults to
   * segtotal (in/out).
   */
   void set_seglatency(const int& value);
 
  /** Get the number of bytes of one sample (out).  This is set by the call to
   * Gst::RingBuffer::acquire().
   */
   int get_bytes_per_sample() const;
 
  /** Set the number of bytes of one sample (out).  This is set by the call to
   * Gst::RingBuffer::acquire() and should probably not be set.
   */
   void set_bytes_per_sample(const int& value);
 
// This constant is obtained from the "silence_sample" member in the
// GstRingBufferSpec structure definition.
#define GSTREAMERMM_RING_BUFFER_SPEC_SILENCE_SAMPLE 32

 
  /** Get the bytes representing one sample of silence (out).  This is set by
   * the call to Gst::RingBuffer::acquire().
   */
   Glib::ArrayHandle<guint8> get_silence_sample() const;
 
  /** Sets the bytes representing one sample of silence (out).  This is set by
   * the call to Gst::RingBuffer::acquire() and probably should not be set.
   */
  void set_silence_sample(const Glib::ArrayHandle<guint8>& silence_sample);

protected:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  GstRingBufferSpec* m_spec;
  // Tells whether the m_spec member should be freed upon destruction.
  bool take_ownership;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


};

/** A base class for audio ringbuffer implementations.
 * This object is the base class for audio ringbuffers used by the base audio
 * source and sink classes.
 *
 * The ringbuffer abstracts a circular buffer of data. One reader and one
 * writer can operate on the data from different threads in a lockfree manner.
 * The base class is sufficiently flexible to be used as an abstraction for
 * DMA based ringbuffers as well as a pure software implementations.
 *
 * Last reviewed on 2006-02-02 (0.10.4).
 * @ingroup GstBaseClasses
 */

class RingBuffer : public Gst::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef RingBuffer CppObjectType;
  typedef RingBuffer_Class CppClassType;
  typedef GstRingBuffer BaseObjectType;
  typedef GstRingBufferClass BaseClassType;

private:  friend class RingBuffer_Class;
  static CppClassType ringbuffer_class_;

private:
  // noncopyable
  RingBuffer(const RingBuffer&);
  RingBuffer& operator=(const RingBuffer&);

protected:
  explicit RingBuffer(const Glib::ConstructParams& construct_params);
  explicit RingBuffer(GstRingBuffer* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~RingBuffer();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstRingBuffer*       gobj()       { return reinterpret_cast<GstRingBuffer*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstRingBuffer* gobj() const { return reinterpret_cast<GstRingBuffer*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstRingBuffer* gobj_copy();

private:


public:
  /** For example,
   * bool on_fill(const Glib::RefPtr<Gst::RingBuffer>& rbuf,
   * const std::vector<guint8>& data, guint len);.
   * This slot is set with set_fill_slot() and is called to fill the memory at
   * data with len bytes of samples.
   */
  typedef sigc::slot<void, const Glib::ArrayHandle<guint8>&, guint> SlotFill;

  //TODO: _MEMBER_GET(cond, cond, Glib::Cond, GCond*)

  /** Sets the given fill slot on the buffer. The slot will be called every
   * time a segment has been written to a device.
   *
   * MT safe.
   *
   * @param slot The fill slot to set.
   */
  void set_fill_slot(const SlotFill& slot);
  

  /** Allocate the resources for the ringbuffer. This function fills
   * in the data pointer of the ring buffer with a valid Gst::Buffer
   * to which samples can be written.
   * @param spec The specs of the buffer.
   * @return <tt>true</tt> if the device could be acquired, <tt>false</tt> on error.
   * 
   * MT safe.
   */
  bool acquire(Gst::RingBufferSpec& spec);
  
  /** Free the resources of the ringbuffer.
   * @return <tt>true</tt> if the device could be released, <tt>false</tt> on error.
   * 
   * MT safe.
   */
  bool release();
  
  /** Check if the ringbuffer is acquired and ready to use.
   * @return <tt>true</tt> if the ringbuffer is acquired, <tt>false</tt> on error.
   * 
   * MT safe.
   */
  bool is_acquired() const;
  
  /** Activate @a buf to start or stop pulling data.
   * 
   * MT safe.
   * @param active The new mode.
   * @return <tt>true</tt> if the device could be activated in the requested mode,
   * <tt>false</tt> on error.
   */
  bool activate(bool active);
  
  /** Check if @a buf is activated.
   * 
   * MT safe.
   * @return <tt>true</tt> if the device is active.
   */
  bool is_active() const;
  
  /** Start processing samples from the ringbuffer.
   * @return <tt>true</tt> if the device could be started, <tt>false</tt> on error.
   * 
   * MT safe.
   */
  bool start();
  
  /** Pause processing samples from the ringbuffer.
   * @return <tt>true</tt> if the device could be paused, <tt>false</tt> on error.
   * 
   * MT safe.
   */
  bool pause();
  
  /** Stop processing samples from the ringbuffer.
   * @return <tt>true</tt> if the device could be stopped, <tt>false</tt> on error.
   * 
   * MT safe.
   */
  bool stop();
  
  /** Get the number of samples queued in the audio device. This is
   * usually less than the segment size but can be bigger when the
   * implementation uses another internal buffer between the audio
   * device.
   * 
   * For playback ringbuffers this is the amount of samples transfered from the
   * ringbuffer to the device but still not played.
   * 
   * For capture ringbuffers this is the amount of samples in the device that are
   * not yet transfered to the ringbuffer.
   * @return The number of samples queued in the audio device.
   * 
   * MT safe.
   */
  guint get_delay() const;
  
  /** Get the number of samples that were processed by the ringbuffer
   * since it was last started. This does not include the number of samples not
   * yet processed (see delay()).
   * @return The number of samples processed by the ringbuffer.
   * 
   * MT safe.
   */
  guint64 get_samples_done() const;
  
  /** Make sure that the next sample written to the device is
   * accounted for as being the @a sample sample written to the
   * device. This value will be used in reporting the current
   * sample position of the ringbuffer.
   * 
   * This function will also clear the buffer with silence.
   * 
   * MT safe.
   * @param sample The sample number to set.
   */
  void set_sample(guint64 sample);

 
  /** Same as commit_full() but with a in_samples and out_samples
   * equal to @a len, ignoring accum.
   * @param sample The sample position of the data.
   * @param data The data to commit.
   * @param len The number of samples in the data to commit.
   * @return The number of samples written to the ringbuffer or -1 on
   * error.
   * 
   * MT safe.
   */
  guint commit(guint64 sample, const Glib::ArrayHandle<guchar>& data, guint len);
  
  /** Commit @a in_samples samples pointed to by @a data to the ringbuffer @a buf. 
   * 
   *  @a in_samples and @a out_samples define the rate conversion to perform on the
   * samples in @a data. For negative rates, @a out_samples must be negative and
   *  @a in_samples positive.
   * 
   * When @a out_samples is positive, the first sample will be written at position @a sample
   * in the ringbuffer. When @a out_samples is negative, the last sample will be written to
   *  @a sample in reverse order.
   * 
   *  @a out_samples does not need to be a multiple of the segment size of the ringbuffer
   * although it is recommended for optimal performance. 
   * 
   *  @a accum will hold a temporary accumulator used in rate conversion and should be
   * set to 0 when this function is first called. In case the commit operation is
   * interrupted, one can resume the processing by passing the previously returned
   *  @a accum value back to this function.
   * 
   * MT safe.
   * @param sample The sample position of the data.
   * @param data The data to commit.
   * @param in_samples The number of samples in the data to commit.
   * @param out_samples The number of samples to write to the ringbuffer.
   * @param accum Accumulator for rate conversion.
   * @return The number of samples written to the ringbuffer or -1 on error. The
   * number of samples written can be less than @a out_samples when @a buf was interrupted
   * with a flush or stop.
   */
  guint commit(guint64& sample, const Glib::ArrayHandle<guchar>& data, int in_samples, int out_samples, int& accum);

  
  /** Convert @a src_val in @a src_fmt to the equivalent value in @a dest_fmt. The result
   * will be put in @a dest_val.
   * @param src_fmt The source format.
   * @param src_val The source value.
   * @param dest_fmt The destination format.
   * @param dest_val A location to store the converted value.
   * @return <tt>true</tt> if the conversion succeeded.
   */
  bool convert(Gst::Format src_fmt, gint64 src_val, Gst::Format dest_fmt, gint64& dest_val) const;

  
  /** Returns a pointer to memory where the data from segment @a segment
   * can be found. This function is mostly used by subclasses.
   * @param segment The segment to read.
   * @param readptr The pointer to the memory where samples can be read.
   * @param len The number of bytes to read.
   * @return <tt>false</tt> if the buffer is not started.
   * 
   * MT safe.
   */

  bool prepare_read(int& segment, std::vector<guint8>& readptr, int& len);

  
  /** Read @a len samples from the ringbuffer into the memory pointed 
   * to by @a data.
   * The first sample should be read from position @a sample in
   * the ringbuffer.
   * 
   *  @a len should not be a multiple of the segment size of the ringbuffer
   * although it is recommended.
   * @param sample The sample position of the data.
   * @param data Where the data should be read.
   * @param len The number of samples in data to read.
   * @return The number of samples read from the ringbuffer or -1 on
   * error.
   * 
   * MT safe.
   */
  guint read(guint64 sample, const Glib::ArrayHandle<guchar>& data, guint len);

  
  /** Clear the given segment of the buffer with silence samples.
   * This function is used by subclasses.
   * 
   * MT safe.
   * @param segment The segment to clear.
   */
  void clear(int segment);
  
  /** Fill the ringbuffer with silence.
   * 
   * MT safe.
   */
  void clear_all();
  
  /** Subclasses should call this function to notify the fact that 
   *  @a advance segments are now processed by the device.
   * 
   * MT safe.
   * @param advance The number of segments written.
   */
  void advance(guint advance);
  
  /** Close the audio device associated with the ring buffer. The ring buffer
   * should already have been released via release().
   * @return <tt>true</tt> if the device could be closed, <tt>false</tt> on error.
   * 
   * MT safe.
   */
  bool close_device();
  
  /** Open the audio device associated with the ring buffer. Does not perform any
   * setup on the device. You must open the device before acquiring the ring
   * buffer.
   * @return <tt>true</tt> if the device could be opened, <tt>false</tt> on error.
   * 
   * MT safe.
   */
  bool open_device();
  
  /** Checks the status of the device associated with the ring buffer.
   * @return <tt>true</tt> if the device was open, <tt>false</tt> if it was closed.
   * 
   * MT safe.
   */
  bool device_is_open() const;
  
  /** Tell the ringbuffer that it is allowed to start playback when
   * the ringbuffer is filled with samples. 
   * 
   * MT safe.
   * @param allowed The new value.
   */
  void set_may_start(bool allowed);
  
  /** Parse @a caps into @a spec.
   * @param spec A spec.
   * @param caps A Gst::Caps.
   * @return <tt>true</tt> if the caps could be parsed.
   */
  static bool parse_caps(Gst::RingBufferSpec& p1, const Glib::RefPtr<Gst::Caps>& caps);
  
  /** Set the ringbuffer to flushing mode or normal mode.
   * 
   * MT safe.
   * @param flushing The new mode.
   */
  void set_flushing(bool flushing);

  /** Virtual function to open the device.  Don't set any params or allocate
   * anything.
   */
    virtual bool open_device_vfunc();


  /** Virtual function to allocate the resources for the ring buffer using the
   * given spec.
   */
  virtual bool acquire_vfunc(Gst::RingBufferSpec& spec);

  /** Virtual function to free resources of the ring buffer.
   */
    virtual bool release_vfunc();


  /** Virtual function to close the device.
   */
    virtual bool close_device_vfunc();


  /** Virtual function to start processing of samples.
   */
    virtual bool start_vfunc();


  /** Virtual function to pause processing of samples.
   */
    virtual bool pause_vfunc();


  /** Virtual function to resume processing of samples after pause.
   */
    virtual bool resume_vfunc();


  /** Virtual function to stop processing of samples.
   */
    virtual bool stop_vfunc();


  /** Virtual function to get number of samples queued in device.
   */
    virtual guint delay_vfunc();


  /** Virtual function to activate the thread that starts pulling and
   * monitoring the consumed segments in the device. Since 0.10.22.
   */
    virtual bool activate_vfunc(bool active);


  /** Virtual function to write samples into the ring buffer.
   */
  virtual guint commit_vfunc(guint64& sample, const Glib::ArrayHandle<guchar>& data, int in_samples, int out_samples, int& accum);

  /** Virtual function to clear the entire ringbuffer Since 0.10.24.
   */
    virtual void clear_all_vfunc();


protected:

  
#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:
  std::auto_ptr<SlotFill> m_slot;
#endif


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::RingBuffer
   */
  Glib::RefPtr<Gst::RingBuffer> wrap(GstRingBuffer* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_RINGBUFFER_H */

