"""
GTSAM Copyright 2010-2019, Georgia Tech Research Corporation,
Atlanta, Georgia 30332-0415
All Rights Reserved
See LICENSE for the license information
Rot3 unit tests.
Author: John Lambert
"""
# pylint: disable=no-name-in-module

import unittest

import numpy as np

import gtsam
from gtsam import Point3, Rot3, Unit3
from gtsam.utils.test_case import GtsamTestCase


R1_R2_pairs = [
    (
        [
            [0.994283, -0.10356, 0.0260251],
            [0.102811, 0.994289, 0.0286205],
            [-0.0288404, -0.0257812, 0.999251],
        ],
        [
            [-0.994235, 0.0918291, -0.0553602],
            [-0.0987317, -0.582632, 0.806718],
            [0.0418251, 0.807532, 0.588339],
        ],
    ),
    (
        [
            [0.999823, -0.000724729, 0.0187896],
            [0.00220672, 0.996874, -0.0789728],
            [-0.0186736, 0.0790003, 0.9967],
        ],
        [
            [-0.99946, -0.0155217, -0.0289749],
            [-0.0306159, 0.760422, 0.648707],
            [0.0119641, 0.649244, -0.760487],
        ],
    ),
    (
        [
            [0.999976, 0.00455542, -0.00529608],
            [-0.00579633, 0.964214, -0.265062],
            [0.00389908, 0.265086, 0.964217],
        ],
        [
            [-0.999912, -0.0123323, -0.00489179],
            [-0.00739095, 0.21159, 0.977331],
            [-0.0110179, 0.977281, -0.211663],
        ],
    ),
    (
        [
            [0.998801, 0.0449026, 0.019479],
            [-0.0448727, 0.998991, -0.00197348],
            [-0.0195479, 0.00109704, 0.999808],
        ],
        [
            [-0.999144, -0.0406154, -0.00800012],
            [0.0406017, -0.999174, 0.00185875],
            [-0.00806909, 0.00153352, 0.999966],
        ],
    ),
    (
        [
            [0.587202, 0.00034062, -0.80944],
            [0.394859, 0.872825, 0.286815],
            [0.706597, -0.488034, 0.51239],
        ],
        [
            [-0.999565, -0.028095, -0.00905389],
            [0.0192863, -0.853838, 0.520182],
            [-0.0223455, 0.519782, 0.854007],
        ],
    ),
    (
        [
            [0.998798, 0.0370584, 0.0320815],
            [-0.0355966, 0.998353, -0.0449943],
            [-0.033696, 0.0437982, 0.998472],
        ],
        [
            [-0.999942, -0.010745, -0.00132538],
            [-0.000998705, -0.0304045, 0.999538],
            [-0.0107807, 0.999481, 0.0303914],
        ],
    ),
    (
        [
            [0.998755, 0.00708291, -0.0493744],
            [-0.00742097, 0.99995, -0.00666709],
            [0.0493247, 0.0070252, 0.998758],
        ],
        [
            [-0.998434, 0.0104672, 0.0549825],
            [0.0115323, 0.999751, 0.0190859],
            [-0.0547691, 0.01969, -0.998307],
        ],
    ),
    (
        [
            [0.990471, 0.0997485, -0.0949595],
            [-0.117924, 0.970427, -0.210631],
            [0.0711411, 0.219822, 0.972943],
        ],
        [
            [-0.99192, -0.125627, 0.0177888],
            [0.126478, -0.967866, 0.217348],
            [-0.0100874, 0.217839, 0.975933],
        ],
    ),
    (
        [
            [-0.780894, -0.578319, -0.236116],
            [0.34478, -0.0838381, -0.934932],
            [0.520894, -0.811491, 0.264862],
        ],
        [
            [-0.99345, 0.00261746, -0.114244],
            [-0.112503, 0.152922, 0.981815],
            [0.0200403, 0.988236, -0.151626],
        ],
    ),
    (
        [
            [0.968425, 0.0466097, 0.244911],
            [-0.218867, 0.629346, 0.745668],
            [-0.119378, -0.775726, 0.619676],
        ],
        [
            [-0.971208, 0.00666431, -0.238143],
            [0.0937886, 0.929584, -0.35648],
            [0.218998, -0.368551, -0.903444],
        ],
    ),
    (
        [
            [0.998512, 0.0449168, -0.0309146],
            [-0.0344032, 0.958823, 0.281914],
            [0.0423043, -0.280431, 0.958941],
        ],
        [
            [-0.999713, 0.00732431, 0.0228168],
            [-0.00759688, 0.806166, -0.59164],
            [-0.0227275, -0.591644, -0.805879],
        ],
    ),
    (
        [
            [0.981814, 0.00930728, 0.189617],
            [-0.0084101, 0.999949, -0.00553563],
            [-0.189659, 0.00384026, 0.981843],
        ],
        [
            [-0.981359, 0.00722349, -0.192051],
            [0.00148564, 0.999549, 0.0300036],
            [0.192182, 0.0291591, -0.980927],
        ],
    ),
    (
        [
            [0.972544, -0.215591, 0.0876242],
            [0.220661, 0.973915, -0.0529018],
            [-0.0739333, 0.0707846, 0.994748],
        ],
        [
            [-0.971294, 0.215675, -0.100371],
            [-0.23035, -0.747337, 0.62324],
            [0.0594069, 0.628469, 0.775564],
        ],
    ),
    (
        [
            [0.989488, 0.0152447, 0.143808],
            [-0.0160974, 0.999859, 0.00476753],
            [-0.143715, -0.00703235, 0.989594],
        ],
        [
            [-0.988492, 0.0124362, -0.150766],
            [0.00992423, 0.999799, 0.0174037],
            [0.150952, 0.0157072, -0.988417],
        ],
    ),
    (
        [
            [0.99026, 0.109934, -0.0854388],
            [-0.0973012, 0.985345, 0.140096],
            [0.099588, -0.130418, 0.986445],
        ],
        [
            [-0.994239, 0.0206112, 0.1052],
            [0.0227944, 0.999548, 0.0195944],
            [-0.104748, 0.0218794, -0.994259],
        ],
    ),
    (
        [
            [0.988981, 0.132742, -0.0655406],
            [-0.113134, 0.963226, 0.243712],
            [0.0954813, -0.233612, 0.96763],
        ],
        [
            [-0.989473, -0.144453, 0.00888153],
            [0.112318, -0.727754, 0.67658],
            [-0.0912697, 0.670455, 0.736317],
        ],
    ),
    (
        [
            [0.13315, -0.722685, 0.678231],
            [0.255831, 0.686195, 0.680946],
            [-0.957508, 0.0828446, 0.276252],
        ],
        [
            [-0.233019, 0.0127274, -0.97239],
            [-0.0143824, 0.99976, 0.0165321],
            [0.972367, 0.0178377, -0.23278],
        ],
    ),
    (
        [
            [0.906305, -0.0179617, -0.422243],
            [0.0246095, 0.999644, 0.0102984],
            [0.421908, -0.0197247, 0.906424],
        ],
        [
            [-0.90393, 0.0136293, 0.427466],
            [0.0169755, 0.999848, 0.0040176],
            [-0.427346, 0.0108879, -0.904024],
        ],
    ),
    (
        [
            [0.999808, 0.0177784, -0.00826505],
            [-0.0177075, 0.999806, 0.00856939],
            [0.0084158, -0.00842139, 0.999929],
        ],
        [
            [-0.999901, -0.0141114, 0.00072392],
            [0.00130602, -0.0413336, 0.999145],
            [-0.0140699, 0.999047, 0.0413473],
        ],
    ),
    (
        [
            [0.985811, -0.161425, 0.0460375],
            [0.154776, 0.980269, 0.12295],
            [-0.0649764, -0.11408, 0.991344],
        ],
        [
            [-0.985689, 0.137931, -0.09692],
            [-0.162627, -0.626622, 0.762168],
            [0.0443951, 0.767022, 0.640085],
        ],
    ),
    (
        [
            [0.956652, -0.0116044, 0.291001],
            [0.05108, 0.990402, -0.128428],
            [-0.286718, 0.137726, 0.948064],
        ],
        [
            [-0.956189, 0.00996594, -0.292585],
            [-0.0397033, 0.985772, 0.16333],
            [0.29005, 0.167791, -0.942189],
        ],
    ),
    (
        [
            [0.783763, -0.0181248, -0.620796],
            [-0.0386421, 0.996214, -0.0778717],
            [0.619857, 0.0850218, 0.780095],
        ],
        [
            [-0.780275, 0.0093644, 0.625368],
            [-0.0221791, 0.998845, -0.0426297],
            [-0.625045, -0.0471329, -0.779165],
        ],
    ),
    (
        [
            [0.890984, 0.0232464, -0.453439],
            [-0.0221215, 0.999725, 0.00778511],
            [0.453495, 0.00309433, 0.891253],
        ],
        [
            [-0.890178, 0.0290103, 0.45469],
            [0.0337152, 0.999429, 0.0022403],
            [-0.454366, 0.0173244, -0.890648],
        ],
    ),
    (
        [
            [0.998177, -0.0119546, 0.0591504],
            [0.00277494, 0.988238, 0.152901],
            [-0.0602825, -0.152458, 0.98647],
        ],
        [
            [-0.997444, 0.00871865, -0.0709414],
            [0.0197108, 0.987598, -0.155762],
            [0.0687035, -0.156762, -0.985246],
        ],
    ),
    (
        [
            [0.985214, 0.164929, 0.0463837],
            [-0.166966, 0.984975, 0.0441225],
            [-0.0384096, -0.0512146, 0.997949],
        ],
        [
            [-0.999472, -0.000819214, -0.0325087],
            [-0.00344291, 0.99673, 0.0807324],
            [0.0323362, 0.0808019, -0.996206],
        ],
    ),
    (
        [
            [0.998499, 0.0465241, 0.0288955],
            [-0.0454764, 0.99832, -0.0359142],
            [-0.0305178, 0.0345463, 0.998937],
        ],
        [
            [-0.999441, 0.00412484, -0.0332105],
            [0.00374685, 0.999928, 0.0114307],
            [0.0332552, 0.0112999, -0.999384],
        ],
    ),
    (
        [
            [0.10101, -0.943239, -0.316381],
            [0.841334, -0.0887423, 0.533182],
            [-0.530994, -0.320039, 0.784615],
        ],
        [
            [-0.725665, 0.0153749, -0.687878],
            [-0.304813, 0.889109, 0.34143],
            [0.616848, 0.457438, -0.640509],
        ],
    ),
    (
        [
            [0.843428, 0.174952, 0.507958],
            [0.0435637, 0.920106, -0.389239],
            [-0.535473, 0.350423, 0.768422],
        ],
        [
            [-0.835464, 0.0040872, -0.549533],
            [0.00227251, 0.999989, 0.00398241],
            [0.549543, 0.00207845, -0.835464],
        ],
    ),
    (
        [
            [0.999897, -0.0142888, -0.00160177],
            [0.0141561, 0.997826, -0.064364],
            [0.00251798, 0.0643346, 0.997925],
        ],
        [
            [-0.999956, 0.00898988, 0.00296485],
            [0.00900757, 0.999941, 0.00601779],
            [-0.00291058, 0.00604429, -0.999978],
        ],
    ),
    (
        [
            [0.999477, -0.0204859, 0.0250096],
            [0.0126204, 0.959462, 0.281557],
            [-0.0297637, -0.281094, 0.959219],
        ],
        [
            [-0.999384, 0.0172602, -0.0305795],
            [-0.0254425, 0.24428, 0.969371],
            [0.0242012, 0.969551, -0.24369],
        ],
    ),
    (
        [
            [0.984597, 0.173474, -0.0218106],
            [-0.15145, 0.783891, -0.602145],
            [-0.0873592, 0.596173, 0.798089],
        ],
        [
            [-0.998608, -0.0432858, 0.0301827],
            [-0.00287128, 0.615692, 0.787983],
            [-0.0526917, 0.786797, -0.61496],
        ],
    ),
    (
        [
            [0.917099, -0.3072, 0.254083],
            [0.303902, 0.951219, 0.0531566],
            [-0.258018, 0.0284665, 0.965721],
        ],
        [
            [-0.931191, 0.347008, -0.111675],
            [-0.352102, -0.77686, 0.522032],
            [0.0943935, 0.52543, 0.845586],
        ],
    ),
    (
        [
            [0.991706, 0.0721037, -0.106393],
            [-0.0995017, 0.954693, -0.280464],
            [0.0813505, 0.288725, 0.95395],
        ],
        [
            [-0.995306, 0.00106317, 0.0967833],
            [0.0167662, 0.986717, 0.161583],
            [-0.0953259, 0.162447, -0.982103],
        ],
    ),
    (
        [
            [0.997078, 0.0478273, -0.0595641],
            [-0.0348316, 0.978617, 0.202719],
            [0.067986, -0.200052, 0.977424],
        ],
        [
            [-0.997925, -0.0439691, 0.0470461],
            [0.0643829, -0.695474, 0.715663],
            [0.00125305, 0.717207, 0.696861],
        ],
    ),
    (
        [
            [0.972749, -0.0233882, -0.230677],
            [0.0255773, 0.999652, 0.00650349],
            [0.230445, -0.0122264, 0.973009],
        ],
        [
            [-0.973286, 0.0147558, 0.229126],
            [0.0145644, 0.999891, -0.00252631],
            [-0.229138, 0.000878362, -0.973394],
        ],
    ),
    (
        [
            [0.999271, 0.00700481, 0.0375381],
            [-0.0348202, 0.57069, 0.820427],
            [-0.0156757, -0.821136, 0.570517],
        ],
        [
            [-0.999805, -0.0198049, 0.000539906],
            [0.0179848, -0.89584, 0.444015],
            [-0.00831113, 0.443938, 0.89602],
        ],
    ),
    (
        [
            [0.975255, -0.0207895, 0.220104],
            [0.0252764, 0.999526, -0.0175888],
            [-0.219634, 0.022717, 0.975318],
        ],
        [
            [-0.975573, 0.0128154, -0.219304],
            [0.0106554, 0.999882, 0.0110292],
            [0.219419, 0.00842303, -0.975594],
        ],
    ),
    (
        [
            [-0.433961, -0.658151, -0.615236],
            [0.610442, -0.717039, 0.336476],
            [-0.6626, -0.229548, 0.71293],
        ],
        [
            [-0.998516, -0.00675119, -0.054067],
            [-0.00405539, 0.99875, -0.0498174],
            [0.0543358, -0.0495237, -0.997296],
        ],
    ),
    (
        [
            [0.942764, -0.0126807, -0.333221],
            [-0.0017175, 0.999079, -0.042879],
            [0.333458, 0.0409971, 0.941873],
        ],
        [
            [-0.942228, -0.0109444, 0.334798],
            [0.0110573, 0.997905, 0.0637396],
            [-0.334794, 0.0637589, -0.940133],
        ],
    ),
    (
        [
            [0.962038, 0.0147987, 0.272515],
            [-0.0185974, 0.999762, 0.0113615],
            [-0.272283, -0.0159982, 0.962084],
        ],
        [
            [-0.959802, 0.0113708, -0.280451],
            [0.00982126, 0.999928, 0.00692958],
            [0.280509, 0.00389678, -0.959845],
        ],
    ),
    (
        [
            [0.998414, 0.0139348, 0.0545528],
            [-0.0226877, 0.986318, 0.163283],
            [-0.0515311, -0.164262, 0.98507],
        ],
        [
            [-0.998641, -0.000695993, -0.0521343],
            [0.0182534, 0.931965, -0.362087],
            [0.0488394, -0.362547, -0.930686],
        ],
    ),
    (
        [
            [0.999705, -0.0234518, -0.00633743],
            [0.0235916, 0.999458, 0.0229643],
            [0.00579544, -0.023107, 0.999716],
        ],
        [
            [-0.999901, 0.004436, 0.0133471],
            [-0.00306106, 0.85758, -0.514342],
            [-0.0137278, -0.514332, -0.857481],
        ],
    ),
    (
        [
            [0.998617, -0.051704, 0.0094837],
            [0.0484292, 0.975079, 0.216506],
            [-0.0204416, -0.215748, 0.976235],
        ],
        [
            [-0.999959, -0.00295958, -0.00862907],
            [-0.00313279, 0.999792, 0.0201361],
            [0.00856768, 0.0201625, -0.999761],
        ],
    ),
    (
        [
            [0.999121, 0.0345472, -0.023733],
            [-0.0333175, 0.998174, 0.0503881],
            [0.0254304, -0.0495531, 0.998448],
        ],
        [
            [-0.999272, -0.0337466, 0.0178065],
            [0.0200629, -0.0677624, 0.9975],
            [-0.0324556, 0.997131, 0.0683898],
        ],
    ),
    (
        [
            [0.989017, 0.139841, -0.0478525],
            [-0.131355, 0.683201, -0.718319],
            [-0.0677572, 0.716715, 0.694067],
        ],
        [
            [-0.995236, 0.00457798, 0.097401],
            [0.097488, 0.0258334, 0.994902],
            [0.00203912, 0.999657, -0.0261574],
        ],
    ),
    (
        [
            [0.961528, 0.249402, 0.11516],
            [-0.204522, 0.9298, -0.306009],
            [-0.183395, 0.270684, 0.945038],
        ],
        [
            [-0.999566, -0.0233216, 0.0180679],
            [0.012372, 0.224583, 0.974377],
            [-0.0267822, 0.974177, -0.224197],
        ],
    ),
    (
        [
            [0.865581, 0.0252563, -0.500131],
            [0.0302583, 0.994265, 0.102578],
            [0.499853, -0.103923, 0.859853],
        ],
        [
            [-0.866693, 0.0042288, 0.498824],
            [0.0129331, 0.999818, 0.0139949],
            [-0.498674, 0.0185807, -0.866591],
        ],
    ),
    (
        [
            [0.998999, -0.0213419, -0.0393009],
            [-0.0007582, 0.870578, -0.492031],
            [0.0447153, 0.491568, 0.86969],
        ],
        [
            [-0.999207, -0.0184688, 0.0353073],
            [0.00153266, 0.867625, 0.497218],
            [-0.0398164, 0.496876, -0.866908],
        ],
    ),
    (
        [
            [0.96567, -0.00482973, 0.259728],
            [0.00349956, 0.999978, 0.00558359],
            [-0.259749, -0.00448297, 0.965666],
        ],
        [
            [-0.962691, -0.00113074, -0.270609],
            [-5.93716e-05, 0.999992, -0.00396767],
            [0.270612, -0.00380337, -0.962683],
        ],
    ),
    (
        [
            [0.948799, 0.287027, -0.131894],
            [-0.300257, 0.949181, -0.0943405],
            [0.0981135, 0.129112, 0.986764],
        ],
        [
            [-0.993593, -0.0406684, 0.105449],
            [-0.0506857, 0.994269, -0.0941326],
            [-0.101017, -0.0988741, -0.98996],
        ],
    ),
    (
        [
            [0.998935, 0.0451118, 0.0097202],
            [-0.0418086, 0.973879, -0.223183],
            [-0.0195345, 0.222539, 0.974728],
        ],
        [
            [-0.999821, 0.00821522, -0.0170658],
            [0.00742187, 0.998912, 0.046048],
            [0.0174255, 0.0459131, -0.998794],
        ],
    ),
    (
        [
            [0.99577, 0.00458459, 0.0917705],
            [-0.00244288, 0.999722, -0.0234365],
            [-0.0918524, 0.0231131, 0.995504],
        ],
        [
            [-0.995956, 0.0137721, -0.0887945],
            [0.0122932, 0.999777, 0.0171801],
            [0.0890113, 0.0160191, -0.995903],
        ],
    ),
    (
        [
            [0.97931, 0.0219899, 0.201169],
            [-0.0159226, 0.99937, -0.0317288],
            [-0.201739, 0.0278692, 0.979043],
        ],
        [
            [-0.980952, 0.00507266, -0.19419],
            [0.00310821, 0.999941, 0.010419],
            [0.194231, 0.00961706, -0.98091],
        ],
    ),
    (
        [
            [0.999616, 0.00550326, -0.0271537],
            [-0.0048286, 0.99968, 0.0248495],
            [0.0272817, -0.0247088, 0.999322],
        ],
        [
            [-0.999689, -0.00054899, 0.0249588],
            [-0.00125497, 0.999599, -0.0282774],
            [-0.0249333, -0.0282998, -0.999289],
        ],
    ),
    (
        [
            [0.998036, -0.00755259, -0.0621791],
            [0.0417502, 0.820234, 0.570502],
            [0.0466927, -0.571978, 0.818939],
        ],
        [
            [-0.999135, -0.0278203, 0.0309173],
            [-0.00855238, 0.864892, 0.501886],
            [-0.0407029, 0.501187, -0.864382],
        ],
    ),
    (
        [
            [0.958227, 0.00271545, 0.285997],
            [-0.00426128, 0.999979, 0.00478282],
            [-0.285979, -0.00580174, 0.958218],
        ],
        [
            [-0.958726, 0.011053, -0.284121],
            [0.0138068, 0.999875, -0.00769161],
            [0.284001, -0.0112968, -0.958759],
        ],
    ),
    (
        [
            [-0.804547, -0.48558, -0.341929],
            [0.517913, -0.855425, -0.00382581],
            [-0.290637, -0.180168, 0.939718],
        ],
        [
            [0.993776, -0.0469383, -0.101033],
            [-0.110087, -0.274676, -0.955214],
            [0.0170842, 0.96039, -0.278134],
        ],
    ),
    (
        [
            [0.991875, -0.0022313, -0.127195],
            [-0.00198041, 0.999454, -0.0329762],
            [0.127199, 0.0329602, 0.991329],
        ],
        [
            [-0.992632, -0.0090772, 0.120844],
            [-0.00870494, 0.999956, 0.00360636],
            [-0.120871, 0.00252786, -0.992667],
        ],
    ),
    (
        [
            [0.999305, -0.0252534, 0.0274367],
            [0.026144, 0.999126, -0.0326002],
            [-0.0265895, 0.0332948, 0.999092],
        ],
        [
            [-0.999314, -0.0038532, -0.0368519],
            [-0.00441323, 0.999876, 0.0151263],
            [0.036789, 0.0152787, -0.999207],
        ],
    ),
    (
        [
            [0.999843, -0.00958823, 0.0148803],
            [0.00982469, 0.999825, -0.0159002],
            [-0.0147253, 0.0160439, 0.999763],
        ],
        [
            [-0.999973, 0.00673608, -0.00308692],
            [-0.0067409, -0.999977, 0.00116827],
            [-0.00307934, 0.00119013, 0.999995],
        ],
    ),
    (
        [
            [0.981558, -0.00727741, 0.191028],
            [-0.00866166, 0.996556, 0.0824708],
            [-0.190971, -0.0826044, 0.978114],
        ],
        [
            [-0.980202, 0.0179519, -0.197188],
            [0.00957606, 0.999014, 0.0433472],
            [0.197772, 0.0406008, -0.979408],
        ],
    ),
    (
        [
            [0.966044, 0.0143709, 0.257977],
            [-0.0157938, 0.999869, 0.00344404],
            [-0.257894, -0.00740153, 0.966145],
        ],
        [
            [-0.965532, 0.0100318, -0.260094],
            [0.00950897, 0.999949, 0.00326797],
            [0.260113, 0.000682242, -0.965579],
        ],
    ),
    (
        [
            [0.999965, 0.00727991, -0.00412134],
            [-0.00802642, 0.973769, -0.227397],
            [0.00235781, 0.227422, 0.973794],
        ],
        [
            [-0.999877, 0.00698241, 0.0141441],
            [0.0103867, 0.966295, 0.257228],
            [-0.0118713, 0.257343, -0.966248],
        ],
    ),
    (
        [
            [0.951385, -0.0297966, 0.306561],
            [-0.0314555, 0.980706, 0.19294],
            [-0.306395, -0.193204, 0.932092],
        ],
        [
            [-0.99981, 0.00389172, -0.0191159],
            [-0.00386326, -0.999991, -0.00150593],
            [-0.0191215, -0.00143146, 0.999816],
        ],
    ),
    (
        [
            [0.986772, -0.120673, 0.10825],
            [0.0543962, 0.875511, 0.480126],
            [-0.152713, -0.467887, 0.870495],
        ],
        [
            [-0.991246, 0.125848, -0.0399414],
            [-0.129021, -0.85897, 0.495507],
            [0.0280503, 0.496321, 0.867686],
        ],
    ),
    (
        [
            [-0.804799, -0.588418, 0.0778637],
            [-0.514399, 0.756902, 0.403104],
            [-0.296129, 0.284365, -0.911836],
        ],
        [
            [0.98676, -0.0939473, 0.132227],
            [0.162179, 0.557277, -0.814336],
            [0.0028177, 0.824995, 0.565135],
        ],
    ),
    (
        [
            [0.878935, 0.115231, 0.462813],
            [0.0845639, 0.917349, -0.388998],
            [-0.469386, 0.381041, 0.796546],
        ],
        [
            [-0.869533, 0.00193279, -0.493873],
            [-0.00419575, 0.999927, 0.0113007],
            [0.493859, 0.0118986, -0.869462],
        ],
    ),
    (
        [
            [0.951881, 0.20828, 0.224816],
            [-0.305582, 0.700797, 0.644595],
            [-0.023294, -0.682277, 0.730722],
        ],
        [
            [-0.999787, 0.0141074, -0.0151097],
            [-0.000971554, 0.698061, 0.716038],
            [0.0206489, 0.7159, -0.697898],
        ],
    ),
    (
        [
            [0.999538, 0.0192173, 0.0235334],
            [-0.0189064, 0.999732, -0.0133635],
            [-0.0237839, 0.0129124, 0.999634],
        ],
        [
            [-0.999807, 0.00286378, -0.0194776],
            [0.0026258, 0.999922, 0.0122308],
            [0.0195111, 0.0121774, -0.999736],
        ],
    ),
    (
        [
            [0.998468, 0.041362, -0.0367422],
            [-0.0364453, 0.991404, 0.125658],
            [0.0416238, -0.124127, 0.991393],
        ],
        [
            [-0.997665, -0.0658235, 0.0183602],
            [0.0216855, -0.0501652, 0.998507],
            [-0.064804, 0.99657, 0.0514739],
        ],
    ),
    (
        [
            [0.995563, 0.0493669, 0.0801057],
            [-0.0272233, 0.966027, -0.257002],
            [-0.0900717, 0.253681, 0.963085],
        ],
        [
            [-0.999228, -0.034399, -0.0190572],
            [0.0250208, -0.929986, 0.366743],
            [-0.0303386, 0.365984, 0.930127],
        ],
    ),
    (
        [
            [0.952898, 0.0122933, 0.303043],
            [-0.00568444, 0.999727, -0.0226807],
            [-0.303239, 0.0198898, 0.952707],
        ],
        [
            [-0.951155, 0.0127759, -0.308452],
            [0.000612627, 0.999219, 0.0394978],
            [0.308716, 0.0373795, -0.95042],
        ],
    ),
    (
        [
            [0.923096, -0.000313887, 0.38457],
            [0.00948258, 0.999714, -0.0219453],
            [-0.384454, 0.0239044, 0.922835],
        ],
        [
            [-0.922662, -0.00403523, -0.385589],
            [-0.0119834, 0.999762, 0.0182116],
            [0.385424, 0.0214239, -0.922491],
        ],
    ),
    (
        [
            [0.991575, 0.0945042, -0.0885834],
            [-0.10112, 0.99216, -0.0734349],
            [0.080949, 0.0817738, 0.993358],
        ],
        [
            [-0.990948, -0.127974, 0.0405639],
            [0.096351, -0.467557, 0.878697],
            [-0.0934839, 0.874651, 0.475655],
        ],
    ),
    (
        [
            [0.997148, 0.010521, 0.0747407],
            [-0.0079726, 0.999379, -0.034313],
            [-0.0750553, 0.0336192, 0.996612],
        ],
        [
            [-0.996543, 0.00988805, -0.0825019],
            [0.00939476, 0.999936, 0.0063645],
            [0.0825595, 0.00556751, -0.996572],
        ],
    ),
    (
        [
            [0.991261, 0.00474444, -0.131831],
            [-0.00205841, 0.999788, 0.0205036],
            [0.131901, -0.020053, 0.99106],
        ],
        [
            [-0.990924, 4.45275e-05, 0.134427],
            [0.00614714, 0.998969, 0.0449827],
            [-0.134286, 0.0454008, -0.989903],
        ],
    ),
    (
        [
            [0.992266, -0.0947916, 0.0801474],
            [0.100889, 0.992006, -0.0757987],
            [-0.0723216, 0.0832984, 0.993897],
        ],
        [
            [-0.992701, 0.0817686, -0.0886652],
            [-0.114283, -0.40263, 0.908203],
            [0.0385633, 0.911704, 0.409035],
        ],
    ),
    (
        [
            [0.99696, -0.00808565, -0.0774951],
            [0.0585083, 0.734519, 0.676061],
            [0.0514552, -0.67854, 0.732759],
        ],
        [
            [-0.9998, 0.0053398, -0.0193164],
            [-0.0162677, -0.779206, 0.626556],
            [-0.0117055, 0.626745, 0.779137],
        ],
    ),
    (
        [
            [0.961501, 0.0133645, -0.274475],
            [-0.016255, 0.999834, -0.00825889],
            [0.274319, 0.0124025, 0.961559],
        ],
        [
            [-0.963687, 0.000179203, 0.267042],
            [0.00670194, 0.999701, 0.023515],
            [-0.266958, 0.0244509, -0.9634],
        ],
    ),
    (
        [
            [0.99877, 0.0413462, -0.0273572],
            [-0.0263673, 0.91029, 0.413131],
            [0.0419844, -0.411902, 0.910261],
        ],
        [
            [-0.998035, -0.0613039, 0.0130407],
            [-0.00146496, 0.230815, 0.972998],
            [-0.0626594, 0.971065, -0.230452],
        ],
    ),
    (
        [
            [0.999657, 0.0261608, 0.00141675],
            [-0.0261957, 0.998937, 0.0379393],
            [-0.000422719, -0.0379634, 0.999279],
        ],
        [
            [-0.998896, -0.0310033, -0.0353275],
            [0.0315452, -0.999392, -0.0148857],
            [-0.0348445, -0.0159846, 0.999265],
        ],
    ),
    (
        [
            [0.77369, 0.0137861, 0.633415],
            [-0.0186509, 0.999826, 0.00102049],
            [-0.63329, -0.0126033, 0.773812],
        ],
        [
            [-0.773069, 0.0156632, -0.634129],
            [0.00418312, 0.999799, 0.0195956],
            [0.634308, 0.0124961, -0.772979],
        ],
    ),
    (
        [
            [0.952827, -0.024521, -0.302522],
            [-0.00541318, 0.9952, -0.0977158],
            [0.303465, 0.0947439, 0.94812],
        ],
        [
            [-0.952266, -0.00806089, 0.305165],
            [0.00351941, 0.999295, 0.037378],
            [-0.305252, 0.0366678, -0.951567],
        ],
    ),
    (
        [
            [-0.172189, 0.949971, 0.260587],
            [-0.86961, -0.0223234, -0.493235],
            [-0.462741, -0.311539, 0.829948],
        ],
        [
            [-0.672964, 0.0127645, -0.739567],
            [0.00429523, 0.999902, 0.0133494],
            [0.739664, 0.00580721, -0.672953],
        ],
    ),
    (
        [
            [0.637899, -0.440017, 0.632036],
            [-0.52883, 0.346333, 0.774849],
            [-0.559842, -0.828516, -0.0117683],
        ],
        [
            [-0.0627307, -0.0314554, -0.997536],
            [-0.733537, 0.679201, 0.0247117],
            [0.67675, 0.733279, -0.0656804],
        ],
    ),
    (
        [
            [0.998402, 0.00284932, -0.0564372],
            [0.000393713, 0.998353, 0.0573683],
            [0.0565077, -0.0572989, 0.996757],
        ],
        [
            [-0.997878, 0.000941416, 0.0651252],
            [-2.16756e-05, 0.999891, -0.0147853],
            [-0.065132, -0.0147552, -0.997768],
        ],
    ),
    (
        [
            [0.9999, 0.0141438, -0.000431687],
            [-0.0140882, 0.9979, 0.063225],
            [0.00132502, -0.0632125, 0.997999],
        ],
        [
            [-0.999515, -0.0308197, -0.00482715],
            [-0.00160551, -0.103741, 0.994605],
            [-0.0311554, 0.994128, 0.10364],
        ],
    ),
    (
        [
            [-0.201909, 0.0267804, 0.979038],
            [-0.0159062, 0.999405, -0.0306179],
            [-0.979275, -0.0217548, -0.201363],
        ],
        [
            [0.261235, 0.951613, -0.161839],
            [0.0758567, 0.146901, 0.986239],
            [0.962292, -0.269916, -0.03381],
        ],
    ),
    (
        [
            [0.998335, -0.0191576, -0.0544038],
            [0.0163271, 0.998513, -0.0520045],
            [0.0553192, 0.0510297, 0.997164],
        ],
        [
            [-0.998811, -0.00846127, 0.0480344],
            [-0.0051736, 0.997661, 0.0681593],
            [-0.0484988, 0.0678295, -0.996519],
        ],
    ),
    (
        [
            [0.999973, 0.00227282, -0.00699658],
            [-0.00137504, 0.992062, 0.125744],
            [0.00722684, -0.125731, 0.992038],
        ],
        [
            [-0.999995, -0.00337061, 4.25756e-05],
            [-0.00333677, 0.991528, 0.129853],
            [-0.00047993, 0.129852, -0.991534],
        ],
    ),
    (
        [
            [0.998908, 0.0216581, -0.041392],
            [-0.0327304, 0.956678, -0.289302],
            [0.0333331, 0.290341, 0.956342],
        ],
        [
            [-0.998254, -0.0377592, 0.0454422],
            [0.00744647, 0.682591, 0.730764],
            [-0.0586112, 0.729825, -0.681118],
        ],
    ),
    (
        [
            [0.999387, -0.0042571, -0.0347599],
            [0.00485203, 0.999843, 0.017049],
            [0.0346819, -0.0172072, 0.99925],
        ],
        [
            [-0.999976, 0.00260242, -0.00669664],
            [-0.00250352, -0.999889, -0.0147361],
            [-0.00673422, -0.0147175, 0.99987],
        ],
    ),
    (
        [
            [0.906103, -0.398828, -0.141112],
            [0.381512, 0.914475, -0.13485],
            [0.182826, 0.0683519, 0.980766],
        ],
        [
            [-0.996568, -0.0321282, -0.0763021],
            [-0.0823787, 0.476597, 0.875254],
            [0.00824509, 0.878535, -0.477609],
        ],
    ),
    (
        [
            [0.908356, 0.316033, -0.273884],
            [-0.231421, -0.165634, -0.95865],
            [-0.34833, 0.934178, -0.0773183],
        ],
        [
            [-0.999889, -0.0146322, -0.00295739],
            [-0.0149238, 0.974974, 0.221815],
            [-0.000362257, 0.221835, -0.975085],
        ],
    ),
    (
        [
            [0.999507, -0.00834631, 0.0302637],
            [0.00899248, 0.999733, -0.0212785],
            [-0.030078, 0.0215401, 0.999315],
        ],
        [
            [-0.999538, 0.00785187, -0.0293621],
            [0.00739788, 0.999852, 0.0155394],
            [0.0294797, 0.0153149, -0.999448],
        ],
    ),
    (
        [
            [0.999951, -0.00729441, -0.00672921],
            [0.00313753, 0.87564, -0.482954],
            [0.00941523, 0.48291, 0.87562],
        ],
        [
            [-0.999984, -0.005202, -0.00277372],
            [0.00340465, -0.893745, 0.448565],
            [-0.00481353, 0.448548, 0.893747],
        ],
    ),
    (
        [
            [0.998028, -0.0569885, 0.0263322],
            [0.0489091, 0.968801, 0.242967],
            [-0.039357, -0.2412, 0.969677],
        ],
        [
            [-0.997066, 0.0422415, -0.0638525],
            [-0.0760293, -0.448184, 0.890703],
            [0.00900662, 0.892944, 0.45008],
        ],
    ),
    (
        [
            [0.999745, 0.00860777, 0.0208747],
            [-0.00827114, 0.999835, -0.0161595],
            [-0.0210103, 0.0159827, 0.999651],
        ],
        [
            [-0.999576, 0.0148733, -0.0251161],
            [0.0151027, 0.999846, -0.00898035],
            [0.0249787, -0.00935575, -0.999646],
        ],
    ),
    (
        [
            [0.91924, 0.0372116, -0.391934],
            [-0.00675798, 0.996868, 0.0787959],
            [0.393639, -0.0697837, 0.916613],
        ],
        [
            [-0.921919, 0.00882585, 0.387286],
            [0.00588498, 0.999944, -0.00877866],
            [-0.387342, -0.00581387, -0.921919],
        ],
    ),
    (
        [
            [0.998324, -0.0029024, 0.0577924],
            [0.00236766, 0.999954, 0.00931901],
            [-0.0578167, -0.00916657, 0.998285],
        ],
        [
            [-0.99892, -0.0025688, -0.0464413],
            [-0.00203721, 0.999932, -0.0114927],
            [0.0464676, -0.0113855, -0.998857],
        ],
    ),
    (
        [
            [0.993986, 0.0163462, -0.108279],
            [-0.0612924, 0.902447, -0.426418],
            [0.090746, 0.43049, 0.898022],
        ],
        [
            [-0.994519, -0.0767804, 0.0709843],
            [0.0579273, 0.160607, 0.985318],
            [-0.0870543, 0.984028, -0.15528],
        ],
    ),
    (
        [
            [0.997351, 0.0715122, -0.0132892],
            [-0.0707087, 0.996067, 0.0533919],
            [0.0170551, -0.0523108, 0.998485],
        ],
        [
            [-0.997704, -0.066002, 0.015281],
            [0.064101, -0.846657, 0.528267],
            [-0.0219278, 0.528033, 0.848942],
        ],
    ),
    (
        [
            [0.999839, 0.00714662, -0.0164633],
            [-0.00859425, 0.99594, -0.0896085],
            [0.0157561, 0.0897356, 0.995841],
        ],
        [
            [-0.999773, 0.0079918, 0.0197854],
            [0.00864136, 0.999419, 0.0329623],
            [-0.0195105, 0.0331255, -0.999262],
        ],
    ),
    (
        [
            [-0.773738, 0.630074, 0.0658454],
            [-0.622848, -0.737618, -0.260731],
            [-0.115711, -0.242749, 0.963163],
        ],
        [
            [-0.740005, 0.000855199, -0.672604],
            [-0.0106008, 0.99986, 0.0129348],
            [0.672521, 0.0167018, -0.739892],
        ],
    ),
    (
        [
            [0.969039, -0.00110643, -0.246907],
            [-0.121454, 0.868509, -0.480564],
            [0.214973, 0.495673, 0.841484],
        ],
        [
            [-0.981168, -0.150714, 0.120811],
            [0.172426, -0.401504, 0.89948],
            [-0.0870583, 0.903372, 0.419929],
        ],
    ),
    (
        [
            [0.589015, 0.80692, 0.0440651],
            [-0.806467, 0.583447, 0.0959135],
            [0.0516848, -0.0920316, 0.994414],
        ],
        [
            [-0.99998, 0.00434293, -0.00486489],
            [0.00437139, 0.999973, -0.00588975],
            [0.00483918, -0.00591087, -0.999972],
        ],
    ),
    (
        [
            [0.999972, 0.000781564, 0.00750023],
            [-0.0031568, 0.946655, 0.322235],
            [-0.00684828, -0.322249, 0.94663],
        ],
        [
            [-0.999817, -0.0178453, -0.00691725],
            [-0.0189272, 0.975556, 0.218934],
            [0.00284118, 0.219025, -0.975716],
        ],
    ),
    (
        [
            [-0.969668, 0.219101, -0.108345],
            [0.172364, 0.298654, -0.938667],
            [-0.173305, -0.928871, -0.32736],
        ],
        [
            [-0.999917, 0.0111423, -0.00656864],
            [-0.00977865, -0.318874, 0.947748],
            [0.00846644, 0.947733, 0.318955],
        ],
    ),
    (
        [
            [-0.808574, -0.185515, -0.558383],
            [0.174641, -0.981898, 0.0733309],
            [-0.561879, -0.038223, 0.826336],
        ],
        [
            [-0.873416, 0.0121808, -0.486824],
            [-0.00495714, 0.999413, 0.0338998],
            [0.486951, 0.032022, -0.872843],
        ],
    ),
    (
        [
            [0.999295, 0.0295658, -0.0231234],
            [-0.0251771, 0.984904, 0.17126],
            [0.0278378, -0.170557, 0.984954],
        ],
        [
            [-0.998834, -0.040128, 0.026921],
            [0.0327412, -0.152276, 0.987798],
            [-0.0355388, 0.987524, 0.153411],
        ],
    ),
    (
        [
            [0.996021, -0.0050677, -0.0889802],
            [0.0042919, 0.999951, -0.00890794],
            [0.089021, 0.0084906, 0.995994],
        ],
        [
            [-0.995726, -0.00858132, 0.0919686],
            [-0.00615004, 0.999625, 0.0266854],
            [-0.0921631, 0.0260058, -0.995405],
        ],
    ),
    (
        [
            [0.563325, 0.812296, 0.151129],
            [-0.316559, 0.381143, -0.868632],
            [-0.763188, 0.441481, 0.471847],
        ],
        [
            [-0.980048, -0.0115108, -0.198437],
            [-0.168991, 0.573853, 0.801335],
            [0.104649, 0.818877, -0.564348],
        ],
    ),
    (
        [
            [0.984844, -0.0288271, 0.17103],
            [0.0260588, 0.999491, 0.0184094],
            [-0.171474, -0.0136736, 0.985094],
        ],
        [
            [-0.984637, -0.00367691, -0.174577],
            [-0.00649229, 0.999858, 0.0155587],
            [0.174495, 0.0164532, -0.984521],
        ],
    ),
    (
        [
            [0.99985, 0.000720773, -0.0172841],
            [-0.00075051, 0.999998, -0.0017141],
            [0.0172828, 0.00172682, 0.999849],
        ],
        [
            [-0.999926, -0.00413456, 0.0114842],
            [-0.00368343, 0.999231, 0.0390359],
            [-0.0116368, 0.0389908, -0.999172],
        ],
    ),
    (
        [
            [0.997976, 0.0603523, -0.0200139],
            [-0.0558618, 0.982551, 0.177404],
            [0.0303714, -0.175927, 0.983935],
        ],
        [
            [-0.996867, -0.0790953, 0.00217996],
            [0.0318842, -0.376338, 0.925935],
            [-0.0724181, 0.923101, 0.37768],
        ],
    ),
    (
        [
            [0.94678, -0.00538407, -0.321837],
            [0.00249113, 0.999953, -0.0094],
            [0.321872, 0.008098, 0.946749],
        ],
        [
            [-0.945694, 0.0255694, 0.324053],
            [0.0240377, 0.999673, -0.00872898],
            [-0.32417, -0.000465377, -0.945999],
        ],
    ),
    (
        [
            [0.846059, 0.435245, -0.307807],
            [0.318073, 0.0512036, 0.946682],
            [0.4278, -0.898855, -0.0951187],
        ],
        [
            [-0.217213, -0.0389124, 0.975352],
            [0.742195, 0.642416, 0.190918],
            [-0.634011, 0.765368, -0.11066],
        ],
    ),
    (
        [
            [0.914988, -0.0538229, -0.399875],
            [-0.0459455, 0.970717, -0.23579],
            [0.400857, 0.234117, 0.885722],
        ],
        [
            [-0.919706, 0.00194642, 0.392606],
            [0.105539, 0.964406, 0.242451],
            [-0.378159, 0.264418, -0.887176],
        ],
    ),
    (
        [
            [0.970915, -0.183858, 0.153365],
            [0.209801, 0.96196, -0.174974],
            [-0.115361, 0.202061, 0.972555],
        ],
        [
            [-0.975509, 0.21077, -0.0629391],
            [-0.218082, -0.964089, 0.151576],
            [-0.0287314, 0.161588, 0.986441],
        ],
    ),
    (
        [
            [0.99369, -0.00515149, -0.112044],
            [0.00366664, 0.999903, -0.0134545],
            [0.112102, 0.0129588, 0.993612],
        ],
        [
            [-0.99406, 0.00631892, 0.108668],
            [0.00878985, 0.999713, 0.022273],
            [-0.108496, 0.0230956, -0.99383],
        ],
    ),
    (
        [
            [0.995917, 0.0137529, 0.089215],
            [-0.0145079, 0.999864, 0.00781912],
            [-0.0890954, -0.00908151, 0.995982],
        ],
        [
            [-0.996188, 0.012059, -0.0864113],
            [0.0126654, 0.999899, -0.00647346],
            [0.0863245, -0.00754306, -0.99624],
        ],
    ),
    (
        [
            [0.84563, -0.0032436, -0.533759],
            [0.0040093, 0.999992, 0.000275049],
            [0.533754, -0.00237259, 0.845636],
        ],
        [
            [-0.849818, -0.00755214, 0.527023],
            [-0.00734806, 0.99997, 0.00248074],
            [-0.527026, -0.00176415, -0.849848],
        ],
    ),
    (
        [
            [0.736067, -0.212675, -0.642631],
            [-0.447028, 0.560168, -0.697408],
            [0.508303, 0.800613, 0.31725],
        ],
        [
            [-0.684029, 0.0061039, 0.729431],
            [0.0260275, 0.999532, 0.0160434],
            [-0.728992, 0.0299595, -0.683868],
        ],
    ),
    (
        [
            [0.993949, 0.00461705, -0.109742],
            [-0.00653155, 0.999833, -0.0170925],
            [0.109644, 0.0177058, 0.993813],
        ],
        [
            [-0.994446, 0.0218439, 0.102965],
            [0.0227578, 0.999711, 0.00770966],
            [-0.102767, 0.0100102, -0.994656],
        ],
    ),
    (
        [
            [0.996005, -0.0103388, 0.0886959],
            [-0.0291635, 0.901147, 0.432531],
            [-0.0843999, -0.43339, 0.897246],
        ],
        [
            [-0.999947, 0.00833193, -0.00598923],
            [-0.0101526, -0.887864, 0.459993],
            [-0.00148526, 0.46003, 0.887902],
        ],
    ),
    (
        [
            [0.981518, 0.0114609, 0.191025],
            [-0.0104683, 0.999926, -0.00620422],
            [-0.191082, 0.00408984, 0.981565],
        ],
        [
            [-0.979556, 0.000134379, -0.201176],
            [-0.00817302, 0.999148, 0.0404628],
            [0.20101, 0.0412799, -0.97872],
        ],
    ),
    (
        [
            [0.997665, -0.0372296, -0.0572574],
            [0.0379027, 0.999224, 0.0107148],
            [0.0568141, -0.01286, 0.998302],
        ],
        [
            [-0.997794, 0.00389749, 0.0662921],
            [0.00639122, 0.999278, 0.0374446],
            [-0.0660983, 0.0377856, -0.997099],
        ],
    ),
    (
        [
            [0.981618, -0.0105643, -0.190564],
            [0.00329498, 0.999256, -0.0384229],
            [0.190828, 0.0370887, 0.980923],
        ],
        [
            [-0.981673, -0.000810695, 0.190576],
            [0.00398375, 0.999685, 0.0247729],
            [-0.190536, 0.0250779, -0.981361],
        ],
    ),
    (
        [
            [-0.544941, -0.812151, -0.208446],
            [0.812337, -0.449791, -0.37121],
            [0.207722, -0.371617, 0.90485],
        ],
        [
            [-0.121327, -0.000366672, -0.992614],
            [-0.955208, 0.271977, 0.116655],
            [0.269926, 0.962303, -0.0333484],
        ],
    ),
    (
        [
            [0.637701, -0.219537, 0.738336],
            [0.735715, 0.457522, -0.499397],
            [-0.228168, 0.861671, 0.453279],
        ],
        [
            [-0.741797, 0.0196167, -0.670339],
            [-0.00209087, 0.9995, 0.0315629],
            [0.670623, 0.0248149, -0.741385],
        ],
    ),
    (
        [
            [0.99813, -0.0590625, -0.0157485],
            [0.0589086, 0.998213, -0.0100649],
            [0.0163148, 0.00911833, 0.999825],
        ],
        [
            [-0.99893, 0.0258783, -0.0383385],
            [-0.0440455, -0.279068, 0.959261],
            [0.014125, 0.959924, 0.279908],
        ],
    ),
    (
        [
            [0.999558, 0.0028395, -0.0296019],
            [-0.00492321, 0.997496, -0.0705578],
            [0.0293274, 0.0706723, 0.997068],
        ],
        [
            [-0.999532, -0.0305627, -0.00231546],
            [0.00957406, -0.38309, 0.923664],
            [-0.0291167, 0.923206, 0.383202],
        ],
    ),
    (
        [
            [0.99814, -0.0528437, -0.0303853],
            [0.0590889, 0.96123, 0.269341],
            [0.0149743, -0.270636, 0.962565],
        ],
        [
            [-0.999464, 0.00781117, 0.0318024],
            [-0.000588355, 0.966696, -0.255928],
            [-0.0327423, -0.255809, -0.966173],
        ],
    ),
    (
        [
            [-0.936685, 0.234194, 0.260336],
            [-0.233325, -0.97178, 0.034698],
            [0.261116, -0.0282419, 0.964894],
        ],
        [
            [0.999511, 0.00582072, 0.0307461],
            [0.0289012, 0.204922, -0.978352],
            [-0.0119956, 0.978762, 0.204654],
        ],
    ),
    (
        [
            [0.973616, -0.019218, -0.227384],
            [0.0030011, 0.99744, -0.0714512],
            [0.228175, 0.0688836, 0.97118],
        ],
        [
            [-0.974738, 0.0190271, 0.222547],
            [0.0222378, 0.999682, 0.0119297],
            [-0.222249, 0.0165771, -0.97485],
        ],
    ),
    (
        [
            [0.997273, 0.0453471, -0.0582173],
            [-0.0234007, 0.942529, 0.333303],
            [0.0699858, -0.331032, 0.941021],
        ],
        [
            [-0.996269, -0.0613496, 0.0607196],
            [-0.0100285, 0.780948, 0.624516],
            [-0.0857328, 0.621576, -0.77865],
        ],
    ),
    (
        [
            [0.999511, 0.0274482, -0.0149865],
            [-0.0305945, 0.957511, -0.286769],
            [0.00647846, 0.287087, 0.957883],
        ],
        [
            [-0.999443, -0.0260559, 0.0209038],
            [0.0148505, 0.213942, 0.976734],
            [-0.0299225, 0.976499, -0.213437],
        ],
    ),
    (
        [
            [0.621123, 0.722893, 0.302708],
            [-0.48353, 0.657448, -0.577894],
            [-0.61677, 0.212574, 0.757896],
        ],
        [
            [-0.996888, -0.0217614, -0.0757776],
            [-0.0783897, 0.376159, 0.923234],
            [0.00841386, 0.926299, -0.376694],
        ],
    ),
    (
        [
            [0.974426, 0.0128384, -0.224341],
            [-0.0123842, 0.999917, 0.00343166],
            [0.224367, -0.00056561, 0.974505],
        ],
        [
            [-0.973234, -0.00506667, 0.229763],
            [-0.000498848, 0.999801, 0.0199346],
            [-0.229818, 0.0192865, -0.973043],
        ],
    ),
    (
        [
            [0.994721, -0.0881097, 0.0526082],
            [0.0972904, 0.972774, -0.210345],
            [-0.0326424, 0.214353, 0.976211],
        ],
        [
            [-0.994309, 0.0920529, -0.0536268],
            [-0.105538, -0.782431, 0.613729],
            [0.0145358, 0.615896, 0.787694],
        ],
    ),
    (
        [
            [0.998677, -0.0372894, 0.0354002],
            [0.0242326, 0.948589, 0.315583],
            [-0.0453481, -0.314308, 0.948237],
        ],
        [
            [-0.999066, -0.00910724, -0.0422707],
            [-0.024629, 0.923353, 0.383161],
            [0.0355411, 0.383844, -0.922715],
        ],
    ),
    (
        [
            [0.931525, 0.00831028, 0.363583],
            [0.0192806, 0.997204, -0.0721909],
            [-0.363167, 0.0742577, 0.92876],
        ],
        [
            [-0.930052, -0.00174384, -0.367425],
            [-0.0268673, 0.997634, 0.0632737],
            [0.366445, 0.0687194, -0.927899],
        ],
    ),
    (
        [
            [-0.50483, -0.819216, 0.272087],
            [0.775688, -0.568816, -0.273414],
            [0.378753, 0.0730272, 0.922612],
        ],
        [
            [-0.981596, 0.00031926, 0.190974],
            [0.00652401, 0.999471, 0.0318616],
            [-0.190863, 0.0325211, -0.981079],
        ],
    ),
    (
        [
            [0.990518, -0.00195099, -0.137368],
            [-0.00164696, 0.999659, -0.0260735],
            [0.137372, 0.0260526, 0.990177],
        ],
        [
            [-0.991078, 0.00934835, 0.132961],
            [0.0106057, 0.999905, 0.00875176],
            [-0.132866, 0.0100839, -0.991083],
        ],
    ),
    (
        [
            [0.935049, -0.353081, 0.0318997],
            [0.257018, 0.737114, 0.624984],
            [-0.244184, -0.576192, 0.779985],
        ],
        [
            [-0.977342, -0.00167896, -0.211667],
            [-0.0448634, 0.978894, 0.199386],
            [0.206864, 0.204364, -0.956789],
        ],
    ),
    (
        [
            [0.998464, 0.0501172, 0.0236119],
            [-0.0498618, 0.998692, -0.0112844],
            [-0.0241466, 0.0100898, 0.999658],
        ],
        [
            [-0.999931, -0.0037971, -0.0112195],
            [-0.00640916, 0.970027, 0.242913],
            [0.00996085, 0.242968, -0.969984],
        ],
    ),
    (
        [
            [0.999893, -0.0108217, 0.00984537],
            [0.011201, 0.999164, -0.0393194],
            [-0.00941164, 0.0394255, 0.999178],
        ],
        [
            [-0.999886, 0.00730461, -0.0133396],
            [-0.0118202, -0.925163, 0.379391],
            [-0.00956982, 0.379504, 0.925142],
        ],
    ),
    (
        [
            [0.990922, -0.086745, 0.102709],
            [0.0847349, 0.99612, 0.0237834],
            [-0.104373, -0.0148644, 0.994427],
        ],
        [
            [-0.994922, -0.00197458, -0.10064],
            [-0.00242513, 0.999988, 0.00435525],
            [0.10063, 0.00457739, -0.994914],
        ],
    ),
    (
        [
            [0.999856, 0.00210734, -0.0168511],
            [-0.00557165, 0.978053, -0.20828],
            [0.0160424, 0.208344, 0.977924],
        ],
        [
            [-0.999698, 0.0048691, 0.0241226],
            [-0.00154306, 0.965899, -0.258915],
            [-0.0245606, -0.258874, -0.9656],
        ],
    ),
    (
        [
            [0.992858, -0.0249864, -0.116659],
            [0.0419872, 0.988447, 0.145634],
            [0.111673, -0.149492, 0.982436],
        ],
        [
            [-0.992324, 0.0357741, 0.118384],
            [-0.0419528, 0.803113, -0.594348],
            [-0.116338, -0.594752, -0.795447],
        ],
    ),
    (
        [
            [0.986821, -0.00531913, 0.161729],
            [0.00797365, 0.999844, -0.0157688],
            [-0.16162, 0.0168505, 0.986709],
        ],
        [
            [-0.985867, 0.0119402, -0.167109],
            [0.0141227, 0.99983, -0.0118784],
            [0.166939, -0.0140704, -0.985868],
        ],
    ),
    (
        [
            [0.999693, -0.0158939, -0.0190113],
            [0.0103599, 0.96501, -0.262007],
            [0.0225104, 0.261729, 0.964879],
        ],
        [
            [-0.999344, -0.0314781, -0.0180051],
            [-0.0250895, 0.241673, 0.970034],
            [-0.0261833, 0.969847, -0.242305],
        ],
    ),
    (
        [
            [0.977445, 0.0293661, 0.209138],
            [-0.0723687, 0.976903, 0.201057],
            [-0.198403, -0.211657, 0.956994],
        ],
        [
            [-0.976437, 0.00895131, -0.215624],
            [0.0552894, 0.976169, -0.20985],
            [0.208607, -0.216827, -0.953663],
        ],
    ),
    (
        [
            [0.994593, 0.0974797, -0.0358119],
            [-0.0822288, 0.949838, 0.301737],
            [0.0634288, -0.297161, 0.952718],
        ],
        [
            [-0.994192, -0.10746, -0.00604622],
            [0.078812, -0.7651, 0.639071],
            [-0.0733003, 0.634882, 0.769124],
        ],
    ),
    (
        [
            [0.365674, 0.282077, -0.88697],
            [-0.609177, 0.793033, 0.00105565],
            [0.703694, 0.539936, 0.461826],
        ],
        [
            [-0.469534, 0.0109062, 0.882848],
            [0.0060785, 0.99994, -0.00911984],
            [-0.882894, 0.00108445, -0.469572],
        ],
    ),
    (
        [
            [0.999956, 0.00903085, 0.0025358],
            [-0.00862738, 0.991574, -0.129252],
            [-0.00368169, 0.129224, 0.991609],
        ],
        [
            [-0.999976, 0.00322491, -0.00637541],
            [0.00379751, 0.995755, -0.0919687],
            [0.00605176, -0.0919907, -0.995743],
        ],
    ),
    (
        [
            [0.999982, -0.00398882, -0.00441072],
            [0.00411881, 0.999545, 0.0298655],
            [0.00428959, -0.0298832, 0.999544],
        ],
        [
            [-0.999931, -0.00315547, -0.0114491],
            [0.00300966, -0.999914, 0.0128304],
            [-0.0114875, 0.012796, 0.999853],
        ],
    ),
    (
        [
            [0.996613, 0.0781452, -0.0256245],
            [-0.0610516, 0.91178, 0.406116],
            [0.0550999, -0.403175, 0.913462],
        ],
        [
            [-0.996368, -0.084671, 0.00909851],
            [0.0540149, -0.545774, 0.83619],
            [-0.0658352, 0.833644, 0.548365],
        ],
    ),
    (
        [
            [0.961059, 0.139318, 0.238654],
            [-0.117488, 0.987672, -0.103448],
            [-0.250124, 0.0713812, 0.965579],
        ],
        [
            [-0.973397, 0.00782581, -0.228998],
            [-0.0621109, 0.952986, 0.296581],
            [0.220553, 0.302913, -0.927147],
        ],
    ),
    (
        [
            [0.156415, -0.982138, 0.104589],
            [-0.568896, -0.176149, -0.803323],
            [0.807398, 0.0661518, -0.586287],
        ],
        [
            [-0.992155, 0.0934304, -0.0830664],
            [-0.121171, -0.555137, 0.822887],
            [0.0307694, 0.826496, 0.562102],
        ],
    ),
    (
        [
            [0.997973, 0.0130328, -0.0622976],
            [-0.011111, 0.999455, 0.0310968],
            [0.0626689, -0.0303416, 0.997573],
        ],
        [
            [-0.997391, -0.00094697, 0.0722014],
            [-0.00271076, 0.9997, -0.024334],
            [-0.0721567, -0.024466, -0.997094],
        ],
    ),
    (
        [
            [0.913504, -0.0125928, -0.406634],
            [-0.108363, 0.95588, -0.27304],
            [0.392132, 0.293487, 0.871836],
        ],
        [
            [-0.909813, 0.0115348, 0.414861],
            [0.128636, 0.958223, 0.255464],
            [-0.394582, 0.28579, -0.873287],
        ],
    ),
    (
        [
            [0.932595, -0.0693644, 0.354197],
            [0.0984415, 0.993036, -0.0647231],
            [-0.347241, 0.0952281, 0.932928],
        ],
        [
            [-0.930498, 0.00578599, -0.366252],
            [-0.106202, 0.952666, 0.284867],
            [0.350564, 0.303964, -0.885839],
        ],
    ),
    (
        [
            [0.995668, -0.00475737, 0.0928567],
            [0.00890154, 0.99898, -0.0442667],
            [-0.0925514, 0.0449015, 0.994695],
        ],
        [
            [-0.996077, -0.0107986, -0.0878355],
            [0.00749423, 0.978669, -0.205305],
            [0.0881789, -0.205158, -0.974749],
        ],
    ),
    (
        [
            [0.99948, 0.0321999, 0.00146151],
            [-0.0321302, 0.998886, -0.0345513],
            [-0.00257243, 0.0344864, 0.999402],
        ],
        [
            [-0.999953, 0.00726142, -0.0065326],
            [0.00488529, 0.950962, 0.30927],
            [0.00845801, 0.309223, -0.950953],
        ],
    ),
]


class TestRot3(GtsamTestCase):
    """Test selected Rot3 methods."""

    def test_axisangle(self) -> None:
        """Test .axisAngle() method."""
        # fmt: off
        R = np.array(
          [
            [ -0.999957, 0.00922903, 0.00203116],
            [ 0.00926964, 0.999739, 0.0208927],
            [ -0.0018374, 0.0209105, -0.999781]
          ])
        # fmt: on

        # get back angle in radians
        _, actual_angle = Rot3(R).axisAngle()
        expected_angle = 3.1396582
        np.testing.assert_almost_equal(actual_angle, expected_angle, 1e-7)

    def test_axis_angle_stress_test(self) -> None:
        """Test that .axisAngle() yields angles less than 180 degrees for specific inputs."""
        for (R1, R2) in R1_R2_pairs:
            R1 = Rot3(np.array(R1))
            R2 = Rot3(np.array(R2))

            i1Ri2 = R1.between(R2)

            axis, angle = i1Ri2.axisAngle()
            angle_deg = np.rad2deg(angle)
            assert angle_deg < 180

    def test_rotate(self) -> None:
        """Test that rotate() works for both Point3 and Unit3."""
        R = Rot3(np.array([[1, 0, 0], [0, -1, 0], [0, 0, 1]]))
        p = Point3(1., 1., 1.)
        u = Unit3(np.array([1, 1, 1]))
        actual_p = R.rotate(p)
        actual_u = R.rotate(u)
        expected_p = Point3(np.array([1, -1, 1]))
        expected_u = Unit3(np.array([1, -1, 1]))
        np.testing.assert_array_equal(actual_p, expected_p)
        np.testing.assert_array_equal(actual_u.point3(), expected_u.point3())

    def test_unrotate(self) -> None:
        """Test that unrotate() after rotate() yields original Point3/Unit3."""
        wRc = Rot3(np.array(R1_R2_pairs[0][0]))
        c_p = Point3(1., 1., 1.)
        c_u = Unit3(np.array([1, 1, 1]))
        w_p = wRc.rotate(c_p)
        w_u = wRc.rotate(c_u)
        actual_p = wRc.unrotate(w_p)
        actual_u = wRc.unrotate(w_u)

        np.testing.assert_almost_equal(actual_p, c_p, decimal=6)
        np.testing.assert_almost_equal(actual_u.point3(), c_u.point3(), decimal=6)


if __name__ == "__main__":
    unittest.main()
