/*
    Utility functions/data for creating the model information found in `empirical.bf`.
*/

LoadFunctionLibrary ("../protein.bf");
LoadFunctionLibrary("../../UtilityFunctions.bf");

function mapMatrixToDict (letters, matrix) {
    dict   = {};
    dim    = utility.Array1D (letters);

    for (l1 = 0; l1 < dim - 1; l1 += 1) {
        dict[letters[l1]] = {};
        for (l2 = l1 + 1; l2 < dim; l2 += 1) {
            (dict[letters[l1]])[letters[l2]] = matrix [l1][l2];
        }
    }
    return dict;
}

WAG = {
    {0, 3.26324, 2.34804, 5.02923, 0.668808, 4.50138, 1.00707, 0.6142879999999999, 2.8795, 1.26431, 2.83893, 1.61995, 4.57074, 2.88691, 1.75252, 10.7101, 6.73946, 6.37375, 0.35946, 0.764894}
    {3.26324, 0, 0.0962568, 0.06784229999999999, 1.26464, 0.974403, 0.791065, 0.540574, 0.23523, 1.22101, 1.24069, 0.842805, 0.347612, 0.313977, 1.67824, 4.4726, 1.62992, 3.18413, 2.27837, 1.72794}
    {2.34804, 0.0962568, 0, 19.6173, 0.148478, 2.75024, 2.95706, 0.125304, 1.52466, 0.269452, 0.32966, 17.251, 1.34714, 1.95972, 0.468033, 3.40533, 1.19107, 0.484018, 0.412312, 1.03489}
    {5.02923, 0.06784229999999999, 19.6173, 0, 0.257789, 1.80382, 1.81116, 0.404776, 8.21158, 0.490144, 1.00125, 3.00956, 2.16806, 17.3783, 1.39535, 2.23982, 2.61419, 1.87059, 0.497433, 0.623719}
    {0.668808, 1.26464, 0.148478, 0.257789, 0, 0.158647, 2.15858, 3.36628, 0.282261, 6.72059, 3.78302, 0.305538, 0.51296, 0.317481, 0.326346, 1.7346, 0.546192, 2.06492, 4.86017, 20.5074}
    {4.50138, 0.974403, 2.75024, 1.80382, 0.158647, 0, 0.792457, 0.0967499, 1.18692, 0.194782, 0.553173, 3.57627, 0.773901, 1.04868, 1.85767, 4.2634, 0.717545, 0.5949449999999999, 1.07071, 0.329184}
    {1.00707, 0.791065, 2.95706, 1.81116, 2.15858, 0.792457, 0, 0.439075, 2.82919, 1.58695, 1.28409, 12.5704, 2.21205, 13.6438, 6.79042, 2.35176, 1.50385, 0.376062, 0.834267, 12.3072}
    {0.6142879999999999, 0.540574, 0.125304, 0.404776, 3.36628, 0.0967499, 0.439075, 0, 1.02892, 10.0752, 13.5273, 1.76099, 0.317506, 0.361952, 0.594093, 1.01497, 4.63305, 24.8508, 0.675128, 1.33502}
    {2.8795, 0.23523, 1.52466, 8.21158, 0.282261, 1.18692, 2.82919, 1.02892, 0, 0.818336, 2.9685, 9.57014, 1.76944, 12.3754, 17.0032, 3.07289, 4.40689, 0.970464, 0.436898, 0.423423}
    {1.26431, 1.22101, 0.269452, 0.490144, 6.72059, 0.194782, 1.58695, 10.0752, 0.818336, 0, 15.4228, 0.417907, 1.32127, 2.76265, 1.58126, 1.09535, 1.03778, 5.72027, 2.1139, 1.26654}
    {2.83893, 1.24069, 0.32966, 1.00125, 3.78302, 0.553173, 1.28409, 13.5273, 2.9685, 15.4228, 0, 0.629813, 0.544368, 4.9098, 2.17063, 1.5693, 4.81721, 6.54037, 1.63857, 1.36128}
    {1.61995, 0.842805, 17.251, 3.00956, 0.305538, 3.57627, 12.5704, 1.76099, 9.57014, 0.417907, 0.629813, 0, 0.6198360000000001, 4.90465, 2.0187, 12.6274, 6.45016, 0.623538, 0.228503, 3.45058}
    {4.57074, 0.347612, 1.34714, 2.16806, 0.51296, 0.773901, 2.21205, 0.317506, 1.76944, 1.32127, 0.544368, 0.6198360000000001, 0, 2.96563, 2.15896, 5.12592, 2.52719, 1.0005, 0.442935, 0.686449}
    {2.88691, 0.313977, 1.95972, 17.3783, 0.317481, 1.04868, 13.6438, 0.361952, 12.3754, 2.76265, 4.9098, 4.90465, 2.96563, 0, 9.644769999999999, 3.26906, 2.72592, 0.957268, 0.685467, 0.723509}
    {1.75252, 1.67824, 0.468033, 1.39535, 0.326346, 1.85767, 6.79042, 0.594093, 17.0032, 1.58126, 2.17063, 2.0187, 2.15896, 9.644769999999999, 0, 3.88965, 1.76155, 0.800207, 3.69815, 1.21225}
    {10.7101, 4.4726, 3.40533, 2.23982, 1.7346, 4.2634, 2.35176, 1.01497, 3.07289, 1.09535, 1.5693, 12.6274, 5.12592, 3.26906, 3.88965, 0, 13.9104, 0.739488, 1.6641, 2.50053}
    {6.73946, 1.62992, 1.19107, 2.61419, 0.546192, 0.717545, 1.50385, 4.63305, 4.40689, 1.03778, 4.81721, 6.45016, 2.52719, 2.72592, 1.76155, 13.9104, 0, 4.41086, 0.352251, 0.925072}
    {6.37375, 3.18413, 0.484018, 1.87059, 2.06492, 0.5949449999999999, 0.376062, 24.8508, 0.970464, 5.72027, 6.54037, 0.623538, 1.0005, 0.957268, 0.800207, 0.739488, 4.41086, 0, 1.1609, 1}
    {0.35946, 2.27837, 0.412312, 0.497433, 4.86017, 1.07071, 0.834267, 0.675128, 0.436898, 2.1139, 1.63857, 0.228503, 0.442935, 0.685467, 3.69815, 1.6641, 0.352251, 1.1609, 0, 7.8969}
    {0.764894, 1.72794, 1.03489, 0.623719, 20.5074, 0.329184, 12.3072, 1.33502, 0.423423, 1.26654, 1.36128, 3.45058, 0.686449, 0.723509, 1.21225, 2.50053, 0.925072, 1, 7.8969, 0}
};

//fprintf (stdout, mapMatrixToDict (models.protein.alphabet, WAG), "\n"):




LG = {
    {0, 7.908630, 1.255501, 3.299796, 0.806091, 6.564482, 1.140209, 0.476059, 1.704692, 1.256114, 3.571425, 0.879541, 3.741781, 3.081669, 1.350659, 15.019796, 6.797891, 8.095413, 0.574197, 0.695704}
    {7.908630, 0, 0.198761, 0.011117, 3.511742, 1.808740, 2.035214, 1.018736, 0.042150, 1.887354, 2.839512, 1.680068, 0.239513, 0.269463, 1.698443, 8.847193, 3.633208, 6.225305, 2.129215, 3.703275}
    {1.255501, 0.198761, 0, 16.661482, 0.055336, 2.684605, 2.945743, 0.033966, 0.899053, 0.047901, 0.081174, 16.128578, 1.253315, 1.662968, 0.393842, 3.940757, 1.353096, 0.120634, 0.094970, 0.429279}
    {3.299796, 0.011117, 16.661482, 0, 0.059769, 1.108400, 1.346808, 0.140644, 5.741990, 0.221374, 0.552013, 1.721195, 1.332599, 13.117878, 1.156451, 1.944437, 1.920836, 0.778553, 0.247361, 0.381397}
    {0.806091, 3.511742, 0.055336, 0.059769, 0, 0.284644, 2.167378, 3.535496, 0.075995, 8.237827, 5.715542, 0.284450, 0.300143, 0.113923, 0.167515, 1.149617, 0.524262, 2.080141, 7.807073, 24.795538}
    {6.564482, 1.808740, 2.684605, 1.108400, 0.284644, 0, 0.989686, 0.027659, 0.942509, 0.140632, 0.443358, 4.567866, 0.625809, 0.851393, 1.239767, 5.528515, 0.412531, 0.243704, 0.853083, 0.173733}
    {1.140209, 2.035214, 2.945743, 1.346808, 2.167378, 0.989686, 0, 0.345954, 2.215435, 1.163908, 1.405878, 14.327317, 1.616785, 15.294073, 7.710101, 3.145590, 1.856391, 0.378143, 1.897035, 16.861539}
    {0.476059, 1.018736, 0.033966, 0.140644, 3.535496, 0.027659, 0.345954, 0, 0.505414, 13.170227, 13.578641, 0.608467, 0.248724, 0.231481, 0.403492, 0.203682, 3.284525, 2.062424, 0.354780, 0.738801}
    {1.704692, 0.042150, 0.899053, 5.741990, 0.075995, 0.942509, 2.215435, 0.505414, 0, 0.436882, 2.086245, 6.815611, 1.240180, 10.276405, 20.099975, 2.378810, 3.612184, 0.588447, 0.158568, 0.419191}
    {1.256114, 1.887354, 0.047901, 0.221374, 8.237827, 0.140632, 1.163908, 13.170227, 0.436882, 0, 20.056417, 0.217415, 0.791345, 1.850656, 0.959069, 0.579185, 0.962526, 5.410175, 1.968773, 0.952079}
    {3.571425, 2.839512, 0.081174, 0.552013, 5.715542, 0.443358, 1.405878, 13.578641, 2.086245, 20.056417, 0, 1.178801, 0.317253, 5.314296, 1.538248, 1.102405, 6.419361, 6.032845, 2.211975, 1.529266}
    {0.879541, 1.680068, 16.128578, 1.721195, 0.284450, 4.567866, 14.327317, 0.608467, 6.815611, 0.217415, 1.178801, 0, 0.514050, 5.387956, 2.388961, 12.735858, 6.356809, 0.265904, 0.144174, 1.944603}
    {3.741781, 0.239513, 1.253315, 1.332599, 0.300143, 0.625809, 1.616785, 0.248724, 1.240180, 0.791345, 0.317253, 0.514050, 0, 1.983585, 1.056566, 4.251681, 1.815740, 0.942080, 0.302262, 0.284730}
    {3.081669, 0.269463, 1.662968, 13.117878, 0.113923, 0.851393, 15.294073, 0.231481, 10.276405, 1.850656, 5.314296, 5.387956, 1.983585, 0, 8.921638, 3.888500, 3.431944, 0.668293, 0.750481, 0.817640}
    {1.350659, 1.698443, 0.393842, 1.156451, 0.167515, 1.239767, 7.710101, 0.403492, 20.099975, 0.959069, 1.538248, 2.388961, 1.056566, 8.921638, 0, 2.726625, 1.839630, 0.542964, 1.886083, 0.999078}
    {15.019796, 8.847193, 3.940757, 1.944437, 1.149617, 5.528515, 3.145590, 0.203682, 2.378810, 0.579185, 1.102405, 12.735858, 4.251681, 3.888500, 2.726625, 0, 20.564538, 0.312550, 0.790716, 1.272668}
    {6.797891, 3.633208, 1.353096, 1.920836, 0.524262, 0.412531, 1.856391, 3.284525, 3.612184, 0.962526, 6.419361, 6.356809, 1.815740, 3.431944, 1.839630, 20.564538, 0, 6.952490, 0.447447, 0.781117}
    {8.095413, 6.225305, 0.120634, 0.778553, 2.080141, 0.243704, 0.378143, 2.062424, 0.588447, 5.410175, 6.032845, 0.265904, 0.942080, 0.668293, 0.542964, 0.312550, 6.952490, 0, 0.602135, 0.792149}
    {0.574197, 2.129215, 0.094970, 0.247361, 7.807073, 0.853083, 1.897035, 0.354780, 0.158568, 1.968773, 2.211975, 0.144174, 0.302262, 0.750481, 1.886083, 0.790716, 0.447447, 0.602135, 0, 10.014342}
    {0.695704, 3.703275, 0.429279, 0.381397, 24.795538, 0.173733, 16.861539, 0.738801, 0.419191, 0.952079, 1.529266, 1.944603, 0.284730, 0.817640, 0.999078, 1.272668, 0.781117, 0.792149, 10.014342, 0}
};
//fprintf (stdout, mapMatrixToDict (models.protein.alphabet, LG), "\n"):


JTT = {
	{0, 1.825304, 2.629062, 3.389193, 0.439402, 5.529052, 0.698916, 1.149188, 1.173822, 0.984993, 1.491421, 1.772843, 6.226284, 1.768897, 1.689314, 12.350566, 14.560301, 9.291012, 0.267941, 0.443212}
	{1.825304, 0, 0.335605, 0.171280, 2.155291, 1.736056, 2.303555, 0.478375, 0.155718, 0.522966, 1.300168, 0.995491, 0.392886, 0.290103, 3.240373, 6.848188, 1.492781, 1.974145, 3.508343, 6.719573}
	{2.629062, 0.335605, 0, 24.676880, 0.103333, 4.042937, 3.280087, 0.368468, 0.897486, 0.195361, 0.603695, 17.632664, 0.404041, 1.657439, 0.492165, 1.872296, 1.350869, 1.001687, 0.182588, 1.442353}
	{3.389193, 0.171280, 24.676880, 0, 0.139259, 3.544726, 0.774530, 0.355139, 5.502124, 0.309742, 0.556299, 1.836860, 0.610027, 10.859165, 1.011924, 0.992752, 1.053550, 1.478317, 0.363426, 0.201608}
	{0.439402, 2.155291, 0.103333, 0.139259, 0, 0.159540, 1.440688, 2.469068, 0.077911, 7.944248, 1.385889, 0.233473, 0.471779, 0.145150, 0.207524, 2.999303, 0.441343, 1.885673, 1.709153, 17.425203}
	{5.529052, 1.736056, 4.042937, 3.544726, 0.159540, 0, 0.640854, 0.170842, 0.857370, 0.220799, 0.414257, 2.457067, 0.661141, 0.734896, 4.320057, 5.955249, 1.006774, 1.493788, 1.729037, 0.166810}
	{0.698916, 2.303555, 3.280087, 0.774530, 1.440688, 0.640854, 0, 0.577600, 1.668401, 1.717570, 1.047437, 12.791207, 3.628382, 18.060173, 10.201347, 2.362208, 1.516712, 0.387084, 0.407311, 18.582271}
	{1.149188, 0.478375, 0.368468, 0.355139, 2.469068, 0.170842, 0.577600, 0, 0.643605, 7.419497, 15.351776, 1.560076, 0.313221, 0.248689, 0.760000, 1.287195, 8.114273, 30.292441, 0.427382, 0.964144}
	{1.173822, 0.155718, 0.897486, 5.502124, 0.077911, 0.857370, 1.668401, 0.643605, 0, 0.465418, 1.984497, 8.037099, 0.687399, 9.426273, 20.745569, 1.507571, 3.068156, 0.394198, 0.283208, 0.279300}
	{0.984993, 0.522966, 0.195361, 0.309742, 7.944248, 0.220799, 1.717570, 7.419497, 0.465418, 0, 12.254646, 0.436212, 3.369566, 2.252737, 1.182794, 1.882600, 0.865866, 5.596665, 1.685012, 0.766034}
	{1.491421, 1.300168, 0.603695, 0.556299, 1.385889, 0.414257, 1.047437, 15.351776, 1.984497, 12.254646, 0, 1.050805, 0.521765, 1.451723, 1.369570, 0.907330, 6.719179, 9.654409, 0.639704, 0.603279}
	{1.772843, 0.995491, 17.632664, 1.836860, 0.233473, 2.457067, 12.791207, 1.560076, 8.037099, 0.436212, 1.050805, 0, 0.387011, 2.442836, 1.433276, 16.070798, 7.470881, 0.522749, 0.088012, 2.226330}
	{6.226284, 0.392886, 0.404041, 0.610027, 0.471779, 0.661141, 3.628382, 0.313221, 0.687399, 3.369566, 0.521765, 0.387011, 0, 5.109540, 2.257455, 8.859674, 3.739588, 0.672198, 0.222302, 0.361739}
	{1.768897, 0.290103, 1.657439, 10.859165, 0.145150, 0.734896, 18.060173, 0.248689, 9.426273, 2.252737, 1.451723, 2.442836, 5.109540, 0, 9.601862, 1.743739, 1.664363, 0.571191, 0.547155, 0.809408}
	{1.689314, 3.240373, 0.492165, 1.011924, 0.207524, 4.320057, 10.201347, 0.760000, 20.745569, 1.182794, 1.369570, 1.433276, 2.257455, 9.601862, 0, 3.182254, 2.066158, 0.546484, 3.996952, 0.748581}
	{12.350566, 6.848188, 1.872296, 0.992752, 2.999303, 5.955249, 2.362208, 1.287195, 1.507571, 1.882600, 0.907330, 16.070798, 8.859674, 1.743739, 3.182254, 0, 15.180140, 1.298039, 0.987916, 1.997292}
	{14.560301, 1.492781, 1.350869, 1.053550, 0.441343, 1.006774, 1.516712, 8.114273, 3.068156, 0.865866, 6.719179, 7.470881, 3.739588, 1.664363, 2.066158, 15.180140, 0, 3.634797, 0.255953, 0.638941}
	{9.291012, 1.974145, 1.001687, 1.478317, 1.885673, 1.493788, 0.387084, 30.292441, 0.394198, 5.596665, 9.654409, 0.522749, 0.672198, 0.571191, 0.546484, 1.298039, 3.634797, 0, 0.761595, 0.525762}
	{0.267941, 3.508343, 0.182588, 0.363426, 1.709153, 1.729037, 0.407311, 0.427382, 0.283208, 1.685012, 0.639704, 0.088012, 0.222302, 0.547155, 3.996952, 0.987916, 0.255953, 0.761595, 0, 2.376287}
	{0.443212, 6.719573, 1.442353, 0.201608, 17.425203, 0.166810, 18.582271, 0.964144, 0.279300, 0.766034, 0.603279, 2.226330, 0.361739, 0.809408, 0.748581, 1.997292, 0.638941, 0.525762, 2.376287, 0}
};

//fprintf (stdout, mapMatrixToDict (models.protein.alphabet, JTT), "\n"):



HIVBm = {
{0,0.123758,1.45504,1.48135,0.0141269,2.13536,0.0847613,0.005,0.005,0.215256,0.0186643,0.005,2.12217,0.0551128,0.307507,2.46633,15.9183,7.61428,0.005,0.005}
{0.123758,0,0.005,0.005,9.29815,0.897871,0.240073,0.005,0.005,0.129777,0.005,0.0860642,0.005,0.005,0.351721,4.69314,0.739969,0.420027,2.63277,7.57932}
{1.45504,0.005,0,10.5872,0.005,2.83806,1.9169,0.0176792,0.005,0.00876048,0.005,17.6612,0.0342658,0.005,0.005,0.52823,0.274724,1.04793,0.005,0.674653}
{1.48135,0.005,10.5872,0,0.005,3.92775,0.11974,0.00609079,4.61482,0.005,0.175789,0.0792633,0.0120226,2.5602,0.0749218,0.005,0.289774,1.02847,0.005,0.0792633}
{0.0141269,9.29815,0.005,0.005,0,0.291561,0.145558,3.39836,0.0342658,8.52484,0.188025,0.005,0.005,0.005,0.005,0.956472,0.0141269,0.723274,0.829343,15.34}
{2.13536,0.897871,2.83806,3.92775,0.291561,0,0.005,0.005,0.521705,0.005,0.005,0.323401,0.005,0.0619137,3.65345,4.38041,0.369615,0.953155,1.21674,0.005}
{0.0847613,0.240073,1.9169,0.11974,0.145558,0.005,0,0.103111,0.005,1.74171,0.005,7.64585,2.45318,7.05545,9.04044,0.382747,0.711594,0.005,0.0695179,18.6943}
{0.005,0.005,0.0176792,0.00609079,3.39836,0.005,0.103111,0,0.322319,5.95879,11.2065,0.680565,0.0410593,0.005,0.677289,1.21803,8.61217,17.7389,0.005,0.148168}
{0.005,0.005,0.005,4.61482,0.0342658,0.521705,0.005,0.322319,0,0.0814995,1.28246,7.90443,0.0313862,6.54737,20.45,0.504111,4.67142,0.265829,0.005,0.005}
{0.215256,0.129777,0.00876048,0.005,8.52484,0.005,1.74171,5.95879,0.0814995,0,5.31961,0.005,2.07757,1.49456,0.701427,0.927656,0.0437673,1.41036,0.748843,0.111986}
{0.0186643,0.005,0.005,0.175789,0.188025,0.005,0.005,11.2065,1.28246,5.31961,0,0.005,0.005,0.303676,2.51394,0.005,4.94026,6.8532,0.089078,0.005}
{0.005,0.0860642,17.6612,0.0792633,0.005,0.323401,7.64585,0.680565,7.90443,0.005,0.005,0,0.00739578,0.672052,0.295543,13.1447,6.88667,0.026656,0.005,1.76417}
{2.12217,0.005,0.0342658,0.0120226,0.005,0.005,2.45318,0.0410593,0.0313862,2.07757,0.005,0.00739578,0,4.47211,1.28355,5.37762,2.01417,0.005,0.0444506,0.0304381}
{0.0551128,0.005,0.005,2.5602,0.005,0.0619137,7.05545,0.005,6.54737,1.49456,0.303676,0.672052,4.47211,0,3.4215,0.116311,0.243589,0.0209153,0.026656,0.113033}
{0.307507,0.351721,0.005,0.0749218,0.005,3.65345,9.04044,0.677289,20.45,0.701427,2.51394,0.295543,1.28355,3.4215,0,3.4791,2.86868,0.0812454,0.991338,0.00991826}
{2.46633,4.69314,0.52823,0.005,0.956472,4.38041,0.382747,1.21803,0.504111,0.927656,0.005,13.1447,5.37762,0.116311,3.4791,0,8.93107,0.0749218,0.0248728,0.648024}
{15.9183,0.739969,0.274724,0.289774,0.0141269,0.369615,0.711594,8.61217,4.67142,0.0437673,4.94026,6.88667,2.01417,0.243589,2.86868,8.93107,0,0.709226,0.005,0.105652}
{7.61428,0.420027,1.04793,1.02847,0.723274,0.953155,0.005,17.7389,0.265829,1.41036,6.8532,0.026656,0.005,0.0209153,0.0812454,0.0749218,0.709226,0,0.005,0.0410593}
{0.005,2.63277,0.005,0.005,0.829343,1.21674,0.0695179,0.005,0.005,0.748843,0.089078,0.005,0.0444506,0.026656,0.991338,0.0248728,0.005,0.005,0,1.28022}
{0.005,7.57932,0.674653,0.0792633,15.34,0.005,18.6943,0.148168,0.005,0.111986,0.005,1.76417,0.0304381,0.113033,0.00991826,0.648024,0.105652,0.0410593,1.28022,0}
};

HIVWm={
{0,0.167653,4.43521,5.56325,0.597923,1.8685,0.005,0.005,0.592784,0.16024,0.005,0.617509,1.00981,0.005,0.0744808,8.5942,24.1422,24.8094,0.005,0.005}
{0.167653,0,0.005,0.005,0.362959,0.0489798,0.005,0.005,0.005,0.005,0.005,0.0604932,0.005,0.005,2.86364,1.12195,0.005,0.005,5.49894,8.34835}
{4.43521,0.005,0,12.1233,0.005,10.3969,2.31779,0.145124,0.894313,0.005,0.005,29.4087,0.005,0.005,0.0674539,0.427881,0.630395,2.91786,0.005,2.28154}
{5.56325,0.005,12.1233,0,0.005,14.7801,0.005,0.0390512,23.9626,0.129839,0.005,0.201526,0.005,3.20656,0.0251632,0.005,0.458743,2.19952,0.005,0.005}
{0.597923,0.362959,0.005,0.005,0,0.005,0.005,1.48288,0.005,7.48781,0.005,0.005,0.0342252,0.005,0.005,4.27939,0.114512,2.28,0.005,4.12728}
{1.8685,0.0489798,10.3969,14.7801,0.005,0,0.005,0.005,0.279425,0.0489798,0.0489798,0.0604932,0.005,0.0604932,13.4379,6.27966,0.0489798,2.79622,2.8258,0.005}
{0.005,0.005,2.31779,0.005,0.005,0.005,0,0.005,0.22406,1.76382,0.005,8.59876,13.9444,18.5465,6.84405,0.725157,0.95956,0.827479,0.005,47.4889}
{0.005,0.005,0.145124,0.0390512,1.48288,0.005,0.005,0,0.817481,9.10246,17.3064,0.987028,0.005,0.0342252,1.34069,0.740091,9.36345,24.8231,0.005,0.114512}
{0.592784,0.005,0.894313,23.9626,0.005,0.279425,0.22406,0.817481,0,0.005,4.09564,10.6655,0.111928,13.0705,39.8897,0.005,4.04802,0.128065,0.005,0.005}
{0.16024,0.005,0.005,0.129839,7.48781,0.0489798,1.76382,9.10246,0.005,0,11.3839,0.005,9.83095,2.89048,0.586757,6.14396,0.005,2.95344,1.37031,0.005}
{0.005,0.005,0.005,0.005,0.005,0.0489798,0.005,17.3064,4.09564,11.3839,0,0.201526,0.005,0.005,3.28652,0.392575,7.41313,14.7683,0.005,0.579198}
{0.617509,0.0604932,29.4087,0.201526,0.005,0.0604932,8.59876,0.987028,10.6655,0.005,0.201526,0,0.344848,0.342068,0.16024,14.5699,4.54206,0.0744808,0.005,5.06475}
{1.00981,0.005,0.005,0.005,0.0342252,0.005,13.9444,0.005,0.111928,9.83095,0.005,0.344848,0,3.04502,0.404723,14.249,4.33701,0.005,0.005,0.005}
{0.005,0.005,0.005,3.20656,0.005,0.0604932,18.5465,0.0342252,13.0705,2.89048,0.005,0.342068,3.04502,0,10.6746,0.16024,0.203091,0.005,0.0443298,0.005}
{0.0744808,2.86364,0.0674539,0.0251632,0.005,13.4379,6.84405,1.34069,39.8897,0.586757,3.28652,0.16024,0.404723,10.6746,0,8.35024,0.928203,0.279425,5.96564,0.005}
{8.5942,1.12195,0.427881,0.005,4.27939,6.27966,0.725157,0.740091,0.005,6.14396,0.392575,14.5699,14.249,0.16024,8.35024,0,6.34079,0.862637,1.10156,0.933142}
{24.1422,0.005,0.630395,0.458743,0.114512,0.0489798,0.95956,9.36345,4.04802,0.005,7.41313,4.54206,4.33701,0.203091,0.928203,6.34079,0,0.005,0.005,0.490608}
{24.8094,0.005,2.91786,2.19952,2.28,2.79622,0.827479,24.8231,0.128065,2.95344,14.7683,0.0744808,0.005,0.005,0.279425,0.862637,0.005,0,0.005,1.35482}
{0.005,5.49894,0.005,0.005,0.005,2.8258,0.005,0.005,0.005,1.37031,0.005,0.005,0.005,0.0443298,5.96564,1.10156,0.005,0.005,0,0.005}
{0.005,8.34835,2.28154,0.005,4.12728,0.005,47.4889,0.114512,0.005,0.005,0.579198,5.06475,0.005,0.005,0.005,0.933142,0.490608,1.35482,0.005,0}
};

cpREV={
{0.0, 0.17842659999999999, 0.092912900000000007, 1.2410950000000001, 0.0089291809999999996, 0.19922690000000001, 0.95218210000000003, 1.8519509999999999, 5.2413160000000003, 0.1140412, 0.069691009999999998, 0.073883550000000006, 0.062992709999999993, 0.11301460000000001, 1.800713, 0.99883580000000005, 2.9123169999999998, 0.079395489999999999, 0.1433528, 3.7744770000000001}
{0.17842659999999999, 0.0, 0.78291299999999997, 0.057953739999999997, 0.1821885, 1.9239010000000001, 0.062738630000000004, 1.0893999999999999, 10.4955, 0.32451750000000001, 0.3932002, 7.5492400000000002, 0.33623259999999999, 0.082086770000000003, 0.3498713, 1.9264349999999999, 1.1352580000000001, 0.57242859999999995, 0.17113149999999999, 0.1366145}
{0.092912900000000007, 0.78291299999999997, 0.0, 7.1851820000000002, 1.3742680000000001e-06, 0.087059890000000001, 0.50383730000000004, 0.48689009999999999, 14.05444, 1.762721, 0.027694420000000001, 6.1903180000000004, 0.039721729999999997, 0.19554460000000001, 0.0073425540000000003, 7.3483460000000003, 2.1471749999999998, 0.00073109369999999996, 2.622763, 0.049312059999999998}
{1.2410950000000001, 0.057953739999999997, 7.1851820000000002, 0.0, 0.023400190000000001, 0.18438560000000001, 7.4266189999999996, 2.1124000000000001, 11.26995, 0.039169990000000002, 0.030205019999999999, 0.066227720000000004, 0.033575769999999998, 0.1031734, 0.1509482, 0.58229880000000001, 0.15168809999999999, 0.01423897, 0.90783380000000002, 0.40760740000000001}
{0.0089291809999999996, 0.1821885, 1.3742680000000001e-06, 0.023400190000000001, 0.0, 1.046446e-08, 7.5192150000000001e-11, 0.058911230000000002, 3.9633880000000001, 0.0006594967, 0.0060792190000000003, 3.7228779999999998e-16, 0.0072131779999999998, 0.1993818, 0.0048783949999999998, 0.26394820000000002, 3.225214e-06, 0.44408330000000001, 0.77416119999999999, 0.022435119999999999}
{0.19922690000000001, 1.9239010000000001, 0.087059890000000001, 0.18438560000000001, 1.046446e-08, 0.0, 3.6916709999999999, 0.055163400000000001, 8.9084339999999997, 6.7127360000000003e-06, 0.6802781, 3.030805, 0.001233336, 0.00149661, 0.74269090000000004, 0.00059064049999999998, 0.12020939999999999, 4.3329830000000002e-05, 0.027370909999999998, 0.0090477370000000001}
{0.95218210000000003, 0.062738630000000004, 0.50383730000000004, 7.4266189999999996, 7.5192150000000001e-11, 3.6916709999999999, 0.0, 1.38937, 7.2980799999999997, 0.00010299589999999999, 0.0012831209999999999, 3.608816, 0.076595659999999996, 0.052886250000000003, 0.028898150000000001, 0.067767090000000002, 0.060166240000000003, 0.02252612, 0.1240642, 0.57954090000000003}
{1.8519509999999999, 1.0893999999999999, 0.48689009999999999, 2.1124000000000001, 0.058911230000000002, 0.055163400000000001, 1.38937, 0.0, 9.1395180000000007, 0.035604820000000002, 0.021579359999999999, 0.055044000000000003, 0.021872639999999999, 0.19847719999999999, 0.079150559999999995, 0.99842149999999996, 0.078627669999999997, 0.13868530000000001, 0.22958419999999999, 0.42281999999999997}
{5.2413160000000003, 10.4955, 14.05444, 11.26995, 3.9633880000000001, 8.9084339999999997, 7.2980799999999997, 9.1395180000000007, 0.0, 4.7065859999999997, 5.8791029999999997, 1.455741, 2.298295, 5.642309, 10.494960000000001, 5.4391160000000003, 3.4432849999999999, 7.01389, 20.55414, 6.890244}
{0.1140412, 0.32451750000000001, 1.762721, 0.039169990000000002, 0.0006594967, 6.7127360000000003e-06, 0.00010299589999999999, 0.035604820000000002, 4.7065859999999997, 0.0, 1.6011230000000001, 0.50597930000000002, 10.96748, 2.7147049999999999, 0.050165679999999997, 0.60076070000000004, 3.0871520000000001, 0.063187480000000004, 0.29031649999999998, 7.9266750000000004}
{0.069691009999999998, 0.3932002, 0.027694420000000001, 0.030205019999999999, 0.0060792190000000003, 0.6802781, 0.0012831209999999999, 0.021579359999999999, 5.8791029999999997, 1.6011230000000001, 0.0, 0.021584510000000001, 5.6479850000000003, 3.3906179999999999, 1.149931, 0.1580539, 0.57027919999999999, 0.3378544, 0.15213199999999999, 3.59531}
{0.073883550000000006, 7.5492400000000002, 6.1903180000000004, 0.066227720000000004, 3.7228779999999998e-16, 3.030805, 3.608816, 0.055044000000000003, 1.455741, 0.50597930000000002, 0.021584510000000001, 0.0, 1.238634, 0.0046490350000000001, 0.0099489939999999992, 0.086884050000000004, 1.0392980000000001, 0.0080242630000000002, 0.07109973, 0.034934399999999997}
{0.062992709999999993, 0.33623259999999999, 0.039721729999999997, 0.033575769999999998, 0.0072131779999999998, 0.001233336, 0.076595659999999996, 0.021872639999999999, 2.298295, 10.96748, 5.6479850000000003, 1.238634, 0.0, 3.94794, 0.074172790000000002, 0.018613540000000001, 1.4156120000000001, 0.10111489999999999, 0.0022467590000000001, 4.3967200000000002}
{0.11301460000000001, 0.082086770000000003, 0.19554460000000001, 0.1031734, 0.1993818, 0.00149661, 0.052886250000000003, 0.19847719999999999, 5.642309, 2.7147049999999999, 3.3906179999999999, 0.0046490350000000001, 3.94794, 0.0, 0.35561979999999999, 0.98130640000000002, 0.036744859999999997, 0.2199856, 7.0744639999999999, 1.6439459999999999}
{1.800713, 0.3498713, 0.0073425540000000003, 0.1509482, 0.0048783949999999998, 0.74269090000000004, 0.028898150000000001, 0.079150559999999995, 10.494960000000001, 0.050165679999999997, 1.149931, 0.0099489939999999992, 0.074172790000000002, 0.35561979999999999, 0.0, 1.284651, 0.90571120000000005, 0.0055160740000000002, 0.19921330000000001, 0.2217442}
{0.99883580000000005, 1.9264349999999999, 7.3483460000000003, 0.58229880000000001, 0.26394820000000002, 0.00059064049999999998, 0.067767090000000002, 0.99842149999999996, 5.4391160000000003, 0.60076070000000004, 0.1580539, 0.086884050000000004, 0.018613540000000001, 0.98130640000000002, 1.284651, 0.0, 3.0585749999999998, 0.1385142, 0.8104751, 0.074770409999999995}
{2.9123169999999998, 1.1352580000000001, 2.1471749999999998, 0.15168809999999999, 3.225214e-06, 0.12020939999999999, 0.060166240000000003, 0.078627669999999997, 3.4432849999999999, 3.0871520000000001, 0.57027919999999999, 1.0392980000000001, 1.4156120000000001, 0.036744859999999997, 0.90571120000000005, 3.0585749999999998, 0.0, 0.01412361, 0.099842550000000002, 0.2166054}
{0.079395489999999999, 0.57242859999999995, 0.00073109369999999996, 0.01423897, 0.44408330000000001, 4.3329830000000002e-05, 0.02252612, 0.13868530000000001, 7.01389, 0.063187480000000004, 0.3378544, 0.0080242630000000002, 0.10111489999999999, 0.2199856, 0.0055160740000000002, 0.1385142, 0.01412361, 0.0, 0.61212840000000002, 0.096635689999999996}
{0.1433528, 0.17113149999999999, 2.622763, 0.90783380000000002, 0.77416119999999999, 0.027370909999999998, 0.1240642, 0.22958419999999999, 20.55414, 0.29031649999999998, 0.15213199999999999, 0.07109973, 0.0022467590000000001, 7.0744639999999999, 0.19921330000000001, 0.8104751, 0.099842550000000002, 0.61212840000000002, 0.0, 0.5010635}
{3.7744770000000001, 0.1366145, 0.049312059999999998, 0.40760740000000001, 0.022435119999999999, 0.0090477370000000001, 0.57954090000000003, 0.42281999999999997, 6.890244, 7.9266750000000004, 3.59531, 0.034934399999999997, 4.3967200000000002, 1.6439459999999999, 0.2217442, 0.074770409999999995, 0.2166054, 0.096635689999999996, 0.5010635, 0.0}};






fprintf (stdout, mapMatrixToDict (models.protein.alphabet, cpREV), "\n"):


