/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IARRAY_H
#define IARRAY_H

//
//  Automatically-resizable array of type T; the type must have operator =.
//

template<class T>
class iArray
{

public:

	iArray(int inc = 10);
	virtual ~iArray();

    T& operator[](int i);
    const T& operator[](int i) const;

	inline int Size() const { return this->mNum; }
	inline int MaxIndex() const { return this->mNum-1; }

	inline T& Last(){ return this->mArr[this->mNum-1]; }
	inline const T& Last() const { return this->mArr[this->mNum-1]; }

	virtual void Add(const T &val);
	void Remove(int n);
	T RemoveLast();  // useful for deleteting all: while(arr.Size() > 0) delete arr.RemoveLast();
	void Clear();
	void Resize(int n);

	inline const T* Data() const { return this->mArr; }

protected:

	void Extend(int len);

	T* mArr;
	int mNum, mLen;
	const int mInc;

private:

	iArray(const iArray<T>&); // not implemented
	void operator=(const iArray<T>&); // not implemented
};


//
//  This version also needs operator ==
//
template<class T>
class iSearchableArray : public iArray<T>
{

public:

	iSearchableArray(int inc = 10);

	virtual int Find(const T &val) const;
	void AddUnique(const T &val);
	bool Remove(const T &val);

private:

	iSearchableArray(const iSearchableArray<T>&); // not implemented
	void operator=(const iSearchableArray<T>&); // not implemented
};


//
//  This version also needs operator <
//
template<class T>
class iOrderedArray : public iSearchableArray<T>
{

public:

	iOrderedArray(int inc = 10);

	virtual int Find(const T &val) const;
	virtual void Add(const T &val);
	virtual bool Less(const T& v1, const T& v2) const;

private:

	iOrderedArray(const iOrderedArray<T>&); // not implemented
	void operator=(const iOrderedArray<T>&); // not implemented
};

	
template<class T>
inline bool iOrderedArray<T>::Less(const T& v1, const T& v2) const
{
	return v1 < v2;
}

//
//  According to C/C++ standard, comparing pointers using < is not portable.
//  Hence, the pointer array is not ordered.
//
template<class T>
class iPointerArray : public iSearchableArray<T*>
{

public:

	iPointerArray(int inc = 10) : iSearchableArray<T*>(inc){}

private:

	iPointerArray(const iPointerArray<T>&); // not implemented
	void operator=(const iPointerArray<T>&); // not implemented
};

#endif // IARRAY_H
