# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki

XDG_CACHE_HOME ?= $(HOME)/.cache

GARDEN_CACHE_DIR ?= $(if $(value SNAP_USER_COMMON),$(SNAP_USER_COMMON)/cache,$(XDG_CACHE_HOME)/image-garden)
GARDEN_DL_DIR ?= $(GARDEN_CACHE_DIR)/dl
GARDEN_SHARE_DIR = $(or $(wildcard $(abspath $(dir $(filter %/image-garden.mk,$(MAKEFILE_LIST)))/../share/image-garden/)),.)/
GARDEN_ARCH ?= $(shell uname -m)
GARDEN_ARCH := $(GARDEN_ARCH)

MKPASSWD ?= $(or $(shell command -v mkpasswd),$(error program mkpasswd is required))
GENISOIMAGE ?= $(or $(shell command -v genisoimage),$(error program genisoimage is required))
WGET ?= $(or $(shell command -v wget),$(error wget is required))$(if $(value CI), --quiet)

comma=,
nothing=
space:=$(nothing) $(nothing)

map_to_debian_arch=$(or $(value debian_arch_$1),$1)
debian_arch_x86_64=amd64
debian_arch_aarch64=arm64

.DEFAULT_GOAL := help

.PHONY: all
.PHONY: fetch

.PHONY: clean
clean::
	rm -f *.log

.PHONY:
distclean:: clean

$(GARDEN_DL_DIR):
	mkdir -p $@

%: %.xz
	unxz --keep $<

GARDEN_SYSTEMS ?=

.PHONY: help
help: RANDOM_SYSTEM=$(word $(shell bash -c 'expr $$RANDOM % $(words $(GARDEN_SYSTEMS))'),$(GARDEN_SYSTEMS))
help:
	@echo "Usage: image-garden make <SYSTEM>.{run,qcow2}"
	@echo ""
	@echo "Each SYSTEM has a disk image (.qcow2) and a boot script (.run)."
	@echo "Run 'image-garden make list-systems' for a complete list of systems."
	@echo ""
	@echo "To create a disk image and boot script for an example system use:"
	@echo ""
	@echo "    image-garden make $(RANDOM_SYSTEM).run"
	@echo ""
	@echo "Note that this image was selected at random."

.PHONY: list-systems
list-systems:
	@$(foreach i,$(GARDEN_SYSTEMS),echo $i;)
