#!/usr/bin/env python
#!/usr/bin/python
# -*- coding: UTF-8 -*-
#eventCalScreenlet by Wolfgang Arlt.

import screenlets
from screenlets.options import StringOption, BoolOption, ColorOption, IntOption
import cairo
import pango
import gtk
import gobject
import datetime
import locale
from iCal import ICalReader
import sys
class eventCalScreenlet(screenlets.Screenlet):
	"""A iCompatible Screenlet, you can use it with any iCal account like google calendar etc"""
	
	# default meta-info for Screenlets
	__name__ = 'eventCalScreenlet'
	__version__ = '3.36++'
	__author__ = 'Wolfgang Arlt'
	__desc__ = 'A iCalendar Compatible Screenlet, you can use it with any iCal account like google calendar etc'

	# internals
	__timeout = None
	__first_day = 0
	__day_names = []
	rgba_color = (255, 255, 255, 1)
	bg_rgba_color = (0, 0, 0, 0.5)
	todaytxt = 'Heute'
	showAmPm = False
	themeBehind = False
	scaleTheme = True
	roundCorner = True
	
	# settings
	update_interval = 15
	first_weekday = ''
	p_layout = None
	day = ''
	reader = ICalReader()
	event1 = ''
	event2 = ''
	event3 = ''
	event4 = ''
	event5 = ''
	event6 = ''
	event7 = ''
	event8 = ''
	mypath = sys.argv[0][:sys.argv[0].find('eventCalScreenlet.py')].strip()
	icalpath = mypath + 'calendar.ics'
	showevents = True
	autoHide =True
	showEventsUntil = 2
	text = ''
	offset_events = 140
	offset_month = 170
	padding = 10

	demo_number = ''
	int_example = 1
	bool_example = True
	time_example =  (7, 30, 0)
	account_example =  ('','')
	color_example =(0.0, 0.0, 0.0, 1)
	text_font = "FreeSans"
	image_example = ''
	file_example = ''
	directory_example = ''
	list_example = ('','')
	hover = False
	number = 0
    
	# constructor
	def on_init (self, **keyword_args):
                # add menu items
		self.add_menuitem("icspath", "Ics path/file")	
		self.add_menuitem("mini", "Toggle view events")
		self.add_menuitem("update", "Update events")	
                # add the default menu items
		self.add_default_menuitems()

	def __init__(self, **keyword_args):
		screenlets.Screenlet.__init__(self, width=130, height=131, uses_theme=True, **keyword_args) 
		# get localized day names
		locale.setlocale(locale.LC_ALL, '');
		# we convert to unicode here for the first letter extraction to work well
		self.__day_names = [locale.nl_langinfo(locale.DAY_1 + i).decode() for i in range(7)] 
		self.first_weekday = self.__day_names[self.__first_day]
		# call super (and not show window yet)
		# set theme
		self.theme_name = "none"
		# add settings

		self.update_interval = self.update_interval
		self.add_options_group('iCalendar', 'iCal settings')
		self.add_option(StringOption('iCalendar', 'icalpath', self.icalpath, 'iCalendar ics path/file', 'The full path where the .ics file is located , local or url) ...'), realtime=False)
		self.add_option(BoolOption('iCalendar', 'showevents',bool(self.showevents), 'Show iCalendar events','Show iCalendar events'),realtime=True)
		self.add_option(BoolOption('iCalendar', 'autoHide',bool(self.autoHide), 'auto hide on no events','auto hide on no events'),realtime=True)
		self.add_option(IntOption('iCalendar', 'showEventsUntil', self.showEventsUntil, 'future days', 'Amount of future days to show events', min=0, max=30), realtime=False)
		self.add_option(StringOption('iCalendar', 'todaytxt', self.todaytxt,'Today title', '',),realtime=False)
		self.add_option(BoolOption('iCalendar', 'showAmPm',bool(self.showAmPm), 'use 12-hour clock','use 12-hour clock'),realtime=True)
		self.add_option(IntOption('iCalendar', 'update_interval', self.update_interval, 'Update interval', 'The interval for updating info (in seconds)', min=1, max=600),realtime=False)


		self.add_option(ColorOption('iCalendar', 'rgba_color', self.rgba_color, 'Text Color', 'The default color of the text (when no Markup is used) ...'), realtime=True)
		self.add_option(ColorOption('iCalendar', 'bg_rgba_color', self.bg_rgba_color, 'Background Color', 'The default color of the Background.'), realtime=True)
		self.add_option(BoolOption('iCalendar', 'roundCorner',bool(self.roundCorner), 'Background round corners','Draw background with round corners'),realtime=True)
		self.add_option(BoolOption('iCalendar', 'themeBehind',bool(self.themeBehind), 'Theme behind background','Theme behind background'),realtime=True)
		self.add_option(BoolOption('iCalendar', 'scaleTheme',bool(self.scaleTheme), 'Scale theme','Scale theme'),realtime=True)
		self.reader.readURL(self.icalpath)

	# attribute-"setter", handles setting of attributes
	def __setattr__(self, name, value):
		# call Screenlet.__setattr__ in baseclass (ESSENTIAL!!!!)
		screenlets.Screenlet.__setattr__(self, name, value)
		# check for this Screenlet's attributes, we are interested in: 
		if name == ('rgba_color'):
			
			if self.window:
				self.redraw_canvas()
		if name == ('bg_rgba_color'):
			
			if self.window:
				self.redraw_canvas()
		if name == ('icalpath'):
			self.reader = ICalReader()
			self.reader.readURL(self.icalpath)
			if self.window:
				self.redraw_canvas()
		if name == "update_interval":
			if value > 0:
				self.__dict__['update_interval'] = value
				if self.__timeout:
					gobject.source_remove(self.__timeout)
				self.__timeout = gobject.timeout_add(value 
						* 1000, self.update)
			else:
				# TODO: raise exception!!!
				pass
		
		
	
	def get_date_info(self):
		today = datetime.datetime.now()
	

		day = today.strftime("%d")

		month = today.month

		year = today.year

		# apply month shift
		
		# get first day of the updated month
		first_day = datetime.date(year, month, 1)
		# get the month name
		month_name = first_day.strftime("%B")
        # get the day name
		day_name = today.strftime("%A")
		# get the day count
		if month in [1, 3, 5, 7, 8, 10, 12]:
			days_in_month = 31
		elif month != 2:
			days_in_month = 30
		elif year % 4 == 0:
			days_in_month = 29
		else:
			days_in_month = 28
		# find the first day of the month
		start_day = (int(first_day.strftime("%u")) % 7) + 1
		# return as array

		return [day, year, month_name, days_in_month, start_day, day_name]
	
	# timeout-functions
	def update(self):
		self.icalpath = self.icalpath
		self.redraw_canvas()
		return True



	def menuitem_callback(self, widget, id):
		screenlets.Screenlet.menuitem_callback(self, widget, id)

		if id == "mini":
			self.showevents = not self.showevents
			self.redraw_canvas()
		if id=="icspath":
			self.show_edit_dialog()
			
		if id=="update":
			self.update()

	def show_edit_dialog(self):
		# create dialog
		dialog = gtk.Dialog("iCalendar ics path/file", self.window)
		dialog.resize(300, 100)
		dialog.add_buttons(gtk.STOCK_OK, gtk.RESPONSE_OK, 
			gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)
		entrybox = gtk.Entry()
		entrybox.set_text(str(self.icalpath))
		dialog.vbox.add(entrybox)
		entrybox.show()	
		# run dialog
		response = dialog.run()
		if response == gtk.RESPONSE_OK:
			self.icalpath = entrybox.get_text()
			self.updated_recently = 1
		dialog.hide()
		self.update()



	def on_draw(self, ctx):
		# get data
		date = self.get_date_info() # [day, year, month_name, days_in_month, start_day]
		# draw bg (if theme available)
		ctx.set_operator(cairo.OPERATOR_OVER)
		# set size
		ctx.scale(self.scale, self.scale)
		
		if self.theme:
			today=datetime.date.today()
			eventlist1 = []
			date0 = datetime.datetime.today()
			startDate = None
			age = ''
			i = 0
			if self.showevents == True:
				print '\n'
				while i <= self.showEventsUntil:
					for event in self.reader.events:
						firstStart = event.startDateTime
						startDate = event.startsOn(date0)
						occursOn = event.occursOn(date0)
						categories = event.categories
						end = event.endDateTime
						if type(startDate) == datetime.datetime or occursOn:
							if type(categories) == str:
								if (categories.upper()).find('BIRTHDAY') != -1 or (categories.upper()).find('GEBURTSTAG') != -1:
									age = ' (' + str(today.year - firstStart.year) + ')'
							else:
								age = ''
							if type(startDate) == datetime.datetime:
								info = '\t'
								if startDate.hour == 0 and startDate.minute == 0:
									startDate = datetime.date(date0.year, date0.month, date0.day) 
									info = ' ***** \t'
							else:
								startDate = datetime.date(date0.year, date0.month, date0.day)
								info = ' ----->\t'
							eventlist = [(str(startDate), (str(startDate)[11:][:5] + info), (str(event) + age), startDate)]
							eventlist1 = eventlist1 + eventlist
							age = ''
					date0 = date0 + datetime.timedelta(days=1)
					i = i + 1

	            # window size
				self.newWidth = 400
				self.newHeight = 32.75
				eventlist1.sort(key=lambda t:t[0])
				for i in range(0, len(eventlist1)):
					if type(eventlist1[i][3]) == datetime.datetime and self.showAmPm == True:
						if eventlist1[i][3].hour  == 0:
							startTime = '12' + ':' + eventlist1[i][3].strftime('%MA\t')
						elif eventlist1[i][3].hour >= 22 and eventlist1[i][3].hour <= 23 or eventlist1[i][3].hour == 12:
							startTime = eventlist1[i][3].strftime('%I:%MP\t')
						elif eventlist1[i][3].hour >=13 and eventlist1[i][3].hour <= 21:
							startTime = '  ' + (eventlist1[i][3].strftime('%I:%MP\t').lstrip('0'))
						elif eventlist1[i][3].hour >= 10 and eventlist1[i][3].hour <= 11: #or eventlist1[i][3].hour == 0:
							startTime = eventlist1[i][3].strftime('%I:%MA\t').lstrip('0')
						elif eventlist1[i][3].hour >= 1 and eventlist1[i][3].hour <= 9:
							startTime = '  ' + (eventlist1[i][3].strftime('%I:%MA\t').lstrip('0'))

					elif type(eventlist1[i][3]) == datetime.datetime and self.showAmPm == False:
						if eventlist1[i][3].hour == 0:
							startTime = '  ' + str(eventlist1[i][3].hour) + ':' + eventlist1[i][3].strftime('%M\t')
						elif eventlist1[i][3].hour != 0 and eventlist1[i][3].hour <= 9:
							startTime = '  ' + (eventlist1[i][3].strftime('%H:%M\t').lstrip('0'))
						else:
							startTime = eventlist1[i][3].strftime('%H:%M\t')

					else:
						startTime = eventlist1[i][1]
					startDate = eventlist1[i][0][:10]
					startDate = datetime.date(int(startDate[:4]), int(startDate[5:7]), int(startDate[8:10]))
					event = eventlist1[i][2].replace('\\,', ',').replace('\\;', ';').replace('\\\"', '\"').replace('&', '&amp;').replace('<', '&lt;').replace('\\\\','\\')
					event2 = eventlist1[i][2].replace('\\,', ',').replace('\\;', ';').replace('\\\"', '\"').replace('\\\\','\\')
					if len(event.decode('utf-8')) > 30:
						print len(event.decode('utf-8'))
						event0 = str(event)[:30] + '\n\t\t' + str(event)[30:60]
						event1 = str(event)[:21] + '\n\t\t\t\t' + str(event)[21:42]
						self.newHeight = self.newHeight + 16.38
					else:
						event0 = str(event)
						event1 = str(event)
					print str(startDate) + ' ' + str(eventlist1[i][1]) +  str(event0)
					if today == startDate:
						if self.event1 == '':
							self.newHeight = self.newHeight + 32.75
							self.event1 = '<b>'+ self.todaytxt + '</b>' + '\n'
							self.event1 = self.event1 + str(startTime) + str(event0) + '\n'
						else:
							self.newHeight = self.newHeight + 16.38
							self.event1 = self.event1 + str(startTime) +  str(event0) + '\n'
						
					if today + datetime.timedelta(days=1) == startDate:
						if self.event2 == '':
							self.newHeight = self.newHeight + 32.75
							self.event2 = '<b>'+ (today + datetime.timedelta(days=1)).strftime('%A') + '</b>' + '\n'
							self.event2 = self.event2 + str(startTime) + str(event0) + '\n'
						else:
							self.newHeight = self.newHeight + 16.38
							self.event2 = self.event2 + str(startTime) + str(event0) + '\n'

					if today + datetime.timedelta(days=2) == startDate:
						if self.event3 == '':
							self.newHeight = self.newHeight + 32.75
							self.event3 = '<b>'+ (today + datetime.timedelta(days=2)).strftime('%A') + '</b>' + '\n'
							self.event3 = self.event3 + str(startTime) + str(event0) + '\n'
						else:
							self.newHeight = self.newHeight + 16.38
							self.event3 = self.event3 + str(startTime) + str(event0) + '\n'

					if today + datetime.timedelta(days=3) == startDate:
						if self.event4 == '':
							self.newHeight = self.newHeight + 32.75
							self.event4 = '<b>'+ (today + datetime.timedelta(days=3)).strftime('%A') + '</b>' + '\n'
							self.event4 = self.event4 + str(startTime) + str(event0) + '\n'
						else:
							self.newHeight = self.newHeight + 16.38
							self.event4 = self.event4 + str(startTime) + str(event0) + '\n'

					if today + datetime.timedelta(days=4) == startDate:
						if self.event5 == '':
							self.newHeight = self.newHeight + 32.75
							self.event5 = '<b>'+ (today + datetime.timedelta(days=4)).strftime('%A') + '</b>' + '\n'
							self.event5 = self.event5 + str(startTime) + str(event0) + '\n'
						else:
							self.newHeight = self.newHeight + 16.38
							self.event5 = self.event5 + str(startTime) + str(event0) + '\n'

					if today + datetime.timedelta(days=5) == startDate:
						if self.event6 == '':
							self.newHeight = self.newHeight + 32.75
							self.event6 = '<b>'+ (today + datetime.timedelta(days=5)).strftime('%A') + '</b>' + '\n'
							self.event6 = self.event6 + str(startTime) + str(event0) + '\n'
						else:
							self.newHeight = self.newHeight + 16.38
							self.event6 = self.event6 + str(startTime) + str(event0) + '\n'

					if today + datetime.timedelta(days=6) == startDate:
						if self.event7 == '':
							self.newHeight = self.newHeight + 32.75
							self.event7 = '<b>'+ (today + datetime.timedelta(days=6)).strftime('%A') + '</b>' + '\n'
							self.event7 = self.event7 + str(startTime) + str(event0) + '\n'
						else:
							self.newHeight = self.newHeight + 16.38
							self.event7 = self.event7 + str(startTime) + str(event0) + '\n'

					if startDate > today + datetime.timedelta(days=6):
						if self.event8 == '':
							self.newHeight = self.newHeight + 32.75
							self.event8 = '<b>'+ '--------------------------------------------------------------' + '</b>' + '\n'
							self.event8 = self.event8 + startDate.strftime('%d. %m. ') + str(startTime) + str(event1) + '\n'
						else:
							self.newHeight = self.newHeight + 16.38
							self.event8 = self.event8 + startDate.strftime('%d. %m. ') + str(startTime) + str(event1) + '\n'

				self.txt = self.event1
				self.event1 = ''
				self.txt = self.txt + self.event2
				self.event2 = ''
				self.txt = self.txt + self.event3
				self.event3 = ''
				self.txt = self.txt + self.event4
				self.event4 = ''
				self.txt = self.txt + self.event5
				self.event5 = ''
				self.txt = self.txt + self.event6
				self.event6 = ''
				self.txt = self.txt + self.event7
				self.event7 = ''
				self.txt = self.txt + self.event8
				self.event8 = ''

				if self.txt == '':
					print 'no actual events found'

				if self.txt == '' and self.autoHide == True:
					if self.themeBehind == False:
						ctx.set_source_rgba(self.bg_rgba_color[0], self.bg_rgba_color[1], self.bg_rgba_color[2], self.bg_rgba_color[3])
						if self.roundCorner:
							self.draw_rounded_rectangle(ctx,0,0, 17,self.width -4, self.height -4)
						else:
							self.draw_rectangle(ctx,0,0, self.width -4, self.height -4)
						self.theme.render(ctx, 'calendar')
						ctx.set_source_rgba(self.rgba_color[0], self.rgba_color[1], self.rgba_color[2], self.rgba_color[3])
						self.draw_text(ctx, str(date[2]) + ' ' + str(date[1]), self.padding - 10, 10, self.text_font , 9, self.width,pango.ALIGN_CENTER)
						self.draw_text(ctx, str(date[0]), self.padding - 10, 15, self.text_font, 54, self.width,pango.ALIGN_CENTER)
						self.draw_text(ctx, str(date[5]), self.padding - 10, 95, self.text_font , 10, self.width,pango.ALIGN_CENTER)
						self.draw_circle(ctx, 115, 10, 2, 2, fill=True)
		
					else:
						self.theme.render(ctx, 'calendar')
						ctx.set_source_rgba(self.bg_rgba_color[0], self.bg_rgba_color[1], self.bg_rgba_color[2], self.bg_rgba_color[3])
						if self.roundCorner:
							self.draw_rounded_rectangle(ctx,0,0, 17,self.width -4, self.height -4)
						else:
							self.draw_rectangle(ctx,0,0, self.width -4, self.height -4)
						ctx.set_source_rgba(self.rgba_color[0], self.rgba_color[1], self.rgba_color[2], self.rgba_color[3])
						self.draw_text(ctx, str(date[2]) + ' ' + str(date[1]), self.padding - 10, 10, self.text_font , 9, self.width,pango.ALIGN_CENTER)
						self.draw_text(ctx, str(date[0]), self.padding - 10, 15, self.text_font, 54, self.width,pango.ALIGN_CENTER)
						self.draw_text(ctx, str(date[5]), self.padding - 10, 95, self.text_font , 10, self.width,pango.ALIGN_CENTER)
						self.draw_circle(ctx, 115, 15, 2, 2, fill=True)
				else:
					if self.newHeight < 131:
						self.newHeight = 131
					self.window.resize(int(self.newWidth * self.scale), int(self.newHeight * self.scale))
					if self.themeBehind == False:
						ctx.set_source_rgba(self.bg_rgba_color[0], self.bg_rgba_color[1], self.bg_rgba_color[2], self.bg_rgba_color[3])
						if self.roundCorner:
							self.draw_rounded_rectangle(ctx,0,0, 17, self.newWidth -4, self.newHeight -4)
						else:
							self.draw_rectangle(ctx,0,0, self.newWidth -4, self.newHeight -4)
	
						if self.scaleTheme == True:
							try:
								self.theme.draw_scaled_image(ctx, 0, 0, self.mypath + 'themes/' + self.theme_name + '/calendar1.svg', self.newWidth, self.newHeight)
							except: 
								try:
									self.theme.draw_scaled_image(ctx, 0, 0, self.mypath + 'themes/' + self.theme_name + '/calendar1.png', self.newWidth, self.newHeight)
								except: pass # print 'theme not found !'
						else:
							self.theme.render(ctx, 'calendar1')
	
						ctx.set_source_rgba(self.rgba_color[0], self.rgba_color[1], self.rgba_color[2], self.rgba_color[3])
	
		                    # draw month as string
						self.draw_text(ctx, str(date[2]) + ' ' + str(date[1]), self.padding - 10, 10, self.text_font , 9, self.width,pango.ALIGN_CENTER)
	            
		        	    # draw day as number
						self.draw_text(ctx, str(date[0]), self.padding - 10, 15, self.text_font, 54, self.width,pango.ALIGN_CENTER)
	            
			            # draw day as string
						self.draw_text(ctx, str(date[5]), self.padding - 10, 95, self.text_font , 10, self.width,pango.ALIGN_CENTER)
	
		        	    # draw line	
						self.draw_line(ctx, self.offset_events - self.padding, self.padding, 0, self.newHeight - self.padding * 2, 2)
	
					else:
						if self.scaleTheme == True:
							try:
								self.theme.draw_scaled_image(ctx, 0, 0, self.mypath + 'themes/' + self.theme_name + '/calendar1.svg', self.newWidth, self.newHeight)
							except: 
								try:
									self.theme.draw_scaled_image(ctx, 0, 0, self.mypath + 'themes/' + self.theme_name + '/calendar1.png', self.newWidth, self.newHeight)
								except: pass #print 'theme not found !'
						else:
							self.theme.render(ctx, 'calendar1')
	
						ctx.set_source_rgba(self.bg_rgba_color[0], self.bg_rgba_color[1], self.bg_rgba_color[2], self.bg_rgba_color[3])
						if self.roundCorner:
							self.draw_rounded_rectangle(ctx,0,0, 17, self.newWidth, self.newHeight)
						else:
							self.draw_rectangle(ctx,0,0, self.newWidth, self.newHeight)
		
						ctx.set_source_rgba(self.rgba_color[0], self.rgba_color[1], self.rgba_color[2], self.rgba_color[3])
	
		                    # draw month as string
						self.draw_text(ctx, str(date[2]) + ' ' + str(date[1]), self.padding - 10, 10, self.text_font , 9, self.width,pango.ALIGN_CENTER)
	            
		        	    # draw day as number
						self.draw_text(ctx, str(date[0]), self.padding - 10, 15, self.text_font, 54, self.width,pango.ALIGN_CENTER)
	            
			            # draw day as string
						self.draw_text(ctx, str(date[5]), self.padding - 10, 95, self.text_font , 10, self.width,pango.ALIGN_CENTER)
	
		        	    # draw line	
						self.draw_line(ctx,self.offset_events - self.padding, self.padding, 0, self.newHeight - self.padding * 2, 2)
	
					self.draw_text(ctx, self.txt, self.offset_events, 15, self.text_font , 9, self.newWidth,pango.ALIGN_LEFT)
					self.txt = ''
			else:
				if self.themeBehind == False:
					ctx.set_source_rgba(self.bg_rgba_color[0], self.bg_rgba_color[1], self.bg_rgba_color[2], self.bg_rgba_color[3])
					if self.roundCorner:
						self.draw_rounded_rectangle(ctx,0,0, 17,self.width -4, self.height -4)
					else:
						self.draw_rectangle(ctx,0,0, self.width -4, self.height -4)
					self.theme.render(ctx, 'calendar')
					ctx.set_source_rgba(self.rgba_color[0], self.rgba_color[1], self.rgba_color[2], self.rgba_color[3])
					self.draw_text(ctx, str(date[2]) + ' ' + str(date[1]), self.padding - 10, 10, self.text_font , 9, self.width,pango.ALIGN_CENTER)
					self.draw_text(ctx, str(date[0]), self.padding - 10, 15, self.text_font, 54, self.width,pango.ALIGN_CENTER)
					self.draw_text(ctx, str(date[5]), self.padding - 10, 95, self.text_font , 10, self.width,pango.ALIGN_CENTER)

				else:
					self.theme.render(ctx, 'calendar')
					ctx.set_source_rgba(self.bg_rgba_color[0], self.bg_rgba_color[1], self.bg_rgba_color[2], self.bg_rgba_color[3])
					if self.roundCorner:
						self.draw_rounded_rectangle(ctx,0,0, 17,self.width -4, self.height -4)
					else:
						self.draw_rectangle(ctx,0,0, self.width -4, self.height -4)
					ctx.set_source_rgba(self.rgba_color[0], self.rgba_color[1], self.rgba_color[2], self.rgba_color[3])
					self.draw_text(ctx, str(date[2]) + ' ' + str(date[1]), self.padding - 10, 10, self.text_font , 9, self.width,pango.ALIGN_CENTER)
					self.draw_text(ctx, str(date[0]), self.padding - 10, 15, self.text_font, 54, self.width,pango.ALIGN_CENTER)
					self.draw_text(ctx, str(date[5]), self.padding - 10, 95, self.text_font , 10, self.width,pango.ALIGN_CENTER)

	            # resize Window
				self.window.resize(int(self.width * self.scale), int(self.height * self.scale))
				ctx.scale(self.scale, self.scale)

			ctx.stroke ()

							
	def on_draw_shape(self,ctx):
			self.on_draw(ctx)
	

# If the program is run directly or passed as an argument to the python
# interpreter then create a Screenlet instance and show it
if __name__ == "__main__":
	import screenlets.session
	screenlets.session.create_session(eventCalScreenlet)
