#! /bin/sh
#
# Test suite for innupgrade.

# The count starts at 1 and is updated each time ok is printed.  printcount
# takes "ok" or "not ok".
count=1
printcount() {
    echo "$1 $count $2"
    count=$(expr $count + 1)
}

# Run innupgrade with the given arguments and expect it to succeed.
run() {
    perl -Tw ${innupgrade} "$@"
    if [ $? = 0 ]; then
        printcount "ok"
    else
        printcount "not ok"
    fi
}

# Make sure that a file does not exist.
notexists() {
    if [ -r "$1" ]; then
        printcount "not ok"
    else
        printcount "ok"
    fi
}

# Given two files, make sure that the first file exists and that its contents
# match the contents of the second file.
compare() {
    if [ -r "$1" ] && diff "$1" "$2"; then
        printcount "ok"
    else
        printcount "not ok"
    fi
}

# Find the right directory.
innupgrade="../../scripts/innupgrade"
dirs='../data data tests/data'
for dir in $dirs; do
    if [ -r "$dir/upgrade/inn.conf" ]; then
        cd $dir
        break
    fi
done
if [ ! -x "$innupgrade" ]; then
    echo "Could not find innupgrade" >&2
    exit 1
fi

# Print out the number of tests
echo 18

# Save backup copies.
cp "upgrade/incoming.conf" "upgrade/incoming.conf.bad"
cp "upgrade/inn.conf" "upgrade/inn.conf.bad"
cp "upgrade/newsfeeds" "upgrade/newsfeeds.bad"
cp "upgrade/readers.conf" "upgrade/readers.conf.bad"

# Upgrade everything in the directory.
run "upgrade"
compare "upgrade/incoming.conf.OLD" "upgrade/incoming.conf.bad"
compare "upgrade/inn.conf.OLD" "upgrade/inn.conf.bad"
compare "upgrade/newsfeeds.OLD" "upgrade/newsfeeds.bad"
compare "upgrade/readers.conf.OLD" "upgrade/readers.conf.bad"
compare "upgrade/incoming.conf" "upgrade/incoming.conf.ok"
compare "upgrade/inn.conf" "upgrade/inn.conf.ok"
compare "upgrade/newsfeeds" "upgrade/newsfeeds.ok"
compare "upgrade/readers.conf" "upgrade/readers.conf.ok"

if [ -f "upgrade/inn-secrets.conf" ]; then
    printcount "ok"
else
    printcount "not ok"
fi

if [ ! -e "upgrade/overview.fmt" ] && [ -e "upgrade/overview.fmt.OLD" ]; then
    printcount "ok"
else
    printcount "not ok"
fi

# Move inn.conf back and run it again in file mode.
# Also move obsolete files back.
mv -f "upgrade/inn.conf.OLD" "upgrade/inn.conf"
mv -f "upgrade/overview.fmt.OLD" "upgrade/overview.fmt"
mv -f "upgrade/sasl.conf.OLD" "upgrade/sasl.conf"
run "-f" "upgrade/inn.conf"
compare "upgrade/inn.conf.OLD" "upgrade/inn.conf.bad"
compare "upgrade/inn.conf" "upgrade/inn.conf.ok"

if [ -e "upgrade/overview.fmt" ] && [ ! -e "upgrade/overview.fmt.OLD" ]; then
    printcount "ok"
else
    printcount "not ok"
fi

# Run innupgrade on the good file and make sure that it doesn't change
# anything.
run "-f" "upgrade/inn.conf"
compare "upgrade/inn.conf.OLD" "upgrade/inn.conf.bad"
compare "upgrade/inn.conf" "upgrade/inn.conf.ok"

# Clean up.
mv -f "upgrade/incoming.conf.bad" "upgrade/incoming.conf"
mv -f "upgrade/inn.conf.bad" "upgrade/inn.conf"
mv -f "upgrade/newsfeeds.bad" "upgrade/newsfeeds"
mv -f "upgrade/readers.conf.bad" "upgrade/readers.conf"
rm -f "upgrade/incoming.conf.OLD" "upgrade/inn.conf.OLD"
rm -f "upgrade/newsfeeds.OLD" "upgrade/readers.conf.OLD"
rm -f "upgrade/inn-secrets.conf"
