/*
 * File    : AlphaColorChooserPanel.java
 * Created : 25-sep-2002 16:51
 * By      : fbusquets
 *
 * JClic - Authoring and playing system for educational activities
 *
 * Copyright (C) 2000 - 2005 Francesc Busquets & Departament
 * d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 */

package edu.xtec.jclic.beans;

import edu.xtec.util.Options;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JColorChooser;
import javax.swing.colorchooser.ColorSelectionModel;

/**
 *
 * @author Francesc Busquets (fbusquets@xtec.cat)
 * @version 13.08.29
 */
public class AlphaColorChooserPanel extends javax.swing.colorchooser.AbstractColorChooserPanel {
    
    protected javax.swing.JColorChooser currentChooser = null;
    protected Options options;
    /** Creates new form AlphaColorChooserPanel */
    public AlphaColorChooserPanel(Options options) {
        super();
        this.options=options;
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        javax.swing.JLabel alphaLabel;
        java.awt.GridBagConstraints gridBagConstraints;

        alphaSlider = new javax.swing.JSlider();
        alphaLabel = new javax.swing.JLabel();
        alphaTxt = new javax.swing.JTextField();

        setLayout(new java.awt.GridBagLayout());

        alphaSlider.setMajorTickSpacing(50);
        alphaSlider.setMaximum(255);
        alphaSlider.setMinorTickSpacing(10);
        alphaSlider.setPaintLabels(true);
        alphaSlider.setPaintTicks(true);
        alphaSlider.setToolTipText(options.getMsg("edit_color_opacity_tooltip"));
        alphaSlider.setValue(0);
        alphaSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                alphaSliderStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(alphaSlider, gridBagConstraints);

        alphaLabel.setText(options.getMsg("edit_color_opacity"));
        alphaLabel.setLabelFor(alphaTxt);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(alphaLabel, gridBagConstraints);

        alphaTxt.setText("0");
        alphaTxt.setToolTipText(options.getMsg("edit_color_opacity_tooltip"));
        alphaTxt.setPreferredSize(new java.awt.Dimension(40, 21));
        alphaTxt.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(alphaTxt, gridBagConstraints);

    }//GEN-END:initComponents

    private void alphaSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_alphaSliderStateChanged

        int v=alphaSlider.getValue();
        alphaTxt.setText(Integer.toString(v));
        
        ColorSelectionModel csm=getColorSelectionModel();
        if(csm!=null){
            Color c=csm.getSelectedColor();
            Color nc = v < 255
                    ? new Color(c.getRed(), c.getGreen(), c.getBlue(), v)
                    : new Color(c.getRed(), c.getGreen(), c.getBlue());
            csm.setSelectedColor(nc);
        }
        
    }//GEN-LAST:event_alphaSliderStateChanged

    public String getDisplayName() {
        return options.getMsg("edit_color_opacity");
    }    
    
    public javax.swing.Icon getLargeDisplayIcon() {
        return null;
    }    
    
    public javax.swing.Icon getSmallDisplayIcon() {
        return null;
    }
    
    @Override
    public void installChooserPanel(javax.swing.JColorChooser jColorChooser) {
        super.installChooserPanel(jColorChooser);
        currentChooser=jColorChooser;
        setColor(jColorChooser.getColor());
    }
    
    protected void setColor(Color c){
        int a=c.getAlpha();
        alphaSlider.setValue(a);
        alphaTxt.setText(Integer.toString(a));        
    }
    
    public void updateChooser() {
        /*
        ColorSelectionModel csm=getColorSelectionModel();
        if(csm!=null){
            int a=csm.getSelectedColor().getAlpha();
            alphaSlider.setValue(a);
            alphaTxt.setText(Integer.toString(a));
        }
         */
    }
    
    protected void buildChooser() {
        //initComponents();
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSlider alphaSlider;
    private javax.swing.JTextField alphaTxt;
    // End of variables declaration//GEN-END:variables
    
    
    static JColorChooser chooser;
    static AlphaColorChooserPanel accp;
    static ActionListener okListener;
    static ActionListener cancelListener;
    static Object[] result;
    
    public static Color chooseColor(Options options, java.awt.Component parent, Color initialColor){
        if(chooser==null){
            chooser=new JColorChooser(initialColor);
            accp=new AlphaColorChooserPanel(options);
            chooser.addChooserPanel(accp);
            result=new Object[1];
            okListener = new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    result[0] = chooser.getColor();
                }
            };
            cancelListener = new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    result[0] = null;
                }
            };
        }
        
        // 30-mai-2007
        // Clear result between calls to chooseColor
        result[0]=null;
        
        chooser.setColor(initialColor);
        accp.setColor(initialColor);
        JColorChooser.createDialog(parent, options.getMsg("edit_color_dlgTitle"), true, chooser, okListener, cancelListener).setVisible(true);
        return (Color)result[0];
    }
        
}
