/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.exception;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.stripes.config.BootstrapPropertyResolver;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.exception.AutoExceptionHandler;
import net.sourceforge.stripes.exception.DefaultExceptionHandler;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.ResolverUtil;
import net.sourceforge.stripes.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingExceptionHandler
extends DefaultExceptionHandler {
    private static final Log log = Log.getInstance(DelegatingExceptionHandler.class);
    @Deprecated
    public static final String URL_FILTERS = "DelegatingExceptionHandler.UrlFilters";
    @Deprecated
    public static final String PACKAGE_FILTERS = "DelegatingExceptionHandler.PackageFilters";
    public static final String PACKAGES = "DelegatingExceptionHandler.Packages";

    @Override
    public void init(Configuration configuration) throws Exception {
        super.init(configuration);
        Set<Class<? extends AutoExceptionHandler>> handlers = this.findClasses();
        for (Class<? extends AutoExceptionHandler> handler : handlers) {
            if (Modifier.isAbstract(handler.getModifiers())) continue;
            log.debug("Processing class ", handler, " looking for exception handling methods.");
            this.addHandler(handler);
        }
    }

    protected Set<Class<? extends AutoExceptionHandler>> findClasses() {
        String[] packages;
        BootstrapPropertyResolver bootstrap = this.getConfiguration().getBootstrapPropertyResolver();
        if (bootstrap.getProperty(URL_FILTERS) != null || bootstrap.getProperty(PACKAGE_FILTERS) != null) {
            log.error("The configuration properties '", URL_FILTERS, "' and '", PACKAGE_FILTERS, "' are deprecated, and NO LONGER SUPPORTED. Please read the upgrade ", "documentation for Stripes 1.5 for how to resolve this situation. In short ", "you should specify neither ", URL_FILTERS, " nor ", PACKAGE_FILTERS, ". Instead you should specify a comma separated list of package roots ", "(e.g. com.myco.web) that should be scanned for implementations of ", "AutoExceptionHandler, using the configuration parameter '", PACKAGES, "', or include the packages along with other extension packages using the ", "configuration parameter '", "Extension.Packages", "'.");
        }
        if ((packages = StringUtil.standardSplit(bootstrap.getProperty(PACKAGES))) == null || packages.length == 0) {
            log.info("No config parameter '", PACKAGES, "' found. Trying autodiscovery instead.");
            List<Class<AutoExceptionHandler>> classes = bootstrap.getClassPropertyList(AutoExceptionHandler.class);
            if (!classes.isEmpty()) {
                return new HashSet<Class<? extends AutoExceptionHandler>>(classes);
            }
            log.info("Autodiscovery found no implementations of AutoExceptionHandler. Using ", "the value of '", "ActionResolver.Packages", "' instead.");
            packages = StringUtil.standardSplit(bootstrap.getProperty("ActionResolver.Packages"));
        }
        if (packages != null && packages.length > 0) {
            ResolverUtil resolver = new ResolverUtil();
            resolver.findImplementations(AutoExceptionHandler.class, packages);
            return resolver.getClasses();
        }
        return Collections.emptySet();
    }
}

