/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.format.Formatter;
import net.sourceforge.stripes.format.FormatterFactory;
import net.sourceforge.stripes.tag.VarTagSupport;
import net.sourceforge.stripes.util.Log;

public class FormatTag
extends VarTagSupport {
    private static final Log log = Log.getInstance(FormatTag.class);
    private Object value;
    private String formatType;
    private String formatPattern;

    public String getFormatPattern() {
        return this.formatPattern;
    }

    public void setFormatPattern(String formatPattern) {
        this.formatPattern = formatPattern;
    }

    public String getFormatType() {
        return this.formatType;
    }

    public void setFormatType(String formatType) {
        this.formatType = formatType;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    protected String format(Object value) {
        if (value == null) {
            return "";
        }
        FormatterFactory factory = StripesFilter.getConfiguration().getFormatterFactory();
        Formatter<?> formatter = factory.getFormatter(value.getClass(), this.getPageContext().getRequest().getLocale(), this.formatType, this.formatPattern);
        if (formatter == null) {
            return String.valueOf(value);
        }
        return formatter.format(value);
    }

    protected void writeOut(Object value) throws JspException {
        String formatted = this.format(value);
        try {
            this.pageContext.getOut().print(formatted);
        }
        catch (IOException e) {
            JspException jspe = new JspException("IOException encountered while writing formatted value '" + formatted + " to the JspWriter.", (Throwable)e);
            log.warn((Throwable)jspe, new Object[0]);
            throw jspe;
        }
    }

    public int doStartTag() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        if (this.var == null) {
            this.writeOut(this.value);
        } else {
            this.export(this.format(this.value));
        }
        return 6;
    }
}

