// Do not edit this file, it is autogenerated by CMake from the .md file
_HKI( "# 1 - Full documentation\n"
"\n"
"The Eeschema documentation (*eeschema.html*) describes this intermediate netlist and gives examples(chapter ***creating customized netlists and bom files***).\n"
"\n"
"# 2 - The intermediate Netlist File\n"
"\n"
"BOM files (and netlist files) can be created from an *Intermediate netlist file* created by Eeschema.\n"
"\n"
"This file uses XML syntax and is called the intermediate netlist. The intermediate netlist includes a large amount of data about your board and because of this, it can be used with post-processing to create a BOM or other reports.\n"
"\n"
"Depending on the output (BOM or netlist), different subsets of the complete Intermediate Netlist file will be used in the post-processing.\n"
"\n"
"# 3 - Conversion to a new format\n"
"\n"
"By applying a post-processing filter to the Intermediate netlist file you can generate foreign netlist files as well as BOM files. Because this conversion is a text to text transformation, this post-processing filter can be written using *Python*, *XSLT*, or any other tool capable of taking XML as input.\n"
"\n"
"XSLT itself is a XML language suitable for XML transformations. There is a free program called `xsltproc` that you can download and install. The `xsltproc` program can be used to read the Intermediate XML netlist input file, apply a style-sheet to transform the input, and save the results in an output file. Use of `xsltproc` requires a style-sheet file using XSLT conventions. The full conversion process is handled by Eeschema, after it is configured once to run `xsltproc` in a specific way.\n"
"\n"
"A Python script is somewhat more easy to create.\n"
"\n"
"# 4 - Initialization of the dialog window\n"
"\n"
"You should add a new plugin (a script) in the plugin list by clicking on the Add Plugin button.\n"
"\n"
"## 4.1 - Plugin Configuration Parameters\n"
"\n"
"The Eeschema plug-in configuration dialog requires the following information:\n"
"\n"
" * The title: for instance, the name of the netlist format.\n"
" * The command line to launch the converter (usually a script).\n"
"\n"
"***Note (Windows only):***\n"
"*By default, the command line runs with hidden console window and output is redirected to \"Plugin info\" field. To show the window of the running command, set the checkbox \"Show console window\".*\n"
"\n"
"Once you click on the generate button the following will happen:\n"
"\n"
"1. Eeschema creates an intermediate netlist file \\*.xml, for instance `test.xml`.\n"
"2. Eeschema runs the script from the command line to create the final output file.\n"
"\n"
"## 4.2 - Generate netlist files with the command line\n"
"\n"
"Assuming we are using the program `xsltproc.exe` to apply the sheet style to the intermediate file, `xsltproc.exe` is executed with the following command.\n"
"\n"
"```\n"
"xsltproc.exe -o <output filename> <style-sheet filename> <input XML file to convert>\n"
"```\n"
"\n"
"On Windows the command line is the following.\n"
"\n"
"```\n"
"f:/kicad/bin/xsltproc.exe -o \"%O\" f:/kicad/bin/plugins/myconverter.xsl \"%I\"\n"
"```\n"
"\n"
"On Linux the command becomes as following.\n"
"\n"
"```\n"
"xsltproc -o \"%O\" /usr/local/kicad/bin/plugins/myconverter .xsl \"%I\"\n"
"```\n"
"where `myconverter.xsl` is the style-sheet that you are applying.\n"
"\n"
"Do not forget the double quotes around the file names, this allows them to have spaces after the substitution by Eeschema.\n"
"\n"
"If a Python script is used, the command line is something like (depending on the Python script):\n"
"\n"
"```\n"
"python f:/kicad/bin/plugins/bom-in-python/myconverter.py \"%I\" \"%O\"\n"
"```\n"
"\n"
"or\n"
"\n"
"```\n"
"python /usr/local/kicad/bin/plugins/bom-in-python/myconverter .xsl \"%I\" \"%O\"\n"
"```\n"
"\n"
"The command line format accepts parameters for filenames. The supported formatting parameters are:\n"
"\n"
" * `%B`: base filename of selected output file, minus path and extension.\n"
" * `%P`: project directory, without name and without trailing '/'.\n"
" * `%I`: complete filename and path of the temporary input file\n"
"(the intermediate net file).\n"
" * `%O`: complete filename and path (but without extension) of the user\n"
"chosen output file.\n"
"\n"
"`%I` will be replaced by the actual intermediate file name (usually the full root sheet filename with extension \".xml\").\n"
"`%O` will be replaced by the actual output file name (the full root sheet filename minus extension).\n"
"`%B` will be replaced by the actual output short file name (the short root sheet filename minus extension).\n"
"`%P` will be replaced by the actual current project path.\n"
"\n"
"## 4.3 - Command line format:\n"
"\n"
"### 4.3.1 - Remark:\n"
"\n"
"Most of time, the created file must have an extension, depending on its type.\n"
"Therefore you have to add to the option ***%O*** the right file extension.\n"
"\n"
"For instance:\n"
"\n"
" * **%O.csv** to create a .csv file (comma separated value file).\n"
" * **%O.htm** to create a .html file.\n"
" * **%O.bom** to create a .bom file.\n"
"\n"
"### 4.3.2 Example for xsltproc:\n"
"\n"
"The command line format for xsltproc is the following:\n"
"\n"
"```\n"
"<path of xsltproc> xsltproc <xsltproc parameters>\n"
"```\n"
"\n"
"On Windows:\n"
"```\n"
"f:/kicad/bin/xsltproc.exe -o \"%O.bom\" f:/kicad/bin/plugins/netlist_form_pads-pcb.xsl \"%I\"\n"
"```\n"
"\n"
"On Linux:\n"
"```\n"
"xsltproc -o \"%O.bom\" /usr/local/kicad/bin/plugins/netlist_form_pads-pcb.xsl \"%I\"\n"
"```\n"
"\n"
"The above examples assume `xsltproc` is installed on your PC under Windows and xsl files located in `<path_to_kicad>/kicad/bin/plugins/`.\n"
"\n"
"\n"
"### 4.3.3 Example for Python scripts:\n"
"\n"
"Assuming python is installed on your PC, and python scripts are located in\n"
"\n"
" `<path_to_kicad>/kicad/bin/plugins/bom-in-python/`,\n"
"\n"
"the command line format for python is something like:\n"
"\n"
"```\n"
"python <script file name> <input filename> <output filename>\n"
"```\n"
"\n"
"On Windows:\n"
"```\n"
"python.exe f:/kicad/bin/plugins/bom-in-python/my_python_script.py \"%I\" \"%O.html\"\n"
"```\n"
"\n"
"On Linux:\n"
"```\n"
"python /usr/local/kicad/bin/plugins/bom-in-python/my_python_script.py \"%I\" \"%O.csv\"\n"
"```\n"
"" );
