/***************************************************************************
                          chatmessage.cpp -  description
                             -------------------
    begin                : Sat Okt 29 2005
    copyright            : (C) 2005 by Diederik van der Boor
    email                : "vdboor" --at-- "codingdomain.com"
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "chatmessage.h"



// The constructor
ChatMessage::ChatMessage( const MessageType      type,
                          const ContentsClass    contentsClass,
                                bool             isIncoming,
                          const QString &        body,
                          const QString &        contactHandle,
                          const QString &        contactName,
                          const QString &        contactPicturePath,
                          const QFont &          font,
                          const QString &        fontColor,
                          const QDateTime &      time )
  : body_(body)
  , contactHandle_(contactHandle)
  , contactName_(contactName)
  , contactPicturePath_(contactPicturePath)
  , contentsClass_(contentsClass)
  , font_(font)
  , fontColor_(fontColor)
  , isIncoming_(isIncoming)
  , time_(time)
  , type_(type)
{

}



// The destructor
ChatMessage::~ChatMessage()
{
}



// A clone method for ChatView::showMessage()
ChatMessage * ChatMessage::clone() const
{
  return new ChatMessage(type_, contentsClass_, isIncoming_, body_, contactHandle_, contactName_, contactPicturePath_, font_, fontColor_, time_ );
}



// Return the message body
const QString & ChatMessage::getBody() const
{
  return body_;
}



// Return the handle of the sending contact
const QString & ChatMessage::getContactHandle() const
{
  return contactHandle_;
}



// Return the name of the sending contact
const QString & ChatMessage::getContactName() const
{
  return contactName_;
}



// Return the path of the sending contact's picture
const QString & ChatMessage::getContactPicturePath() const
{
  return contactPicturePath_;
}



// Return the message contents class
ChatMessage::ContentsClass ChatMessage::getContentsClass() const
{
  return contentsClass_;
}



// Return the message date and time (for offline-im messages)
const QDateTime & ChatMessage::getDateTime() const
{
  return time_;
}


// Return the message font
const QFont & ChatMessage::getFont() const
{
  return font_;
}



// Return the message font color
const QString & ChatMessage::getFontColor() const
{
  return fontColor_;
}



// Return the message time
const QTime ChatMessage::getTime() const
{
  return time_.time();
}



// Return the message type
ChatMessage::MessageType ChatMessage::getType() const
{
  return type_;
}



// Return whether the body is already in HTML format.
bool ChatMessage::hasHtmlBody() const
{
  return ( contentsClass_ == CONTENT_MESSAGE_INK );
}



// Return whether the message is incoming or outgoing
bool ChatMessage::isIncoming() const
{
  return isIncoming_;
}



// Return whether it's a normal chat message
bool ChatMessage::isNormalMessage() const
{
  return (type_ == TYPE_INCOMING || type_ == TYPE_OUTGOING || type_ == TYPE_OFFLINE_INCOMING);
}


