/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "addressbook_description.h"
#include "addressbook_listingmodel.h"
#include "addressbook_policy.h"
#include "addressbook_record.h"

#include "addressbook_page.h"

AddressBookPage::AddressBookPage()
  : mModel( 0 ), mDescription( 0 ),
    mPolicy( 0 ), mRecord( 0 )
{
}

AddressBookPage::~AddressBookPage()
{
  delete mModel;
  mModel = 0;

  delete mDescription;
  mDescription = 0;

  delete mPolicy;
  mPolicy = 0;

  delete mRecord;
  mRecord = 0;
}

QString AddressBookPage::name() const
{
  return "addressbook";
}

QString AddressBookPage::title() const
{
  return QObject::tr( "Addressbook" );
}

QString AddressBookPage::description() const
{
  return QObject::tr( "Manage global LDAP address book" );
}

QString AddressBookPage::iconName() const
{
  return "addressbook";
}

ListingModel* AddressBookPage::model()
{
  if ( !mModel )
    mModel = new AddressBookListingModel;

  return mModel;
}

Form::Description* AddressBookPage::formDescription()
{
  if ( !mDescription )
    mDescription = new Form::AddressBookDescription;

  return mDescription;
}

Form::PagePolicy* AddressBookPage::formPolicy()
{
  if ( !mPolicy )
    mPolicy = new Form::AddressBookPolicy;

  return mPolicy;
}

Form::Record* AddressBookPage::formRecord()
{
  if ( !mRecord )
    mRecord = new Form::AddressBookRecord;

  return mRecord;
}
