/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#ifndef HEADER_CLIENTMAINWINDOW
#define HEADER_CLIENTMAINWINDOW

#include <QtGui>
#include <QObject>
#include <QToolButton>
#include <QSystemTrayIcon>
#include <QStatusBar>
#include <QMenu>
#include <QSettings>
#include <QMessageBox>
#include <QAction>
#include <QProgressBar>
#include <QApplication>
#include <QSystemTrayIcon>
#include <QDesktopWidget>
#include "../../commons/win32/qtwin.h"
#include "../../commons/startup/update_manager.h"
#include "../../commons/startup/user_mode.h"
#include "client_central_window.h"
#include "../../commons/constants.h"
#include "../../commons/about_dialog.h"

class ClientMainWindow : public QMainWindow
{
    Q_OBJECT

public: 
    ClientMainWindow(QWidget *parent = 0);
    void centerOnScreen();
    ClientCentralWindow *centralWindow;
    void createActions();
    void createTrayIcon();

private:
    QSystemTrayIcon *trayIcon;
    QMenu *trayIconMenu;
    QAction *minimizeAction;
    QAction *maximizeAction;
    QAction *restoreAction;
    QAction *switchModeAction;
    QAction *quitAction;
    QAction *aboutAction;
    QAction *addComputerAction;
    QAction *updateAction;
    QStatusBar *toolBar;
    QProgressBar *progressBar;
    QSettings *settings;
    AboutDialog *aboutDialog;

public slots:
    void switchMode();
    void iconActivated(QSystemTrayIcon::ActivationReason reason);
    void displayAbout();
    void showMessage(QString title, QString content, int duration);
    void displayUpdateManager();
    void fullScreenMode();
    void switchUserMode();

signals:

protected:
    void closeEvent(QCloseEvent *event);
    void resizeEvent(QResizeEvent* event);
};


#endif
