#   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud
#   Contact : <admin.kontrol@gmail.com>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as
#   published by the Free Software Foundation; either version 2.0 of
#   the License, or (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   General Public License for more details.
#
#   You should have received a copy of the GNU General Public
#   License along with this program; if not, write to
#   the Free Software Foundation, Inc.,
#   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

win32 {
        INCLUDEPATH += C:\\sqlite3\\include C:\\OpenSSL\\include C:\\libxml2\\lib\\include\\libxml2 ..\\libsecuretcp
        LIBS += -LC:\\sqlite3 -lsqlite3.dll -L..\\bin -lsecuretcp0 -LC:\libxml2\lib\lib -lxml2 -LC:\\OpenSSL\\lib\\MinGW -leay32 -LC:\Qt\2010.02.1\mingw\lib -lws2_32 -lwsock32
}
linux-g++ {
        INCLUDEPATH += /usr/include/openssl ../libsecuretcp /usr/include/libxml2
       LIBS += -L/usr/lib -lssl -L../bin -lsecuretcp -lxml2 -lsqlite3
}
macx {
        INCLUDEPATH += /usr/include/openssl ../libsecuretcp /usr/include/libxml2
        LIBS += -L/usr/lib  -lcrypto -F../bin -framework securetcp -lxml2 -lsqlite3
}
QT += core network xml
TARGET = kontrolpack
CONFIG += qt thread

RESOURCES = resources.qrc
win32:RC_FILE = KontrolPack.rc
macx:ICON = KontrolPack.icns

SOURCES += main.cpp \
commons/startup/startup_dialog.cpp \
commons/startup/update_manager.cpp \
commons/startup/user_mode.cpp \
commons/win32/qtwin.cpp \
commons/sql/database.cpp \
commons/about_dialog.cpp \
commons/logger.cpp \
server/ui/server_central_window.cpp \
server/ui/server_main_window.cpp \
server/core/network/connection_controller.cpp \
server/core/network/file_manager_server.cpp \
server/core/shell/exec_thread.cpp \
commons/cd/change_dir.cpp \
server/core/xml/xml_creator_server.cpp \
server/core/xml/xml_parser_server.cpp \
server/core/bean/document.cpp \
client/ui/client_home.cpp \
client/ui/client_central_window.cpp \
client/ui/client_main_window.cpp \
client/ui/tab_dialog.cpp \
client/ui/remote_computer.cpp \
client/ui/dns/dns_resolver.cpp \
client/ui/tabui/share_files.cpp \
client/ui/tabui/identity_client.cpp \
client/ui/tabui/exec_shell.cpp \
client/ui/tabui/defined_command.cpp \
client/ui/extend/drop_list_view.cpp \
client/core/network/socket_controller.cpp \
client/core/network/file_manager.cpp \
client/core/xml/xml_creator_client.cpp \
client/core/xml/xml_parser_client.cpp \
client/core/bean/os_characteristic.cpp \
client/core/bean/remote_computer_info.cpp \
client/core/bean/command.cpp \
client/core/bean/folder.cpp \
client/core/bean/file.cpp

HEADERS += commons/startup/startup_dialog.h \
commons/startup/update_manager.h \
commons/startup/user_mode.h \
commons/win32/qtwin.h \
commons/constants.h \
commons/sql/database.h \
commons/about_dialog.h \
commons/logger.h \
server/ui/server_central_window.h \
server/ui/server_main_window.h \
server/core/network/connection_controller.h \
server/core/network/file_manager_server.h \
server/core/shell/exec_thread.h \
commons/cd/change_dir.h \
server/core/xml/xml_creator_server.h \
server/core/xml/xml_parser_server.h \
server/core/bean/document.h \
client/ui/client_home.h \
client/ui/client_central_window.h \
client/ui/client_main_window.h \
client/ui/remote_computer.h \
client/ui/dns/dns_resolver.h \
client/ui/tab_dialog.h \
client/ui/tabui/share_files.h \
client/ui/tabui/identity_client.h \
client/ui/tabui/exec_shell.h \
client/ui/tabui/defined_command.h \
client/ui/extend/drop_list_view.h \
client/core/network/socket_controller.h \
client/core/network/file_manager.h \
client/core/xml/xml_creator_client.h \
client/core/xml/xml_parser_client.h \
client/core/bean/os_characteristic.h \
client/core/bean/remote_computer_info.h \
client/core/bean/command.h \
client/core/bean/folder.h \
client/core/bean/file.h

CONFIG(debug, debug|release) {
  DESTDIR       = ../bin
  RCC_DIR  = ../tmp
  OBJECTS_DIR  = ../tmp
  MOC_DIR  = ../tmp
}
CONFIG(release, debug|release) {
  DESTDIR       = ../bin
  RCC_DIR  = ../tmp
  OBJECTS_DIR  = ../tmp
  MOC_DIR  = ../tmp
}
