# Utility functions
function(list_to_bulletpoints result)
    list(REMOVE_AT ARGV 0)
    set(temp "")
    foreach(item ${ARGV})
        set(temp "${temp}* ${item}\n")
    endforeach()
    set(${result} "${temp}" PARENT_SCOPE)
endfunction(list_to_bulletpoints)

function(validate_option name values)
    string(TOLOWER ${${name}} needle_lower)
    string(TOUPPER ${${name}} needle_upper)
    list(FIND ${values} ${needle_lower} IDX_LOWER)
    list(FIND ${values} ${needle_upper} IDX_UPPER)
    if(${IDX_LOWER} LESS 0 AND ${IDX_UPPER} LESS 0)
        list_to_bulletpoints(POSSIBLE_VALUE_LIST ${${values}})
        message(FATAL_ERROR "\n########################################################################\n"
                            "Invalid value '${${name}}' for option ${name}\n"
                            "\n"
                            "Possible values are:\n"
                            "${POSSIBLE_VALUE_LIST}"
                            "########################################################################")
    endif()
endfunction(validate_option)

function(get_lammps_version version_header variable)
    file(READ ${version_header} line)
    set(MONTHS x Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec)
    string(REGEX REPLACE "#define LAMMPS_VERSION \"([0-9]+) ([A-Za-z]+) ([0-9]+)\"" "\\1" day "${line}")
    string(REGEX REPLACE "#define LAMMPS_VERSION \"([0-9]+) ([A-Za-z]+) ([0-9]+)\"" "\\2" month "${line}")
    string(REGEX REPLACE "#define LAMMPS_VERSION \"([0-9]+) ([A-Za-z]+) ([0-9]+)\"" "\\3" year "${line}")
    string(STRIP ${day} day)
    string(STRIP ${month} month)
    string(STRIP ${year} year)
    list(FIND MONTHS "${month}" month)
    string(LENGTH ${day} day_length)
    string(LENGTH ${month} month_length)
    if(day_length EQUAL 1)
        set(day "0${day}")
    endif()
    if(month_length EQUAL 1)
        set(month "0${month}")
    endif()
    set(${variable} "${year}${month}${day}" PARENT_SCOPE)
endfunction()

function(check_for_autogen_files source_dir)
    message(STATUS "Running check for auto-generated files from make-based build system")
    file(GLOB SRC_AUTOGEN_FILES ${source_dir}/style_*.h)
    file(GLOB SRC_AUTOGEN_PACKAGES ${source_dir}/packages_*.h)
    list(APPEND SRC_AUTOGEN_FILES ${SRC_AUTOGEN_PACKAGES} ${source_dir}/lmpinstalledpkgs.h ${source_dir}/lmpgitversion.h)
    foreach(_SRC ${SRC_AUTOGEN_FILES})
      get_filename_component(FILENAME "${_SRC}" NAME)
      if(EXISTS ${source_dir}/${FILENAME})
        message(FATAL_ERROR "\n########################################################################\n"
                              "Found header file(s) generated by the make-based build system\n"
                              "\n"
                              "Please run\n"
                              "make -C ${source_dir} purge\n"
                              "to remove\n"
                              "########################################################################")
      endif()
    endforeach()
endfunction()

macro(pkg_depends PKG1 PKG2)
  if(PKG_${PKG1} AND NOT (PKG_${PKG2} OR BUILD_${PKG2}))
    message(FATAL_ERROR "${PKG1} package needs LAMMPS to be build with ${PKG2}")
  endif()
endmacro()
