/*
 * Copyright Stichting FOM, 2011
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 */

/**
   \file _lcmaps_verify_account_from_pem.h

   \brief the secret interface specification

   This file has been cloned from _lcmaps_return_account_from_pem.h
   where every occurance of RETURN_ and return_ have been replaced by VERIFY_ 
   and verify_ respectively.

   This is probably reason to further combine and generalize these interfaces.
   
   \ingroup LcmapsHiddenInterface
 */
#ifndef _LCMAPS_VERIFY_ACCOUNT_FROM_PEM_H
#define _LCMAPS_VERIFY_ACCOUNT_FROM_PEM_H

# ifdef LCMAPS_USE_DLOPEN

/*!
  \def LCMAPS_LIB_VERIFY_ACCOUNT_FROM_PEM
  \brief The name of the shared object that implements the interface.
*/
#define LCMAPS_LIB_VERIFY_ACCOUNT_FROM_PEM "liblcmaps_verify_account_from_pem" LIBSUFF

/**
   \struct _lcmaps_handle_verify_account_from_pem_s
    \brief Struct containing all the LCMAPS functions, will be filled using dlsym() 
*/
typedef struct _lcmaps_handle_verify_account_from_pem_s {
    const char *libfilename;
    const char *helpername;
    void *handle,*helper;   /* handles to the LCMAPS library and its optional
			       helper (the latter is needed for the 'old' API to
			       provide missing symbols) */
    char *errmsg;
    lcmaps_init_t *lcmaps_init;
    lcmaps_account_info_init_t *lcmaps_account_info_init;
    lcmaps_verify_account_from_pem_t *lcmaps_verify_account_from_pem;
    lcmaps_term_t *lcmaps_term;
    lcmaps_account_info_clean_t *lcmaps_account_info_clean;
    /* Remainder is for 'new' API */
    /* LCMAPS_HANDLE_VERSION_MEMBERS; */
    getMajorVersion_t *getMajorVersion;
    lcmaps_get_major_version_t *lcmaps_get_major_version;
    lcmaps_get_minor_version_t *lcmaps_get_minor_version;
    lcmaps_get_patch_version_t *lcmaps_get_patch_version;
    /* If the above cannot be found (old lcmaps) these values will be
       set to 0 */
    int majorversion, minorversion, patchversion;
    /* Next three is the 'OSG API' */
    lcmaps_disable_voms_attributes_verification_t *lcmaps_disable_voms_attributes_verification;
    lcmaps_enable_voms_attributes_verification_t *lcmaps_enable_voms_attributes_verification;
    lcmaps_is_set_to_verify_voms_attributes_t *lcmaps_is_set_to_verify_voms_attributes;
} _lcmaps_handle_verify_account_from_pem_t;

/* The declarator of the handle object */
#define _LCMAPS_DECL_HANDLE_VERIFY_ACCOUNT_FROM_PEM(l) \
    _lcmaps_handle_verify_account_from_pem_t l = {    \
	LCMAPS_LIB_VERIFY_ACCOUNT_FROM_PEM,	      \
	LCMAPS_FIXVOMSHACKSO,			      \
	NULL,					      \
	NULL,					      \
	NULL,					      \
        NULL,					      \
        NULL,					      \
        NULL,					      \
        NULL,					      \
        NULL,					      \
        NULL,					      \
        NULL,					      \
        NULL,					      \
        NULL,					      \
        -1,-1,-1,				      \
        NULL,					      \
        NULL,					      \
        NULL,					      \
    };


/* The initializer of the handle object */
#define _LCMAPS_INIT_HANDLE_VERIFY_ACCOUNT_FROM_PEM(l)			\
    (									\
    (l)->libfilename = LCMAPS_LIB_VERIFY_ACCOUNT_FROM_PEM,		\
    (l)->helpername = LCMAPS_FIXVOMSHACKSO,				\
    (l)->handle = (l)->helper = NULL,					\
    (l)->errmsg = NULL,							\
    (l)->majorversion = (l)->minorversion = (l)->patchversion = -1,	\
    (l)->lcmaps_init = NULL,						\
    (l)->lcmaps_account_info_init = NULL,				\
    (l)->lcmaps_verify_account_from_pem = NULL,				\
    (l)->lcmaps_term = NULL,						\
    (l)->lcmaps_account_info_clean = NULL,				\
    (l)->getMajorVersion = NULL,					\
    (l)->lcmaps_disable_voms_attributes_verification = NULL,		\
    (l)->lcmaps_enable_voms_attributes_verification = NULL,		\
    (l)->lcmaps_is_set_to_verify_voms_attributes = NULL,		\
    1									\
    )


/* The single macro to call to initialize lcmaps */
#define _LCMAPS_LOAD_VERIFY_ACCOUNT_FROM_PEM(l)				\
    (									\
     _LCMAPS_LOAD_INTERFACE_WITH_FIX(l)					\
     && LCMAPS_LOAD_FUNC(l,lcmaps_init)					\
     && LCMAPS_LOAD_FUNC(l,lcmaps_account_info_init)			\
     && LCMAPS_LOAD_FUNC(l,lcmaps_verify_account_from_pem)		\
     && LCMAPS_LOAD_FUNC(l,lcmaps_term)					\
     && LCMAPS_LOAD_FUNC(l,lcmaps_account_info_clean)			\
    )	    

# else /* LCMAPS_USE_DLOPEN */

typedef void * _lcmaps_handle_verify_account_from_pem_t;

#define _LCMAPS_DECL_HANDLE_VERIFY_ACCOUNT_FROM_PEM(l)
#define _LCMAPS_INIT_HANDLE_VERIFY_ACCOUNT_FROM_PEM(l) (l = NULL)
#define _LCMAPS_INTERFACE_VERIFY_ACCOUNT_FROM_PEM(l) (1)

# endif /* LCMAPS_USE_DLOPEN */

#endif /* _LCMAPS_VERIFY_ACCOUNT_FROM_PEM_H */
