package tests::ConfigVariableIndexTest;

use base qw/Lire::Test::TestCase tests::TestStoreFixture/;

use Lire::ReportSpec;
use Lire::Config::Index;
use Lire::Config::VariableIndex;

sub new {
    my $self = shift->SUPER::new( @_ );

    $self->init();

    return $self;
}
sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->set_up_test_schema();
    $self->{'cfg'}{'lr_reports_path'} = [ "$self->{'testdir'}/reports" ];
    $self->{'table_info'} =
      Lire::ReportSpec->load( 'test', 'downloads-by-period' )->create_table_info();
    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    return;
}

sub test_new {
    my $self = $_[0];

    my $index = new Lire::Config::VariableIndex( $self->{'table_info'} );
    $self->assert_isa( 'Lire::Config::VariableIndex', $index );
    $self->assert_str_equals( $self->{'table_info'}, $index->{'_info'} );
    $self->assert_str_equals( 'both', $index->{'_type'} );
}

sub test_has_entry {
    my $self = $_[0];

    my $index = new Lire::Config::VariableIndex( $self->{'table_info'},
                                                 'categorical' );
    $self->assert( $index->has_entry( 'timegroup:time_start' ) ? 1 : 0,
                   'timegroup:time_start' );
    $self->assert( !$index->has_entry( 'download_count' ) ? 1 : 0,
                   '! download_count' );

    $index->{'_type'} = 'both';
    $self->assert( $index->has_entry( 'timegroup:time_start' ) ? 1 : 0,
                   'timegroup:time_start' );
    $self->assert( $index->has_entry( 'download_count' ) ? 1 : 0,
                   'download_count' );

    $index->{'_type'} = 'numerical';
    $self->assert( !$index->has_entry( 'timegroup:time_start' ) ? 1 : 0,
                   '! timegroup:time_start' );
    $self->assert( $index->has_entry( 'download_count' ) ? 1 : 0,
                   'download_count' );
}

sub test_entries {
    my $self = $_[0];

    my $index = new Lire::Config::VariableIndex( $self->{'table_info'} );
    $self->assert_deep_equals( [ 'timegroup:time_start', 'download_count',
                                 'download_ratio', 'user_count', 'user_ratio',
                               ], $index->entries() );

    $index->{'_type'} = 'categorical';
    $self->assert_deep_equals( [ 'timegroup:time_start' ], $index->entries() );

    $index->{'_type'} = 'numerical';
    $self->assert_deep_equals( [ 'download_count', 'download_ratio',
                                 'user_count', 'user_ratio' ],
                               $index->entries() );
}

sub test_get_ref {
    my $self = $_[0];

    my $index = new Lire::Config::VariableIndex( $self->{'table_info'} );
    $self->assert_dies( qr/no variable "test3"/,
                        sub { $index->get_ref( 'test3' ) } );
    $self->assert_str_equals( $self->{'table_info'}->column_info_by_name( 'timegroup:time_start' ),
                              $index->get_ref( 'timegroup:time_start' ) );
}

1;
