; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnuabi < %s | FileCheck %s
; RUN: llc -mtriple=aarch64_be-linux-gnuabi < %s | FileCheck %s --check-prefix=CHECK-BE

define void @udiv129(i129* %ptr, i129* %out) nounwind {
; CHECK-LABEL: udiv129:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #112
; CHECK-NEXT:    ldp x10, x11, [x0]
; CHECK-NEXT:    stp x30, x19, [sp, #96] // 16-byte Folded Spill
; CHECK-NEXT:    mov x19, x1
; CHECK-NEXT:    mov w8, #3
; CHECK-NEXT:    ldrb w9, [x0, #16]
; CHECK-NEXT:    add x0, sp, #64
; CHECK-NEXT:    add x1, sp, #32
; CHECK-NEXT:    mov x2, sp
; CHECK-NEXT:    mov w3, #256
; CHECK-NEXT:    stp x9, xzr, [sp, #48]
; CHECK-NEXT:    stp xzr, xzr, [sp, #8]
; CHECK-NEXT:    stp xzr, x10, [sp, #24]
; CHECK-NEXT:    str x11, [sp, #40]
; CHECK-NEXT:    str x8, [sp]
; CHECK-NEXT:    bl __udivei4
; CHECK-NEXT:    ldr w8, [sp, #80]
; CHECK-NEXT:    ldp x9, x10, [sp, #64]
; CHECK-NEXT:    and w8, w8, #0x1
; CHECK-NEXT:    stp x9, x10, [x19]
; CHECK-NEXT:    strb w8, [x19, #16]
; CHECK-NEXT:    ldp x30, x19, [sp, #96] // 16-byte Folded Reload
; CHECK-NEXT:    add sp, sp, #112
; CHECK-NEXT:    ret
;
; CHECK-BE-LABEL: udiv129:
; CHECK-BE:       // %bb.0:
; CHECK-BE-NEXT:    sub sp, sp, #112
; CHECK-BE-NEXT:    ldp x11, x10, [x0]
; CHECK-BE-NEXT:    mov w8, #3
; CHECK-BE-NEXT:    stp x30, x19, [sp, #96] // 16-byte Folded Spill
; CHECK-BE-NEXT:    ldrb w9, [x0, #16]
; CHECK-BE-NEXT:    mov x19, x1
; CHECK-BE-NEXT:    add x0, sp, #64
; CHECK-BE-NEXT:    add x1, sp, #32
; CHECK-BE-NEXT:    stp x8, xzr, [sp, #24]
; CHECK-BE-NEXT:    mov x2, sp
; CHECK-BE-NEXT:    extr x8, x11, x10, #56
; CHECK-BE-NEXT:    lsr x11, x11, #56
; CHECK-BE-NEXT:    bfi x9, x10, #8, #56
; CHECK-BE-NEXT:    mov w3, #256
; CHECK-BE-NEXT:    stp xzr, xzr, [sp, #8]
; CHECK-BE-NEXT:    str xzr, [sp]
; CHECK-BE-NEXT:    stp x11, x8, [sp, #40]
; CHECK-BE-NEXT:    str x9, [sp, #56]
; CHECK-BE-NEXT:    bl __udivei4
; CHECK-BE-NEXT:    ldp x9, x8, [sp, #72]
; CHECK-BE-NEXT:    ldr x10, [sp, #88]
; CHECK-BE-NEXT:    extr x9, x9, x8, #8
; CHECK-BE-NEXT:    extr x8, x8, x10, #8
; CHECK-BE-NEXT:    strb w10, [x19, #16]
; CHECK-BE-NEXT:    and x9, x9, #0x1ffffffffffffff
; CHECK-BE-NEXT:    stp x9, x8, [x19]
; CHECK-BE-NEXT:    ldp x30, x19, [sp, #96] // 16-byte Folded Reload
; CHECK-BE-NEXT:    add sp, sp, #112
; CHECK-BE-NEXT:    ret
  %a = load i129, i129* %ptr
  %res = udiv i129 %a, 3
  store i129 %res, i129* %out
  ret void
}

define i129 @urem129(i129 %a, i129 %b) nounwind {
; CHECK-LABEL: urem129:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #112
; CHECK-NEXT:    stp x0, x1, [sp, #32]
; CHECK-NEXT:    and x8, x2, #0x1
; CHECK-NEXT:    and x9, x6, #0x1
; CHECK-NEXT:    add x0, sp, #64
; CHECK-NEXT:    add x1, sp, #32
; CHECK-NEXT:    mov x2, sp
; CHECK-NEXT:    mov w3, #256
; CHECK-NEXT:    str x30, [sp, #96] // 8-byte Folded Spill
; CHECK-NEXT:    stp x4, x5, [sp]
; CHECK-NEXT:    stp x8, xzr, [sp, #48]
; CHECK-NEXT:    stp x9, xzr, [sp, #16]
; CHECK-NEXT:    bl __umodei4
; CHECK-NEXT:    ldp x1, x8, [sp, #72]
; CHECK-NEXT:    ldr x0, [sp, #64]
; CHECK-NEXT:    ldr x30, [sp, #96] // 8-byte Folded Reload
; CHECK-NEXT:    and x2, x8, #0x1
; CHECK-NEXT:    add sp, sp, #112
; CHECK-NEXT:    ret
;
; CHECK-BE-LABEL: urem129:
; CHECK-BE:       // %bb.0:
; CHECK-BE-NEXT:    sub sp, sp, #112
; CHECK-BE-NEXT:    stp x1, x2, [sp, #48]
; CHECK-BE-NEXT:    and x8, x0, #0x1
; CHECK-BE-NEXT:    and x9, x4, #0x1
; CHECK-BE-NEXT:    add x0, sp, #64
; CHECK-BE-NEXT:    add x1, sp, #32
; CHECK-BE-NEXT:    mov x2, sp
; CHECK-BE-NEXT:    mov w3, #256
; CHECK-BE-NEXT:    str x30, [sp, #96] // 8-byte Folded Spill
; CHECK-BE-NEXT:    stp x6, xzr, [sp, #24]
; CHECK-BE-NEXT:    stp x9, x5, [sp, #8]
; CHECK-BE-NEXT:    str xzr, [sp]
; CHECK-BE-NEXT:    str x8, [sp, #40]
; CHECK-BE-NEXT:    bl __umodei4
; CHECK-BE-NEXT:    ldp x8, x1, [sp, #72]
; CHECK-BE-NEXT:    ldp x2, x30, [sp, #88] // 8-byte Folded Reload
; CHECK-BE-NEXT:    and x0, x8, #0x1
; CHECK-BE-NEXT:    add sp, sp, #112
; CHECK-BE-NEXT:    ret
  %res = urem i129 %a, %b
  ret i129 %res
}

define i129 @sdiv129(i129 %a, i129 %b) nounwind {
; CHECK-LABEL: sdiv129:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #112
; CHECK-NEXT:    sbfx x8, x2, #0, #1
; CHECK-NEXT:    stp x0, x1, [sp, #32]
; CHECK-NEXT:    sbfx x9, x6, #0, #1
; CHECK-NEXT:    add x0, sp, #64
; CHECK-NEXT:    add x1, sp, #32
; CHECK-NEXT:    mov x2, sp
; CHECK-NEXT:    mov w3, #256
; CHECK-NEXT:    str x30, [sp, #96] // 8-byte Folded Spill
; CHECK-NEXT:    stp x4, x5, [sp]
; CHECK-NEXT:    stp x8, x8, [sp, #48]
; CHECK-NEXT:    stp x9, x9, [sp, #16]
; CHECK-NEXT:    bl __divei4
; CHECK-NEXT:    ldp x1, x8, [sp, #72]
; CHECK-NEXT:    ldr x0, [sp, #64]
; CHECK-NEXT:    ldr x30, [sp, #96] // 8-byte Folded Reload
; CHECK-NEXT:    and x2, x8, #0x1
; CHECK-NEXT:    add sp, sp, #112
; CHECK-NEXT:    ret
;
; CHECK-BE-LABEL: sdiv129:
; CHECK-BE:       // %bb.0:
; CHECK-BE-NEXT:    sub sp, sp, #112
; CHECK-BE-NEXT:    sbfx x8, x0, #0, #1
; CHECK-BE-NEXT:    stp x1, x2, [sp, #48]
; CHECK-BE-NEXT:    sbfx x9, x4, #0, #1
; CHECK-BE-NEXT:    add x0, sp, #64
; CHECK-BE-NEXT:    add x1, sp, #32
; CHECK-BE-NEXT:    mov x2, sp
; CHECK-BE-NEXT:    mov w3, #256
; CHECK-BE-NEXT:    str x30, [sp, #96] // 8-byte Folded Spill
; CHECK-BE-NEXT:    stp x5, x6, [sp, #16]
; CHECK-BE-NEXT:    stp x8, x8, [sp, #32]
; CHECK-BE-NEXT:    stp x9, x9, [sp]
; CHECK-BE-NEXT:    bl __divei4
; CHECK-BE-NEXT:    ldp x8, x1, [sp, #72]
; CHECK-BE-NEXT:    ldp x2, x30, [sp, #88] // 8-byte Folded Reload
; CHECK-BE-NEXT:    and x0, x8, #0x1
; CHECK-BE-NEXT:    add sp, sp, #112
; CHECK-BE-NEXT:    ret
  %res = sdiv i129 %a, %b
  ret i129 %res
}

define i129 @srem129(i129 %a, i129 %b) nounwind {
; CHECK-LABEL: srem129:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #112
; CHECK-NEXT:    sbfx x8, x2, #0, #1
; CHECK-NEXT:    stp x0, x1, [sp, #32]
; CHECK-NEXT:    sbfx x9, x6, #0, #1
; CHECK-NEXT:    add x0, sp, #64
; CHECK-NEXT:    add x1, sp, #32
; CHECK-NEXT:    mov x2, sp
; CHECK-NEXT:    mov w3, #256
; CHECK-NEXT:    str x30, [sp, #96] // 8-byte Folded Spill
; CHECK-NEXT:    stp x4, x5, [sp]
; CHECK-NEXT:    stp x8, x8, [sp, #48]
; CHECK-NEXT:    stp x9, x9, [sp, #16]
; CHECK-NEXT:    bl __modei4
; CHECK-NEXT:    ldp x1, x8, [sp, #72]
; CHECK-NEXT:    ldr x0, [sp, #64]
; CHECK-NEXT:    ldr x30, [sp, #96] // 8-byte Folded Reload
; CHECK-NEXT:    and x2, x8, #0x1
; CHECK-NEXT:    add sp, sp, #112
; CHECK-NEXT:    ret
;
; CHECK-BE-LABEL: srem129:
; CHECK-BE:       // %bb.0:
; CHECK-BE-NEXT:    sub sp, sp, #112
; CHECK-BE-NEXT:    sbfx x8, x0, #0, #1
; CHECK-BE-NEXT:    stp x1, x2, [sp, #48]
; CHECK-BE-NEXT:    sbfx x9, x4, #0, #1
; CHECK-BE-NEXT:    add x0, sp, #64
; CHECK-BE-NEXT:    add x1, sp, #32
; CHECK-BE-NEXT:    mov x2, sp
; CHECK-BE-NEXT:    mov w3, #256
; CHECK-BE-NEXT:    str x30, [sp, #96] // 8-byte Folded Spill
; CHECK-BE-NEXT:    stp x5, x6, [sp, #16]
; CHECK-BE-NEXT:    stp x8, x8, [sp, #32]
; CHECK-BE-NEXT:    stp x9, x9, [sp]
; CHECK-BE-NEXT:    bl __modei4
; CHECK-BE-NEXT:    ldp x8, x1, [sp, #72]
; CHECK-BE-NEXT:    ldp x2, x30, [sp, #88] // 8-byte Folded Reload
; CHECK-BE-NEXT:    and x0, x8, #0x1
; CHECK-BE-NEXT:    add sp, sp, #112
; CHECK-BE-NEXT:    ret
  %res = srem i129 %a, %b
  ret i129 %res
}

; Some higher sizes
define i257 @sdiv257(i257 %a, i257 %b) nounwind {
; CHECK-LABEL: sdiv257:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #208
; CHECK-NEXT:    ldp x8, x9, [sp, #208]
; CHECK-NEXT:    stp x2, x3, [sp, #80]
; CHECK-NEXT:    mov x2, sp
; CHECK-NEXT:    stp x0, x1, [sp, #64]
; CHECK-NEXT:    add x0, sp, #128
; CHECK-NEXT:    add x1, sp, #64
; CHECK-NEXT:    mov w3, #512
; CHECK-NEXT:    str x30, [sp, #192] // 8-byte Folded Spill
; CHECK-NEXT:    stp x8, x9, [sp, #16]
; CHECK-NEXT:    ldr x9, [sp, #224]
; CHECK-NEXT:    sbfx x8, x4, #0, #1
; CHECK-NEXT:    stp x6, x7, [sp]
; CHECK-NEXT:    sbfx x9, x9, #0, #1
; CHECK-NEXT:    stp x8, x8, [sp, #112]
; CHECK-NEXT:    stp x8, x8, [sp, #96]
; CHECK-NEXT:    stp x9, x9, [sp, #48]
; CHECK-NEXT:    stp x9, x9, [sp, #32]
; CHECK-NEXT:    bl __divei4
; CHECK-NEXT:    ldp x3, x8, [sp, #152]
; CHECK-NEXT:    ldp x0, x1, [sp, #128]
; CHECK-NEXT:    ldr x2, [sp, #144]
; CHECK-NEXT:    ldr x30, [sp, #192] // 8-byte Folded Reload
; CHECK-NEXT:    and x4, x8, #0x1
; CHECK-NEXT:    add sp, sp, #208
; CHECK-NEXT:    ret
;
; CHECK-BE-LABEL: sdiv257:
; CHECK-BE:       // %bb.0:
; CHECK-BE-NEXT:    sub sp, sp, #208
; CHECK-BE-NEXT:    add x8, sp, #208
; CHECK-BE-NEXT:    str x30, [sp, #192] // 8-byte Folded Spill
; CHECK-BE-NEXT:    sbfx x9, x0, #0, #1
; CHECK-BE-NEXT:    add x0, sp, #128
; CHECK-BE-NEXT:    ld1 { v0.2d }, [x8]
; CHECK-BE-NEXT:    mov x8, sp
; CHECK-BE-NEXT:    add x8, x8, #40
; CHECK-BE-NEXT:    st1 { v0.2d }, [x8]
; CHECK-BE-NEXT:    ldr x8, [sp, #224]
; CHECK-BE-NEXT:    stp x3, x4, [sp, #112]
; CHECK-BE-NEXT:    mov w3, #512
; CHECK-BE-NEXT:    stp x1, x2, [sp, #96]
; CHECK-BE-NEXT:    add x1, sp, #64
; CHECK-BE-NEXT:    stp x8, x9, [sp, #56]
; CHECK-BE-NEXT:    sbfx x8, x6, #0, #1
; CHECK-BE-NEXT:    mov x2, sp
; CHECK-BE-NEXT:    stp x9, x9, [sp, #80]
; CHECK-BE-NEXT:    str x9, [sp, #72]
; CHECK-BE-NEXT:    stp x8, x8, [sp, #8]
; CHECK-BE-NEXT:    stp x8, x7, [sp, #24]
; CHECK-BE-NEXT:    str x8, [sp]
; CHECK-BE-NEXT:    bl __divei4
; CHECK-BE-NEXT:    ldp x8, x1, [sp, #152]
; CHECK-BE-NEXT:    ldp x2, x3, [sp, #168]
; CHECK-BE-NEXT:    ldp x4, x30, [sp, #184] // 8-byte Folded Reload
; CHECK-BE-NEXT:    and x0, x8, #0x1
; CHECK-BE-NEXT:    add sp, sp, #208
; CHECK-BE-NEXT:    ret
  %res = sdiv i257 %a, %b
  ret i257 %res
}
