/*
	Cabinet-Models32.h
	
	Copyright 2005 Tim Goetze <tim@quitte.de>
	
	http://quitte.de/dsp/

	Coefficients for 32nd order IIR filters modeling the frequency
	responses of a few select instrument amplifier speaker boxes.
*/
/*
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
	02111-1307, USA or point your web browser to http://www.gnu.org.
*/

Model32 
CabinetII::models44100 [] = { 
		{
			1, /* identity */ 
			{1}, 
			{0}, 
			0.2500
		}, 
		{
			32, /* matchless_off */ 
			{0.751133877447, 0.476665652568, 0.232649157621, 0.073490164573, -0.0520549100755, -0.121257530713, -0.100197130001, -0.0412212505538, 0.0304188276576, 0.0756296082021, 0.0339966964433, -0.0188218345374, -0.0138445066369, 0.0213454687998, 0.0509702380835, 0.0734535180348, 0.0423999627069, 0.0153810625747, 0.0251173605116, 0.0231247294211, 0.0118254107717, 0.0397159715652, 0.0509631315658, 0.0289647310658, -0.0151415828019, -0.0678734405803, -0.093244908543, -0.066522401653, -0.0390777734265, -0.0206522167345, -0.0140462622686, -0.000367155236373}, 
			{0.0, 0.582601584085, 0.179375009603, -0.0310635155569, -0.115346798496, -0.0929627102659, -0.00905181962865, 0.0529760132518, 0.0660791287878, 0.0264313110774, -0.0527906709163, -0.0832644831913, -0.047761487157, -0.00525089678838, 0.00920853658047, 0.00160221988302, -0.036921883774, -0.0508637181262, -0.0369139574948, -0.0297884797081, -0.0131892593004, 0.0328205903451, 0.0532522735819, 0.0434869096278, 0.0171966303505, -0.0117058173799, -0.0222005420711, -0.00885326183421, -0.00467956865215, -0.0017726627279, -0.00860012741033, -0.046231460458}, 
			0.1088
		}, 
		{
			32, /* matchless_on */ 
			{0.737841828858, 0.460204992853, 0.280744637086, 0.0935206597339, -0.0705817082991, -0.156854249167, -0.144106172504, -0.0685499381158, 0.00620304241081, 0.0610934722291, 0.0465273895752, -0.0126452119054, -0.0649026246806, -0.0713209874063, -0.0596110923629, -0.0415373874755, -0.0389721881465, -0.0284327312853, -0.0109349222879, 0.0222033554026, 0.0552410801, 0.0896637673103, 0.106570641198, 0.122226072209, 0.115856033255, 0.0801435470104, 0.0100505511461, -0.0489360304782, -0.0829690212741, -0.0887089006669, -0.0886065785655, -0.0469811200837}, 
			{0.0, 0.611100232423, 0.191219480026, -0.0831423854754, -0.193756321128, -0.162103938394, -0.0633420329893, 0.0168905353821, 0.0319336623225, 0.00544046343502, -0.0450052997134, -0.0655650754908, -0.0385274002732, 0.0140346387674, 0.0381359817338, 0.0270741530904, -0.00985978537582, -0.0339616898786, -0.039510862758, -0.0234251294011, -0.00577196250278, 0.00602171273173, -0.0012115688049, -0.00850899153196, -0.0195544970682, -0.0235059343611, -0.0181958065493, 0.00619896262657, 0.0223536984999, 0.0126908937718, -0.0260364491855, -0.048766780312}, 
			0.1398
		}, 
		{
			32, /* superchamp */ 
			{0.764583545976, 0.538738620869, 0.179425189777, -0.0185116138637, -0.155373227876, -0.162444114313, -0.0955812737534, -0.0527583372679, 0.0109899803101, 0.027210394773, -0.0177057767782, -0.03205717291, -0.0483168565776, -0.00731185525588, 0.0552452873245, 0.075576957847, 0.0442457880974, -0.0118721835978, -0.0177888197761, 0.0351775943888, 0.0348792107809, 0.0127082443141, -0.0055147874283, -0.025538492041, -0.0266140723472, -0.00351312980821, -0.00705954101235, -0.0071756277097, -0.0073123807337, 0.00388589850911, 0.00920641143732, 0.00675123073573}, 
			{0.0, 0.60762891993, 0.0804538514268, -0.139045714146, -0.188318237239, -0.102850850916, -0.014327283229, 0.0095126479685, 0.00675439266545, -0.0369566468812, -0.0735379197498, -0.0464884257152, -0.00652653570483, 0.0460655599383, 0.0503985731174, -5.63018161884e-05, -0.0506993010893, -0.0519236737825, 0.00601034157191, 0.0565585753845, 0.0271235886591, -0.0124334855533, -0.0275977294885, -0.0178167665585, 0.0128169339437, 0.0370635121992, 0.0234037648427, 0.00539790260771, -0.0105614779717, -0.00455010484908, 0.0101491481873, 0.0220600470141}, 
			0.1771
		}, 
		{
			32, /* fender_68 */ 
			{0.952578805555, 0.423653323267, -0.299325586902, -0.181365977098, -0.00917621972835, -0.106211820702, -0.144312857058, -0.0664525836173, -0.0308777018884, -0.0289677657295, 0.06172127279, 0.0700934900581, 0.00309908907112, -0.00891983996273, -0.0687746247517, -0.0146407179784, 0.0264920122813, 0.0134951652977, 0.0480259959669, 0.021152058087, -0.0229395195318, 0.00306616207055, 0.015377268642, -0.0166969251715, -0.0472474005373, -0.0257631159809, -0.0298364749235, -0.0359529903186, -0.0228763062676, -0.0190698276841, -0.0481625561196, -0.024778494842}, 
			{0.0, 0.373287747089, -0.379113471957, -0.162638822705, -0.0309789534425, -0.113942084113, -0.0746182251996, 0.00371088736605, -0.0311272559258, -0.0641468114835, -0.01820597504, -0.0106553201186, -0.0025754233332, 0.00779983208005, -0.0133002473609, 0.0474101909397, 0.0302769494631, -0.0206219756872, 0.00091004302278, 0.00989883124397, -0.00095818764248, -0.00710510898183, -0.0103772680579, 0.00636775505307, 0.0172954284337, 0.00560785607672, -0.00550757886611, 0.0349170637518, 0.033667260855, 0.0263631580776, 0.110816169944, 0.0551965257177}, 
			0.5267
		}, 
		{
			32, /* marshall */ 
			{0.632136921276, 0.487520501766, 0.267166936676, 0.0328329910029, -0.124746548218, -0.175922403211, -0.134056005594, -0.0275494615733, 0.0707349518645, 0.112423870345, 0.0758114749041, 0.0139250983739, -0.0210142361937, -0.00193163235992, 0.0197248569676, 0.0206461311409, -0.00897578938148, -0.0306233925441, -0.041776582616, -0.0398244883075, -0.0328395317644, -0.0101508675516, 0.00636535089023, 0.0217430701187, 0.0223553033142, 0.0237782685683, 0.0278909244449, 0.0469073547267, 0.0509466858461, 0.0336174039295, 0.0028829896058, 0.0114245696423}, 
			{0.0, 0.618938053184, 0.180052941443, -0.1028119852, -0.19233134457, -0.14303971742, -0.0450998045919, 0.0341843500162, 0.0465086637485, 0.0071435730282, -0.0461779135605, -0.059013077843, -0.0284397368519, 0.0187689538251, 0.0341298347311, 0.0244703904826, 0.00720524642447, 0.00991307420138, 0.018738094495, 0.0275442994126, 0.0299092523536, 0.0339721143791, 0.0270175082759, 0.0151058732685, -0.00751060215331, -0.0236467101096, -0.0272347092017, -0.00812409176413, 0.0141531255726, 0.0270163512016, 0.00208457244433, -0.0784208903527}, 
			0.1132
		}, 
		{
			32, /* mesa */ 
			{0.462494284717, 0.393585742058, 0.303328992303, 0.181503108654, 0.0629173541037, -0.020681232006, -0.0571885284376, -0.0467796891544, -0.0276756897046, -0.00892844543715, 0.00204563746045, 0.0115134879366, 0.00106846505647, -0.0149439761237, -0.0330954690659, -0.0337794782369, -0.0276991983671, -0.0190072253549, -0.0324525139664, -0.0630355306227, -0.0999209480709, -0.111933999507, -0.110645947594, -0.092891889065, -0.0692697576821, -0.0450776510962, -0.0392851148349, -0.035324392499, -0.035403719608, -0.0376283525137, -0.0612971281858, -0.0900100571873}, 
			{0.0, 0.56035020932, 0.29343466934, 0.0772363317707, -0.0530744622425, -0.0885361452358, -0.0589180077997, -0.00257855932105, 0.0334935643243, 0.0442328268628, 0.0294583386742, 0.00717959220156, -0.0175320543891, -0.0208128084726, -0.00373790944406, 0.0334761867029, 0.0627006023834, 0.0700861323961, 0.0416727224516, -0.000637024095321, -0.0357094622237, -0.0404012923223, -0.0285442599547, -0.00354190734239, 0.0184796761008, 0.0306524756002, 0.0181509660649, -0.00687913029057, -0.0393242377083, -0.0550286859069, -0.0375235630652, 0.0471541139774}, 
			0.2500
		}, 
		{
			32, /* pro_jr */ 
			{0.734249445521, 0.491537503216, 0.337459965314, 0.176462147927, 0.0276390917692, -0.0644515999868, -0.0972401016684, -0.0803985996088, -0.0428685363211, -0.0140919517701, -0.0337409328059, -0.0478897322188, -0.0362288411405, -0.0130597902066, -0.00582049410513, 0.0022469159791, -0.00964075940401, -0.0380828738621, -0.0763568061844, -0.089961400489, -0.0952731732008, -0.0895604973654, -0.101346765163, -0.119569610891, -0.128233125318, -0.109253322153, -0.0821678710293, -0.041620049917, -0.0245690004857, -0.0219634796685, -0.0419014341928, -0.0651369005252}, 
			{0.0, 0.663188793345, 0.270439727768, 0.0190336508265, -0.0946822703696, -0.0888520332756, -0.0267575060227, 0.03588910806, 0.0599594346375, 0.041850528867, -0.00632721029526, -0.0244115687714, -0.0103162286821, 0.0119858957112, 0.0197992179523, 0.0238625339809, 0.0142267453341, 0.00296440492823, -0.00543873217766, -0.00014858213959, -0.00196572770138, -0.00750279035903, -0.0243069229182, -0.0285801812939, -0.0100437887585, 0.0259127459737, 0.0475587872734, 0.0497287926166, 0.0189008750066, -0.0156259358581, -0.0395277285226, -0.0325403937133}, 
			0.2500
		}, 
};

Model32 
CabinetII::models48000 [] = { 
		{
			1, /* identity */ 
			{1}, 
			{0}, 
			0.2500
		}, 
		{
			32, /* matchless_off */ 
			{0.751616859768, 0.455477674067, 0.236301148417, 0.0831041136969, -0.0271403780165, -0.100856772665, -0.105648770896, -0.0532306291781, 0.00532168244437, 0.0769562829624, 0.0998339309568, 0.0558038693299, -0.00395884124382, -0.0114310936324, -0.00035476064153, 0.0174339944264, 0.0326924241347, 0.0270873548662, -0.00429020715999, 0.00156163927912, 0.0110729521074, -0.00355947960002, -0.0197465530354, -0.00226491671692, 0.000562585645118, -0.0113374627036, -0.0395530054938, -0.0773637715714, -0.110300349197, -0.102242460538, -0.0802708342222, -0.0368542661019}, 
			{0.0, 0.573363683971, 0.199471497847, -0.0100987131104, -0.10105055289, -0.104899707204, -0.0453437303875, 0.0227558858103, 0.0494210617945, 0.0469948522053, -0.000869801014908, -0.060632162889, -0.078080719406, -0.036500327, 0.00169111404144, 0.0161416041893, 0.00446588199593, -0.0256497606161, -0.052007235054, -0.0329954828689, -0.00846672300472, 0.00503287700528, 0.0225460696732, 0.0488769816297, 0.0448900330347, 0.0265213842101, 0.00867720983291, 0.00309440217249, 0.0106055108636, 0.0271743998844, 0.00790666559882, -0.0494793375024}, 
			0.0972
		}, 
		{
			32, /* matchless_on */ 
			{0.736752793274, 0.42789796886, 0.276149514408, 0.115820415827, -0.0320628697966, -0.121795204879, -0.142828258933, -0.0859958693575, -0.0176210080708, 0.0507262077785, 0.0760681727953, 0.0516030677135, -0.0156690595908, -0.0681826247693, -0.0944163538419, -0.0902627133447, -0.0823076517005, -0.0734934090705, -0.0692943287136, -0.0513490885216, -0.0305887683924, 0.00285704997857, 0.0369925466712, 0.0764037770343, 0.103822670992, 0.130505051247, 0.126189167018, 0.0870288516942, 0.00607091602923, -0.0716539223465, -0.122336223951, -0.107802803871}, 
			{0.0, 0.60867772822, 0.226828570484, -0.0393069664502, -0.171393086666, -0.174192716258, -0.103361484389, -0.0132853346158, 0.028065787663, 0.0276791758057, -0.0093177316362, -0.0469821632045, -0.0621330892865, -0.0326281391326, 0.00952584471493, 0.0391305970452, 0.0343547401694, 0.0103991548433, -0.0167038490391, -0.0239538249183, -0.0200522931237, -0.00619037145571, 0.00112030880301, 0.00379111038519, -0.00425737141588, -0.00510101082859, -0.00618382168232, 0.00222622566288, 0.012234432496, 0.0240659559777, 0.00806553945799, -0.0500627523652}, 
			0.1292
		}, 
		{
			32, /* superchamp */ 
			{0.736144077022, 0.533697136818, 0.208223243775, 0.0105446749467, -0.115112852124, -0.167784888349, -0.118309369108, -0.0686796829989, -0.0320689348914, 0.0293577338735, 0.0228074058112, -0.00942321170451, -0.0247236206138, -0.0382275338893, -0.0220962904251, 0.0369265390908, 0.0652234781224, 0.0625494411772, 0.0203218939615, -0.0130049534934, 0.00776964355966, 0.0408524993227, 0.0187403995074, -0.00323676614764, -0.011729909669, -0.0146182789026, -0.00520348014418, 0.0251718299467, 0.0292350516935, 0.0265773340322, 0.0181154887123, 0.00421057480694}, 
			{0.0, 0.610899704338, 0.116614493347, -0.107102211172, -0.17045907835, -0.125900190491, -0.0364778545046, 0.00268191730596, 0.00393059621292, -0.00442930148683, -0.0496456084728, -0.0641110080937, -0.0380451267687, -0.00269939732468, 0.0336320714582, 0.0473822399663, 0.00672982206906, -0.0376868259805, -0.0574242984978, -0.0235397064668, 0.0375124576452, 0.0561991090538, 0.0137707473486, -0.019313535496, -0.0308393757193, -0.0231851781013, -0.000359955230619, 0.0224262684571, 0.0140137052508, 0.000784652753983, -0.00886431320574, 0.00520310404507}, 
			0.1627
		}, 
		{
			32, /* fender_68 */ 
			{0.940499002611, 0.474406048513, -0.234027864276, -0.245068743132, -0.0275886925241, -0.0375353084644, -0.116020540053, -0.0788142311793, -0.0192628993487, -0.0208031874862, -0.036274591111, 0.0274443468203, 0.0248807593189, -0.00647753415313, 0.0123263590476, -0.0207149994271, -0.0169433327912, 0.0367748568855, 0.0157152144192, 0.0219763333967, 0.0220500063178, -0.0236599648747, -0.028051497911, 0.0300390624893, 0.0503387731847, 0.0200944005064, -0.0199651438354, -0.0189512878551, -0.0341641453641, -0.0429368448753, -0.00172415323758, 0.0187773541719}, 
			{0.0, 0.438339721191, -0.314663980515, -0.200197131305, -0.0199447108206, -0.0806444850114, -0.112178302737, -0.0407327776523, -0.0162859630428, -0.04823028022, -0.0411406583855, 0.0181605305425, 0.0182296926714, 0.0118833391549, 0.00393162532115, -0.0208012980893, 0.0236552029021, 0.0440436249244, -0.015760708804, -0.00800215008051, 0.0264390446392, 0.0224755303713, -0.00488388416495, -0.0302927869543, -0.0389708286652, -0.0213138828272, -0.0196593434643, -0.0250837259433, -0.0171306364105, -0.00247139702561, -0.0442683480699, 0.00104076341183}, 
			0.4976
		}, 
		{
			32, /* marshall */ 
			{0.632432814914, 0.466340577796, 0.289928964438, 0.0873773815151, -0.0637714745665, -0.134210611966, -0.135503699906, -0.0734327294692, 0.00792058229369, 0.0760927054439, 0.0890306791735, 0.0595619591479, 0.00922265898468, -0.00784921065447, 0.00721708132165, 0.0350086110935, 0.0376247852781, 0.0202910905225, -0.00870656585895, -0.0201433438279, -0.0279367587019, -0.0245180701261, -0.0152282108474, 0.00828831561931, 0.026894267099, 0.0460507228179, 0.0479724909309, 0.0409446830643, 0.0201085872414, 0.00561387003945, -0.00753169056058, 0.000986659484038}, 
			{0.0, 0.594136919296, 0.201493775156, -0.0716153113375, -0.180702317671, -0.160390621032, -0.0826806167453, 0.000697581661664, 0.0397029332137, 0.0299147550153, -0.0177304803895, -0.0570701545448, -0.0652412298089, -0.0298128518083, 0.0124560081161, 0.0355161884622, 0.0255626596849, 0.00762986123778, -0.00431800264305, 0.00420452150537, 0.0150803653129, 0.0291131391488, 0.0359312991789, 0.0364212054952, 0.0203516393338, 0.0022141464642, -0.0149317465975, -0.0121651677123, 0.00704936522966, 0.0353605810957, 0.0322793623201, -0.0307481566657}, 
			0.0996
		}, 
		{
			32, /* mesa */ 
			{0.495930895017, 0.376476419856, 0.303586589503, 0.197845120631, 0.0899987258287, 0.00535662962566, -0.0475751298521, -0.0519576953746, -0.0376515865627, -0.0168652310379, -0.00508935920432, 0.00888673824726, 0.0109356809664, 0.00654236486877, -0.0122417367265, -0.0265484743045, -0.0339837870474, -0.0233241554396, -0.0127914848925, -0.00515836827508, -0.0209864779144, -0.0475368628257, -0.0782299905969, -0.0909360283527, -0.0983527406681, -0.0938199589393, -0.0898861541372, -0.0810532718198, -0.0815503996776, -0.0796236089322, -0.0749972587191, -0.0599151413182}, 
			{0.0, 0.534078389658, 0.294930996327, 0.0991032789063, -0.0272295349878, -0.0770236019127, -0.0705005212384, -0.0257307535864, 0.0146092582685, 0.0379865150974, 0.0359872042115, 0.0230902724993, -0.000725294921074, -0.0174606095957, -0.0236682462783, -0.00669570447944, 0.021362472642, 0.0512331674592, 0.0584309807453, 0.044407663655, 0.00900197651083, -0.0217065441135, -0.037007819832, -0.0257650758221, -0.00590170187955, 0.0194528583388, 0.0320489572473, 0.030386820278, 0.00581345215134, -0.02347217653, -0.0472400829369, -0.0430772235107}, 
			0.2500
		}, 
		{
			32, /* pro_jr */ 
			{0.767221028694, 0.44461349725, 0.324943328323, 0.187583401624, 0.0585707039826, -0.036895934974, -0.0893306767021, -0.0935390488322, -0.0758668196298, -0.0408583447944, -0.0309741335777, -0.0417509830741, -0.0550681782871, -0.0417048932451, -0.0295194484972, -0.0177059350466, -0.0189517349534, -0.0180093708399, -0.0336546809637, -0.0511188019942, -0.0648908298083, -0.0619349722444, -0.058573104994, -0.0470621645996, -0.0597723312001, -0.0855574645731, -0.109611426273, -0.113648127167, -0.112000636381, -0.0909222239483, -0.0727424833493, -0.0362189061166}, 
			{0.0, 0.62970643913, 0.293410547935, 0.0578415012725, -0.0672697168081, -0.094466063484, -0.0596589574295, 0.000648321788151, 0.0432524054305, 0.0596811813862, 0.0366985835211, 0.0035102339371, -0.0156226319473, -0.00793362884142, 0.00010974226424, 0.00946937446156, 0.012432810986, 0.0166353982569, 0.00885441580212, 0.00176491241101, -0.00465797946213, -0.00706780418692, -0.0169292031721, -0.0217285491491, -0.0298358684941, -0.0214136482558, 0.00603804801211, 0.0432427970473, 0.0585065590431, 0.0472784452715, -0.00622503195681, -0.0778508047032}, 
			0.2500
		}, 
};

Model32 
CabinetII::models88200 [] = { 
		{
			1, /* identity */ 
			{1}, 
			{0}, 
			0.2500
		}, 
		{
			32, /* matchless_off */ 
			{0.581241782856, 0.351127495653, 0.293447498861, 0.203644809011, 0.122868019886, 0.0798136296596, 0.0627344813847, 0.0582949053671, 0.0495483041303, 0.0432630437098, 0.040778980166, 0.0502959955879, 0.06102889964, 0.0717641907075, 0.0748815766238, 0.0800912666293, 0.0851573668252, 0.0920643205477, 0.0863975575062, 0.0672325976358, 0.0316956083124, -0.00434276880274, -0.0353531287352, -0.0497775530225, -0.0549729489782, -0.0523697171754, -0.0527017492312, -0.0496529350336, -0.0432932459975, -0.02532771672, -0.00704167237723, 0.0048594343372}, 
			{0.0, 0.527351085198, 0.306902134941, 0.121666659808, -0.000869395618695, -0.0590060725486, -0.0800321294614, -0.0812161497866, -0.0756902882293, -0.0586480829698, -0.035146960319, -0.00693669578546, 0.0137459416267, 0.0260709477944, 0.027142282904, 0.0255107789641, 0.0184912445046, 0.00787311464383, -0.012080806249, -0.0326630439808, -0.0479929895538, -0.0449384101923, -0.0257392906728, 0.00611234738181, 0.0331632616028, 0.0482685642726, 0.0424761053987, 0.0227984734932, -0.00689764194843, -0.0338856201523, -0.0506606159856, -0.036511204766}, 
			0.0505
		}, 
		{
			32, /* matchless_on */ 
			{0.754229081317, 0.28992460445, 0.25506113675, 0.205825249671, 0.149736304722, 0.0965453802519, 0.043937905171, 0.000434005345846, -0.0380077969732, -0.0648440473691, -0.0820185458195, -0.0804769096126, -0.067903181347, -0.0457545818062, -0.024506391213, 0.000276698483466, 0.0227732012504, 0.0462273060245, 0.0612627993168, 0.0704402843546, 0.0668070265589, 0.0560526861609, 0.0360109823522, 0.0171596012087, -0.00254977646019, -0.0169995310247, -0.0326802854744, -0.0431803638863, -0.0527933574758, -0.0537365642607, -0.0484658084207, -0.0264410770067}, 
			{0.0, 0.473323278291, 0.304447812378, 0.156758267418, 0.0407417557578, -0.0375541115795, -0.084174169143, -0.0995647273704, -0.0953485009639, -0.0745284443813, -0.047611748504, -0.0160860230858, 0.00812108121932, 0.022520582633, 0.0218183858734, 0.0139436350809, -0.000684654971314, -0.0149097687302, -0.0306604197839, -0.0406022715147, -0.0468128179642, -0.0432623683601, -0.0334406989274, -0.0143890226248, 0.00558711901527, 0.0240338814196, 0.0313772357088, 0.0288551286613, 0.0119537593072, -0.0137695197232, -0.0487934292115, -0.0830489298052}, 
			0.0977
		}, 
		{
			32, /* superchamp */ 
			{0.564442248694, 0.417375378841, 0.328112930961, 0.184087902524, 0.0606877879374, -0.000888211396509, -0.0240417949471, -0.0386494407725, -0.0623924578122, -0.077697122496, -0.0771755477917, -0.0625887925073, -0.0567602691995, -0.0606788148043, -0.0653972735044, -0.0482177616776, -0.0134706312764, 0.0255178539984, 0.0454519306153, 0.0488386058553, 0.040370247527, 0.0309888915369, 0.0118591255626, -0.0166655766779, -0.0524886753799, -0.0735764853592, -0.0712539506456, -0.0409275497673, 2.56200623182e-05, 0.0407426819337, 0.0605288133085, 0.045387360314}, 
			{0.0, 0.58401876341, 0.301866612426, 0.0749234792796, -0.0512250579262, -0.0884380547633, -0.0859341509964, -0.0715039798048, -0.0533786975427, -0.0228940420774, 0.00895370138835, 0.029234699873, 0.0249642271923, 0.00815472752255, -0.00852123193886, -0.013874697166, -0.0177655062032, -0.0244009337209, -0.0348366549323, -0.0341041586519, -0.0199202543104, 0.0049040564053, 0.0228786117828, 0.0307412470467, 0.0270357914745, 0.0202102683028, 0.00600213627849, -0.0132416519396, -0.035306113292, -0.0400865958576, -0.0122081055945, 0.061547236583}, 
			0.0940
		}, 
		{
			32, /* fender_68 */ 
			{0.636561915308, 0.539655264394, 0.306940867236, -0.00798666364572, -0.2010016693, -0.196429989976, -0.0871390659769, 0.0058320328314, 0.0205797064122, -0.0137249327682, -0.0511542488948, -0.0559233911299, -0.0365269209833, -0.00933607201861, 0.00259528983031, 0.000820508580746, -0.014655020786, -0.0298656923381, -0.0363760565053, -0.0164103072662, 0.0180980103038, 0.0427307277871, 0.0289045601723, -0.00365819240342, -0.0221033761769, -0.00613002097262, 0.0137359639094, 0.0126374765575, -0.0109039821774, -0.022164851067, -0.00644276895272, 0.0406179316828}, 
			{0.0, 0.660098640191, 0.135995579965, -0.18643602906, -0.21362553946, -0.0765656086032, 0.0304158765248, 0.0317377501315, -0.0306547118834, -0.0742288333657, -0.0716640946732, -0.0400798411024, -0.016998894935, -0.0119106601837, -0.0209707717803, -0.0285105267284, -0.033043355156, -0.03016836978, -0.0235112391223, -0.0121431367424, -0.0083970652792, -0.0121227777881, -0.0179437299751, -0.0103936611338, 0.000810102779011, -0.000708784846704, -0.0234941025684, -0.0371015701952, -0.0180247391719, 0.0220761118738, 0.0243771530897, -0.0421517051891}, 
			0.2672
		}, 
		{
			32, /* marshall */ 
			{0.487781223472, 0.313482625917, 0.286350463893, 0.224656866466, 0.146402144474, 0.0763559834141, 0.0205530599391, -0.0145817074955, -0.0366424375139, -0.0445785898927, -0.0458160857045, -0.037336889106, -0.0251791786851, -0.00575399966305, 0.0148942739024, 0.0391750282507, 0.0589388969198, 0.0752812491289, 0.0811254049966, 0.0801917939348, 0.0685526132261, 0.0533549680139, 0.0342811257343, 0.0215399491933, 0.0147049499229, 0.0198301270011, 0.030982725155, 0.0503002628087, 0.0693130546132, 0.0867905978395, 0.0881891739024, 0.0641468491285}, 
			{0.0, 0.51943795847, 0.326729354403, 0.149229797985, 0.0109767104297, -0.0732768493116, -0.111088974509, -0.110789539541, -0.0898934114003, -0.0564578047856, -0.0231004313356, 0.0069673688738, 0.0254240918116, 0.0337510299271, 0.0282514883492, 0.0147089116391, -0.00647743824673, -0.0269028751263, -0.0446349197143, -0.0510564142456, -0.0478791675617, -0.0324832722564, -0.0121393859238, 0.0104982033447, 0.0241412382054, 0.026038551433, 0.00994372364326, -0.0158545375622, -0.0436236854665, -0.0537883431888, -0.032574614307, 0.0387767610956}, 
			0.0666
		}, 
		{
			32, /* mesa */ 
			{0.800744790951, 0.174351736281, 0.162047205857, 0.138794638546, 0.105850412073, 0.0723656260485, 0.0365740092219, 0.00431957094182, -0.0274260159266, -0.052813754463, -0.0747002681782, -0.0875980404567, -0.0959206315285, -0.0964326627017, -0.0951211930444, -0.0890916136798, -0.0839336477818, -0.0759587618493, -0.0699911420952, -0.0618103150195, -0.0562569921852, -0.0497246788081, -0.0474425366429, -0.045118852226, -0.0466084665482, -0.0466183009403, -0.048518031551, -0.0465434705359, -0.0436608634155, -0.0338725172886, -0.0202008830722, 0.0028064387038}, 
			{0.0, 0.348283848037, 0.278266186344, 0.208315992656, 0.142238507639, 0.0877418515218, 0.0426721771028, 0.0101211230173, -0.0142620082039, -0.0279206093939, -0.0353541175487, -0.0344380562925, -0.030780249931, -0.0230674032021, -0.016830370528, -0.00961683532214, -0.00530786189015, -0.000225073976316, 0.00276994164541, 0.00775476255757, 0.0114020240885, 0.0168731013913, 0.0203623771917, 0.0249313385656, 0.0267810408235, 0.0287888955038, 0.026286558388, 0.0210452426156, 0.00782753651909, -0.0119982689793, -0.0444362907999, -0.0880582917654}, 
			0.2500
		}, 
		{
			32, /* pro_jr */ 
			{0.909835294941, 0.237116967883, 0.220493213781, 0.188296175986, 0.145804855731, 0.1035213914, 0.0593519550104, 0.018535542445, -0.0211984146917, -0.0519769598497, -0.0754321013216, -0.0869433378891, -0.0920887014799, -0.087865027182, -0.0792907797887, -0.0637463287733, -0.0482713945314, -0.0325419993651, -0.0236382913314, -0.0187673840883, -0.0211003792763, -0.0242608362201, -0.0299312006336, -0.032972160693, -0.038384284548, -0.0433373155719, -0.0522438990617, -0.0598215574684, -0.0680342990137, -0.0706075753658, -0.0696540637908, -0.0592163425206}, 
			{0.0, 0.437589362895, 0.316542061632, 0.204591087565, 0.109610647885, 0.0395709089276, -0.0101168883103, -0.0392507441308, -0.0536854447628, -0.0525994961208, -0.0429181531663, -0.0263178649123, -0.0108114446263, 0.00361113168474, 0.0124368978113, 0.0183164472387, 0.0173632458965, 0.0133080282174, 0.00451776800884, -0.0027292732446, -0.0084152300302, -0.00649797485834, 0.000343904158769, 0.0135853277076, 0.0260015642816, 0.0368350330248, 0.0397116093504, 0.035854103932, 0.0201173890247, -0.00598389310382, -0.0479894271495, -0.10412912505}, 
			0.2500
		}, 
};

Model32 
CabinetII::models96000 [] = { 
		{
			1, /* identity */ 
			{1}, 
			{0}, 
			0.2500
		}, 
		{
			32, /* matchless_off */ 
			{0.576442585125, 0.306361432085, 0.256653772545, 0.177316081395, 0.0989986029973, 0.0501811139283, 0.0263950297254, 0.0211066378234, 0.0164669956215, 0.0145939695187, 0.0131915301884, 0.0224302343035, 0.0359395096833, 0.0545608587271, 0.0665798797365, 0.0764638706987, 0.0822020713116, 0.0937583388117, 0.104705110174, 0.114731370205, 0.110211793209, 0.0934363192015, 0.0618719406527, 0.0288732783262, -0.00358352145982, -0.0259155247732, -0.0441021836484, -0.0555310772717, -0.0670712283056, -0.0677576234809, -0.0520883036287, -0.00170675690763}, 
			{0.0, 0.508669145362, 0.322479739387, 0.156892646838, 0.035020841423, -0.0347440829067, -0.0701806136041, -0.0825008530376, -0.0845801358275, -0.0733688333095, -0.0530323023958, -0.0234536559399, 0.00360324038712, 0.0244342060698, 0.0314240125922, 0.0309189326677, 0.0230090442585, 0.0145937492998, 0.00103582471628, -0.0152025378362, -0.0363464186106, -0.0511215757185, -0.0557855361088, -0.0408742372067, -0.0130066718085, 0.023938151261, 0.0530188010691, 0.0671220652663, 0.0540529792683, 0.0164681954699, -0.0469180610472, -0.125461903689}, 
			0.0494
		}, 
		{
			32, /* matchless_on */ 
			{0.941618036526, 0.239866043796, 0.218739659026, 0.1855624175, 0.143119285622, 0.098285134927, 0.049823345838, 0.00491072985196, -0.0372254815054, -0.0706502777402, -0.0969381684649, -0.109632530255, -0.11098328422, -0.0987132407502, -0.080379871629, -0.0559715185867, -0.0315381582245, -0.00496109501612, 0.0171690268626, 0.0357166271116, 0.0446464487104, 0.0469813895302, 0.0390401137056, 0.0262125456401, 0.00716840214371, -0.0108017316884, -0.028794724005, -0.0413800680682, -0.0514241182155, -0.0535943709963, -0.0501288491812, -0.0356807796594}, 
			{0.0, 0.436259688495, 0.303343311728, 0.180401443304, 0.0755768977826, -0.00298141418929, -0.057401860201, -0.0849229021135, -0.0921029201246, -0.0808710238831, -0.0601563297725, -0.031853887802, -0.00462566662184, 0.0189321520075, 0.0307568282097, 0.0327103981415, 0.0234112049746, 0.00941773902223, -0.00880302596543, -0.024628145492, -0.0377321989901, -0.0420727660837, -0.0390726798885, -0.0257996845469, -0.00726121684029, 0.0160981879938, 0.0352540092546, 0.0464046029779, 0.0397882340227, 0.0142875216435, -0.0354360590043, -0.105598440048}, 
			0.0651
		}, 
		{
			32, /* superchamp */ 
			{0.598483659576, 0.392119614921, 0.324128816827, 0.207253363884, 0.0944270102152, 0.0269672658419, -0.00338080597527, -0.0154386943775, -0.0337854523788, -0.0528375781544, -0.0668037964282, -0.0644824272507, -0.0581122839458, -0.053620685433, -0.05941095465, -0.0599621297144, -0.0476930600655, -0.0143047492128, 0.0237480623761, 0.0559779339589, 0.0689887990541, 0.0713731354487, 0.0647181254244, 0.0560812069922, 0.0357682629483, 0.00706245212017, -0.0286615791021, -0.052644819201, -0.0590210498647, -0.041747604451, -0.0168191702228, 0.00465326173164}, 
			{0.0, 0.555306548005, 0.304384349565, 0.0955876011242, -0.032790937176, -0.0803585769889, -0.0834509085546, -0.069736664388, -0.0558345347225, -0.0359974911327, -0.012046069248, 0.0128302949846, 0.0234882264814, 0.0187166685281, 0.00137741738003, -0.0128825824672, -0.0213054248788, -0.0224842024484, -0.0275110748888, -0.0335451251688, -0.0384673765875, -0.0306779974376, -0.0133415017904, 0.00900611383706, 0.0222626768741, 0.0253127037082, 0.0166771042914, 0.00577574428968, -0.00773567900765, -0.0175688399329, -0.021338142267, -0.00199213694503}, 
			0.0903
		}, 
		{
			32, /* fender_68 */ 
			{0.61042243584, 0.519167522444, 0.338455322638, 0.0598120788559, -0.155008295955, -0.209996385603, -0.142681005045, -0.0444570079209, 0.00529240289956, 7.6909429568e-05, -0.03354602127, -0.0535687744411, -0.049519403779, -0.0238846177015, -0.000920606029846, 0.010434338433, 0.002228774067, -0.0140907683377, -0.035872619499, -0.0481212880009, -0.0457673542097, -0.0191076772359, 0.0133771714316, 0.0322386165839, 0.0178556687427, -0.0095701287891, -0.0237842865664, -0.00484822472333, 0.0227424513401, 0.0316309750773, 0.00586735474858, -0.0235815475244}, 
			{0.0, 0.658865798836, 0.184872779539, -0.137135473027, -0.210003150161, -0.108221769211, 0.0110221508749, 0.0526622948184, 0.0145697157163, -0.0398151102571, -0.0659793146563, -0.0534131399862, -0.0284152189248, -0.0091286709165, -0.00636536651116, -0.00986403078301, -0.0155052371976, -0.0165973690878, -0.018011376701, -0.0154898840826, -0.0109104131649, -0.00195757926804, 0.00204116721073, 0.00157889259535, -0.00328499795407, -0.00244356007769, -0.00227606009504, -0.00603112779608, -0.0173439459505, -0.0176299504059, -0.00210293292278, 0.00864548631897}, 
			0.2359
		}, 
		{
			32, /* marshall */ 
			{0.519039714244, 0.28397066065, 0.263752501402, 0.216763224092, 0.153202060875, 0.093498887372, 0.0418092813984, 0.00649080672527, -0.0187685887985, -0.0313725205166, -0.0386046242494, -0.0368255569808, -0.0319398932261, -0.0190867195417, -0.00429792893597, 0.0171895051396, 0.038509421914, 0.0625518463058, 0.0812007261611, 0.0971807963934, 0.10334087256, 0.104223746243, 0.0947810421376, 0.0820175331544, 0.0638964900287, 0.049888405421, 0.0379912291508, 0.0353343445924, 0.036271348736, 0.0455456726476, 0.0571810093304, 0.0753869660867}, 
			{0.0, 0.495552580909, 0.326384725738, 0.167649233033, 0.0373913746446, -0.049802990613, -0.0971841927371, -0.108389008817, -0.0971430950292, -0.0702481334571, -0.0402478232447, -0.00995144228925, 0.0120995492915, 0.0263638891687, 0.0284733804008, 0.0226883648689, 0.00733748451124, -0.0103570201666, -0.0304762029918, -0.0447374261541, -0.0534169560389, -0.0509721172171, -0.0411315716449, -0.0225994268992, -0.00306083571223, 0.0162408742504, 0.0258967736277, 0.0250750690024, 0.00862389563333, -0.0164131934788, -0.0455336929843, -0.0629205840552}, 
			0.0663
		}, 
		{
			32, /* mesa */ 
			{0.816556812848, 0.150293117891, 0.141795487793, 0.124839522537, 0.099196755702, 0.0723627786971, 0.0428519140057, 0.0161310830227, -0.0110923701697, -0.034007587359, -0.0554568663798, -0.070468417213, -0.0823376819593, -0.0871844200317, -0.0898440433576, -0.0874713568897, -0.0851052646307, -0.0795934648554, -0.075427699709, -0.0687589148326, -0.0639930873009, -0.0572185996408, -0.0529180674694, -0.0475806410473, -0.0456514163291, -0.0429752541034, -0.0432519558816, -0.0416267292155, -0.0408422393067, -0.0352236824279, -0.0269876908459, -0.0103181623672}, 
			{0.0, 0.324884890574, 0.268628249933, 0.210962607294, 0.15379956812, 0.104238396719, 0.0608732030517, 0.0272239220101, -0.000475953058616, -0.019347999351, -0.0332735025431, -0.039418716712, -0.0418327023679, -0.0385575041649, -0.0342524288567, -0.0267537524134, -0.0202714386094, -0.0115967221036, -0.00421419915726, 0.0052675530631, 0.0133773574491, 0.0230906449798, 0.0303465968119, 0.0374618799867, 0.0402738707573, 0.0409671902591, 0.0352080031286, 0.0253938319794, 0.0070273986645, -0.0175302180141, -0.0528396401673, -0.0967034944448}, 
			0.2500
		}, 
		{
			32, /* pro_jr */ 
			{0.925365759135, 0.205121186223, 0.193282167511, 0.170964672217, 0.139026712618, 0.10615970874, 0.0712170483592, 0.0387785989803, 0.00565122246474, -0.022529589284, -0.0474765753603, -0.0638195347354, -0.0750789855745, -0.0781013105481, -0.0774023301337, -0.0698851353181, -0.0601759362765, -0.0460666153988, -0.033417255906, -0.0207620686126, -0.0136627961657, -0.008873845834, -0.00924040700271, -0.00959897299234, -0.0122760927684, -0.0134131792383, -0.0169861222268, -0.0197237904964, -0.0247929394164, -0.0274056341581, -0.0290372582108, -0.0230858292646}, 
			{0.0, 0.384047660947, 0.296120799911, 0.212432468703, 0.136561707438, 0.0758675413252, 0.0277844248084, -0.00596868040294, -0.0302987351926, -0.0432929213814, -0.0490562834943, -0.0462652470517, -0.0403753213236, -0.030690892845, -0.022025662253, -0.0121577019191, -0.00457323646437, 0.00324370289428, 0.00777535572758, 0.0119010287281, 0.0130997070818, 0.0155933691883, 0.0177344547654, 0.023362610354, 0.028693981754, 0.0347549373256, 0.0352150834795, 0.0303066390313, 0.0145055938776, -0.0110543984149, -0.0508137742561, -0.102480420772}, 
			0.2500
		}, 
};

