#ifndef __JREADLINE_H__ /* filewrapper */
#define __JREADLINE_H__
/*
 * Jeffrey Friedl
 * Omron Corporation			ʳ
 * Nagaokakyoshi, Japan			617Ĺ
 *
 * jfriedl@nff.ncl.omron.co.jp
 *
 * This work is placed under the terms of the GNU General Purpose License
 * (the "GNU Copyleft").
 */

#define jreadline_version 103 /* 1.03 */

/*
 * Given a prompt, accept a line of input from the user and return it.
 * The value returned should be eventually free'd by the user.
 */
extern unsigned char *readline(const unsigned char *readlineprompt);


/*
 * Add the given line to the history list. The contents of the line are copied
 * to separately saved memory, so there's no need to do that by the calling
 * function.
*/
extern void add_history(const unsigned char *);


#ifndef NO_AUTO_ROMAJI_CONVERSION
  /*
   * Can be set to true or false to allow automatic romaji conversion.
   * Particularly useful to be set via jreadline_access (described below).
   */
  extern int jreadline_auto_romaji;

  /*
   * The kind of function that should be called to do romaji conversion,
   * if any (if set, will be called after each character input if
   * jreadline_auto_romaji is true.
   */
  typedef void (*romaji_converter_t)(unsigned char *buffer,
				     const unsigned char *bufend,
				     unsigned char **cursorloc,
				     const unsigned char **eol,
				     int force);

  /*
   * Used to set what function should be called to do the conversion (the
   * old function address being returned). An appropriate function can
   * be found in std_romaji.c
   */
  extern romaji_converter_t set_romaji_converter(romaji_converter_t new);
#endif /* NO_AUTO_ROMAJI_CONVERSION */

/*
 * If set, called (more-or-less) after each character read, to allow
 * an outside agent to modify or view the in-progress line. When
 * multiple characters are available for input at one time, they're
 * processed in a block before (*jreadline_access)() is called.
 */
extern int (*jreadline_access)(unsigned char *line,
			       unsigned char **dot,
			       unsigned char **eol);

/*
 * used to set the prompt >during readline processing<. To be called from
 * a function that's called from within readline, such as the romaji
 * converter or the jreadline_access function.
 */
const unsigned char *jreadline_mod_prompt(const unsigned char *new);

/* The prompt used by the current (if in-execution) or last readline(). */
extern const unsigned char *jreadline_last_prompt;

/* Actually defined in std_romaji.c... rather a kludge to be here */
extern const char *std_romaji_allowed_nonletters(const char *new);
extern void std_romaji_converter(const unsigned char *start_of_line,
				 const unsigned char *bufend,
				 unsigned char **dot_p,
				 const unsigned char **eol_p,
				 int force,
				 int eat_leading_slash);

/*
 * The input buffer is static and of limited size.
 * An input line is not allowed beyond this size.
 */
#ifndef MAX_INPUT_LINE_LENGTH
# define MAX_INPUT_LINE_LENGTH 200
#endif

/*
 * Used to set (or enquire the current) type of encoding used for high-bit
 * set characters. Returns the previous value, and sets a new value if
 * selection is JREADLINE_EUC or JREADLINE_SJIS. Note that regular JIS
 * is always recognized.
 */
unsigned jreadline_highbit_input(unsigned selection);
#define JREADLINE_EUC		1
#define JREADLINE_SJIS		2
#define JREADLINE_INQUIRE	3

#endif /* file wrapper */
