/* ----- encode/761x3, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_761x3_checksums[] = {
  "174595681ec51d85de90246ab033f588d23586e48cee89ef360c213c47987ec4",
  "e77793e4a45e5582c3f32e346f5cf7d1f91f9ed3c531e41918c09d70d4d3815f",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_761x3_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_761x3_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_761x3_ITEMBYTES

static void *storage_encode_761x3_s;
static unsigned char *test_encode_761x3_s;
static void *storage_encode_761x3_x;
static unsigned char *test_encode_761x3_x;
static void *storage_encode_761x3_s2;
static unsigned char *test_encode_761x3_s2;
static void *storage_encode_761x3_x2;
static unsigned char *test_encode_761x3_x2;

#define precomputed_encode_761x3_NUM 4

static const unsigned char precomputed_encode_761x3_s[precomputed_encode_761x3_NUM][crypto_encode_STRBYTES] = {
  {121,156,222,233,6,254,216,163,86,105,152,175,19,230,157,87,160,7,189,250,27,235,14,169,236,218,159,191,193,62,245,141,253,6,59,20,63,3,65,136,213,218,219,230,28,234,23,43,80,1,68,227,199,8,89,208,64,118,167,175,51,62,131,163,201,119,206,74,108,172,80,238,179,63,185,109,120,228,120,121,229,244,236,57,214,234,156,201,213,0,59,160,148,21,67,38,177,101,183,79,181,59,164,112,16,49,153,236,87,22,118,165,248,49,160,238,217,164,210,137,77,194,144,139,228,15,182,96,50,155,155,173,27,174,249,165,194,59,101,254,145,117,38,255,125,201,80,37,209,79,221,237,186,205,214,3,206,226,170,181,14,147,171,248,58,133,140,242,209,195,170,204,103,139,166,186,199,152,141,173,242,116,53,96,32,238,28,199,236,165,23},
  {37,1,149,122,75,14,160,247,122,112,85,200,254,180,179,225,195,7,183,98,45,110,108,69,20,95,246,227,20,197,218,75,149,215,115,19,38,69,70,82,68,204,137,142,255,102,100,171,66,69,77,66,32,222,144,234,2,143,151,14,126,243,233,13,131,42,217,183,121,251,30,141,220,96,201,182,96,247,212,67,181,170,141,193,106,218,203,169,20,59,85,253,170,166,206,209,115,55,0,180,129,99,168,140,14,42,88,136,234,251,185,64,127,26,234,183,147,177,1,30,109,184,56,10,178,172,92,40,191,220,255,237,62,133,60,122,35,123,80,193,50,48,174,55,132,194,116,107,169,57,42,64,26,33,90,182,165,46,176,205,123,215,102,18,25,76,22,3,190,207,29,118,202,63,63,76,22,216,175,74,66,127,115,5,87,10,252,195,106,38,164},
  {195,247,144,71,184,75,65,123,255,249,148,14,113,13,25,94,90,23,65,15,180,129,208,157,170,134,66,194,193,166,186,186,131,213,62,33,87,69,74,106,163,199,81,119,141,225,131,246,220,114,33,33,198,45,36,179,5,77,207,200,173,84,217,17,151,186,224,66,127,78,245,76,106,11,22,7,158,240,34,152,255,236,91,89,137,254,140,72,139,2,63,68,193,109,134,122,104,88,230,13,232,42,199,236,179,77,75,211,103,150,189,48,87,53,242,91,113,185,78,208,203,85,139,4,113,28,244,164,162,55,109,63,0,241,121,55,120,253,117,125,102,253,92,39,63,63,129,7,11,38,56,97,100,145,160,177,72,175,155,218,217,33,135,223,206,64,51,228,230,198,82,6,109,110,40,97,64,101,210,144,160,131,207,106,43,18,253,238,78,27,229},
  {137,244,174,97,11,227,141,226,165,253,101,255,135,46,58,202,237,107,125,132,42,169,245,233,239,138,252,91,19,132,112,100,38,2,13,178,161,184,170,109,106,92,240,109,139,50,11,244,133,31,69,49,51,197,44,25,20,221,120,8,135,122,2,139,29,67,251,15,105,152,179,202,105,56,199,174,60,150,34,97,229,4,112,50,4,113,138,223,162,7,180,23,40,193,246,225,139,205,221,80,180,100,89,103,58,219,35,131,101,171,142,215,21,91,209,1,192,212,42,166,91,231,136,142,72,99,182,104,66,53,151,172,39,222,136,180,202,238,167,148,230,250,24,223,156,73,126,168,63,42,3,212,32,123,139,219,189,172,140,70,250,51,48,118,236,183,100,106,94,195,151,1,112,74,246,153,40,37,177,47,205,167,29,130,105,22,191,132,84,132,54},
} ;

static const unsigned char precomputed_encode_761x3_x[precomputed_encode_761x3_NUM][crypto_encode_ITEMS] = {
  {236,22,206,208,179,117,224,199,141,247,38,171,156,154,1,202,73,202,12,166,237,159,240,249,83,248,93,198,26,177,251,183,25,22,121,120,176,45,199,241,15,89,81,79,26,148,123,109,38,54,132,42,97,0,3,168,212,1,95,194,50,96,53,0,211,118,214,13,26,174,46,128,236,71,206,178,85,248,127,22,78,142,252,158,226,53,154,221,93,151,4,199,128,65,193,115,15,210,108,150,41,231,104,17,66,82,76,16,138,216,252,11,240,71,94,210,161,98,20,222,124,165,201,176,40,136,251,21,52,177,43,108,165,123,170,206,134,112,34,10,107,237,22,225,170,96,192,131,182,70,250,53,56,193,7,177,59,14,100,106,200,34,251,102,117,88,115,114,106,187,151,71,157,173,120,159,187,163,16,174,173,82,118,249,26,226,78,197,62,226,81,104,227,30,234,76,180,178,239,37,59,81,75,167,242,15,86,212,234,202,10,215,215,147,69,73,136,199,162,153,119,77,153,121,31,155,206,202,41,10,237,252,10,126,109,42,78,179,188,158,58,213,157,230,105,160,172,213,22,146,117,98,110,124,243,27,48,213,231,246,54,107,236,58,85,53,45,242,209,9,244,219,239,86,45,192,55,192,30,169,239,31,185,104,45,71,41,155,218,73,226,85,42,76,73,124,60,66,14,109,140,51,192,199,31,185,154,134,195,171,86,95,151,79,161,205,76,250,7,18,4,135,239,194,227,179,183,138,167,16,215,37,16,201,79,91,233,42,163,167,45,66,6,164,179,193,161,210,40,23,215,250,180,35,252,182,195,62,215,78,234,131,183,34,43,212,233,37,63,68,211,191,172,241,237,182,50,123,245,14,101,91,168,106,164,218,149,84,12,141,237,120,82,180,116,24,206,255,95,169,180,235,60,29,226,21,83,82,151,150,122,211,139,140,62,58,255,127,240,207,180,98,106,184,28,162,186,16,187,103,92,110,106,230,180,127,41,114,33,39,41,58,157,45,160,160,167,247,51,76,56,111,84,198,23,176,139,64,4,94,117,125,107,106,104,155,179,230,199,194,4,237,97,15,190,132,88,7,192,3,4,125,60,97,69,34,126,175,155,100,9,114,154,47,110,224,51,107,223,179,122,28,217,245,153,102,139,110,99,166,221,53,21,242,108,141,178,65,173,215,246,72,203,198,48,94,63,255,170,51,17,41,133,225,161,153,0,53,17,119,96,108,152,171,5,178,22,245,26,87,23,8,208,92,81,99,29,59,122,128,120,149,35,101,224,84,223,128,225,244,254,65,194,166,77,34,16,142,34,63,212,140,83,245,215,53,125,170,60,157,110,177,136,77,12,216,94,47,130,111,132,209,4,222,104,108,116,97,181,60,20,6,96,46,138,235,237,41,155,45,102,202,166,131,173,47,121,230,9,69,27,15,61,90,47,223,252,165,81,7,101,97,53,38,122,117,27,13,222,166,230,166,163,244,195,204,245,8,117,178,176,144,92,150,211,237,59,92,105,237,128,246,168,213,172,255,22,130,29,154,109,142,207,79,255,170,221,92,174,181,237,139,186,111,248,173,109,21,249,200,113,137,209,131,206,85,25,251,235,22,100,159,0,98,55,65,68,153,27,104,105,69,190,125,31,176,176,33,12,121,119,22,175,247,196,157,163,54,17,49,17,90,78,5,11,159,244,116,86,51,49,225,247,132,237,7,204,41,198,114,22},
  {148,255,80,125,244,106,49,220,8,94,56,237,225,213,7,214,230,96,213,233,165,33,229,229,151,1,27,64,230,247,6,206,197,152,8,230,39,157,204,199,252,129,20,135,251,214,94,233,193,26,60,207,51,195,206,117,110,48,199,227,200,189,181,98,158,116,104,62,54,75,77,26,214,11,206,94,25,49,179,12,128,194,169,107,249,204,183,14,51,141,183,185,96,148,80,61,115,163,16,127,34,178,46,229,1,28,103,171,94,216,145,103,115,123,210,57,100,111,169,151,105,167,0,246,222,10,7,206,128,144,132,97,150,211,194,254,150,62,137,8,154,169,4,61,81,164,15,188,24,250,251,93,237,145,192,155,101,98,57,230,111,248,82,230,203,227,10,138,192,201,177,177,9,140,108,253,54,177,215,101,253,5,172,129,75,209,12,75,154,23,246,196,77,148,209,237,168,142,25,74,36,133,200,149,137,253,99,149,251,156,230,220,221,83,194,41,223,251,235,235,197,12,34,34,145,31,66,42,202,4,206,46,190,121,206,103,81,58,192,126,13,151,236,228,46,100,50,87,80,25,238,244,4,117,146,23,214,90,251,181,209,9,102,58,92,118,201,223,242,196,46,134,240,33,187,160,250,187,40,61,197,45,33,121,160,22,208,89,159,186,80,180,251,156,138,16,188,86,234,15,81,152,83,134,83,110,156,201,46,169,9,193,207,88,97,145,158,24,15,88,168,162,179,148,225,129,127,110,180,205,165,204,148,58,95,24,193,225,85,102,77,110,20,253,202,131,114,10,244,12,211,56,11,233,185,162,42,47,244,15,216,42,208,50,36,205,197,144,197,64,197,189,245,251,71,88,169,124,190,152,128,183,42,90,254,148,61,124,190,33,134,157,87,81,21,255,23,74,70,27,220,176,25,64,250,137,11,209,155,122,193,19,27,211,233,165,61,87,190,169,85,44,5,110,39,207,34,214,187,166,226,63,201,119,239,204,138,163,237,87,52,40,189,43,147,178,229,241,26,252,74,238,73,247,174,107,77,102,35,178,22,47,37,69,30,156,239,39,120,5,229,74,128,47,243,249,21,1,91,236,232,108,80,110,219,170,150,70,127,33,254,44,109,142,21,115,133,246,100,107,115,197,157,32,171,83,65,152,83,156,213,43,254,231,41,225,83,13,108,153,6,77,183,20,244,173,207,180,13,91,235,51,104,122,22,130,7,60,219,137,225,245,159,42,2,3,80,203,122,159,151,207,99,194,165,129,244,234,121,129,145,71,55,239,251,248,204,61,173,127,183,133,62,33,58,66,3,75,8,70,201,81,70,188,227,119,230,240,210,121,26,15,152,235,61,233,224,129,168,30,253,90,235,107,167,225,52,250,33,137,128,90,248,165,136,15,169,171,255,235,81,124,78,33,28,125,88,87,29,179,51,15,187,132,161,202,180,57,206,20,26,183,223,217,74,250,61,246,173,121,196,53,201,221,52,229,148,228,130,254,247,68,79,80,41,154,123,90,222,176,45,1,53,57,73,227,218,204,211,145,32,154,216,175,133,191,122,24,241,61,125,119,170,172,117,41,250,60,184,46,251,191,176,108,189,85,231,113,167,167,76,198,130,238,230,235,25,115,233,150,237,232,70,224,86,41,119,131,90,17,64,222,244,191,96,119,46,81,53,173,229,188,142,24,239,234,69,151,254,244,138,196,233,203,236,125,197,111,109,178,163},
  {22,186,127,214,178,60,168,86,179,86,79,77,66,28,108,238,63,125,131,188,10,63,107,25,80,87,144,145,202,35,105,41,210,70,244,66,24,27,86,211,115,215,43,139,113,166,95,119,188,156,171,217,196,5,174,176,20,96,147,148,241,38,168,216,121,107,130,115,66,28,17,88,224,67,64,152,62,183,174,223,55,138,32,64,120,61,236,168,35,206,190,205,200,236,129,103,149,80,244,145,113,204,189,115,73,217,144,165,97,71,119,78,136,161,66,137,137,6,199,33,65,213,241,247,117,108,164,116,242,219,81,203,188,33,80,101,49,66,59,244,152,133,94,69,10,206,212,186,20,231,188,122,85,80,246,120,241,41,176,246,98,183,25,70,26,82,85,123,208,231,161,250,158,253,201,104,112,22,187,139,116,234,203,167,86,122,15,20,29,121,126,203,147,49,219,62,245,34,162,194,224,87,1,86,80,43,121,105,173,145,136,32,0,18,241,38,19,187,205,56,182,186,124,20,44,69,187,3,144,150,233,74,190,143,68,57,211,132,33,166,152,44,193,36,155,225,190,136,36,40,88,193,124,0,60,202,138,10,9,8,133,88,240,202,207,235,205,101,173,88,134,106,222,95,125,112,133,53,250,4,232,126,92,24,95,66,217,60,101,64,251,64,146,33,102,105,93,253,239,50,6,11,116,137,221,39,173,160,91,96,8,217,213,206,48,163,135,15,176,130,186,140,240,235,219,99,159,173,142,50,83,18,8,151,190,199,144,17,246,16,61,227,126,40,11,251,28,174,11,26,32,74,134,112,55,6,109,196,15,201,214,189,34,16,239,156,29,243,16,31,222,172,208,30,53,82,93,101,56,91,197,8,208,217,87,111,144,8,23,107,4,200,205,69,251,224,200,200,17,135,71,47,53,221,161,77,132,95,82,188,55,115,123,95,30,147,86,130,192,44,124,103,34,191,98,61,178,94,134,82,107,228,114,244,149,58,89,134,181,10,140,103,208,241,111,67,86,148,150,99,198,178,128,160,86,86,153,249,202,126,38,28,207,186,12,208,193,183,252,194,238,42,37,21,80,246,79,79,43,201,14,14,99,136,44,221,202,79,174,146,92,254,67,63,247,176,16,159,101,145,99,93,47,252,167,242,127,1,255,152,87,138,21,254,208,121,98,172,93,172,196,85,76,37,78,251,35,54,63,11,52,52,48,243,194,214,208,249,103,144,66,16,30,170,107,6,150,137,180,157,176,14,216,182,207,206,24,200,39,138,253,49,117,12,216,80,5,109,63,2,12,208,14,169,226,20,206,95,34,50,122,208,239,5,84,166,228,156,94,153,215,158,58,131,223,102,185,50,69,40,119,67,38,12,240,119,60,130,111,112,130,91,8,1,187,226,111,119,196,27,236,236,172,92,55,211,131,137,98,102,6,116,14,10,213,207,225,241,26,133,20,224,151,178,204,244,103,39,182,75,153,215,10,8,42,243,73,20,42,125,135,197,189,62,46,152,93,206,123,89,35,130,73,246,23,248,17,212,81,216,225,31,86,233,21,127,198,229,236,211,202,5,213,193,92,82,231,167,177,113,140,60,165,1,179,166,38,133,12,201,166,206,145,47,163,172,167,9,147,237,195,254,53,13,250,233,57,152,202,212,122,11,65,233,115,180,234,131,174,192,253,180,179,67,96,146,248,30,233,120,229,102,45,135,167,77,118,56,215,92,228},
  {104,159,125,250,175,16,191,83,229,237,16,43,100,86,37,52,50,61,129,6,146,155,201,172,88,0,14,172,109,196,189,89,172,105,136,130,212,41,51,212,200,250,78,86,14,43,147,179,98,196,216,69,25,200,178,66,173,138,241,144,37,96,21,202,64,102,64,183,118,116,205,236,32,26,10,36,39,86,27,172,161,33,227,174,192,89,171,226,196,243,73,54,20,76,217,187,118,185,56,23,165,24,235,30,175,222,120,60,234,199,96,204,74,5,66,61,83,211,221,227,251,32,174,255,215,78,132,171,233,178,30,21,41,1,188,31,56,172,93,248,93,224,92,243,192,139,210,93,115,100,94,138,153,139,33,70,72,176,1,156,37,176,111,245,39,20,201,132,187,164,181,196,244,161,102,129,62,62,72,198,197,230,188,3,138,191,83,56,79,124,142,182,48,28,157,87,190,219,34,2,192,232,213,173,124,12,191,189,50,235,104,166,148,255,138,1,23,124,25,173,100,44,239,235,207,116,178,192,248,12,146,117,111,9,105,60,219,182,92,89,62,149,58,36,65,5,149,50,161,23,135,233,146,133,65,222,144,134,118,35,146,15,250,106,118,208,151,62,166,145,249,133,48,233,36,36,103,75,171,156,154,121,86,30,225,61,242,34,160,197,14,242,255,169,188,102,206,221,171,10,21,89,66,183,171,55,230,228,201,14,220,38,125,172,78,3,140,192,92,187,112,100,181,129,135,66,218,206,147,246,147,210,201,201,179,155,159,156,238,251,16,131,176,100,209,121,8,212,34,210,178,128,209,123,53,1,74,246,69,129,47,28,76,164,254,145,176,142,3,56,167,34,28,72,107,194,193,200,12,88,220,76,196,73,30,46,194,233,0,138,157,94,64,78,173,129,111,231,31,104,203,197,144,242,167,86,41,102,188,26,138,45,162,80,179,112,213,212,4,70,142,146,147,190,158,232,109,223,170,221,201,182,52,179,161,0,110,86,173,59,193,34,171,57,162,72,232,73,32,136,88,156,218,87,37,238,172,128,145,39,224,99,112,17,123,104,57,247,87,242,214,16,173,238,91,23,233,82,166,199,146,157,48,160,138,186,170,18,243,84,95,152,169,140,30,182,47,153,138,251,158,172,88,237,57,226,42,112,135,47,21,54,165,90,218,49,36,63,144,167,6,227,211,214,191,182,0,95,34,8,213,13,101,241,54,28,207,117,97,250,151,22,239,18,185,11,37,165,101,129,167,191,178,20,49,181,139,53,206,148,121,202,151,222,249,27,96,77,39,155,63,1,190,51,252,221,99,117,17,160,196,36,90,124,233,188,77,78,143,53,83,179,46,147,143,162,77,78,13,54,42,201,202,15,43,61,66,77,135,97,196,158,158,18,192,117,174,158,5,55,150,32,7,140,236,227,155,197,231,28,224,248,103,56,63,240,65,172,148,83,173,222,212,21,18,183,183,46,63,75,247,28,181,235,160,75,103,124,224,241,118,191,59,101,135,30,245,199,25,27,125,247,141,203,73,215,10,13,247,91,138,110,12,157,204,96,38,112,159,199,230,240,193,241,211,105,109,229,234,56,236,34,209,63,107,126,107,155,168,22,61,244,244,154,40,218,194,178,201,79,64,6,42,106,82,172,241,9,148,245,10,39,153,69,148,77,236,110,203,87,149,107,204,211,18,70,20,36,15,108,91,255,227,39,184,176,227,123,210,117,53},
} ;

static void test_encode_761x3_impl(long long impl)
{
  unsigned char *s = test_encode_761x3_s;
  unsigned char *x = test_encode_761x3_x;
  unsigned char *s2 = test_encode_761x3_s2;
  unsigned char *x2 = test_encode_761x3_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_761x3_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_761x3(impl);
    printf("encode_761x3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_761x3_implementation(impl),ntruprime_dispatch_encode_761x3_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_761x3;
    printf("encode_761x3 selected implementation %s compiler %s\n",ntruprime_encode_761x3_implementation(),ntruprime_encode_761x3_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_761x3_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_761x3_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_761x3_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_761x3_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_761x3_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_761x3_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_761x3(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"761x3")) return;
  storage_encode_761x3_s = callocplus(crypto_encode_STRBYTES);
  test_encode_761x3_s = aligned(storage_encode_761x3_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_761x3_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_761x3_x = aligned(storage_encode_761x3_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_761x3_s2 = callocplus(maxalloc);
  test_encode_761x3_s2 = aligned(storage_encode_761x3_s2,crypto_encode_STRBYTES);
  storage_encode_761x3_x2 = callocplus(maxalloc);
  test_encode_761x3_x2 = aligned(storage_encode_761x3_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_761x3 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_761x3();++impl)
      forked(test_encode_761x3_impl,impl);
    ++test_encode_761x3_s;
    ++test_encode_761x3_x;
    ++test_encode_761x3_s2;
    ++test_encode_761x3_x2;
  }
  free(storage_encode_761x3_x2);
  free(storage_encode_761x3_s2);
  free(storage_encode_761x3_x);
  free(storage_encode_761x3_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

