/**
 * \file pappsomspp/processing/cbor/cborstreamwriter.h
 * \date 05/07/2025
 * \author Olivier Langella
 * \brief PAPPSO CBOR stream writer
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/
#pragma once

#include <QCborStreamWriter>
#include <QCborMap>


#include "pappsomspp/export-import-config.h"

namespace pappso
{
namespace cbor
{
/**
 * @todo write docs
 */
class PMSPP_LIB_DECL CborStreamWriter : public QCborStreamWriter
{
  public:
  /**
   * Default constructor
   */
  CborStreamWriter(QByteArray *data);
  CborStreamWriter(QIODevice *device);

  /**
   * Destructor
   */
  virtual ~CborStreamWriter();


  const QString &getUuid() const;


  void writeInformations(const QString &software_name,
                         const QString &software_version,
                         const QString &type,
                         const QString &operation);


  void writeCborMap(const QCborMap &cbor_map);
  void writeCborArray(const QCborArray &cbor_array);
  void writeArray(const std::vector<std::size_t> &int_list);
  void writeArray(const std::vector<qint64> &int_list);
  void writeArray(const std::vector<double> &double_list);
  void writeArray(const std::vector<int> &positions);
  void writeArray(const std::vector<std::uint8_t> &small_uint_list);
  void writeArray(const QStringList &str_list);
  void writeArray(const std::vector<QString> &str_list);

  private:
  QString m_uuid;
};
} // namespace cbor
} // namespace pappso
