//------------------------------------------------------------------------------
// <auto-generated />
//
// This file was automatically generated by SWIG (http://www.swig.org).
// Version 3.0.12
//
// Do not make changes to this file unless you know what you are doing--modify
// the SWIG interface file instead.
//------------------------------------------------------------------------------

namespace libsbml {

 using System;
 using System.Runtime.InteropServices;

/** 
 * @sbmlpackage{core}
 *
@htmlinclude pkg-marker-core.html A user-defined function in an SBML model.
 *
 * The FunctionDefinition structure associates an identifier with a
 * function definition.  This identifier can then be used as the function
 * called in subsequent MathML content elsewhere in an SBML model.
 * 
 * FunctionDefinition has one required attribute, 'id', to give the
 * function a unique identifier by which other parts of an SBML model
 * definition can refer to it.  A FunctionDefinition instance can also have
 * an optional 'name' attribute of type @c string.  Identifiers and names
 * must be used according to the guidelines described in the %SBML
 * specification (e.g., Section 3.3 in the Level 2 Version 4
 * specification).
 * 
 * FunctionDefinition has a 'math' subelement containing a MathML
 * expression defining the function body.  In SBML Level&nbsp;2 and SBML
 * Level&nbsp;3 Version&nbsp;1, that 'math' subelement is required;
 * in SBML Level&nbsp;3 Version&nbsp;2, this restriction was relaxed,
 * making the 'math' subelement optional.  The content of this element can
 * only be a MathML 'lambda' element.  The 'lambda' element must begin with
 * zero or more 'bvar' elements, followed by any other of the elements in
 * the MathML subset allowed in SBML Level 2 @em except 'lambda' (i.e., a
 * 'lambda' element cannot contain another 'lambda' element).  This is the
 * only place in SBML where a 'lambda' element can be used.  The function
 * defined by a FunctionDefinition is only available for use in other
 * MathML elements that @em follow the FunctionDefinition definition in the
 * model.  (These restrictions prevent recursive and mutually-recursive
 * functions from being expressed.)
 *
 * A further restriction on the content of 'math' is that it cannot contain
 * references to variables other than the variables declared to the
 * 'lambda' itself.  That is, the contents of MathML 'ci' elements inside
 * the body of the 'lambda' can only be the variables declared by its
 * 'bvar' elements, or the identifiers of other FunctionDefinition
 * instances in the model.  This means must be written so that all
 * variables or parameters used in the MathML content are passed to them
 * via their function parameters.  In SBML Level&nbsp;2, this restriction
 * applies also to the MathML @c csymbol elements for @em time and @em
 * delay; in SBML Level&nbsp;3, it additionally applies to the @c csymbol
 * element for @em avogadro.
 *
 * In SBML Level&nbsp;3 Version&nbsp;2, if no math element is present in 
 * the FunctionDefinition, the function has no mathematical meaning 
 * defined in SBML Level&nbsp;3 Core. This situation may arise when models 
 * are incomplete, or when additional meanings are provided by an SBML 
 * Level&nbsp;3 package.
 *
 * @note Function definitions (also informally known as user-defined
 * functions) were introduced in SBML Level 2.  They have purposefully
 * limited capabilities.  A function cannot reference parameters or other
 * model quantities outside of itself; values must be passed as parameters
 * to the function.  Moreover, recursive and mutually-recursive functions
 * are not permitted.  The purpose of these limitations is to balance power
 * against complexity of implementation.  With the restrictions as they
 * are, function definitions could be implemented as textual
 * substitutions---they are simply macros.  Software implementations
 * therefore do not need the full function-definition machinery typically
 * associated with programming languages.
 * <br><br>
 * Another important point to note is FunctionDefinition does not
 * have a separate attribute for defining the units of the value returned
 * by the function.  The units associated with the function's return value,
 * when the function is called from within MathML expressions elsewhere in
 * SBML, are simply the overall units of the expression in
 * FunctionDefinition's 'math' subelement when applied to the arguments
 * supplied in the call to the function.  Ascertaining these units requires
 * performing dimensional analysis on the expression.  (Readers may wonder
 * why there is no attribute.  The reason is that having a separate
 * attribute for declaring the units would not only be redundant, but also
 * lead to the potential for having conflicting information.  In the case
 * of a conflict between the declared units and those of the value actually
 * returned by the function, the only logical resolution rule would be to
 * assume that the correct units are those of the expression anyway.)
 * 
 * 
 *
 */

public class FunctionDefinition : SBase {
	private HandleRef swigCPtr;
	
	internal FunctionDefinition(IntPtr cPtr, bool cMemoryOwn) : base(libsbmlPINVOKE.FunctionDefinition_SWIGUpcast(cPtr), cMemoryOwn)
	{
		//super(libsbmlPINVOKE.FunctionDefinitionUpcast(cPtr), cMemoryOwn);
		swigCPtr = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(FunctionDefinition obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (FunctionDefinition obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~FunctionDefinition() {
    Dispose();
  }

  public override void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != global::System.IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_FunctionDefinition(swigCPtr);
        }
        swigCPtr = new global::System.Runtime.InteropServices.HandleRef(null, global::System.IntPtr.Zero);
      }
      global::System.GC.SuppressFinalize(this);
      base.Dispose();
    }
  }

  
/**
   * Creates a new FunctionDefinition using the given SBML @p level and @p version
   * values.
   *
   * @param level a long integer, the SBML Level to assign to this FunctionDefinition.
   *
   * @param version a long integer, the SBML Version to assign to this
   * FunctionDefinition.
   *
   *
 * @throws SBMLConstructorException
 * Thrown if the given @p level and @p version combination are invalid
 * or if this object is incompatible with the given level and version.
 *
 *
   *
   *
 * @note Attempting to add an object to an SBMLDocument having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * SBMLDocument), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
 *
 *
   */ public
 FunctionDefinition(long level, long version) : this(libsbmlPINVOKE.new_FunctionDefinition__SWIG_0(level, version), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates a new FunctionDefinition using the given SBMLNamespaces object
   * @p sbmlns.
   *
   *
 * 
 * The SBMLNamespaces object encapsulates SBML Level/Version/namespaces
 * information.  It is used to communicate the SBML Level, Version, and (in
 * Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.  A
 * common approach to using libSBML's SBMLNamespaces facilities is to create an
 * SBMLNamespaces object somewhere in a program once, then hand that object
 * as needed to object constructors that accept SBMLNamespaces as arguments.
 *
 * 
   *
   * @param sbmlns an SBMLNamespaces object.
   *
   *
 * @throws SBMLConstructorException
 * Thrown if the given @p sbmlns is inconsistent or incompatible
 * with this object.
 *
 *
   *
   *
 * @note Attempting to add an object to an SBMLDocument having a different
 * combination of SBML Level, Version and XML namespaces than the object
 * itself will result in an error at the time a caller attempts to make the
 * addition.  A parent object must have compatible Level, Version and XML
 * namespaces.  (Strictly speaking, a parent may also have more XML
 * namespaces than a child, but the reverse is not permitted.)  The
 * restriction is necessary to ensure that an SBML model has a consistent
 * overall structure.  This requires callers to manage their objects
 * carefully, but the benefit is increased flexibility in how models can be
 * created by permitting callers to create objects bottom-up if desired.  In
 * situations where objects are not yet attached to parents (e.g.,
 * SBMLDocument), knowledge of the intented SBML Level and Version help
 * libSBML determine such things as whether it is valid to assign a
 * particular value to an attribute.
 *
 *
   */ public
 FunctionDefinition(SBMLNamespaces sbmlns) : this(libsbmlPINVOKE.new_FunctionDefinition__SWIG_1(SBMLNamespaces.getCPtr(sbmlns)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Copy constructor; creates a copy of this FunctionDefinition.
   *
   * @param orig the object to copy.
   */ public
 FunctionDefinition(FunctionDefinition orig) : this(libsbmlPINVOKE.new_FunctionDefinition__SWIG_2(FunctionDefinition.getCPtr(orig)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates and returns a deep copy of this FunctionDefinition object.
   *
   * @return the (deep) copy of this FunctionDefinition object.
   */ public new
 FunctionDefinition clone() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.FunctionDefinition_clone(swigCPtr);
    FunctionDefinition ret = (cPtr == global::System.IntPtr.Zero) ? null : new FunctionDefinition(cPtr, true);
    return ret;
  }

  
/**
   * Returns the value of the 'id' attribute of this FunctionDefinition.
   *
   * @note Because of the inconsistent behavior of this function with 
   * respect to assignments and rules, it is now recommended to
   * use the getIdAttribute() function instead.
   *
   *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping,
 * the character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers
 * is determined by an exact character sequence match; i.e., comparisons must
 * be performed in a case-sensitive manner.  This applies to all uses of
 * <code>SId</code>, <code>SIdRef</code>, and derived types.
 *
 * Users need to be aware of some important API issues that are the result of
 * the history of SBML and libSBML.  Prior to SBML Level&nbsp;3
 * Version&nbsp;2, SBML defined 'id' and 'name' attributes on only a subset
 * of SBML objects.  To simplify the work of programmers, libSBML's API
 * provided get, set, check, and unset on the SBase object class itself
 * instead of on individual subobject classes. This made the
 * get/set/etc. methods uniformly available on all objects in the libSBML
 * API.  LibSBML simply returned empty strings or otherwise did not act when
 * the methods were applied to SBML objects that were not defined by the SBML
 * specification to have 'id' or 'name' attributes.  Additional complications
 * arose with the rule and assignment objects: InitialAssignment,
 * EventAssignment, AssignmentRule, and RateRule.  In early versions of SBML,
 * the rule object hierarchy was different, and in addition, then as now,
 * they possess different attributes: 'variable' (for the rules and event
 * assignments), 'symbol' (for initial assignments), or neither (for
 * algebraic rules).  Prior to SBML Level&nbsp;3 Version&nbsp;2, getId()
 * would always return an empty string, and isSetId() would always return @c
 * false for objects of these classes.
 *
 * With the addition of 'id' and 'name' attributes on SBase in Level&nbsp;3
 * Version&nbsp;2, it became necessary to introduce a new way to interact
 * with the attributes more consistently in libSBML to avoid breaking
 * backward compatibility in the behavior of the original 'id' methods.  For
 * this reason, libSBML provides four functions (getIdAttribute(),
 * setIdAttribute(@if java String@endif), isSetIdAttribute(), and
 * unsetIdAttribute()) that always act on the actual 'id' attribute inherited
 * from SBase, regardless of the object's type.  <strong>These new methods
 * should be used instead of the older getId()/setId()/etc. methods</strong>
 * unless the old behavior is somehow necessary.  Regardless of the Level and
 * Version of the SBML, these functions allow client applications to use more
 * generalized code in some situations (for instance, when manipulating
 * objects that are all known to have identifiers).  If the object in
 * question does not posess an 'id' attribute according to the SBML
 * specification for the Level and Version in use, libSBML will not allow the
 * identifier to be set, nor will it read or write 'id' attributes for those
 * objects.
 *
 *
   *
   * @return the id of this FunctionDefinition.
   *
   * @see getIdAttribute()
   * @see setIdAttribute(string sid)
   * @see isSetIdAttribute()
   * @see unsetIdAttribute()
   */ public new
 string getId() {
    string ret = libsbmlPINVOKE.FunctionDefinition_getId(swigCPtr);
    return ret;
  }

  
/**
   * Returns the value of the 'name' attribute of this FunctionDefinition object.
   *
   *
 *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  LibSBML has for a long time provided functions
 * defined on SBase itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 *
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 * 
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 * 
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 *
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 *
 *
 *
 * @return the name of this SBML object, or the empty string if not set or unsettable.
 *
 * @see getIdAttribute()
 * @see isSetName()
 * @see setName(string sid)
 * @see unsetName()
 * 
 *
   */ public new
 string getName() {
    string ret = libsbmlPINVOKE.FunctionDefinition_getName(swigCPtr);
    return ret;
  }

  
/**
   * Get the mathematical formula of this FunctionDefinition.
   *
   * @return an ASTNode, the value of the 'math' subelement of this
   * FunctionDefinition, or @c null if the math is not set.
   */ public new
 ASTNode getMath() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.FunctionDefinition_getMath(swigCPtr);
    ASTNode ret = (cPtr == global::System.IntPtr.Zero) ? null : new ASTNode(cPtr, false);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * FunctionDefinition's 'id' attribute is set.
   *
   *
 *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping,
 * the character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers
 * is determined by an exact character sequence match; i.e., comparisons must
 * be performed in a case-sensitive manner.  This applies to all uses of
 * <code>SId</code>, <code>SIdRef</code>, and derived types.
 *
 * Users need to be aware of some important API issues that are the result of
 * the history of SBML and libSBML.  Prior to SBML Level&nbsp;3
 * Version&nbsp;2, SBML defined 'id' and 'name' attributes on only a subset
 * of SBML objects.  To simplify the work of programmers, libSBML's API
 * provided get, set, check, and unset on the SBase object class itself
 * instead of on individual subobject classes. This made the
 * get/set/etc. methods uniformly available on all objects in the libSBML
 * API.  LibSBML simply returned empty strings or otherwise did not act when
 * the methods were applied to SBML objects that were not defined by the SBML
 * specification to have 'id' or 'name' attributes.  Additional complications
 * arose with the rule and assignment objects: InitialAssignment,
 * EventAssignment, AssignmentRule, and RateRule.  In early versions of SBML,
 * the rule object hierarchy was different, and in addition, then as now,
 * they possess different attributes: 'variable' (for the rules and event
 * assignments), 'symbol' (for initial assignments), or neither (for
 * algebraic rules).  Prior to SBML Level&nbsp;3 Version&nbsp;2, getId()
 * would always return an empty string, and isSetId() would always return @c
 * false for objects of these classes.
 *
 * With the addition of 'id' and 'name' attributes on SBase in Level&nbsp;3
 * Version&nbsp;2, it became necessary to introduce a new way to interact
 * with the attributes more consistently in libSBML to avoid breaking
 * backward compatibility in the behavior of the original 'id' methods.  For
 * this reason, libSBML provides four functions (getIdAttribute(),
 * setIdAttribute(@if java String@endif), isSetIdAttribute(), and
 * unsetIdAttribute()) that always act on the actual 'id' attribute inherited
 * from SBase, regardless of the object's type.  <strong>These new methods
 * should be used instead of the older getId()/setId()/etc. methods</strong>
 * unless the old behavior is somehow necessary.  Regardless of the Level and
 * Version of the SBML, these functions allow client applications to use more
 * generalized code in some situations (for instance, when manipulating
 * objects that are all known to have identifiers).  If the object in
 * question does not posess an 'id' attribute according to the SBML
 * specification for the Level and Version in use, libSBML will not allow the
 * identifier to be set, nor will it read or write 'id' attributes for those
 * objects.
 *
 *
 *
 * @return @c true if the 'id' attribute of this SBML object is
 * set, @c false otherwise.
 *
 * @note Because of the inconsistent behavior of this function with
 * respect to assignments and rules, it is recommended that callers
 * use isSetIdAttribute() instead.
 *
 * @see getIdAttribute()
 * @see setIdAttribute(string sid)
 * @see unsetIdAttribute()
 * @see isSetIdAttribute()
 *
 *
   */ public new
 bool isSetId() {
    bool ret = libsbmlPINVOKE.FunctionDefinition_isSetId(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * FunctionDefinition's 'name' attribute is set.
   *
   *
 *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  LibSBML has for a long time provided functions
 * defined on SBase itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 *
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 * 
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 * 
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 *
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 *
 *
 * 
 * @return @c true if the 'name' attribute of this SBML object is
 * set, @c false otherwise.
 *
 * @see getName()
 * @see setName(string sid)
 * @see unsetName()
 *
 *
   */ public new
 bool isSetName() {
    bool ret = libsbmlPINVOKE.FunctionDefinition_isSetName(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if this
   * FunctionDefinition's 'math' subelement contains a value.
   * 
   * @return @c true if the 'math' for this FunctionDefinition is set,
   * @c false otherwise.
   */ public
 bool isSetMath() {
    bool ret = libsbmlPINVOKE.FunctionDefinition_isSetMath(swigCPtr);
    return ret;
  }

  
/**
   * Sets the value of the 'id' attribute of this FunctionDefinition.
   *
   *
 * 
 * The string @p sid is copied.
 *
 *
 * 
 * The identifier given by an object's 'id' attribute value
 * is used to identify the object within the SBML model definition.
 * Other objects can refer to the component using this identifier.  The
 * data type of 'id' is always <code>SId</code> or a type derived
 * from that, such as <code>UnitSId</code>, depending on the object in 
 * question.  All data types are defined as follows:
 * <pre style='margin-left: 2em; border: none; font-weight: bold; color: black'>
 *   letter ::= 'a'..'z','A'..'Z'
 *   digit  ::= '0'..'9'
 *   idChar ::= letter | digit | '_'
 *   SId    ::= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping,
 * the character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers
 * is determined by an exact character sequence match; i.e., comparisons must
 * be performed in a case-sensitive manner.  This applies to all uses of
 * <code>SId</code>, <code>SIdRef</code>, and derived types.
 *
 * Users need to be aware of some important API issues that are the result of
 * the history of SBML and libSBML.  Prior to SBML Level&nbsp;3
 * Version&nbsp;2, SBML defined 'id' and 'name' attributes on only a subset
 * of SBML objects.  To simplify the work of programmers, libSBML's API
 * provided get, set, check, and unset on the SBase object class itself
 * instead of on individual subobject classes. This made the
 * get/set/etc. methods uniformly available on all objects in the libSBML
 * API.  LibSBML simply returned empty strings or otherwise did not act when
 * the methods were applied to SBML objects that were not defined by the SBML
 * specification to have 'id' or 'name' attributes.  Additional complications
 * arose with the rule and assignment objects: InitialAssignment,
 * EventAssignment, AssignmentRule, and RateRule.  In early versions of SBML,
 * the rule object hierarchy was different, and in addition, then as now,
 * they possess different attributes: 'variable' (for the rules and event
 * assignments), 'symbol' (for initial assignments), or neither (for
 * algebraic rules).  Prior to SBML Level&nbsp;3 Version&nbsp;2, getId()
 * would always return an empty string, and isSetId() would always return @c
 * false for objects of these classes.
 *
 * With the addition of 'id' and 'name' attributes on SBase in Level&nbsp;3
 * Version&nbsp;2, it became necessary to introduce a new way to interact
 * with the attributes more consistently in libSBML to avoid breaking
 * backward compatibility in the behavior of the original 'id' methods.  For
 * this reason, libSBML provides four functions (getIdAttribute(),
 * setIdAttribute(@if java String@endif), isSetIdAttribute(), and
 * unsetIdAttribute()) that always act on the actual 'id' attribute inherited
 * from SBase, regardless of the object's type.  <strong>These new methods
 * should be used instead of the older getId()/setId()/etc. methods</strong>
 * unless the old behavior is somehow necessary.  Regardless of the Level and
 * Version of the SBML, these functions allow client applications to use more
 * generalized code in some situations (for instance, when manipulating
 * objects that are all known to have identifiers).  If the object in
 * question does not posess an 'id' attribute according to the SBML
 * specification for the Level and Version in use, libSBML will not allow the
 * identifier to be set, nor will it read or write 'id' attributes for those
 * objects.
 *
 *
 * 
 * @param sid the string to use as the identifier of this object.
 *
 *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
 * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
 * @li @link libsbml#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE@endlink
 *
 * @see getIdAttribute()
 * @see setIdAttribute(string sid)
 * @see isSetIdAttribute()
 * @see unsetIdAttribute()
 * 
 *
   */ public new
 int setId(string sid) {
    int ret = libsbmlPINVOKE.FunctionDefinition_setId(swigCPtr, sid);
    return ret;
  }

  
/**
   * Sets the value of the 'name' attribute of this FunctionDefinition.
   *
   *
 * 
 *
 * The string in @p name is copied.
 *
 * @param name the new name for the SBML object.
 *
 *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
 * @li @link libsbml#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE@endlink
 *
 *
   */ public new
 int setName(string name) {
    int ret = libsbmlPINVOKE.FunctionDefinition_setName(swigCPtr, name);
    return ret;
  }

  
/**
   * Sets the 'math' subelement of this FunctionDefinition to the Abstract
   * Syntax Tree given in @p math.
   *
   * @param math an AST containing the mathematical expression to
   * be used as the formula for this FunctionDefinition.
   *
   *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
   * @li @link libsbml#LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT@endlink
   */ public new
 int setMath(ASTNode math) {
    int ret = libsbmlPINVOKE.FunctionDefinition_setMath(swigCPtr, ASTNode.getCPtr(math));
    return ret;
  }

  
/**
   * Unsets the value of the 'name' attribute of this FunctionDefinition.
   *
   *
 *
 * 
 * In SBML Level&nbsp;3 Version&nbsp;2, the 'id' and 'name' attributes were
 * moved to SBase directly, instead of being defined individually for many
 * (but not all) objects.  LibSBML has for a long time provided functions
 * defined on SBase itself to get, set, and unset those attributes, which 
 * would fail or otherwise return empty strings if executed on any object 
 * for which those attributes were not defined.  Now that all SBase objects 
 * define those attributes, those functions now succeed for any object with 
 * the appropriate level and version.
 *
 * The 'name' attribute is
 * optional and is not intended to be used for cross-referencing purposes
 * within a model.  Its purpose instead is to provide a human-readable
 * label for the component.  The data type of 'name' is the type
 * <code>string</code> defined in XML Schema.  SBML imposes no
 * restrictions as to the content of 'name' attributes beyond those
 * restrictions defined by the <code>string</code> type in XML Schema.
 *
 * The recommended practice for handling 'name' is as follows.  If a
 * software tool has the capability for displaying the content of 'name'
 * attributes, it should display this content to the user as a
 * component's label instead of the component's 'id'.  If the user
 * interface does not have this capability (e.g., because it cannot
 * display or use special characters in symbol names), or if the 'name'
 * attribute is missing on a given component, then the user interface
 * should display the value of the 'id' attribute instead.  (Script
 * language interpreters are especially likely to display 'id' instead of
 * 'name'.)
 * 
 * As a consequence of the above, authors of systems that automatically
 * generate the values of 'id' attributes should be aware some systems
 * may display the 'id''s to the user.  Authors therefore may wish to
 * take some care to have their software create 'id' values that are: (a)
 * reasonably easy for humans to type and read; and (b) likely to be
 * meaningful, for example by making the 'id' attribute be an abbreviated
 * form of the name attribute value.
 * 
 * An additional point worth mentioning is although there are
 * restrictions on the uniqueness of 'id' values, there are no
 * restrictions on the uniqueness of 'name' values in a model.  This
 * allows software applications leeway in assigning component identifiers.
 *
 * Regardless of the level and version of the SBML, these functions allow
 * client applications to use more generalized code in some situations 
 * (for instance, when manipulating objects that are all known to have 
 * names).  If the object in question does not posess a 'name' attribute 
 * according to the SBML specification for the Level and Version in use,
 * libSBML will not allow the name to be set, nor will it read or 
 * write 'name' attributes for those objects.
 *
 *
 * 
 *
 * @return integer value indicating success/failure of the
 * function.  @if clike The value is drawn from the
 * enumeration #OperationReturnValues_t. @endif The possible values
 * returned by this function are:
 * @li @link libsbml#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS@endlink
 * @li @link libsbml#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED@endlink
 *
 * @see getName()
 * @see setName(string sid)
 * @see isSetName()
 *
 *
   */ public new
 int unsetName() {
    int ret = libsbmlPINVOKE.FunctionDefinition_unsetName(swigCPtr);
    return ret;
  }

  
/**
   * Get the <code>n</code>th argument to this function.
   *
   * Callers should first find out the number of arguments to the function
   * by calling getNumArguments().
   *
   * @param n an integer index for the argument sought.
   * 
   * @return the nth argument (bound variable) passed to this
   * FunctionDefinition.
   * If the index @p n is invalid, @c null is returned.
   *
   * @see getNumArguments()
   */ public
 ASTNode getArgument(long n) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.FunctionDefinition_getArgument__SWIG_0(swigCPtr, n);
    ASTNode ret = (cPtr == global::System.IntPtr.Zero) ? null : new ASTNode(cPtr, false);
    return ret;
  }

  
/**
   * Get the argument named @p name to this FunctionDefinition.
   *
   * @param name the exact name (case-sensitive) of the sought-after
   * argument.
   * 
   * @return the argument (bound variable) having the given name, or @c null if
   * no such argument exists.
   */ public
 ASTNode getArgument(string name) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.FunctionDefinition_getArgument__SWIG_1(swigCPtr, name);
    ASTNode ret = (cPtr == global::System.IntPtr.Zero) ? null : new ASTNode(cPtr, false);
    return ret;
  }

  
/**
   * Get the mathematical expression that is the body of this
   * FunctionDefinition object.
   * 
   * @return the body of this FunctionDefinition as an Abstract Syntax
   * Tree, or @c null if no body is defined.
   */ public
 ASTNode getBody() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.FunctionDefinition_getBody__SWIG_0(swigCPtr);
    ASTNode ret = (cPtr == global::System.IntPtr.Zero) ? null : new ASTNode(cPtr, false);
    return ret;
  }

  
/**
   * Predicate returning @c true if the body of this
   * FunctionDefinition has set.
   *
   * @return @c true if the body of this FunctionDefinition is 
   * set, @c false otherwise.
   */ public
 bool isSetBody() {
    bool ret = libsbmlPINVOKE.FunctionDefinition_isSetBody(swigCPtr);
    return ret;
  }

  
/**
   * Get the number of arguments (bound variables) taken by this
   * FunctionDefinition.
   *
   * @return the number of arguments (bound variables) that must be passed
   * to this FunctionDefinition.
   */ public
 long getNumArguments() { return (long)libsbmlPINVOKE.FunctionDefinition_getNumArguments(swigCPtr); }

  
/**
   * Returns the libSBML type code for this %SBML object.
   * 
   *
 * 
 * LibSBML attaches an identifying code to every kind of SBML object.  These
 * are integer constants known as <em>SBML type codes</em>.  The names of all
 * the codes begin with the characters <code>SBML_</code>.
 * @if clike The set of possible type codes for core elements is defined in
 * the enumeration #SBMLTypeCode_t, and in addition, libSBML plug-ins for
 * SBML Level&nbsp;3 packages define their own extra enumerations of type
 * codes (e.g., #SBMLLayoutTypeCode_t for the Level&nbsp;3 Layout
 * package).@endif@if java In the Java language interface for libSBML, the
 * type codes are defined as static integer constants in the interface class
 * {@link libsbmlConstants}.  @endif@if python In the Python language
 * interface for libSBML, the type codes are defined as static integer
 * constants in the interface class @link libsbml@endlink.@endif@if csharp In
 * the C# language interface for libSBML, the type codes are defined as
 * static integer constants in the interface class
 * @link libsbmlcs.libsbml@endlink.@endif  Note that different Level&nbsp;3
 * package plug-ins may use overlapping type codes; to identify the package
 * to which a given object belongs, call the 
 * <code>@if conly SBase_getPackageName()
 * @else SBase::getPackageName()
 * @endif</code>
 * method on the object.
 *
 * The exception to this is lists:  all SBML-style list elements have the type 
 * @link libsbml#SBML_LIST_OF SBML_LIST_OF@endlink, regardless of what package they 
 * are from.
 *
 *
   *
   * @return the SBML type code for this object:
   * @link libsbml#SBML_FUNCTION_DEFINITION SBML_FUNCTION_DEFINITION@endlink (default).
   *
   *
 * @warning <span class='warning'>The specific integer values of the possible
 * type codes may be reused by different libSBML plug-ins for SBML Level&nbsp;3.
 * packages,  To fully identify the correct code, <strong>it is necessary to
 * invoke both getPackageName() and getTypeCode()</strong> (or 
 * ListOf::getItemTypeCode()).</span>
 *
 *
   *
   * @see getElementName()
   * @see getPackageName()
   */ public new
 int getTypeCode() {
    int ret = libsbmlPINVOKE.FunctionDefinition_getTypeCode(swigCPtr);
    return ret;
  }

  
/**
   * Returns the XML element name of this object, which for
   * FunctionDefinition, is always @c 'functionDefinition'.
   * 
   * @return the name of this element, i.e., @c 'functionDefinition'.
   */ public new
 string getElementName() {
    string ret = libsbmlPINVOKE.FunctionDefinition_getElementName(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if
   * all the required attributes for this FunctionDefinition object
   * have been set.
   *
   * The required attributes for a FunctionDefinition object are:
   * @li 'id'
   *
   * @return @c true if the required attributes have been set, @c false
   * otherwise.
   */ public new
 bool hasRequiredAttributes() {
    bool ret = libsbmlPINVOKE.FunctionDefinition_hasRequiredAttributes(swigCPtr);
    return ret;
  }

  
/**
   * Predicate returning @c true if
   * all the required elements for this FunctionDefinition object
   * have been set.
   *
   * @note The required elements for a FunctionDefinition object are:
   * @li 'math' inSBML Level&nbsp;2 and Level&nbsp;3 Version&nbsp;1.  
   *     (In SBML Level&nbsp;3 Version&nbsp;2+, it is no longer required.)
   *
   * @return a boolean value indicating whether all the required
   * elements for this object have been defined.
   */ public new
 bool hasRequiredElements() {
    bool ret = libsbmlPINVOKE.FunctionDefinition_hasRequiredElements(swigCPtr);
    return ret;
  }

  
/**
   * Renames all the @c UnitSIdRef attributes on this element.
   *
   *
 * 
 * In SBML, unit definitions have identifiers of type <code>UnitSId</code>.  In
 * SBML Level&nbsp;3, an explicit data type called <code>UnitSIdRef</code> was
 * introduced for attribute values that refer to <code>UnitSId</code> values; in
 * previous Levels of SBML, this data type did not exist and attributes were
 * simply described to as 'referring to a unit identifier', but the effective
 * data type was the same as <code>UnitSIdRef</code> in Level&nbsp;3.  These and
 * other methods of libSBML refer to the type <code>UnitSIdRef</code> for all
 * Levels of SBML, even if the corresponding SBML specification did not
 * explicitly name the data type.
 *
 *
   *
   * This method works by looking at all unit identifier attribute values
   * (including, if appropriate, inside mathematical formulas), comparing the
   * unit identifiers to the value of @p oldid.  If any matches are found,
   * the matching identifiers are replaced with @p newid.  The method does
   * @em not descend into child elements.
   * 
   * @param oldid the old identifier.
   * @param newid the new identifier.
   */ public new
 void renameUnitSIdRefs(string oldid, string newid) {
    libsbmlPINVOKE.FunctionDefinition_renameUnitSIdRefs(swigCPtr, oldid, newid);
  }

}

}
