/*
 *  /MathJax/config/MML_HTMLorMML-full.js
 *  
 *  Copyright (c) 2010-11 Design Science, Inc.
 *
 *  Part of the MathJax library.
 *  See http://www.mathjax.org for details.
 * 
 *  Licensed under the Apache License, Version 2.0;
 *  you may not use this file except in compliance with the License.
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 */

MathJax.Hub.Config({delayJaxRegistration: true});

MathJax.Ajax.Preloading(
  "[MathJax]/jax/input/MathML/config.js",
  "[MathJax]/jax/output/HTML-CSS/config.js",
  "[MathJax]/jax/output/NativeMML/config.js",
  "[MathJax]/config/MMLorHTML.js",
  "[MathJax]/extensions/mml2jax.js",
  "[MathJax]/extensions/MathZoom.js",
  "[MathJax]/extensions/MathMenu.js",
  "[MathJax]/jax/element/mml/jax.js",
  "[MathJax]/extensions/toMathML.js",
  "[MathJax]/jax/input/MathML/jax.js",
  "[MathJax]/jax/output/NativeMML/jax.js",
  "[MathJax]/jax/output/HTML-CSS/jax.js",
  "[MathJax]/jax/output/HTML-CSS/autoload/mtable.js"
);

MathJax.Hub.Config({"v1.0-compatible":false});

MathJax.InputJax.MathML=MathJax.InputJax({id:"MathML",version:"1.1.4",directory:MathJax.InputJax.directory+"/MathML",extensionDir:MathJax.InputJax.extensionDir+"/MathML",entityDir:MathJax.InputJax.directory+"/MathML/entities",config:{useMathMLspacing:false}});MathJax.InputJax.MathML.Register("math/mml");MathJax.InputJax.MathML.loadComplete("config.js");

MathJax.OutputJax["HTML-CSS"]=MathJax.OutputJax({id:"HTML-CSS",version:"1.1.5",directory:MathJax.OutputJax.directory+"/HTML-CSS",extensionDir:MathJax.OutputJax.extensionDir+"/HTML-CSS",autoloadDir:MathJax.OutputJax.directory+"/HTML-CSS/autoload",fontDir:MathJax.OutputJax.directory+"/HTML-CSS/fonts",webfontDir:MathJax.OutputJax.fontDir+"/HTML-CSS",config:{scale:100,minScaleAdjust:50,availableFonts:["STIX","TeX"],preferredFont:"TeX",webFont:"TeX",imageFont:"TeX",undefinedFamily:"STIXGeneral,'Arial Unicode MS',serif",showMathMenu:true,styles:{".MathJax_Display":{"text-align":"center",margin:"1em 0em"},".MathJax .merror":{"background-color":"#FFFF88",color:"#CC0000",border:"1px solid #CC0000",padding:"1px 3px","font-family":"serif","font-style":"normal","font-size":"90%"},".MathJax_Preview":{color:"#888888"},"#MathJax_Tooltip":{"background-color":"InfoBackground",color:"InfoText",border:"1px solid black","box-shadow":"2px 2px 5px #AAAAAA","-webkit-box-shadow":"2px 2px 5px #AAAAAA","-moz-box-shadow":"2px 2px 5px #AAAAAA","-khtml-box-shadow":"2px 2px 5px #AAAAAA",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')",padding:"3px 4px"}}}});if(MathJax.Hub.Browser.isMSIE&&document.documentMode>=9){delete MathJax.OutputJax["HTML-CSS"].config.styles["#MathJax_Tooltip"].filter}if(!MathJax.Hub.config.delayJaxRegistration){MathJax.OutputJax["HTML-CSS"].Register("jax/mml")}MathJax.Hub.Register.StartupHook("End Config",[function(b,c){var a=b.Insert({minBrowserVersion:{Firefox:3,Opera:9.52,MSIE:6,Chrome:0.3,Safari:2,Konqueror:4},inlineMathDelimiters:["$","$"],displayMathDelimiters:["$$","$$"],multilineDisplay:true,minBrowserTranslate:function(f){var e=b.getJaxFor(f),k=["[Math]"],j;var h=document.createElement("span",{className:"MathJax_Preview"});if(e.inputJax.id==="TeX"){if(e.root.Get("displaystyle")){j=a.displayMathDelimiters;k=[j[0]+e.originalText+j[1]];if(a.multilineDisplay){k=k[0].split(/\n/)}}else{j=a.inlineMathDelimiters;k=[j[0]+e.originalText.replace(/^\s+/,"").replace(/\s+$/,"")+j[1]]}}for(var g=0,d=k.length;g<d;g++){h.appendChild(document.createTextNode(k[g]));if(g<d-1){h.appendChild(document.createElement("br"))}}f.parentNode.insertBefore(h,f)}},(b.config["HTML-CSS"]||{}));if(b.Browser.version!=="0.0"&&!b.Browser.versionAtLeast(a.minBrowserVersion[b.Browser]||0)){c.Translate=a.minBrowserTranslate;b.Config({showProcessingMessages:false});MathJax.Message.Set("Your browser does not support MathJax",null,4000);b.Startup.signal.Post("MathJax not supported")}},MathJax.Hub,MathJax.OutputJax["HTML-CSS"]]);MathJax.OutputJax["HTML-CSS"].loadComplete("config.js");

MathJax.OutputJax.NativeMML=MathJax.OutputJax({id:"NativeMML",version:"1.1.4",directory:MathJax.OutputJax.directory+"/NativeMML",extensionDir:MathJax.OutputJax.extensionDir+"/NativeMML",config:{scale:100,showMathMenu:true,showMathMenuMSIE:true,styles:{"DIV.MathJax_MathML":{"text-align":"center",margin:".75em 0px"}}}});if(!MathJax.Hub.config.delayJaxRegistration){MathJax.OutputJax.NativeMML.Register("jax/mml")}MathJax.OutputJax.NativeMML.loadComplete("config.js");

(function(c){var h="1.1.1";var a=MathJax.Hub.CombineConfig("MMLorHTML",{prefer:{MSIE:"MML",Firefox:"MML",Opera:"HTML",other:"HTML"}});var e={Firefox:3,Opera:9.52,MSIE:6,Chrome:0.3,Safari:2,Konqueror:4};var b=(c.Browser.version==="0.0"||c.Browser.versionAtLeast(e[c.Browser]||0));var g=false;if(!c.Browser.isIE9){try{new ActiveXObject("MathPlayer.Factory.1");g=true}catch(f){}}var d=(c.Browser.isFirefox&&c.Browser.versionAtLeast("1.5"))||(c.Browser.isMSIE&&g)||(c.Browser.isOpera&&c.Browser.versionAtLeast("9.52"));c.Register.StartupHook("End Config",function(){var i=(a.prefer&&typeof(a.prefer)==="object"?a.prefer[MathJax.Hub.Browser]||a.prefer.other||"HTML":a.prefer);if(b||d){if(d&&(i==="MML"||!b)){if(MathJax.OutputJax.NativeMML){MathJax.OutputJax.NativeMML.Register("jax/mml")}else{c.config.jax.unshift("output/NativeMML")}c.Startup.signal.Post("NativeMML output selected")}else{if(MathJax.OutputJax["HTML-CSS"]){MathJax.OutputJax["HTML-CSS"].Register("jax/mml")}else{c.config.jax.unshift("output/HTML-CSS")}c.Startup.signal.Post("HTML-CSS output selected")}}else{c.PreProcess.disabled=true;c.prepareScripts.disabled=true;MathJax.Message.Set("Your browser does not support MathJax",null,4000);c.Startup.signal.Post("MathJax not supported")}})})(MathJax.Hub);MathJax.Ajax.loadComplete("[MathJax]/config/MMLorHTML.js");

MathJax.Extension.mml2jax={version:"1.1.2",config:{preview:"alttext"},MMLnamespace:"http://www.w3.org/1998/Math/MathML",PreProcess:function(e){if(!this.configured){this.config=MathJax.Hub.CombineConfig("mml2jax",this.config);if(this.config.Augment){MathJax.Hub.Insert(this,this.config.Augment)}this.InitBrowser();this.configured=true}if(typeof(e)==="string"){e=document.getElementById(e)}if(!e){e=document.body}this.ProcessMathArray(e.getElementsByTagName("math"));if(e.getElementsByTagNameNS){this.ProcessMathArray(e.getElementsByTagNameNS(this.MMLnamespace,"math"))}var d=document.getElementsByTagName("html")[0];if(d){for(var c=0,b=d.attributes.length;c<b;c++){var a=d.attributes[c];if(a.nodeName.substr(0,6)==="xmlns:"&&a.nodeValue===this.MMLnamespace){this.ProcessMathArray(e.getElementsByTagName(a.nodeName.substr(6)+":math"))}}}},ProcessMathArray:function(b){var a;if(b.length){if(this.MathTagBug){for(a=b.length-1;a>=0;a--){if(b[a].nodeName==="MATH"){this.ProcessMathFlattened(b[a])}else{this.ProcessMath(b[a])}}}else{for(a=b.length-1;a>=0;a--){this.ProcessMath(b[a])}}}},ProcessMath:function(e){var d=e.parentNode;var a=document.createElement("script");a.type="math/mml";d.insertBefore(a,e);if(this.AttributeBug){var b=this.OuterHTML(e);if(this.CleanupHTML){b=b.replace(/<\?import .*?>/i,"").replace(/<\?xml:namespace .*?\/>/i,"");b=b.replace(/&nbsp;/g,"&#xA0;")}MathJax.HTML.setScript(a,b);d.removeChild(e)}else{var c=MathJax.HTML.Element("span");c.appendChild(e);MathJax.HTML.setScript(a,c.innerHTML)}if(this.config.preview!=="none"){this.createPreview(e,a)}},ProcessMathFlattened:function(f){var d=f.parentNode;var b=document.createElement("script");b.type="math/mml";d.insertBefore(b,f);var c="",e,a=f;while(f&&f.nodeName!=="/MATH"){e=f;f=f.nextSibling;c+=this.NodeHTML(e);e.parentNode.removeChild(e)}if(f&&f.nodeName==="/MATH"){f.parentNode.removeChild(f)}b.text=c+"</math>";if(this.config.preview!=="none"){this.createPreview(a,b)}},NodeHTML:function(e){var c,b,a;if(e.nodeName==="#text"){c=this.quoteHTML(e.nodeValue)}else{if(e.nodeName==="#comment"){c="<!--"+e.nodeValue+"-->"}else{c="<"+e.nodeName.toLowerCase();for(b=0,a=e.attributes.length;b<a;b++){var d=e.attributes[b];if(d.specified){c+=" "+d.nodeName.toLowerCase().replace(/xmlns:xmlns/,"xmlns")+"=";var f=d.nodeValue;if(f==null&&d.nodeName==="style"&&e.style){f=e.style.cssText}c+='"'+this.quoteHTML(f)+'"'}}c+=">";if(e.outerHTML!=null&&e.outerHTML.match(/(.<\/[A-Z]+>|\/>)$/)){for(b=0,a=e.childNodes.length;b<a;b++){c+=this.OuterHTML(e.childNodes[b])}c+="</"+e.nodeName.toLowerCase()+">"}}}return c},OuterHTML:function(d){if(d.nodeName.charAt(0)==="#"){return this.NodeHTML(d)}if(!this.AttributeBug){return d.outerHTML}var c=this.NodeHTML(d);for(var b=0,a=d.childNodes.length;b<a;b++){c+=this.OuterHTML(d.childNodes[b])}c+="</"+d.nodeName.toLowerCase()+">";return c},quoteHTML:function(a){if(a==null){a=""}return a.replace(/&/g,"&#x26;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;")},createPreview:function(b,a){var c;if(this.config.preview==="alttext"){var d=b.getAttribute("alttext");if(d!=null){c=[this.filterText(d)]}}else{if(this.config.preview instanceof Array){c=this.config.preview}}if(c){c=MathJax.HTML.Element("span",{className:MathJax.Hub.config.preRemoveClass},c);a.parentNode.insertBefore(c,a)}},filterText:function(a){return a},InitBrowser:function(){var b=MathJax.HTML.Element("span",{id:"<",className:"mathjax",innerHTML:"<math><mi>x</mi><mspace /></math>"});var a=b.outerHTML||"";this.AttributeBug=a!==""&&!(a.match(/id="&lt;"/)&&a.match(/class="mathjax"/)&&a.match(/<\/math>/));this.MathTagBug=b.childNodes.length>1;this.CleanupHTML=MathJax.Hub.Browser.isMSIE}};MathJax.Hub.Register.PreProcessor(["PreProcess",MathJax.Extension.mml2jax]);MathJax.Ajax.loadComplete("[MathJax]/extensions/mml2jax.js");

(function(a,c,e,b,h){var i="1.1";var g=a.CombineConfig("MathZoom",{delay:400,styles:{"#MathJax_Zoom":{position:"absolute","background-color":"#F0F0F0",overflow:"auto",display:"block","z-index":301,padding:".5em",border:"1px solid black",margin:0,"font-family":"serif","font-size":"85%","font-weight":"normal","font-style":"normal","text-align":"left","text-indent":0,"text-transform":"none","line-height":"normal","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none","box-shadow":"5px 5px 15px #AAAAAA","-webkit-box-shadow":"5px 5px 15px #AAAAAA","-moz-box-shadow":"5px 5px 15px #AAAAAA","-khtml-box-shadow":"5px 5px 15px #AAAAAA",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')"},"#MathJax_ZoomOverlay":{position:"absolute",left:0,top:0,"z-index":300,display:"inline-block",width:"100%",height:"100%",border:0,padding:0,margin:0,"background-color":"white",opacity:0,filter:"alpha(opacity=0)"}}});var d=function(j){if(!j){j=window.event}if(j){if(j.preventDefault){j.preventDefault()}if(j.stopPropagation){j.stopPropagation()}j.cancelBubble=true;j.returnValue=false}return false};var f=MathJax.Extension.MathZoom={version:i,settings:a.config.menuSettings,HandleEvent:function(l,j,k){if(!l){l=window.event}if(f.settings.CTRL&&!l.ctrlKey){return true}if(f.settings.ALT&&!l.altKey){return true}if(f.settings.CMD&&!l.metaKey){return true}if(f.settings.Shift&&!l.shiftKey){return true}return f[j](l,k)},Click:function(k,j){if(this.settings.zoom==="Click"){return this.Zoom(j,k)}},DblClick:function(k,j){if(this.settings.zoom==="Double-Click"){return this.Zoom(j,k)}},Mouseover:function(k,j){if(this.settings.zoom==="Hover"){f.oldMouseOver=j.onmouseover;j.onmouseover=null;j.onmousemove=this.Mousemove;j.onmouseout=this.Mouseout;return f.Timer(k,j)}},Mouseout:function(j){this.onmouseover=f.oldMouseOver;delete f.oldMouseOver;this.onmousemove=this.onmouseout=null;f.ClearTimer();return d(j)},Mousemove:function(j){return f.Timer(j||window.event,this)},Timer:function(k,j){this.ClearTimer();this.timer=setTimeout(MathJax.Callback(["Zoom",this,j,{}]),g.delay);return d(k)},ClearTimer:function(){if(this.timer){clearTimeout(this.timer);delete this.timer}},Zoom:function(s,l){this.ClearTimer();this.Remove();var v=s.parentNode;if(v.className==="MathJax_MathContainer"){v=v.parentNode}if(v.parentNode.className==="MathJax_MathContainer"){v=v.parentNode.parentNode}var q=(String(v.className).match(/^MathJax_(MathML|Display)$/)?v:s).nextSibling;var m=a.getJaxFor(q),r=m.root;var o=(b&&m.outputJax.isa(b.constructor)?"HTMLCSS":(h&&m.outputJax.isa(h.constructor)?"MathML":null));if(!o){return}var j=Math.floor(0.85*document.body.clientWidth),p=Math.floor(0.85*document.body.clientHeight);var k=c.Element("span",{style:{position:"relative",display:"inline-block",height:0,width:0},id:"MathJax_ZoomFrame"},[["span",{id:"MathJax_ZoomOverlay",onmousedown:this.Remove}],["span",{id:"MathJax_Zoom",onclick:this.Remove,style:{visibility:"hidden",fontSize:this.settings.zscale,"max-width":j+"px","max-height":p+"px"}},[["span"]]]]);var x=k.lastChild,u=x.firstChild,n=k.firstChild;s.parentNode.insertBefore(k,s);if(this.msieZIndexBug){var t=c.Element("img",{src:"about:blank",id:"MathJax_ZoomTracker",style:{width:0,height:0,position:"relative"}});document.body.appendChild(k);k.style.position="absolute";k.style.zIndex=g.styles["#MathJax_ZoomOverlay"]["z-index"];k=t}var w=(this["Zoom"+o])(r,u,s);if(this.msiePositionBug){if(this.msieIE8Bug){u.style.position="absolute";x.style.height=u.offsetHeight;u.style.position="";if(x.offsetHeight<=p&&x.offsetWidth<=j){x.style.overflow="visible"}}if(this.msieWidthBug){x.style.width=Math.min(j,w.w)}else{if(w.w>j){x.style.width=j}}if(x.offsetHeight>p){x.style.Height=p+"px"}if(s.nextSibling){s.parentNode.insertBefore(k,s.nextSibling)}else{v.appendChild(k)}}else{if(this.operaPositionBug){x.style.width=Math.min(j,u.offsetWidth)+"px"}}this.Position(x,w,(o==="MathML"&&v.nodeName.toLowerCase()==="div"));x.style.visibility="";if(this.settings.zoom==="Hover"){n.onmouseover=this.Remove}if(window.addEventListener){addEventListener("resize",this.Resize,false)}else{if(window.attachEvent){attachEvent("onresize",this.Resize)}else{this.onresize=window.onresize;window.onresize=this.Resize}}return d(l)},ZoomHTMLCSS:function(o,q,p){q.className="MathJax";b.idPostfix="-zoom";b.getScales(q,q);o.toHTML(q,q);var r=o.HTMLspanElement().bbox;b.idPostfix="";if(r.width&&r.width!=="100%"){var j=Math.floor(0.85*document.body.clientWidth);q.style.width=j+"px";q.style.display="inline-block";var k=(o.id||"MathJax-Span-"+o.spanID)+"-zoom";var l=document.getElementById(k).firstChild;while(l&&l.style.width!==r.width){l=l.nextSibling}if(l){l.style.width="100%"}}q.appendChild(this.topImg);var n=this.topImg.offsetTop;q.removeChild(this.topImg);var m=(this.msieWidthBug?b.getW(p)*b.em:p.offsetWidth);return{w:r.w*b.em,Y:-n,W:m}},ZoomMathML:function(k,l,m){k.toNativeMML(l,l);var n;l.appendChild(this.topImg);n=this.topImg.offsetTop;l.removeChild(this.topImg);var j=(this.ffMMLwidthBug?m.parentNode:m).offsetWidth;return{w:l.offsetWidth,Y:-n,W:j}},Position:function(p,n,r){var k=this.Resize(),m=k.x,l=k.y,j=n.W;if(this.msiePositionBug){j=-j}if(r&&this.ffMMLcenterBug){j=0}var q=-Math.floor((p.offsetWidth-j)/2),o=n.Y;p.style.left=Math.max(q,20-m)+"px";p.style.top=Math.max(o,20-l)+"px"},Resize:function(l){if(f.onresize){f.onresize(l)}var j=0,o=0,n=document.getElementById("MathJax_ZoomFrame"),k=document.getElementById("MathJax_ZoomOverlay");var m=(f.msieZIndexBug?document.getElementById("MathJax_ZoomTracker"):n);if(f.operaPositionBug){n.style.border="1px solid"}if(m.offsetParent){do{j+=m.offsetLeft;o+=m.offsetTop}while(m=m.offsetParent)}if(f.operaPositionBug){n.style.border=""}if(f.msieZIndexBug){n.style.left=j+"px";n.style.top=o+"px"}k.style.left=(-j)+"px";k.style.top=(-o)+"px";if(f.msiePositionBug){setTimeout(f.SetWH,0)}else{f.SetWH()}return{x:j,y:o}},SetWH:function(){var j=document.getElementById("MathJax_ZoomOverlay");j.style.width=j.style.height="1px";j.style.width=document.body.scrollWidth+"px";j.style.height=document.body.scrollHeight+"px"},Remove:function(k){var l=document.getElementById("MathJax_ZoomFrame");if(l){l.parentNode.removeChild(l);l=document.getElementById("MathJax_ZoomTracker");if(l){l.parentNode.removeChild(l)}if(f.operaRefreshBug){var j=c.addElement(document.body,"div",{style:{position:"fixed",left:0,top:0,width:"100%",height:"100%",backgroundColor:"white",opacity:0},id:"MathJax_OperaDiv"});document.body.removeChild(j)}if(window.removeEventListener){removeEventListener("resize",f.Resize,false)}else{if(window.detachEvent){detachEvent("onresize",f.Resize)}else{window.onresize=f.onresize;delete f.onresize}}}return d(k)}};a.Register.StartupHook("HTML-CSS Jax Ready",function(){b=MathJax.OutputJax["HTML-CSS"];b.Augment({HandleEvent:f.HandleEvent})});a.Register.StartupHook("NativeMML Jax Ready",function(){h=MathJax.OutputJax.NativeMML;h.Augment({HandleEvent:f.HandleEvent,MSIEmouseup:function(l,k,j){if(this.trapUp){delete this.trapUp;return true}if(this.MSIEzoomKeys(l)){return true}return false},MSIEclick:function(l,k,j){if(this.trapClick){delete this.trapClick;return true}if(!this.MSIEzoomKeys(l)){return false}if(!this.settings.zoom.match(/Click/)){return false}return(f.Click(l,k)===false)},MSIEdblclick:function(l,k,j){if(!this.MSIEzoomKeys(l)){return false}return(f.DblClick(l,k)===false)},MSIEmouseover:function(l,k,j){if(this.settings.zoom!=="Hover"){return false}f.Timer(l,k);return true},MSIEmouseout:function(l,k,j){if(this.settings.zoom!=="Hover"){return false}f.ClearTimer();return true},MSIEmousemove:function(l,k,j){if(this.settings.zoom!=="Hover"){return false}f.Timer(l,k);return true},MSIEzoomKeys:function(j){if(this.settings.CTRL&&!j.ctrlKey){return false}if(this.settings.CMD&&!j.metaKey){return false}if(this.settings.ALT&&!j.altKey){return false}if(this.settings.Shift&&!j.shiftKey){return false}return true}})});a.Browser.Select({MSIE:function(j){var k=(document.compatMode==="BackCompat");var l=j.versionAtLeast("8.0")&&document.documentMode>7;f.msiePositionBug=true;f.msieWidthBug=!k;f.msieIE8Bug=l;f.msieZIndexBug=!l;f.msieInlineBlockAlignBug=(!l||k);if(document.documentMode>=9){delete g.styles["#MathJax_Zoom"].filter}},Opera:function(j){f.operaPositionBug=true;f.operaRefreshBug=true},Firefox:function(j){f.ffMMLwidthBug=true;f.ffMMLcenterBug=true}});f.topImg=(f.msieInlineBlockAlignBug?c.Element("img",{style:{width:0,height:0},src:"about:blank"}):c.Element("span",{style:{width:0,height:0,display:"inline-block"}}));if(f.operaPositionBug){f.topImg.style.border="1px solid"}MathJax.Callback.Queue(["Styles",e,g.styles],["Post",a.Startup.signal,"MathZoom Ready"],["loadComplete",e,"[MathJax]/extensions/MathZoom.js"])})(MathJax.Hub,MathJax.HTML,MathJax.Ajax,MathJax.OutputJax["HTML-CSS"],MathJax.OutputJax.NativeMML);

(function(b,c,f){var k="1.1.4";MathJax.Extension.MathMenu={version:k};var i=b.Browser.isPC,g=b.Browser.isMSIE;var e=(i?null:"5px");var j=b.CombineConfig("MathMenu",{delay:150,helpURL:"http://www.mathjax.org/help/user/",showRenderer:true,showFontMenu:false,showContext:false,windowSettings:{status:"no",toolbar:"no",locationbar:"no",menubar:"no",directories:"no",personalbar:"no",resizable:"yes",scrollbars:"yes",width:100,height:50},styles:{"#MathJax_About":{position:"fixed",left:"50%",width:"auto","text-align":"center",border:"3px outset",padding:"1em 2em","background-color":"#DDDDDD",color:"black",cursor:"default","font-family":"message-box","font-size":"120%","font-style":"normal","text-indent":0,"text-transform":"none","line-height":"normal","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none","z-index":201,"border-radius":"15px","-webkit-border-radius":"15px","-moz-border-radius":"15px","-khtml-border-radius":"15px","box-shadow":"0px 10px 20px #808080","-webkit-box-shadow":"0px 10px 20px #808080","-moz-box-shadow":"0px 10px 20px #808080","-khtml-box-shadow":"0px 10px 20px #808080",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')"},".MathJax_Menu":{position:"absolute","background-color":"white",color:"black",width:"auto",padding:(i?"2px":"5px 0px"),border:"1px solid #CCCCCC",margin:0,cursor:"default",font:"menu","text-align":"left","text-indent":0,"text-transform":"none","line-height":"normal","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none","z-index":201,"border-radius":e,"-webkit-border-radius":e,"-moz-border-radius":e,"-khtml-border-radius":e,"box-shadow":"0px 10px 20px #808080","-webkit-box-shadow":"0px 10px 20px #808080","-moz-box-shadow":"0px 10px 20px #808080","-khtml-box-shadow":"0px 10px 20px #808080",filter:"progid:DXImageTransform.Microsoft.dropshadow(OffX=2, OffY=2, Color='gray', Positive='true')"},".MathJax_MenuItem":{padding:(i?"2px 2em":"1px 2em"),background:"transparent"},".MathJax_MenuTitle":{"background-color":"#CCCCCC",margin:(i?"-1px -1px 1px -1px":"-5px 0 0 0"),"text-align":"center","font-style":"italic","font-size":"80%",color:"#444444",padding:"2px 0",overflow:"hidden"},".MathJax_MenuArrow":{position:"absolute",right:".5em",color:"#666666","font-family":(g?"'Arial unicode MS'":null)},".MathJax_MenuActive .MathJax_MenuArrow":{color:"white"},".MathJax_MenuCheck":{position:"absolute",left:".7em","font-family":(g?"'Arial unicode MS'":null)},".MathJax_MenuRadioCheck":{position:"absolute",left:(i?"1em":".7em")},".MathJax_MenuLabel":{padding:(i?"2px 2em 4px 1.33em":"1px 2em 3px 1.33em"),"font-style":"italic"},".MathJax_MenuRule":{"border-top":(i?"1px solid #CCCCCC":"1px solid #DDDDDD"),margin:(i?"4px 1px 0px":"4px 3px")},".MathJax_MenuDisabled":{color:"GrayText"},".MathJax_MenuActive":{"background-color":(i?"Highlight":"#606872"),color:(i?"HighlightText":"white")}}});var d=function(l){if(!l){l=window.event}if(l){if(l.preventDefault){l.preventDefault()}if(l.stopPropagation){l.stopPropagation()}l.cancelBubble=true;l.returnValue=false}return false};var a=MathJax.Menu=MathJax.Object.Subclass({version:k,items:[],posted:false,title:null,margin:5,Init:function(l){this.items=[].slice.call(arguments,0)},With:function(l){if(l){b.Insert(this,l)}return this},Post:function(n,v){if(!n){n=window.event}var t=(!this.title?null:[["div",{className:"MathJax_MenuTitle"},[this.title]]]);var l=document.getElementById("MathJax_MenuFrame");if(!l){l=a.Background(this)}var o=c.addElement(l,"div",{onmouseup:a.Mouseup,ondblclick:this.False,ondragstart:this.False,onselectstart:this.False,oncontextmenu:this.False,menuItem:this,className:"MathJax_Menu"},t);for(var q=0,p=this.items.length;q<p;q++){this.items[q].Create(o)}this.posted=true;o.style.width=(o.offsetWidth+2)+"px";var u=n.pageX,s=n.pageY;if(!u&&!s){u=n.clientX+document.body.scrollLeft+document.documentElement.scrollLeft;s=n.clientY+document.body.scrollTop+document.documentElement.scrollTop}if(!v){if(u+o.offsetWidth>document.body.offsetWidth-this.margin){u=document.body.offsetWidth-o.offsetWidth-this.margin}a.skipUp=true}else{var r="left",w=v.offsetWidth;u=v.offsetWidth-2;s=0;while(v&&v!==l){u+=v.offsetLeft;s+=v.offsetTop;v=v.parentNode}if(u+o.offsetWidth>document.body.offsetWidth-this.margin){r="right";u=Math.max(this.margin,u-w-o.offsetWidth+6)}if(!i){o.style["borderRadiusTop"+r]=0;o.style["WebkitBorderRadiusTop"+r]=0;o.style["MozBorderRadiusTop"+r]=0;o.style["KhtmlBorderRadiusTop"+r]=0}}o.style.left=u+"px";o.style.top=s+"px";if(document.selection&&document.selection.empty){document.selection.empty()}return this.False(n)},Remove:function(l,m){var n=document.getElementById("MathJax_MenuFrame");if(n){n.parentNode.removeChild(n);if(this.msieBackgroundBug){detachEvent("onresize",a.Resize)}}},Mouseup:function(l,m){if(a.skipUp){delete a.skipUp}else{this.Remove(l,m)}},False:d},{config:j,div:null,Remove:function(l){a.Event(l,this,"Remove")},Mouseover:function(l){a.Event(l,this,"Mouseover")},Mouseout:function(l){a.Event(l,this,"Mouseout")},Mousedown:function(l){a.Event(l,this,"Mousedown")},Mouseup:function(l){a.Event(l,this,"Mouseup")},Mousemove:function(l){a.Event(l,this,"Mousemove")},Event:function(n,o,l){if(!n){n=window.event}var m=o.menuItem;if(m&&m[l]){return m[l](n,o)}return null},BGSTYLE:{position:"absolute",left:0,top:0,"z-index":200,width:"100%",height:"100%",border:0,padding:0,margin:0},Background:function(m){var n=c.addElement(document.body,"div",{style:this.BGSTYLE,id:"MathJax_MenuFrame"},[["div",{style:this.BGSTYLE,menuItem:m,onmousedown:this.Remove}]]);var l=n.firstChild;if(m.msieBackgroundBug){l.style.backgroundColor="white";l.style.filter="alpha(opacity=0)";n.width=n.height=0;this.Resize();attachEvent("onresize",this.Resize)}else{l.style.position="fixed"}return n},Resize:function(){setTimeout(a.SetWH,0)},SetWH:function(){var l=document.getElementById("MathJax_MenuFrame");if(l){l=l.firstChild;l.style.width=l.style.height="1px";l.style.width=document.body.scrollWidth+"px";l.style.height=document.body.scrollHeight+"px"}},saveCookie:function(){c.Cookie.Set("menu",this.cookie)},getCookie:function(){this.cookie=c.Cookie.Get("menu")}});var h=a.ITEM=MathJax.Object.Subclass({name:"",Create:function(m){if(!this.hidden){var l={onmouseover:a.Mouseover,onmouseout:a.Mouseout,onmouseup:a.Mouseup,onmousedown:this.False,ondragstart:this.False,onselectstart:this.False,onselectend:this.False,className:"MathJax_MenuItem",menuItem:this};if(this.disabled){l.className+=" MathJax_MenuDisabled"}c.addElement(m,"div",l,this.Label(l,m))}},Mouseover:function(q,s){if(!this.disabled){this.Activate(s)}if(!this.menu||!this.menu.posted){var r=document.getElementById("MathJax_MenuFrame").childNodes,n=s.parentNode.childNodes;for(var o=0,l=n.length;o<l;o++){var p=n[o].menuItem;if(p&&p.menu&&p.menu.posted){p.Deactivate(n[o])}}l=r.length-1;while(l>=0&&s.parentNode.menuItem!==r[l].menuItem){r[l].menuItem.posted=false;r[l].parentNode.removeChild(r[l]);l--}if(this.Timer){this.Timer(q,s)}}},Mouseout:function(l,m){if(!this.menu||!this.menu.posted){this.Deactivate(m)}if(this.timer){clearTimeout(this.timer);delete this.timer}},Mouseup:function(l,m){return this.Remove(l,m)},Remove:function(l,m){m=m.parentNode.menuItem;return m.Remove(l,m)},Activate:function(l){this.Deactivate(l);l.className+=" MathJax_MenuActive"},Deactivate:function(l){l.className=l.className.replace(/ MathJax_MenuActive/,"")},With:function(l){if(l){b.Insert(this,l)}return this},False:d});a.ITEM.COMMAND=a.ITEM.Subclass({action:function(){},Init:function(l,n,m){this.name=l;this.action=n;this.With(m)},Label:function(l,m){return[this.name]},Mouseup:function(l,m){if(!this.disabled){this.Remove(l,m);this.action.call(this,l)}return this.False(l)}});a.ITEM.SUBMENU=a.ITEM.Subclass({menu:null,marker:(i&&!b.Browser.isSafari?"\u25B6":"\u25B8"),Init:function(l,n){this.name=l;var m=1;if(!(n instanceof a.ITEM)){this.With(n),m++}this.menu=a.apply(a,[].slice.call(arguments,m))},Label:function(l,m){l.onmousemove=a.Mousemove;this.menu.posted=false;return[this.name+" ",["span",{className:"MathJax_MenuArrow"},[this.marker]]]},Timer:function(l,m){if(this.timer){clearTimeout(this.timer)}l={clientX:l.clientX,clientY:l.clientY};this.timer=setTimeout(MathJax.Callback(["Mouseup",this,l,m]),j.delay)},Mouseup:function(n,p){if(!this.disabled){if(!this.menu.posted){if(this.timer){clearTimeout(this.timer);delete this.timer}this.menu.Post(n,p)}else{var o=document.getElementById("MathJax_MenuFrame").childNodes,l=o.length-1;while(l>=0){var q=o[l];q.menuItem.posted=false;q.parentNode.removeChild(q);if(q.menuItem===this.menu){break}l--}}}return this.False(n)}});a.ITEM.RADIO=a.ITEM.Subclass({variable:null,marker:(i?"\u25CF":"\u2713"),Init:function(m,l,n){this.name=m;this.variable=l;this.With(n);if(this.value==null){this.value=this.name}},Label:function(m,n){var l={className:"MathJax_MenuRadioCheck"};if(j.settings[this.variable]!==this.value){l={style:{display:"none"}}}return[["span",l,[this.marker]]," "+this.name]},Mouseup:function(p,q){if(!this.disabled){var r=q.parentNode.childNodes;for(var n=0,l=r.length;n<l;n++){var o=r[n].menuItem;if(o&&o.variable===this.variable){r[n].firstChild.style.display="none"}}q.firstChild.display="";j.settings[this.variable]=this.value;a.cookie[this.variable]=j.settings[this.variable];a.saveCookie();if(this.action){this.action.call(a)}}this.Remove(p,q);return this.False(p)}});a.ITEM.CHECKBOX=a.ITEM.Subclass({variable:null,marker:"\u2713",Init:function(m,l,n){this.name=m;this.variable=l;this.With(n)},Label:function(m,n){var l={className:"MathJax_MenuCheck"};if(!j.settings[this.variable]){l={style:{display:"none"}}}return[["span",l,[this.marker]]," "+this.name]},Mouseup:function(l,m){if(!this.disabled){m.firstChild.display=(j.settings[this.variable]?"none":"");j.settings[this.variable]=!j.settings[this.variable];a.cookie[this.variable]=j.settings[this.variable];a.saveCookie();if(this.action){this.action.call(a)}}this.Remove(l,m);return this.False(l)}});a.ITEM.LABEL=a.ITEM.Subclass({Init:function(l,m){this.name=l;this.With(m)},Label:function(l,m){delete l.onmouseover,delete l.onmouseout;delete l.onmousedown;l.className+=" MathJax_MenuLabel";return[this.name]}});a.ITEM.RULE=a.ITEM.Subclass({Label:function(l,m){delete l.onmouseover,delete l.onmouseout;delete l.onmousedown;l.className+=" MathJax_MenuRule";return null}});a.About=function(){var o=MathJax.OutputJax["HTML-CSS"]||{fontInUse:""};var q=(o.webFonts?"":"local "),m=(o.webFonts?" web":"");var n=(o.imgFonts?"Image":q+o.fontInUse+m)+" fonts";var l=["MathJax.js v"+MathJax.fileversion,["br"]];l.push(["div",{style:{"border-top":"groove 2px",margin:".25em 0"}}]);a.About.GetJax(l,MathJax.InputJax,"Input Jax");a.About.GetJax(l,MathJax.OutputJax,"Output Jax");a.About.GetJax(l,MathJax.ElementJax,"Element Jax");l.push(["div",{style:{"border-top":"groove 2px",margin:".25em 0"}}]);a.About.GetJax(l,MathJax.Extension,"Extension",true);l.push(["div",{style:{"border-top":"groove 2px",margin:".25em 0"}}],["center",{},[b.Browser+" v"+b.Browser.version+(o.webFonts?" \u2014 "+o.allowWebFonts+" fonts":"")]]);a.About.div=a.Background(a.About);var r=MathJax.HTML.addElement(a.About.div,"div",{id:"MathJax_About",onclick:a.About.Remove},[["b",{style:{fontSize:"120%"}},["MathJax"]]," v"+MathJax.version,["br"],"using "+n,["br"],["br"],["span",{style:{display:"inline-block","text-align":"left","font-size":"80%","background-color":"#E4E4E4",padding:".4em .6em",border:"1px inset"}},l],["br"],["br"],["a",{href:"http://www.mathjax.org/"},["www.mathjax.org"]]]);var s=(document.documentElement||{});var p=window.innerHeight||s.clientHeight||s.scrollHeight||0;if(a.prototype.msieAboutBug){r.style.width="20em";r.style.position="absolute";r.style.left=Math.floor((document.documentElement.scrollWidth-r.offsetWidth)/2)+"px";r.style.top=(Math.floor((p-r.offsetHeight)/3)+document.body.scrollTop)+"px"}else{r.style.marginLeft=Math.floor(-r.offsetWidth/2)+"px";r.style.top=Math.floor((p-r.offsetHeight)/3)+"px"}};a.About.Remove=function(l){if(a.About.div){document.body.removeChild(a.About.div);delete a.About.div}};a.About.GetJax=function(l,o,n,m){for(var p in o){if(o.hasOwnProperty(p)&&o[p]){if((m&&o[p].version)||(o[p].isa&&o[p].isa(o))){l.push((o[p].id||p)+" "+n+" v"+o[p].version,["br"])}}}return l};a.Help=function(){window.open(j.helpURL,"MathJaxHelp")};a.ShowSource=function(o){if(!o){o=window.event}var n={screenX:o.screenX,screenY:o.screenY};if(!a.jax){return}if(j.settings.format==="MathML"){var l=MathJax.ElementJax.mml;if(l&&typeof(l.mbase.prototype.toMathML)!=="undefined"){try{a.ShowSource.Text(a.jax.root.toMathML(),o)}catch(m){if(!m.restart){throw m}MathJax.Callback.After([this,arguments.callee,n])}}else{if(!f.loadingToMathML){f.loadingToMathML=true;a.ShowSource.Window(o);MathJax.Callback.Queue(f.Require("[MathJax]/extensions/toMathML.js"),function(){delete f.loadingToMathML},[this,arguments.callee,n]);return}}}else{if(a.jax.originalText==null){alert("No TeX form available");return}a.ShowSource.Text(a.jax.originalText,o)}};a.ShowSource.Window=function(m){if(!a.ShowSource.w){var n=[],l=j.windowSettings;for(var o in l){if(l.hasOwnProperty(o)){n.push(o+"="+l[o])}}a.ShowSource.w=window.open("","_blank",n.join(","))}return a.ShowSource.w};a.ShowSource.Text=function(r,q){var n=a.ShowSource.Window(q);r=r.replace(/^\s*/,"").replace(/\s*$/,"");r=r.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;");n.document.open();n.document.write("<html><head><title>MathJax Equation Source</title></head><body style='font-size:85%'>");n.document.write("<table><tr><td><pre>"+r+"</pre></td></tr></table>");n.document.write("</body></html>");n.document.close();var p=n.document.body.firstChild;var o=(n.outerHeight-n.innerHeight)||30,m=(n.outerWidth-n.innerWidth)||30;m=Math.min(Math.floor(0.5*screen.width),p.offsetWidth+m+25);o=Math.min(Math.floor(0.5*screen.height),p.offsetHeight+o+25);n.resizeTo(m,o);if(q&&q.screenX!=null){var l=Math.max(0,Math.min(q.screenX-Math.floor(m/2),screen.width-m-20)),s=Math.max(0,Math.min(q.screenY-Math.floor(o/2),screen.height-o-20));n.moveTo(l,s)}delete a.ShowSource.w};a.Scale=function(){var m=MathJax.OutputJax["HTML-CSS"],l=MathJax.OutputJax.NativeMML;var o=(m?m.config.scale:l.config.scale);var n=prompt("Scale all mathematics (compared to surrounding text) by",o+"%");if(n){if(n.match(/^\s*\d+\s*%?\s*$/)){n=parseInt(n);if(n){if(n!==o){if(m){m.config.scale=n}if(l){l.config.scale=n}a.cookie.scale=n;a.saveCookie();b.Reprocess()}}else{alert("The scale should not be zero")}}else{alert("The scale should be a perentage (e.g., 120%)")}}};a.Zoom=function(){if(!MathJax.Extension.MathZoom){f.Require("[MathJax]/extensions/MathZoom.js")}};a.Renderer=function(){var l=b.config.outputJax["jax/mml"];if(l[0]!==j.settings.renderer){MathJax.Callback.Queue(["Require",f,"[MathJax]/jax/output/"+j.settings.renderer+"/config.js"],["Post",b.Startup.signal,j.settings.renderer+" output selected"],[function(){var p=MathJax.OutputJax[j.settings.renderer];for(var o=0,n=l.length;o<n;o++){if(l[o]===p){l.splice(o,1);break}}l.unshift(p)}],["Reprocess",b])}};a.Font=function(){var l=MathJax.OutputJax["HTML-CSS"];if(!l){return}document.location.reload()};b.Browser.Select({MSIE:function(l){var m=(document.compatMode==="BackCompat");var n=l.versionAtLeast("8.0")&&document.documentMode>7;a.Augment({margin:20,msieBackgroundBug:(m||!n),msieAboutBug:m});if(document.documentMode>=9){delete j.styles["#MathJax_About"].filter;delete j.styles[".MathJax_Menu"].filter}}});b.Register.StartupHook("End Config",function(){j.settings=b.config.menuSettings;if(!j.settings.format){j.settings.format=(MathJax.InputJax.TeX?"Original":"MathML")}if(typeof(j.settings.showRenderer)!=="undefined"){j.showRenderer=j.settings.showRenderer}if(typeof(j.settings.showFontMenu)!=="undefined"){j.showFontMenu=j.settings.showFontMenu}if(typeof(j.settings.showContext)!=="undefined"){j.showContext=j.settings.showContext}a.getCookie();a.menu=a(h.COMMAND("Show Source",a.ShowSource),h.SUBMENU("Format",h.RADIO("MathML","format"),h.RADIO("Original","format",{value:"Original"})),h.RULE(),h.SUBMENU("Settings",h.SUBMENU("Zoom Trigger",h.RADIO("Hover","zoom",{action:a.Zoom}),h.RADIO("Click","zoom",{action:a.Zoom}),h.RADIO("Double-Click","zoom",{action:a.Zoom}),h.RADIO("No Zoom","zoom",{value:"None"}),h.RULE(),h.LABEL("Trigger Requires:"),h.CHECKBOX((b.Browser.isMac?"Option":"Alt"),"ALT"),h.CHECKBOX("Command","CMD",{hidden:!b.Browser.isMac}),h.CHECKBOX("Control","CTRL",{hidden:b.Browser.isMac}),h.CHECKBOX("Shift","Shift")),h.SUBMENU("Zoom Factor",h.RADIO("125%","zscale"),h.RADIO("133%","zscale"),h.RADIO("150%","zscale"),h.RADIO("175%","zscale"),h.RADIO("200%","zscale"),h.RADIO("250%","zscale"),h.RADIO("300%","zscale"),h.RADIO("400%","zscale")),h.RULE(),h.SUBMENU("Math Renderer",{hidden:!j.showRenderer},h.RADIO("HTML-CSS","renderer",{action:a.Renderer}),h.RADIO("MathML","renderer",{action:a.Renderer,value:"NativeMML"})),h.SUBMENU("Font Preference",{hidden:!j.showFontMenu},h.LABEL("For HTML-CSS:"),h.RADIO("Auto","font",{action:a.Font}),h.RULE(),h.RADIO("TeX (local)","font",{action:a.Font}),h.RADIO("TeX (web)","font",{action:a.Font}),h.RADIO("TeX (image)","font",{action:a.Font}),h.RULE(),h.RADIO("STIX (local)","font",{action:a.Font})),h.SUBMENU("Contextual Menu",{hidden:!j.showContext},h.RADIO("MathJax","context"),h.RADIO("Browser","context")),h.COMMAND("Scale All Math ...",a.Scale)),h.RULE(),h.COMMAND("About MathJax",a.About),h.COMMAND("MathJax Help",a.Help))});a.showRenderer=function(l){a.cookie.showRenderer=j.showRenderer=l;a.saveCookie();a.menu.items[3].menu.item[3].hidden=!l};a.showFontMenu=function(l){a.cookie.showFontMenu=j.showFontMenu=l;a.saveCookie();a.menu.items[3].menu.items[4].hidden=!l};a.showContext=function(l){a.cookie.showContext=j.showContext=l;a.saveCookie();a.menu.items[3].menu.items[5].hidden=!l};MathJax.Callback.Queue(["Styles",f,j.styles],["Post",b.Startup.signal,"MathMenu Ready"],["loadComplete",f,"[MathJax]/extensions/MathMenu.js"])})(MathJax.Hub,MathJax.HTML,MathJax.Ajax);

MathJax.ElementJax.mml=MathJax.ElementJax({mimeType:"jax/mml"},{id:"mml",version:"1.1.1",directory:MathJax.ElementJax.directory+"/mml",extensionDir:MathJax.ElementJax.extensionDir+"/mml",optableDir:MathJax.ElementJax.directory+"/mml/optable"});MathJax.ElementJax.mml.Augment({Init:function(){if(arguments.length===1&&arguments[0].type==="math"){this.root=arguments[0]}else{this.root=MathJax.ElementJax.mml.math.apply(this,arguments)}if(this.root.mode){if(!this.root.display&&this.root.mode==="display"){this.root.display="block"}delete this.root.mode}}},{INHERIT:"_inherit_",AUTO:"_auto_",SIZE:{INFINITY:"infinity",SMALL:"small",NORMAL:"normal",BIG:"big"},COLOR:{TRANSPARENT:"transparent"},VARIANT:{NORMAL:"normal",BOLD:"bold",ITALIC:"italic",BOLDITALIC:"bold-italic",DOUBLESTRUCK:"double-struck",FRAKTUR:"fraktur",BOLDFRAKTUR:"bold-fraktur",SCRIPT:"script",BOLDSCRIPT:"bold-script",SANSSERIF:"sans-serif",BOLDSANSSERIF:"bold-sans-serif",SANSSERIFITALIC:"sans-serif-italic",SANSSERIFBOLDITALIC:"sans-serif-bold-italic",MONOSPACE:"monospace",INITIAL:"inital",TAILED:"tailed",LOOPED:"looped",STRETCHED:"stretched",CALIGRAPHIC:"-tex-caligraphic",OLDSTYLE:"-tex-oldstyle"},FORM:{PREFIX:"prefix",INFIX:"infix",POSTFIX:"postfix"},LINEBREAK:{AUTO:"auto",NEWLINE:"newline",NOBREAK:"nobreak",GOODBREAK:"goodbreak",BADBREAK:"badbreak"},LINEBREAKSTYLE:{BEFORE:"before",AFTER:"after",DUPLICATE:"duplicate",INFIXLINBREAKSTYLE:"infixlinebreakstyle"},INDENTALIGN:{LEFT:"left",CENTER:"center",RIGHT:"right",AUTO:"auto",ID:"id",INDENTALIGN:"indentalign"},INDENTSHIFT:{INDENTSHIFT:"indentshift"},LINETHICKNESS:{THIN:"thin",MEDIUM:"medium",THICK:"thick"},NOTATION:{LONGDIV:"longdiv",ACTUARIAL:"actuarial",RADICAL:"radical",BOX:"box",ROUNDEDBOX:"roundedbox",CIRCLE:"circle",LEFT:"left",RIGHT:"right",TOP:"top",BOTTOM:"bottom",UPDIAGONALSTRIKE:"updiagonalstrike",DOWNDIAGONALSTRIKE:"downdiagonalstrike",VERTICALSTRIKE:"verticalstrike",HORIZONTALSTRIKE:"horizontalstrike",MADRUWB:"madruwb"},ALIGN:{TOP:"top",BOTTOM:"bottom",CENTER:"center",BASELINE:"baseline",AXIS:"axis",LEFT:"left",RIGHT:"right"},LINES:{NONE:"none",SOLID:"solid",DASHED:"dashed"},SIDE:{LEFT:"left",RIGHT:"right",LEFTOVERLAP:"leftoverlap",RIGHTOVERLAP:"rightoverlap"},WIDTH:{AUTO:"auto",FIT:"fit"},ACTIONTYPE:{TOGGLE:"toggle",STATUSLINE:"statusline",TOOLTIP:"tooltip",INPUT:"input"},LENGTH:{VERYVERYTHINMATHSPACE:"veryverythinmathspace",VERYTHINMATHSPACE:"verythinmathspace",THINMATHSPACE:"thinmathspace",MEDIUMMATHSPACE:"mediummathspace",THICKMATHSPACE:"thickmathspace",VERYTHICKMATHSPACE:"verythickmathspace",VERYVERYTHICKMATHSPACE:"veryverythickmathspace",NEGATIVEVERYVERYTHINMATHSPACE:"negativeveryverythinmathspace",NEGATIVEVERYTHINMATHSPACE:"negativeverythinmathspace",NEGATIVETHINMATHSPACE:"negativethinmathspace",NEGATIVEMEDIUMMATHSPACE:"negativemediummathspace",NEGATIVETHICKMATHSPACE:"negativethickmathspace",NEGATIVEVERYTHICKMATHSPACE:"negativeverythickmathspace",NEGATIVEVERYVERYTHICKMATHSPACE:"negativeveryverythickmathspace"},OVERFLOW:{LINBREAK:"linebreak",SCROLL:"scroll",ELIDE:"elide",TRUNCATE:"truncate",SCALE:"scale"},UNIT:{EM:"em",EX:"ex",PX:"px",IN:"in",CM:"cm",MM:"mm",PT:"pt",PC:"pc"},TEXCLASS:{ORD:0,OP:1,BIN:2,REL:3,OPEN:4,CLOSE:5,PUNCT:6,INNER:7,VCENTER:8,NONE:-1},PLANE1:String.fromCharCode(55349)});(function(a){var d=false;var b=true;a.mbase=MathJax.Object.Subclass({type:"base",isToken:d,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT},noInherit:{},Init:function(){this.data=[];if(this.inferRow&&!(arguments.length===1&&arguments[0].inferred)){this.Append(a.mrow().With({inferred:b}))}this.Append.apply(this,arguments)},With:function(f){for(var g in f){if(f.hasOwnProperty(g)){this[g]=f[g]}}return this},Append:function(){if(this.inferRow&&this.data.length){this.data[0].Append.apply(this.data[0],arguments)}else{for(var g=0,f=arguments.length;g<f;g++){this.SetData(this.data.length,arguments[g])}}},SetData:function(f,g){if(g!=null){if(!(g instanceof a.mbase)){g=(this.isToken?a.chars(g):a.mtext(g))}g.parent=this;g.setInherit(this.inheritFromMe?this:this.inherit)}this.data[f]=g},Parent:function(){var f=this.parent;while(f&&f.inferred){f=f.parent}return f},Get:function(g,k){if(typeof(this[g])!=="undefined"){return this[g]}var h=this.Parent();if(h&&h["adjustChild_"+g]!=null){return(h["adjustChild_"+g])(h.childPosition(this))}var j=this.inherit;var f=j;while(j){if(typeof(j[g])!=="undefined"){var i=j.noInherit[this.type];if(!(i&&i[g])){return j[g]}}f=j;j=j.inherit}if(!k){if(this.defaults[g]===a.AUTO){return this.autoDefault(g)}if(this.defaults[g]!==a.INHERIT&&this.defaults[g]!=null){return this.defaults[g]}if(f){return f.defaults[g]}}return null},hasValue:function(f){return(this.Get(f,true)!=null)},getValues:function(){var g={};for(var h=0,f=arguments.length;h<f;h++){g[arguments[h]]=this.Get(arguments[h])}return g},adjustChild_scriptlevel:function(f){return this.Get("scriptlevel")},adjustChild_displaystyle:function(f){return this.Get("displaystyle")},adjustChild_texprimestyle:function(f){return this.Get("texprimestyle")},childPosition:function(h){if(h.parent.inferred){h=h.parent}for(var g=0,f=this.data.length;g<f;g++){if(this.data[g]===h){return g}}return null},setInherit:function(h){if(h!==this.inherit&&this.inherit==null){this.inherit=h;for(var g=0,f=this.data.length;g<f;g++){if(this.data[g]&&this.data[g].setInherit){this.data[g].setInherit(h)}}}},setTeXclass:function(f){this.getPrevClass(f);return(typeof(this.texClass)!=="undefined"?this:f)},getPrevClass:function(f){if(f){this.prevClass=f.Get("texClass");this.prevLevel=f.Get("scriptlevel")}},updateTeXclass:function(f){if(f){this.prevClass=f.prevClass;delete f.prevClass;this.prevLevel=f.prevLevel;delete f.prevLevel;this.texClass=f.Get("texClass")}},texSpacing:function(){var g=(this.prevClass!=null?this.prevClass:a.TEXCLASS.NONE);var f=(this.Get("texClass")||a.TEXCLASS.ORD);if(g===a.TEXCLASS.NONE||f===a.TEXCLASS.NONE){return""}if(g===a.TEXCLASS.VCENTER){g=a.TEXCLASS.ORD}if(f===a.TEXCLASS.VCENTER){f=a.TEXCLASS.ORD}var h=this.TEXSPACE[g][f];if(this.prevLevel>0&&this.Get("scriptlevel")>0&&h>=0){return""}return this.TEXSPACELENGTH[Math.abs(h)]},TEXSPACELENGTH:["",a.LENGTH.THINMATHSPACE,a.LENGTH.MEDIUMMATHSPACE,a.LENGTH.THICKMATHSPACE],TEXSPACE:[[0,-1,2,3,0,0,0,1],[-1,-1,0,3,0,0,0,1],[2,2,0,0,2,0,0,2],[3,3,0,0,3,0,0,3],[0,0,0,0,0,0,0,0],[0,-1,2,3,0,0,0,1],[1,1,0,1,1,1,1,1],[1,-1,2,3,1,0,1,1]],autoDefault:function(f){return""},isSpacelike:function(){return d},isEmbellished:function(){return d},Core:function(){return this},CoreMO:function(){return this},lineBreak:function(){if(this.isEmbellished()){return this.CoreMO().lineBreak()}else{return"none"}},array:function(){if(this.inferred){return this.data}else{return[this]}},toString:function(){return this.type+"("+this.data.join(",")+")"}},{childrenSpacelike:function(){for(var f=0;f<this.data.length;f++){if(!this.data[f].isSpacelike()){return d}}return b},childEmbellished:function(){return(this.data[0]&&this.data[0].isEmbellished())},childCore:function(){return this.data[0]},childCoreMO:function(){return(this.data[0]?this.data[0].CoreMO():null)},setChildTeXclass:function(f){if(this.data[0]){f=this.data[0].setTeXclass(f);this.updateTeXclass(this.data[0])}return f},setBaseTeXclasses:function(h){this.getPrevClass(h);this.texClass=null;if(this.isEmbellished()){h=this.data[0].setTeXclass(h);this.updateTeXclass(this.Core())}else{if(this.data[0]){this.data[0].setTeXclass()}h=this}for(var g=1,f=this.data.length;g<f;g++){if(this.data[g]){this.data[g].setTeXclass()}}return h},setSeparateTeXclasses:function(h){this.getPrevClass(h);for(var g=0,f=this.data.length;g<f;g++){if(this.data[g]){this.data[g].setTeXclass()}}if(this.isEmbellished()){this.updateTeXclass(this.Core())}return this}});a.mi=a.mbase.Subclass({type:"mi",isToken:b,texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.AUTO,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT},autoDefault:function(g){if(g==="mathvariant"){var f=(this.data[0]||"").toString();return(f.length===1||(f.length===2&&f.charCodeAt(0)===this.PLANE1)?a.VARIANT.ITALIC:a.VARIANT.NORMAL)}return""}});a.mn=a.mbase.Subclass({type:"mn",isToken:b,texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT}});a.mo=a.mbase.Subclass({type:"mo",isToken:b,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT,form:a.AUTO,fence:a.AUTO,separator:a.AUTO,lspace:a.AUTO,rspace:a.AUTO,stretchy:a.AUTO,symmetric:a.AUTO,maxsize:a.AUTO,minsize:a.AUTO,largeop:a.AUTO,movablelimits:a.AUTO,accent:a.AUTO,linebreak:a.LINEBREAK.AUTO,lineleading:a.INHERIT,linebreakstyle:a.AUTO,linebreakmultchar:a.INHERIT,indentalign:a.INHERIT,indentshift:a.INHERIT,indenttarget:a.INHERIT,indentalignfirst:a.INHERIT,indentshiftfirst:a.INHERIT,indentalignlast:a.INHERIT,indentshiftlast:a.INHERIT,texClass:a.AUTO},defaultDef:{form:a.FORM.INFIX,fence:d,separator:d,lspace:a.LENGTH.THICKMATHSPACE,rspace:a.LENGTH.THICKMATHSPACE,stretchy:d,symmetric:b,maxsize:a.SIZE.INFINITY,minsize:"0em",largeop:d,movablelimits:d,accent:d,linebreak:a.LINEBREAK.AUTO,lineleading:"1ex",linebreakstyle:"before",indentalign:a.INDENTALIGN.AUTO,indentshift:"0",indenttarget:"",indentalignfirst:a.INDENTALIGN.INDENTALIGN,indentshiftfirst:a.INDENTSHIFT.INDENTSHIFT,indentalignlast:a.INDENTALIGN.INDENTALIGN,indentshiftlast:a.INDENTSHIFT.INDENTSHIFT,texClass:a.TEXCLASS.REL},SPACE_ATTR:{lspace:1,rspace:2,form:4},useMMLspacing:7,autoDefault:function(h,o){var n=this.def;if(!n){if(h==="form"){this.useMMLspacing&=~this.SPACE_ATTR.form;return this.getForm()}var l=this.data.join("");var g=[this.Get("form"),a.FORM.INFIX,a.FORM.POSTFIX,a.FORM.PREFIX];for(var j=0,f=g.length;j<f;j++){var k=this.OPTABLE[g[j]][l];if(k){n=this.makeDef(k);break}}if(!n){n=this.CheckRange(l)}if(!n&&o){n={}}else{if(!n){n=MathJax.Hub.Insert({},this.defaultDef)}n.form=g[0];this.def=n}}this.useMMLspacing&=~(this.SPACE_ATTR[h]||0);if(n[h]!=null){return n[h]}else{if(!o){return this.defaultDef[h]}}return""},CheckRange:function(k){var l=k.charCodeAt(0);if(k.charAt(0)===a.PLANE1){l=k.charCodeAt(1)+119808-56320}for(var h=0,f=this.RANGES.length;h<f&&this.RANGES[h][0]<=l;h++){if(l<=this.RANGES[h][1]){if(this.RANGES[h][3]){var g=a.optableDir+"/"+this.RANGES[h][3]+".js";this.RANGES[h][3]=null;MathJax.Hub.RestartAfter(MathJax.Ajax.Require(g))}var j=(["ORD","OP","BIN","REL","OPEN","CLOSE","PUNCT","INNER"])[this.RANGES[h][2]];j=this.OPTABLE.infix[k]=a.mo.OPTYPES[j==="BIN"?"BIN3":j];return this.makeDef(j)}}return null},makeDef:function(g){if(g[2]==null){g[2]=this.defaultDef.texClass}if(!g[3]){g[3]={}}var f=MathJax.Hub.Insert({},g[3]);f.lspace=this.SPACE[g[0]];f.rspace=this.SPACE[g[1]];f.texClass=g[2];return f},getForm:function(){var f=this,h=this.parent,g=this.Parent();while(g&&g.isEmbellished()){f=h;h=g.parent;g=g.Parent()}if(h&&h.type==="mrow"&&h.NonSpaceLength()!==1){if(h.FirstNonSpace()===f){return a.FORM.PREFIX}if(h.LastNonSpace()===f){return a.FORM.POSTFIX}}return a.FORM.INFIX},isEmbellished:function(){return b},lineBreak:function(){var f=this.getValues("linebreak","linebreakstyle");if(f.linebreak===a.LINEBREAK.NEWLINE){if(f.linebreakstyle===a.LINEBREAKSTYLE.INFIXLINEBREAKSTYLE){f.linebreakstyle=this.Get("infixlinebreakstyle")}return f.linebreakstyle}return"none"},setTeXclass:function(f){this.getValues("lspace","rspace");if(this.useMMLspacing){this.texClass=a.TEXCLASS.NONE;return this}this.texClass=this.Get("texClass");if(f){this.prevClass=f.texClass||a.TEXCLASS.ORD;this.prevLevel=f.Get("scriptlevel")}else{this.prevClass=a.TEXCLASS.NONE}if(this.texClass===a.TEXCLASS.BIN&&(this.prevClass===a.TEXCLASS.NONE||this.prevClass===a.TEXCLASS.BIN||this.prevClass===a.TEXCLASS.OP||this.prevClass===a.TEXCLASS.REL||this.prevClass===a.TEXCLASS.OPEN||this.prevClass===a.TEXCLASS.PUNCT)){this.texClass=a.TEXCLASS.ORD}else{if(this.prevClass===a.TEXCLASS.BIN&&(this.texClass===a.TEXCLASS.REL||this.texClass===a.TEXCLASS.CLOSE||this.texClass===a.TEXCLASS.PUNCT)){f.texClass=this.prevClass=a.TEXCLASS.ORD}}return this}});a.mtext=a.mbase.Subclass({type:"mtext",isToken:b,isSpacelike:function(){return b},texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT}});a.mspace=a.mbase.Subclass({type:"mspace",isToken:b,isSpacelike:function(){return b},defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,width:"0em",height:"0ex",depth:"0ex",linebreak:a.LINEBREAK.AUTO},lineBreak:function(){return(this.Get("linebreak")===a.LINEBREAK.NEWLINE?a.LINEBREAKSTYLE.AFTER:"none")}});a.ms=a.mbase.Subclass({type:"ms",isToken:b,texClass:a.TEXCLASS.ORD,defaults:{mathvariant:a.INHERIT,mathsize:a.INHERIT,mathbackground:a.INHERIT,mathcolor:a.INHERIT,lquote:'"',rquote:'"'}});a.mglyph=a.mbase.Subclass({type:"mglyph",isToken:b,texClass:a.TEXCLASS.ORD,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,alt:"",src:"",width:a.AUTO,height:a.AUTO,valign:"0em"}});a.mrow=a.mbase.Subclass({type:"mrow",isSpacelike:a.mbase.childrenSpacelike,inferred:d,isEmbellished:function(){var g=d;for(var h=0,f=this.data.length;h<f;h++){if(this.data[h]==null){continue}if(this.data[h].isEmbellished()){if(g){return d}g=b;this.core=h}else{if(!this.data[h].isSpacelike()){return d}}}return g},NonSpaceLength:function(){var h=0;for(var g=0,f=this.data.length;g<f;g++){if(this.data[g]&&!this.data[g].isSpacelike()){h++}}return h},FirstNonSpace:function(){for(var g=0,f=this.data.length;g<f;g++){if(this.data[g]&&!this.data[g].isSpacelike()){return this.data[g]}}return null},LastNonSpace:function(){for(var f=this.data.length-1;f>=0;f--){if(this.data[0]&&!this.data[f].isSpacelike()){return this.data[f]}}return null},Core:function(){if(!(this.isEmbellished())||typeof(this.core)==="undefined"){return this}return this.data[this.core]},CoreMO:function(){if(!(this.isEmbellished())||typeof(this.core)==="undefined"){return this}return this.data[this.core].CoreMO()},toString:function(){if(this.inferred){return"["+this.data.join(",")+"]"}return this.SUPER(arguments).toString.call(this)},setTeXclass:function(h){for(var g=0,f=this.data.length;g<f;g++){if(this.data[g]){h=this.data[g].setTeXclass(h)}}if(this.data[0]){this.updateTeXclass(this.data[0])}return h}});a.mfrac=a.mbase.Subclass({type:"mfrac",num:0,den:1,texClass:a.TEXCLASS.INNER,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,linethickness:a.LINETHICKNESS.MEDIUM,numalign:a.ALIGN.CENTER,denomalign:a.ALIGN.CENTER,bevelled:d},adjustChild_displaystyle:function(f){return d},adjustChild_scriptlevel:function(g){var f=this.Get("scriptlevel");if(!this.Get("displaystyle")||f>0){f++}return f},adjustChild_texprimestyle:function(f){if(f==this.den){return true}return this.Get("texprimestyle")},setTeXclass:a.mbase.setSeparateTeXclasses});a.msqrt=a.mbase.Subclass({type:"msqrt",inferRow:b,texClass:a.TEXCLASS.ORD,setTeXclass:a.mbase.setSeparateTeXclasses,adjustChild_texprimestyle:function(f){return b}});a.mroot=a.mbase.Subclass({type:"mroot",texClass:a.TEXCLASS.ORD,adjustChild_displaystyle:function(f){if(f===1){return d}return this.Get("displaystyle")},adjustChild_scriptlevel:function(g){var f=this.Get("scriptlevel");if(g===1){f+=2}return f},adjustChild_texprimestyle:function(f){if(f===0){return b}return this.Get("texprimestyle")},setTeXclass:a.mbase.setSeparateTeXclasses});a.mstyle=a.mbase.Subclass({type:"mstyle",isSpacelike:a.mbase.childrenSpacelike,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,inferRow:b,defaults:{scriptlevel:a.INHERIT,displaystyle:a.INHERIT,scriptsizemultiplier:Math.sqrt(1/2),scriptminsize:"8pt",mathbackground:a.INHERIT,mathcolor:a.INHERIT,infixlinebreakstyle:a.LINEBREAKSTYLE.BEFORE,decimalseparator:"."},adjustChild_scriptlevel:function(h){var g=this.scriptlevel;if(g==null){g=this.Get("scriptlevel")}else{if(String(g).match(/^ *[-+]/)){delete this.scriptlevel;var f=this.Get("scriptlevel");this.scriptlevel=g;g=f+parseInt(g)}}return g},inheritFromMe:b,noInherit:{mpadded:{width:b,height:b,depth:b,lspace:b,voffset:b},mtable:{width:b,height:b,depth:b,align:b}},setTeXclass:a.mbase.setChildTeXclass});a.merror=a.mbase.Subclass({type:"merror",inferRow:b,texClass:a.TEXCLASS.ORD});a.mpadded=a.mbase.Subclass({type:"mpadded",inferRow:b,isSpacelike:a.mbase.childrenSpacelike,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,width:"",height:"",depth:"",lspace:0,voffset:0},setTeXclass:a.mbase.setChildTeXclass});a.mphantom=a.mbase.Subclass({type:"mphantom",texClass:a.TEXCLASS.ORD,inferRow:b,isSpacelike:a.mbase.childrenSpacelike,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,setTeXclass:a.mbase.setChildTeXclass});a.mfenced=a.mbase.Subclass({type:"mfenced",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,open:"(",close:")",separators:","},texClass:a.TEXCLASS.OPEN,setTeXclass:function(j){this.getPrevClass(j);var g=this.getValues("open","close","separators");g.open=g.open.replace(/[ \t\n\r]/g,"");g.close=g.close.replace(/[ \t\n\r]/g,"");g.separators=g.separators.replace(/[ \t\n\r]/g,"");if(g.open!==""){this.SetData("open",a.mo(g.open).With({stretchy:true,texClass:a.TEXCLASS.OPEN}));j=this.data.open.setTeXclass(j)}if(g.separators!==""){while(g.separators.length<this.data.length){g.separators+=g.separators.charAt(g.separators.length-1)}}if(this.data[0]){j=this.data[0].setTeXclass(j)}for(var h=1,f=this.data.length;h<f;h++){if(this.data[h]){if(g.separators!==""){this.SetData("sep"+h,a.mo(g.separators.charAt(h-1)));j=this.data["sep"+h].setTeXclass(j)}j=this.data[h].setTeXclass(j)}}if(g.close!==""){this.SetData("close",a.mo(g.close).With({stretchy:true,texClass:a.TEXCLASS.CLOSE}));j=this.data.close.setTeXclass(j)}this.updateTeXclass(this.data.open);return j}});a.menclose=a.mbase.Subclass({type:"menclose",inferRow:b,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,notation:a.NOTATION.LONGDIV,texClass:a.TEXCLASS.ORD},setTeXclass:a.mbase.setSeparateTeXclasses});a.msubsup=a.mbase.Subclass({type:"msubsup",base:0,sub:1,sup:2,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,subscriptshift:"",superscriptshift:"",texClass:a.AUTO},autoDefault:function(f){if(f==="texClass"){return(this.isEmbellished()?this.CoreMO().Get(f):a.TEXCLASS.ORD)}return 0},adjustChild_displaystyle:function(f){if(f>0){return d}return this.Get("displaystyle")},adjustChild_scriptlevel:function(g){var f=this.Get("scriptlevel");if(g>0){f++}return f},adjustChild_texprimestyle:function(f){if(f===this.sub){return b}return this.Get("texprimestyle")},setTeXclass:a.mbase.setBaseTeXclasses});a.msub=a.msubsup.Subclass({type:"msub"});a.msup=a.msubsup.Subclass({type:"msup",sub:2,sup:1});a.mmultiscripts=a.msubsup.Subclass({type:"mmultiscripts",adjustChild_texprimestyle:function(f){if(f%2===1){return b}return this.Get("texprimestyle")}});a.mprescripts=a.mbase.Subclass({type:"mprescripts"});a.none=a.mbase.Subclass({type:"none"});a.munderover=a.mbase.Subclass({type:"munderover",base:0,under:1,over:2,sub:1,sup:2,ACCENTS:["","accentunder","accent"],isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,accent:a.AUTO,accentunder:a.AUTO,align:a.ALIGN.CENTER,texClass:a.AUTO,subscriptshift:"",superscriptshift:""},autoDefault:function(f){if(f==="texClass"){return(this.isEmbellished()?this.CoreMO().Get(f):a.TEXCLASS.ORD)}if(f==="accent"&&this.data[this.over]){return this.data[this.over].CoreMO().Get("accent")}if(f==="accentunder"&&this.data[this.under]){return this.data[this.under].CoreMO().Get("accent")}return d},adjustChild_displaystyle:function(f){if(f>0){return d}return this.Get("displaystyle")},adjustChild_scriptlevel:function(g){var f=this.Get("scriptlevel");if(g==this.under&&!this.Get("accentunder")){f++}if(g==this.over&&!this.Get("accent")){f++}return f},adjustChild_texprimestyle:function(f){if(f===this.base&&this.data[this.over]){return b}return this.Get("texprimestyle")},setTeXclass:a.mbase.setBaseTeXclasses});a.munder=a.munderover.Subclass({type:"munder"});a.mover=a.munderover.Subclass({type:"mover",over:1,under:2,sup:1,sub:2,ACCENTS:["","accent","accentunder"]});a.mtable=a.mbase.Subclass({type:"mtable",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,align:a.ALIGN.AXIS,rowalign:a.ALIGN.BASELINE,columnalign:a.ALIGN.CENTER,groupalign:"{left}",alignmentscope:b,columnwidth:a.WIDTH.AUTO,width:a.WIDTH.AUTO,rowspacing:"1ex",columnspacing:".8em",rowlines:a.LINES.NONE,columnlines:a.LINES.NONE,frame:a.LINES.NONE,framespacing:"0.4em 0.5ex",equalrows:d,equalcolumns:d,displaystyle:d,side:a.SIDE.RIGHT,minlabelspacing:"0.8em",texClass:a.TEXCLASS.ORD,useHeight:1},inheritFromMe:b,noInherit:{mtable:{align:b,rowalign:b,columnalign:b,groupalign:b,alignmentscope:b,columnwidth:b,width:b,rowspacing:b,columnspacing:b,rowlines:b,columnlines:b,frame:b,framespacing:b,equalrows:b,equalcolumns:b,side:b,minlabelspacing:b,texClass:b,useHeight:1}},Append:function(){for(var g=0,f=arguments.length;g<f;g++){if(!((arguments[g] instanceof a.mtr)||(arguments[g] instanceof a.mlabeledtr))){arguments[g]=a.mtd(arguments[g])}}this.SUPER(arguments).Append.apply(this,arguments)},setTeXclass:a.mbase.setSeparateTeXclasses});a.mtr=a.mbase.Subclass({type:"mtr",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,rowalign:a.INHERIT,columnalign:a.INHERIT,groupalign:a.INHERIT},inheritFromMe:b,noInherit:{mrow:{rowalign:b,columnalign:b,groupalign:b},mtable:{rowalign:b,columnalign:b,groupalign:b}},Append:function(){for(var g=0,f=arguments.length;g<f;g++){if(!(arguments[g] instanceof a.mtd)){arguments[g]=a.mtd(arguments[g])}}this.SUPER(arguments).Append.apply(this,arguments)},setTeXclass:a.mbase.setSeparateTeXclasses});a.mtd=a.mbase.Subclass({type:"mtd",inferRow:b,isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,rowspan:1,columnspan:1,rowalign:a.INHERIT,columnalign:a.INHERIT,groupalign:a.INHERIT},setTeXclass:a.mbase.setSeparateTeXclasses});a.maligngroup=a.mbase.Subclass({type:"malign",isSpacelike:function(){return b},defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,groupalign:a.INHERIT},inheritFromMe:b,noInherit:{mrow:{groupalign:b},mtable:{groupalign:b}}});a.malignmark=a.mbase.Subclass({type:"malignmark",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,edge:a.SIDE.LEFT},isSpacelike:function(){return b}});a.mlabeledtr=a.mtr.Subclass({type:"mlabeledtr"});a.maction=a.mbase.Subclass({type:"maction",defaults:{mathbackground:a.INHERIT,mathcolor:a.INHERIT,actiontype:a.ACTIONTYPE.TOGGLE,selection:1},selected:function(){return this.data[this.Get("selection")-1]||a.NULL},isEmbellished:function(){return this.selected().isEmbellished()},isSpacelike:function(){return this.selected().isSpacelike()},Core:function(){return this.selected().Core()},CoreMO:function(){return this.selected().CoreMO()},setTeXclass:function(f){return this.selected().setTeXclass(f)}});a.semantics=a.mbase.Subclass({type:"semantics",isEmbellished:a.mbase.childEmbellished,Core:a.mbase.childCore,CoreMO:a.mbase.childCoreMO,defaults:{definitionURL:null,encoding:null},setTeXclass:a.mbase.setChildTeXclass});a.annotation=a.mbase.Subclass({type:"annotation",isToken:b,defaults:{definitionURL:null,encoding:null,cd:"mathmlkeys",name:"",src:null}});a["annotation-xml"]=a.mbase.Subclass({type:"annotation-xml",defaults:{definitionURL:null,encoding:null,cd:"mathmlkeys",name:"",src:null}});a.math=a.mstyle.Subclass({type:"math",defaults:{mathvariant:a.VARIANT.NORMAL,mathsize:a.SIZE.NORMAL,mathcolor:"",mathbackground:a.COLOR.TRANSPARENT,scriptlevel:0,displaystyle:a.AUTO,display:"inline",maxwidth:"",overflow:a.OVERFLOW.LINEBREAK,altimg:"","altimg-width":"","altimg-height":"","altimg-valign":"",alttext:"",cdgroup:"",scriptsizemultiplier:Math.sqrt(1/2),scriptminsize:"8px",infixlinebreakstyle:a.LINEBREAKSTYLE.BEFORE,lineleading:"1ex",indentshift:"auto",indentalign:a.INDENTALIGN.AUTO,indentalignfirst:a.INDENTALIGN.INDENTALIGN,indentshiftfirst:a.INDENTSHIFT.INDENTSHIFT,decimalseparator:".",texprimestyle:d},autoDefault:function(f){if(f==="displaystyle"){return this.Get("display")==="block"}return""},setTeXclass:a.mbase.setChildTeXclass});a.chars=a.mbase.Subclass({type:"chars",Append:function(){this.data.push.apply(this.data,arguments)},value:function(){return this.data.join("")},toString:function(){return this.data.join("")}});a.entity=a.mbase.Subclass({type:"entity",Append:function(){this.data.push.apply(this.data,arguments)},value:function(){if(this.data[0].substr(0,2)==="#x"){return parseInt(this.data[0].substr(2),16)}else{if(this.data[0].substr(0,1)==="#"){return parseInt(this.data[0].substr(1))}else{return 0}}},toString:function(){var f=this.value();if(f<=65535){return String.fromCharCode(f)}return this.PLANE1+String.fromCharCode(f-119808+56320)}});a.xml=a.mbase.Subclass({type:"xml",Init:function(){this.div=document.createElement("div");return this.SUPER(arguments).Init.apply(this,arguments)},Append:function(){for(var g=0,f=arguments.length;g<f;g++){var h=this.Import(arguments[g]);this.data.push(h);this.div.appendChild(h)}},Import:function(k){if(document.importNode){return document.importNode(k,true)}var g,h,f;if(k.nodeType===1){g=document.createElement(k.nodeName);if(k.className){g.className=iNode.className}for(h=0,f=k.attributes.length;h<f;h++){var j=k.attributes[h];if(j.specified&&j.nodeValue!=null&&j.nodeValue!=""){g.setAttribute(j.nodeName,j.nodeValue)}if(j.nodeName==="style"){g.style.cssText=j.nodeValue}}if(k.className){g.className=k.className}}else{if(k.nodeType===3||k.nodeType===4){g=document.createTextNode(k.nodeValue)}else{if(k.nodeType===8){g=document.createComment(k.nodeValue)}else{return document.createTextNode("")}}}for(h=0,f=k.childNodes.length;h<f;h++){g.appendChild(this.Import(k.childNodes[h]))}return g},value:function(){return this.div},toString:function(){return this.div.innerHTML}});a.TeXAtom=a.mbase.Subclass({type:"texatom",inferRow:b,texClass:a.TEXCLASS.ORD,setTeXclass:function(f){this.getPrevClass(f);this.data[0].setTeXclass();return this}});a.NULL=a.mbase().With({type:"null"});var c=a.TEXCLASS;var e={ORD:[0,0,c.ORD],ORD11:[1,1,c.ORD],ORD21:[2,1,c.ORD],ORD02:[0,2,c.ORD],ORD55:[5,5,c.ORD],OP:[1,2,c.OP,{largeop:true,movablelimits:true,symmetric:true}],OPFIXED:[1,2,c.OP,{largeop:true,movablelimits:true}],INTEGRAL:[0,1,c.OP,{largeop:true,symmetric:true}],INTEGRAL2:[1,2,c.OP,{largeop:true,symmetric:true}],BIN3:[3,3,c.BIN],BIN4:[4,4,c.BIN],BIN01:[0,1,c.BIN],TALLBIN:[4,4,c.BIN,{stretchy:true}],BINOP:[4,4,c.BIN,{largeop:true,movablelimits:true}],REL:[5,5,c.REL],REL1:[1,1,c.REL,{stretchy:true}],REL4:[4,4,c.REL],WIDEREL:[5,5,c.REL,{stretchy:true}],RELACCENT:[5,5,c.REL,{accent:true,stretchy:true}],OPEN:[0,0,c.OPEN,{fence:true,stretchy:true,symmetric:true}],CLOSE:[0,0,c.CLOSE,{fence:true,stretchy:true,symmetric:true}],INNER:[0,0,c.INNER],PUNCT:[0,3,c.PUNCT],ACCENT:[0,0,c.ORD,{accent:true}],WIDEACCENT:[0,0,c.ORD,{accent:true,stretchy:true}]};a.mo.Augment({SPACE:["0em","0.1111em","0.1667em","0.2222em","0.2667em","0.3333em"],RANGES:[[32,127,c.REL,"BasicLatin"],[160,255,c.ORD,"Latin1Supplement"],[256,383,c.ORD],[384,591,c.ORD],[688,767,c.ORD,"SpacingModLetters"],[768,879,c.ORD,"CombDiacritMarks"],[880,1023,c.ORD,"GreekAndCoptic"],[7680,7935,c.ORD],[8192,8303,c.PUNCT,"GeneralPunctuation"],[8304,8351,c.ORD],[8352,8399,c.ORD],[8400,8447,c.ORD,"CombDiactForSymbols"],[8448,8527,c.ORD,"LetterlikeSymbols"],[8528,8591,c.ORD],[8592,8703,c.REL,"Arrows"],[8704,8959,c.BIN,"MathOperators"],[8960,9215,c.ORD,"MiscTechnical"],[9312,9471,c.ORD],[9632,9727,c.ORD,"GeometricShapes"],[9984,10175,c.ORD,"Dingbats"],[10176,10223,c.ORD,"MiscMathSymbolsA"],[10496,10623,c.REL,"SupplementalArrowsB"],[10624,10751,c.ORD,"MiscMathSymbolsB"],[10752,11007,c.BIN,"SuppMathOperators"],[11008,11263,c.ORD],[119808,120831,c.ORD]],OPTABLE:{prefix:{"\u2111":e.ORD11,"\u2113":e.ORD11,"\u211C":e.ORD11,"\u2200":e.ORD21,"\u2202":e.ORD21,"\u2203":e.ORD21,"\u2207":e.ORD21,"\u220F":e.OP,"\u2210":e.OP,"\u2211":e.OP,"\u2212":e.BIN01,"\u2213":e.BIN01,"\u221A":[1,1,c.ORD,{stretchy:true}],"\u2220":e.ORD,"\u222B":e.INTEGRAL,"\u222E":e.INTEGRAL,"\u22C0":e.OP,"\u22C1":e.OP,"\u22C2":e.OP,"\u22C3":e.OP,"\u2308":e.OPEN,"\u230A":e.OPEN,"\u27E8":e.OPEN,"\u2A00":e.OP,"\u2A01":e.OP,"\u2A02":e.OP,"\u2A04":e.OP,"\u2A06":e.OP,"\u00AC":e.ORD21,"\u00B1":e.BIN01,"(":e.OPEN,"+":e.BIN01,"-":e.BIN01,"[":e.OPEN,"{":e.OPEN,"|":e.OPEN},postfix:{"!":[1,0,c.CLOSE],"&":e.ORD,"\u2032":e.ORD02,"\u203E":e.WIDEACCENT,"\u2309":e.CLOSE,"\u230B":e.CLOSE,"\u23DE":e.WIDEACCENT,"\u23DF":e.WIDEACCENT,"\u266D":e.ORD02,"\u266E":e.ORD02,"\u266F":e.ORD02,"\u27E9":e.CLOSE,"\u02C6":e.WIDEACCENT,"\u02C7":e.WIDEACCENT,"\u02D8":e.ACCENT,"\u02D9":e.ACCENT,"\u02DC":e.WIDEACCENT,"\u0302":e.ACCENT,"\u00A8":e.ACCENT,"\u00AF":e.WIDEACCENT,")":e.CLOSE,"]":e.CLOSE,"^":e.WIDEACCENT,_:e.WIDEACCENT,"`":e.ACCENT,"|":e.CLOSE,"}":e.CLOSE,"~":e.WIDEACCENT},infix:{"%":[3,3,c.ORD],"\u2022":e.BIN4,"\u2026":e.INNER,"\u2044":e.TALLBIN,"\u2061":e.ORD,"\u2062":e.ORD,"\u2063":[0,0,c.ORD,{separator:true}],"\u2064":e.ORD,"\u2190":e.RELACCENT,"\u2191":e.WIDEREL,"\u2192":e.RELACCENT,"\u2193":e.WIDEREL,"\u2194":e.RELACCENT,"\u2195":e.WIDEREL,"\u2196":e.WIDEREL,"\u2197":e.WIDEREL,"\u2198":e.WIDEREL,"\u2199":e.WIDEREL,"\u21A6":e.WIDEREL,"\u21A9":e.WIDEREL,"\u21AA":e.WIDEREL,"\u21BC":e.RELACCENT,"\u21BD":e.WIDEREL,"\u21C0":e.RELACCENT,"\u21C1":e.WIDEREL,"\u21CC":e.WIDEREL,"\u21D0":e.WIDEREL,"\u21D1":e.WIDEREL,"\u21D2":e.WIDEREL,"\u21D3":e.WIDEREL,"\u21D4":e.WIDEREL,"\u21D5":e.WIDEREL,"\u2208":e.REL,"\u2209":e.REL,"\u220B":e.REL,"\u2212":e.BIN4,"\u2213":e.BIN4,"\u2215":e.TALLBIN,"\u2216":e.BIN4,"\u2217":e.BIN4,"\u2218":e.BIN4,"\u2219":e.BIN4,"\u221D":e.REL,"\u2223":e.REL,"\u2225":e.REL,"\u2227":e.BIN4,"\u2228":e.BIN4,"\u2229":e.BIN4,"\u222A":e.BIN4,"\u223C":e.REL,"\u2240":e.BIN4,"\u2243":e.REL,"\u2245":e.REL,"\u2248":e.REL,"\u224D":e.REL,"\u2250":e.REL,"\u2260":e.REL,"\u2261":e.REL,"\u2264":e.REL,"\u2265":e.REL,"\u226A":e.REL,"\u226B":e.REL,"\u227A":e.REL,"\u227B":e.REL,"\u2282":e.REL,"\u2283":e.REL,"\u2286":e.REL,"\u2287":e.REL,"\u228E":e.BIN4,"\u2291":e.REL,"\u2292":e.REL,"\u2293":e.BIN4,"\u2294":e.BIN4,"\u2295":e.BIN4,"\u2296":e.BIN4,"\u2297":e.BIN4,"\u2298":e.BIN4,"\u2299":e.BIN4,"\u22A2":e.REL,"\u22A3":e.REL,"\u22A4":e.ORD55,"\u22A5":e.REL,"\u22A8":e.REL,"\u22C4":e.BIN4,"\u22C5":e.BIN4,"\u22C6":e.BIN4,"\u22C8":e.REL,"\u22EE":e.ORD55,"\u22EF":e.INNER,"\u22F1":[5,5,c.INNER],"\u2500":[0,0,c.ORD,{stretchy:true}],"\u25B3":e.BIN4,"\u25B5":e.BIN4,"\u25B9":e.BIN4,"\u25BD":e.BIN4,"\u25BF":e.BIN4,"\u25C3":e.BIN4,"\u2758":[4,4,c.REL,{fence:true,stretchy:true,symmetric:true}],"\u27F5":e.REL1,"\u27F6":e.REL1,"\u27F7":e.REL1,"\u27F8":e.REL1,"\u27F9":e.REL1,"\u27FA":e.REL1,"\u2A2F":e.BIN4,"\u2A3F":e.BIN4,"\u2AAF":e.REL,"\u2AB0":e.REL,"\u00B1":e.BIN4,"\u00B7":e.BIN4,"\u00D7":e.BIN4,"\u00F7":e.BIN4,"*":e.BIN3,"+":e.BIN4,",":[0,3,c.PUNCT,{separator:true}],"-":e.BIN4,".":[3,3,c.ORD],"/":e.ORD11,":":[1,2,c.REL],";":[0,3,c.PUNCT,{separator:true}],"<":e.REL,"=":e.REL,">":e.REL,"?":[1,1,c.CLOSE],"\\":e.ORD,_:e.ORD11,"|":[2,2,c.ORD,{fence:true,stretchy:true,symmetric:true}],"#":e.ORD,"$":e.ORD,"\u002E":[0,3,c.PUNCT,{separator:true}],"\u02B9":e.ORD,"\u02C9":e.ACCENT,"\u02CA":e.ACCENT,"\u02CB":e.ACCENT,"\u0300":e.ACCENT,"\u0301":e.ACCENT,"\u0303":e.WIDEACCENT,"\u0304":e.ACCENT,"\u0306":e.ACCENT,"\u0307":e.ACCENT,"\u0308":e.ACCENT,"\u030C":e.ACCENT,"\u0332":e.WIDEACCENT,"\u0338":e.REL4,"\u2015":[0,0,c.ORD,{stretchy:true}],"\u2017":[0,0,c.ORD,{stretchy:true}],"\u2020":e.BIN3,"\u2021":e.BIN3,"\u20D7":e.ACCENT,"\u2118":e.ORD,"\u2205":e.ORD,"\u221E":e.ORD,"\u2305":e.BIN3,"\u2306":e.BIN3,"\u2322":e.REL4,"\u2323":e.REL4,"\u2329":e.OPEN,"\u232A":e.CLOSE,"\u23AA":e.ORD,"\u23AF":[0,0,c.ORD,{stretchy:true}],"\u23B0":e.OPEN,"\u23B1":e.CLOSE,"\u25EF":e.BIN3,"\u2660":e.ORD,"\u2661":e.ORD,"\u2662":e.ORD,"\u2663":e.ORD,"\u27EE":e.OPEN,"\u27EF":e.CLOSE,"\u27FC":e.REL4,"\u3008":e.OPEN,"\u3009":e.CLOSE,"\uFE37":e.WIDEACCENT,"\uFE38":e.WIDEACCENT}}},{OPTYPES:e})})(MathJax.ElementJax.mml);MathJax.ElementJax.mml.loadComplete("jax.js");

MathJax.Hub.Register.LoadHook("[MathJax]/jax/element/mml/jax.js",function(){var b="1.1.1";var a=MathJax.ElementJax.mml;a.mbase.Augment({toMathML:function(k){var g=(this.inferred&&this.parent.inferRow);if(k==null){k=""}var e=this.type,d=this.MathMLattributes();if(e==="mspace"){return k+"<"+e+d+" />"}var j=[];var h=(this.isToken?"":k+(g?"":"  "));for(var f=0,c=this.data.length;f<c;f++){if(this.data[f]){j.push(this.data[f].toMathML(h))}else{if(!this.isToken){j.push(h+"<mrow />")}}}if(this.isToken){return k+"<"+e+d+">"+j.join("")+"</"+e+">"}if(g){return j.join("\n")}if(j.length===0||(j.length===1&&j[0]==="")){return k+"<"+e+d+" />"}return k+"<"+e+d+">\n"+j.join("\n")+"\n"+k+"</"+e+">"},MathMLattributes:function(){var j=[],g=this.defaults;var c=this.copyAttributes,l=this.skipAttributes;if(this.type==="math"){j.push('xmlns="http://www.w3.org/1998/Math/MathML"')}if(this.type==="mstyle"){g=a.math.prototype.defaults}for(var d in g){if(!l[d]&&g.hasOwnProperty(d)){var e=(d==="open"||d==="close");if(this[d]!=null&&(e||this[d]!==g[d])){var k=this[d];delete this[d];if(e||this.Get(d)!==k){j.push(d+'="'+this.quoteHTML(k)+'"')}this[d]=k}}}for(var h=0,f=c.length;h<f;h++){if(this[c[h]]!=null){j.push(c[h]+'="'+this.quoteHTML(this[c[h]])+'"')}}if(j.length){return" "+j.join(" ")}else{return""}},copyAttributes:["fontfamily","fontsize","fontweight","fontstyle","color","background","id","class","href","style"],skipAttributes:{texClass:1,useHeight:1,texprimestyle:1},quoteHTML:function(e){e=String(e).split("");for(var f=0,d=e.length;f<d;f++){var h=e[f].charCodeAt(0);if(h<32||h>126){e[f]="&#x"+h.toString(16).toUpperCase()+";"}else{var g={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;"}[e[f]];if(g){e[f]=g}}}return e.join("")}});a.msubsup.Augment({toMathML:function(h){var e=this.type;if(this.data[this.sup]==null){e="msub"}if(this.data[this.sub]==null){e="msup"}var d=this.MathMLattributes();delete this.data[0].inferred;var g=[];for(var f=0,c=this.data.length;f<c;f++){if(this.data[f]){g.push(this.data[f].toMathML(h+"  "))}}return h+"<"+e+d+">\n"+g.join("\n")+"\n"+h+"</"+e+">"}});a.munderover.Augment({toMathML:function(h){var e=this.type;if(this.data[this.under]==null){e="mover"}if(this.data[this.over]==null){e="munder"}var d=this.MathMLattributes();delete this.data[0].inferred;var g=[];for(var f=0,c=this.data.length;f<c;f++){if(this.data[f]){g.push(this.data[f].toMathML(h+"  "))}}return h+"<"+e+d+">\n"+g.join("\n")+"\n"+h+"</"+e+">"}});a.TeXAtom.Augment({toMathML:function(c){return c+"<mrow>\n"+this.data[0].toMathML(c+"  ")+"\n"+c+"</mrow>"}});a.chars.Augment({toMathML:function(c){return(c||"")+this.quoteHTML(this.toString())}});a.entity.Augment({toMathML:function(c){return(c||"")+"&"+this.data[0]+";<!-- "+this.toString()+" -->"}});a.xml.Augment({toMathML:function(c){return(c||"")+this.toString()}});MathJax.Hub.Register.StartupHook("TeX mathchoice Ready",function(){a.TeXmathchoice.Augment({toMathML:function(c){return this.Core().toMathML(c)}})});MathJax.Hub.Startup.signal.Post("toMathML Ready")});MathJax.Ajax.loadComplete("[MathJax]/extensions/toMathML.js");

(function(b,c){var a;b.Parse=MathJax.Object.Subclass({Init:function(d){this.Parse(d)},Parse:function(f){var g;if(typeof f!=="string"){g=f.parentNode}else{if(f.match(/^<[a-z]+:/i)&&!f.match(/^<[^<>]* xmlns:/)){f=f.replace(/^<([a-z]+)(:math)/i,'<$1$2 xmlns:$1="http://www.w3.org/1998/Math/MathML"')}f=f.replace(/^\s*(?:\/\/)?<!(--)?\[CDATA\[((.|\n)*)(\/\/)?\]\]\1>\s*$/,"$2");f=f.replace(/&([a-z][a-z0-9]*);/ig,this.replaceEntity);g=b.ParseXML(f);if(g==null){b.Error("Error parsing MathML")}}var e=g.getElementsByTagName("parsererror")[0];if(e){b.Error("Error parsing MathML: "+e.textContent.replace(/This page.*?errors:|XML Parsing Error: |Below is a rendering of the page.*/g,""))}if(g.childNodes.length!==1){b.Error("MathML must be formed by a single element")}if(g.firstChild.nodeName.toLowerCase()==="html"){var d=g.getElementsByTagName("h1")[0];if(d&&d.textContent==="XML parsing error"&&d.nextSibling){b.Error("Error parsing MathML: "+String(d.nextSibling.nodeValue).replace(/fatal parsing error: /,""))}}if(g.firstChild.nodeName.toLowerCase().replace(/^[a-z]+:/,"")!=="math"){b.Error("MathML must be formed by a <math> element, not <"+g.firstChild.nodeName+">")}this.mml=this.MakeMML(g.firstChild)},MakeMML:function(h){var l=h.nodeName.toLowerCase().replace(/^[a-z]+:/,"");if(!(a[l]&&a[l].isa&&a[l].isa(a.mbase))){return a.merror("Unknown node type: "+l)}var d=a[l](),k,j,e,n;for(k=0,j=h.attributes.length;k<j;k++){e=h.attributes[k].name;if(e=="xlink:href"){e="href"}if(e.match(/:/)){continue}n=h.attributes[k].value;if(n.toLowerCase()==="true"){n=true}else{if(n.toLowerCase()==="false"){n=false}}d[e]=n}for(k=0,j=h.childNodes.length;k<j;k++){var f=h.childNodes[k];if(f.nodeName==="#comment"){continue}if(f.nodeName==="#text"){if(d.isToken&&!d.mmlSelfClosing){var o=this.trimSpace(f.nodeValue);if(d.isa(a.mo)&&o.length===1&&this.Remap[o.charAt(0)]){o=this.Remap[o.charAt(0)]}o=o.replace(/&([a-z][a-z0-9]*);/ig,this.replaceEntity);d.Append(a.chars(o))}else{if(f.nodeValue.match(/\S/)){b.Error("Unexpected text node: '"+f.nodeValue+"'")}}}else{if(d.type==="annotation-xml"){d.Append(a.xml(f))}else{var g=this.MakeMML(f);d.Append(g);if(g.mmlSelfClosing&&g.data.length){d.Append.apply(d,g.data);g.data=[]}}}}if(b.config.useMathMLspacing){d.useMMLspacing=8}return d},trimSpace:function(d){return d.replace(/^[ \t\n\r]+/,"").replace(/[ \t\n\r]+$/,"").replace(/[ \t\n\r][ \t\n\r]+/g," ")},replaceEntity:function(f,e){if(e.match(/^(lt|amp|quot)$/)){return f}if(b.Parse.Entity[e]){return b.Parse.Entity[e]}var g=e.charAt(0).toLowerCase();var d=e.match(/^[a-zA-Z](fr|scr|opf)$/);if(d){g=d[1]}if(!b.Parse.loaded[g]){b.Parse.loaded[g]=true;MathJax.Hub.RestartAfter(MathJax.Ajax.Require(b.entityDir+"/"+g+".js"))}return f},Remap:{"\u0027":"\u2032","\u002A":"\u2217","\u002D":"\u2212"}},{loaded:[]});b.Augment({Translate:function(d){if(!this.ParseXML){this.ParseXML=this.createParser()}var e,g;if(d.firstChild&&d.firstChild.nodeName.toLowerCase().replace(/^[a-z]+:/,"")==="math"){g=this.prefilterMathML(d.firstChild)}else{g=d.innerHTML.replace(/^\s+/,"").replace(/\s+$/,"");if(c.isMSIE){g=g.replace(/(&nbsp;)+$/,"")}else{if(c.isKonqueror){g=g.replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&amp;/g,"&")}}g=this.prefilterMath(g,d)}try{e=b.Parse(g).mml}catch(f){if(!f.mathmlError){throw f}e=this.formatError(f,g,d)}return a(e)},prefilterMath:function(e,d){return e},prefilterMathML:function(d){return d},formatError:function(f,e,d){return a.merror(f.message.replace(/\n.*/,""))},Error:function(d){throw MathJax.Hub.Insert(Error(d),{mathmlError:true})},parseDOM:function(d){return this.parser.parseFromString(d,"text/xml")},parseMS:function(d){return(this.parser.loadXML(d)?this.parser:null)},parseDIV:function(d){this.div.innerHTML=d.replace(/<([a-z]+)([^>]*)\/>/g,"<$1$2></$1>");return this.div},parseError:function(d){return null},createParser:function(){if(window.DOMParser){this.parser=new DOMParser();return(this.parseDOM)}else{if(window.ActiveXObject){var e=["MSXML2.DOMDocument.6.0","MSXML2.DOMDocument.5.0","MSXML2.DOMDocument.4.0","MSXML2.DOMDocument.3.0","MSXML2.DOMDocument.2.0","Microsoft.XMLDOM"];for(var f=0,d=e.length;f<d&&!this.parser;f++){try{this.parser=new ActiveXObject(e[f])}catch(g){}}if(!this.parser){alert("MathJax can't create an XML parser for MathML.  Check that\nthe 'Script ActiveX controls marked safe for scripting' security\nsetting is enabled (use the Internet Options item in the Tools\nmenu, and select the Security panel, then press the Custom Level\nbutton to check this).\n\nMathML equations will not be able to be processed by MathJax.");return(this.parseError)}this.parser.async=false;return(this.parseMS)}}this.div=MathJax.Hub.Insert(document.createElement("div"),{style:{visibility:"hidden",overflow:"hidden",height:"1px",position:"absolute",top:0}});if(!document.body.firstChild){document.body.appendChild(this.div)}else{document.body.insertBefore(this.div,document.body.firstChild)}return(this.parseDIV)},Startup:function(){a=MathJax.ElementJax.mml;a.mspace.Augment({mmlSelfClosing:true});a.none.Augment({mmlSelfClosing:true});a.mprescripts.Augment({mmlSelfClossing:true})}});b.Parse.Entity={ApplyFunction:"\u2061",Backslash:"\u2216",Because:"\u2235",Breve:"\u02D8",Cap:"\u22D2",CenterDot:"\u00B7",CircleDot:"\u2299",CircleMinus:"\u2296",CirclePlus:"\u2295",CircleTimes:"\u2297",Congruent:"\u2261",ContourIntegral:"\u222E",Coproduct:"\u2210",Cross:"\u2A2F",Cup:"\u22D3",CupCap:"\u224D",Dagger:"\u2021",Del:"\u2207",Delta:"\u0394",Diamond:"\u22C4",DifferentialD:"\u2146",DotEqual:"\u2250",DoubleDot:"\u00A8",DoubleRightTee:"\u22A8",DoubleVerticalBar:"\u2225",DownArrow:"\u2193",DownLeftVector:"\u21BD",DownRightVector:"\u21C1",DownTee:"\u22A4",Downarrow:"\u21D3",Element:"\u2208",EqualTilde:"\u2242",Equilibrium:"\u21CC",Exists:"\u2203",ExponentialE:"\u2147",FilledVerySmallSquare:"\u25AA",ForAll:"\u2200",Gamma:"\u0393",Gg:"\u22D9",GreaterEqual:"\u2265",GreaterEqualLess:"\u22DB",GreaterFullEqual:"\u2267",GreaterLess:"\u2277",GreaterSlantEqual:"\u2A7E",GreaterTilde:"\u2273",Hacek:"\u02C7",Hat:"\u005E",HumpDownHump:"\u224E",HumpEqual:"\u224F",Im:"\u2111",ImaginaryI:"\u2148",Integral:"\u222B",Intersection:"\u22C2",InvisibleComma:"\u2063",InvisibleTimes:"\u2062",Lambda:"\u039B",Larr:"\u219E",LeftAngleBracket:"\u27E8",LeftArrow:"\u2190",LeftArrowRightArrow:"\u21C6",LeftCeiling:"\u2308",LeftDownVector:"\u21C3",LeftFloor:"\u230A",LeftRightArrow:"\u2194",LeftTee:"\u22A3",LeftTriangle:"\u22B2",LeftTriangleEqual:"\u22B4",LeftUpVector:"\u21BF",LeftVector:"\u21BC",Leftarrow:"\u21D0",Leftrightarrow:"\u21D4",LessEqualGreater:"\u22DA",LessFullEqual:"\u2266",LessGreater:"\u2276",LessSlantEqual:"\u2A7D",LessTilde:"\u2272",Ll:"\u22D8",Lleftarrow:"\u21DA",LongLeftArrow:"\u27F5",LongLeftRightArrow:"\u27F7",LongRightArrow:"\u27F6",Longleftarrow:"\u27F8",Longleftrightarrow:"\u27FA",Longrightarrow:"\u27F9",Lsh:"\u21B0",MinusPlus:"\u2213",NestedGreaterGreater:"\u226B",NestedLessLess:"\u226A",NotDoubleVerticalBar:"\u2226",NotElement:"\u2209",NotEqual:"\u2260",NotExists:"\u2204",NotGreater:"\u226F",NotGreaterEqual:"\u2271",NotLeftTriangle:"\u22EA",NotLeftTriangleEqual:"\u22EC",NotLess:"\u226E",NotLessEqual:"\u2270",NotPrecedes:"\u2280",NotPrecedesSlantEqual:"\u22E0",NotRightTriangle:"\u22EB",NotRightTriangleEqual:"\u22ED",NotSubsetEqual:"\u2288",NotSucceeds:"\u2281",NotSucceedsSlantEqual:"\u22E1",NotSupersetEqual:"\u2289",NotTilde:"\u2241",NotVerticalBar:"\u2224",Omega:"\u03A9",OverBar:"\u203E",OverBrace:"\u23DE",PartialD:"\u2202",Phi:"\u03A6",Pi:"\u03A0",PlusMinus:"\u00B1",Precedes:"\u227A",PrecedesEqual:"\u2AAF",PrecedesSlantEqual:"\u227C",PrecedesTilde:"\u227E",Product:"\u220F",Proportional:"\u221D",Psi:"\u03A8",Rarr:"\u21A0",Re:"\u211C",ReverseEquilibrium:"\u21CB",RightAngleBracket:"\u27E9",RightArrow:"\u2192",RightArrowLeftArrow:"\u21C4",RightCeiling:"\u2309",RightDownVector:"\u21C2",RightFloor:"\u230B",RightTee:"\u22A2",RightTeeArrow:"\u21A6",RightTriangle:"\u22B3",RightTriangleEqual:"\u22B5",RightUpVector:"\u21BE",RightVector:"\u21C0",Rightarrow:"\u21D2",Rrightarrow:"\u21DB",Rsh:"\u21B1",Sigma:"\u03A3",SmallCircle:"\u2218",Sqrt:"\u221A",Square:"\u25A1",SquareIntersection:"\u2293",SquareSubset:"\u228F",SquareSubsetEqual:"\u2291",SquareSuperset:"\u2290",SquareSupersetEqual:"\u2292",SquareUnion:"\u2294",Star:"\u22C6",Subset:"\u22D0",SubsetEqual:"\u2286",Succeeds:"\u227B",SucceedsEqual:"\u2AB0",SucceedsSlantEqual:"\u227D",SucceedsTilde:"\u227F",SuchThat:"\u220B",Sum:"\u2211",Superset:"\u2283",SupersetEqual:"\u2287",Supset:"\u22D1",Therefore:"\u2234",Theta:"\u0398",Tilde:"\u223C",TildeEqual:"\u2243",TildeFullEqual:"\u2245",TildeTilde:"\u2248",UnderBar:"\u005F",UnderBrace:"\u23DF",Union:"\u22C3",UnionPlus:"\u228E",UpArrow:"\u2191",UpDownArrow:"\u2195",UpTee:"\u22A5",Uparrow:"\u21D1",Updownarrow:"\u21D5",Upsilon:"\u03A5",Vdash:"\u22A9",Vee:"\u22C1",VerticalBar:"\u2223",VerticalTilde:"\u2240",Vvdash:"\u22AA",Wedge:"\u22C0",Xi:"\u039E",acute:"\u00B4",aleph:"\u2135",alpha:"\u03B1",amalg:"\u2A3F",and:"\u2227",ang:"\u2220",angmsd:"\u2221",angsph:"\u2222",ape:"\u224A",backprime:"\u2035",backsim:"\u223D",backsimeq:"\u22CD",beta:"\u03B2",beth:"\u2136",between:"\u226C",bigcirc:"\u25EF",bigodot:"\u2A00",bigoplus:"\u2A01",bigotimes:"\u2A02",bigsqcup:"\u2A06",bigstar:"\u2605",bigtriangledown:"\u25BD",bigtriangleup:"\u25B3",biguplus:"\u2A04",blacklozenge:"\u29EB",blacktriangle:"\u25B4",blacktriangledown:"\u25BE",blacktriangleleft:"\u25C2",bowtie:"\u22C8",boxdl:"\u2510",boxdr:"\u250C",boxminus:"\u229F",boxplus:"\u229E",boxtimes:"\u22A0",boxul:"\u2518",boxur:"\u2514",bsol:"\u005C",bull:"\u2022",cap:"\u2229",check:"\u2713",chi:"\u03C7",circ:"\u02C6",circeq:"\u2257",circlearrowleft:"\u21BA",circlearrowright:"\u21BB",circledR:"\u00AE",circledS:"\u24C8",circledast:"\u229B",circledcirc:"\u229A",circleddash:"\u229D",clubs:"\u2663",colon:"\u003A",comp:"\u2201",ctdot:"\u22EF",cuepr:"\u22DE",cuesc:"\u22DF",cularr:"\u21B6",cup:"\u222A",curarr:"\u21B7",curlyvee:"\u22CE",curlywedge:"\u22CF",dagger:"\u2020",daleth:"\u2138",ddarr:"\u21CA",deg:"\u00B0",delta:"\u03B4",digamma:"\u03DD",div:"\u00F7",divideontimes:"\u22C7",dot:"\u02D9",doteqdot:"\u2251",dotplus:"\u2214",dotsquare:"\u22A1",dtdot:"\u22F1",ecir:"\u2256",efDot:"\u2252",egs:"\u2A96",ell:"\u2113",els:"\u2A95",empty:"\u2205",epsi:"\u03B5",epsiv:"\u03F5",erDot:"\u2253",eta:"\u03B7",eth:"\u00F0",flat:"\u266D",fork:"\u22D4",frown:"\u2322",gEl:"\u2A8C",gamma:"\u03B3",gap:"\u2A86",gimel:"\u2137",gnE:"\u2269",gnap:"\u2A8A",gne:"\u2A88",gnsim:"\u22E7",gt:"\u003E",gtdot:"\u22D7",harrw:"\u21AD",hbar:"\u210F",hellip:"\u2026",hookleftarrow:"\u21A9",hookrightarrow:"\u21AA",imath:"\u0131",infin:"\u221E",intcal:"\u22BA",iota:"\u03B9",jmath:"\u0237",kappa:"\u03BA",kappav:"\u03F0",lEg:"\u2A8B",lambda:"\u03BB",lap:"\u2A85",larrlp:"\u21AB",larrtl:"\u21A2",lbrace:"\u007B",lbrack:"\u005B",le:"\u2264",leftleftarrows:"\u21C7",leftthreetimes:"\u22CB",lessdot:"\u22D6",lmoust:"\u23B0",lnE:"\u2268",lnap:"\u2A89",lne:"\u2A87",lnsim:"\u22E6",longmapsto:"\u27FC",looparrowright:"\u21AC",lowast:"\u2217",loz:"\u25CA",lt:"\u003C",ltimes:"\u22C9",ltri:"\u25C3",macr:"\u00AF",malt:"\u2720",mho:"\u2127",mu:"\u03BC",multimap:"\u22B8",nLeftarrow:"\u21CD",nLeftrightarrow:"\u21CE",nRightarrow:"\u21CF",nVDash:"\u22AF",nVdash:"\u22AE",natur:"\u266E",nearr:"\u2197",nharr:"\u21AE",nlarr:"\u219A",not:"\u00AC",nrarr:"\u219B",nu:"\u03BD",nvDash:"\u22AD",nvdash:"\u22AC",nwarr:"\u2196",omega:"\u03C9",omicron:"\u03BF",or:"\u2228",osol:"\u2298",period:"\u002E",phi:"\u03C6",phiv:"\u03D5",pi:"\u03C0",piv:"\u03D6",prap:"\u2AB7",precnapprox:"\u2AB9",precneqq:"\u2AB5",precnsim:"\u22E8",prime:"\u2032",psi:"\u03C8",rarrtl:"\u21A3",rbrace:"\u007D",rbrack:"\u005D",rho:"\u03C1",rhov:"\u03F1",rightrightarrows:"\u21C9",rightthreetimes:"\u22CC",ring:"\u02DA",rmoust:"\u23B1",rtimes:"\u22CA",rtri:"\u25B9",scap:"\u2AB8",scnE:"\u2AB6",scnap:"\u2ABA",scnsim:"\u22E9",sdot:"\u22C5",searr:"\u2198",sect:"\u00A7",sharp:"\u266F",sigma:"\u03C3",sigmav:"\u03C2",simne:"\u2246",smile:"\u2323",spades:"\u2660",sub:"\u2282",subE:"\u2AC5",subnE:"\u2ACB",subne:"\u228A",supE:"\u2AC6",supnE:"\u2ACC",supne:"\u228B",swarr:"\u2199",tau:"\u03C4",theta:"\u03B8",thetav:"\u03D1",tilde:"\u02DC",times:"\u00D7",triangle:"\u25B5",triangleq:"\u225C",upsi:"\u03C5",upuparrows:"\u21C8",veebar:"\u22BB",vellip:"\u22EE",weierp:"\u2118",xi:"\u03BE",yen:"\u00A5",zeta:"\u03B6",zigrarr:"\u21DD"};b.loadComplete("jax.js")})(MathJax.InputJax.MathML,MathJax.Hub.Browser);

(function(b,e,d){var a,c=e.Browser.isMSIE;b.Augment({LEFTBUTTON:(c?1:0),MENUKEY:"altKey",noContextMenuBug:e.Browser.isKonequeror,msieQuirks:(c&&!(document.compatMode==="BackCompat")),msieEventBug:e.Browser.isIE9,config:{styles:{}},settings:e.config.menuSettings,Startup:function(){return MathJax.Ajax.Styles(this.config.styles)},Config:function(){this.SUPER(arguments).Config.call(this);if(this.settings.scale){this.config.scale=this.settings.scale}if(e.config.displayAlign!=="center"){var h=e.config.displayAlign,f=e.config.displayIndent;var g={"text-align":h+"!important"};g["margin-"+h]=f+"!important";MathJax.Hub.Insert(this.config.styles,{"div.MathJax_MathML":g,"div.MathJax_MathML math":{"text-align":h},"div.MathJax_MathContainer > span":{"text-align":h+"!important"}})}},InitializeMML:function(){this.initialized=true;if(MathJax.Hub.Browser.isMSIE){try{var f=document.createElement("object");f.id="mathplayer";f.classid="clsid:32F66A20-7614-11D4-BD11-00104BD3F987";document.getElementsByTagName("head")[0].appendChild(f);document.namespaces.add("mjx","http://www.w3.org/1998/Math/MathML");document.namespaces.mjx.doImport("#mathplayer")}catch(g){alert("MathJax was not able to set up MathPlayer.\n\nIf MathPlayer is not installed, you need to install it first.\nOtherwise, your security settings may be preventing ActiveX     \ncontrols from running.  Use the Internet Options item under\nthe Tools menu and select the Security tab, then press the\nCustom Level button. Check that the settings for\n'Run ActiveX Controls', and 'Binary and script behaviors'\nare enabled.\n\nCurrently you will see error messages rather than\ntypeset mathematics.")}}},Translate:function(g){if(!g.parentNode){return}if(!this.initialized){this.InitializeMML()}var k=g.previousSibling;if(k&&String(k.className).match(/^MathJax(_MathML|_Display)?$/)){k.parentNode.removeChild(k)}var j=g.MathJax.elementJax.root;var i=(j.Get("display")==="block"?"div":"span");var h=document.createElement(i),f=h;h.className="MathJax_MathML";h.style.fontSize=this.config.scale+"%";if(c&&this.config.showMathMenuMSIE){f=MathJax.HTML.addElement(h,"span",{className:"MathJax_MathContainer",style:{display:"inline-block",position:"relative"}})}j.toNativeMML(f);g.parentNode.insertBefore(h,g);if(c){if(this.config.showMathMenuMSIE){this.MSIEoverlay(h)}}else{j=h.firstChild;j.oncontextmenu=this.ContextMenu;j.onmouseover=this.Mouseover;j.onmousedown=this.Mousedown;j.onclick=this.Click;j.ondblclick=this.DblClick}},Remove:function(f){var g=f.SourceElement();if(!g){return}g=g.previousSibling;if(!g){return}if(g.className.match(/MathJax_MathML/)){g.parentNode.removeChild(g)}},MMLnamespace:"http://www.w3.org/1998/Math/MathML",MSIEoverlay:function(m){var l=m.firstChild;m.style.position="absolute";var n=m.scrollHeight,h=m.offsetWidth;var j=MathJax.HTML.addElement(m,"img",{src:"about:blank",style:{width:0,height:n+"px"}});var f=m.scrollHeight-n;m.removeChild(j);m.style.position="";var k,i,g=(m.parentNode.nodeName.toLowerCase()==="div");if(g&&this.quirks){k=-n;i=Math.floor(-h/2)}else{k=f-n,i=-h}MathJax.HTML.addElement(m,"span",{style:{display:"inline-block",width:0,height:0,position:"relative"}},[["span",{style:{display:"inline-block",position:"absolute",left:i+"px",top:k+"px",width:l.offsetWidth+"px",height:n+"px",cursor:"pointer","background-color":"white",filter:"alpha(opacity=0)"},onmousedown:this.MSIEevent,oncontextmenu:this.MSIEevent,onclick:this.MSIEevent,onmousemove:this.MSIEevent,ondblclick:this.MSIEevent,onmouseover:this.MSIEevent,onmouseout:this.MSIEevent}]])},MSIEmath:function(f){var g=f.parentNode.previousSibling.firstChild;return(g.nodeName.toLowerCase()==="span"?g.firstChild:g)},MSIEevent:function(){var g=b.MSIEmath(this);var f=window.event;var h=b["MSIE"+f.type];if(h&&h.call(b,f,g,this)){return false}g.fireEvent("on"+f.type,f);return false},MSIEmousedown:function(h,g,f){if(h[this.MENUKEY]&&h.button===this.LEFTBUTTON&&this.settings.context!=="MathJax"){this.trapUp=this.trapClick=true;this.ContextMenu.call(f,h,true);return true}if(this.MSIEzoomKeys&&this.MSIEzoomKeys(h)){this.trapUp=true;return true}return false},MSIEcontextmenu:function(h,g,f){if(this.settings.context==="MathJax"){this.trapUp=this.trapClick=true;this.ContextMenu.call(f,h,true);return true}return false},ContextMenu:function(i,j){if(b.config.showMathMenu&&(b.settings.context==="MathJax"||j)){if(b.safariContextMenuBug){setTimeout("window.getSelection().empty()",0)}if(!i||b.msieEventBug){i=window.event}var g=MathJax.Menu;if(g){if(document.selection){setTimeout("document.selection.empty()",0)}var f=(c?this.parentNode.parentNode.nextSibling:this.parentNode.nextSibling);g.jax=e.getJaxFor(f);g.menu.items[1].menu.items[1].name=(g.jax.inputJax.id==="MathML"?"Original":g.jax.inputJax.id);delete b.trapClick;delete b.trapUp;return g.menu.Post(i)}else{if(!d.loadingMathMenu){d.loadingMathMenu=true;var h={pageX:i.pageX,pageY:i.pageY,clientX:i.clientX,clientY:i.clientY};MathJax.Callback.Queue(d.Require("[MathJax]/extensions/MathMenu.js"),function(){delete d.loadingMathMenu},[this,arguments.callee,h,j])}if(!i){i=window.event}if(i.preventDefault){i.preventDefault()}if(i.stopPropagation){i.stopPropagation()}i.cancelBubble=true;i.returnValue=false;return false}}},Mousedown:function(f){if(b.config.showMathMenu){if(!f){f=window.event}if(b.settings.context==="MathJax"){if(!b.noContextMenuBug||f.button!==2){return}}else{if(!f[b.MENUKEY]||f.button!==b.LEFTBUTTON){return}}return b.ContextMenu.call(this,f,true)}},Mouseover:function(f){b.HandleEvent(f,"Mouseover",this)},Click:function(f){b.HandleEvent(f,"Click",this)},DblClick:function(f){b.HandleEvent(f,"DblClick",this)},HandleEvent:function(h,f,g){},NAMEDSPACE:{negativeveryverythinmathspace:"-.0556em",negativeverythinmathspace:"-.1111em",negativethinmathspace:"-.1667em",negativemediummathspace:"-.2222em",negativethickmathspace:"-.2778em",negativeverythickmathspace:"-.3333em",negativeveryverythickmathspace:"-.3889em"}});e.Register.StartupHook("mml Jax Ready",function(){a=MathJax.ElementJax.mml;a.mbase.Augment({toNativeMML:function(k){var h=this.NativeMMLelement(this.type);this.NativeMMLattributes(h);for(var j=0,g=this.data.length;j<g;j++){if(this.data[j]){this.data[j].toNativeMML(h)}else{h.appendChild(this.NativeMMLelement("mrow"))}}k.appendChild(h)},NativeMMLattributes:function(h){var l=this.defaults;var o=this.NativeMMLcopyAttributes,k=this.NativeMMLskipAttributes;if(this.type==="mstyle"){l=a.math.prototype.defaults}for(var n in l){if(!k[n]&&l.hasOwnProperty(n)){if(this[n]!=null){h.setAttribute(n,this.NativeMMLattribute(n,this[n]))}}}for(var j=0,g=o.length;j<g;j++){if(this[o[j]]!=null){h.setAttribute(o[j],this.NativeMMLattribute(o[j],this[o[j]]))}}},NativeMMLcopyAttributes:["fontfamily","fontsize","fontweight","fontstyle","color","background","id","class","href","style"],NativeMMLskipAttributes:{texClass:1,useHeight:1,texprimestyle:1},NativeMMLattribute:function(h,g){g=String(g);if(b.NAMEDSPACE[g]){g=b.NAMEDSPACE[g]}else{if(g.match(/^\s*([-+]?(\d+(\.\d*)?|\.\d+))\s*mu\s*$/)){g=((1/18)*RegExp.$1)+"em"}else{if(g==="-tex-caligraphic"){g="script"}else{if(g==="-tex-oldstyle"){g="normal"}}}}return g},NativeMMLelement:(c?function(g){return document.createElement("mjx:"+g)}:function(g){return document.createElementNS(b.MMLnamespace,g)})});a.mrow.Augment({toNativeMML:function(j){if(this.inferred&&this.parent.inferRow){for(var h=0,g=this.data.length;h<g;h++){if(this.data[h]){this.data[h].toNativeMML(j)}else{j.appendChild(this.NativeMMLelement("mrow"))}}}else{this.SUPER(arguments).toNativeMML.call(this,j)}}});a.msubsup.Augment({toNativeMML:function(l){var k=this.type;if(this.data[this.sup]==null){k="msub"}if(this.data[this.sub]==null){k="msup"}var h=this.NativeMMLelement(k);this.NativeMMLattributes(h);delete this.data[0].inferred;for(var j=0,g=this.data.length;j<g;j++){if(this.data[j]){this.data[j].toNativeMML(h)}}l.appendChild(h)}});a.munderover.Augment({toNativeMML:function(l){var k=this.type;if(this.data[this.under]==null){k="mover"}if(this.data[this.over]==null){k="munder"}var h=this.NativeMMLelement(k);this.NativeMMLattributes(h);delete this.data[0].inferred;for(var j=0,g=this.data.length;j<g;j++){if(this.data[j]){this.data[j].toNativeMML(h)}}l.appendChild(h)}});if(MathJax.Hub.Browser.isFirefox){a.mtable.Augment({toNativeMML:function(g){if(this.width){var h=(this.style||"").replace(/;\s*$/,"").split(";");h.push("width:"+this.width);this.style=h.join(";")}this.SUPER(arguments).toNativeMML.call(this,g)}});a.mlabeledtr.Augment({toNativeMML:function(k){var h=this.NativeMMLelement("mtr");this.NativeMMLattributes(h);for(var j=1,g=this.data.length;j<g;j++){if(this.data[j]){this.data[j].toNativeMML(h)}else{h.appendChild(this.NativeMMLelement("mrow"))}}k.appendChild(h)}});var f=MathJax.Hub.config.root+"/fonts/HTML-CSS/TeX/otf";b.Augment({config:{styles:{'[mathvariant="double-struck"]':{"font-family":"MathJax_AMS"},'[mathvariant="script"]':{"font-family":"MathJax_Script"},'[mathvariant="fraktur"]':{"font-family":"MathJax_Fraktur"},'[mathvariant="-tex-oldstyle"]':{"font-family":"MathJax_Caligraphic"},'[mathvariant="-tex-oldstyle-bold"]':{"font-family":"MathJax_Caligraphic","font-weight":"bold"},'[mathvariant="-tex-caligraphic"]':{"font-family":"MathJax_Caligraphic"},'[mathvariant="-tex-caligraphic-bold"]':{"font-family":"MathJax_Caligraphic","font-weight":"bold"},'[mathvariant="bold-script"]':{"font-family":"MathJax_Script","font-weight":"bold"},'[mathvariant="bold-fraktur"]':{"font-family":"MathJax_Fraktur","font-weight":"bold"},'[mathvariant="monospace"]':{"font-family":"monospace"},'[mathvariant="sans-serif"]':{"font-family":"sansserif"},'[mathvariant="bold-sans-serif"]':{"font-family":"sansserif","font-weight":"bold"},'[mathvariant="sans-serif-italic"]':{"font-family":"sansserif","font-style":"italic"},'[mathvariant="sans-serif-bold-italic"]':{"font-family":"sansserif","font-style":"italic","font-weight":"bold"},"@font-face /*1*/":{"font-family":"MathJax_AMS",src:"local('MathJax_AMS'), url('"+f+"/MathJax_AMS-Regular.otf')"},"@font-face /*2*/":{"font-family":"MathJax_Script",src:"local('MathJax_Script'), url('"+f+"/MathJax_Script-Regular.otf')"},"@font-face /*3*/":{"font-family":"MathJax_Fraktur",src:"local('MathJax_Fraktur'), url('"+f+"/MathJax_Fraktur-Regular.otf')"},"@font-face /*4*/":{"font-family":"MathJax_Caligraphic",src:"local('MathJax_Caligraphic'), url('"+f+"/MathJax_Caligraphic-Regular.otf')"},"@font-face /*5*/":{"font-family":"MathJax_Fraktur","font-weight":"bold",src:"local('MathJax_Fraktur-Bold'), url('"+f+"/MathJax_Fraktur-Bold.otf')"},"@font-face /*6*/":{"font-family":"MathJax_Caligraphic","font-weight":"bold",src:"local('MathJax_Caligraphic-Bold'), url('"+f+"/MathJax_Caligraphic-Bold.otf')"}}}})}a.TeXAtom.Augment({toNativeMML:function(h){var g=this.NativeMMLelement("mrow");this.data[0].toNativeMML(g);h.appendChild(g)}});a.chars.Augment({toNativeMML:function(g){g.appendChild(document.createTextNode(this.toString()))}});a.entity.Augment({toNativeMML:function(g){g.appendChild(document.createTextNode(this.toString()))}});a.xml.Augment({toNativeMML:function(j){for(var h=0,g=this.data.length;h<g;h++){j.appendChild(this.data[h].cloneNode(true))}}});e.Register.StartupHook("TeX mathchoice Ready",function(){a.TeXmathchoice.Augment({toNativeMML:function(g){this.Core().toNativeMML(g)}})});setTimeout(MathJax.Callback(["loadComplete",b,"jax.js"]),0)});e.Register.StartupHook("End Cookie",function(){if(e.config.menuSettings.zoom!=="None"){d.Require("[MathJax]/extensions/MathZoom.js")}})})(MathJax.OutputJax.NativeMML,MathJax.Hub,MathJax.Ajax);

(function(c,d,e){var a;var b=MathJax.Object.Subclass({timeout:5*1000,FontInfo:{STIX:{family:"STIXSizeOneSym",testString:"() {} []"},TeX:{family:"MathJax_Size1",testString:"() {} []"}},comparisonFont:["sans-serif","monospace","script","Times","Courier","Arial","Helvetica"],testSize:["40px","50px","60px","30px","20px"],Init:function(){this.div=MathJax.HTML.addElement(document.body,"div",{style:{position:"absolute",visibility:"hidden",top:0,left:0,width:"auto",padding:0,border:0,margin:0,textAlign:"left",textIndent:0,textTransform:"none",lineHeight:"normal",letterSpacing:"normal",wordSpacing:"normal",fontSize:this.testSize[0],fontWeight:"normal",fontStyle:"normal"}},[""]);this.text=this.div.firstChild},findFont:function(j,g){if(g&&this.testCollection(g)){return g}for(var h=0,f=j.length;h<f;h++){if(j[h]===g){continue}if(this.testCollection(j[h])){return j[h]}}return null},testCollection:function(f){return this.testFont(this.FontInfo[f])},testFont:function(h){if(h.isWebFont&&e.FontFaceBug){this.div.style.fontWeight=this.div.style.fontStyle="normal"}else{this.div.style.fontWeight=(h.weight||"normal");this.div.style.fontStyle=(h.style||"normal")}var g=this.getComparisonWidths(h.testString,h.noStyleChar);if(g){this.div.style.fontFamily="'"+h.family+"',"+this.comparisonFont[0];if(this.div.offsetWidth==g[0]){this.div.style.fontFamily="'"+h.family+"',"+this.comparisonFont[g[2]];if(this.div.offsetWidth==g[1]){return false}}if(this.div.offsetWidth!=g[3]){if(h.noStyleChar||!e.FONTDATA||!e.FONTDATA.hasStyleChar){return true}for(var j=0,f=this.testSize.length;j<f;j++){if(this.testStyleChar(h,this.testSize[j])){return true}}}}return false},styleChar:String.fromCharCode(61437),versionChar:String.fromCharCode(61438),compChar:String.fromCharCode(61439),testStyleChar:function(h,j){var m=3+(h.weight?2:0)+(h.style?4:0);var g="",i=0;var l=this.div.style.fontSize;this.div.style.fontSize=j;if(e.msieItalicWidthBug&&h.style==="italic"){this.text.nodeValue=g=this.compChar;i=this.div.offsetWidth}if(e.safariTextNodeBug){this.div.innerHTML=this.compChar+g}else{this.text.nodeValue=this.compChar+g}var f=this.div.offsetWidth-i;if(e.safariTextNodeBug){this.div.innerHTML=this.styleChar+g}else{this.text.nodeValue=this.styleChar+g}var k=Math.floor((this.div.offsetWidth-i)/f+0.5);if(k===m){if(e.safariTextNodeBug){this.div.innerHTML=this.versionChar+g}else{this.text.nodeValue=this.versionChar+g}h.version=Math.floor((this.div.offsetWidth-i)/f+1.5)/2}this.div.style.fontSize=l;return(k===m)},getComparisonWidths:function(j,h){if(e.FONTDATA&&e.FONTDATA.hasStyleChar&&!h){j+=this.styleChar+" "+this.compChar}if(e.safariTextNodeBug){this.div.innerHTML=j}else{this.text.nodeValue=j}this.div.style.fontFamily=this.comparisonFont[0];var g=this.div.offsetWidth,l=-1;if(e.safariWebFontSerif){this.div.style.fontFamily=e.safariWebFontSerif[0];l=this.div.offsetWidth}for(var k=1,f=this.comparisonFont.length;k<f;k++){this.div.style.fontFamily=this.comparisonFont[k];if(this.div.offsetWidth!=g){return[g,this.div.offsetWidth,k,l]}}return null},loadWebFont:function(g){d.Startup.signal.Post("HTML-CSS Jax - Web-Font "+e.fontInUse+"/"+g.directory);var i=MathJax.Message.File("Web-Font "+e.fontInUse+"/"+g.directory);var f=MathJax.Callback({});var h=MathJax.Callback(["loadComplete",this,g,i,f]);c.timer.start(c,[this.checkWebFont,g,h],1,this.timeout);return f},loadComplete:function(h,j,g,f){MathJax.Message.Clear(j);if(f===c.STATUS.OK){g();return}this.loadError(h);if(d.Browser.isFirefox&&e.allowWebFonts){var i=document.location.protocol+"//"+document.location.hostname;if(document.location.port!=""){i+=":"+document.location.port}i+="/";if(c.fileURL(e.webfontDir).substr(0,i.length)!==i){this.firefoxFontError(h)}}e.loadWebFontError(h,g)},loadError:function(f){MathJax.Message.Set("Can't load web font "+e.fontInUse+"/"+f.directory,null,2000)},firefoxFontError:function(f){MathJax.Message.Set("Firefox can't load web fonts from a remote host",null,3000)},checkWebFont:function(f,g,h){if(f.time(h)){return}if(e.Font.testFont(g)){h(f.STATUS.OK)}else{setTimeout(f,f.delay)}},fontFace:function(h){var i=e.allowWebFonts;var k=e.FONTDATA.FONTS[h];if(e.msieFontCSSBug&&!k.family.match(/-Web$/)){k.family+="-Web"}var g=c.fileURL(e.webfontDir+"/"+i);var f=h.replace(/-b/,"-B").replace(/-i/,"-I").replace(/-Bold-/,"-Bold");if(!f.match(/-/)){f+="-Regular"}if(i==="svg"){f+=".svg#"+f}else{f+="."+i}var j={"font-family":k.family,src:"url('"+g+"/"+f+"')"};if(i==="svg"){j.src+=" format('svg')"}if(!(e.FontFaceBug&&k.isWebFont)){if(h.match(/-bold/)){j["font-weight"]="bold"}if(h.match(/-italic/)){j["font-style"]="italic"}}return j}});e.Augment({config:{styles:{".MathJax":{display:"inline","font-family":"serif","font-style":"normal","font-weight":"normal","line-height":"normal","font-size":"100%","font-size-adjust":"none","text-indent":0,"text-align":"left","text-transform":"none","letter-spacing":"normal","word-spacing":"normal","word-wrap":"normal","white-space":"nowrap","float":"none",direction:"ltr",border:0,padding:0,margin:0},".MathJax_Display":{position:"relative",display:"block",width:"100%"},".MathJax img, .MathJax nobr, .MathJax a":{border:0,padding:0,margin:0,"max-width":"none","max-height":"none","vertical-align":0,"line-height":"normal","text-decoration":"none"},"img.MathJax_strut":{border:"0 !important",padding:"0 !important",margin:"0 !important","vertical-align":"0 !important"},".MathJax span":{display:"inline",position:"static",border:0,padding:0,margin:0,"vertical-align":0,"line-height":"normal","text-decoration":"none"},".MathJax nobr":{"white-space":"nowrap"},".MathJax img":{display:"inline ! important"},".MathJax_Processing":{visibility:"hidden",position:"fixed",width:0,height:0,overflow:"hidden"},".MathJax .MathJax_HitBox":{cursor:"text"},"#MathJax_Tooltip":{position:"absolute",left:0,top:0,width:"auto",height:"auto",display:"none"},"#MathJax_Tooltip *":{filter:"none",background:"transparent"}}},settings:d.config.menuSettings,LEFTBUTTON:(d.Browser.isMSIE?1:0),MENUKEY:"altKey",Font:null,Config:function(){this.Font=b();this.SUPER(arguments).Config.call(this);var g=this.settings;if(this.adjustAvailableFonts){this.adjustAvailableFonts(this.config.availableFonts)}if(g.scale){this.config.scale=g.scale}if(g.font&&g.font!=="Auto"){if(g.font==="TeX (local)"){this.config.availableFonts=["TeX"];this.config.preferredFont="TeX";this.config.webFont="TeX"}else{if(g.font==="STIX (local)"){this.config.availableFonts=["STIX"];this.config.preferredFont="STIX";this.config.webFont="TeX"}else{if(g.font==="TeX (web)"){this.config.availableFonts=[];this.config.preferredFont="";this.config.webFont="TeX"}else{if(g.font==="TeX (image)"){this.config.availableFonts=[];this.config.preferredFont="";this.config.webFont=""}}}}}var f=this.Font.findFont(this.config.availableFonts,this.config.preferredFont);if(!f&&this.allowWebFonts){f=this.config.webFont;if(f){this.webFonts=true}}if(!f&&this.config.imageFont){f=this.config.imageFont;this.imgFonts=true}if(f){this.fontInUse=f;this.fontDir+="/"+f;this.webfontDir+="/"+f;if(!this.require){this.require=[]}this.require.push(this.fontDir+"/fontdata.js");if(this.imgFonts){this.require.push(this.directory+"/imageFonts.js");d.Startup.signal.Post("HTML-CSS Jax - using image fonts")}}else{MathJax.Message.Set("Can't find a valid font using ["+this.config.availableFonts.join(", ")+"]",null,3000);this.FONTDATA={TeX_factor:1,baselineskip:1.2,lineH:0.8,lineD:0.2,ffLineH:0.8,FONTS:{},VARIANT:{normal:{fonts:[]}},RANGES:[],DELIMITERS:{},RULECHAR:45,REMAP:{}};if(MathJax.InputJax.TeX&&MathJax.InputJax.TeX.Definitions){MathJax.InputJax.TeX.Definitions.macros.overline[1]="002D";MathJax.InputJax.TeX.Definitions.macros.underline[1]="002D"}d.Startup.signal.Post("HTML-CSS Jax - no valid font")}},Startup:function(){var h=[],l=this.FONTDATA.VARIANT.normal.fonts;if(!(l instanceof Array)){l=[l]}for(var g=0,f=l.length;g<f;g++){h[g]=this.FONTDATA.FONTS[l[g]].family;if(!h[g]){h[g]=l[g]}}this.config.styles[".MathJax .math span"]=this.config.styles["#MathJax_getScales"]={"font-family":h.join(",")};this.hiddenDiv=this.Element("div",{style:{visibility:"hidden",overflow:"hidden",position:"absolute",top:0,height:"1px",width:"auto",padding:0,border:0,margin:0,textAlign:"left",textIndent:0,textTransform:"none",lineHeight:"normal",letterSpacing:"normal",wordSpacing:"normal"}});if(!document.body.firstChild){document.body.appendChild(this.hiddenDiv)}else{document.body.insertBefore(this.hiddenDiv,document.body.firstChild)}this.hiddenDiv=this.addElement(this.hiddenDiv,"div",{id:"MathJax_Hidden"});var k=this.addElement(this.hiddenDiv,"div",{style:{width:"5in"}});this.pxPerInch=k.offsetWidth/5;this.hiddenDiv.removeChild(k);this.startMarker=e.createStrut(this.Element("span"),10,true);this.endMarker=this.addText(this.Element("span"),"x").parentNode;this.HDspan=this.Element("span");if(this.operaHeightBug){this.createStrut(this.HDspan,0)}if(this.msieInlineBlockAlignBug){this.HDimg=this.addElement(this.HDspan,"img",{style:{height:"0px",width:"1px"}});try{this.HDimg.src="about:blank"}catch(j){}}else{this.HDimg=e.createStrut(this.HDspan,0)}this.HDMspan=this.Element("span",{style:{position:"absolute","font-size-adjust":"none"}});if(this.msieInlineBlockAlignBug){this.HDMimg=this.addElement(this.HDMspan,"img",{style:{height:"0px",width:"1px","max-width":"none","max-height":"none",border:0,padding:0,margin:0}});try{this.HDMimg.src="about:blank"}catch(j){}}else{this.HDMimg=e.createStrut(this.HDMspan,0);this.HDMimg.style.marginRight=""}this.marginCheck=e.Element("span",null,[["span",{style:{display:"inline-block",width:"5em"}}]]);this.marginMove=e.addElement(this.marginCheck,"span",{style:{display:"inline-block",width:"5em",marginLeft:"-5em"}});return c.Styles(this.config.styles,["PreloadWebFonts",this])},PreloadWebFonts:function(){if(!e.allowWebFonts||!e.config.preloadWebFonts){return}for(var g=0,f=e.config.preloadWebFonts.length;g<f;g++){var h=e.FONTDATA.FONTS[e.config.preloadWebFonts[g]];if(!h.available){e.Font.testFont(h)}}},Translate:function(l){if(!l.parentNode){return}var j=l.previousSibling;if(j&&String(j.className).match(/^MathJax(_MathML|_Display)?$/)){j.parentNode.removeChild(j)}var m=l.MathJax.elementJax.root,n,f,h;n=f=h=this.Element("span",{className:"MathJax",oncontextmenu:this.ContextMenu,onmousedown:this.Mousedown,onmouseover:this.Mouseover,onclick:this.Click,ondblclick:this.DblClick});var i=(m.Get("display")==="block");if(i){f=h=this.Element("div",{className:"MathJax_Display",style:{width:"100%",position:"relative"}});f.appendChild(n)}f.setAttribute("role","textbox");f.setAttribute("aria-readonly","true");if(this.useProcessingFrame){h=this.Element((i?"div":"span"),{className:"MathJax_Processing"});h.appendChild(f)}l.parentNode.insertBefore(h,l);var g;try{this.getScales(n);g=(this.em===0||String(this.em)==="NaN")}catch(k){g=true}if(g){this.hiddenDiv.appendChild(h);this.getScales(n)}this.initImg(n);this.initHTML(m,n);m.setTeXclass();try{m.toHTML(n,f)}catch(k){if(k.restart){h.parentNode.removeChild(h)}throw k}if(g){l.parentNode.insertBefore(h,l)}if(this.useProcessingFrame){h.parentNode.replaceChild(f,h)}},ContextMenu:function(i,j){if(e.config.showMathMenu&&(e.settings.context==="MathJax"||j)){if(e.safariContextMenuBug){setTimeout("window.getSelection().empty()",0)}if(!i||e.msieEventBug){i=window.event}var f=MathJax.Menu;if(f){var h=(this.parentNode.className==="MathJax_Display"?this.parentNode:this);f.jax=d.getJaxFor(h.nextSibling);f.menu.items[1].menu.items[1].name=(f.jax.inputJax.id==="MathML"?"Original":f.jax.inputJax.id);return f.menu.Post(i)}else{if(!c.loadingMathMenu){c.loadingMathMenu=true;var g={pageX:i.pageX,pageY:i.pageY,clientX:i.clientX,clientY:i.clientY};MathJax.Callback.Queue(c.Require("[MathJax]/extensions/MathMenu.js"),function(){delete c.loadingMathMenu},[this,arguments.callee,g,j])}if(!i){i=window.event}if(i.preventDefault){i.preventDefault()}if(i.stopPropagation){i.stopPropagation()}i.cancelBubble=true;i.returnValue=false;return false}}},Mousedown:function(f){if(e.config.showMathMenu){if(!f){f=window.event}if(e.settings.context==="MathJax"){if(!e.noContextMenuBug||f.button!==2){return}}else{if(!f[e.MENUKEY]||f.button!==e.LEFTBUTTON){return}}return e.ContextMenu.call(this,f,true)}},Mouseover:function(f){e.HandleEvent(f,"Mouseover",this)},Click:function(f){e.HandleEvent(f,"Click",this)},DblClick:function(f){e.HandleEvent(f,"DblClick",this)},HandleEvent:function(h,f,g){},initImg:function(f){},initHTML:function(g,f){},initFont:function(f){var h=e.FONTDATA.FONTS,g=e.config.availableFonts;if(g&&g.length&&e.Font.testFont(h[f])){h[f].available=true;return null}if(!this.allowWebFonts){return null}h[f].isWebFont=true;if(e.FontFaceBug){h[f].family=f;if(e.msieFontCSSBug){h[f].family+="-Web"}}return c.Styles({"@font-face":this.Font.fontFace(f)})},Remove:function(f){var g=f.SourceElement();if(!g){return}g=g.previousSibling;if(!g){return}if(g.className.match(/^MathJax/)){g.parentNode.removeChild(g)}},getScales:function(h){h.parentNode.insertBefore(this.HDMspan,h);this.HDMspan.className="";this.HDMspan.id="";this.HDMspan.style.fontSize="";this.HDMimg.style.height="1px";this.HDMimg.style.width="60ex";var g=this.HDMspan.offsetWidth/60;this.HDMspan.className="MathJax";this.HDMspan.id="MathJax_getScales";this.HDMimg.style.width="60em";var f=this.outerEm=this.HDMspan.offsetWidth/60;this.scale=Math.floor(Math.max(this.config.minScaleAdjust/100,(g/this.TeX.x_height)/f)*this.config.scale);h.style.fontSize=this.HDMspan.style.fontSize=this.scale+"%";this.em=a.mbase.prototype.em=this.HDMspan.offsetWidth/60;if(this.operaFontSizeBug&&f===this.em&&this.scale!==100){this.em=a.mbase.prototype.em=f*this.scale/100}h.parentNode.removeChild(this.HDMspan);this.msieMarginScale=this.getMarginScale(h)},getMarginScale:function(f){return 1},getMSIEmarginScale:function(h){h.appendChild(this.marginCheck);var f=this.marginCheck.offsetWidth,g=this.marginMove.offsetWidth;var i=(2*g-f?g/(2*g-f):1);h.removeChild(this.marginCheck);return i},getHD:function(g){var f=g.style.position;g.style.position="absolute";this.HDimg.style.height="0px";g.appendChild(this.HDspan);var h={h:g.offsetHeight};this.HDimg.style.height=h.h+"px";h.d=g.offsetHeight-h.h;h.h-=h.d;h.h/=this.em;h.d/=this.em;g.removeChild(this.HDspan);g.style.position=f;return h},getW:function(i){var g=i.offsetWidth,h=(i.bbox?i.bbox.w:-1),j=i;if((h<0||this.negativeSkipBug)&&g>=0){if(this.negativeSkipBug){var f=i.style.position;i.style.position="absolute";j=this.startMarker;if(i.firstChild){i.insertBefore(j,i.firstChild)}else{i.appendChild(j)}j=this.startMarker}i.appendChild(this.endMarker);g=this.endMarker.offsetLeft-j.offsetLeft;i.removeChild(this.endMarker);if(this.negativeSkipBug){i.removeChild(j);i.style.position=f}}return g/this.em},Measured:function(h,g){if(h.bbox.width==null&&h.bbox.w&&!h.bbox.isMultiline){var f=this.getW(h);h.bbox.rw+=f-h.bbox.w;h.bbox.w=f}if(!g){g=h.parentNode}if(!g.bbox){g.bbox=h.bbox}return h},Remeasured:function(g,f){f.bbox=this.Measured(g,f).bbox},Em:function(f){if(Math.abs(f)<0.0006){return"0em"}return f.toFixed(3).replace(/\.?0+$/,"")+"em"},Percent:function(f){return(100*f).toFixed(1).replace(/\.?0+$/,"")+"%"},length2percent:function(f){return this.Percent(this.length2em(f))},length2em:function(k,i){if(typeof(k)!=="string"){k=k.toString()}if(k===""){return""}if(k===a.SIZE.NORMAL){return 1}if(k===a.SIZE.BIG){return 2}if(k===a.SIZE.SMALL){return 0.71}if(k==="infinity"){return e.BIGDIMEN}var h=this.FONTDATA.TeX_factor;if(k.match(/mathspace$/)){return e.MATHSPACE[k]*h}var g=k.match(/^\s*([-+]?(?:\.\d+|\d+(?:\.\d*)?))?(pt|em|ex|mu|px|pc|in|mm|cm|%)?/);var f=parseFloat(g[1]||"1"),j=g[2];if(i==null){i=1}if(j==="em"){return f*h}if(j==="ex"){return f*e.TeX.x_height*h}if(j==="%"){return f/100*i}if(j==="px"){return f/e.em}if(j==="pt"){return f/10*h}if(j==="pc"){return f*1.2*h}if(j==="in"){return f*this.pxPerInch/e.em}if(j==="cm"){return f*this.pxPerInch/e.em/2.54}if(j==="mm"){return f*this.pxPerInch/e.em/25.4}if(j==="mu"){return f/18*h}return f*h*i},thickness2em:function(f){var g=e.TeX.rule_thickness;if(f===a.LINETHICKNESS.MEDIUM){return g}if(f===a.LINETHICKNESS.THIN){return 0.67*g}if(f===a.LINETHICKNESS.THICK){return 1.67*g}return this.length2em(f,g)},createStrut:function(i,g,j){var f=this.Element("span",{style:{display:"inline-block",overflow:"hidden",height:g+"px",width:"1px",marginRight:"-1px"}});if(j){i.insertBefore(f,i.firstChild)}else{i.appendChild(f)}return f},createBlank:function(g,f,h){var i=this.Element("span",{style:{display:"inline-block",overflow:"hidden",height:"1px",width:this.Em(f)}});if(h){g.insertBefore(i,g.firstChild)}else{g.appendChild(i)}return i},createShift:function(g,f,i){var h=this.Element("span",{style:{marginLeft:this.Em(f)}});if(i){g.insertBefore(h,g.firstChild)}else{g.appendChild(h)}return h},createSpace:function(k,j,m,f,g){var i=this.Em(Math.max(0,j+m)),l=this.Em(-m);if(this.msieInlineBlockAlignBug){l=this.Em(e.getHD(k.parentNode).d-m)}if(k.isBox||k.className=="mspace"){k.bbox={h:j*k.scale,d:m*k.scale,w:f*k.scale,rw:f*k.scale,lw:0};k.style.height=i;k.style.verticalAlign=l}else{k=this.addElement(k,"span",{style:{height:i,verticalAlign:l}})}if(f>=0){k.style.width=this.Em(f);k.style.display="inline-block"}else{if(this.msieNegativeSpaceBug){k.style.height=""}k.style.marginLeft=this.Em(f);if(e.safariNegativeSpaceBug&&k.parentNode.firstChild==k){this.createBlank(k,0,true)}}if(g&&g!==a.COLOR.TRANSPARENT){k.style.backgroundColor=g}return k},createRule:function(o,k,m,p,i){var j=e.TeX.min_rule_thickness;if(p>0&&p*this.em<j){p=j/this.em}if(k+m>0&&(k+m)*this.em<j){var l=1/(k+m)*(j/this.em);k*=l;m*=l}if(!i){i="solid"}else{i="solid "+i}i=this.Em(p)+" "+i;var q=this.Em(k+m),g=this.Em(-m);var n=this.addElement(o,"span",{style:{borderLeft:i,display:"inline-block",overflow:"hidden",width:0,height:q,verticalAlign:g},bbox:{h:k,d:m,w:p,rw:p,lw:0},noAdjust:true});if(p>0&&n.offsetWidth==0){n.style.width=this.Em(p)}if(o.isBox||o.className=="mspace"){o.bbox=n.bbox}return n},createFrame:function(o,m,n,p,r,g){var l=(this.msieBorderWidthBug?0:2*r);var q=this.Em(m+n-l),f=this.Em(-n-r),k=this.Em(p-l);var i=this.Em(r)+" "+g;var j=this.addElement(o,"span",{style:{border:i,display:"inline-block",overflow:"hidden",width:k,height:q},bbox:{h:m,d:n,w:p,rw:p,lw:0},noAdjust:true});if(f){j.style.verticalAlign=f}return j},createStack:function(h,j,g){if(this.msiePaddingWidthBug){this.createStrut(h,0)}var i=String(g).match(/%$/);var f=(!i&&g!=null?g:0);h=this.addElement(h,"span",{noAdjust:true,style:{display:"inline-block",position:"relative",width:(i?"100%":this.Em(f)),height:0}});if(!j){h.parentNode.bbox=h.bbox={h:-this.BIGDIMEN,d:-this.BIGDIMEN,w:f,lw:this.BIGDIMEN,rw:(!i&&g!=null?g:-this.BIGDIMEN)};if(i){h.bbox.width=g}}return h},createBox:function(g,f){var h=this.addElement(g,"span",{style:{position:"absolute"},isBox:true});if(f!=null){h.style.width=f}return h},addBox:function(f,g){g.style.position="absolute";g.isBox=true;return f.appendChild(g)},placeBox:function(n,m,k,i){var o=n.parentNode,v=n.bbox,q=o.bbox;if(this.msiePlaceBoxBug){this.addText(n,this.NBSP)}if(this.imgSpaceBug){this.addText(n,this.imgSpace)}var p=n.offsetHeight/this.em+1,z=0;if(n.noAdjust){p-=1}else{if(this.msieInlineBlockAlignBug){this.addElement(n,"img",{className:"MathJax_strut",border:0,src:"about:blank",style:{width:0,height:this.Em(p)}})}else{this.addElement(n,"span",{style:{display:"inline-block",width:0,height:this.Em(p)}})}}n.style.top=this.Em(-k-p);n.style.left=this.Em(m+z);if(v){if(this.negativeSkipBug){if(v.lw<0){z=v.lw;e.createBlank(n,-z,true);h=0}if(v.rw>v.w){e.createBlank(n,v.rw-v.w+0.1)}}if(!this.msieClipRectBug&&!v.noclip&&!i){var u=3/this.em;var s=(v.H==null?v.h:v.H),g=(v.D==null?v.d:v.D);var w=p-s-u,j=p+g+u,h=v.lw-3*u,f=1000;if(v.isFixed){f=v.width-h}n.style.clip="rect("+this.Em(w)+" "+this.Em(f)+" "+this.Em(j)+" "+this.Em(h)+")"}}if(v&&q){if(v.H!=null&&(q.H==null||v.H+k>q.H)){q.H=v.H+k}if(v.D!=null&&(q.D==null||v.D-k>q.D)){q.D=v.D-k}if(v.h+k>q.h){q.h=v.h+k}if(v.d-k>q.d){q.d=v.d-k}if(q.H!=null&&q.H<=q.h){delete q.H}if(q.D!=null&&q.D<=q.d){delete q.D}if(v.w+m>q.w){q.w=v.w+m;if(q.width==null){o.style.width=this.Em(q.w)}}if(v.rw+m>q.rw){q.rw=v.rw+m}if(v.lw+m<q.lw){q.lw=v.lw+m}if(v.width!=null&&!v.isFixed){if(q.width==null){o.style.width=q.width="100%"}n.style.width=v.width}}},alignBox:function(h,n,m){this.placeBox(h,0,m);var j=h.bbox;if(j.isMultiline){return}var g=j.width!=null&&!j.isFixed;var i=0,k=-j.w/2,f="50%";if(this.negativeSkipBug){i=j.w-j.rw-0.1;k+=j.lw}k=this.Em(k*this.msieMarginScale);if(g){k="";f=(50-parseFloat(j.width)/2)+"%"}d.Insert(h.style,({right:{left:"",right:this.Em(i)},center:{left:f,marginLeft:k}})[n])},setStackWidth:function(g,f){if(typeof(f)==="number"){g.style.width=this.Em(Math.max(0,f));if(g.bbox){g.bbox.w=f}if(g.parentNode.bbox){g.parentNode.bbox.w=f}}else{g.style.width=g.parentNode.style.width="100%";if(g.bbox){g.bbox.width=f}if(g.parentNode.bbox){g.parentNode.bbox.width=f}}},createDelimiter:function(q,f,h,l,j){if(!f){q.bbox={h:0,d:0,w:this.TeX.nulldelimiterspace,lw:0};q.bbox.rw=q.bbox.w;this.createSpace(q,q.bbox.h,q.bbox.d,q.bbox.w);return}if(!l){l=1}if(!(h instanceof Array)){h=[h,h]}var p=h[1];h=h[0];var g={alias:f};while(g.alias){f=g.alias;g=this.FONTDATA.DELIMITERS[f];if(!g){g={HW:[0,this.FONTDATA.VARIANT[a.VARIANT.NORMAL]]}}}for(var o=0,k=g.HW.length;o<k;o++){if(g.HW[o][0]*l>=h-0.01||(o==k-1&&!g.stretch)){if(g.HW[o][2]){l*=g.HW[o][2]}if(g.HW[o][3]){f=g.HW[o][3]}var n=this.addElement(q,"span");this.createChar(n,[f,g.HW[o][1]],l,j);q.bbox=n.bbox;q.offset=0.65*q.bbox.w;q.scale=l;return}}if(g.stretch){this["extendDelimiter"+g.dir](q,p,g.stretch,l,j)}},extendDelimiterV:function(v,p,A,B,s){var i=this.createStack(v,true);var r=this.createBox(i),q=this.createBox(i);this.createChar(r,(A.top||A.ext),B,s);this.createChar(q,(A.bot||A.ext),B,s);var g={bbox:{w:0,lw:0,rw:0}},z=g,j;var w=r.bbox.h+r.bbox.d+q.bbox.h+q.bbox.d;var m=-r.bbox.h;this.placeBox(r,0,m,true);m-=r.bbox.d;if(A.mid){z=this.createBox(i);this.createChar(z,A.mid,B,s);w+=z.bbox.h+z.bbox.d}if(p>w){g=this.Element("span");this.createChar(g,A.ext,B,s);var x=g.bbox.h+g.bbox.d,f=x-0.05,t,l,u=(A.mid?2:1);l=t=Math.ceil((p-w)/(u*f));if(!A.fullExtenders){f=(p-w)/(u*t)}var o=(t/(t+1))*(x-f);f=x-o;m+=o+f-g.bbox.h;while(u-->0){while(t-->0){if(!this.msieCloneNodeBug){j=g.cloneNode(true)}else{j=this.Element("span");this.createChar(j,A.ext,B,s)}m-=f;this.placeBox(this.addBox(i,j),0,m,true)}m+=o-g.bbox.d;if(A.mid&&u){this.placeBox(z,0,m-z.bbox.h,true);t=l;m+=-(z.bbox.h+z.bbox.d)+o+f-g.bbox.h}}}else{m+=(w-p)/2;if(A.mid){this.placeBox(z,0,m-z.bbox.h,true);m+=-(z.bbox.h+z.bbox.d)}m+=(w-p)/2}this.placeBox(q,0,m-q.bbox.h,true);m-=q.bbox.h+q.bbox.d;v.bbox={w:Math.max(r.bbox.w,g.bbox.w,q.bbox.w,z.bbox.w),lw:Math.min(r.bbox.lw,g.bbox.lw,q.bbox.lw,z.bbox.lw),rw:Math.max(r.bbox.rw,g.bbox.rw,q.bbox.rw,z.bbox.rw),h:0,d:-m};v.scale=B;v.offset=0.55*v.bbox.w;v.isMultiChar=true;this.setStackWidth(i,v.bbox.w)},extendDelimiterH:function(u,h,z,B,r){var l=this.createStack(u,true);var i=this.createBox(l),v=this.createBox(l);this.createChar(i,(z.left||z.rep),B,r);this.createChar(v,(z.right||z.rep),B,r);var f=this.Element("span");this.createChar(f,z.rep,B,r);var y={bbox:{h:-this.BIGDIMEN,d:-this.BIGDIMEN}},g;this.placeBox(i,-i.bbox.lw,0,true);var p=(i.bbox.rw-i.bbox.lw)+(v.bbox.rw-v.bbox.lw)-0.05,o=i.bbox.rw-i.bbox.lw-0.025,q;if(z.mid){y=this.createBox(l);this.createChar(y,z.mid,B,r);p+=y.bbox.w}if(h>p){var A=f.bbox.rw-f.bbox.lw,j=A-0.05,s,m,t=(z.mid?2:1);m=s=Math.ceil((h-p)/(t*j));j=(h-p)/(t*s);q=(s/(s+1))*(A-j);j=A-q;o-=f.bbox.lw+q;while(t-->0){while(s-->0){if(!this.msieCloneNodeBug){g=f.cloneNode(true)}else{g=this.Element("span");this.createChar(g,z.rep,B,r)}this.placeBox(this.addBox(l,g),o,0,true);o+=j}if(z.mid&&t){this.placeBox(y,o,0,true);o+=y.bbox.w-q;s=m}}}else{q=Math.min(p-h,i.bbox.w/2);o-=q/2;if(z.mid){this.placeBox(y,o,0,true);o+=y.bbox.w}o-=q/2}this.placeBox(v,o,0,true);u.bbox={w:o+v.bbox.rw,lw:0,rw:o+v.bbox.rw,H:Math.max(i.bbox.h,f.bbox.h,v.bbox.h,y.bbox.h),D:Math.max(i.bbox.d,f.bbox.d,v.bbox.d,y.bbox.d),h:f.bbox.h,d:f.bbox.d};u.scale=B;u.isMultiChar=true;this.setStackWidth(l,u.bbox.w)},createChar:function(o,k,h,f){var n=o,p="",j={fonts:[k[1]],noRemap:true};if(f&&f===a.VARIANT.BOLD){j.fonts=[k[1]+"-bold",k[1]]}if(typeof(k[1])!=="string"){j=k[1]}if(k[0] instanceof Array){for(var l=0,g=k[0].length;l<g;l++){p+=String.fromCharCode(k[0][l])}}else{p=String.fromCharCode(k[0])}if(h!==1){n=this.addElement(o,"span",{style:{fontSize:this.Percent(h)},scale:h});this.handleVariant(n,j,p);o.bbox=n.bbox}else{this.handleVariant(o,j,p)}if(k[2]){o.style.marginLeft=this.Em(k[2])}if(this.AccentBug&&o.bbox.w===0){n.firstChild.nodeValue+=this.NBSP;e.createSpace(o,0,0,-o.offsetWidth/e.em)}},positionDelimiter:function(g,f){f-=g.bbox.h;g.bbox.d-=f;g.bbox.h+=f;if(f){if(this.safariVerticalAlignBug||this.msieVerticalAlignBug||this.konquerorVerticalAlignBug||(this.operaVerticalAlignBug&&g.isMultiChar)){if(g.firstChild.style.display===""&&g.style.top!==""){g=g.firstChild;f-=parseFloat(g.style.top)}g.style.position="relative";g.style.top=this.Em(-f)}else{g.style.verticalAlign=this.Em(f);if(e.ffVerticalAlignBug){e.createRule(g.parentNode,g.bbox.h,0,0)}}}},handleVariant:function(v,j,o){var u="",s,y,p,g,x,z,f=v;if(o.length===0){return}if(!v.bbox){v.bbox={w:0,h:-this.BIGDIMEN,d:-this.BIGDIMEN,rw:-this.BIGDIMEN,lw:this.BIGDIMEN}}if(!j){j=this.FONTDATA.VARIANT[a.VARIANT.NORMAL]}z=j;for(var w=0,t=o.length;w<t;w++){j=z;s=o.charCodeAt(w);y=o.charAt(w);if(y===this.PLANE1){w++;s=o.charCodeAt(w)+119808-56320;if(this.FONTDATA.RemapPlane1){var A=this.FONTDATA.RemapPlane1(s,j);s=A.n;j=A.variant}}else{var q,l,r=this.FONTDATA.RANGES;for(q=0,l=r.length;q<l;q++){if(r[q].name==="alpha"&&j.noLowerCase){continue}var k=j["offset"+r[q].offset];if(k&&s>=r[q].low&&s<=r[q].high){if(r[q].remap&&r[q].remap[s]){s=k+r[q].remap[s]}else{s=s-r[q].low+k;if(r[q].add){s+=r[q].add}}if(j["variant"+r[q].offset]){j=this.FONTDATA.VARIANT[j["variant"+r[q].offset]]}break}}}if(j.remap&&j.remap[s]){if(j.remap[s] instanceof Array){var h=j.remap[s];s=h[0];j=this.FONTDATA.VARIANT[h[1]]}else{s=j.remap[s];if(j.remap.variant){j=this.FONTDATA.VARIANT[j.remap.variant]}}}if(this.FONTDATA.REMAP[s]&&!j.noRemap){s=this.FONTDATA.REMAP[s]}p=this.lookupChar(j,s);y=p[s];if(j!==x&&!y[5].img){if(u.length){this.addText(f,u);u=""}f=v;x=g;if(j!==x){if(x){f=this.addElement(v,"span")}else{g=j}}this.handleFont(f,p,f!==v);x=j}u=this.handleChar(f,p,y,s,u);if(y[0]/1000>v.bbox.h){v.bbox.h=y[0]/1000}if(y[1]/1000>v.bbox.d){v.bbox.d=y[1]/1000}if(v.bbox.w+y[3]/1000<v.bbox.lw){v.bbox.lw=v.bbox.w+y[3]/1000}if(v.bbox.w+y[4]/1000>v.bbox.rw){v.bbox.rw=v.bbox.w+y[4]/1000}v.bbox.w+=y[2]/1000}if(u.length){this.addText(f,u)}if(v.scale&&v.scale!==1){v.bbox.h*=v.scale;v.bbox.d*=v.scale;v.bbox.w*=v.scale;v.bbox.lw*=v.scale;v.bbox.rw*=v.scale}if(o.length==1&&p.skew&&p.skew[s]){v.bbox.skew=p.skew[s]}},handleFont:function(h,f,j){h.style.fontFamily=f.family;if(!(e.FontFaceBug&&f.isWebFont)){var g=f.style||"normal",i=f.weight||"normal";if(g!=="normal"||j){h.style.fontStyle=g}if(i!=="normal"||j){h.style.fontWeight=i}}},handleChar:function(g,f,l,k,j){var i=l[5];if(i.img){return this.handleImg(g,f,l,k,j)}if(i.isUnknown&&this.FONTDATA.DELIMITERS[k]){if(j.length){this.addText(g,j)}var h=g.scale;e.createDelimiter(g,k,0,1,f);g.scale=h;l[0]=g.bbox.h*1000;l[1]=g.bbox.d*1000;l[2]=g.bbox.w*1000;l[3]=g.bbox.lw*1000;l[4]=g.bbox.rw*1000;return""}if(i.c==null){if(k<=65535){i.c=String.fromCharCode(k)}else{i.c=this.PLANE1+String.fromCharCode(k-119808+56320)}}if(l[2]||!this.msieAccentBug||j.length){return j+i.c}e.createShift(g,l[3]/1000);e.createShift(g,(l[4]-l[3])/1000);this.addText(g,i.c);e.createShift(g,-l[4]/1000);return""},handleImg:function(g,f,j,i,h){return h},lookupChar:function(j,p){var h,f;if(!j.FONTS){var o=this.FONTDATA.FONTS;var l=(j.fonts||this.FONTDATA.VARIANT.normal.fonts);if(!(l instanceof Array)){l=[l]}if(j.fonts!=l){j.fonts=l}j.FONTS=[];for(h=0,f=l.length;h<f;h++){if(o[l[h]]){j.FONTS.push(o[l[h]]);o[l[h]].name=l[h]}}}for(h=0,f=j.FONTS.length;h<f;h++){var g=j.FONTS[h];if(typeof(g)==="string"){delete j.FONTS;this.loadFont(g)}if(g[p]){if(g[p].length===5){g[p][5]={}}if(e.allowWebFonts&&!g.available){this.loadWebFont(g)}else{return g}}else{this.findBlock(g,p)}}var k=(j.defaultFont||{family:e.config.undefinedFamily});if(j.bold){k.weight="bold"}if(j.italic){k.style="italic"}k[p]=[800,200,500,0,500,{isUnknown:true}];return k},findBlock:function(g,n){if(g.Ranges){for(var l=0,f=g.Ranges.length;l<f;l++){if(n<g.Ranges[l][0]){return}if(n<=g.Ranges[l][1]){var k=g.Ranges[l][2];for(var h=g.Ranges.length-1;h>=0;h--){if(g.Ranges[h][2]==k){g.Ranges.splice(h,1)}}this.loadFont(g.directory+"/"+k+".js")}}}},loadFont:function(g){var f=MathJax.Callback.Queue();f.Push(["Require",c,this.fontDir+"/"+g]);if(this.imgFonts){if(!MathJax.isPacked){g=g.replace(/\/([^\/]*)$/,e.imgPacked+"/$1")}f.Push(["Require",c,this.webfontDir+"/png/"+g])}d.RestartAfter(f.Push({}))},loadWebFont:function(f){f.available=f.isWebFont=true;if(e.FontFaceBug){f.family=f.name;if(e.msieFontCSSBug){f.family+="-Web"}}d.RestartAfter(this.Font.loadWebFont(f))},loadWebFontError:function(g,f){d.Startup.signal.Post("HTML-CSS Jax - disable web fonts");g.isWebFont=false;if(this.config.imageFont&&this.config.imageFont===this.fontInUse){this.imgFonts=true;d.Startup.signal.Post("HTML-CSS Jax - switch to image fonts");d.Startup.signal.Post("HTML-CSS Jax - using image fonts");MathJax.Message.Set("Web-Fonts not available -- using image fonts instead",null,3000);c.Require(this.directory+"/imageFonts.js",f)}else{this.allowWebFonts=false;f()}},Element:MathJax.HTML.Element,addElement:MathJax.HTML.addElement,TextNode:MathJax.HTML.TextNode,addText:MathJax.HTML.addText,ucMatch:MathJax.HTML.ucMatch,BIGDIMEN:10000000,ID:0,idPostfix:"",GetID:function(){this.ID++;return this.ID},MATHSPACE:{veryverythinmathspace:1/18,verythinmathspace:2/18,thinmathspace:3/18,mediummathspace:4/18,thickmathspace:5/18,verythickmathspace:6/18,veryverythickmathspace:7/18,negativeveryverythinmathspace:-1/18,negativeverythinmathspace:-2/18,negativethinmathspace:-3/18,negativemediummathspace:-4/18,negativethickmathspace:-5/18,negativeverythickmathspace:-6/18,negativeveryverythickmathspace:-7/18},TeX:{x_height:0.430554,quad:1,num1:0.676508,num2:0.393732,num3:0.44373,denom1:0.685951,denom2:0.344841,sup1:0.412892,sup2:0.362892,sup3:0.288888,sub1:0.15,sub2:0.247217,sup_drop:0.386108,sub_drop:0.05,delim1:2.39,delim2:1,axis_height:0.25,rule_thickness:0.06,big_op_spacing1:0.111111,big_op_spacing2:0.166666,big_op_spacing3:0.2,big_op_spacing4:0.6,big_op_spacing5:0.1,scriptspace:0.1,nulldelimiterspace:0.12,delimiterfactor:901,delimitershortfall:0.1,min_rule_thickness:1.25},PLANE1:String.fromCharCode(55349),NBSP:String.fromCharCode(160),rfuzz:0});MathJax.Hub.Register.StartupHook("mml Jax Ready",function(){a=MathJax.ElementJax.mml;a.mbase.Augment({toHTML:function(l){var j=this.HTMLlineBreaks();if(j.length>2){return this.toHTMLmultiline(l,j)}l=this.HTMLcreateSpan(l);if(this.type!="mrow"){l=this.HTMLhandleSize(l)}for(var g=0,f=this.data.length;g<f;g++){if(this.data[g]){this.data[g].toHTML(l)}}var o=this.HTMLcomputeBBox(l);var k=l.bbox.h,n=l.bbox.d;for(g=0,f=o.length;g<f;g++){o[g].HTMLstretchV(l,k,n)}if(o.length){this.HTMLcomputeBBox(l,true)}this.HTMLhandleSpace(l);this.HTMLhandleColor(l);return l},HTMLlineBreaks:function(){var k=[[0,this]];for(var h=0,f=this.data.length;h<f;h++){if(this.data[h]){var l=this.data[h].lineBreak();if(l!=="none"){var g=(l==="after"?h+1:h);if(k.length===0||k[k.length-1]!==g){k.push([g,this.data[h]])}else{k[k.length-1]=[g,this.data[h]]}}}}k.push([this.data.length,k[k.length-1][1]]);return k},toHTMLmultiline:function(f){a.mbase.HTMLautoloadFile("multiline")},HTMLcomputeBBox:function(l,k,j,f){if(j==null){j=0}if(f==null){f=this.data.length}var h=l.bbox={},n=[];while(j<f){var g=this.data[j];if(!g){continue}if(!k&&g.HTMLcanStretch("Vertical")){n.push(g);g=(g.CoreMO()||g)}this.HTMLcombineBBoxes(g,h);j++}this.HTMLcleanBBox(h);return n},HTMLcombineBBoxes:function(f,g){if(g.w==null){this.HTMLemptyBBox(g)}var i=f.HTMLspanElement();if(!i||!i.bbox){return}var h=i.bbox;if(h.d>g.d){g.d=h.d}if(h.h>g.h){g.h=h.h}if(h.D!=null&&h.D>g.D){g.D=h.D}if(h.H!=null&&h.H>g.H){g.H=h.H}if(i.style.paddingLeft){g.w+=parseFloat(i.style.paddingLeft)*(i.scale||1)}if(g.w+h.lw<g.lw){g.lw=g.w+h.lw}if(g.w+h.rw>g.rw){g.rw=g.w+h.rw}g.w+=h.w;if(i.style.paddingRight){g.w+=parseFloat(i.style.paddingRight)*(i.scale||1)}if(h.width){g.width=h.width}},HTMLemptyBBox:function(f){f.h=f.d=f.H=f.D=f.rw=-e.BIGDIMEN;f.w=0;f.lw=e.BIGDIMEN;return f},HTMLcleanBBox:function(f){if(f.h===this.BIGDIMEN){f.h=f.d=f.H=f.D=f.w=f.rw=f.lw=0}if(f.D<=f.d){delete f.D}if(f.H<=f.h){delete f.H}},HTMLzeroBBox:function(){return{h:0,d:0,w:0,lw:0,rw:0}},HTMLcanStretch:function(f){if(this.isEmbellished()){return this.Core().HTMLcanStretch(f)}return false},HTMLstretchH:function(g,f){return this.HTMLspanElement()},HTMLstretchV:function(g,f,i){return this.HTMLspanElement()},HTMLnotEmpty:function(f){while(f){if((f.type!=="mrow"&&f.type!=="texatom")||f.data.length>1){return true}f=f.data[0]}return false},HTMLmeasureChild:function(g,f){if(this.data[g]!=null){e.Measured(this.data[g].toHTML(f),f)}else{f.bbox=this.HTMLzeroBBox()}},HTMLcreateSpan:function(f){if(this.spanID){var g=this.HTMLspanElement();if(g){while(g.firstChild){g.removeChild(g.firstChild)}g.bbox={w:0,h:0,d:0,lw:0,rw:0};g.scale=1;g.isMultChar=null;g.style.cssText="";return g}}if(this.href){f=e.addElement(f,"a",{href:this.href})}f=e.addElement(f,"span",{className:this.type});if(e.imgHeightBug){f.style.display="inline-block"}if(this["class"]!=null){f.className+=" "+this["class"]}if(this.style){f.style.cssText=this.style;if(f.style.fontSize){this.mathsize=f.style.fontSize;f.style.fontSize=""}}this.spanID=e.GetID();f.id=(this.id||"MathJax-Span-"+this.spanID)+e.idPostfix;f.bbox={w:0,h:0,d:0,lw:0,lr:0};if(this.href){f.parentNode.bbox=f.bbox}return f},HTMLspanElement:function(){if(!this.spanID){return null}return document.getElementById((this.id||"MathJax-Span-"+this.spanID)+e.idPostfix)},HTMLhandleVariant:function(g,f,h){e.handleVariant(g,f,h)},HTMLhandleSize:function(f){if(!f.scale){f.scale=this.HTMLgetScale();if(f.scale!==1){f.style.fontSize=e.Percent(f.scale)}}return f},HTMLhandleColor:function(k){var m=this.getValues("mathcolor","color");if(this.mathbackground){m.mathbackground=this.mathbackground}if(this.background){m.background=this.background}if(this.style&&k.style.backgroundColor){m.mathbackground=k.style.backgroundColor;k.style.backgroundColor="transparent"}if(m.color&&!this.mathcolor){m.mathcolor=m.color}if(m.background&&!this.mathbackground){m.mathbackground=m.background}if(m.mathcolor){k.style.color=m.mathcolor}if(m.mathbackground&&m.mathbackground!==a.COLOR.TRANSPARENT){var n=1/e.em,j=0,i=0;if(this.isToken){j=k.bbox.lw;i=k.bbox.rw-k.bbox.w}if(k.style.paddingLeft!==""){j+=parseFloat(k.style.paddingLeft)*(k.scale||1)}if(k.style.paddingRight!==""){i-=parseFloat(k.style.paddingRight)*(k.scale||1)}var h=Math.max(0,e.getW(k)+(e.PaddingWidthBug?0:i-j));if(e.msieCharPaddingWidthBug&&k.style.paddingLeft!==""){h+=parseFloat(k.style.paddingLeft)*(k.scale||1)}var l=k.bbox.h+k.bbox.d,f=-k.bbox.d;if(h>0){h+=2*n;j-=n}if(l>0){l+=2*n;f-=n}i=-h-j;var g=e.Element("span",{id:"MathJax-Color-"+this.spanID+e.idPostfix,style:{display:"inline-block",backgroundColor:m.mathbackground,width:e.Em(h),height:e.Em(l),verticalAlign:e.Em(f),marginLeft:e.Em(j),marginRight:e.Em(i)}});if(e.msieInlineBlockAlignBug){g.style.position="relative";g.style.width=g.style.height=0;g.style.verticalAlign=g.style.marginLeft=g.style.marginRight="";e.placeBox(e.addElement(g,"span",{noAdjust:true,style:{display:"inline-block",position:"absolute",overflow:"hidden",width:e.Em(h),height:e.Em(l),background:m.mathbackground}}),j,k.bbox.h+n)}k.parentNode.insertBefore(g,k);if(e.msieColorPositionBug){k.style.position="relative"}return g}return null},HTMLremoveColor:function(){var f=document.getElementById("MathJax-Color-"+this.spanID+e.idPostfix);if(f){f.parentNode.removeChild(f)}},HTMLhandleSpace:function(i){if(this.useMMLspacing){if(this.type!=="mo"){return}var g=this.getValues("scriptlevel","lspace","rspace");if(g.scriptlevel<=0||this.hasValue("lspace")||this.hasValue("rspace")){g.lspace=Math.max(0,e.length2em(g.lspace));g.rspace=Math.max(0,e.length2em(g.rspace));var f=this,h=this.Parent();while(h&&h.isEmbellished()&&h.Core()===f){f=h;h=h.Parent();i=f.HTMLspanElement()}if(g.lspace){i.style.paddingLeft=e.Em(g.lspace)}if(g.rspace){i.style.paddingRight=e.Em(g.rspace)}}}else{var j=this.texSpacing();if(j!==""){j=e.length2em(j)/(i.scale||1);if(i.style.paddingLeft){j+=parseFloat(i.style.paddingLeft)}i.style.paddingLeft=e.Em(j)}}},HTMLgetScale:function(){var h=1,f=this.getValues("mathsize","scriptlevel","fontsize","scriptminsize");if(this.style){var g=this.HTMLspanElement();if(g.style.fontSize!=""){f.fontsize=g.style.fontSize}}if(f.fontsize&&!this.mathsize){f.mathsize=f.fontsize}if(f.scriptlevel!==0){if(f.scriptlevel>2){f.scriptlevel=2}h=Math.pow(this.Get("scriptsizemultiplier"),f.scriptlevel);f.scriptminsize=e.length2em(f.scriptminsize);if(h<f.scriptminsize){h=f.scriptminsize}}h*=e.length2em(f.mathsize);return h},HTMLgetVariant:function(){var f=this.getValues("mathvariant","fontfamily","fontweight","fontstyle");if(this.style){var h=this.HTMLspanElement();if(h.style.fontFamily){f.fontfamily=h.style.fontFamily}if(h.style.fontWeight){f.fontweight=h.style.fontWeight}if(h.style.fontStyle){f.fontStyle=h.style.fontStyle}}var g=f.mathvariant;if(this.variantForm){g="-"+e.fontInUse+"-variant"}if(f.fontfamily&&!this.mathvariant){if(!f.fontweight&&f.mathvariant.match(/bold/)){f.fontweight="bold"}if(!f.fontstyle&&f.mathvariant.match(/italic/)){f.fontstyle="italic"}return{FONTS:[],fonts:[],noRemap:true,defaultFont:{family:f.fontfamily,style:f.fontstyle,weight:f.fontweight}}}if(f.fontweight==="bold"){g={normal:a.VARIANT.BOLD,italic:a.VARIANT.BOLDITALIC,fraktur:a.VARIANT.BOLDFRAKTUR,script:a.VARIANT.BOLDSCRIPT,"sans-serif":a.VARIANT.BOLDSANSSERIF,"sans-serif-italic":a.VARIANT.SANSSERIFBOLDITALIC}[g]||g}else{if(f.fontweight==="normal"){g={bold:a.VARIANT.normal,"bold-italic":a.VARIANT.ITALIC,"bold-fraktur":a.VARIANT.FRAKTUR,"bold-script":a.VARIANT.SCRIPT,"bold-sans-serif":a.VARIANT.SANSSERIF,"sans-serif-bold-italic":a.VARIANT.SANSSERIFITALIC}[g]||g}}if(f.fontstyle==="italic"){g={normal:a.VARIANT.ITALIC,bold:a.VARIANT.BOLDITALIC,"sans-serif":a.VARIANT.SANSSERIFITALIC,"bold-sans-serif":a.VARIANT.SANSSERIFBOLDITALIC}[g]||g}else{if(f.fontstyle==="normal"){g={italic:a.VARIANT.NORMAL,"bold-italic":a.VARIANT.BOLD,"sans-serif-italic":a.VARIANT.SANSSERIF,"sans-serif-bold-italic":a.VARIANT.BOLDSANSSERIF}[g]||g}}return e.FONTDATA.VARIANT[g]}},{HTMLautoload:function(){var f=e.autoloadDir+"/"+this.type+".js";d.RestartAfter(c.Require(f))},HTMLautoloadFile:function(f){var g=e.autoloadDir+"/"+f+".js";d.RestartAfter(c.Require(g))},HTMLstretchH:function(g,f){this.HTMLremoveColor();return this.toHTML(g,f)},HTMLstretchV:function(g,f,i){this.HTMLremoveColor();return this.toHTML(g,f,i)}});a.chars.Augment({toHTML:function(g,f){this.HTMLhandleVariant(g,f,this.data.join("").replace(/[\u2061-\u2064]/g,""))}});a.entity.Augment({toHTML:function(g,f){this.HTMLhandleVariant(g,f,this.toString().replace(/[\u2061-\u2064]/g,""))}});a.mi.Augment({toHTML:function(j){j=this.HTMLhandleSize(this.HTMLcreateSpan(j));j.bbox=null;var h=this.HTMLgetVariant();for(var g=0,f=this.data.length;g<f;g++){if(this.data[g]){this.data[g].toHTML(j,h)}}if(!j.bbox){j.bbox={w:0,h:0,d:0,rw:0,lw:0}}if(this.data.join("").length!==1){delete j.bbox.skew}this.HTMLhandleSpace(j);this.HTMLhandleColor(j);return j}});a.mn.Augment({toHTML:function(j){j=this.HTMLhandleSize(this.HTMLcreateSpan(j));j.bbox=null;var h=this.HTMLgetVariant();for(var g=0,f=this.data.length;g<f;g++){if(this.data[g]){this.data[g].toHTML(j,h)}}if(!j.bbox){j.bbox={w:0,h:0,d:0,rw:0,lw:0}}if(this.data.join("").length!==1){delete j.bbox.skew}this.HTMLhandleSpace(j);this.HTMLhandleColor(j);return j}});a.mo.Augment({toHTML:function(k){k=this.HTMLhandleSize(this.HTMLcreateSpan(k));if(this.data.length==0){return k}else{k.bbox=null}var n=this.data.join("");var j=this.HTMLgetVariant();var g=this.getValues("largeop","displaystyle");if(g.largeop){j=e.FONTDATA.VARIANT[g.displaystyle?"-largeOp":"-smallOp"]}for(var h=0,f=this.data.length;h<f;h++){if(this.data[h]){this.data[h].toHTML(k,j)}}if(!k.bbox){k.bbox={w:0,h:0,d:0,rw:0,lw:0}}if(n.length!==1){delete k.bbox.skew}if(e.AccentBug&&k.bbox.w===0&&n.length===1&&k.firstChild){k.firstChild.nodeValue+=e.NBSP;e.createSpace(k,0,0,-k.offsetWidth/e.em)}if(g.largeop){var l=(k.bbox.h-k.bbox.d)/2-e.TeX.axis_height*k.scale;if(e.safariVerticalAlignBug&&k.lastChild.nodeName==="IMG"){k.lastChild.style.verticalAlign=e.Em(parseFloat(k.lastChild.style.verticalAlign||0)/e.em-l/k.scale)}else{if(e.konquerorVerticalAlignBug&&k.lastChild.nodeName==="IMG"){k.style.position="relative";k.lastChild.style.position="relative";k.lastChild.style.top=e.Em(l/k.scale)}else{k.style.verticalAlign=e.Em(-l/k.scale)}}k.bbox.h-=l;k.bbox.d+=l;if(k.bbox.rw>k.bbox.w){k.bbox.ic=k.bbox.rw-k.bbox.w;e.createBlank(k,k.bbox.ic);k.bbox.w=k.bbox.rw}}this.HTMLhandleSpace(k);this.HTMLhandleColor(k);return k},HTMLcanStretch:function(f){if(!this.Get("stretchy")){return false}var g=this.data.join("");if(g.length>1){return false}g=e.FONTDATA.DELIMITERS[g.charCodeAt(0)];return(g&&g.dir==f.substr(0,1))},HTMLstretchV:function(l,k,n){this.HTMLremoveColor();var f=this.getValues("symmetric","maxsize","minsize");var j=this.HTMLspanElement(),g;var i=e.TeX.axis_height,m=j.scale;if(f.symmetric){g=2*Math.max(k-i,n+i)}else{g=k+n}f.maxsize=e.length2em(f.maxsize,j.bbox.h+j.bbox.d);f.minsize=e.length2em(f.minsize,j.bbox.h+j.bbox.d);g=Math.max(f.minsize,Math.min(f.maxsize,g));j=this.HTMLcreateSpan(l);e.createDelimiter(j,this.data.join("").charCodeAt(0),g,m);if(f.symmetric){g=(j.bbox.h+j.bbox.d)/2+i}else{g=(j.bbox.h+j.bbox.d)*k/(k+n)}e.positionDelimiter(j,g);this.HTMLhandleSpace(j);this.HTMLhandleColor(j);return j},HTMLstretchH:function(i,f){this.HTMLremoveColor();var g=this.getValues("maxsize","minsize","mathvariant","fontweight");if(g.fontweight==="bold"&&!this.mathvariant){g.mathvariant=a.VARIANT.BOLD}var h=this.HTMLspanElement(),j=h.scale;g.maxsize=e.length2em(g.maxsize,h.bbox.w);g.minsize=e.length2em(g.minsize,h.bbox.w);f=Math.max(g.minsize,Math.min(g.maxsize,f));h=this.HTMLcreateSpan(i);e.createDelimiter(h,this.data.join("").charCodeAt(0),f,j,g.mathvariant);this.HTMLhandleSpace(h);this.HTMLhandleColor(h);return h}});a.mtext.Augment({toHTML:function(k){k=this.HTMLhandleSize(this.HTMLcreateSpan(k));k.bbox=null;if(this.Parent().type==="merror"){e.addText(k,this.data.join(""));var l=e.getHD(k),g=e.getW(k);k.bbox={h:l.h,d:l.d,w:g,lw:0,rw:g}}else{var j=this.HTMLgetVariant();for(var h=0,f=this.data.length;h<f;h++){if(this.data[h]){this.data[h].toHTML(k,j)}}if(!k.bbox){k.bbox={w:0,h:0,d:0,rw:0,lw:0}}if(this.data.join("").length!==1){delete k.bbox.skew}}this.HTMLhandleSpace(k);this.HTMLhandleColor(k);return k}});a.ms.Augment({toHTML:a.mbase.HTMLautoload});a.mglyph.Augment({toHTML:a.mbase.HTMLautoload});a.mspace.Augment({toHTML:function(j){j=this.HTMLhandleSize(this.HTMLcreateSpan(j));var g=this.getValues("height","depth","width");g.mathbackground=this.mathbackground;if(this.background&&!this.mathbackground){g.mathbackground=this.background}var i=e.length2em(g.height),k=e.length2em(g.depth),f=e.length2em(g.width);e.createSpace(j,i,k,f,g.mathbackground);return j}});a.mphantom.Augment({toHTML:function(j,g,l){j=this.HTMLcreateSpan(j);if(this.data[0]!=null){var k=e.Measured(this.data[0].toHTML(j),j);if(l!=null){e.Remeasured(this.data[0].HTMLstretchV(j,g,l),j)}else{if(g!=null){e.Remeasured(this.data[0].HTMLstretchH(j,g),j)}}j.bbox={w:k.bbox.w,h:k.bbox.h,d:k.bbox.d,lw:0,rw:0};for(var h=0,f=j.childNodes.length;h<f;h++){j.childNodes[h].style.visibility="hidden"}}this.HTMLhandleSpace(j);this.HTMLhandleColor(j);return j},HTMLstretchH:a.mbase.HTMLstretchH,HTMLstretchV:a.mbase.HTMLstretchV});a.mpadded.Augment({toHTML:function(j,h,l){j=this.HTMLcreateSpan(j);if(this.data[0]!=null){var g=e.createStack(j,true);var k=e.createBox(g);e.Measured(this.data[0].toHTML(k),k);if(l!=null){e.Remeasured(this.data[0].HTMLstretchV(k,h,l),k)}else{if(h!=null){e.Remeasured(this.data[0].HTMLstretchH(k,h),k)}}var i=this.getValues("height","depth","width","lspace","voffset"),f=0,m=0;if(i.lspace){f=this.HTMLlength2em(k,i.lspace)}if(i.voffset){m=this.HTMLlength2em(k,i.voffset)}e.placeBox(k,f,m);j.bbox={h:k.bbox.h,d:k.bbox.d,w:k.bbox.w,lw:Math.min(0,k.bbox.lw+f),rw:Math.max(k.bbox.w,k.bbox.rw+f),H:Math.max((k.bbox.H==null?-e.BIGDIMEN:k.bbox.H),k.bbox.h+m),D:Math.max((k.bbox.D==null?-e.BIGDIMEN:k.bbox.D),k.bbox.d-m)};if(i.height!==""){j.bbox.h=this.HTMLlength2em(k,i.height,"h",0)}if(i.depth!==""){j.bbox.d=this.HTMLlength2em(k,i.depth,"d",0)}if(i.width!==""){j.bbox.w=this.HTMLlength2em(k,i.width,"w",0)}if(j.bbox.H<=j.bbox.h){delete j.bbox.H}if(j.bbox.D<=j.bbox.d){delete j.bbox.D}e.setStackWidth(g,j.bbox.w)}this.HTMLhandleSpace(j);this.HTMLhandleColor(j);return j},HTMLlength2em:function(j,k,l,f){if(f==null){f=-e.BIGDIMEN}var h=String(k).match(/width|height|depth/);var i=(h?j.bbox[h[0].charAt(0)]:(l?j.bbox[l]:null));var g=e.length2em(k,i);if(l&&String(k).match(/^\s*[-+]/)){return Math.max(f,j.bbox[l]+g)}else{return g}},HTMLstretchH:a.mbase.HTMLstretchH,HTMLstretchV:a.mbase.HTMLstretchV});a.mrow.Augment({HTMLstretchH:function(h,f){this.HTMLremoveColor();var g=this.HTMLspanElement();this.data[this.core].HTMLstretchH(g,f);this.HTMLcomputeBBox(g,true);this.HTMLhandleColor(g);return g},HTMLstretchV:function(i,g,j){this.HTMLremoveColor();var f=this.HTMLspanElement();this.data[this.core].HTMLstretchV(f,g,j);this.HTMLcomputeBBox(f,true);this.HTMLhandleColor(f);return f}});a.mstyle.Augment({toHTML:function(f){if(this.data[0]!=null){f=this.data[0].toHTML(f);this.spanID=this.data[0].spanID;this.HTMLhandleSpace(f);this.HTMLhandleColor(f)}return f},HTMLspanElement:function(){return(this.data[0]!=null?this.data[0].HTMLspanElement():null)},HTMLstretchH:function(g,f){return(this.data[0]!=null?this.data[0].HTMLstretchH(g,f):g)},HTMLstretchV:function(g,f,i){return(this.data[0]!=null?this.data[0].HTMLstretchV(g,f,i):g)}});a.mfrac.Augment({toHTML:function(y){y=this.HTMLcreateSpan(y);var h=e.createStack(y);var k=e.createBox(h),j=e.createBox(h);this.HTMLmeasureChild(0,k);this.HTMLmeasureChild(1,j);var f=this.getValues("displaystyle","linethickness","numalign","denomalign","bevelled");var C=this.HTMLgetScale(),x=f.displaystyle;var B=e.TeX.axis_height*C;if(f.bevelled){var A=(x?0.4:0.15);var l=Math.max(k.bbox.h+k.bbox.d,j.bbox.h+j.bbox.d)+2*A;var z=e.createBox(h);e.createDelimiter(z,47,l);e.placeBox(k,0,(k.bbox.d-k.bbox.h)/2+B+A);e.placeBox(z,k.bbox.w-A/2,(z.bbox.d-z.bbox.h)/2+B);e.placeBox(j,k.bbox.w+z.bbox.w-A,(j.bbox.d-j.bbox.h)/2+B-A)}else{var g=Math.max(k.bbox.w,j.bbox.w);var o=e.thickness2em(f.linethickness),s,r,n,m;var w=e.TeX.min_rule_thickness/this.em;if(x){n=e.TeX.num1;m=e.TeX.denom1}else{n=(o===0?e.TeX.num3:e.TeX.num2);m=e.TeX.denom2}n*=C;m*=C;if(o===0){s=Math.max((x?7:3)*e.TeX.rule_thickness,2*w);r=(n-k.bbox.d)-(j.bbox.h-m);if(r<s){n+=(s-r)/2;m+=(s-r)/2}}else{s=Math.max((x?2:0)*w+o,o/2+1.5*w);r=(n-k.bbox.d)-(B+o/2);if(r<s){n+=s-r}r=(B-o/2)-(j.bbox.h-m);if(r<s){m+=s-r}var i=e.createBox(h);e.createRule(i,o,0,g+2*o);e.placeBox(i,0,B-o/2)}e.alignBox(k,f.numalign,n);e.alignBox(j,f.denomalign,-m)}this.HTMLhandleSpace(y);this.HTMLhandleColor(y);return y},HTMLcanStretch:function(f){return false},HTMLhandleSpace:function(f){if(!this.texWithDelims){var g=(this.useMMLspacing?0:e.length2em(this.texSpacing()||0))+0.12;f.style.paddingLeft=e.Em(g);f.style.paddingRight=".12em"}}});a.msqrt.Augment({toHTML:function(n){n=this.HTMLcreateSpan(n);var r=e.createStack(n);var h=e.createBox(r),l=e.createBox(r),k=e.createBox(r);this.HTMLmeasureChild(0,h);var j=this.HTMLgetScale();var s=e.TeX.rule_thickness*j,g,f,o,i;if(this.Get("displaystyle")){g=e.TeX.x_height*j}else{g=s}f=Math.max(s+g/4,1.5*e.TeX.min_rule_thickness/this.em);o=h.bbox.h+h.bbox.d+f+s;i=h.bbox.w;e.createDelimiter(k,8730,o,j);e.Measured(k);var m=0;if(k.isMultiChar||(e.AdjustSurd&&e.imgFonts)){k.bbox.w*=0.95}if(k.bbox.h+k.bbox.d>o){f=((k.bbox.h+k.bbox.d)-(o-s))/2}var u=e.FONTDATA.DELIMITERS[e.FONTDATA.RULECHAR];if(!u||i<u.HW[0][0]*j||j<0.75){e.createRule(l,s,0,i)}else{e.createDelimiter(l,e.FONTDATA.RULECHAR,i,j)}o=h.bbox.h+f+s;m=this.HTMLaddRoot(r,k,m,k.bbox.h+k.bbox.d-o,j);e.placeBox(k,m,o-k.bbox.h);e.placeBox(l,m+k.bbox.w,o-l.bbox.h+e.rfuzz);e.placeBox(h,m+k.bbox.w,0);this.HTMLhandleSpace(n);this.HTMLhandleColor(n);return n},HTMLaddRoot:function(h,g,f,j,i){return f}});a.mroot.Augment({toHTML:a.msqrt.prototype.toHTML,HTMLaddRoot:function(o,g,m,k,f){var i=e.createBox(o);if(this.data[1]){var l=this.data[1].toHTML(i);l.style.paddingRight=l.style.paddingLeft="";e.Measured(l,i)}else{i.bbox=this.HTMLzeroBBox()}var j=this.HTMLrootHeight(g.bbox.h+g.bbox.d,f,i)-k;var n=Math.min(i.bbox.w,i.bbox.rw);m=Math.max(n,g.offset);e.placeBox(i,m-n,j);return m-g.offset},HTMLrootHeight:function(h,g,f){return 0.45*(h-0.9*g)+0.6*g+Math.max(0,f.bbox.d-0.075)}});a.mfenced.Augment({toHTML:function(k){k=this.HTMLcreateSpan(k);if(this.data.open){this.data.open.toHTML(k)}if(this.data[0]!=null){this.data[0].toHTML(k)}for(var g=1,f=this.data.length;g<f;g++){if(this.data[g]){if(this.data["sep"+g]){this.data["sep"+g].toHTML(k)}this.data[g].toHTML(k)}}if(this.data.close){this.data.close.toHTML(k)}var n=this.HTMLcomputeBBox(k);var j=k.bbox.h,l=k.bbox.d;for(g=0,f=n.length;g<f;g++){n[g].HTMLstretchV(k,j,l)}if(n.length){this.HTMLcomputeBBox(k,true)}this.HTMLhandleSpace(k);this.HTMLhandleColor(k);return k},HTMLcomputeBBox:function(k,j){var g=k.bbox={},l=[];this.HTMLcheckStretchy(this.data.open,g,l,j);this.HTMLcheckStretchy(this.data[0],g,l,j);for(var h=1,f=this.data.length;h<f;h++){if(this.data[h]){this.HTMLcheckStretchy(this.data["sep"+h],g,l,j);this.HTMLcheckStretchy(this.data[h],g,l,j)}}this.HTMLcheckStretchy(this.data.close,g,l,j);this.HTMLcleanBBox(g);return l},HTMLcheckStretchy:function(f,g,i,h){if(f){if(!h&&f.HTMLcanStretch("Vertical")){i.push(f);f=(f.CoreMO()||f)}this.HTMLcombineBBoxes(f,g)}}});a.menclose.Augment({toHTML:a.mbase.HTMLautoload});a.maction.Augment({toHTML:a.mbase.HTMLautoload});a.semantics.Augment({toHTML:function(f){if(this.data[0]!=null){f=this.data[0].toHTML(f);this.spanID=this.data[0].spanID;this.HTMLhandleSpace(f)}return f},HTMLspanElement:function(){return(this.data[0]!=null?this.data[0].HTMLspanElement():null)},HTMLstretchH:function(g,f){return(this.data[0]!=null?this.data[0].HTMLstretchH(g,f):g)},HTMLstretchV:function(g,f,i){return(this.data[0]!=null?this.data[0].HTMLstretchV(g,f,i):g)}});a.munderover.Augment({toHTML:function(G,B,z){var f=this.getValues("displaystyle","accent","accentunder","align");if(!f.displaystyle&&this.data[this.base]!=null&&this.data[this.base].Get("movablelimits")){return a.msubsup.prototype.toHTML.call(this,G)}G=this.HTMLcreateSpan(G);var K=this.HTMLgetScale();var j=e.createStack(G);var l=[],I=[],q,H,C,g=-e.BIGDIMEN,F=g;for(H=0,C=this.data.length;H<C;H++){if(this.data[H]!=null){q=l[H]=e.createBox(j);e.Measured(this.data[H].toHTML(q),q);if(H==this.base){if(z!=null){e.Remeasured(this.data[this.base].HTMLstretchV(q,B,z),q)}else{if(B!=null){e.Remeasured(this.data[this.base].HTMLstretchH(q,B),q)}}I[H]=(z==null&&B!=null?false:this.data[H].HTMLcanStretch("Horizontal"))}else{I[H]=this.data[H].HTMLcanStretch("Horizontal")}if(q.bbox.w>F){F=q.bbox.w}if(!I[H]&&F>g){g=F}}}if(z==null&&B!=null){g=B}else{if(g==-e.BIGDIMEN){g=F}}for(H=F=0,C=this.data.length;H<C;H++){if(this.data[H]){q=l[H];if(I[H]){q.bbox=this.data[H].HTMLstretchH(q,g).bbox}if(q.bbox.w>F){F=q.bbox.w}}}var w=e.TeX.rule_thickness,A=e.FONTDATA.TeX_factor;var h=l[this.base]||{bbox:this.HTMLzeroBBox()},J=(h.bbox.ic||0);var p,n,s,r,o,v,E;for(H=0,C=this.data.length;H<C;H++){if(this.data[H]!=null){q=l[H];o=e.TeX.big_op_spacing5*K;var u=(H!=this.base&&f[this.ACCENTS[H]]);if(u&&q.bbox.w<=1/e.em+0.0001){q.bbox.w=q.bbox.rw-q.bbox.lw;q.bbox.noclip=true;if(q.bbox.lw&&!e.zeroWidthBug){q.insertBefore(e.createSpace(q.parentNode,0,0,-q.bbox.lw),q.firstChild)}e.createBlank(q,0,0,q.bbox.rw+0.1)}v={left:0,center:(F-q.bbox.w)/2,right:F-q.bbox.w}[f.align];p=v;n=0;if(H==this.over){if(u){E=Math.max(w*K*A,2.5/this.em);o=0;if(h.bbox.skew){p+=h.bbox.skew}}else{s=e.TeX.big_op_spacing1*K*A;r=e.TeX.big_op_spacing3*K*A;E=Math.max(s,r-Math.max(0,q.bbox.d))}E=Math.max(E,1.5/this.em);p+=J;n=h.bbox.h+q.bbox.d+E;q.bbox.h+=o}else{if(H==this.under){if(u){E=3*w*K*A;o=0}else{s=e.TeX.big_op_spacing2*K*A;r=e.TeX.big_op_spacing4*K*A;E=Math.max(s,r-q.bbox.h)}E=Math.max(E,1.5/this.em);p-=J;n=-(h.bbox.d+q.bbox.h+E);q.bbox.d+=o}}e.placeBox(q,p,n)}}this.HTMLhandleSpace(G);this.HTMLhandleColor(G);return G},HTMLstretchH:a.mbase.HTMLstretchH,HTMLstretchV:a.mbase.HTMLstretchV});a.msubsup.Augment({toHTML:function(C,A,w){C=this.HTMLcreateSpan(C);var G=this.HTMLgetScale();var j=e.createStack(C),g;var i=e.createBox(j);this.HTMLmeasureChild(this.base,i);if(this.data[this.base]){if(w!=null){e.Remeasured(this.data[this.base].HTMLstretchV(i,A,w),i)}else{if(A!=null){e.Remeasured(this.data[this.base].HTMLstretchH(i,A),i)}}}e.placeBox(i,0,0);var h=(this.data[this.sup]||this.data[this.sub]||this).HTMLgetScale();var E=e.TeX.x_height*G,o=e.TeX.scriptspace*G*0.75;var f,k;if(this.HTMLnotEmpty(this.data[this.sup])){f=e.createBox(j);e.Measured(this.data[this.sup].toHTML(f),f);f.bbox.w+=o;f.bbox.rw=Math.max(f.bbox.w,f.bbox.rw)}if(this.HTMLnotEmpty(this.data[this.sub])){k=e.createBox(j);e.Measured(this.data[this.sub].toHTML(k),k);k.bbox.w+=o;k.bbox.rw=Math.max(k.bbox.w,k.bbox.rw)}var y=e.TeX.sup_drop*h,x=e.TeX.sub_drop*h;var m=i.bbox.h-y,l=i.bbox.d+x,F=0,z;if(i.bbox.ic){F=i.bbox.ic}if(this.data[this.base]&&(this.data[this.base].type==="mi"||this.data[this.base].type==="mo")){if(this.data[this.base].data.join("").length===1&&i.bbox.scale===1&&!this.data[this.base].Get("largeop")){m=l=0}}var B=this.getValues("subscriptshift","superscriptshift");B.subscriptshift=(B.subscriptshift===""?0:e.length2em(B.subscriptshift));B.superscriptshift=(B.superscriptshift===""?0:e.length2em(B.superscriptshift));if(!f){if(k){l=Math.max(l,e.TeX.sub1*G,k.bbox.h-(4/5)*E,B.subscriptshift);e.placeBox(k,i.bbox.w+o-F,-l,k.bbox)}}else{if(!k){g=this.getValues("displaystyle","texprimestyle");z=e.TeX[(g.displaystyle?"sup1":(g.texprimestyle?"sup3":"sup2"))];m=Math.max(m,z*G,f.bbox.d+(1/4)*E,B.superscriptshift);e.placeBox(f,i.bbox.w+o,m,f.bbox)}else{l=Math.max(l,e.TeX.sub2*G);var n=e.TeX.rule_thickness*G;if((m-f.bbox.d)-(k.bbox.h-l)<3*n){l=3*n-m+f.bbox.d+k.bbox.h;y=(4/5)*E-(m-f.bbox.d);if(y>0){m+=y;l-=y}}e.placeBox(f,i.bbox.w+o,Math.max(m,B.superscriptshift));e.placeBox(k,i.bbox.w+o-F,-Math.max(l,B.subscriptshift))}}this.HTMLhandleSpace(C);this.HTMLhandleColor(C);return C},HTMLstretchH:a.mbase.HTMLstretchH,HTMLstretchV:a.mbase.HTMLstretchV});a.mmultiscripts.Augment({toHTML:a.mbase.HTMLautoload});a.mtable.Augment({toHTML:a.mbase.HTMLautoload});a["annotation-xml"].Augment({toHTML:a.mbase.HTMLautoload});a.math.Augment({toHTML:function(n,g){var k=this.Get("alttext");if(k){g.setAttribute("aria-label",k)}var h=e.addElement(n,"nobr");n=this.HTMLcreateSpan(h);var l=e.createStack(n),i=e.createBox(l),m;l.style.fontSize=h.parentNode.style.fontSize;h.parentNode.style.fontSize="";if(this.data[0]!=null){if(e.msieColorBug){if(this.background){this.data[0].background=this.background;delete this.background}if(this.mathbackground){this.data[0].mathbackground=this.mathbackground;delete this.mathbackground}}a.mbase.prototype.displayAlign=d.config.displayAlign;a.mbase.prototype.displayIndent=d.config.displayIndent;m=e.Measured(this.data[0].toHTML(i),i)}e.placeBox(i,0,0);var j=e.em/e.outerEm;e.em/=j;n.bbox.h*=j;n.bbox.d*=j;n.bbox.w*=j;n.bbox.lw*=j;n.bbox.rw*=j;if(m&&m.bbox.width!=null){l.style.width=m.bbox.width;i.style.width="100%"}this.HTMLhandleColor(n);if(m){e.createRule(n,m.bbox.h*j,m.bbox.d*j,0)}if(!this.isMultiline&&this.Get("display")==="block"&&n.bbox.width==null){var o=this.getValues("indentalignfirst","indentshiftfirst","indentalign","indentshift");if(o.indentalignfirst!==a.INDENTALIGN.INDENTALIGN){o.indentalign=o.indentalignfirst}if(o.indentalign===a.INDENTALIGN.AUTO){o.indentalign=this.displayAlign}g.style.textAlign=o.indentalign;if(o.indentshiftfirst!==a.INDENTSHIFT.INDENTSHIFT){o.indentshift=o.indentshiftfirst}if(o.indentshift==="auto"){o.indentshift=this.displayIndent}if(o.indentshift&&o.indentalign!==a.INDENTALIGN.CENTER){n.style[{left:"marginLeft",right:"marginRight"}[o.indentalign]]=e.Em(e.length2em(o.indentshift))}}return n}});a.TeXAtom.Augment({toHTML:function(g){g=this.HTMLcreateSpan(g);if(this.data[0]!=null){if(this.texClass===a.TEXCLASS.VCENTER){var f=e.createStack(g);var h=e.createBox(f);e.Measured(this.data[0].toHTML(h),h);e.placeBox(h,0,e.TeX.axis_height-(h.bbox.h+h.bbox.d)/2+h.bbox.d)}else{g.bbox=this.data[0].toHTML(g).bbox}}this.HTMLhandleSpace(g);this.HTMLhandleColor(g);return g}});MathJax.Hub.Register.StartupHook("onLoad",function(){setTimeout(MathJax.Callback(["loadComplete",e,"jax.js"]),0)})});d.Register.StartupHook("End Config",function(){d.Browser.Select({MSIE:function(f){var i=f.versionAtLeast("7.0");var h=f.versionAtLeast("8.0")&&document.documentMode>7;var g=(document.compatMode==="BackCompat");e.config.styles[".MathJax .MathJax_HitBox"]["background-color"]="white";e.config.styles[".MathJax .MathJax_HitBox"].opacity=0;e.config.styles[".MathJax .MathJax_HitBox"].filter="alpha(opacity=0)";e.Augment({getMarginScale:e.getMSIEmarginScale,PaddingWidthBug:true,msieEventBug:f.isIE9,msieAccentBug:true,msieColorBug:true,msieColorPositionBug:true,msieRelativeWidthBug:g,msieMarginWidthBug:true,msiePaddingWidthBug:true,msieCharPaddingWidthBug:(h&&!g),msieBorderWidthBug:g,msieInlineBlockAlignBug:(!h||g),msieVerticalAlignBug:(h&&!g),msiePlaceBoxBug:(h&&!g),msieClipRectBug:!h,msieNegativeSpaceBug:g,msieCloneNodeBug:(h&&f.version==="8.0"),negativeSkipBug:true,msieIE6:!i,msieItalicWidthBug:true,zeroWidthBug:true,FontFaceBug:true,msieFontCSSBug:f.isIE9,allowWebFonts:"eot"})},Firefox:function(g){var h=false;if(g.versionAtLeast("3.5")){var f=String(document.location).replace(/[^\/]*$/,"");if(document.location.protocol!=="file:"||(d.config.root+"/").substr(0,f.length)===f){h="otf"}}e.Augment({useProcessingFrame:true,ffVerticalAlignBug:true,AccentBug:true,allowWebFonts:h})},Safari:function(j){var h=j.versionAtLeast("3.0");var g=j.versionAtLeast("3.1");j.isMobile=(navigator.appVersion.match(/Mobile/i)!=null);var f=(navigator.appVersion.match(/ Android (\d+)\.(\d+)/));var k=(g&&j.isMobile&&((navigator.platform.match(/iPad|iPod|iPhone/)&&!j.versionAtLeast("5.0"))||(f!=null&&(f[1]<2||(f[1]==2&&f[2]<2)))));e.Augment({config:{styles:{".MathJax img, .MathJax nobr, .MathJax a":{"max-width":"5000em","max-height":"5000em"}}},useProcessingFrame:true,rfuzz:0.05,AccentBug:true,AdjustSurd:true,safariContextMenuBug:true,safariNegativeSpaceBug:true,safariVerticalAlignBug:!g,safariTextNodeBug:!h,safariWebFontSerif:["serif"],allowWebFonts:(g&&!k?"otf":false)});if(k){var i=d.config["HTML-CSS"];if(i){i.availableFonts=[];i.preferredFont=null}else{d.config["HTML-CSS"]={availableFonts:[],preferredFont:null}}}},Chrome:function(f){e.Augment({useProcessingFrame:true,rfuzz:0.05,AccentBug:true,AdjustSurd:true,allowWebFonts:(f.versionAtLeast("4.0")?"otf":"svg"),safariNegativeSpaceBug:true,safariWebFontSerif:[""]})},Opera:function(f){f.isMini=(navigator.appVersion.match("Opera Mini")!=null);e.config.styles[".MathJax .merror"]["vertical-align"]=null;e.Augment({useProcessingFrame:true,operaHeightBug:true,operaVerticalAlignBug:true,operaFontSizeBug:f.versionAtLeast("10.61"),negativeSkipBug:true,zeroWidthBug:true,FontFaceBug:true,PaddingWidthBug:true,allowWebFonts:(f.versionAtLeast("10.0")&&!f.isMini?"otf":false),adjustAvailableFonts:function(j){for(var h=0,g=j.length;h<g;h++){if(j[h]==="STIX"){j.splice(h,1);g--;h--}}if(this.config.preferredFont==="STIX"){this.config.preferredFont=j[0]}}})},Konqueror:function(f){e.Augment({konquerorVerticalAlignBug:true,noContextMenuBug:true})}})});MathJax.Hub.Register.StartupHook("End Cookie",function(){if(d.config.menuSettings.zoom!=="None"){c.Require("[MathJax]/extensions/MathZoom.js")}})})(MathJax.Ajax,MathJax.Hub,MathJax.OutputJax["HTML-CSS"]);

MathJax.Hub.Register.StartupHook("HTML-CSS Jax Ready",function(){var c="1.1";var a=MathJax.ElementJax.mml,b=MathJax.OutputJax["HTML-CSS"];a.mtable.Augment({toHTML:function(X){X=this.HTMLcreateSpan(X);if(this.data.length===0){return X}var aJ=this.getValues("columnalign","rowalign","columnspacing","rowspacing","columnwidth","equalcolumns","equalrows","columnlines","rowlines","frame","framespacing","align","useHeight","width","side","minlabelspacing");var r=aJ.width.match(/%$/);var ag=b.createStack(X);var am=this.HTMLgetScale();var aH=-1;var w=[],I=[],l=[],O=[],K=[],aF,aE,v=-1,aC,t,ay,R;var aL=b.FONTDATA.baselineskip*am*aJ.useHeight,Z=b.FONTDATA.lineH*am,af=b.FONTDATA.lineD*am;for(aF=0,aC=this.data.length;aF<aC;aF++){R=this.data[aF];ay=(R.type==="mlabeledtr"?aH:0);O[aF]=[];w[aF]=I[aF]=0;for(aE=ay,t=R.data.length+ay;aE<t;aE++){if(l[aE]==null){if(aE>v){v=aE}K[aE]=b.createStack(b.createBox(ag));l[aE]=-b.BIGDIMEN}O[aF][aE]=b.createBox(K[aE]);b.Measured(R.data[aE-ay].toHTML(O[aF][aE]),O[aF][aE]);if(R.data[aE-ay].isMultiline){O[aF][aE].style.width="100%"}if(O[aF][aE].bbox.h>w[aF]){w[aF]=O[aF][aE].bbox.h}if(O[aF][aE].bbox.d>I[aF]){I[aF]=O[aF][aE].bbox.d}if(O[aF][aE].bbox.w>l[aE]){l[aE]=O[aF][aE].bbox.w}}}if(w[0]+I[0]){w[0]=Math.max(w[0],Z)}if(w[O.length-1]+I[O.length-1]){I[O.length-1]=Math.max(I[O.length-1],af)}var al=aJ.columnspacing.split(/ /),S=aJ.rowspacing.split(/ /),ah=aJ.columnalign.split(/ /),L=aJ.rowalign.split(/ /),N=aJ.columnlines.split(/ /),k=aJ.rowlines.split(/ /),ap=aJ.columnwidth.split(/ /),au=[];for(aF=0,aC=al.length;aF<aC;aF++){al[aF]=b.length2em(al[aF])}for(aF=0,aC=S.length;aF<aC;aF++){S[aF]=b.length2em(S[aF])}while(al.length<v){al.push(al[al.length-1])}while(ah.length<=v){ah.push(ah[ah.length-1])}while(N.length<v){N.push(N[N.length-1])}while(ap.length<=v){ap.push(ap[ap.length-1])}while(S.length<O.length){S.push(S[S.length-1])}while(L.length<=O.length){L.push(L[L.length-1])}while(k.length<O.length){k.push(k[k.length-1])}if(K[aH]){ah[aH]=(aJ.side.substr(0,1)==="l"?"left":"right");al[aH]=-l[aH]}for(aF=0,aC=O.length;aF<aC;aF++){R=this.data[aF];au[aF]=[];if(R.rowalign){L[aF]=R.rowalign}if(R.columnalign){au[aF]=R.columnalign.split(/ /);while(au[aF].length<=v){au[aF].push(au[aF][au[aF].length-1])}}}var az=w[0]+I[O.length-1];for(aF=0,aC=O.length-1;aF<aC;aF++){az+=Math.max((w[aF]+I[aF]?aL:0),I[aF]+w[aF+1]+S[aF])}var ac=0,aa=0,aA,aI=az;if(aJ.frame!=="none"||(aJ.columnlines+aJ.rowlines).match(/solid|dashed/)){ac=b.length2em(aJ.framespacing.split(/[, ]+/)[0]);aa=b.length2em(aJ.framespacing.split(/[, ]+/)[1]);aI=az+2*aa}var h,ax;if(String(aJ.align).match(/^\d+$/)){h=az/2+b.TeX.axis_height*am-w[0];ax=-(az/2+aa)}else{h=({top:-(w[0]+aa),bottom:az+aa-w[0],center:az/2-w[0],baseline:az/2-w[0],axis:az/2+b.TeX.axis_height*am-w[0]})[aJ.align];ax=({top:-(az+2*aa),bottom:0,center:-(az/2+aa),baseline:-(az/2+aa),axis:b.TeX.axis_height*am-az/2-aa})[aJ.align]}var aq,aw=0,U=0,V=0,aB=0,aG=0,o=[],B=[],ai=1;if(aJ.equalcolumns&&aJ.width!=="auto"){if(r){aq=(100/(v+1)).toFixed(2).replace(/\.?0+$/,"")+"%";for(aF=0,aC=Math.min(v+1,ap.length);aF<aC;aF++){ap[aF]=aq}aq=0;aw=1;aG=v+1;for(aF=0,aC=Math.min(v+1,al.length);aF<aC;aF++){aq+=al[aF]}}else{aq=b.length2em(aJ.width);for(aF=0,aC=Math.min(v+1,al.length);aF<aC;aF++){aq-=al[aF]}aq/=v+1;for(aF=0,aC=Math.min(v+1,ap.length);aF<aC;aF++){l[aF]=aq}}}else{for(aF=0,aC=Math.min(v+1,ap.length);aF<aC;aF++){if(ap[aF]==="auto"){U+=l[aF]}else{if(ap[aF]==="fit"){B[aG]=aF;aG++;U+=l[aF]}else{if(ap[aF].match(/%$/)){o[aB]=aF;aB++;V+=l[aF];aw+=b.length2em(ap[aF],1)}else{l[aF]=b.length2em(ap[aF]);U+=l[aF]}}}}if(r){aq=0;for(aF=0,aC=Math.min(v,al.length);aF<aC;aF++){aq+=al[aF]}if(aw>0.98){ai=0.98/aw;aw=0.98}}else{if(aJ.width==="auto"){if(aw>0.98){ai=V/(U+V);aq=U+V}else{aq=U/(1-aw)}}else{aq=b.length2em(aJ.width);for(aF=0,aC=Math.min(v+1,al.length);aF<aC;aF++){aq-=al[aF]}}for(aF=0,aC=o.length;aF<aC;aF++){l[o[aF]]=b.length2em(ap[o[aF]],aq*ai);U+=l[o[aF]]}if(Math.abs(aq-U)>0.01){if(aG&&aq>U){aq=(aq-U)/aG;for(aF=0,aC=B.length;aF<aC;aF++){l[B[aF]]+=aq}}else{aq=aq/U;for(aE=0;aE<=v;aE++){l[aE]*=aq}}}if(aJ.equalcolumns){var ad=Math.max.apply(Math,l);for(aE=0;aE<=v;aE++){l[aE]=ad}}}}if(aJ.equalrows){var T=Math.max.apply(Math,w),ao=Math.max.apply(Math,I);for(aF=0,aC=O.length;aF<aC;aF++){ay=((T+ao)-(w[aF]+I[aF]))/2;w[aF]+=ay;I[aF]+=ay}}var ar=h,n,u,aD;ay=(K[aH]?aH:0);for(aE=ay;aE<=v;aE++){for(aF=0,aC=O.length;aF<aC;aF++){if(O[aF][aE]){ay=(this.data[aF].type==="mlabeledtr"?aH:0);var ak=this.data[aF].data[aE-ay];if(ak.HTMLcanStretch("Horizontal")){O[aF][aE].bbox=ak.HTMLstretchH(K[aE],l[aE]).bbox}else{if(ak.HTMLcanStretch("Vertical")){var z=ak.CoreMO();var ab=z.symmetric;z.symmetric=false;O[aF][aE].bbox=ak.HTMLstretchV(K[aE],w[aF],I[aF]).bbox;z.symmetric=ab}}aD=ak.rowalign||this.data[aF].rowalign||L[aF];n=({top:w[aF]-O[aF][aE].bbox.h,bottom:O[aF][aE].bbox.d-I[aF],center:((w[aF]-I[aF])-(O[aF][aE].bbox.h-O[aF][aE].bbox.d))/2,baseline:0,axis:0})[aD];aD=(ak.columnalign||au[aF][aE]||ah[aE]);b.alignBox(O[aF][aE],aD,ar+n)}if(aF<O.length-1){ar-=Math.max((w[aF]+I[aF]?aL:0),I[aF]+w[aF+1]+S[aF])}}ar=h}if(r){var q=b.createBox(ag);q.style.left=q.style.top=0;q.style.right=b.Em(aq+2*ac);q.style.display="inline-block";q.style.height="0px";if(b.msieRelativeWidthBug){q=b.createBox(q);q.style.position="relative";q.style.height="1em";q.style.width="100%";q.bbox=ag.bbox}var an=0,av=ac,aK,g;if(aG){aK=100*(1-aw)/aG,g=U/aG}else{aK=100*(1-aw)/(v+1);g=U/(v+1)}for(aE=0;aE<=v;aE++){b.placeBox(K[aE].parentNode,0,0);K[aE].style.position="relative";K[aE].style.left=b.Em(av);K[aE].style.width="100%";K[aE].parentNode.parentNode.removeChild(K[aE].parentNode);var e=b.createBox(q);b.addBox(e,K[aE]);K[aE]=e;var ae=e.style;ae.display="inline-block";ae.left=an+"%";if(ap[aE].match(/%$/)){var G=parseFloat(ap[aE])*ai;if(aG===0){ae.width=(aK+G)+"%";an+=aK+G;e=b.createBox(e);b.addBox(e,K[aE].firstChild);e.style.left=0;e.style.right=b.Em(g);av-=g}else{ae.width=G+"%";an+=G}}else{if(ap[aE]==="fit"||aG===0){ae.width=aK+"%";e=b.createBox(e);b.addBox(e,K[aE].firstChild);e.style.left=0;e.style.right=b.Em(g-l[aE]);av+=l[aE]-g;an+=aK}else{ae.width=b.Em(l[aE]);av+=l[aE]}}if(b.msieRelativeWidthBug){b.addText(e.firstChild,b.NBSP);e.firstChild.style.position="relative"}av+=al[aE];if(N[aE]!=="none"&&aE<v&&aE!==aH){u=b.createBox(q);u.style.left=an+"%";u=b.createRule(u,aI,0,1.25/b.em);u.style.position="absolute";u.bbox={h:aI,d:0,w:0,rw:1.25/b.em,lw:0};u.parentNode.bbox=ag.bbox;b.placeBox(u,av-al[aE]/2,ax,true);u.style.borderStyle=N[aE]}}}else{var at=ac;for(aE=0;aE<=v;aE++){if(!K[aE].bbox.width){b.setStackWidth(K[aE],l[aE])}if(ap[aE]!=="auto"&&ap[aE]!=="fit"){K[aE].bbox.width=l[aE];K[aE].bbox.isFixed=true}b.placeBox(K[aE].parentNode,at,0);at+=l[aE]+al[aE];if(N[aE]!=="none"&&aE<v&&aE!==aH){u=b.createRule(ag,aI,0,1.25/b.em);b.addBox(ag,u);u.bbox={h:aI,d:0,w:0,rw:1.25/b.em,lw:0};b.placeBox(u,at-al[aE]/2,ax,true);u.style.borderStyle=N[aE]}}}aA=ag.bbox.w+ac;var d;if(aJ.frame!=="none"){d=b.createFrame(ag,aI,0,aA,1.25/b.em,aJ.frame);b.addBox(ag,d);b.placeBox(d,0,ax,true);if(r){d.style.width="100%"}}ar=h;for(aF=0,aC=O.length-1;aF<aC;aF++){n=Math.max(aL,I[aF]+w[aF+1]+S[aF]);if(k[aF]!=="none"){u=b.createRule(ag,1.25/b.em,0,aA);b.addBox(ag,u);u.bbox={h:1.25/b.em,d:0,w:aA,rw:aA,lw:0};b.placeBox(u,0,ar-I[aF]-(n-I[aF]-w[aF+1])/2,true);if(k[aF]==="dashed"||r){u.style.borderTop=u.style.height+" "+k[aF];u.style.height=0;u.style.width=u.style.borderLeftWidth;u.style.borderLeft="";if(r){u.style.width="100%"}}}ar-=n}if(r){X.bbox.width=aJ.width;ag.style.width="100%"}if(K[aH]){var Q=this.getValues("indentalignfirst","indentshiftfirst","indentalign","indentshift");if(Q.indentalignfirst!==a.INDENTALIGN.INDENTALIGN){Q.indentalign=Q.indentalignfirst}if(Q.indentalign===a.INDENTALIGN.AUTO){Q.indentalign=this.displayAlign}if(Q.indentshiftfirst!==a.INDENTSHIFT.INDENTSHIFT){Q.indentshift=Q.indentshiftfirst}if(Q.indentshift==="auto"){Q.indentshift=this.displayIndent}var E=b.createStack(X,false,"100%");b.addBox(E,ag);b.alignBox(ag,Q.indentalign,0);if(Q.indentshift&&Q.indentalign!==a.INDENTALIGN.CENTER){ag.style[{left:"Left",right:"Right"}[Q.indentalign]]=b.Em(b.length2em(Q.indentshift))}K[aH].parentNode.parentNode.removeChild(K[aH].parentNode);b.addBox(E,K[aH]);b.alignBox(K[aH],ah[aH],0);if(b.msieRelativeWidthBug){ag.style.top=K[aH].style.top=""}if(r){ag.style.width=aJ.width;X.bbox.width="100%"}K[aH].style.marginRight=K[aH].style.marginLeft=b.Em(b.length2em(aJ.minlabelspacing))}if(!r){this.HTMLhandleSpace(X)}var aj=this.HTMLhandleColor(X);if(aj&&r){if(!d){d=b.createFrame(ag,aI,0,aA,0,"none");b.addBox(ag,d);b.placeBox(d,0,ax,true);d.style.width="100%"}d.style.backgroundColor=aj.style.backgroundColor;d.parentNode.insertBefore(d,d.parentNode.firstChild);aj.parentNode.removeChild(aj)}return X},HTMLhandleSpace:function(d){d.style.paddingLeft=d.style.paddingRight=".1667em"}});a.mtd.Augment({toHTML:function(e,d,g){e=this.HTMLcreateSpan(e);if(this.data[0]){var f=b.Measured(this.data[0].toHTML(e),e);if(g!=null){b.Remeasured(this.data[0].HTMLstretchV(e,d,g),e)}else{if(d!=null){b.Remeasured(this.data[0].HTMLstretchH(e,d),e)}}e.bbox=f.bbox}this.HTMLhandleSpace(e);this.HTMLhandleColor(e);return e},HTMLstretchH:a.mbase.HTMLstretchH,HTMLstretchV:a.mbase.HTMLstretchV});MathJax.Hub.Startup.signal.Post("HTML-CSS mtable Ready");MathJax.Ajax.loadComplete(b.autoloadDir+"/mtable.js")});

MathJax.Ajax.loadComplete("[MathJax]/config/MML_HTMLorMML-full.js");
