/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File Log.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef Log_H
#define Log_H

#include "inc_iostream.h"
#include "inc_stl.h"

#ifndef Path_H
#include "Path.h"
#endif

class IconObject;

class Log {
public:

// -- Exceptions
	// None

// -- Contructors

	Log(IconObject*);

// -- Destructor

	~Log(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators

	operator ostream&() ;

// -- Methods

	const Path& path();

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods

	static ostream& info(IconObject*);
	static ostream& warning(IconObject*);
	static ostream& error(IconObject*);
	static ostream& syserr(ostream&);

	static ostream& info(const string&);
	static ostream& warning(const string&);
	static ostream& error(const string&);

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	Log(const Log&);
	Log& operator=(const Log&);

// -- Members

	Path              path_;
	auto_ptr<ostream> out_;
	auto_ptr<ostream> tee_;
	IconObject* object_;

// -- Methods

	

// -- Overridden methods
	// None

// -- Class members



// -- Class methods


	static ostream& global();
// -- Friends

	//friend ostream& operator<<(ostream& s,const Log& p)
	//	{ p.print(s); return s; }

};

inline void destroy(Log**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(Log);
//#endif

#endif
