#!/usr/bin/perl

#(c)2007-2009 Hurricane Labs
#Author: Billford
#License: See LICENSE file GPL v2
#Nagzilla Jabber Relay Client

require Config::Simple;
require Data::Dumper;
use IO::Socket;
use IO::Socket::INET;

#bring in our configuration variables
$CONFDIR = "/etc/nagzillac";

# DO NOT EDIT ANYTHING BEYOND THIS POINT!!

##################Begin Config Setup########################

Config::Simple->import_from('nagzillac.cfg', \%Config);
$cfg = new Config::Simple("$CONFDIR/nagzillac.cfg");

#Nagzillac Nagzilla Server Settings

$nagzillaserver = $cfg->param("NagzillaServer");
$nagzillaport  = $cfg->param("NagzillaPort");

##################End Config Setup##########################

#Let's make us a socket connection
$remote = IO::Socket::INET->new(
   Proto    => 'tcp',
   PeerAddr => "$nagzillaserver",
   PeerPort => "$nagzillaport",
   Reuse    => 1
) or die "$!";

$remote->autoflush(1);

print $remote $ARGV[0];

close $remote;
