<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/modules/ap/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/modules/ap/metadata.yaml"
sidebar_label: "Access Points"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Linux Systems/Network"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Access Points


<img src="https://netdata.cloud/img/network-wired.svg" width="150"/>


Plugin: go.d.plugin
Module: ap

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors various wireless access point metrics like connected clients, bandwidth, packets, transmit issues, signal strength, and bitrate for each device and its associated SSID.


This tool uses the `iw` command-line utility to discover nearby access points. It starts by running `iw dev`, which provides information about all wireless interfaces.  Then, for each interface identified as an access point (type AP), the `iw INTERFACE station dump` command is executed to gather relevant metrics.


This collector is only supported on the following platforms:

- Linux

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

The plugin is able to auto-detect any access points on your Linux machine.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per wireless device

These metrics refer to the entire monitored application.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| device | Wireless interface name |
| ssid | SSID |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| ap.clients | clients | clients |
| ap.net | received, sent | kilobits/s |
| ap.packets | received, sent | packets/s |
| ap.issues | retries, failures | issues/s |
| ap.signal | average signal | dBm |
| ap.bitrate | receive, transmit | Mbps |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### `iw` utility.

Make sure the `iw` utility is installed.


### Configuration

#### File

The configuration file name for this integration is `go.d/ap.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/ap.conf
```
#### Options

The following options can be defined globally: update_every.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 10 | no |
| binary_path | Path to the `iw` binary. If an absolute path is provided, the collector will use it directly; otherwise, it will search for the binary in directories specified in the PATH environment variable. | /usr/sbin/iw | yes |
| timeout | Timeout for executing the binary, specified in seconds. | 2 | no |

</details>

#### Examples

##### Custom binary path

The executable is not in the directories specified in the PATH environment variable.

```yaml
jobs:
  - name: custom_iw
    binary_path: /usr/local/sbin/iw

```


## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `ap` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m ap
  ```

### Getting Logs

If you're encountering problems with the `ap` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep ap
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep ap /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep ap
```


