C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_c_p91_vwn5.F 
C> The nwxcm_c_p91_vwn5 functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_c_p91_vwn5 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_4} &=& 1.0-{\it t_2}\,{\it t_3}\\\\ 
C>   {\it t_5} &=& {\it t_2}\,{\it t_3}+1.0\\\\ 
C>   {\it t_6} &=& 0.5\,{\it t_5}^{{{2}\over{3}}}+0.5\,{
C>    \it t_4}^{{{2}\over{3}}}\\\\ 
C>   {\it t_7} &=& {\it t_6}^{3.0}\\\\ 
C>   {\it t_8} &=& {\it t_1}^{1.166666666666667}\\\\ 
C>   {\it t_9} &=& {{1}\over{{\it t_8}^{2.0}}}\\\\ 
C>   {\it t_{10}} &=& {{1}\over{{\it t_6}^{2.0}}}\\\\ 
C>   {\it t_{11}} &=& \sigma_{\beta\beta}+2.0\,\sigma_{\alpha\beta}
C>    +\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{12}} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_{13}} &=& {{1}\over{\sqrt{{\it t_{12}}}}}\\\\ 
C>   {\it t_{14}} &=& 1.575246635799487\,{\it t_{13}}\\\\ 
C>   {\it t_{15}} &=& \arctan \left({{6.15199081975908}\over{{
C>    \it t_{14}}+3.72744}}\right)\\\\ 
C>   {\it t_{16}} &=& 0.7876233178997433\,{\it t_{13}}\\\\ 
C>   {\it t_{17}} &=& {{1}\over{{\it t_{12}}}}\\\\ 
C>   {\it t_{18}} &=& 0.6203504908994001\,{\it t_{17}}\\\\ 
C>   {\it t_{19}} &=& {{1}\over{\left| 2.935818660072219\,{\it t_{13}}
C>    +{\it t_{18}}+12.9352\right| }}\\\\ 
C>   {\it t_{20}} &=& \log \left(1.0\,\left({\it t_{16}}
C>    +0.10498\right)^2\,{\it t_{19}}\right)\\\\ 
C>   {\it t_{21}} &=& \left| {\it t_{17}}\right| \\\\ 
C>   {\it t_{22}} &=& \log \left(0.6203504908994001\,{\it t_{21}}
C>    \,{\it t_{19}}\right)\\\\ 
C>   {\it t_{23}} &=& \arctan \left({{7.123108917818118}\over{{
C>    \it t_{14}}+1.13107}}\right)\\\\ 
C>   {\it t_{24}} &=& {{1}\over{\left| 0.8908571061768626\,{
C>    \it t_{13}}+{\it t_{18}}+13.0045\right| }}\\\\ 
C>   {\it t_{25}} &=& \log \left(1.0\,\left({\it t_{16}}
C>    +0.0047584\right)^2\,{\it t_{24}}\right)\\\\ 
C>   {\it t_{26}} &=& \log \left(0.6203504908994001\,{\it t_{21}}
C>    \,{\it t_{24}}\right)\\\\ 
C>   {\it t_{27}} &=& {{1}\over{\left| 5.560951426165705\,{\it t_{13}}
C>    +{\it t_{18}}+18.0578\right| }}\\\\ 
C>   {\it t_{28}} &=& {{1}\over{e^{{{40.4276151175637\,\left(1.125
C>    \,\left({\it t_5}^{{{4}\over{3}}}+{\it t_4}^{{{4}\over{3}}}
C>    -2.0\right)\,\left({{{\it t_2}^4\,\left(1.709920934161365
C>    \,\left(0.01554535\,\log \left(0.6203504908994001\,{
C>    \it t_{21}}\,{\it t_{27}}\right)+0.002247867095542611
C>    \,\log \left(1.0\,\left({\it t_{16}}+0.325\right)^2\,{
C>    \it t_{27}}\right)-0.0310907\,{\it t_{22}}
C>    -9.690227711544375 \times 10^{-4}\,{\it t_{20}}
C>    +0.05249139316978092\,\arctan \left({{4.730926909560114}
C>    \over{{\it t_{14}}+7.06042}}\right)-0.03878329487811301\,{
C>    \it t_{15}}\right)+0.01688686394038963\,{\it t_{26}}
C>    +6.991732350764465 \times 10^{-6}\,{\it t_{25}}
C>    +0.005365091848883603\,{\it t_{23}}\right)}\over{{\it t_1}^4}}
C>    -0.01688686394038963\,{\it t_{26}}-6.991732350764465 \times 10^{
C>    -6}\,{\it t_{25}}-0.005365091848883603\,{\it t_{23}}\right)
C>    +0.0310907\,{\it t_{22}}+9.690227711544375 \times 10^{-4}\,{
C>    \it t_{20}}+0.03878329487811301\,{\it t_{15}}\right)}\over{{
C>    \it t_7}}}}}}-1.0\\\\ 
C>   {\it t_{29}} &=& {{0.1712109500228823\,{\it t_9}\,{\it t_{10}}
C>    \,{\it t_{11}}}\over{{\it t_{28}}}}\\\\ 
C>   {\it t_{30}} &=& \rho_s^{1.166666666666667}\\\\ 
C>   {\it t_{31}} &=& {{1}\over{{\it t_{30}}^{2.0}}}\\\\ 
C>   {\it t_{32}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{33}} &=& {{1}\over{\sqrt{{\it t_{32}}}}}\\\\ 
C>   {\it t_{34}} &=& {{1}\over{{\it t_{32}}}}\\\\ 
C>   {\it t_{35}} &=& 0.6203504908994001\,{\it t_{34}}\\\\ 
C>   {\it t_{36}} &=& {{1}\over{\left| {\it t_{35}}
C>    +2.935818660072219\,{\it t_{33}}+12.9352\right| }}\\\\ 
C>   {\it t_{37}} &=& \left| {\it t_{34}}\right| \\\\ 
C>   {\it t_{38}} &=& \log \left(0.6203504908994001\,{\it t_{36}}
C>    \,{\it t_{37}}\right)\\\\ 
C>   {\it t_{39}} &=& 0.7876233178997433\,{\it t_{33}}\\\\ 
C>   {\it t_{40}} &=& \log \left(1.0\,{\it t_{36}}\,\left({\it t_{39}}
C>    +0.10498\right)^2\right)\\\\ 
C>   {\it t_{41}} &=& 1.575246635799487\,{\it t_{33}}\\\\ 
C>   {\it t_{42}} &=& \arctan \left({{6.15199081975908}\over{{
C>    \it t_{41}}+3.72744}}\right)\\\\ 
C>   {\it t_{43}} &=& {{1}\over{\left| {\it t_{35}}
C>    +0.8908571061768626\,{\it t_{33}}+13.0045\right| }}\\\\ 
C>   {\it t_{44}} &=& \log \left(0.6203504908994001\,{\it t_{43}}
C>    \,{\it t_{37}}\right)\\\\ 
C>   {\it t_{45}} &=& \log \left(1.0\,{\it t_{43}}\,\left({\it t_{39}}
C>    +0.0047584\right)^2\right)\\\\ 
C>   {\it t_{46}} &=& \arctan \left({{7.123108917818118}\over{{
C>    \it t_{41}}+1.13107}}\right)\\\\ 
C>   {\it t_{47}} &=& {{1}\over{\left| {\it t_{35}}
C>    +5.560951426165705\,{\it t_{33}}+18.0578\right| }}\\\\ 
C>   {\it t_{48}} &=& {{1}\over{e^{80.85523023512742\,
C>    \left(0.5848223622634643\,\left(1.0\,\left(1.709920934161365
C>    \,\left(0.05249139316978092\,\arctan 
C>    \left({{4.730926909560114}\over{{\it t_{41}}+7.06042}}\right)
C>    -0.03878329487811301\,{\it t_{42}}+0.002247867095542611
C>    \,\log \left(1.0\,{\it t_{47}}\,\left({\it t_{39}}
C>    +0.325\right)^2\right)-9.690227711544375 \times 10^{-4}\,{
C>    \it t_{40}}+0.01554535\,\log \left(0.6203504908994001\,{
C>    \it t_{47}}\,{\it t_{37}}\right)-0.0310907\,{\it t_{38}}\right)
C>    +0.005365091848883603\,{\it t_{46}}
C>    +6.991732350764465 \times 10^{-6}\,{\it t_{45}}
C>    +0.01688686394038963\,{\it t_{44}}\right)-0.005365091848883603
C>    \,{\it t_{46}}-6.991732350764465 \times 10^{-6}\,{\it t_{45}}
C>    -0.01688686394038963\,{\it t_{44}}\right)+0.03878329487811301
C>    \,{\it t_{42}}+9.690227711544375 \times 10^{-4}\,{\it t_{40}}
C>    +0.0310907\,{\it t_{38}}\right)}}}-1.0\\\\ 
C>   {\it t_{49}} &=& {{0.2717804421747982\,{\it t_{31}}\,
C>    \sigma_{ss}}\over{{\it t_{48}}}}\\\\ 
C>   f &=& 0.02473556743557577\,{\it t_1}\,{\it t_7}\,\log 
C>    \left({{0.1712109500228823\,{\it t_9}\,{\it t_{10}}\,{
C>    \it t_{11}}\,\left({\it t_{29}}+1.0\right)}
C>    \over{{{0.02931318940773791\,{\it t_{11}}^{2.0}}\over{{
C>    \it t_8}^{4.0}\,{\it t_6}^{4.0}\,{\it t_{28}}^{2.0}}}+{
C>    \it t_{29}}+1.0}}+1.0\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 0.01236778371778788\,\rho_s\,\log 
C>    \left({{0.2717804421747982\,{\it t_{31}}\,\sigma_{ss}\,
C>    \left({\it t_{49}}+1.0\right)}\over{{{0.07386460874872887
C>    \,\sigma_{ss}^{2.0}}\over{{\it t_{30}}^{4.0}\,{
C>    \it t_{48}}^{2.0}}}+{\it t_{49}}+1.0}}+1.0\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] unpublished , DOI: 
C> <a href="https://doi.org/unpublished "> 
C> unpublished </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_p91_vwn5(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Cmat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**1.1666666666666667d+0
            t2 = 1/t1**2.0d+0
            t3 = rhoa**3.333333333333333d-1
            t4 = t3**5.0d-1
            t5 = 1/t4
            t6 = 1/t3
            t7 = 4.9237251092134837d-1*t6
            t8 = 1/abs(t7+2.615517080950829d+0*t5+1.29352d+1)
            t9 = abs(t6)
            t10 = exp(-4.0427615117563703d+1*(3.10907d-2*log(4.923725109
     1         2134837d-1*t8*t9)+9.690227711544375d-4*log(1.0d+0*(7.0169
     2         26042943223d-1*t5+1.0498d-1)**2*t8)+3.8783294878113006d-2
     3         *atan(6.15199081975908d+0/(1.4033852085886447d+0*t5+3.727
     4         44d+0))))-1.0d+0
            t11 = 1.358902210873991d-1*gammaaa*t2/t10
            t12 = gammaaa**2.0d+0
            t13 = 1/t1**4.0d+0
            t14 = t7+2.615517080950828d+0*t5+1.29352d+1
            t15 = abs(t14)
            t16 = 1/t15
            t17 = 7.016926042943222d-1*t5+1.0498d-1
            t18 = t17**2
            t19 = 1.4033852085886445d+0*t5+3.72744d+0
            t20 = exp(-4.0427615117563703d+1*(3.10907d-2*log(4.923725109
     1         2134837d-1*t16*t9)+3.8783294878113006d-2*atan(6.151990819
     2         75908d+0/t19)+9.690227711544375d-4*log(1.0d+0*t16*t18)))
            t21 = t20-1.0d+0
            t22 = 1/t21
            t23 = 1.3589022108739912d-1*gammaaa*t2*t22
            t24 = t23+1.0d+0
            t25 = 1/t21**2.0d+0
            t26 = 1.846615218718221d-2*t12*t13*t25+t23+1.0d+0
            t27 = 1/t26
            t28 = 1.3589022108739912d-1*gammaaa*t2*t24*t27+1.0d+0
            t29 = 1/t28
            t30 = rhoa**1.6666666666666674d-1
            t31 = 1/t1**3.0d+0
            t32 = -1.585385912686323d-1*gammaaa*t22*t30*t31
            t33 = 1/t9
            t34 = 1/t4**3
            t35 = 1/rhoa**6.666666666666667d-1
            t36 = -2.1795975674590234d-1*t34*t35-8.206208515355806d-2/rh
     1         oa**1.3333333333333333d+0
            t37 = 1/t14
            t38 = 1/t19**2
            t39 = 6.314467057030004d-2*t15*t33*(-4.9237251092134837d-1*t
     1         16*t36*t37*t9-8.206208515355806d-2*t16*t33/rhoa**1.666666
     2         6666666666d+0)+2.790332964441521d-2*t34*t35*t38/(3.784699
     3         104639999d+1*t38+1)+9.690227711544375d-4*t15*(-1.0d+0*t16
     4         *t18*t36*t37-1.1694876738238703d-1*t16*t17*t34*t35)/t18
            t40 = 5.493717556362011d+0*gammaaa*t2*t20*t39/t21**2
            t41 = 1/t26**2
            fnc(iq) = 4.947113487115154d-2*rhoa*log(1.358902210873991d-1
     1         *gammaaa*(t11+1.0d+0)*t2/(1.8466152187182203d-2*t12*t13/t
     2         10**2.0d+0+t11+1.0d+0)+1.0d+0)*wght+fnc(iq)
            Amat(iq,D1_RA) = 4.947113487115154d-2*rhoa*t29*(-1.358902210
     1         8739912d-1*gammaaa*t2*t24*(t40+1.4930849866515192d+0*t12*
     2         t13*t20*t39/t21**3.0d+0+t32-4.30876884367585d-2*t12*t25*t
     3         30/t1**5.0d+0)*t41+1.3589022108739912d-1*gammaaa*t2*t27*(
     4         t40+t32)-1.585385912686323d-1*gammaaa*t24*t27*t30*t31)*wg
     5         ht+2.473556743557577d-2*log(t28)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 4.947113487115154d-2*rhoa*t29*(-1.35890221
     1         08739912d-1*gammaaa*t2*t24*(9.233076093591105d-3*gammaaa*
     2         t13*t25+3.397255527184978d-2*t2*t22)*t41+3.39725552718497
     3         8d-2*t2*t24*t27+4.6165380467955525d-3*gammaaa*t13*t22*t27
     4         )*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 4.947113487115154d-2*rhoa*t29*(-1.35890221
     1         08739912d-1*gammaaa*t2*t24*(1.846615218718221d-2*gammaaa*
     2         t13*t25+6.794511054369956d-2*t2*t22)*t41+6.79451105436995
     3         6d-2*t2*t24*t27+9.233076093591105d-3*gammaaa*t13*t22*t27)
     4         *wght+Cmat(iq,D1_GAB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = rhoa-rhob
            t3 = 1/t1
            t4 = 1.0d+0-t2*t3
            t5 = t2*t3+1.0d+0
            t6 = 5.0d-1*t5**6.666666666666666d-1+5.0d-1*t4**6.6666666666
     1         66666d-1
            t7 = t6**3.0d+0
            t8 = gammabb+2.0d+0*gammaab+gammaaa
            t9 = t1**1.1666666666666667d+0
            t10 = 1/t9**2.0d+0
            t11 = t6**2.0d+0
            t12 = 1/t11
            t13 = 1/t7
            t14 = t1**3.333333333333333d-1
            t15 = t14**5.0d-1
            t16 = 1/t15
            t17 = 1.5752466357994865d+0*t16
            t18 = t17+3.72744d+0
            t19 = atan(6.15199081975908d+0/t18)
            t20 = 7.876233178997433d-1*t16
            t21 = t20+1.0498d-1
            t22 = t21**2
            t23 = 1/t14
            t24 = 6.203504908994001d-1*t23
            t25 = t24+2.935818660072219d+0*t16+1.29352d+1
            t26 = abs(t25)
            t27 = 1/t26
            t28 = log(1.0d+0*t22*t27)
            t29 = abs(t23)
            t30 = log(6.203504908994001d-1*t27*t29)
            t31 = t5**1.3333333333333333d+0+t4**1.3333333333333333d+0-2.
     1         0d+0
            t32 = t17+1.13107d+0
            t33 = atan(7.123108917818117d+0/t32)
            t34 = t20+4.7584000000000004d-3
            t35 = t34**2
            t36 = t24+8.908571061768626d-1*t16+1.30045d+1
            t37 = abs(t36)
            t38 = 1/t37
            t39 = log(1.0d+0*t35*t38)
            t40 = log(6.203504908994001d-1*t29*t38)
            t41 = t2**4
            t42 = 1/t1**4
            t43 = t17+7.06042d+0
            t44 = t20+3.25d-1
            t45 = t44**2
            t46 = t24+5.560951426165704d+0*t16+1.8057800000000002d+1
            t47 = abs(t46)
            t48 = 1/t47
            t49 = 1.709920934161365d+0*(2.2478670955426108d-3*log(1.0d+0
     1         *t45*t48)+1.554535d-2*log(6.203504908994001d-1*t29*t48)+5
     2         .249139316978092d-2*atan(4.7309269095601136d+0/t43)-3.109
     3         07d-2*t30-9.690227711544375d-4*t28-3.8783294878113006d-2*
     4         t19)+1.688686394038963d-2*t40+6.991732350764465d-6*t39+5.
     5         365091848883603d-3*t33
            t50 = t41*t42*t49-1.688686394038963d-2*t40-6.991732350764465
     1         d-6*t39-5.365091848883603d-3*t33
            t51 = 1.1250000000000002d+0*t31*t50+3.10907d-2*t30+9.6902277
     1         11544375d-4*t28+3.8783294878113006d-2*t19
            t52 = exp(-4.0427615117563703d+1*t13*t51)
            t53 = t52-1.0d+0
            t54 = 1/t53
            t55 = 1.7121095002288234d-1*t10*t12*t54*t8
            t56 = t55+1.0d+0
            t57 = t8**2.0d+0
            t58 = 1/t9**4.0d+0
            t59 = 1/t6**4.0d+0
            t60 = 1/t53**2.0d+0
            t61 = 2.931318940773791d-2*t57*t58*t59*t60+t55+1.0d+0
            t62 = 1/t61
            t63 = 1.7121095002288234d-1*t10*t12*t56*t62*t8+1.0d+0
            t64 = log(t63)
            t65 = 1/t1**2
            t66 = t2*t65
            t67 = -t3
            t68 = t67+t66
            t69 = t4**3.333333333333333d-1
            t70 = 1/t69
            t71 = -t2*t65
            t72 = t71+t3
            t73 = t5**3.333333333333333d-1
            t74 = 1/t73
            t75 = 3.333333333333333d-1*t72*t74+3.333333333333333d-1*t68*
     1         t70
            t76 = 2.473556743557577d-2*t64*t7*wght
            t77 = 1/t63
            t78 = t1**1.6666666666666674d-1
            t79 = 1/t9**3.0d+0
            t80 = -3.994922167200588d-1*t12*t56*t62*t78*t79*t8
            t81 = -3.4242190004576467d-1*t10*t13*t54*t75*t8
            t82 = -3.994922167200588d-1*t12*t54*t78*t79*t8
            t83 = 1/t53**2
            t84 = 1/t1**6.666666666666667d-1
            t85 = 1/t15**3
            t86 = 1/t18**2
            t87 = 1/(3.784699104639999d+1*t86+1)
            t88 = 6.264085709464389d-2*t84*t85*t86*t87
            t89 = 1/t22
            t90 = -2.067834969664667d-1/t1**1.3333333333333333d+0
            t91 = t90-4.8930311001203647d-1*t84*t85
            t92 = 1/t25
            t93 = -1.0d+0*t22*t27*t91*t92-2.625411059665811d-1*t21*t27*t
     1         84*t85
            t94 = 9.690227711544375d-4*t26*t89*t93
            t95 = 1/t29
            t96 = 1/t1**1.6666666666666666d+0
            t97 = -2.067834969664667d-1*t27*t95*t96-6.203504908994001d-1
     1         *t27*t29*t91*t92
            t98 = 5.011795824473985d-2*t26*t95*t97
            t99 = 1/t32**2
            t100 = 1/(5.07386806551d+1*t99+1)
            t101 = -1.0033305979455584d-2*t100*t84*t85*t99
            t102 = 1/t35
            t103 = t90-1.4847618436281043d-1*t84*t85
            t104 = 1/t36
            t105 = -2.625411059665811d-1*t34*t38*t84*t85-1.0d+0*t103*t10
     1         4*t35*t38
            t106 = -6.991732350764465d-6*t102*t105*t37
            t107 = -2.067834969664667d-1*t38*t95*t96-6.203504908994001d-
     1         1*t103*t104*t29*t38
            t108 = -2.722148880047894d-2*t107*t37*t95
            t109 = 1/t43**2
            t110 = t90-9.26825237694284d-1*t84*t85
            t111 = 1/t46
            t112 = t41*t42*(1.0033305979455584d-2*t100*t84*t85*t99+1.709
     1         920934161365d+0*(-5.011795824473985d-2*t26*t95*t97+2.5058
     2         979122369923d-2*t47*t95*(-2.067834969664667d-1*t48*t95*t9
     3         6-6.203504908994001d-1*t110*t111*t29*t48)-9.6902277115443
     4         75d-4*t26*t89*t93-6.264085709464389d-2*t84*t85*t86*t87+2.
     5         2478670955426108d-3*t47*(-2.625411059665811d-1*t44*t48*t8
     6         4*t85-1.0d+0*t110*t111*t45*t48)/t45+6.519760588836059d-2*
     7         t109*t84*t85/(2.238166942360001d+1*t109+1))+2.72214888004
     8         7894d-2*t107*t37*t95+6.991732350764465d-6*t102*t105*t37)
            t113 = -4*t41*t49/t1**5
            t114 = t2**3
            t115 = 1.2128284535269111d+2*t51*t59*t75-4.0427615117563703d
     1         +1*t13*(t98+t94+t88+1.1250000000000002d+0*t50*(1.33333333
     2         33333333d+0*t72*t73+1.3333333333333333d+0*t68*t69)+1.1250
     3         000000000002d+0*t31*(4*t114*t42*t49+t113+t112+t108+t106+t
     4         101))
            t116 = -1.7121095002288234d-1*t10*t115*t12*t52*t8*t83
            t117 = 1/t61**2
            t118 = 1/t6**5.0d+0
            t119 = -1.3679488390277694d-1*t57*t59*t60*t78/t9**5.0d+0
            t120 = 1/t53**3.0d+0
            t121 = t66+t3
            t122 = t71+t67
            t123 = 3.333333333333333d-1*t122*t74+3.333333333333333d-1*t1
     1         21*t70
            t124 = -3.4242190004576467d-1*t10*t123*t13*t54*t8
            t125 = 1.2128284535269111d+2*t123*t51*t59-4.0427615117563703
     1         d+1*t13*(t98+t94+t88+1.1250000000000002d+0*t50*(1.3333333
     2         333333333d+0*t122*t73+1.3333333333333333d+0*t121*t69)+1.1
     3         250000000000002d+0*t31*(-4*t114*t42*t49+t113+t112+t108+t1
     4         06+t101))
            t126 = -1.7121095002288234d-1*t10*t12*t125*t52*t8*t83
            t127 = 2.473556743557577d-2*t1*t7*t77*(-1.7121095002288234d-
     1         1*t10*t117*t12*t56*t8*(5.862637881547582d-2*t58*t59*t60*t
     2         8+1.7121095002288234d-1*t10*t12*t54)+2.931318940773791d-2
     3         *t54*t58*t59*t62*t8+1.7121095002288234d-1*t10*t12*t56*t62
     4         )*wght
            fnc(iq) = 2.473556743557577d-2*t1*t64*t7*wght+fnc(iq)
            Amat(iq,D1_RA) = 2.473556743557577d-2*t1*t7*t77*(-1.71210950
     1         02288234d-1*t10*t117*t12*t56*t8*(t82+t81-1.17252757630951
     2         65d-1*t118*t57*t58*t60*t75-5.862637881547582d-2*t115*t120
     3         *t52*t57*t58*t59+t119+t116)+1.7121095002288234d-1*t10*t12
     4         *t62*t8*(t82+t81+t116)+t80-3.4242190004576467d-1*t10*t13*
     5         t56*t62*t75*t8)*wght+7.420670230672731d-2*t1*t11*t64*t75*
     6         wght+t76+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 2.473556743557577d-2*t1*t7*t77*(-1.71210950
     1         02288234d-1*t10*t117*t12*t56*t8*(t82-1.1725275763095165d-
     2         1*t118*t123*t57*t58*t60-5.862637881547582d-2*t120*t125*t5
     3         2*t57*t58*t59+t126+t124+t119)+1.7121095002288234d-1*t10*t
     4         12*t62*t8*(t82+t126+t124)+t80-3.4242190004576467d-1*t10*t
     5         123*t13*t56*t62*t8)*wght+7.420670230672731d-2*t1*t11*t123
     6         *t64*wght+t76+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = t127+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 2.473556743557577d-2*t1*t7*t77*(-1.7121095
     1         002288234d-1*t10*t117*t12*t56*t8*(1.1725275763095165d-1*t
     2         58*t59*t60*t8+3.4242190004576467d-1*t10*t12*t54)+5.862637
     3         881547582d-2*t54*t58*t59*t62*t8+3.4242190004576467d-1*t10
     4         *t12*t56*t62)*wght+Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = t127+Cmat(iq,D1_GBB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**1.1666666666666667d+0
            t2 = 1/t1**2.0d+0
            t3 = rhoa**3.333333333333333d-1
            t4 = t3**5.0d-1
            t5 = 1/t4
            t6 = 1/t3
            t7 = 6.203504908994001d-1*t6
            t8 = t7+2.935818660072219d+0*t5+1.29352d+1
            t9 = abs(t8)
            t10 = 1/t9
            t11 = abs(t6)
            t12 = log(6.203504908994001d-1*t10*t11)
            t13 = 7.876233178997433d-1*t5
            t14 = t13+1.0498d-1
            t15 = t14**2
            t16 = log(1.0d+0*t10*t15)
            t17 = 1.5752466357994865d+0*t5
            t18 = t17+3.72744d+0
            t19 = atan(6.15199081975908d+0/t18)
            t20 = t7+8.908571061768626d-1*t5+1.30045d+1
            t21 = abs(t20)
            t22 = 1/t21
            t23 = log(6.203504908994001d-1*t11*t22)
            t24 = t13+4.7584000000000004d-3
            t25 = t24**2
            t26 = log(1.0d+0*t22*t25)
            t27 = t17+1.13107d+0
            t28 = atan(7.123108917818117d+0/t27)
            t29 = t7+5.560951426165704d+0*t5+1.8057800000000002d+1
            t30 = abs(t29)
            t31 = 1/t30
            t32 = t13+3.25d-1
            t33 = t32**2
            t34 = t17+7.06042d+0
            t35 = exp(-8.085523023512742d+1*(5.848223622634643d-1*(1.0d+
     1         0*(1.709920934161365d+0*(5.249139316978092d-2*atan(4.7309
     2         269095601136d+0/t34)+2.2478670955426108d-3*log(1.0d+0*t31
     3         *t33)+1.554535d-2*log(6.203504908994001d-1*t11*t31)-3.878
     4         3294878113006d-2*t19-9.690227711544375d-4*t16-3.10907d-2*
     5         t12)+5.365091848883603d-3*t28+6.991732350764465d-6*t26+1.
     6         688686394038963d-2*t23)-5.365091848883603d-3*t28-6.991732
     7         350764465d-6*t26-1.688686394038963d-2*t23)+3.878329487811
     8         3006d-2*t19+9.690227711544375d-4*t16+3.10907d-2*t12))
            t36 = t35-1.0d+0
            t37 = 1/t36
            t38 = 2.7178044217479824d-1*gammaaa*t2*t37
            t39 = t38+1.0d+0
            t40 = gammaaa**2.0d+0
            t41 = 1/t1**4.0d+0
            t42 = 1/t36**2.0d+0
            t43 = 7.386460874872887d-2*t40*t41*t42+t38+1.0d+0
            t44 = 1/t43
            t45 = 2.7178044217479824d-1*gammaaa*t2*t39*t44+1.0d+0
            t46 = log(t45)
            t47 = 1/t45
            t48 = rhoa**1.6666666666666674d-1
            t49 = 1/t1**3.0d+0
            t50 = -6.341543650745293d-1*gammaaa*t37*t48*t49
            t51 = 1/t11
            t52 = -2.067834969664667d-1/rhoa**1.3333333333333333d+0
            t53 = 1/t4**3
            t54 = 1/rhoa**6.666666666666667d-1
            t55 = t52-4.8930311001203647d-1*t53*t54
            t56 = 1/t8
            t57 = 1/rhoa**1.6666666666666666d+0
            t58 = -2.067834969664667d-1*t10*t51*t57-6.203504908994001d-1
     1         *t10*t11*t55*t56
            t59 = 1/t18**2
            t60 = 1/(3.784699104639999d+1*t59+1)
            t61 = 1/t15
            t62 = -1.0d+0*t10*t15*t55*t56-2.625411059665811d-1*t10*t14*t
     1         53*t54
            t63 = t52-1.4847618436281043d-1*t53*t54
            t64 = 1/t20
            t65 = -6.203504908994001d-1*t11*t22*t63*t64-2.06783496966466
     1         7d-1*t22*t51*t57
            t66 = 1/t27**2
            t67 = 1/(5.07386806551d+1*t66+1)
            t68 = 1/t25
            t69 = -1.0d+0*t22*t25*t63*t64-2.625411059665811d-1*t22*t24*t
     1         53*t54
            t70 = t52-9.26825237694284d-1*t53*t54
            t71 = 1/t29
            t72 = 1/t34**2
            t73 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-9
     1         .690227711544375d-4*t61*t62*t9-5.011795824473985d-2*t51*t
     2         58*t9+6.519760588836059d-2*t53*t54*t72/(2.238166942360001
     3         d+1*t72+1)+2.2478670955426108d-3*t30*(-1.0d+0*t31*t33*t70
     4         *t71-2.625411059665811d-1*t31*t32*t53*t54)/t33+2.50589791
     5         22369923d-2*t30*t51*(-6.203504908994001d-1*t11*t31*t70*t7
     6         1-2.067834969664667d-1*t31*t51*t57)-6.264085709464389d-2*
     7         t53*t54*t59*t60)+6.991732350764465d-6*t21*t68*t69+1.00333
     8         05979455584d-2*t53*t54*t66*t67+2.722148880047894d-2*t21*t
     9         51*t65)-6.991732350764465d-6*t21*t68*t69-1.00333059794555
     :         84d-2*t53*t54*t66*t67-2.722148880047894d-2*t21*t51*t65)+9
     ;         .690227711544375d-4*t61*t62*t9+5.011795824473985d-2*t51*t
     <         58*t9+6.264085709464389d-2*t53*t54*t59*t60
            t74 = 2.1974870225448048d+1*gammaaa*t2*t35*t73/t36**2
            t75 = 1/t43**2
            fnc(iq) = 1.2367783717787881d-2*rhoa*t46*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.2367783717787881d-2*rhoa*t47*(-2.71780442
     1         17479824d-1*gammaaa*t2*t39*(t74+1.194467989321216d+1*t35*
     2         t40*t41*t73/t36**3.0d+0+t50-3.447015074940681d-1*t40*t42*
     3         t48/t1**5.0d+0)*t75+2.7178044217479824d-1*gammaaa*t2*t44*
     4         (t74+t50)-6.341543650745293d-1*gammaaa*t39*t44*t48*t49)*w
     5         ght+1.2367783717787881d-2*t46*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.2367783717787881d-2*rhoa*t47*(-2.7178044
     1         217479824d-1*gammaaa*t2*t39*(1.4772921749745774d-1*gammaa
     2         a*t41*t42+2.7178044217479824d-1*t2*t37)*t75+7.38646087487
     3         2885d-2*gammaaa*t37*t41*t44+2.7178044217479824d-1*t2*t39*
     4         t44)*wght+Cmat(iq,D1_GAA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**1.1666666666666667d+0
            t2 = 1/t1**2.0d+0
            t3 = rhob**3.333333333333333d-1
            t4 = t3**5.0d-1
            t5 = 1/t4
            t6 = 1/t3
            t7 = 6.203504908994001d-1*t6
            t8 = t7+2.935818660072219d+0*t5+1.29352d+1
            t9 = abs(t8)
            t10 = 1/t9
            t11 = abs(t6)
            t12 = log(6.203504908994001d-1*t10*t11)
            t13 = 7.876233178997433d-1*t5
            t14 = t13+1.0498d-1
            t15 = t14**2
            t16 = log(1.0d+0*t10*t15)
            t17 = 1.5752466357994865d+0*t5
            t18 = t17+3.72744d+0
            t19 = atan(6.15199081975908d+0/t18)
            t20 = t7+8.908571061768626d-1*t5+1.30045d+1
            t21 = abs(t20)
            t22 = 1/t21
            t23 = log(6.203504908994001d-1*t11*t22)
            t24 = t13+4.7584000000000004d-3
            t25 = t24**2
            t26 = log(1.0d+0*t22*t25)
            t27 = t17+1.13107d+0
            t28 = atan(7.123108917818117d+0/t27)
            t29 = t7+5.560951426165704d+0*t5+1.8057800000000002d+1
            t30 = abs(t29)
            t31 = 1/t30
            t32 = t13+3.25d-1
            t33 = t32**2
            t34 = t17+7.06042d+0
            t35 = exp(-8.085523023512742d+1*(5.848223622634643d-1*(1.0d+
     1         0*(1.709920934161365d+0*(5.249139316978092d-2*atan(4.7309
     2         269095601136d+0/t34)+2.2478670955426108d-3*log(1.0d+0*t31
     3         *t33)+1.554535d-2*log(6.203504908994001d-1*t11*t31)-3.878
     4         3294878113006d-2*t19-9.690227711544375d-4*t16-3.10907d-2*
     5         t12)+5.365091848883603d-3*t28+6.991732350764465d-6*t26+1.
     6         688686394038963d-2*t23)-5.365091848883603d-3*t28-6.991732
     7         350764465d-6*t26-1.688686394038963d-2*t23)+3.878329487811
     8         3006d-2*t19+9.690227711544375d-4*t16+3.10907d-2*t12))
            t36 = t35-1.0d+0
            t37 = 1/t36
            t38 = 2.7178044217479824d-1*gammabb*t2*t37
            t39 = t38+1.0d+0
            t40 = gammabb**2.0d+0
            t41 = 1/t1**4.0d+0
            t42 = 1/t36**2.0d+0
            t43 = 7.386460874872887d-2*t40*t41*t42+t38+1.0d+0
            t44 = 1/t43
            t45 = 2.7178044217479824d-1*gammabb*t2*t39*t44+1.0d+0
            t46 = log(t45)
            t47 = 1/t45
            t48 = rhob**1.6666666666666674d-1
            t49 = 1/t1**3.0d+0
            t50 = -6.341543650745293d-1*gammabb*t37*t48*t49
            t51 = 1/t11
            t52 = -2.067834969664667d-1/rhob**1.3333333333333333d+0
            t53 = 1/t4**3
            t54 = 1/rhob**6.666666666666667d-1
            t55 = t52-4.8930311001203647d-1*t53*t54
            t56 = 1/t8
            t57 = 1/rhob**1.6666666666666666d+0
            t58 = -2.067834969664667d-1*t10*t51*t57-6.203504908994001d-1
     1         *t10*t11*t55*t56
            t59 = 1/t18**2
            t60 = 1/(3.784699104639999d+1*t59+1)
            t61 = 1/t15
            t62 = -1.0d+0*t10*t15*t55*t56-2.625411059665811d-1*t10*t14*t
     1         53*t54
            t63 = t52-1.4847618436281043d-1*t53*t54
            t64 = 1/t20
            t65 = -6.203504908994001d-1*t11*t22*t63*t64-2.06783496966466
     1         7d-1*t22*t51*t57
            t66 = 1/t27**2
            t67 = 1/(5.07386806551d+1*t66+1)
            t68 = 1/t25
            t69 = -1.0d+0*t22*t25*t63*t64-2.625411059665811d-1*t22*t24*t
     1         53*t54
            t70 = t52-9.26825237694284d-1*t53*t54
            t71 = 1/t29
            t72 = 1/t34**2
            t73 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-9
     1         .690227711544375d-4*t61*t62*t9-5.011795824473985d-2*t51*t
     2         58*t9+6.519760588836059d-2*t53*t54*t72/(2.238166942360001
     3         d+1*t72+1)+2.2478670955426108d-3*t30*(-1.0d+0*t31*t33*t70
     4         *t71-2.625411059665811d-1*t31*t32*t53*t54)/t33+2.50589791
     5         22369923d-2*t30*t51*(-6.203504908994001d-1*t11*t31*t70*t7
     6         1-2.067834969664667d-1*t31*t51*t57)-6.264085709464389d-2*
     7         t53*t54*t59*t60)+6.991732350764465d-6*t21*t68*t69+1.00333
     8         05979455584d-2*t53*t54*t66*t67+2.722148880047894d-2*t21*t
     9         51*t65)-6.991732350764465d-6*t21*t68*t69-1.00333059794555
     :         84d-2*t53*t54*t66*t67-2.722148880047894d-2*t21*t51*t65)+9
     ;         .690227711544375d-4*t61*t62*t9+5.011795824473985d-2*t51*t
     <         58*t9+6.264085709464389d-2*t53*t54*t59*t60
            t74 = 2.1974870225448048d+1*gammabb*t2*t35*t73/t36**2
            t75 = 1/t43**2
            fnc(iq) = 1.2367783717787881d-2*rhob*t46*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.2367783717787881d-2*rhob*t47*(-2.71780442
     1         17479824d-1*gammabb*t2*t39*(t74+1.194467989321216d+1*t35*
     2         t40*t41*t73/t36**3.0d+0+t50-3.447015074940681d-1*t40*t42*
     3         t48/t1**5.0d+0)*t75+2.7178044217479824d-1*gammabb*t2*t44*
     4         (t74+t50)-6.341543650745293d-1*gammabb*t39*t44*t48*t49)*w
     5         ght+1.2367783717787881d-2*t46*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.2367783717787881d-2*rhob*t47*(-2.7178044
     1         217479824d-1*gammabb*t2*t39*(1.4772921749745774d-1*gammab
     2         b*t41*t42+2.7178044217479824d-1*t2*t37)*t75+7.38646087487
     3         2885d-2*gammabb*t37*t41*t44+2.7178044217479824d-1*t2*t39*
     4         t44)*wght+Cmat(iq,D1_GBB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_p91_vwn5 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_4} &=& 1.0-{\it t_2}\,{\it t_3}\\\\ 
C>   {\it t_5} &=& {\it t_2}\,{\it t_3}+1.0\\\\ 
C>   {\it t_6} &=& 0.5\,{\it t_5}^{{{2}\over{3}}}+0.5\,{
C>    \it t_4}^{{{2}\over{3}}}\\\\ 
C>   {\it t_7} &=& {\it t_6}^{3.0}\\\\ 
C>   {\it t_8} &=& {\it t_1}^{1.166666666666667}\\\\ 
C>   {\it t_9} &=& {{1}\over{{\it t_8}^{2.0}}}\\\\ 
C>   {\it t_{10}} &=& {{1}\over{{\it t_6}^{2.0}}}\\\\ 
C>   {\it t_{11}} &=& \sigma_{\beta\beta}+2.0\,\sigma_{\alpha\beta}
C>    +\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{12}} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_{13}} &=& {{1}\over{\sqrt{{\it t_{12}}}}}\\\\ 
C>   {\it t_{14}} &=& 1.575246635799487\,{\it t_{13}}\\\\ 
C>   {\it t_{15}} &=& \arctan \left({{6.15199081975908}\over{{
C>    \it t_{14}}+3.72744}}\right)\\\\ 
C>   {\it t_{16}} &=& 0.7876233178997433\,{\it t_{13}}\\\\ 
C>   {\it t_{17}} &=& {{1}\over{{\it t_{12}}}}\\\\ 
C>   {\it t_{18}} &=& 0.6203504908994001\,{\it t_{17}}\\\\ 
C>   {\it t_{19}} &=& {{1}\over{\left| 2.935818660072219\,{\it t_{13}}
C>    +{\it t_{18}}+12.9352\right| }}\\\\ 
C>   {\it t_{20}} &=& \log \left(1.0\,\left({\it t_{16}}
C>    +0.10498\right)^2\,{\it t_{19}}\right)\\\\ 
C>   {\it t_{21}} &=& \left| {\it t_{17}}\right| \\\\ 
C>   {\it t_{22}} &=& \log \left(0.6203504908994001\,{\it t_{21}}
C>    \,{\it t_{19}}\right)\\\\ 
C>   {\it t_{23}} &=& \arctan \left({{7.123108917818118}\over{{
C>    \it t_{14}}+1.13107}}\right)\\\\ 
C>   {\it t_{24}} &=& {{1}\over{\left| 0.8908571061768626\,{
C>    \it t_{13}}+{\it t_{18}}+13.0045\right| }}\\\\ 
C>   {\it t_{25}} &=& \log \left(1.0\,\left({\it t_{16}}
C>    +0.0047584\right)^2\,{\it t_{24}}\right)\\\\ 
C>   {\it t_{26}} &=& \log \left(0.6203504908994001\,{\it t_{21}}
C>    \,{\it t_{24}}\right)\\\\ 
C>   {\it t_{27}} &=& {{1}\over{\left| 5.560951426165705\,{\it t_{13}}
C>    +{\it t_{18}}+18.0578\right| }}\\\\ 
C>   {\it t_{28}} &=& {{1}\over{e^{{{40.4276151175637\,\left(1.125
C>    \,\left({\it t_5}^{{{4}\over{3}}}+{\it t_4}^{{{4}\over{3}}}
C>    -2.0\right)\,\left({{{\it t_2}^4\,\left(1.709920934161365
C>    \,\left(0.01554535\,\log \left(0.6203504908994001\,{
C>    \it t_{21}}\,{\it t_{27}}\right)+0.002247867095542611
C>    \,\log \left(1.0\,\left({\it t_{16}}+0.325\right)^2\,{
C>    \it t_{27}}\right)-0.0310907\,{\it t_{22}}
C>    -9.690227711544375 \times 10^{-4}\,{\it t_{20}}
C>    +0.05249139316978092\,\arctan \left({{4.730926909560114}
C>    \over{{\it t_{14}}+7.06042}}\right)-0.03878329487811301\,{
C>    \it t_{15}}\right)+0.01688686394038963\,{\it t_{26}}
C>    +6.991732350764465 \times 10^{-6}\,{\it t_{25}}
C>    +0.005365091848883603\,{\it t_{23}}\right)}\over{{\it t_1}^4}}
C>    -0.01688686394038963\,{\it t_{26}}-6.991732350764465 \times 10^{
C>    -6}\,{\it t_{25}}-0.005365091848883603\,{\it t_{23}}\right)
C>    +0.0310907\,{\it t_{22}}+9.690227711544375 \times 10^{-4}\,{
C>    \it t_{20}}+0.03878329487811301\,{\it t_{15}}\right)}\over{{
C>    \it t_7}}}}}}-1.0\\\\ 
C>   {\it t_{29}} &=& {{0.1712109500228823\,{\it t_9}\,{\it t_{10}}
C>    \,{\it t_{11}}}\over{{\it t_{28}}}}\\\\ 
C>   {\it t_{30}} &=& \rho_s^{1.166666666666667}\\\\ 
C>   {\it t_{31}} &=& {{1}\over{{\it t_{30}}^{2.0}}}\\\\ 
C>   {\it t_{32}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{33}} &=& {{1}\over{\sqrt{{\it t_{32}}}}}\\\\ 
C>   {\it t_{34}} &=& {{1}\over{{\it t_{32}}}}\\\\ 
C>   {\it t_{35}} &=& 0.6203504908994001\,{\it t_{34}}\\\\ 
C>   {\it t_{36}} &=& {{1}\over{\left| {\it t_{35}}
C>    +2.935818660072219\,{\it t_{33}}+12.9352\right| }}\\\\ 
C>   {\it t_{37}} &=& \left| {\it t_{34}}\right| \\\\ 
C>   {\it t_{38}} &=& \log \left(0.6203504908994001\,{\it t_{36}}
C>    \,{\it t_{37}}\right)\\\\ 
C>   {\it t_{39}} &=& 0.7876233178997433\,{\it t_{33}}\\\\ 
C>   {\it t_{40}} &=& \log \left(1.0\,{\it t_{36}}\,\left({\it t_{39}}
C>    +0.10498\right)^2\right)\\\\ 
C>   {\it t_{41}} &=& 1.575246635799487\,{\it t_{33}}\\\\ 
C>   {\it t_{42}} &=& \arctan \left({{6.15199081975908}\over{{
C>    \it t_{41}}+3.72744}}\right)\\\\ 
C>   {\it t_{43}} &=& {{1}\over{\left| {\it t_{35}}
C>    +0.8908571061768626\,{\it t_{33}}+13.0045\right| }}\\\\ 
C>   {\it t_{44}} &=& \log \left(0.6203504908994001\,{\it t_{43}}
C>    \,{\it t_{37}}\right)\\\\ 
C>   {\it t_{45}} &=& \log \left(1.0\,{\it t_{43}}\,\left({\it t_{39}}
C>    +0.0047584\right)^2\right)\\\\ 
C>   {\it t_{46}} &=& \arctan \left({{7.123108917818118}\over{{
C>    \it t_{41}}+1.13107}}\right)\\\\ 
C>   {\it t_{47}} &=& {{1}\over{\left| {\it t_{35}}
C>    +5.560951426165705\,{\it t_{33}}+18.0578\right| }}\\\\ 
C>   {\it t_{48}} &=& {{1}\over{e^{80.85523023512742\,
C>    \left(0.5848223622634643\,\left(1.0\,\left(1.709920934161365
C>    \,\left(0.05249139316978092\,\arctan 
C>    \left({{4.730926909560114}\over{{\it t_{41}}+7.06042}}\right)
C>    -0.03878329487811301\,{\it t_{42}}+0.002247867095542611
C>    \,\log \left(1.0\,{\it t_{47}}\,\left({\it t_{39}}
C>    +0.325\right)^2\right)-9.690227711544375 \times 10^{-4}\,{
C>    \it t_{40}}+0.01554535\,\log \left(0.6203504908994001\,{
C>    \it t_{47}}\,{\it t_{37}}\right)-0.0310907\,{\it t_{38}}\right)
C>    +0.005365091848883603\,{\it t_{46}}
C>    +6.991732350764465 \times 10^{-6}\,{\it t_{45}}
C>    +0.01688686394038963\,{\it t_{44}}\right)-0.005365091848883603
C>    \,{\it t_{46}}-6.991732350764465 \times 10^{-6}\,{\it t_{45}}
C>    -0.01688686394038963\,{\it t_{44}}\right)+0.03878329487811301
C>    \,{\it t_{42}}+9.690227711544375 \times 10^{-4}\,{\it t_{40}}
C>    +0.0310907\,{\it t_{38}}\right)}}}-1.0\\\\ 
C>   {\it t_{49}} &=& {{0.2717804421747982\,{\it t_{31}}\,
C>    \sigma_{ss}}\over{{\it t_{48}}}}\\\\ 
C>   f &=& 0.02473556743557577\,{\it t_1}\,{\it t_7}\,\log 
C>    \left({{0.1712109500228823\,{\it t_9}\,{\it t_{10}}\,{
C>    \it t_{11}}\,\left({\it t_{29}}+1.0\right)}
C>    \over{{{0.02931318940773791\,{\it t_{11}}^{2.0}}\over{{
C>    \it t_8}^{4.0}\,{\it t_6}^{4.0}\,{\it t_{28}}^{2.0}}}+{
C>    \it t_{29}}+1.0}}+1.0\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 0.01236778371778788\,\rho_s\,\log 
C>    \left({{0.2717804421747982\,{\it t_{31}}\,\sigma_{ss}\,
C>    \left({\it t_{49}}+1.0\right)}\over{{{0.07386460874872887
C>    \,\sigma_{ss}^{2.0}}\over{{\it t_{30}}^{4.0}\,{
C>    \it t_{48}}^{2.0}}}+{\it t_{49}}+1.0}}+1.0\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] unpublished , DOI: 
C> <a href="https://doi.org/unpublished "> 
C> unpublished </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_p91_vwn5_d2(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Amat2,Cmat,Cmat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,*)  !< [Output] The 2nd derivative wrt rgamma 
                                    !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**1.1666666666666667d+0
            t2 = 1/t1**2.0d+0
            t3 = rhoa**3.333333333333333d-1
            t4 = t3**5.0d-1
            t5 = 1/t4
            t6 = 1/t3
            t7 = 4.9237251092134837d-1*t6
            t8 = 1/abs(t7+2.615517080950829d+0*t5+1.29352d+1)
            t9 = abs(t6)
            t10 = exp(-4.0427615117563703d+1*(3.10907d-2*log(4.923725109
     1         2134837d-1*t8*t9)+9.690227711544375d-4*log(1.0d+0*(7.0169
     2         26042943223d-1*t5+1.0498d-1)**2*t8)+3.8783294878113006d-2
     3         *atan(6.15199081975908d+0/(1.4033852085886447d+0*t5+3.727
     4         44d+0))))-1.0d+0
            t11 = 1.358902210873991d-1*gammaaa*t2/t10
            t12 = gammaaa**2.0d+0
            t13 = 1/t1**4.0d+0
            t14 = t7+2.615517080950828d+0*t5+1.29352d+1
            t15 = abs(t14)
            t16 = 1/t15
            t17 = 7.016926042943222d-1*t5
            t18 = t17+1.0498d-1
            t19 = t18**2
            t20 = 1.4033852085886445d+0*t5
            t21 = t20+3.72744d+0
            t22 = 3.10907d-2*log(4.9237251092134837d-1*t16*t9)+3.8783294
     1         878113006d-2*atan(6.15199081975908d+0/t21)+9.690227711544
     2         375d-4*log(1.0d+0*t16*t19)
            t23 = exp(-4.0427615117563703d+1*t22)
            t24 = t23-1.0d+0
            t25 = 1/t24
            t26 = 1.3589022108739912d-1*gammaaa*t2*t25
            t27 = t26+1.0d+0
            t28 = 1/t24**2.0d+0
            t29 = 1.846615218718221d-2*t12*t13*t28+t26+1.0d+0
            t30 = 1/t29
            t31 = 1.3589022108739912d-1*gammaaa*t2*t27*t30+1.0d+0
            t32 = 1/t31
            t33 = rhoa**1.6666666666666674d-1
            t34 = 1/t1**3.0d+0
            t35 = -1.585385912686323d-1*gammaaa*t25*t33*t34
            t36 = 1/t9
            t37 = 1/t4**3
            t38 = 1/rhoa**6.666666666666667d-1
            t39 = -2.1795975674590234d-1*t37*t38-8.206208515355806d-2/rh
     1         oa**1.3333333333333333d+0
            t40 = 1/t14
            t41 = 1/rhoa**1.6666666666666666d+0
            t42 = -4.9237251092134837d-1*t16*t39*t40*t9-8.20620851535580
     1         6d-2*t16*t36*t41
            t43 = 1/t21**2
            t44 = 3.784699104639999d+1*t43+1
            t45 = 1/t44
            t46 = 1/t19
            t47 = -1.0d+0*t16*t19*t39*t40-1.1694876738238703d-1*t16*t18*
     1         t37*t38
            t48 = 9.690227711544375d-4*t15*t46*t47+2.790332964441521d-2*
     1         t37*t38*t43*t45+6.314467057030004d-2*t15*t36*t42
            t49 = 1/t24**2
            t50 = 5.493717556362011d+0*gammaaa*t2*t23*t48*t49
            t51 = t50+t35
            t52 = 1/t29**2
            t53 = 1/t1**5.0d+0
            t54 = 1/t24**3.0d+0
            t55 = 1.4930849866515192d+0*t12*t13*t23*t48*t54-4.3087688436
     1         7585d-2*t12*t28*t33*t53+t50+t35
            t56 = -1.3589022108739912d-1*gammaaa*t2*t27*t52*t55+1.358902
     1         2108739912d-1*gammaaa*t2*t30*t51-1.585385912686323d-1*gam
     2         maaa*t27*t30*t33*t34
            t57 = log(t31)
            t58 = 9.233076093591105d-3*gammaaa*t13*t28+3.397255527184978
     1         d-2*t2*t25
            t59 = -1.3589022108739912d-1*gammaaa*t2*t27*t52*t58+3.397255
     1         527184978d-2*t2*t27*t30+4.6165380467955525d-3*gammaaa*t13
     2         *t25*t30
            t60 = 1.846615218718221d-2*gammaaa*t13*t28+6.794511054369956
     1         d-2*t2*t25
            t61 = -1.3589022108739912d-1*gammaaa*t2*t27*t52*t60+6.794511
     1         054369956d-2*t2*t27*t30+9.233076093591105d-3*gammaaa*t13*
     2         t25*t30
            t62 = 1/t31**2
            t63 = -4.947113487115154d-2*rhoa*t56**2*t62*wght
            t64 = 1/rhoa
            t65 = 4.947113487115154d-2*t56*wght
            t66 = rhoa**3.333333333333335d-1
            t67 = 2.774425347201065d-1*gammaaa*t13*t27*t30*t66
            t68 = 1/rhoa**8.333333333333333d-1
            t69 = -1.3211549272386033d-2*gammaaa*t27*t30*t34*t68
            t70 = 1/rhoa**2
            t71 = -3.170771825372646d-1*gammaaa*t30*t33*t34*t51
            t72 = 3.170771825372646d-1*gammaaa*t27*t33*t34*t52*t55
            t73 = -2.7178044217479824d-1*gammaaa*t2*t51*t52*t55
            t74 = t48**2
            t75 = exp(-8.085523023512741d+1*t22)
            t76 = 4.441957978664119d+2*gammaaa*t2*t74*t75/t24**3
            t77 = 2.774425347201065d-1*gammaaa*t13*t25*t66
            t78 = -1.3211549272386033d-2*gammaaa*t25*t34*t68
            t79 = 1.5098913454155452d-2*gammaaa*t2*t25*t70
            t80 = -1.2818674298178023d+1*gammaaa*t23*t33*t34*t48*t49
            t81 = -2.2209789893320595d+2*gammaaa*t2*t23*t49*t74
            t82 = 1/rhoa**2.3333333333333334d+0
            t83 = -2.470091445929572d-1*t82/(t21**5*t44**2)
            t84 = 6.526520015557556d-3*t45*t82/t21**3
            t85 = 1/abs(t7+7.93663453939179d-1*t5+1.30045d+1)
            t86 = -1.688686394038963d-2*log(4.9237251092134837d-1*t85*t9
     1         )-6.991732350764465d-6*log(1.0d+0*(t17+4.7584000000000004
     2         d-3)**2*t85)-5.365091848883603d-3*atan(7.123108917818117d
     3         +0/(t20+1.13107d+0))
            t87 = 1/rhoa**1.6666666666666669d+0
            t88 = -9.301109881471736d-3*t37*t43*t45*t87
            t89 = t39**2
            t90 = 1/t14**2
            t91 = 1/t4**5
            t92 = 1/rhoa**1.3333333333333336d+0
            t93 = 5.448993918647558d-2*t91*t92+7.265325224863413d-2*t37*
     1         t87+5.470805676903872d-2/rhoa**2.333333333333333d+0
            t94 = 6.314467057030004d-2*t15*t36*(-4.9237251092134837d-1*t
     1         16*t40*t9*t93+9.847450218426967d-1*t16*t89*t9*t90+1.64124
     2         17030711612d-1*t16*t36*t39*t40*t41+5.470805676903869d-2*t
     3         16*t36/rhoa**2.6666666666666666d+0)
            t95 = -6.975832411103801d-3*t43*t45*t91*t92
            t96 = 1.0524111761716676d-2*t15*t36*t42/rhoa**9.999999999999
     1         999d-1
            t97 = 1.1332601865197636d-4*t15*t37*t38*t47/t18**3
            t98 = 9.690227711544375d-4*t15*t46*(-1.0d+0*t16*t19*t40*t93+
     1         2.923719184559675d-2*t16*t18*t91*t92+2.0d+0*t16*t19*t89*t
     2         90+3.898292246079568d-2*t16*t18*t37*t87+6.838507096129838
     3         d-3*t16*t82+2.3389753476477407d-1*t16*t18*t37*t38*t39*t40
     4         )
            t99 = 6.314467057030004d-2*t14*t16*t36*t39*t42
            t100 = 9.690227711544375d-4*t14*t16*t39*t46*t47
            t101 = -4.0427615117563703d+1*(t99+t98+t97+t96+t95+t94+t88+2
     1         .5000000000000006d-1*t70*t86+t84+t83+t100)-6.737935852927
     2         281d+0*t22*t70
            t102 = -1.3589022108739912d-1*gammaaa*t101*t2*t23*t49
            t103 = 1.8108559553448106d+2*t12*t13*t74*t75/t24**4.0d+0
            t104 = 1/t1**6.0d+0
            t105 = 1.256724246072123d-1*t104*t12*t28*t66
            t106 = -3.59064070306321d-3*t12*t28*t53*t68
            t107 = -6.96772993770709d+0*t12*t23*t33*t48*t53*t54
            t108 = -6.036186517816036d+1*t12*t13*t23*t54*t74
            t109 = 1/t29**3
            t110 = 2.7178044217479824d-1*gammaaa*t109*t2*t27*t55**2
            t111 = -1.5098913454155458d-2*gammaaa*t2*t25*t70
            t112 = 6.737935852927284d+0*t22*t70-4.0427615117563703d+1*(t
     1         99+t98+t97+t96+t95+t94+t88-2.5000000000000006d-1*t70*t86+
     2         t84+t83+t100)
            t113 = -1.3589022108739912d-1*gammaaa*t112*t2*t23*t49
            t114 = -3.9634647817158075d-2*t25*t33*t34
            t115 = 1.3734293890905028d+0*t2*t23*t48*t49
            t116 = t32*(2.473556743557577d-2*t59*wght+4.947113487115154d
     1         -2*rhoa*(2.7178044217479824d-1*gammaaa*t109*t2*t27*t55*t5
     2         8-1.3589022108739912d-1*gammaaa*t2*t51*t52*t58+1.58538591
     3         2686323d-1*gammaaa*t27*t33*t34*t52*t58-3.397255527184978d
     4         -2*t2*t27*t52*t55-4.6165380467955525d-3*gammaaa*t13*t25*t
     5         52*t55-1.3589022108739912d-1*gammaaa*t2*t27*t52*(7.465424
     6         933257596d-1*gammaaa*t13*t23*t48*t54-2.154384421837925d-2
     7         *gammaaa*t28*t33*t53+t115+t114)-5.385961054594812d-3*gamm
     8         aaa*t25*t30*t33*t53+3.397255527184978d-2*t2*t30*t51-3.963
     9         4647817158075d-2*t27*t30*t33*t34+1.3589022108739912d-1*ga
     :         mmaaa*(t115+t114)*t2*t30)*wght)-4.947113487115154d-2*rhoa
     ;         *t56*t59*t62*wght
            t117 = -7.926929563431615d-2*t25*t33*t34
            t118 = 2.7468587781810055d+0*t2*t23*t48*t49
            t119 = -6.794511054369956d-2*t2*t27*t52*t58
            t120 = -9.233076093591105d-3*gammaaa*t13*t25*t52*t58
            t121 = 4.947113487115154d-2*rhoa*t32*(2.7178044217479824d-1*
     1         gammaaa*t109*t2*t27*t58**2-3.1367118791871873d-4*gammaaa*
     2         t104*t27*t28*t52+2.3082690233977762d-3*t13*t25*t30+t120+t
     3         119)*wght-4.947113487115154d-2*rhoa*t59**2*t62*wght
            fnc(iq) = 4.947113487115154d-2*rhoa*log(1.358902210873991d-1
     1         *gammaaa*(t11+1.0d+0)*t2/(1.8466152187182203d-2*t12*t13/t
     2         10**2.0d+0+t11+1.0d+0)+1.0d+0)*wght+fnc(iq)
            Amat(iq,D1_RA) = 2.473556743557577d-2*t57*wght+4.94711348711
     1         5154d-2*rhoa*t32*t56*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 4.947113487115154d-2*rhoa*t32*t59*wght+Cma
     1         t(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 4.947113487115154d-2*rhoa*t32*t61*wght+Cma
     1         t(iq,D1_GAB)
            Amat2(iq,D2_RA_RA) = t32*(4.947113487115154d-2*rhoa*(-1.3589
     1         022108739912d-1*gammaaa*t2*t27*t52*(t81+t80+t79+t78+t77+t
     2         76+4.103589374929379d-3*t12*t13*t28*t70-3.693230437436442
     3         d-2*t101*t12*t13*t23*t54+t108+t107+t106+t105+t103+t102)+1
     4         .3589022108739912d-1*gammaaa*t2*t30*(t81+t80+t79+t78+t77+
     5         t76+t102)+t73+t72+t71+1.5098913454155452d-2*gammaaa*t2*t2
     6         7*t30*t70+t69+t67+t110)*wght+t65)-8.245189145191921d-3*t5
     7         7*t64*wght+t63+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = t32*(4.947113487115154d-2*rhoa*(-1.3589
     1         022108739912d-1*gammaaa*t2*t27*t52*(t81+t80+t78+t77+t76-4
     2         .1035893749293795d-3*t12*t13*t28*t70-3.693230437436442d-2
     3         *t112*t12*t13*t23*t54+t113+t111+t108+t107+t106+t105+t103)
     4         +1.3589022108739912d-1*gammaaa*t2*t30*(t81+t80+t78+t77+t7
     5         6+t113+t111)+t73+t72+t71-1.5098913454155458d-2*gammaaa*t2
     6         *t27*t30*t70+t69+t67+t110)*wght+t65)+8.245189145191922d-3
     7         *t57*t64*wght+t63+Amat2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = t116+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = t32*(2.473556743557577d-2*t61*wght+4.9
     1         47113487115154d-2*rhoa*(2.7178044217479824d-1*gammaaa*t10
     2         9*t2*t27*t55*t60-1.3589022108739912d-1*gammaaa*t2*t51*t52
     3         *t60+1.585385912686323d-1*gammaaa*t27*t33*t34*t52*t60-6.7
     4         94511054369956d-2*t2*t27*t52*t55-9.233076093591105d-3*gam
     5         maaa*t13*t25*t52*t55-1.3589022108739912d-1*gammaaa*t2*t27
     6         *t52*(1.4930849866515192d+0*gammaaa*t13*t23*t48*t54-4.308
     7         76884367585d-2*gammaaa*t28*t33*t53+t118+t117)-1.077192210
     8         9189624d-2*gammaaa*t25*t30*t33*t53+6.794511054369956d-2*t
     9         2*t30*t51-7.926929563431615d-2*t27*t30*t33*t34+1.35890221
     :         08739912d-1*gammaaa*(t118+t117)*t2*t30)*wght)-4.947113487
     ;         115154d-2*rhoa*t56*t61*t62*wght+Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = t116+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = t121+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = -4.947113487115154d-2*rhoa*t59*t61*t6
     1         2*wght+4.947113487115154d-2*rhoa*t32*(2.7178044217479824d
     2         -1*gammaaa*t109*t2*t27*t58*t60-3.397255527184978d-2*t2*t2
     3         7*t52*t60-4.6165380467955525d-3*gammaaa*t13*t25*t52*t60-6
     4         .273423758374375d-4*gammaaa*t104*t27*t28*t52+4.6165380467
     5         955525d-3*t13*t25*t30+t120+t119)*wght+Cmat2(iq,D2_GAA_GAB
     6         )
            Cmat2(iq,D2_GAA_GBB) = t121+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = -4.947113487115154d-2*rhoa*t61**2*t62
     1         *wght+4.947113487115154d-2*rhoa*t32*(2.7178044217479824d-
     2         1*gammaaa*t109*t2*t27*t60**2-1.3589022108739912d-1*t2*t27
     3         *t52*t60-1.846615218718221d-2*gammaaa*t13*t25*t52*t60-1.2
     4         54684751674875d-3*gammaaa*t104*t27*t28*t52+9.233076093591
     5         105d-3*t13*t25*t30)*wght+Cmat2(iq,D2_GAB_GAB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = rhoa-rhob
            t3 = 1/t1
            t4 = 1.0d+0-t2*t3
            t5 = t4**6.666666666666666d-1
            t6 = t2*t3+1.0d+0
            t7 = t6**6.666666666666666d-1
            t8 = 5.0d-1*t7+5.0d-1*t5
            t9 = t8**3.0d+0
            t10 = gammabb+2.0d+0*gammaab+gammaaa
            t11 = t1**1.1666666666666667d+0
            t12 = 1/t11**2.0d+0
            t13 = t8**2.0d+0
            t14 = 1/t13
            t15 = 1/t9
            t16 = t1**3.333333333333333d-1
            t17 = t16**5.0d-1
            t18 = 1/t17
            t19 = 1.5752466357994865d+0*t18
            t20 = t19+3.72744d+0
            t21 = atan(6.15199081975908d+0/t20)
            t22 = 7.876233178997433d-1*t18
            t23 = t22+1.0498d-1
            t24 = t23**2
            t25 = 1/t16
            t26 = 6.203504908994001d-1*t25
            t27 = t26+2.935818660072219d+0*t18+1.29352d+1
            t28 = abs(t27)
            t29 = 1/t28
            t30 = log(1.0d+0*t24*t29)
            t31 = abs(t25)
            t32 = log(6.203504908994001d-1*t29*t31)
            t33 = t4**1.3333333333333333d+0
            t34 = t6**1.3333333333333333d+0
            t35 = t34+t33-2.0d+0
            t36 = t19+1.13107d+0
            t37 = atan(7.123108917818117d+0/t36)
            t38 = t22+4.7584000000000004d-3
            t39 = t38**2
            t40 = t26+8.908571061768626d-1*t18+1.30045d+1
            t41 = abs(t40)
            t42 = 1/t41
            t43 = log(1.0d+0*t39*t42)
            t44 = log(6.203504908994001d-1*t31*t42)
            t45 = t2**4
            t46 = 1/t1**4
            t47 = t19+7.06042d+0
            t48 = t22+3.25d-1
            t49 = t48**2
            t50 = t26+5.560951426165704d+0*t18+1.8057800000000002d+1
            t51 = abs(t50)
            t52 = 1/t51
            t53 = 1.709920934161365d+0*(2.2478670955426108d-3*log(1.0d+0
     1         *t49*t52)+1.554535d-2*log(6.203504908994001d-1*t31*t52)+5
     2         .249139316978092d-2*atan(4.7309269095601136d+0/t47)-3.109
     3         07d-2*t32-9.690227711544375d-4*t30-3.8783294878113006d-2*
     4         t21)+1.688686394038963d-2*t44+6.991732350764465d-6*t43+5.
     5         365091848883603d-3*t37
            t54 = t45*t46*t53-1.688686394038963d-2*t44-6.991732350764465
     1         d-6*t43-5.365091848883603d-3*t37
            t55 = 1.1250000000000002d+0*t35*t54+3.10907d-2*t32+9.6902277
     1         11544375d-4*t30+3.8783294878113006d-2*t21
            t56 = exp(-4.0427615117563703d+1*t15*t55)
            t57 = t56-1.0d+0
            t58 = 1/t57
            t59 = 1.7121095002288234d-1*t10*t12*t14*t58
            t60 = t59+1.0d+0
            t61 = t10**2.0d+0
            t62 = 1/t11**4.0d+0
            t63 = 1/t8**4.0d+0
            t64 = 1/t57**2.0d+0
            t65 = 2.931318940773791d-2*t61*t62*t63*t64+t59+1.0d+0
            t66 = 1/t65
            t67 = 1.7121095002288234d-1*t10*t12*t14*t60*t66+1.0d+0
            t68 = log(t67)
            t69 = 1/t1**2
            t70 = t2*t69
            t71 = -t3
            t72 = t71+t70
            t73 = t4**3.333333333333333d-1
            t74 = 1/t73
            t75 = -t2*t69
            t76 = t75+t3
            t77 = t6**3.333333333333333d-1
            t78 = 1/t77
            t79 = 3.333333333333333d-1*t76*t78+3.333333333333333d-1*t72*
     1         t74
            t80 = 2.473556743557577d-2*t68*t9*wght
            t81 = 1/t67
            t82 = t1**1.6666666666666674d-1
            t83 = 1/t11**3.0d+0
            t84 = -3.994922167200588d-1*t10*t14*t60*t66*t82*t83
            t85 = -3.4242190004576467d-1*t10*t12*t15*t58*t79
            t86 = -3.994922167200588d-1*t10*t14*t58*t82*t83
            t87 = 1/t57**2
            t88 = 1/t1**6.666666666666667d-1
            t89 = 1/t17**3
            t90 = 1/t20**2
            t91 = 3.784699104639999d+1*t90+1
            t92 = 1/t91
            t93 = 6.264085709464389d-2*t88*t89*t90*t92
            t94 = 1/t24
            t95 = -2.067834969664667d-1/t1**1.3333333333333333d+0
            t96 = t95-4.8930311001203647d-1*t88*t89
            t97 = 1/t27
            t98 = -1.0d+0*t24*t29*t96*t97-2.625411059665811d-1*t23*t29*t
     1         88*t89
            t99 = 9.690227711544375d-4*t28*t94*t98
            t100 = 1/t31
            t101 = 1/t1**1.6666666666666666d+0
            t102 = -6.203504908994001d-1*t29*t31*t96*t97-2.0678349696646
     1         67d-1*t100*t101*t29
            t103 = 5.011795824473985d-2*t100*t102*t28
            t104 = 1/t36**2
            t105 = 5.07386806551d+1*t104+1
            t106 = 1/t105
            t107 = -1.0033305979455584d-2*t104*t106*t88*t89
            t108 = 1/t39
            t109 = t95-1.4847618436281043d-1*t88*t89
            t110 = 1/t40
            t111 = -2.625411059665811d-1*t38*t42*t88*t89-1.0d+0*t109*t11
     1         0*t39*t42
            t112 = -6.991732350764465d-6*t108*t111*t41
            t113 = -6.203504908994001d-1*t109*t110*t31*t42-2.06783496966
     1         4667d-1*t100*t101*t42
            t114 = -2.722148880047894d-2*t100*t113*t41
            t115 = 1/t47**2
            t116 = 2.238166942360001d+1*t115+1
            t117 = 1/t116
            t118 = 1/t49
            t119 = t95-9.26825237694284d-1*t88*t89
            t120 = 1/t50
            t121 = -2.625411059665811d-1*t48*t52*t88*t89-1.0d+0*t119*t12
     1         0*t49*t52
            t122 = -6.203504908994001d-1*t119*t120*t31*t52-2.06783496966
     1         4667d-1*t100*t101*t52
            t123 = 1.709920934161365d+0*(-9.690227711544375d-4*t28*t94*t
     1         98-6.264085709464389d-2*t88*t89*t90*t92+6.519760588836059
     2         d-2*t115*t117*t88*t89+2.5058979122369923d-2*t100*t122*t51
     3         +2.2478670955426108d-3*t118*t121*t51-5.011795824473985d-2
     4         *t100*t102*t28)+1.0033305979455584d-2*t104*t106*t88*t89+2
     5         .722148880047894d-2*t100*t113*t41+6.991732350764465d-6*t1
     6         08*t111*t41
            t124 = t123*t45*t46
            t125 = 1/t1**5
            t126 = -4*t125*t45*t53
            t127 = t2**3
            t128 = 4*t127*t46*t53+t126+t124+t114+t112+t107
            t129 = 1.3333333333333333d+0*t76*t77+1.3333333333333333d+0*t
     1         72*t73
            t130 = t99+t93+1.1250000000000002d+0*t129*t54+1.125000000000
     1         0002d+0*t128*t35+t103
            t131 = 1.2128284535269111d+2*t55*t63*t79-4.0427615117563703d
     1         +1*t130*t15
            t132 = -1.7121095002288234d-1*t10*t12*t131*t14*t56*t87
            t133 = t86+t85+t132
            t134 = 1/t65**2
            t135 = 1/t8**5.0d+0
            t136 = 1/t11**5.0d+0
            t137 = -1.3679488390277694d-1*t136*t61*t63*t64*t82
            t138 = 1/t57**3.0d+0
            t139 = t86+t85-1.1725275763095165d-1*t135*t61*t62*t64*t79-5.
     1         862637881547582d-2*t131*t138*t56*t61*t62*t63+t137+t132
            t140 = t84-3.4242190004576467d-1*t10*t12*t15*t60*t66*t79+1.7
     1         121095002288234d-1*t10*t12*t133*t14*t66-1.712109500228823
     2         4d-1*t10*t12*t134*t139*t14*t60
            t141 = t70+t3
            t142 = t75+t71
            t143 = 3.333333333333333d-1*t142*t78+3.333333333333333d-1*t1
     1         41*t74
            t144 = -3.4242190004576467d-1*t10*t12*t143*t15*t58
            t145 = -4*t127*t46*t53+t126+t124+t114+t112+t107
            t146 = 1.3333333333333333d+0*t142*t77+1.3333333333333333d+0*
     1         t141*t73
            t147 = t99+t93+1.1250000000000002d+0*t146*t54+1.125000000000
     1         0002d+0*t145*t35+t103
            t148 = 1.2128284535269111d+2*t143*t55*t63-4.0427615117563703
     1         d+1*t147*t15
            t149 = -1.7121095002288234d-1*t10*t12*t14*t148*t56*t87
            t150 = t86+t149+t144
            t151 = t86-1.1725275763095165d-1*t135*t143*t61*t62*t64-5.862
     1         637881547582d-2*t138*t148*t56*t61*t62*t63+t149+t144+t137
            t152 = t84-3.4242190004576467d-1*t10*t12*t143*t15*t60*t66+1.
     1         7121095002288234d-1*t10*t12*t14*t150*t66-1.71210950022882
     2         34d-1*t10*t12*t134*t14*t151*t60
            t153 = 5.862637881547582d-2*t10*t62*t63*t64+1.71210950022882
     1         34d-1*t12*t14*t58
            t154 = 2.931318940773791d-2*t10*t58*t62*t63*t66+1.7121095002
     1         288234d-1*t12*t14*t60*t66-1.7121095002288234d-1*t10*t12*t
     2         134*t14*t153*t60
            t155 = 2.473556743557577d-2*t1*t154*t81*t9*wght
            t156 = 1.1725275763095165d-1*t10*t62*t63*t64+3.4242190004576
     1         467d-1*t12*t14*t58
            t157 = 5.862637881547582d-2*t10*t58*t62*t63*t66+3.4242190004
     1         576467d-1*t12*t14*t60*t66-1.7121095002288234d-1*t10*t12*t
     2         134*t14*t156*t60
            t158 = t79**2
            t159 = t72**2
            t160 = 1/t33
            t161 = 1/t1**3
            t162 = -2*t161*t2
            t163 = 2*t69
            t164 = t163+t162
            t165 = t76**2
            t166 = 1/t34
            t167 = 2*t161*t2
            t168 = -2*t69
            t169 = t168+t167
            t170 = 3.333333333333333d-1*t169*t78+3.333333333333333d-1*t1
     1         64*t74-1.111111111111111d-1*t165*t166-1.111111111111111d-
     2         1*t159*t160
            t171 = 1/t67**2
            t172 = t1**3.333333333333335d-1
            t173 = 1.398222758520206d+0*t10*t14*t172*t60*t62*t66
            t174 = 1/t1**8.333333333333333d-1
            t175 = -6.658203612000984d-2*t10*t14*t174*t60*t66*t83
            t176 = 1/t65**3
            t177 = 1.027265700137294d+0*t10*t12*t158*t58*t63
            t178 = -3.4242190004576467d-1*t10*t12*t15*t170*t58
            t179 = 1.5979688668802353d+0*t10*t15*t58*t79*t82*t83
            t180 = 1.398222758520206d+0*t10*t14*t172*t58*t62
            t181 = -6.658203612000984d-2*t10*t14*t174*t58*t83
            t182 = exp(-8.085523023512741d+1*t15*t55)
            t183 = 1/t57**3
            t184 = t131**2
            t185 = 3.4242190004576467d-1*t10*t12*t14*t182*t183*t184
            t186 = -1.7121095002288234d-1*t10*t12*t14*t184*t56*t87
            t187 = 1/t1**2.3333333333333334d+0
            t188 = 1/t20**5
            t189 = 1/t91**2
            t190 = -1.2448480831567728d+0*t187*t188*t189
            t191 = 1/t20**3
            t192 = 3.289159980064472d-2*t187*t191*t92
            t193 = 1/t1**1.3333333333333336d+0
            t194 = 1/t17**5
            t195 = -3.1320428547321943d-2*t193*t194*t90*t92
            t196 = 1/t1**1.6666666666666669d+0
            t197 = -4.176057139642926d-2*t196*t89*t90*t92
            t198 = 9.690227711544375d-4*t27*t29*t94*t96*t98
            t199 = 5.011795824473985d-2*t100*t102*t27*t29*t96
            t200 = t96**2
            t201 = 1/t27**2
            t202 = 2.7571132928862224d-1/t1**2.333333333333333d+0
            t203 = 3.262020733413577d-1*t196*t89+t202+2.4465155500601823
     1         d-1*t193*t194
            t204 = 5.250822119331622d-1*t23*t29*t88*t89*t96*t97-1.0d+0*t
     1         203*t24*t29*t97+1.7502740397772074d-1*t196*t23*t29*t89+2.
     2         0d+0*t200*t201*t24*t29+1.3127055298329054d-1*t193*t194*t2
     3         3*t29+3.446391616107778d-2*t187*t29
            t205 = 9.690227711544375d-4*t204*t28*t94
            t206 = 1/t23**3
            t207 = 2.544083100456872d-4*t206*t28*t88*t89*t98
            t208 = 1/t1**2.6666666666666666d+0
            t209 = 4.135669939329334d-1*t100*t101*t29*t96*t97-6.20350490
     1         8994001d-1*t203*t29*t31*t97+1.2407009817988002d+0*t200*t2
     2         01*t29*t31+2.7571132928862224d-1*t100*t208*t29
            t210 = 5.011795824473985d-2*t100*t209*t28
            t211 = 1/t1**9.999999999999999d-1
            t212 = 1.670598608157995d-2*t100*t102*t211*t28
            t213 = 1/t36**5
            t214 = 1/t105**2
            t215 = 2.6730712388370664d-1*t187*t213*t214
            t216 = 1/t36**3
            t217 = -5.26831049669476d-3*t106*t187*t216
            t218 = 5.016652989727792d-3*t104*t106*t193*t194
            t219 = 6.68887065297039d-3*t104*t106*t196*t89
            t220 = -6.991732350764465d-6*t108*t109*t111*t40*t42
            t221 = -2.722148880047894d-2*t100*t109*t113*t40*t42
            t222 = t109**2
            t223 = 1/t40**2
            t224 = 9.89841229085403d-2*t196*t89+t202+7.423809218140521d-
     1         2*t193*t194
            t225 = 5.250822119331622d-1*t109*t110*t38*t42*t88*t89+1.7502
     1         740397772074d-1*t196*t38*t42*t89-1.0d+0*t110*t224*t39*t42
     2         +2.0d+0*t222*t223*t39*t42+1.3127055298329054d-1*t193*t194
     3         *t38*t42+3.446391616107778d-2*t187*t42
            t226 = -6.991732350764465d-6*t108*t225*t41
            t227 = 1/t38**3
            t228 = -1.8356171439920266d-6*t111*t227*t41*t88*t89
            t229 = -6.203504908994001d-1*t110*t224*t31*t42+1.24070098179
     1         88002d+0*t222*t223*t31*t42+2.7571132928862224d-1*t100*t20
     2         8*t42+4.135669939329334d-1*t100*t101*t109*t110*t42
            t230 = -2.722148880047894d-2*t100*t229*t41
            t231 = -9.073829600159646d-3*t100*t113*t211*t41
            t232 = -8*t123*t125*t45
            t233 = t119**2
            t234 = 1/t50**2
            t235 = 6.178834917961894d-1*t196*t89+t202+4.63412618847142d-
     1         1*t193*t194
            t236 = t45*t46*(1.709920934161365d+0*(-9.690227711544375d-4*
     1         t27*t29*t94*t96*t98-2.544083100456872d-4*t206*t28*t88*t89
     2         *t98-5.011795824473985d-2*t100*t102*t27*t29*t96-9.6902277
     3         11544375d-4*t204*t28*t94+4.176057139642926d-2*t196*t89*t9
     4         0*t92+3.1320428547321943d-2*t193*t194*t90*t92-3.289159980
     5         064472d-2*t187*t191*t92+2.2478670955426108d-3*t118*t51*(5
     6         .250822119331622d-1*t119*t120*t48*t52*t88*t89+1.750274039
     7         7772074d-1*t196*t48*t52*t89-1.0d+0*t120*t235*t49*t52+2.0d
     8         +0*t233*t234*t49*t52+1.3127055298329054d-1*t193*t194*t48*
     9         t52+3.446391616107778d-2*t187*t52)+5.901575133296435d-4*t
     :         121*t51*t88*t89/t48**3-4.3465070592240396d-2*t115*t117*t1
     ;         96*t89+2.5058979122369923d-2*t100*t51*(-6.203504908994001
     <         d-1*t120*t235*t31*t52+1.2407009817988002d+0*t233*t234*t31
     =         *t52+2.7571132928862224d-1*t100*t208*t52+4.13566993932933
     >         4d-1*t100*t101*t119*t120*t52)+2.5058979122369923d-2*t100*
     ?         t119*t122*t50*t52+2.2478670955426108d-3*t118*t119*t121*t5
     @         0*t52+8.352993040789976d-3*t100*t122*t211*t51+3.423410311
     1         2606934d-2*t117*t187/t47**3-7.662163788798045d-1*t187/(t1
     2         16**2*t47**5)-1.670598608157995d-2*t100*t102*t211*t28-5.0
     3         11795824473985d-2*t100*t209*t28-3.2598802944180294d-2*t11
     4         5*t117*t193*t194+1.2448480831567728d+0*t187*t188*t189)+1.
     5         8356171439920266d-6*t111*t227*t41*t88*t89-6.6888706529703
     6         9d-3*t104*t106*t196*t89+2.722148880047894d-2*t100*t109*t1
     7         13*t40*t42+6.991732350764465d-6*t108*t109*t111*t40*t42+2.
     8         722148880047894d-2*t100*t229*t41+6.991732350764465d-6*t10
     9         8*t225*t41+9.073829600159646d-3*t100*t113*t211*t41+5.2683
     :         1049669476d-3*t106*t187*t216-2.6730712388370664d-1*t187*t
     ;         213*t214-5.016652989727792d-3*t104*t106*t193*t194)
            t237 = 20*t45*t53/t1**6
            t238 = t2**2
            t239 = 12*t238*t46*t53
            t240 = 1/t5
            t241 = 1/t7
            t242 = 2.4256569070538223d+2*t130*t63*t79-4.0427615117563703
     1         d+1*t15*(1.1250000000000002d+0*t54*(1.3333333333333333d+0
     2         *t169*t77+1.3333333333333333d+0*t164*t73+4.44444444444444
     3         4d-1*t165*t241+4.444444444444444d-1*t159*t240)+1.12500000
     4         00000002d+0*t35*(-32*t125*t127*t53+8*t123*t127*t46+t239+t
     5         237+t236+t232+t231+t230+t228+t226+t221+t220+t219+t218+t21
     6         7+t215)+t212+t210+t207+t205+t199+t198+t197+t195+t192+t190
     7         +2.2500000000000003d+0*t128*t129)+1.2128284535269111d+2*t
     8         170*t55*t63-4.8513138141076445d+2*t135*t158*t55
            t243 = -1.7121095002288234d-1*t10*t12*t14*t242*t56*t87
            t244 = 6.848438000915293d-1*t10*t12*t131*t15*t56*t79*t87
            t245 = 7.989844334401176d-1*t10*t131*t14*t56*t82*t83*t87
            t246 = 1/t8**6.0d+0
            t247 = 1/t11**6.0d+0
            t248 = 7.979701560995323d-1*t172*t247*t61*t63*t64
            t249 = -2.2799147317129503d-2*t136*t174*t61*t63*t64
            t250 = 1/t57**4.0d+0
            t251 = 6.666666666666666d-1*t161*t2*t78-1.111111111111111d-1
     1         *t142*t166*t76-6.666666666666666d-1*t161*t2*t74-1.1111111
     2         11111111d-1*t141*t160*t72
            t252 = 1.027265700137294d+0*t10*t12*t143*t58*t63*t79
            t253 = -3.4242190004576467d-1*t10*t12*t15*t251*t58
            t254 = 7.989844334401176d-1*t10*t143*t15*t58*t82*t83
            t255 = 7.989844334401176d-1*t10*t15*t58*t79*t82*t83
            t256 = 1.2128284535269111d+2*t147*t63*t79-4.8513138141076445
     1         d+2*t135*t143*t55*t79-4.0427615117563703d+1*t15*(1.125000
     2         0000000002d+0*t54*(2.6666666666666666d+0*t161*t2*t77+4.44
     3         4444444444444d-1*t142*t241*t76-2.6666666666666666d+0*t161
     4         *t2*t73+4.444444444444444d-1*t141*t240*t72)+1.12500000000
     5         00002d+0*t35*(-12*t238*t46*t53+t237+t236+t232+t231+t230+t
     6         228+t226+t221+t220+t219+t218+t217+t215)+t212+t210+t207+t2
     7         05+t199+t198+t197+t195+t192+t190+1.1250000000000002d+0*t1
     8         28*t146+1.1250000000000002d+0*t129*t145)+1.21282845352691
     9         11d+2*t251*t55*t63+1.2128284535269111d+2*t130*t143*t63
            t257 = -1.7121095002288234d-1*t10*t12*t14*t256*t56*t87
            t258 = 3.4242190004576467d-1*t10*t12*t148*t15*t56*t79*t87
            t259 = 3.994922167200588d-1*t10*t14*t148*t56*t82*t83*t87
            t260 = 3.4242190004576467d-1*t10*t12*t131*t143*t15*t56*t87
            t261 = 3.994922167200588d-1*t10*t131*t14*t56*t82*t83*t87
            t262 = 3.4242190004576467d-1*t10*t12*t131*t14*t148*t182*t183
            t263 = -1.7121095002288234d-1*t10*t12*t131*t14*t148*t56*t87
            t264 = t143**2
            t265 = t141**2
            t266 = t168+t162
            t267 = t142**2
            t268 = t167+t163
            t269 = 3.333333333333333d-1*t268*t78+3.333333333333333d-1*t2
     1         66*t74-1.111111111111111d-1*t166*t267-1.111111111111111d-
     2         1*t160*t265
            t270 = 1.027265700137294d+0*t10*t12*t264*t58*t63
            t271 = -3.4242190004576467d-1*t10*t12*t15*t269*t58
            t272 = 1.5979688668802353d+0*t10*t143*t15*t58*t82*t83
            t273 = t148**2
            t274 = 3.4242190004576467d-1*t10*t12*t14*t182*t183*t273
            t275 = -1.7121095002288234d-1*t10*t12*t14*t273*t56*t87
            t276 = -4.0427615117563703d+1*t15*(1.1250000000000002d+0*t54
     1         *(1.3333333333333333d+0*t268*t77+1.3333333333333333d+0*t2
     2         66*t73+4.444444444444444d-1*t241*t267+4.444444444444444d-
     3         1*t240*t265)+1.1250000000000002d+0*t35*(32*t125*t127*t53-
     4         8*t123*t127*t46+t239+t237+t236+t232+t231+t230+t228+t226+t
     5         221+t220+t219+t218+t217+t215)+t212+t210+t207+t205+t199+t1
     6         98+t197+t195+t192+t190+2.2500000000000003d+0*t145*t146)+1
     7         .2128284535269111d+2*t269*t55*t63+2.4256569070538223d+2*t
     8         143*t147*t63-4.8513138141076445d+2*t135*t264*t55
            t277 = -1.7121095002288234d-1*t10*t12*t14*t276*t56*t87
            t278 = 6.848438000915293d-1*t10*t12*t143*t148*t15*t56*t87
            t279 = 7.989844334401176d-1*t10*t14*t148*t56*t82*t83*t87
            t280 = 2.473556743557577d-2*t154*t9*wght
            t281 = 3.994922167200588d-1*t10*t134*t14*t153*t60*t82*t83
            t282 = -3.994922167200588d-1*t14*t60*t66*t82*t83
            t283 = -6.839744195138847d-2*t10*t136*t58*t63*t66*t82
            t284 = -3.4242190004576467d-1*t12*t15*t58*t79
            t285 = -3.994922167200588d-1*t14*t58*t82*t83
            t286 = -1.7121095002288234d-1*t12*t131*t14*t56*t87
            t287 = -2.735897678055539d-1*t10*t136*t63*t64*t82
            t288 = t81*(2.473556743557577d-2*t1*(-1.7121095002288234d-1*
     1         t10*t12*t134*t14*t60*(-2.345055152619033d-1*t10*t135*t62*
     2         t64*t79-1.1725275763095165d-1*t10*t131*t138*t56*t62*t63+t
     3         287+t286+t285+t284)-5.862637881547582d-2*t10*t135*t58*t62
     4         *t66*t79-3.4242190004576467d-1*t12*t15*t60*t66*t79+3.4242
     5         190004576467d-1*t10*t12*t134*t15*t153*t60*t79+1.712109500
     6         2288234d-1*t10*t12*t14*(t286+t285+t284)*t66+1.71210950022
     7         88234d-1*t12*t133*t14*t66-2.931318940773791d-2*t10*t134*t
     8         139*t58*t62*t63+3.4242190004576467d-1*t10*t12*t139*t14*t1
     9         53*t176*t60-1.7121095002288234d-1*t12*t134*t139*t14*t60+t
     :         283+t282+t281-1.7121095002288234d-1*t10*t12*t133*t134*t14
     ;         *t153)*t9*wght+7.420670230672731d-2*t1*t13*t154*t79*wght+
     <         t280)-2.473556743557577d-2*t1*t140*t154*t171*t9*wght
            t289 = 2.473556743557577d-2*t157*t9*wght
            t290 = 3.994922167200588d-1*t10*t134*t14*t156*t60*t82*t83
            t291 = -7.989844334401176d-1*t14*t60*t66*t82*t83
            t292 = -1.3679488390277694d-1*t10*t136*t58*t63*t66*t82
            t293 = -6.848438000915293d-1*t12*t15*t58*t79
            t294 = -7.989844334401176d-1*t14*t58*t82*t83
            t295 = -3.4242190004576467d-1*t12*t131*t14*t56*t87
            t296 = -5.471795356111078d-1*t10*t136*t63*t64*t82
            t297 = -3.4242190004576467d-1*t12*t143*t15*t58
            t298 = -1.7121095002288234d-1*t12*t14*t148*t56*t87
            t299 = t81*(2.473556743557577d-2*t1*(-5.862637881547582d-2*t
     1         10*t135*t143*t58*t62*t66-3.4242190004576467d-1*t12*t143*t
     2         15*t60*t66+1.7121095002288234d-1*t10*t12*t14*(t298+t297+t
     3         285)*t66+1.7121095002288234d-1*t12*t14*t150*t66-1.7121095
     4         002288234d-1*t10*t12*t134*t14*t60*(-2.345055152619033d-1*
     5         t10*t135*t143*t62*t64-1.1725275763095165d-1*t10*t138*t148
     6         *t56*t62*t63+t298+t297+t287+t285)-2.931318940773791d-2*t1
     7         0*t134*t151*t58*t62*t63+3.4242190004576467d-1*t10*t12*t14
     8         *t151*t153*t176*t60+3.4242190004576467d-1*t10*t12*t134*t1
     9         43*t15*t153*t60-1.7121095002288234d-1*t12*t134*t14*t151*t
     :         60+t283+t282+t281-1.7121095002288234d-1*t10*t12*t134*t14*
     ;         t150*t153)*t9*wght+7.420670230672731d-2*t1*t13*t143*t154*
     <         wght+t280)-2.473556743557577d-2*t1*t152*t154*t171*t9*wght
            t300 = -6.848438000915293d-1*t12*t143*t15*t58
            t301 = -3.4242190004576467d-1*t12*t14*t148*t56*t87
            t302 = -3.4242190004576467d-1*t12*t134*t14*t153*t60
            t303 = -5.862637881547582d-2*t10*t134*t153*t58*t62*t63
            t304 = 2.473556743557577d-2*t1*(5.862637881547582d-2*t58*t62
     1         *t63*t66-1.0037478013399d-2*t10*t134*t246*t247*t60*t64+3.
     2         4242190004576467d-1*t10*t12*t14*t153**2*t176*t60+t303+t30
     3         2)*t81*t9*wght-2.473556743557577d-2*t1*t154**2*t171*t9*wg
     4         ht
            t305 = 2.473556743557577d-2*t1*(1.1725275763095165d-1*t58*t6
     1         2*t63*t66-2.0074956026798d-2*t10*t134*t246*t247*t60*t64-2
     2         .931318940773791d-2*t10*t134*t156*t58*t62*t63+3.424219000
     3         4576467d-1*t10*t12*t14*t153*t156*t176*t60-1.7121095002288
     4         234d-1*t12*t134*t14*t156*t60+t303+t302)*t81*t9*wght-2.473
     5         556743557577d-2*t1*t154*t157*t171*t9*wght
            fnc(iq) = 2.473556743557577d-2*t1*t68*t9*wght+fnc(iq)
            Amat(iq,D1_RA) = 2.473556743557577d-2*t1*t140*t81*t9*wght+7.
     1         420670230672731d-2*t1*t13*t68*t79*wght+t80+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 2.473556743557577d-2*t1*t152*t81*t9*wght+7.
     1         420670230672731d-2*t1*t13*t143*t68*wght+t80+Amat(iq,D1_RB
     2         )
            Cmat(iq,D1_GAA) = t155+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 2.473556743557577d-2*t1*t157*t81*t9*wght+C
     1         mat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = t155+Cmat(iq,D1_GBB)
            Amat2(iq,D2_RA_RA) = t81*(2.473556743557577d-2*t1*(1.5979688
     1         668802353d+0*t10*t15*t60*t66*t79*t82*t83-7.98984433440117
     2         6d-1*t10*t133*t14*t66*t82*t83+7.989844334401176d-1*t10*t1
     3         34*t139*t14*t60*t82*t83-1.7121095002288234d-1*t10*t12*t13
     4         4*t14*t60*(1.0943590712222155d+0*t135*t136*t61*t64*t79*t8
     5         2+5.471795356111078d-1*t131*t136*t138*t56*t61*t63*t82+4.6
     6         90110305238066d-1*t131*t135*t138*t56*t61*t62*t79+5.862637
     7         881547582d-1*t158*t246*t61*t62*t64-1.1725275763095165d-1*
     8         t135*t170*t61*t62*t64-5.862637881547582d-2*t138*t242*t56*
     9         t61*t62*t63-5.862637881547582d-2*t138*t184*t56*t61*t62*t6
     :         3+1.7587913644642747d-1*t182*t184*t250*t61*t62*t63+t249+t
     ;         248+t245+t244+t243+t186+t185+t181+t180+t179+t178+t177)-6.
     <         848438000915293d-1*t10*t12*t133*t15*t66*t79+6.84843800091
     =         5293d-1*t10*t12*t134*t139*t15*t60*t79+1.027265700137294d+
     >         0*t10*t12*t158*t60*t63*t66-3.4242190004576467d-1*t10*t12*
     ?         t15*t170*t60*t66+1.7121095002288234d-1*t10*t12*t14*(t245+
     @         t244+t243+t186+t185+t181+t180+t179+t178+t177)*t66+3.42421
     1         90004576467d-1*t10*t12*t139**2*t14*t176*t60+t175+t173-3.4
     2         242190004576467d-1*t10*t12*t133*t134*t139*t14)*t9*wght+4.
     3         947113487115154d-2*t140*t9*wght+1.4841340461345462d-1*t1*
     4         t13*t140*t79*wght)-2.473556743557577d-2*t1*t140**2*t171*t
     5         9*wght+1.4841340461345462d-1*t1*t158*t68*t8*wght+1.484134
     6         0461345462d-1*t13*t68*t79*wght+7.420670230672731d-2*t1*t1
     7         3*t170*t68*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = t81*(2.473556743557577d-2*t1*(7.9898443
     1         34401176d-1*t10*t15*t60*t66*t79*t82*t83+7.989844334401176
     2         d-1*t10*t143*t15*t60*t66*t82*t83-3.994922167200588d-1*t10
     3         *t14*t150*t66*t82*t83-3.994922167200588d-1*t10*t133*t14*t
     4         66*t82*t83+3.994922167200588d-1*t10*t134*t14*t151*t60*t82
     5         *t83+3.994922167200588d-1*t10*t134*t139*t14*t60*t82*t83-1
     6         .7121095002288234d-1*t10*t12*t134*t14*t60*(5.471795356111
     7         078d-1*t135*t136*t61*t64*t79*t82+5.471795356111078d-1*t13
     8         5*t136*t143*t61*t64*t82+2.735897678055539d-1*t136*t138*t1
     9         48*t56*t61*t63*t82+2.735897678055539d-1*t131*t136*t138*t5
     :         6*t61*t63*t82+5.862637881547582d-1*t143*t246*t61*t62*t64*
     ;         t79+2.345055152619033d-1*t135*t138*t148*t56*t61*t62*t79-1
     <         .1725275763095165d-1*t135*t251*t61*t62*t64-5.862637881547
     =         582d-2*t138*t256*t56*t61*t62*t63-5.862637881547582d-2*t13
     >         1*t138*t148*t56*t61*t62*t63+1.7587913644642747d-1*t131*t1
     ?         48*t182*t250*t61*t62*t63+2.345055152619033d-1*t131*t135*t
     @         138*t143*t56*t61*t62+t263+t262+t261+t260+t259+t258+t257+t
     1         255+t254+t253+t252+t249+t248+t181+t180)+1.027265700137294
     2         d+0*t10*t12*t143*t60*t63*t66*t79-3.4242190004576467d-1*t1
     3         0*t12*t15*t150*t66*t79+3.4242190004576467d-1*t10*t12*t134
     4         *t15*t151*t60*t79-3.4242190004576467d-1*t10*t12*t15*t251*
     5         t60*t66+1.7121095002288234d-1*t10*t12*t14*(t263+t262+t261
     6         +t260+t259+t258+t257+t255+t254+t253+t252+t181+t180)*t66-3
     7         .4242190004576467d-1*t10*t12*t133*t143*t15*t66+3.42421900
     8         04576467d-1*t10*t12*t139*t14*t151*t176*t60+3.424219000457
     9         6467d-1*t10*t12*t134*t139*t143*t15*t60+t175+t173-1.712109
     :         5002288234d-1*t10*t12*t133*t134*t14*t151-1.71210950022882
     ;         34d-1*t10*t12*t134*t139*t14*t150)*t9*wght+2.4735567435575
     <         77d-2*t152*t9*wght+2.473556743557577d-2*t140*t9*wght+7.42
     =         0670230672731d-2*t1*t13*t152*t79*wght+7.420670230672731d-
     >         2*t1*t13*t140*t143*wght)-2.473556743557577d-2*t1*t140*t15
     ?         2*t171*t9*wght+1.4841340461345462d-1*t1*t143*t68*t79*t8*w
     @         ght+7.420670230672731d-2*t13*t68*t79*wght+7.4206702306727
     1         31d-2*t1*t13*t251*t68*wght+7.420670230672731d-2*t13*t143*
     2         t68*wght+Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = t81*(2.473556743557577d-2*t1*(1.5979688
     1         668802353d+0*t10*t143*t15*t60*t66*t82*t83-7.9898443344011
     2         76d-1*t10*t14*t150*t66*t82*t83+7.989844334401176d-1*t10*t
     3         134*t14*t151*t60*t82*t83-1.7121095002288234d-1*t10*t12*t1
     4         34*t14*t60*(1.0943590712222155d+0*t135*t136*t143*t61*t64*
     5         t82+5.471795356111078d-1*t136*t138*t148*t56*t61*t63*t82-1
     6         .1725275763095165d-1*t135*t269*t61*t62*t64+5.862637881547
     7         582d-1*t246*t264*t61*t62*t64-5.862637881547582d-2*t138*t2
     8         76*t56*t61*t62*t63-5.862637881547582d-2*t138*t273*t56*t61
     9         *t62*t63+1.7587913644642747d-1*t182*t250*t273*t61*t62*t63
     :         +4.690110305238066d-1*t135*t138*t143*t148*t56*t61*t62+t27
     ;         9+t278+t277+t275+t274+t272+t271+t270+t249+t248+t181+t180)
     <         +1.027265700137294d+0*t10*t12*t264*t60*t63*t66-3.42421900
     =         04576467d-1*t10*t12*t15*t269*t60*t66+1.7121095002288234d-
     >         1*t10*t12*t14*(t279+t278+t277+t275+t274+t272+t271+t270+t1
     ?         81+t180)*t66-6.848438000915293d-1*t10*t12*t143*t15*t150*t
     @         66+3.4242190004576467d-1*t10*t12*t14*t151**2*t176*t60+6.8
     1         48438000915293d-1*t10*t12*t134*t143*t15*t151*t60+t175+t17
     2         3-3.4242190004576467d-1*t10*t12*t134*t14*t150*t151)*t9*wg
     3         ht+4.947113487115154d-2*t152*t9*wght+1.4841340461345462d-
     4         1*t1*t13*t143*t152*wght)-2.473556743557577d-2*t1*t152**2*
     5         t171*t9*wght+1.4841340461345462d-1*t1*t264*t68*t8*wght+7.
     6         420670230672731d-2*t1*t13*t269*t68*wght+1.484134046134546
     7         2d-1*t13*t143*t68*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RA_GAA) = t288+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = t81*(2.473556743557577d-2*t1*(-1.71210
     1         95002288234d-1*t10*t12*t134*t14*t60*(-4.690110305238066d-
     2         1*t10*t135*t62*t64*t79-2.345055152619033d-1*t10*t131*t138
     3         *t56*t62*t63+t296+t295+t294+t293)-1.1725275763095165d-1*t
     4         10*t135*t58*t62*t66*t79-6.848438000915293d-1*t12*t15*t60*
     5         t66*t79+3.4242190004576467d-1*t10*t12*t134*t15*t156*t60*t
     6         79+1.7121095002288234d-1*t10*t12*t14*(t295+t294+t293)*t66
     7         +3.4242190004576467d-1*t12*t133*t14*t66-5.862637881547582
     8         d-2*t10*t134*t139*t58*t62*t63+3.4242190004576467d-1*t10*t
     9         12*t139*t14*t156*t176*t60-3.4242190004576467d-1*t12*t134*
     :         t139*t14*t60+t292+t291+t290-1.7121095002288234d-1*t10*t12
     ;         *t133*t134*t14*t156)*t9*wght+7.420670230672731d-2*t1*t13*
     <         t157*t79*wght+t289)-2.473556743557577d-2*t1*t140*t157*t17
     =         1*t9*wght+Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = t288+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = t299+Cmat2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = t81*(2.473556743557577d-2*t1*(-1.17252
     1         75763095165d-1*t10*t135*t143*t58*t62*t66-6.84843800091529
     2         3d-1*t12*t143*t15*t60*t66+1.7121095002288234d-1*t10*t12*t
     3         14*(t301+t300+t294)*t66+3.4242190004576467d-1*t12*t14*t15
     4         0*t66-1.7121095002288234d-1*t10*t12*t134*t14*t60*(-4.6901
     5         10305238066d-1*t10*t135*t143*t62*t64-2.345055152619033d-1
     6         *t10*t138*t148*t56*t62*t63+t301+t300+t296+t294)-5.8626378
     7         81547582d-2*t10*t134*t151*t58*t62*t63+3.4242190004576467d
     8         -1*t10*t12*t14*t151*t156*t176*t60+3.4242190004576467d-1*t
     9         10*t12*t134*t143*t15*t156*t60-3.4242190004576467d-1*t12*t
     :         134*t14*t151*t60+t292+t291+t290-1.7121095002288234d-1*t10
     ;         *t12*t134*t14*t150*t156)*t9*wght+7.420670230672731d-2*t1*
     <         t13*t143*t157*wght+t289)-2.473556743557577d-2*t1*t152*t15
     =         7*t171*t9*wght+Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = t299+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = t304+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = t305+Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = t304+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = 2.473556743557577d-2*t1*(2.3450551526
     1         19033d-1*t58*t62*t63*t66-4.0149912053596d-2*t10*t134*t246
     2         *t247*t60*t64-1.1725275763095165d-1*t10*t134*t156*t58*t62
     3         *t63+3.4242190004576467d-1*t10*t12*t14*t156**2*t176*t60-6
     4         .848438000915293d-1*t12*t134*t14*t156*t60)*t81*t9*wght-2.
     5         473556743557577d-2*t1*t157**2*t171*t9*wght+Cmat2(iq,D2_GA
     6         B_GAB)
            Cmat2(iq,D2_GAB_GBB) = t305+Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = t304+Cmat2(iq,D2_GBB_GBB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**1.1666666666666667d+0
            t2 = 1/t1**2.0d+0
            t3 = rhoa**3.333333333333333d-1
            t4 = t3**5.0d-1
            t5 = 1/t4
            t6 = 1/t3
            t7 = 6.203504908994001d-1*t6
            t8 = t7+2.935818660072219d+0*t5+1.29352d+1
            t9 = abs(t8)
            t10 = 1/t9
            t11 = abs(t6)
            t12 = log(6.203504908994001d-1*t10*t11)
            t13 = 7.876233178997433d-1*t5
            t14 = t13+1.0498d-1
            t15 = t14**2
            t16 = log(1.0d+0*t10*t15)
            t17 = 1.5752466357994865d+0*t5
            t18 = t17+3.72744d+0
            t19 = atan(6.15199081975908d+0/t18)
            t20 = t7+8.908571061768626d-1*t5+1.30045d+1
            t21 = abs(t20)
            t22 = 1/t21
            t23 = log(6.203504908994001d-1*t11*t22)
            t24 = t13+4.7584000000000004d-3
            t25 = t24**2
            t26 = log(1.0d+0*t22*t25)
            t27 = t17+1.13107d+0
            t28 = atan(7.123108917818117d+0/t27)
            t29 = t7+5.560951426165704d+0*t5+1.8057800000000002d+1
            t30 = abs(t29)
            t31 = 1/t30
            t32 = t13+3.25d-1
            t33 = t32**2
            t34 = t17+7.06042d+0
            t35 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(5.
     1         249139316978092d-2*atan(4.7309269095601136d+0/t34)+2.2478
     2         670955426108d-3*log(1.0d+0*t31*t33)+1.554535d-2*log(6.203
     3         504908994001d-1*t11*t31)-3.8783294878113006d-2*t19-9.6902
     4         27711544375d-4*t16-3.10907d-2*t12)+5.365091848883603d-3*t
     5         28+6.991732350764465d-6*t26+1.688686394038963d-2*t23)-5.3
     6         65091848883603d-3*t28-6.991732350764465d-6*t26-1.68868639
     7         4038963d-2*t23)+3.8783294878113006d-2*t19+9.6902277115443
     8         75d-4*t16+3.10907d-2*t12
            t36 = exp(-8.085523023512742d+1*t35)
            t37 = t36-1.0d+0
            t38 = 1/t37
            t39 = 2.7178044217479824d-1*gammaaa*t2*t38
            t40 = t39+1.0d+0
            t41 = gammaaa**2.0d+0
            t42 = 1/t1**4.0d+0
            t43 = 1/t37**2.0d+0
            t44 = 7.386460874872887d-2*t41*t42*t43+t39+1.0d+0
            t45 = 1/t44
            t46 = 2.7178044217479824d-1*gammaaa*t2*t40*t45+1.0d+0
            t47 = log(t46)
            t48 = 1/t46
            t49 = rhoa**1.6666666666666674d-1
            t50 = 1/t1**3.0d+0
            t51 = -6.341543650745293d-1*gammaaa*t38*t49*t50
            t52 = 1/t11
            t53 = -2.067834969664667d-1/rhoa**1.3333333333333333d+0
            t54 = 1/t4**3
            t55 = 1/rhoa**6.666666666666667d-1
            t56 = t53-4.8930311001203647d-1*t54*t55
            t57 = 1/t8
            t58 = 1/rhoa**1.6666666666666666d+0
            t59 = -2.067834969664667d-1*t10*t52*t58-6.203504908994001d-1
     1         *t10*t11*t56*t57
            t60 = 1/t18**2
            t61 = 3.784699104639999d+1*t60+1
            t62 = 1/t61
            t63 = 1/t15
            t64 = -1.0d+0*t10*t15*t56*t57-2.625411059665811d-1*t10*t14*t
     1         54*t55
            t65 = t53-1.4847618436281043d-1*t54*t55
            t66 = 1/t20
            t67 = -6.203504908994001d-1*t11*t22*t65*t66-2.06783496966466
     1         7d-1*t22*t52*t58
            t68 = 1/t27**2
            t69 = 5.07386806551d+1*t68+1
            t70 = 1/t69
            t71 = 1/t25
            t72 = -1.0d+0*t22*t25*t65*t66-2.625411059665811d-1*t22*t24*t
     1         54*t55
            t73 = t53-9.26825237694284d-1*t54*t55
            t74 = 1/t29
            t75 = -6.203504908994001d-1*t11*t31*t73*t74-2.06783496966466
     1         7d-1*t31*t52*t58
            t76 = 1/t34**2
            t77 = 2.238166942360001d+1*t76+1
            t78 = 1/t77
            t79 = 1/t33
            t80 = -1.0d+0*t31*t33*t73*t74-2.625411059665811d-1*t31*t32*t
     1         54*t55
            t81 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-9
     1         .690227711544375d-4*t63*t64*t9-5.011795824473985d-2*t52*t
     2         59*t9+2.2478670955426108d-3*t30*t79*t80+6.519760588836059
     3         d-2*t54*t55*t76*t78+2.5058979122369923d-2*t30*t52*t75-6.2
     4         64085709464389d-2*t54*t55*t60*t62)+6.991732350764465d-6*t
     5         21*t71*t72+1.0033305979455584d-2*t54*t55*t68*t70+2.722148
     6         880047894d-2*t21*t52*t67)-6.991732350764465d-6*t21*t71*t7
     7         2-1.0033305979455584d-2*t54*t55*t68*t70-2.722148880047894
     8         d-2*t21*t52*t67)+9.690227711544375d-4*t63*t64*t9+5.011795
     9         824473985d-2*t52*t59*t9+6.264085709464389d-2*t54*t55*t60*
     :         t62
            t82 = 1/t37**2
            t83 = 2.1974870225448048d+1*gammaaa*t2*t36*t81*t82
            t84 = t83+t51
            t85 = 1/t44**2
            t86 = 1/t1**5.0d+0
            t87 = 1/t37**3.0d+0
            t88 = 1.194467989321216d+1*t36*t41*t42*t81*t87-3.44701507494
     1         0681d-1*t41*t43*t49*t86+t83+t51
            t89 = -2.7178044217479824d-1*gammaaa*t2*t40*t85*t88+2.717804
     1         4217479824d-1*gammaaa*t2*t45*t84-6.341543650745293d-1*gam
     2         maaa*t40*t45*t49*t50
            t90 = 1.4772921749745774d-1*gammaaa*t42*t43+2.71780442174798
     1         24d-1*t2*t38
            t91 = -2.7178044217479824d-1*gammaaa*t2*t40*t85*t90+7.386460
     1         874872885d-2*gammaaa*t38*t42*t45+2.7178044217479824d-1*t2
     2         *t40*t45
            t92 = 1/t46**2
            t93 = rhoa**3.333333333333335d-1
            t94 = 1/rhoa**8.333333333333333d-1
            t95 = t81**2
            t96 = exp(-1.6171046047025484d+2*t35)
            t97 = 3.553566382931297d+3*gammaaa*t2*t95*t96/t37**3
            t98 = 2.2195402777608525d+0*gammaaa*t38*t42*t93
            t99 = -1.0569239417908825d-1*gammaaa*t38*t50*t94
            t100 = -1.0254939438542422d+2*gammaaa*t36*t49*t50*t81*t82
            t101 = -1.7767831914656484d+3*gammaaa*t2*t36*t82*t95
            t102 = 1/t61**2
            t103 = 1/t18**5
            t104 = 1/rhoa**2.3333333333333334d+0
            t105 = 1/t18**3
            t106 = 1/rhoa**1.6666666666666669d+0
            t107 = t56**2
            t108 = 1/t8**2
            t109 = 2.7571132928862224d-1/rhoa**2.333333333333333d+0
            t110 = 1/t4**5
            t111 = 1/rhoa**1.3333333333333336d+0
            t112 = 3.262020733413577d-1*t106*t54+2.4465155500601823d-1*t
     1         110*t111+t109
            t113 = 1/rhoa**2.6666666666666666d+0
            t114 = 4.135669939329334d-1*t10*t52*t56*t57*t58-6.2035049089
     1         94001d-1*t10*t11*t112*t57+2.7571132928862224d-1*t10*t113*
     2         t52+1.2407009817988002d+0*t10*t107*t108*t11
            t115 = 1/rhoa**9.999999999999999d-1
            t116 = 1/t14**3
            t117 = 5.250822119331622d-1*t10*t14*t54*t55*t56*t57-1.0d+0*t
     1         10*t112*t15*t57+1.7502740397772074d-1*t10*t106*t14*t54+2.
     2         0d+0*t10*t107*t108*t15+1.3127055298329054d-1*t10*t110*t11
     3         1*t14+3.446391616107778d-2*t10*t104
            t118 = 1/t69**2
            t119 = 1/t27**5
            t120 = 1/t27**3
            t121 = t65**2
            t122 = 1/t20**2
            t123 = 9.89841229085403d-2*t106*t54+7.423809218140521d-2*t11
     1         0*t111+t109
            t124 = 4.135669939329334d-1*t22*t52*t58*t65*t66-6.2035049089
     1         94001d-1*t11*t123*t22*t66+2.7571132928862224d-1*t113*t22*
     2         t52+1.2407009817988002d+0*t11*t121*t122*t22
            t125 = 1/t24**3
            t126 = 5.250822119331622d-1*t22*t24*t54*t55*t65*t66-1.0d+0*t
     1         123*t22*t25*t66+1.7502740397772074d-1*t106*t22*t24*t54+2.
     2         0d+0*t121*t122*t22*t25+1.3127055298329054d-1*t110*t111*t2
     3         2*t24+3.446391616107778d-2*t104*t22
            t127 = t73**2
            t128 = 1/t29**2
            t129 = 6.178834917961894d-1*t106*t54+4.63412618847142d-1*t11
     1         0*t111+t109
            t130 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-
     1         2.544083100456872d-4*t116*t54*t55*t64*t9-9.69022771154437
     2         5d-4*t117*t63*t9-1.670598608157995d-2*t115*t52*t59*t9-5.0
     3         11795824473985d-2*t114*t52*t9+2.2478670955426108d-3*t29*t
     4         31*t73*t79*t80+5.901575133296435d-4*t30*t54*t55*t80/t32**
     5         3-9.690227711544375d-4*t10*t56*t63*t64*t8-5.0117958244739
     6         85d-2*t10*t52*t56*t59*t8+2.2478670955426108d-3*t30*(5.250
     7         822119331622d-1*t31*t32*t54*t55*t73*t74-1.0d+0*t129*t31*t
     8         33*t74+1.7502740397772074d-1*t106*t31*t32*t54+2.0d+0*t127
     9         *t128*t31*t33+1.3127055298329054d-1*t110*t111*t31*t32+3.4
     :         46391616107778d-2*t104*t31)*t79-4.3465070592240396d-2*t10
     ;         6*t54*t76*t78-3.2598802944180294d-2*t110*t111*t76*t78+3.4
     <         234103112606934d-2*t104*t78/t34**3-7.662163788798045d-1*t
     =         104/(t34**5*t77**2)+2.5058979122369923d-2*t29*t31*t52*t73
     >         *t75+8.352993040789976d-3*t115*t30*t52*t75+2.505897912236
     ?         9923d-2*t30*t52*(4.135669939329334d-1*t31*t52*t58*t73*t74
     @         -6.203504908994001d-1*t11*t129*t31*t74+2.7571132928862224
     1         d-1*t113*t31*t52+1.2407009817988002d+0*t11*t127*t128*t31)
     2         +4.176057139642926d-2*t106*t54*t60*t62+3.1320428547321943
     3         d-2*t110*t111*t60*t62-3.289159980064472d-2*t104*t105*t62+
     4         1.2448480831567728d+0*t102*t103*t104)+6.991732350764465d-
     5         6*t20*t22*t65*t71*t72+1.8356171439920266d-6*t125*t21*t54*
     6         t55*t72+6.991732350764465d-6*t126*t21*t71-6.6888706529703
     7         9d-3*t106*t54*t68*t70-5.016652989727792d-3*t110*t111*t68*
     8         t70+5.26831049669476d-3*t104*t120*t70+2.722148880047894d-
     9         2*t20*t22*t52*t65*t67+9.073829600159646d-3*t115*t21*t52*t
     :         67+2.722148880047894d-2*t124*t21*t52-2.6730712388370664d-
     ;         1*t104*t118*t119)-6.991732350764465d-6*t20*t22*t65*t71*t7
     <         2-1.8356171439920266d-6*t125*t21*t54*t55*t72-6.9917323507
     =         64465d-6*t126*t21*t71+6.68887065297039d-3*t106*t54*t68*t7
     >         0+5.016652989727792d-3*t110*t111*t68*t70-5.26831049669476
     ?         d-3*t104*t120*t70-2.722148880047894d-2*t20*t22*t52*t65*t6
     @         7-9.073829600159646d-3*t115*t21*t52*t67-2.722148880047894
     1         d-2*t124*t21*t52+2.6730712388370664d-1*t104*t118*t119)+2.
     2         544083100456872d-4*t116*t54*t55*t64*t9+9.690227711544375d
     3         -4*t117*t63*t9+1.670598608157995d-2*t115*t52*t59*t9+5.011
     4         795824473985d-2*t114*t52*t9+9.690227711544375d-4*t10*t56*
     5         t63*t64*t8+5.011795824473985d-2*t10*t52*t56*t59*t8-4.1760
     6         57139642926d-2*t106*t54*t60*t62-3.1320428547321943d-2*t11
     7         0*t111*t60*t62+3.289159980064472d-2*t104*t105*t62-1.24484
     8         80831567728d+0*t102*t103*t104
            t131 = 2.1974870225448048d+1*gammaaa*t130*t2*t36*t82
            t132 = 1/t1**6.0d+0
            t133 = 1/t44**3
            t134 = -6.341543650745293d-1*t38*t49*t50
            t135 = 2.1974870225448048d+1*t2*t36*t81*t82
            fnc(iq) = 1.2367783717787881d-2*rhoa*t47*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.2367783717787881d-2*rhoa*t48*t89*wght+1.2
     1         367783717787881d-2*t47*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.2367783717787881d-2*rhoa*t48*t91*wght+Cm
     1         at(iq,D1_GAA)
            Amat2(iq,D2_RA_RA) = t48*(1.2367783717787881d-2*rhoa*(-2.717
     1         8044217479824d-1*gammaaa*t2*t40*t85*(t99+t98+t97+2.897369
     2         528551699d+3*t41*t42*t95*t96/t37**4.0d+0-9.65789842850566
     3         3d+2*t36*t41*t42*t87*t95-5.745025124901137d-2*t41*t43*t86
     4         *t94+2.0107587937153976d+0*t132*t41*t43*t93-1.11483679003
     5         31349d+2*t36*t41*t49*t81*t86*t87+1.194467989321216d+1*t13
     6         0*t36*t41*t42*t87+t131+t101+t100)+2.7178044217479824d-1*g
     7         ammaaa*t2*t45*(t99+t98+t97+t131+t101+t100)-1.056923941790
     8         8825d-1*gammaaa*t40*t45*t50*t94+2.2195402777608525d+0*gam
     9         maaa*t40*t42*t45*t93+5.435608843495965d-1*gammaaa*t133*t2
     :         *t40*t88**2-5.435608843495965d-1*gammaaa*t2*t84*t85*t88+1
     ;         .2683087301490586d+0*gammaaa*t40*t49*t50*t85*t88-1.268308
     <         7301490586d+0*gammaaa*t45*t49*t50*t84)*wght+2.47355674355
     =         75762d-2*t89*wght)-1.2367783717787881d-2*rhoa*t89**2*t92*
     >         wght+Amat2(iq,D2_RA_RA)
            Cmat2(iq,D2_RA_GAA) = t48*(1.2367783717787881d-2*t91*wght+1.
     1         2367783717787881d-2*rhoa*(5.435608843495965d-1*gammaaa*t1
     2         33*t2*t40*t88*t90-2.7178044217479824d-1*gammaaa*t2*t84*t8
     3         5*t90+6.341543650745293d-1*gammaaa*t40*t49*t50*t85*t90-7.
     4         386460874872885d-2*gammaaa*t38*t42*t85*t88-2.717804421747
     5         9824d-1*t2*t40*t85*t88-2.7178044217479824d-1*gammaaa*t2*t
     6         40*t85*(2.388935978642432d+1*gammaaa*t36*t42*t81*t87-6.89
     7         4030149881362d-1*gammaaa*t43*t49*t86+t135+t134)-1.7235075
     8         374703399d-1*gammaaa*t38*t45*t49*t86+2.7178044217479824d-
     9         1*t2*t45*t84-6.341543650745293d-1*t40*t45*t49*t50+2.71780
     :         44217479824d-1*gammaaa*(t135+t134)*t2*t45)*wght)-1.236778
     ;         3717787881d-2*rhoa*t89*t91*t92*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = -1.2367783717787881d-2*rhoa*t91**2*t9
     1         2*wght+1.2367783717787881d-2*rhoa*t48*(5.435608843495965d
     2         -1*gammaaa*t133*t2*t40*t90**2-1.477292174974577d-1*gammaa
     3         a*t38*t42*t85*t90-5.435608843495965d-1*t2*t40*t85*t90-4.0
     4         149912053596004d-2*gammaaa*t132*t40*t43*t85+1.47729217497
     5         4577d-1*t38*t42*t45)*wght+Cmat2(iq,D2_GAA_GAA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**1.1666666666666667d+0
            t2 = 1/t1**2.0d+0
            t3 = rhob**3.333333333333333d-1
            t4 = t3**5.0d-1
            t5 = 1/t4
            t6 = 1/t3
            t7 = 6.203504908994001d-1*t6
            t8 = t7+2.935818660072219d+0*t5+1.29352d+1
            t9 = abs(t8)
            t10 = 1/t9
            t11 = abs(t6)
            t12 = log(6.203504908994001d-1*t10*t11)
            t13 = 7.876233178997433d-1*t5
            t14 = t13+1.0498d-1
            t15 = t14**2
            t16 = log(1.0d+0*t10*t15)
            t17 = 1.5752466357994865d+0*t5
            t18 = t17+3.72744d+0
            t19 = atan(6.15199081975908d+0/t18)
            t20 = t7+8.908571061768626d-1*t5+1.30045d+1
            t21 = abs(t20)
            t22 = 1/t21
            t23 = log(6.203504908994001d-1*t11*t22)
            t24 = t13+4.7584000000000004d-3
            t25 = t24**2
            t26 = log(1.0d+0*t22*t25)
            t27 = t17+1.13107d+0
            t28 = atan(7.123108917818117d+0/t27)
            t29 = t7+5.560951426165704d+0*t5+1.8057800000000002d+1
            t30 = abs(t29)
            t31 = 1/t30
            t32 = t13+3.25d-1
            t33 = t32**2
            t34 = t17+7.06042d+0
            t35 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(5.
     1         249139316978092d-2*atan(4.7309269095601136d+0/t34)+2.2478
     2         670955426108d-3*log(1.0d+0*t31*t33)+1.554535d-2*log(6.203
     3         504908994001d-1*t11*t31)-3.8783294878113006d-2*t19-9.6902
     4         27711544375d-4*t16-3.10907d-2*t12)+5.365091848883603d-3*t
     5         28+6.991732350764465d-6*t26+1.688686394038963d-2*t23)-5.3
     6         65091848883603d-3*t28-6.991732350764465d-6*t26-1.68868639
     7         4038963d-2*t23)+3.8783294878113006d-2*t19+9.6902277115443
     8         75d-4*t16+3.10907d-2*t12
            t36 = exp(-8.085523023512742d+1*t35)
            t37 = t36-1.0d+0
            t38 = 1/t37
            t39 = 2.7178044217479824d-1*gammabb*t2*t38
            t40 = t39+1.0d+0
            t41 = gammabb**2.0d+0
            t42 = 1/t1**4.0d+0
            t43 = 1/t37**2.0d+0
            t44 = 7.386460874872887d-2*t41*t42*t43+t39+1.0d+0
            t45 = 1/t44
            t46 = 2.7178044217479824d-1*gammabb*t2*t40*t45+1.0d+0
            t47 = log(t46)
            t48 = 1/t46
            t49 = rhob**1.6666666666666674d-1
            t50 = 1/t1**3.0d+0
            t51 = -6.341543650745293d-1*gammabb*t38*t49*t50
            t52 = 1/t11
            t53 = -2.067834969664667d-1/rhob**1.3333333333333333d+0
            t54 = 1/t4**3
            t55 = 1/rhob**6.666666666666667d-1
            t56 = t53-4.8930311001203647d-1*t54*t55
            t57 = 1/t8
            t58 = 1/rhob**1.6666666666666666d+0
            t59 = -2.067834969664667d-1*t10*t52*t58-6.203504908994001d-1
     1         *t10*t11*t56*t57
            t60 = 1/t18**2
            t61 = 3.784699104639999d+1*t60+1
            t62 = 1/t61
            t63 = 1/t15
            t64 = -1.0d+0*t10*t15*t56*t57-2.625411059665811d-1*t10*t14*t
     1         54*t55
            t65 = t53-1.4847618436281043d-1*t54*t55
            t66 = 1/t20
            t67 = -6.203504908994001d-1*t11*t22*t65*t66-2.06783496966466
     1         7d-1*t22*t52*t58
            t68 = 1/t27**2
            t69 = 5.07386806551d+1*t68+1
            t70 = 1/t69
            t71 = 1/t25
            t72 = -1.0d+0*t22*t25*t65*t66-2.625411059665811d-1*t22*t24*t
     1         54*t55
            t73 = t53-9.26825237694284d-1*t54*t55
            t74 = 1/t29
            t75 = -6.203504908994001d-1*t11*t31*t73*t74-2.06783496966466
     1         7d-1*t31*t52*t58
            t76 = 1/t34**2
            t77 = 2.238166942360001d+1*t76+1
            t78 = 1/t77
            t79 = 1/t33
            t80 = -1.0d+0*t31*t33*t73*t74-2.625411059665811d-1*t31*t32*t
     1         54*t55
            t81 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-9
     1         .690227711544375d-4*t63*t64*t9-5.011795824473985d-2*t52*t
     2         59*t9+2.2478670955426108d-3*t30*t79*t80+6.519760588836059
     3         d-2*t54*t55*t76*t78+2.5058979122369923d-2*t30*t52*t75-6.2
     4         64085709464389d-2*t54*t55*t60*t62)+6.991732350764465d-6*t
     5         21*t71*t72+1.0033305979455584d-2*t54*t55*t68*t70+2.722148
     6         880047894d-2*t21*t52*t67)-6.991732350764465d-6*t21*t71*t7
     7         2-1.0033305979455584d-2*t54*t55*t68*t70-2.722148880047894
     8         d-2*t21*t52*t67)+9.690227711544375d-4*t63*t64*t9+5.011795
     9         824473985d-2*t52*t59*t9+6.264085709464389d-2*t54*t55*t60*
     :         t62
            t82 = 1/t37**2
            t83 = 2.1974870225448048d+1*gammabb*t2*t36*t81*t82
            t84 = t83+t51
            t85 = 1/t44**2
            t86 = 1/t1**5.0d+0
            t87 = 1/t37**3.0d+0
            t88 = 1.194467989321216d+1*t36*t41*t42*t81*t87-3.44701507494
     1         0681d-1*t41*t43*t49*t86+t83+t51
            t89 = -2.7178044217479824d-1*gammabb*t2*t40*t85*t88+2.717804
     1         4217479824d-1*gammabb*t2*t45*t84-6.341543650745293d-1*gam
     2         mabb*t40*t45*t49*t50
            t90 = 1.4772921749745774d-1*gammabb*t42*t43+2.71780442174798
     1         24d-1*t2*t38
            t91 = -2.7178044217479824d-1*gammabb*t2*t40*t85*t90+7.386460
     1         874872885d-2*gammabb*t38*t42*t45+2.7178044217479824d-1*t2
     2         *t40*t45
            t92 = 1/t46**2
            t93 = rhob**3.333333333333335d-1
            t94 = 1/rhob**8.333333333333333d-1
            t95 = t81**2
            t96 = exp(-1.6171046047025484d+2*t35)
            t97 = 3.553566382931297d+3*gammabb*t2*t95*t96/t37**3
            t98 = 2.2195402777608525d+0*gammabb*t38*t42*t93
            t99 = -1.0569239417908825d-1*gammabb*t38*t50*t94
            t100 = -1.0254939438542422d+2*gammabb*t36*t49*t50*t81*t82
            t101 = -1.7767831914656484d+3*gammabb*t2*t36*t82*t95
            t102 = 1/t61**2
            t103 = 1/t18**5
            t104 = 1/rhob**2.3333333333333334d+0
            t105 = 1/t18**3
            t106 = 1/rhob**1.6666666666666669d+0
            t107 = t56**2
            t108 = 1/t8**2
            t109 = 2.7571132928862224d-1/rhob**2.333333333333333d+0
            t110 = 1/t4**5
            t111 = 1/rhob**1.3333333333333336d+0
            t112 = 3.262020733413577d-1*t106*t54+2.4465155500601823d-1*t
     1         110*t111+t109
            t113 = 1/rhob**2.6666666666666666d+0
            t114 = 4.135669939329334d-1*t10*t52*t56*t57*t58-6.2035049089
     1         94001d-1*t10*t11*t112*t57+2.7571132928862224d-1*t10*t113*
     2         t52+1.2407009817988002d+0*t10*t107*t108*t11
            t115 = 1/rhob**9.999999999999999d-1
            t116 = 1/t14**3
            t117 = 5.250822119331622d-1*t10*t14*t54*t55*t56*t57-1.0d+0*t
     1         10*t112*t15*t57+1.7502740397772074d-1*t10*t106*t14*t54+2.
     2         0d+0*t10*t107*t108*t15+1.3127055298329054d-1*t10*t110*t11
     3         1*t14+3.446391616107778d-2*t10*t104
            t118 = 1/t69**2
            t119 = 1/t27**5
            t120 = 1/t27**3
            t121 = t65**2
            t122 = 1/t20**2
            t123 = 9.89841229085403d-2*t106*t54+7.423809218140521d-2*t11
     1         0*t111+t109
            t124 = 4.135669939329334d-1*t22*t52*t58*t65*t66-6.2035049089
     1         94001d-1*t11*t123*t22*t66+2.7571132928862224d-1*t113*t22*
     2         t52+1.2407009817988002d+0*t11*t121*t122*t22
            t125 = 1/t24**3
            t126 = 5.250822119331622d-1*t22*t24*t54*t55*t65*t66-1.0d+0*t
     1         123*t22*t25*t66+1.7502740397772074d-1*t106*t22*t24*t54+2.
     2         0d+0*t121*t122*t22*t25+1.3127055298329054d-1*t110*t111*t2
     3         2*t24+3.446391616107778d-2*t104*t22
            t127 = t73**2
            t128 = 1/t29**2
            t129 = 6.178834917961894d-1*t106*t54+4.63412618847142d-1*t11
     1         0*t111+t109
            t130 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-
     1         2.544083100456872d-4*t116*t54*t55*t64*t9-9.69022771154437
     2         5d-4*t117*t63*t9-1.670598608157995d-2*t115*t52*t59*t9-5.0
     3         11795824473985d-2*t114*t52*t9+2.2478670955426108d-3*t29*t
     4         31*t73*t79*t80+5.901575133296435d-4*t30*t54*t55*t80/t32**
     5         3-9.690227711544375d-4*t10*t56*t63*t64*t8-5.0117958244739
     6         85d-2*t10*t52*t56*t59*t8+2.2478670955426108d-3*t30*(5.250
     7         822119331622d-1*t31*t32*t54*t55*t73*t74-1.0d+0*t129*t31*t
     8         33*t74+1.7502740397772074d-1*t106*t31*t32*t54+2.0d+0*t127
     9         *t128*t31*t33+1.3127055298329054d-1*t110*t111*t31*t32+3.4
     :         46391616107778d-2*t104*t31)*t79-4.3465070592240396d-2*t10
     ;         6*t54*t76*t78-3.2598802944180294d-2*t110*t111*t76*t78+3.4
     <         234103112606934d-2*t104*t78/t34**3-7.662163788798045d-1*t
     =         104/(t34**5*t77**2)+2.5058979122369923d-2*t29*t31*t52*t73
     >         *t75+8.352993040789976d-3*t115*t30*t52*t75+2.505897912236
     ?         9923d-2*t30*t52*(4.135669939329334d-1*t31*t52*t58*t73*t74
     @         -6.203504908994001d-1*t11*t129*t31*t74+2.7571132928862224
     1         d-1*t113*t31*t52+1.2407009817988002d+0*t11*t127*t128*t31)
     2         +4.176057139642926d-2*t106*t54*t60*t62+3.1320428547321943
     3         d-2*t110*t111*t60*t62-3.289159980064472d-2*t104*t105*t62+
     4         1.2448480831567728d+0*t102*t103*t104)+6.991732350764465d-
     5         6*t20*t22*t65*t71*t72+1.8356171439920266d-6*t125*t21*t54*
     6         t55*t72+6.991732350764465d-6*t126*t21*t71-6.6888706529703
     7         9d-3*t106*t54*t68*t70-5.016652989727792d-3*t110*t111*t68*
     8         t70+5.26831049669476d-3*t104*t120*t70+2.722148880047894d-
     9         2*t20*t22*t52*t65*t67+9.073829600159646d-3*t115*t21*t52*t
     :         67+2.722148880047894d-2*t124*t21*t52-2.6730712388370664d-
     ;         1*t104*t118*t119)-6.991732350764465d-6*t20*t22*t65*t71*t7
     <         2-1.8356171439920266d-6*t125*t21*t54*t55*t72-6.9917323507
     =         64465d-6*t126*t21*t71+6.68887065297039d-3*t106*t54*t68*t7
     >         0+5.016652989727792d-3*t110*t111*t68*t70-5.26831049669476
     ?         d-3*t104*t120*t70-2.722148880047894d-2*t20*t22*t52*t65*t6
     @         7-9.073829600159646d-3*t115*t21*t52*t67-2.722148880047894
     1         d-2*t124*t21*t52+2.6730712388370664d-1*t104*t118*t119)+2.
     2         544083100456872d-4*t116*t54*t55*t64*t9+9.690227711544375d
     3         -4*t117*t63*t9+1.670598608157995d-2*t115*t52*t59*t9+5.011
     4         795824473985d-2*t114*t52*t9+9.690227711544375d-4*t10*t56*
     5         t63*t64*t8+5.011795824473985d-2*t10*t52*t56*t59*t8-4.1760
     6         57139642926d-2*t106*t54*t60*t62-3.1320428547321943d-2*t11
     7         0*t111*t60*t62+3.289159980064472d-2*t104*t105*t62-1.24484
     8         80831567728d+0*t102*t103*t104
            t131 = 2.1974870225448048d+1*gammabb*t130*t2*t36*t82
            t132 = 1/t1**6.0d+0
            t133 = 1/t44**3
            t134 = -6.341543650745293d-1*t38*t49*t50
            t135 = 2.1974870225448048d+1*t2*t36*t81*t82
            fnc(iq) = 1.2367783717787881d-2*rhob*t47*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.2367783717787881d-2*rhob*t48*t89*wght+1.2
     1         367783717787881d-2*t47*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.2367783717787881d-2*rhob*t48*t91*wght+Cm
     1         at(iq,D1_GBB)
            Amat2(iq,D2_RB_RB) = t48*(1.2367783717787881d-2*rhob*(-2.717
     1         8044217479824d-1*gammabb*t2*t40*t85*(t99+t98+t97+2.897369
     2         528551699d+3*t41*t42*t95*t96/t37**4.0d+0-9.65789842850566
     3         3d+2*t36*t41*t42*t87*t95-5.745025124901137d-2*t41*t43*t86
     4         *t94+2.0107587937153976d+0*t132*t41*t43*t93-1.11483679003
     5         31349d+2*t36*t41*t49*t81*t86*t87+1.194467989321216d+1*t13
     6         0*t36*t41*t42*t87+t131+t101+t100)+2.7178044217479824d-1*g
     7         ammabb*t2*t45*(t99+t98+t97+t131+t101+t100)-1.056923941790
     8         8825d-1*gammabb*t40*t45*t50*t94+2.2195402777608525d+0*gam
     9         mabb*t40*t42*t45*t93+5.435608843495965d-1*gammabb*t133*t2
     :         *t40*t88**2-5.435608843495965d-1*gammabb*t2*t84*t85*t88+1
     ;         .2683087301490586d+0*gammabb*t40*t49*t50*t85*t88-1.268308
     <         7301490586d+0*gammabb*t45*t49*t50*t84)*wght+2.47355674355
     =         75762d-2*t89*wght)-1.2367783717787881d-2*rhob*t89**2*t92*
     >         wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RB_GBB) = t48*(1.2367783717787881d-2*t91*wght+1.
     1         2367783717787881d-2*rhob*(5.435608843495965d-1*gammabb*t1
     2         33*t2*t40*t88*t90-2.7178044217479824d-1*gammabb*t2*t84*t8
     3         5*t90+6.341543650745293d-1*gammabb*t40*t49*t50*t85*t90-7.
     4         386460874872885d-2*gammabb*t38*t42*t85*t88-2.717804421747
     5         9824d-1*t2*t40*t85*t88-2.7178044217479824d-1*gammabb*t2*t
     6         40*t85*(2.388935978642432d+1*gammabb*t36*t42*t81*t87-6.89
     7         4030149881362d-1*gammabb*t43*t49*t86+t135+t134)-1.7235075
     8         374703399d-1*gammabb*t38*t45*t49*t86+2.7178044217479824d-
     9         1*t2*t45*t84-6.341543650745293d-1*t40*t45*t49*t50+2.71780
     :         44217479824d-1*gammabb*(t135+t134)*t2*t45)*wght)-1.236778
     ;         3717787881d-2*rhob*t89*t91*t92*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = -1.2367783717787881d-2*rhob*t91**2*t9
     1         2*wght+1.2367783717787881d-2*rhob*t48*(5.435608843495965d
     2         -1*gammabb*t133*t2*t40*t90**2-1.477292174974577d-1*gammab
     3         b*t38*t42*t85*t90-5.435608843495965d-1*t2*t40*t85*t90-4.0
     4         149912053596004d-2*gammabb*t132*t40*t43*t85+1.47729217497
     5         4577d-1*t38*t42*t45)*wght+Cmat2(iq,D2_GBB_GBB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_p91_vwn5 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_4} &=& 1.0-{\it t_2}\,{\it t_3}\\\\ 
C>   {\it t_5} &=& {\it t_2}\,{\it t_3}+1.0\\\\ 
C>   {\it t_6} &=& 0.5\,{\it t_5}^{{{2}\over{3}}}+0.5\,{
C>    \it t_4}^{{{2}\over{3}}}\\\\ 
C>   {\it t_7} &=& {\it t_6}^{3.0}\\\\ 
C>   {\it t_8} &=& {\it t_1}^{1.166666666666667}\\\\ 
C>   {\it t_9} &=& {{1}\over{{\it t_8}^{2.0}}}\\\\ 
C>   {\it t_{10}} &=& {{1}\over{{\it t_6}^{2.0}}}\\\\ 
C>   {\it t_{11}} &=& \sigma_{\beta\beta}+2.0\,\sigma_{\alpha\beta}
C>    +\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{12}} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_{13}} &=& {{1}\over{\sqrt{{\it t_{12}}}}}\\\\ 
C>   {\it t_{14}} &=& 1.575246635799487\,{\it t_{13}}\\\\ 
C>   {\it t_{15}} &=& \arctan \left({{6.15199081975908}\over{{
C>    \it t_{14}}+3.72744}}\right)\\\\ 
C>   {\it t_{16}} &=& 0.7876233178997433\,{\it t_{13}}\\\\ 
C>   {\it t_{17}} &=& {{1}\over{{\it t_{12}}}}\\\\ 
C>   {\it t_{18}} &=& 0.6203504908994001\,{\it t_{17}}\\\\ 
C>   {\it t_{19}} &=& {{1}\over{\left| 2.935818660072219\,{\it t_{13}}
C>    +{\it t_{18}}+12.9352\right| }}\\\\ 
C>   {\it t_{20}} &=& \log \left(1.0\,\left({\it t_{16}}
C>    +0.10498\right)^2\,{\it t_{19}}\right)\\\\ 
C>   {\it t_{21}} &=& \left| {\it t_{17}}\right| \\\\ 
C>   {\it t_{22}} &=& \log \left(0.6203504908994001\,{\it t_{21}}
C>    \,{\it t_{19}}\right)\\\\ 
C>   {\it t_{23}} &=& \arctan \left({{7.123108917818118}\over{{
C>    \it t_{14}}+1.13107}}\right)\\\\ 
C>   {\it t_{24}} &=& {{1}\over{\left| 0.8908571061768626\,{
C>    \it t_{13}}+{\it t_{18}}+13.0045\right| }}\\\\ 
C>   {\it t_{25}} &=& \log \left(1.0\,\left({\it t_{16}}
C>    +0.0047584\right)^2\,{\it t_{24}}\right)\\\\ 
C>   {\it t_{26}} &=& \log \left(0.6203504908994001\,{\it t_{21}}
C>    \,{\it t_{24}}\right)\\\\ 
C>   {\it t_{27}} &=& {{1}\over{\left| 5.560951426165705\,{\it t_{13}}
C>    +{\it t_{18}}+18.0578\right| }}\\\\ 
C>   {\it t_{28}} &=& {{1}\over{e^{{{40.4276151175637\,\left(1.125
C>    \,\left({\it t_5}^{{{4}\over{3}}}+{\it t_4}^{{{4}\over{3}}}
C>    -2.0\right)\,\left({{{\it t_2}^4\,\left(1.709920934161365
C>    \,\left(0.01554535\,\log \left(0.6203504908994001\,{
C>    \it t_{21}}\,{\it t_{27}}\right)+0.002247867095542611
C>    \,\log \left(1.0\,\left({\it t_{16}}+0.325\right)^2\,{
C>    \it t_{27}}\right)-0.0310907\,{\it t_{22}}
C>    -9.690227711544375 \times 10^{-4}\,{\it t_{20}}
C>    +0.05249139316978092\,\arctan \left({{4.730926909560114}
C>    \over{{\it t_{14}}+7.06042}}\right)-0.03878329487811301\,{
C>    \it t_{15}}\right)+0.01688686394038963\,{\it t_{26}}
C>    +6.991732350764465 \times 10^{-6}\,{\it t_{25}}
C>    +0.005365091848883603\,{\it t_{23}}\right)}\over{{\it t_1}^4}}
C>    -0.01688686394038963\,{\it t_{26}}-6.991732350764465 \times 10^{
C>    -6}\,{\it t_{25}}-0.005365091848883603\,{\it t_{23}}\right)
C>    +0.0310907\,{\it t_{22}}+9.690227711544375 \times 10^{-4}\,{
C>    \it t_{20}}+0.03878329487811301\,{\it t_{15}}\right)}\over{{
C>    \it t_7}}}}}}-1.0\\\\ 
C>   {\it t_{29}} &=& {{0.1712109500228823\,{\it t_9}\,{\it t_{10}}
C>    \,{\it t_{11}}}\over{{\it t_{28}}}}\\\\ 
C>   {\it t_{30}} &=& \rho_s^{1.166666666666667}\\\\ 
C>   {\it t_{31}} &=& {{1}\over{{\it t_{30}}^{2.0}}}\\\\ 
C>   {\it t_{32}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{33}} &=& {{1}\over{\sqrt{{\it t_{32}}}}}\\\\ 
C>   {\it t_{34}} &=& {{1}\over{{\it t_{32}}}}\\\\ 
C>   {\it t_{35}} &=& 0.6203504908994001\,{\it t_{34}}\\\\ 
C>   {\it t_{36}} &=& {{1}\over{\left| {\it t_{35}}
C>    +2.935818660072219\,{\it t_{33}}+12.9352\right| }}\\\\ 
C>   {\it t_{37}} &=& \left| {\it t_{34}}\right| \\\\ 
C>   {\it t_{38}} &=& \log \left(0.6203504908994001\,{\it t_{36}}
C>    \,{\it t_{37}}\right)\\\\ 
C>   {\it t_{39}} &=& 0.7876233178997433\,{\it t_{33}}\\\\ 
C>   {\it t_{40}} &=& \log \left(1.0\,{\it t_{36}}\,\left({\it t_{39}}
C>    +0.10498\right)^2\right)\\\\ 
C>   {\it t_{41}} &=& 1.575246635799487\,{\it t_{33}}\\\\ 
C>   {\it t_{42}} &=& \arctan \left({{6.15199081975908}\over{{
C>    \it t_{41}}+3.72744}}\right)\\\\ 
C>   {\it t_{43}} &=& {{1}\over{\left| {\it t_{35}}
C>    +0.8908571061768626\,{\it t_{33}}+13.0045\right| }}\\\\ 
C>   {\it t_{44}} &=& \log \left(0.6203504908994001\,{\it t_{43}}
C>    \,{\it t_{37}}\right)\\\\ 
C>   {\it t_{45}} &=& \log \left(1.0\,{\it t_{43}}\,\left({\it t_{39}}
C>    +0.0047584\right)^2\right)\\\\ 
C>   {\it t_{46}} &=& \arctan \left({{7.123108917818118}\over{{
C>    \it t_{41}}+1.13107}}\right)\\\\ 
C>   {\it t_{47}} &=& {{1}\over{\left| {\it t_{35}}
C>    +5.560951426165705\,{\it t_{33}}+18.0578\right| }}\\\\ 
C>   {\it t_{48}} &=& {{1}\over{e^{80.85523023512742\,
C>    \left(0.5848223622634643\,\left(1.0\,\left(1.709920934161365
C>    \,\left(0.05249139316978092\,\arctan 
C>    \left({{4.730926909560114}\over{{\it t_{41}}+7.06042}}\right)
C>    -0.03878329487811301\,{\it t_{42}}+0.002247867095542611
C>    \,\log \left(1.0\,{\it t_{47}}\,\left({\it t_{39}}
C>    +0.325\right)^2\right)-9.690227711544375 \times 10^{-4}\,{
C>    \it t_{40}}+0.01554535\,\log \left(0.6203504908994001\,{
C>    \it t_{47}}\,{\it t_{37}}\right)-0.0310907\,{\it t_{38}}\right)
C>    +0.005365091848883603\,{\it t_{46}}
C>    +6.991732350764465 \times 10^{-6}\,{\it t_{45}}
C>    +0.01688686394038963\,{\it t_{44}}\right)-0.005365091848883603
C>    \,{\it t_{46}}-6.991732350764465 \times 10^{-6}\,{\it t_{45}}
C>    -0.01688686394038963\,{\it t_{44}}\right)+0.03878329487811301
C>    \,{\it t_{42}}+9.690227711544375 \times 10^{-4}\,{\it t_{40}}
C>    +0.0310907\,{\it t_{38}}\right)}}}-1.0\\\\ 
C>   {\it t_{49}} &=& {{0.2717804421747982\,{\it t_{31}}\,
C>    \sigma_{ss}}\over{{\it t_{48}}}}\\\\ 
C>   f &=& 0.02473556743557577\,{\it t_1}\,{\it t_7}\,\log 
C>    \left({{0.1712109500228823\,{\it t_9}\,{\it t_{10}}\,{
C>    \it t_{11}}\,\left({\it t_{29}}+1.0\right)}
C>    \over{{{0.02931318940773791\,{\it t_{11}}^{2.0}}\over{{
C>    \it t_8}^{4.0}\,{\it t_6}^{4.0}\,{\it t_{28}}^{2.0}}}+{
C>    \it t_{29}}+1.0}}+1.0\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 0.01236778371778788\,\rho_s\,\log 
C>    \left({{0.2717804421747982\,{\it t_{31}}\,\sigma_{ss}\,
C>    \left({\it t_{49}}+1.0\right)}\over{{{0.07386460874872887
C>    \,\sigma_{ss}^{2.0}}\over{{\it t_{30}}^{4.0}\,{
C>    \it t_{48}}^{2.0}}}+{\it t_{49}}+1.0}}+1.0\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] unpublished , DOI: 
C> <a href="https://doi.org/unpublished "> 
C> unpublished </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_p91_vwn5_d3(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Amat2,Amat3, 
     +Cmat,Cmat2,Cmat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,*)  !< [Output] The 2nd derivative wrt rgamma 
                                    !< and possibly rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,*)  !< [Output] The 3rd derivative wrt rho 
      double precision Cmat3(nq,*)  !< [Output] The 3rd derivative wrt rgamma 
                                    !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**1.1666666666666667d+0
            t2 = 1/t1**2.0d+0
            t3 = rhoa**3.333333333333333d-1
            t4 = t3**5.0d-1
            t5 = 1/t4
            t6 = 1/t3
            t7 = 4.9237251092134837d-1*t6
            t8 = 1/abs(t7+2.615517080950829d+0*t5+1.29352d+1)
            t9 = abs(t6)
            t10 = exp(-4.0427615117563703d+1*(3.10907d-2*log(4.923725109
     1         2134837d-1*t8*t9)+9.690227711544375d-4*log(1.0d+0*(7.0169
     2         26042943223d-1*t5+1.0498d-1)**2*t8)+3.8783294878113006d-2
     3         *atan(6.15199081975908d+0/(1.4033852085886447d+0*t5+3.727
     4         44d+0))))-1.0d+0
            t11 = 1.358902210873991d-1*gammaaa*t2/t10
            t12 = gammaaa**2.0d+0
            t13 = 1/t1**4.0d+0
            t14 = t7+2.615517080950828d+0*t5+1.29352d+1
            t15 = abs(t14)
            t16 = 1/t15
            t17 = 7.016926042943222d-1*t5
            t18 = t17+1.0498d-1
            t19 = t18**2
            t20 = 1.4033852085886445d+0*t5
            t21 = t20+3.72744d+0
            t22 = 3.10907d-2*log(4.9237251092134837d-1*t16*t9)+3.8783294
     1         878113006d-2*atan(6.15199081975908d+0/t21)+9.690227711544
     2         375d-4*log(1.0d+0*t16*t19)
            t23 = exp(-4.0427615117563703d+1*t22)
            t24 = t23-1.0d+0
            t25 = 1/t24
            t26 = 1.3589022108739912d-1*gammaaa*t2*t25
            t27 = t26+1.0d+0
            t28 = 1/t24**2.0d+0
            t29 = 1.846615218718221d-2*t12*t13*t28+t26+1.0d+0
            t30 = 1/t29
            t31 = 1.3589022108739912d-1*gammaaa*t2*t27*t30+1.0d+0
            t32 = 1/t31
            t33 = rhoa**1.6666666666666674d-1
            t34 = 1/t1**3.0d+0
            t35 = -1.585385912686323d-1*gammaaa*t25*t33*t34
            t36 = 1/t9
            t37 = -8.206208515355806d-2/rhoa**1.3333333333333333d+0
            t38 = 1/t4**3
            t39 = 1/rhoa**6.666666666666667d-1
            t40 = t37-2.1795975674590234d-1*t38*t39
            t41 = 1/t14
            t42 = 1/rhoa**1.6666666666666666d+0
            t43 = -4.9237251092134837d-1*t16*t40*t41*t9-8.20620851535580
     1         6d-2*t16*t36*t42
            t44 = 1/t21**2
            t45 = 3.784699104639999d+1*t44+1
            t46 = 1/t45
            t47 = 1/t19
            t48 = -1.0d+0*t16*t19*t40*t41-1.1694876738238703d-1*t16*t18*
     1         t38*t39
            t49 = 9.690227711544375d-4*t15*t47*t48+2.790332964441521d-2*
     1         t38*t39*t44*t46+6.314467057030004d-2*t15*t36*t43
            t50 = 1/t24**2
            t51 = 5.493717556362011d+0*gammaaa*t2*t23*t49*t50
            t52 = t51+t35
            t53 = 1/t29**2
            t54 = 1/t1**5.0d+0
            t55 = 1/t24**3.0d+0
            t56 = 1.4930849866515192d+0*t12*t13*t23*t49*t55-4.3087688436
     1         7585d-2*t12*t28*t33*t54+t51+t35
            t57 = -1.3589022108739912d-1*gammaaa*t2*t27*t53*t56+1.358902
     1         2108739912d-1*gammaaa*t2*t30*t52-1.585385912686323d-1*gam
     2         maaa*t27*t30*t33*t34
            t58 = log(t31)
            t59 = 9.233076093591105d-3*gammaaa*t13*t28+3.397255527184978
     1         d-2*t2*t25
            t60 = -1.3589022108739912d-1*gammaaa*t2*t27*t53*t59+3.397255
     1         527184978d-2*t2*t27*t30+4.6165380467955525d-3*gammaaa*t13
     2         *t25*t30
            t61 = 1.846615218718221d-2*gammaaa*t13*t28+6.794511054369956
     1         d-2*t2*t25
            t62 = -1.3589022108739912d-1*gammaaa*t2*t27*t53*t61+6.794511
     1         054369956d-2*t2*t27*t30+9.233076093591105d-3*gammaaa*t13*
     2         t25*t30
            t63 = 1/t31**2
            t64 = t57**2
            t65 = -4.947113487115154d-2*rhoa*t63*t64*wght
            t66 = 1/rhoa
            t67 = 4.947113487115154d-2*t57*wght
            t68 = rhoa**3.333333333333335d-1
            t69 = 2.774425347201065d-1*gammaaa*t13*t27*t30*t68
            t70 = 1/rhoa**8.333333333333333d-1
            t71 = -1.3211549272386033d-2*gammaaa*t27*t30*t34*t70
            t72 = 1/rhoa**2
            t73 = -3.170771825372646d-1*gammaaa*t30*t33*t34*t52
            t74 = 3.170771825372646d-1*gammaaa*t27*t33*t34*t53*t56
            t75 = -2.7178044217479824d-1*gammaaa*t2*t52*t53*t56
            t76 = t49**2
            t77 = exp(-8.085523023512741d+1*t22)
            t78 = 1/t24**3
            t79 = 4.441957978664119d+2*gammaaa*t2*t76*t77*t78
            t80 = 2.774425347201065d-1*gammaaa*t13*t25*t68
            t81 = -1.3211549272386033d-2*gammaaa*t25*t34*t70
            t82 = 1.5098913454155452d-2*gammaaa*t2*t25*t72
            t83 = -1.2818674298178023d+1*gammaaa*t23*t33*t34*t49*t50
            t84 = -2.2209789893320595d+2*gammaaa*t2*t23*t50*t76
            t85 = 1/t45**2
            t86 = 1/t21**5
            t87 = 1/rhoa**2.3333333333333334d+0
            t88 = -2.470091445929572d-1*t85*t86*t87
            t89 = 1/t21**3
            t90 = 6.526520015557556d-3*t46*t87*t89
            t91 = t7+7.93663453939179d-1*t5+1.30045d+1
            t92 = abs(t91)
            t93 = 1/t92
            t94 = t17+4.7584000000000004d-3
            t95 = t94**2
            t96 = t20+1.13107d+0
            t97 = -5.365091848883603d-3*atan(7.123108917818117d+0/t96)-6
     1         .991732350764465d-6*log(1.0d+0*t93*t95)-1.688686394038963
     2         d-2*log(4.9237251092134837d-1*t9*t93)
            t98 = 1/rhoa**1.6666666666666669d+0
            t99 = -9.301109881471736d-3*t38*t44*t46*t98
            t100 = t40**2
            t101 = 1/t14**2
            t102 = 1/t4**5
            t103 = 1/rhoa**1.3333333333333336d+0
            t104 = 7.265325224863413d-2*t38*t98+5.448993918647558d-2*t10
     1         2*t103+5.470805676903872d-2/rhoa**2.333333333333333d+0
            t105 = 1/rhoa**2.6666666666666666d+0
            t106 = -4.9237251092134837d-1*t104*t16*t41*t9+9.847450218426
     1         967d-1*t100*t101*t16*t9+1.6412417030711612d-1*t16*t36*t40
     2         *t41*t42+5.470805676903869d-2*t105*t16*t36
            t107 = 6.314467057030004d-2*t106*t15*t36
            t108 = -6.975832411103801d-3*t102*t103*t44*t46
            t109 = 1/rhoa**9.999999999999999d-1
            t110 = 1.0524111761716676d-2*t109*t15*t36*t43
            t111 = 1/t18**3
            t112 = 1.1332601865197636d-4*t111*t15*t38*t39*t48
            t113 = 3.898292246079568d-2*t16*t18*t38*t98+6.83850709612983
     1         8d-3*t16*t87+2.3389753476477407d-1*t16*t18*t38*t39*t40*t4
     2         1-1.0d+0*t104*t16*t19*t41+2.0d+0*t100*t101*t16*t19+2.9237
     3         19184559675d-2*t102*t103*t16*t18
            t114 = 9.690227711544375d-4*t113*t15*t47
            t115 = 6.314467057030004d-2*t14*t16*t36*t40*t43
            t116 = 9.690227711544375d-4*t14*t16*t40*t47*t48
            t117 = -4.0427615117563703d+1*(t99+2.5000000000000006d-1*t72
     1         *t97+t90+t88+t116+t115+t114+t112+t110+t108+t107)-6.737935
     2         852927281d+0*t22*t72
            t118 = -1.3589022108739912d-1*gammaaa*t117*t2*t23*t50
            t119 = t84+t83+t82+t81+t80+t79+t118
            t120 = 1/t24**4.0d+0
            t121 = 1.8108559553448106d+2*t12*t120*t13*t76*t77
            t122 = 1/t1**6.0d+0
            t123 = 1.256724246072123d-1*t12*t122*t28*t68
            t124 = -3.59064070306321d-3*t12*t28*t54*t70
            t125 = -6.96772993770709d+0*t12*t23*t33*t49*t54*t55
            t126 = -6.036186517816036d+1*t12*t13*t23*t55*t76
            t127 = t84+t83+t82+t81+t80+t79+4.103589374929379d-3*t12*t13*
     1         t28*t72-3.693230437436442d-2*t117*t12*t13*t23*t55+t126+t1
     2         25+t124+t123+t121+t118
            t128 = 1/t29**3
            t129 = t56**2
            t130 = 2.7178044217479824d-1*gammaaa*t128*t129*t2*t27
            t131 = t75+t74+t73+1.5098913454155452d-2*gammaaa*t2*t27*t30*
     1         t72+t71+t69-1.3589022108739912d-1*gammaaa*t127*t2*t27*t53
     2         +1.3589022108739912d-1*gammaaa*t119*t2*t30+t130
            t132 = 4.947113487115154d-2*rhoa*t131*wght+t67
            t133 = -1.5098913454155458d-2*gammaaa*t2*t25*t72
            t134 = 6.737935852927284d+0*t22*t72-4.0427615117563703d+1*(t
     1         99-2.5000000000000006d-1*t72*t97+t90+t88+t116+t115+t114+t
     2         112+t110+t108+t107)
            t135 = -1.3589022108739912d-1*gammaaa*t134*t2*t23*t50
            t136 = t84+t83+t81+t80+t79+t135+t133
            t137 = t84+t83+t81+t80+t79-4.1035893749293795d-3*t12*t13*t28
     1         *t72-3.693230437436442d-2*t12*t13*t134*t23*t55+t135+t133+
     2         t126+t125+t124+t123+t121
            t138 = t75+t74+t73-1.5098913454155458d-2*gammaaa*t2*t27*t30*
     1         t72+t71+t69-1.3589022108739912d-1*gammaaa*t137*t2*t27*t53
     2         +1.3589022108739912d-1*gammaaa*t136*t2*t30+t130
            t139 = 4.947113487115154d-2*rhoa*t138*wght+t67
            t140 = -3.9634647817158075d-2*t25*t33*t34
            t141 = 1.3734293890905028d+0*t2*t23*t49*t50
            t142 = t141+t140
            t143 = 7.465424933257596d-1*gammaaa*t13*t23*t49*t55-2.154384
     1         421837925d-2*gammaaa*t28*t33*t54+t141+t140
            t144 = 2.7178044217479824d-1*gammaaa*t128*t2*t27*t56*t59-1.3
     1         589022108739912d-1*gammaaa*t2*t52*t53*t59+1.5853859126863
     2         23d-1*gammaaa*t27*t33*t34*t53*t59-3.397255527184978d-2*t2
     3         *t27*t53*t56-4.6165380467955525d-3*gammaaa*t13*t25*t53*t5
     4         6-5.385961054594812d-3*gammaaa*t25*t30*t33*t54-1.35890221
     5         08739912d-1*gammaaa*t143*t2*t27*t53+3.397255527184978d-2*
     6         t2*t30*t52-3.9634647817158075d-2*t27*t30*t33*t34+1.358902
     7         2108739912d-1*gammaaa*t142*t2*t30
            t145 = 2.473556743557577d-2*t60*wght+4.947113487115154d-2*rh
     1         oa*t144*wght
            t146 = t145*t32-4.947113487115154d-2*rhoa*t57*t60*t63*wght
            t147 = -7.926929563431615d-2*t25*t33*t34
            t148 = 2.7468587781810055d+0*t2*t23*t49*t50
            t149 = t148+t147
            t150 = 1.4930849866515192d+0*gammaaa*t13*t23*t49*t55-4.30876
     1         884367585d-2*gammaaa*t28*t33*t54+t148+t147
            t151 = 2.7178044217479824d-1*gammaaa*t128*t2*t27*t56*t61-1.3
     1         589022108739912d-1*gammaaa*t2*t52*t53*t61+1.5853859126863
     2         23d-1*gammaaa*t27*t33*t34*t53*t61-6.794511054369956d-2*t2
     3         *t27*t53*t56-9.233076093591105d-3*gammaaa*t13*t25*t53*t56
     4         -1.0771922109189624d-2*gammaaa*t25*t30*t33*t54-1.35890221
     5         08739912d-1*gammaaa*t150*t2*t27*t53+6.794511054369956d-2*
     6         t2*t30*t52-7.926929563431615d-2*t27*t30*t33*t34+1.3589022
     7         108739912d-1*gammaaa*t149*t2*t30
            t152 = 2.473556743557577d-2*t62*wght+4.947113487115154d-2*rh
     1         oa*t151*wght
            t153 = t60**2
            t154 = t59**2
            t155 = -6.794511054369956d-2*t2*t27*t53*t59
            t156 = -9.233076093591105d-3*gammaaa*t13*t25*t53*t59
            t157 = -3.1367118791871873d-4*gammaaa*t122*t27*t28*t53+2.308
     1         2690233977762d-3*t13*t25*t30+2.7178044217479824d-1*gammaa
     2         a*t128*t154*t2*t27+t156+t155
            t158 = 4.947113487115154d-2*rhoa*t157*t32*wght-4.94711348711
     1         5154d-2*rhoa*t153*t63*wght
            t159 = 2.7178044217479824d-1*gammaaa*t128*t2*t27*t59*t61-3.3
     1         97255527184978d-2*t2*t27*t53*t61-4.6165380467955525d-3*ga
     2         mmaaa*t13*t25*t53*t61-6.273423758374375d-4*gammaaa*t122*t
     3         27*t28*t53+4.6165380467955525d-3*t13*t25*t30+t156+t155
            t160 = t62**2
            t161 = t61**2
            t162 = -1.3589022108739912d-1*t2*t27*t53*t61-1.8466152187182
     1         21d-2*gammaaa*t13*t25*t53*t61-1.254684751674875d-3*gammaa
     2         a*t122*t27*t28*t53+9.233076093591105d-3*t13*t25*t30+2.717
     3         8044217479824d-1*gammaaa*t128*t161*t2*t27
            t163 = 1/t31**3
            t164 = 9.894226974230308d-2*rhoa*t163*t57**3*wght
            t165 = rhoa**5.000000000000002d-1
            t166 = -6.473659143469154d-1*gammaaa*t165*t27*t30*t54
            t167 = 1/rhoa**6.666666666666665d-1
            t168 = 6.936063368002667d-2*gammaaa*t13*t167*t27*t30
            t169 = 1/rhoa**1.8333333333333332d+0
            t170 = 1/rhoa**3
            t171 = t49**3
            t172 = exp(-1.2128284535269111d+2*t22)
            t173 = 1/t24**4
            t174 = 5.387333025894727d+4*gammaaa*t171*t172*t173*t2
            t175 = -1.5546852925324417d+3*gammaaa*t33*t34*t76*t77*t78
            t176 = -5.387333025894727d+4*gammaaa*t171*t2*t77*t78
            t177 = -3.2962305338172065d+1*gammaaa*t117*t2*t49*t77*t78
            t178 = -6.473659143469154d-1*gammaaa*t165*t25*t54
            t179 = 6.936063368002667d-2*gammaaa*t13*t167*t25
            t180 = -4.7341384892716565d-2*gammaaa*t169*t25*t34
            t181 = -4.529674036246638d-2*gammaaa*t170*t2*t25
            t182 = 3.364902003271732d+1*gammaaa*t13*t23*t49*t50*t68
            t183 = -1.6023342872722537d+0*gammaaa*t23*t34*t49*t50*t70
            t184 = 7.773426462662208d+2*gammaaa*t23*t33*t34*t50*t76
            t185 = 4.756157738058969d-1*gammaaa*t117*t23*t33*t34*t50
            t186 = 8.978888376491212d+3*gammaaa*t171*t2*t23*t50
            t187 = 1.8312391854540028d+0*gammaaa*t2*t23*t49*t50*t72
            t188 = 1/rhoa**3.3333333333333337d+0
            t189 = 4.3226600303767515d-1*t188*t85*t86
            t190 = -1.1421410027225727d-2*t188*t46*t89
            t191 = 1/rhoa**3.0d+0
            t192 = 4.3732069462725337d+0*t191*t38/(t21**8*t45**3)
            t193 = -2.022119049462691d-1*t191*t38*t85/t21**6
            t194 = 2.289805413347801d-3*t191*t38*t46/t21**4
            t195 = 1/rhoa**2.666666666666667d+0
            t196 = 7.750924901226445d-3*t195*t38*t44*t46
            t197 = 6.975832411103802d-3*t102*t44*t46*t87
            t198 = 1.988000729055306d-5*t15*t48*t87/t18**4
            t199 = t37-6.613862116159824d-2*t38*t39
            t200 = 1/t91
            t201 = 1/t96**2
            t202 = -6.991732350764465d-6*t92*(-1.0d+0*t199*t200*t93*t95-
     1         1.1694876738238703d-1*t38*t39*t93*t94)/t95-3.429692674920
     2         095d-2*t36*t92*(-4.9237251092134837d-1*t199*t200*t9*t93-8
     3         .206208515355806d-2*t36*t42*t93)-4.469329717903391d-3*t20
     4         1*t38*t39/(5.07386806551d+1*t201+1)
            t203 = 1/t4**7
            t204 = 1/rhoa**2.0d+0
            t205 = 2.906596837959916d-3*t203*t204*t44*t46
            t206 = -5.262055880858336d-3*t15*t204*t36*t43
            t207 = 1.7540186269527788d-3*t15*t36*t43/rhoa**1.99999999999
     1         99998d+0
            t208 = -3.7775339550658793d-5*t111*t15*t38*t48*t98
            t209 = t40**3
            t210 = 1/t14**3
            t211 = -5.448993918647558d-2*t102*t87-6.054437687386176d-2*t
     1         195*t38-2.2704141327698155d-2*t203*t204-6.382606623054516
     2         d-2/rhoa**3.333333333333333d+0
            t212 = 6.314467057030004d-2*t15*t36*(-4.9237251092134837d-1*
     1         t16*t211*t41*t9+2.95423506552809d+0*t101*t104*t16*t40*t9-
     2         2.95423506552809d+0*t16*t209*t210*t9+2.4618625546067416d-
     3         1*t104*t16*t36*t41*t42-4.923725109213483d-1*t100*t101*t16
     4         *t36*t42-1.6412417030711612d-1*t105*t16*t36*t40*t41-6.382
     5         606623054515d-2*t16*t36/rhoa**3.6666666666666664d+0)
            t213 = -2.833150466299409d-5*t102*t103*t111*t15*t48
            t214 = 2.1048223523433351d-2*t106*t109*t15*t36
            t215 = 2.1048223523433351d-2*t109*t14*t16*t36*t40*t43
            t216 = 2.2665203730395272d-4*t111*t113*t15*t38*t39
            t217 = 2.2665203730395272d-4*t111*t14*t16*t38*t39*t40*t48
            t218 = 9.690227711544375d-4*t15*t47*(-1.1694876738238703d-1*
     1         t16*t18*t38*t40*t41*t98-2.0515521288389513d-2*t16*t40*t41
     2         *t87-2.923719184559675d-2*t102*t16*t18*t87-8.771157553679
     3         026d-2*t102*t103*t16*t18*t40*t41+3.508463021471611d-1*t10
     4         4*t16*t18*t38*t39*t41-1.0d+0*t16*t19*t211*t41+6.0d+0*t101
     5         *t104*t16*t19*t40-7.016926042943222d-1*t100*t101*t16*t18*
     6         t38*t39-3.2485768717329727d-2*t16*t18*t195*t38-6.0d+0*t16
     7         *t19*t209*t210-1.2182163268998646d-2*t16*t18*t203*t204-1.
     8         1967387418227218d-2*t16*t188)
            t219 = 6.314467057030004d-2*t104*t14*t16*t36*t43
            t220 = 1.262893411406001d-1*t106*t14*t16*t36*t40
            t221 = 1.938045542308875d-3*t113*t14*t16*t40*t47
            t222 = 9.690227711544375d-4*t104*t14*t16*t47*t48
            t223 = -4.0427615117563703d+1*(-7.5d-1*t170*t97+7.5000000000
     1         00001d-1*t202*t72+t222+t221+t220+t219+t218+t217+t216+t215
     2         +t214+t213+t212+t208+t207+t206+t205+t198+t197+t196+t194+t
     3         193+t192+t190+t189)-2.021380755878185d+1*t49*t72+2.021380
     4         7558781854d+1*t170*t22
            t224 = -1.3589022108739912d-1*gammaaa*t2*t223*t23*t50
            t225 = 1.6481152669086033d+1*gammaaa*t117*t2*t23*t49*t50
            t226 = 2.9283435038411254d+4*t12*t13*t171*t172/t24**5.0d+0
            t227 = -1.2675991687413676d+3*t12*t120*t33*t54*t76*t77
            t228 = -2.196257627880844d+4*t12*t120*t13*t171*t77
            t229 = 1/t1**7.0d+0
            t230 = -4.39853486125243d-1*t12*t165*t229*t28
            t231 = 3.14181061518031d-2*t12*t122*t167*t28
            t232 = 3.0483818477468533d+1*t12*t122*t23*t49*t55*t68
            t233 = 4.2253305624712256d+2*t12*t23*t33*t54*t55*t76
            t234 = 8.153413265243947d-1*gammaaa*t128*t129*t2*t52
            t235 = 1/t29**4
            t236 = -8.153413265243947d-1*gammaaa*t2*t235*t27*t56**3
            t237 = -2.473556743557577d-2*t64*wght
            t238 = -t132*t57
            t239 = 5.387333025894728d+4*gammaaa*t171*t172*t173*t2
            t240 = -1.5546852925324414d+3*gammaaa*t33*t34*t76*t77*t78
            t241 = -5.387333025894728d+4*gammaaa*t171*t2*t77*t78
            t242 = -2.1974870225448043d+1*gammaaa*t134*t2*t49*t77*t78
            t243 = -1.0987435112724021d+1*gammaaa*t117*t2*t49*t77*t78
            t244 = 2.3120211226675547d-2*gammaaa*t169*t25*t34
            t245 = 1.509891345415546d-2*gammaaa*t170*t2*t25
            t246 = 3.364902003271731d+1*gammaaa*t13*t23*t49*t50*t68
            t247 = -1.602334287272254d+0*gammaaa*t23*t34*t49*t50*t70
            t248 = 7.773426462662207d+2*gammaaa*t23*t33*t34*t50*t76
            t249 = 3.170771825372646d-1*gammaaa*t134*t23*t33*t34*t50
            t250 = 1.585385912686323d-1*gammaaa*t117*t23*t33*t34*t50
            t251 = 8.978888376491213d+3*gammaaa*t171*t2*t23*t50
            t252 = -6.104130618180013d-1*gammaaa*t2*t23*t49*t50*t72
            t253 = -4.0427615117563703d+1*(2.5000000000000006d-1*t170*t9
     1         7-2.5000000000000006d-1*t202*t72+t222+t221+t220+t219+t218
     2         +t217+t216+t215+t214+t213+t212+t208+t207+t206+t205+t198+t
     3         197+t196+t194+t193+t192+t190+t189)+6.737935852927286d+0*t
     4         49*t72-6.737935852927286d+0*t170*t22
            t254 = -1.3589022108739912d-1*gammaaa*t2*t23*t253*t50
            t255 = 1.0987435112724021d+1*gammaaa*t134*t2*t23*t49*t50
            t256 = 5.493717556362011d+0*gammaaa*t117*t2*t23*t49*t50
            t257 = 9.894226974230308d-2*rhoa*t163*t60*t64*wght
            t258 = 4.947113487115154d-2*t144*wght
            t259 = -2.774425347201065d-1*gammaaa*t13*t27*t53*t59*t68
            t260 = 1.3211549272386033d-2*gammaaa*t27*t34*t53*t59*t70
            t261 = 6.936063368002663d-2*t13*t27*t30*t68
            t262 = -3.3028873180965085d-3*t27*t30*t34*t70
            t263 = 9.425431845540924d-3*gammaaa*t122*t25*t30*t68
            t264 = -4.4883008788290113d-4*gammaaa*t25*t30*t54*t70
            t265 = -3.170771825372646d-1*gammaaa*t142*t30*t33*t34
            t266 = 3.170771825372646d-1*gammaaa*t143*t27*t33*t34*t53
            t267 = 3.170771825372646d-1*gammaaa*t33*t34*t52*t53*t59
            t268 = -7.926929563431615d-2*t30*t33*t34*t52
            t269 = -2.7178044217479824d-1*gammaaa*t143*t2*t52*t53
            t270 = -6.341543650745292d-1*gammaaa*t128*t27*t33*t34*t56*t5
     1         9
            t271 = 7.926929563431615d-2*t27*t33*t34*t53*t56
            t272 = 1.0771922109189624d-2*gammaaa*t25*t33*t53*t54*t56
            t273 = -2.7178044217479824d-1*gammaaa*t142*t2*t53*t56
            t274 = 5.435608843495965d-1*gammaaa*t128*t143*t2*t27*t56
            t275 = 5.435608843495965d-1*gammaaa*t128*t2*t52*t56*t59
            t276 = -6.794511054369956d-2*t2*t52*t53*t56
            t277 = 1.1104894946660297d+2*t2*t76*t77*t78
            t278 = 6.936063368002663d-2*t13*t25*t68
            t279 = -3.3028873180965085d-3*t25*t34*t70
            t280 = 3.7747283635388634d-3*t2*t25*t72
            t281 = -3.204668574544506d+0*t23*t33*t34*t49*t50
            t282 = -5.552447473330149d+1*t2*t23*t50*t76
            t283 = -3.397255527184978d-2*t117*t2*t23*t50
            t284 = 9.054279776724052d+1*gammaaa*t120*t13*t76*t77
            t285 = 6.283621230360615d-2*gammaaa*t122*t28*t68
            t286 = -1.795320351531605d-3*gammaaa*t28*t54*t70
            t287 = -3.483864968853545d+0*gammaaa*t23*t33*t49*t54*t55
            t288 = -3.018093258908018d+1*gammaaa*t13*t23*t55*t76
            t289 = -8.153413265243947d-1*gammaaa*t129*t2*t235*t27*t59
            t290 = 6.794511054369956d-2*t128*t129*t2*t27
            t291 = 9.233076093591105d-3*gammaaa*t128*t129*t13*t25
            t292 = -9.894226974230308d-2*rhoa*t144*t57*wght
            t293 = t32*(4.947113487115154d-2*rhoa*(-1.3589022108739912d-
     1         1*gammaaa*t2*t27*t53*(2.0517946874646895d-3*gammaaa*t13*t
     2         28*t72-1.846615218718221d-2*gammaaa*t117*t13*t23*t55+t288
     3         +t287+t286+t285+t284+t283+t282+t281+t280+t279+t278+t277)-
     4         1.5098913454155452d-2*gammaaa*t2*t27*t53*t59*t72+3.774728
     5         3635388634d-3*t2*t27*t30*t72+5.129486718661723d-4*gammaaa
     6         *t13*t25*t30*t72-1.3589022108739912d-1*gammaaa*t119*t2*t5
     7         3*t59+2.7178044217479824d-1*gammaaa*t127*t128*t2*t27*t59-
     8         3.397255527184978d-2*t127*t2*t27*t53-4.6165380467955525d-
     9         3*gammaaa*t127*t13*t25*t53+1.3589022108739912d-1*gammaaa*
     :         t2*(t283+t282+t281+t280+t279+t278+t277)*t30+3.39725552718
     ;         4978d-2*t119*t2*t30+t291+t290+t289+t276+t275+t274+t273+t2
     <         72+t271+t270+t269+t268+t267+t266+t265+t264+t263+t262+t261
     =         +t260+t259)*wght-8.245189145191921d-3*t60*t66*wght+t258)+
     >         (t292-t132*t60)*t63+t257
            t294 = 9.894226974230308d-2*rhoa*t163*t62*t64*wght
            t295 = 4.947113487115154d-2*t151*wght
            t296 = -2.774425347201065d-1*gammaaa*t13*t27*t53*t61*t68
            t297 = 1.3211549272386033d-2*gammaaa*t27*t34*t53*t61*t70
            t298 = 1.3872126736005325d-1*t13*t27*t30*t68
            t299 = -6.605774636193017d-3*t27*t30*t34*t70
            t300 = 1.8850863691081848d-2*gammaaa*t122*t25*t30*t68
            t301 = -8.976601757658023d-4*gammaaa*t25*t30*t54*t70
            t302 = -3.170771825372646d-1*gammaaa*t149*t30*t33*t34
            t303 = 3.170771825372646d-1*gammaaa*t150*t27*t33*t34*t53
            t304 = 3.170771825372646d-1*gammaaa*t33*t34*t52*t53*t61
            t305 = -1.585385912686323d-1*t30*t33*t34*t52
            t306 = -2.7178044217479824d-1*gammaaa*t150*t2*t52*t53
            t307 = -6.341543650745292d-1*gammaaa*t128*t27*t33*t34*t56*t6
     1         1
            t308 = 1.585385912686323d-1*t27*t33*t34*t53*t56
            t309 = 2.154384421837925d-2*gammaaa*t25*t33*t53*t54*t56
            t310 = -2.7178044217479824d-1*gammaaa*t149*t2*t53*t56
            t311 = 5.435608843495965d-1*gammaaa*t128*t150*t2*t27*t56
            t312 = 5.435608843495965d-1*gammaaa*t128*t2*t52*t56*t61
            t313 = -1.3589022108739912d-1*t2*t52*t53*t56
            t314 = 2.2209789893320595d+2*t2*t76*t77*t78
            t315 = 1.3872126736005325d-1*t13*t25*t68
            t316 = -6.605774636193017d-3*t25*t34*t70
            t317 = 7.549456727077727d-3*t2*t25*t72
            t318 = -6.409337149089012d+0*t23*t33*t34*t49*t50
            t319 = -1.1104894946660297d+2*t2*t23*t50*t76
            t320 = -6.794511054369956d-2*t117*t2*t23*t50
            t321 = 1.8108559553448106d+2*gammaaa*t120*t13*t76*t77
            t322 = 1.256724246072123d-1*gammaaa*t122*t28*t68
            t323 = -3.59064070306321d-3*gammaaa*t28*t54*t70
            t324 = -6.96772993770709d+0*gammaaa*t23*t33*t49*t54*t55
            t325 = -6.036186517816036d+1*gammaaa*t13*t23*t55*t76
            t326 = -8.153413265243947d-1*gammaaa*t129*t2*t235*t27*t61
            t327 = 1.3589022108739912d-1*t128*t129*t2*t27
            t328 = 1.846615218718221d-2*gammaaa*t128*t129*t13*t25
            t329 = -9.894226974230308d-2*rhoa*t151*t57*wght
            t330 = -3.774728363538864d-3*t2*t25*t72
            t331 = -3.397255527184978d-2*t134*t2*t23*t50
            t332 = -7.549456727077728d-3*t2*t25*t72
            t333 = -6.794511054369956d-2*t134*t2*t23*t50
            t334 = 7.926929563431615d-2*t27*t33*t34*t53*t59
            t335 = 1.0771922109189624d-2*gammaaa*t25*t33*t53*t54*t59
            t336 = 6.794511054369956d-2*t142*t2*t30
            t337 = -6.794511054369956d-2*t143*t2*t27*t53
            t338 = -9.233076093591105d-3*gammaaa*t13*t143*t25*t53
            t339 = -6.794511054369956d-2*t2*t52*t53*t59
            t340 = 1.3589022108739912d-1*t128*t2*t27*t56*t59
            t341 = 1.846615218718221d-2*gammaaa*t128*t13*t25*t56*t59
            t342 = t63*(-4.947113487115154d-2*rhoa*t144*t60*wght-4.94711
     1         3487115154d-2*rhoa*t157*t57*wght-t145*t60)+t32*(4.9471134
     2         87115154d-2*rhoa*(-2.7178044217479824d-1*gammaaa*t142*t2*
     3         t53*t59+5.435608843495965d-1*gammaaa*t128*t143*t2*t27*t59
     4         -2.3082690233977762d-3*t13*t25*t53*t56+6.273423758374375d
     5         -4*gammaaa*t122*t128*t27*t28*t56-8.153413265243947d-1*gam
     6         maaa*t154*t2*t235*t27*t56-1.3589022108739912d-1*gammaaa*t
     7         2*t27*t53*(1.866356233314399d-1*t13*t23*t49*t55-5.3859610
     8         54594812d-3*t28*t33*t54)-2.692980527297406d-3*t25*t30*t33
     9         *t54-3.1367118791871873d-4*gammaaa*t122*t28*t52*t53+3.659
     :         497192385051d-4*gammaaa*t229*t27*t28*t33*t53+2.7178044217
     ;         479824d-1*gammaaa*t128*t154*t2*t52+t341+t340-3.1707718253
     <         72646d-1*gammaaa*t128*t154*t27*t33*t34+t339+t338+t337+t33
     =         6+t335+t334)*wght+2.473556743557577d-2*t157*wght)+9.89422
     >         6974230308d-2*rhoa*t153*t163*t57*wght
            t343 = 9.894226974230308d-2*rhoa*t163*t57*t60*t62*wght
            t344 = t32*(4.947113487115154d-2*rhoa*(-8.153413265243947d-1
     1         *gammaaa*t2*t235*t27*t56*t59*t61+2.7178044217479824d-1*ga
     2         mmaaa*t128*t2*t52*t59*t61-3.170771825372646d-1*gammaaa*t1
     3         28*t27*t33*t34*t59*t61+6.794511054369956d-2*t128*t2*t27*t
     4         56*t61+9.233076093591105d-3*gammaaa*t128*t13*t25*t56*t61+
     5         5.385961054594812d-3*gammaaa*t25*t33*t53*t54*t61-3.397255
     6         527184978d-2*t2*t52*t53*t61+3.9634647817158075d-2*t27*t33
     7         *t34*t53*t61-1.3589022108739912d-1*gammaaa*t142*t2*t53*t6
     8         1+2.7178044217479824d-1*gammaaa*t128*t143*t2*t27*t61-1.35
     9         89022108739912d-1*gammaaa*t149*t2*t53*t59+2.7178044217479
     :         824d-1*gammaaa*t128*t150*t2*t27*t59-4.6165380467955525d-3
     ;         *t13*t25*t53*t56+1.254684751674875d-3*gammaaa*t122*t128*t
     <         27*t28*t56-1.3589022108739912d-1*gammaaa*t2*t27*t53*(3.73
     =         2712466628798d-1*t13*t23*t49*t55-1.0771922109189624d-2*t2
     >         8*t33*t54)-5.385961054594812d-3*t25*t30*t33*t54-6.2734237
     ?         58374375d-4*gammaaa*t122*t28*t52*t53+7.318994384770102d-4
     @         *gammaaa*t229*t27*t28*t33*t53-3.397255527184978d-2*t150*t
     1         2*t27*t53-4.6165380467955525d-3*gammaaa*t13*t150*t25*t53+
     2         t341+t340+t339+t338+t337+t336+t335+t334+3.397255527184978
     3         d-2*t149*t2*t30)*wght+2.473556743557577d-2*t159*wght)
            t345 = -4.947113487115154d-2*rhoa*t159*t57*wght
            t346 = 1/t1**8.0d+0
            t347 = -1.4841340461345462d-1*rhoa*t157*t60*t63*wght+9.89422
     1         6974230308d-2*rhoa*t163*t60**3*wght+4.947113487115154d-2*
     2         rhoa*t32*(-8.153413265243947d-1*gammaaa*t2*t235*t27*t59**
     3         3-6.924807070193328d-3*t13*t25*t53*t59+1.8820271275123124
     4         d-3*gammaaa*t122*t128*t27*t28*t59-3.1968635306266346d-5*g
     5         ammaaa*t346*t53*t55-2.3525339093903905d-4*t122*t27*t28*t5
     6         3+2.0383533163109868d-1*t128*t154*t2*t27+2.76992282807733
     7         14d-2*gammaaa*t128*t13*t154*t25)*wght
            t348 = 2.50936950334975d-3*gammaaa*t122*t128*t27*t28*t59
            t349 = -9.233076093591105d-3*t13*t25*t53*t59
            t350 = t63*(-4.947113487115154d-2*rhoa*t157*t62*wght-9.89422
     1         6974230308d-2*rhoa*t159*t60*wght)+9.894226974230308d-2*rh
     2         oa*t153*t163*t62*wght+4.947113487115154d-2*rhoa*t32*(1.35
     3         89022108739912d-1*t128*t2*t27*t59*t61+1.846615218718221d-
     4         2*gammaaa*t128*t13*t25*t59*t61-2.3082690233977762d-3*t13*
     5         t25*t53*t61+6.273423758374375d-4*gammaaa*t122*t128*t27*t2
     6         8*t61-8.153413265243947d-1*gammaaa*t154*t2*t235*t27*t61-6
     7         .393727061253269d-5*gammaaa*t346*t53*t55-4.70506781878078
     8         1d-4*t122*t27*t28*t53+t349+t348+1.3589022108739912d-1*t12
     9         8*t154*t2*t27+1.846615218718221d-2*gammaaa*t128*t13*t154*
     :         t25)*wght
            fnc(iq) = 4.947113487115154d-2*rhoa*log(1.358902210873991d-1
     1         *gammaaa*(t11+1.0d+0)*t2/(1.8466152187182203d-2*t12*t13/t
     2         10**2.0d+0+t11+1.0d+0)+1.0d+0)*wght+fnc(iq)
            Amat(iq,D1_RA) = 2.473556743557577d-2*t58*wght+4.94711348711
     1         5154d-2*rhoa*t32*t57*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 4.947113487115154d-2*rhoa*t32*t60*wght+Cma
     1         t(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 4.947113487115154d-2*rhoa*t32*t62*wght+Cma
     1         t(iq,D1_GAB)
            Amat2(iq,D2_RA_RA) = -8.245189145191921d-3*t58*t66*wght+t65+
     1         t132*t32+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 8.245189145191922d-3*t58*t66*wght+t65+t
     1         139*t32+Amat2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = t146+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = -4.947113487115154d-2*rhoa*t57*t62*t63
     1         *wght+t152*t32+Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = t146+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = t158+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = -4.947113487115154d-2*rhoa*t60*t62*t6
     1         3*wght+4.947113487115154d-2*rhoa*t159*t32*wght+Cmat2(iq,D
     2         2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = t158+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = -4.947113487115154d-2*rhoa*t160*t63*w
     1         ght+4.947113487115154d-2*rhoa*t162*t32*wght+Cmat2(iq,D2_G
     2         AB_GAB)
            Amat3(iq,D3_RA_RA_RA) = t32*(4.947113487115154d-2*rhoa*(-1.3
     1         589022108739912d-1*gammaaa*t2*t27*t53*(-1.343776487986367
     2         d+1*t117*t12*t120*t13*t49*t77+9.953899911010125d-1*t12*t1
     3         3*t23*t49*t55*t72-8.709662422133866d-1*t12*t23*t49*t54*t5
     4         5*t70+2.5852613062055096d-1*t117*t12*t23*t33*t54*t55+4.47
     5         92549599545567d+0*t117*t12*t13*t23*t49*t55-3.693230437436
     6         442d-2*t12*t13*t223*t23*t55+2.4402862532009376d+3*t12*t13
     7         *t171*t23*t55-2.722902533156265d-2*t12*t169*t28*t54-1.231
     8         076812478814d-2*t12*t13*t170*t28+t233+t232+t231+t230+t228
     9         +t227+t226+t225+t224+t187+t186+t185+t184+t183+t182+t181+t
     :         180+t179+t178+t177+t176+t175+t174)-4.529674036246636d-2*g
     ;         ammaaa*t2*t27*t53*t56*t72+4.529674036246636d-2*gammaaa*t2
     <         *t30*t52*t72+3.963464781715809d-2*gammaaa*t27*t34*t53*t56
     =         *t70-3.963464781715809d-2*gammaaa*t30*t34*t52*t70-8.32327
     >         6041603197d-1*gammaaa*t13*t27*t53*t56*t68+8.3232760416031
     ?         97d-1*gammaaa*t13*t30*t52*t68+9.512315476117938d-1*gammaa
     @         a*t33*t34*t52*t53*t56-4.0767066326219736d-1*gammaaa*t119*
     1         t2*t53*t56+8.153413265243947d-1*gammaaa*t127*t128*t2*t27*
     2         t56-4.0767066326219736d-1*gammaaa*t127*t2*t52*t53+4.75615
     3         7738058969d-1*gammaaa*t127*t27*t33*t34*t53-4.756157738058
     4         969d-1*gammaaa*t119*t30*t33*t34-9.512315476117938d-1*gamm
     5         aaa*t128*t129*t27*t33*t34-4.7341384892716565d-2*gammaaa*t
     6         169*t27*t30*t34-4.529674036246638d-2*gammaaa*t170*t2*t27*
     7         t30+1.3589022108739912d-1*gammaaa*t2*(t225+t224+t187+t186
     8         +t185+t184+t183+t182+t181+t180+t179+t178+t177+t176+t175+t
     9         174)*t30+t236+t234+t168+t166)*wght-2.473556743557576d-2*t
     :         57*t66*wght+7.420670230672731d-2*t131*wght)+t63*(-9.89422
     ;         6974230308d-2*rhoa*t131*t57*wght+t238+t237)+1.23677837177
     <         87893d-2*t58*t72*wght+t164+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = t32*(4.947113487115154d-2*rhoa*(-1.3
     1         589022108739912d-1*gammaaa*t2*t27*t53*(-8.958509919909113
     2         d+0*t12*t120*t13*t134*t49*t77-4.4792549599545567d+0*t117*
     3         t12*t120*t13*t49*t77-3.317966637003376d-1*t12*t13*t23*t49
     4         *t55*t72-8.709662422133868d-1*t12*t23*t49*t54*t55*t70+1.7
     5         235075374703399d-1*t12*t134*t23*t33*t54*t55+8.61753768735
     6         17d-2*t117*t12*t23*t33*t54*t55+2.9861699733030383d+0*t12*
     7         t13*t134*t23*t49*t55+1.4930849866515192d+0*t117*t12*t13*t
     8         23*t49*t55-3.693230437436442d-2*t12*t13*t23*t253*t55+2.44
     9         0286253200938d+3*t12*t13*t171*t23*t55+1.1071142167778228d
     :         -2*t12*t169*t28*t54+4.1035893749293806d-3*t12*t13*t170*t2
     ;         8+t256+t255+t254+t252+t251+t250+t249+t248+t247+t246+t245+
     <         t244+t243+t242+t241+t240+t239+t233+t232+t231+t230+t228+t2
     =         27+t226+t179+t178)+1.509891345415546d-2*gammaaa*t2*t27*t5
     >         3*t56*t72-1.509891345415546d-2*gammaaa*t2*t30*t52*t72+3.9
     ?         6346478171581d-2*gammaaa*t27*t34*t53*t56*t70-3.9634647817
     @         1581d-2*gammaaa*t30*t34*t52*t70-8.323276041603195d-1*gamm
     1         aaa*t13*t27*t53*t56*t68+8.323276041603195d-1*gammaaa*t13*
     2         t30*t52*t68+9.512315476117937d-1*gammaaa*t33*t34*t52*t53*
     3         t56-2.7178044217479824d-1*gammaaa*t136*t2*t53*t56-1.35890
     4         22108739912d-1*gammaaa*t119*t2*t53*t56+5.435608843495965d
     5         -1*gammaaa*t128*t137*t2*t27*t56+2.7178044217479824d-1*gam
     6         maaa*t127*t128*t2*t27*t56-2.7178044217479824d-1*gammaaa*t
     7         137*t2*t52*t53-1.3589022108739912d-1*gammaaa*t127*t2*t52*
     8         t53+3.170771825372646d-1*gammaaa*t137*t27*t33*t34*t53+1.5
     9         85385912686323d-1*gammaaa*t127*t27*t33*t34*t53-3.17077182
     :         5372646d-1*gammaaa*t136*t30*t33*t34-1.585385912686323d-1*
     ;         gammaaa*t119*t30*t33*t34-9.512315476117937d-1*gammaaa*t12
     <         8*t129*t27*t33*t34+2.3120211226675547d-2*gammaaa*t169*t27
     =         *t30*t34+1.509891345415546d-2*gammaaa*t170*t2*t27*t30+1.3
     >         589022108739912d-1*gammaaa*t2*(t256+t255+t254+t252+t251+t
     ?         250+t249+t248+t247+t246+t245+t244+t243+t242+t241+t240+t23
     @         9+t179+t178)*t30+t236+t234+t168+t166)*wght+8.245189145191
     1         925d-3*t57*t66*wght+4.947113487115154d-2*t138*wght+2.4735
     2         56743557577d-2*t131*wght)+t63*(-9.894226974230308d-2*rhoa
     3         *t138*t57*wght+t238+t237)-4.1225945725959623d-3*t58*t72*w
     4         ght+t164+Amat3(iq,D3_RA_RA_RB)
            Cmat3(iq,D3_RA_RA_GAA) = t293+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = t32*(4.947113487115154d-2*rhoa*(-1.
     1         3589022108739912d-1*gammaaa*t2*t27*t53*(4.103589374929379
     2         d-3*gammaaa*t13*t28*t72-3.693230437436442d-2*gammaaa*t117
     3         *t13*t23*t55+t325+t324+t323+t322+t321+t320+t319+t318+t317
     4         +t316+t315+t314)-1.5098913454155452d-2*gammaaa*t2*t27*t53
     5         *t61*t72+7.549456727077727d-3*t2*t27*t30*t72+1.0258973437
     6         323447d-3*gammaaa*t13*t25*t30*t72-1.3589022108739912d-1*g
     7         ammaaa*t119*t2*t53*t61+2.7178044217479824d-1*gammaaa*t127
     8         *t128*t2*t27*t61-6.794511054369956d-2*t127*t2*t27*t53-9.2
     9         33076093591105d-3*gammaaa*t127*t13*t25*t53+t328+t327+t326
     :         +1.3589022108739912d-1*gammaaa*t2*t30*(t320+t319+t318+t31
     ;         7+t316+t315+t314)+t313+t312+t311+t310+t309+t308+t307+t306
     <         +t305+t304+t303+t302+t301+t300+6.794511054369956d-2*t119*
     =         t2*t30+t299+t298+t297+t296)*wght-8.245189145191921d-3*t62
     >         *t66*wght+t295)+(t329-t132*t62)*t63+t294+Cmat3(iq,D3_RA_R
     ?         A_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = t293+Cmat3(iq,D3_RA_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = t32*(4.947113487115154d-2*rhoa*(-1.
     1         3589022108739912d-1*gammaaa*t2*t27*t53*(-2.05179468746468
     2         97d-3*gammaaa*t13*t28*t72-1.846615218718221d-2*gammaaa*t1
     3         3*t134*t23*t55+t331+t330+t288+t287+t286+t285+t284+t282+t2
     4         81+t279+t278+t277)+1.5098913454155458d-2*gammaaa*t2*t27*t
     5         53*t59*t72-3.774728363538864d-3*t2*t27*t30*t72-5.12948671
     6         8661724d-4*gammaaa*t13*t25*t30*t72-1.3589022108739912d-1*
     7         gammaaa*t136*t2*t53*t59+2.7178044217479824d-1*gammaaa*t12
     8         8*t137*t2*t27*t59-3.397255527184978d-2*t137*t2*t27*t53-4.
     9         6165380467955525d-3*gammaaa*t13*t137*t25*t53+1.3589022108
     :         739912d-1*gammaaa*t2*t30*(t331+t330+t282+t281+t279+t278+t
     ;         277)+3.397255527184978d-2*t136*t2*t30+t291+t290+t289+t276
     <         +t275+t274+t273+t272+t271+t270+t269+t268+t267+t266+t265+t
     =         264+t263+t262+t261+t260+t259)*wght+8.245189145191922d-3*t
     >         60*t66*wght+t258)+(t292-t139*t60)*t63+t257+Cmat3(iq,D3_RA
     ?         _RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = t32*(4.947113487115154d-2*rhoa*(-1.
     1         3589022108739912d-1*gammaaa*t2*t27*t53*(-4.10358937492937
     2         95d-3*gammaaa*t13*t28*t72-3.693230437436442d-2*gammaaa*t1
     3         3*t134*t23*t55+t333+t332+t325+t324+t323+t322+t321+t319+t3
     4         18+t316+t315+t314)+1.5098913454155458d-2*gammaaa*t2*t27*t
     5         53*t61*t72-7.549456727077728d-3*t2*t27*t30*t72-1.02589734
     6         37323449d-3*gammaaa*t13*t25*t30*t72-1.3589022108739912d-1
     7         *gammaaa*t136*t2*t53*t61+2.7178044217479824d-1*gammaaa*t1
     8         28*t137*t2*t27*t61-6.794511054369956d-2*t137*t2*t27*t53-9
     9         .233076093591105d-3*gammaaa*t13*t137*t25*t53+1.3589022108
     :         739912d-1*gammaaa*t2*t30*(t333+t332+t319+t318+t316+t315+t
     ;         314)+t328+t327+t326+t313+t312+t311+t310+t309+t308+t307+t3
     <         06+t305+t304+t303+t302+t301+t300+6.794511054369956d-2*t13
     =         6*t2*t30+t299+t298+t297+t296)*wght+8.245189145191922d-3*t
     >         62*t66*wght+t295)+(t329-t139*t62)*t63+t294+Cmat3(iq,D3_RA
     ?         _RB_GAB)
            Cmat3(iq,D3_RA_GAA_GAA) = t342+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = t63*(-4.947113487115154d-2*rhoa*t1
     1         51*t60*wght-t145*t62+t345)+t344+t343+Cmat3(iq,D3_RA_GAA_G
     2         AB)
            Cmat3(iq,D3_RA_GAA_GBB) = t342+Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = t63*(-4.947113487115154d-2*rhoa*t1
     1         51*t62*wght-4.947113487115154d-2*rhoa*t162*t57*wght-t152*
     2         t62)+t32*(4.947113487115154d-2*rhoa*(2.7178044217479824d-
     3         1*t128*t2*t27*t56*t61+3.693230437436442d-2*gammaaa*t128*t
     4         13*t25*t56*t61+2.154384421837925d-2*gammaaa*t25*t33*t53*t
     5         54*t61-1.3589022108739912d-1*t2*t52*t53*t61+1.58538591268
     6         6323d-1*t27*t33*t34*t53*t61-2.7178044217479824d-1*gammaaa
     7         *t149*t2*t53*t61+5.435608843495965d-1*gammaaa*t128*t150*t
     8         2*t27*t61-9.233076093591105d-3*t13*t25*t53*t56+2.50936950
     9         334975d-3*gammaaa*t122*t128*t27*t28*t56-8.153413265243947
     :         d-1*gammaaa*t161*t2*t235*t27*t56-1.3589022108739912d-1*ga
     ;         mmaaa*t2*t27*t53*(7.465424933257596d-1*t13*t23*t49*t55-2.
     <         154384421837925d-2*t28*t33*t54)-1.0771922109189624d-2*t25
     =         *t30*t33*t54-1.254684751674875d-3*gammaaa*t122*t28*t52*t5
     >         3+1.4637988769540203d-3*gammaaa*t229*t27*t28*t33*t53-1.35
     ?         89022108739912d-1*t150*t2*t27*t53-1.846615218718221d-2*ga
     @         mmaaa*t13*t150*t25*t53+2.7178044217479824d-1*gammaaa*t128
     1         *t161*t2*t52-3.170771825372646d-1*gammaaa*t128*t161*t27*t
     2         33*t34+1.3589022108739912d-1*t149*t2*t30)*wght+2.47355674
     3         3557577d-2*t162*wght)+9.894226974230308d-2*rhoa*t160*t163
     4         *t57*wght+Cmat3(iq,D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = t63*(-4.947113487115154d-2*rhoa*t1
     1         44*t62*wght-t152*t60+t345)+t344+t343+Cmat3(iq,D3_RA_GAB_G
     2         BB)
            Cmat3(iq,D3_RA_GBB_GBB) = t342+Cmat3(iq,D3_RA_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = t347+Cmat3(iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = t350+Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = t347+Cmat3(iq,D3_GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = t63*(-9.894226974230308d-2*rhoa*t
     1         159*t62*wght-4.947113487115154d-2*rhoa*t162*t60*wght)+4.9
     2         47113487115154d-2*rhoa*t32*(2.7178044217479824d-1*t128*t2
     3         *t27*t59*t61+3.693230437436442d-2*gammaaa*t128*t13*t25*t5
     4         9*t61-9.233076093591105d-3*t13*t25*t53*t61+2.509369503349
     5         75d-3*gammaaa*t122*t128*t27*t28*t61-8.153413265243947d-1*
     6         gammaaa*t161*t2*t235*t27*t59-1.278745412250654d-4*gammaaa
     7         *t346*t53*t55-9.410135637561562d-4*t122*t27*t28*t53+t349+
     8         t348+6.794511054369956d-2*t128*t161*t2*t27+9.233076093591
     9         105d-3*gammaaa*t128*t13*t161*t25)*wght+9.894226974230308d
     :         -2*rhoa*t160*t163*t60*wght+Cmat3(iq,D3_GAA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = t350+Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = -1.4841340461345462d-1*rhoa*t162*
     1         t62*t63*wght+9.894226974230308d-2*rhoa*t163*t62**3*wght+4
     2         .947113487115154d-2*rhoa*t32*(-8.153413265243947d-1*gamma
     3         aa*t2*t235*t27*t61**3-2.7699228280773314d-2*t13*t25*t53*t
     4         61+7.52810851004925d-3*gammaaa*t122*t128*t27*t28*t61-2.55
     5         7490824501308d-4*gammaaa*t346*t53*t55-1.8820271275123124d
     6         -3*t122*t27*t28*t53+4.0767066326219736d-1*t128*t161*t2*t2
     7         7+5.539845656154663d-2*gammaaa*t128*t13*t161*t25)*wght+Cm
     8         at3(iq,D3_GAB_GAB_GAB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = rhoa-rhob
            t3 = 1/t1
            t4 = 1.0d+0-t2*t3
            t5 = t4**6.666666666666666d-1
            t6 = t2*t3+1.0d+0
            t7 = t6**6.666666666666666d-1
            t8 = 5.0d-1*t7+5.0d-1*t5
            t9 = t8**3.0d+0
            t10 = gammabb+2.0d+0*gammaab+gammaaa
            t11 = t1**1.1666666666666667d+0
            t12 = 1/t11**2.0d+0
            t13 = t8**2.0d+0
            t14 = 1/t13
            t15 = 1/t9
            t16 = t1**3.333333333333333d-1
            t17 = t16**5.0d-1
            t18 = 1/t17
            t19 = 1.5752466357994865d+0*t18
            t20 = t19+3.72744d+0
            t21 = atan(6.15199081975908d+0/t20)
            t22 = 7.876233178997433d-1*t18
            t23 = t22+1.0498d-1
            t24 = t23**2
            t25 = 1/t16
            t26 = 6.203504908994001d-1*t25
            t27 = t26+2.935818660072219d+0*t18+1.29352d+1
            t28 = abs(t27)
            t29 = 1/t28
            t30 = log(1.0d+0*t24*t29)
            t31 = abs(t25)
            t32 = log(6.203504908994001d-1*t29*t31)
            t33 = t4**1.3333333333333333d+0
            t34 = t6**1.3333333333333333d+0
            t35 = t34+t33-2.0d+0
            t36 = t19+1.13107d+0
            t37 = atan(7.123108917818117d+0/t36)
            t38 = t22+4.7584000000000004d-3
            t39 = t38**2
            t40 = t26+8.908571061768626d-1*t18+1.30045d+1
            t41 = abs(t40)
            t42 = 1/t41
            t43 = log(1.0d+0*t39*t42)
            t44 = log(6.203504908994001d-1*t31*t42)
            t45 = t2**4
            t46 = 1/t1**4
            t47 = t19+7.06042d+0
            t48 = t22+3.25d-1
            t49 = t48**2
            t50 = t26+5.560951426165704d+0*t18+1.8057800000000002d+1
            t51 = abs(t50)
            t52 = 1/t51
            t53 = 1.709920934161365d+0*(2.2478670955426108d-3*log(1.0d+0
     1         *t49*t52)+1.554535d-2*log(6.203504908994001d-1*t31*t52)+5
     2         .249139316978092d-2*atan(4.7309269095601136d+0/t47)-3.109
     3         07d-2*t32-9.690227711544375d-4*t30-3.8783294878113006d-2*
     4         t21)+1.688686394038963d-2*t44+6.991732350764465d-6*t43+5.
     5         365091848883603d-3*t37
            t54 = t45*t46*t53-1.688686394038963d-2*t44-6.991732350764465
     1         d-6*t43-5.365091848883603d-3*t37
            t55 = 1.1250000000000002d+0*t35*t54+3.10907d-2*t32+9.6902277
     1         11544375d-4*t30+3.8783294878113006d-2*t21
            t56 = exp(-4.0427615117563703d+1*t15*t55)
            t57 = t56-1.0d+0
            t58 = 1/t57
            t59 = 1.7121095002288234d-1*t10*t12*t14*t58
            t60 = t59+1.0d+0
            t61 = t10**2.0d+0
            t62 = 1/t11**4.0d+0
            t63 = 1/t8**4.0d+0
            t64 = 1/t57**2.0d+0
            t65 = 2.931318940773791d-2*t61*t62*t63*t64+t59+1.0d+0
            t66 = 1/t65
            t67 = 1.7121095002288234d-1*t10*t12*t14*t60*t66+1.0d+0
            t68 = log(t67)
            t69 = 1/t1**2
            t70 = t2*t69
            t71 = -t3
            t72 = t71+t70
            t73 = t4**3.333333333333333d-1
            t74 = 1/t73
            t75 = -t2*t69
            t76 = t75+t3
            t77 = t6**3.333333333333333d-1
            t78 = 1/t77
            t79 = 3.333333333333333d-1*t76*t78+3.333333333333333d-1*t72*
     1         t74
            t80 = 2.473556743557577d-2*t68*t9*wght
            t81 = 1/t67
            t82 = t1**1.6666666666666674d-1
            t83 = 1/t11**3.0d+0
            t84 = -3.994922167200588d-1*t10*t14*t60*t66*t82*t83
            t85 = -3.4242190004576467d-1*t10*t12*t15*t58*t79
            t86 = -3.994922167200588d-1*t10*t14*t58*t82*t83
            t87 = 1/t57**2
            t88 = 1/t1**6.666666666666667d-1
            t89 = 1/t17**3
            t90 = 1/t20**2
            t91 = 3.784699104639999d+1*t90+1
            t92 = 1/t91
            t93 = 6.264085709464389d-2*t88*t89*t90*t92
            t94 = 1/t24
            t95 = -2.067834969664667d-1/t1**1.3333333333333333d+0
            t96 = t95-4.8930311001203647d-1*t88*t89
            t97 = 1/t27
            t98 = -1.0d+0*t24*t29*t96*t97-2.625411059665811d-1*t23*t29*t
     1         88*t89
            t99 = 9.690227711544375d-4*t28*t94*t98
            t100 = 1/t31
            t101 = 1/t1**1.6666666666666666d+0
            t102 = -6.203504908994001d-1*t29*t31*t96*t97-2.0678349696646
     1         67d-1*t100*t101*t29
            t103 = 5.011795824473985d-2*t100*t102*t28
            t104 = 1/t36**2
            t105 = 5.07386806551d+1*t104+1
            t106 = 1/t105
            t107 = -1.0033305979455584d-2*t104*t106*t88*t89
            t108 = 1/t39
            t109 = t95-1.4847618436281043d-1*t88*t89
            t110 = 1/t40
            t111 = -2.625411059665811d-1*t38*t42*t88*t89-1.0d+0*t109*t11
     1         0*t39*t42
            t112 = -6.991732350764465d-6*t108*t111*t41
            t113 = -6.203504908994001d-1*t109*t110*t31*t42-2.06783496966
     1         4667d-1*t100*t101*t42
            t114 = -2.722148880047894d-2*t100*t113*t41
            t115 = 1/t47**2
            t116 = 2.238166942360001d+1*t115+1
            t117 = 1/t116
            t118 = 1/t49
            t119 = t95-9.26825237694284d-1*t88*t89
            t120 = 1/t50
            t121 = -2.625411059665811d-1*t48*t52*t88*t89-1.0d+0*t119*t12
     1         0*t49*t52
            t122 = -6.203504908994001d-1*t119*t120*t31*t52-2.06783496966
     1         4667d-1*t100*t101*t52
            t123 = 1.709920934161365d+0*(-9.690227711544375d-4*t28*t94*t
     1         98-6.264085709464389d-2*t88*t89*t90*t92+6.519760588836059
     2         d-2*t115*t117*t88*t89+2.5058979122369923d-2*t100*t122*t51
     3         +2.2478670955426108d-3*t118*t121*t51-5.011795824473985d-2
     4         *t100*t102*t28)+1.0033305979455584d-2*t104*t106*t88*t89+2
     5         .722148880047894d-2*t100*t113*t41+6.991732350764465d-6*t1
     6         08*t111*t41
            t124 = t123*t45*t46
            t125 = 1/t1**5
            t126 = -4*t125*t45*t53
            t127 = t2**3
            t128 = 4*t127*t46*t53+t126+t124+t114+t112+t107
            t129 = 1.3333333333333333d+0*t76*t77+1.3333333333333333d+0*t
     1         72*t73
            t130 = t99+t93+1.1250000000000002d+0*t129*t54+1.125000000000
     1         0002d+0*t128*t35+t103
            t131 = 1.2128284535269111d+2*t55*t63*t79-4.0427615117563703d
     1         +1*t130*t15
            t132 = -1.7121095002288234d-1*t10*t12*t131*t14*t56*t87
            t133 = t86+t85+t132
            t134 = 1/t65**2
            t135 = 1/t8**5.0d+0
            t136 = 1/t11**5.0d+0
            t137 = -1.3679488390277694d-1*t136*t61*t63*t64*t82
            t138 = 1/t57**3.0d+0
            t139 = t86+t85-1.1725275763095165d-1*t135*t61*t62*t64*t79-5.
     1         862637881547582d-2*t131*t138*t56*t61*t62*t63+t137+t132
            t140 = t84-3.4242190004576467d-1*t10*t12*t15*t60*t66*t79+1.7
     1         121095002288234d-1*t10*t12*t133*t14*t66-1.712109500228823
     2         4d-1*t10*t12*t134*t139*t14*t60
            t141 = t70+t3
            t142 = t75+t71
            t143 = 3.333333333333333d-1*t142*t78+3.333333333333333d-1*t1
     1         41*t74
            t144 = -3.4242190004576467d-1*t10*t12*t143*t15*t58
            t145 = -4*t127*t46*t53+t126+t124+t114+t112+t107
            t146 = 1.3333333333333333d+0*t142*t77+1.3333333333333333d+0*
     1         t141*t73
            t147 = t99+t93+1.1250000000000002d+0*t146*t54+1.125000000000
     1         0002d+0*t145*t35+t103
            t148 = 1.2128284535269111d+2*t143*t55*t63-4.0427615117563703
     1         d+1*t147*t15
            t149 = -1.7121095002288234d-1*t10*t12*t14*t148*t56*t87
            t150 = t86+t149+t144
            t151 = t86-1.1725275763095165d-1*t135*t143*t61*t62*t64-5.862
     1         637881547582d-2*t138*t148*t56*t61*t62*t63+t149+t144+t137
            t152 = t84-3.4242190004576467d-1*t10*t12*t143*t15*t60*t66+1.
     1         7121095002288234d-1*t10*t12*t14*t150*t66-1.71210950022882
     2         34d-1*t10*t12*t134*t14*t151*t60
            t153 = 5.862637881547582d-2*t10*t62*t63*t64+1.71210950022882
     1         34d-1*t12*t14*t58
            t154 = 2.931318940773791d-2*t10*t58*t62*t63*t66+1.7121095002
     1         288234d-1*t12*t14*t60*t66-1.7121095002288234d-1*t10*t12*t
     2         134*t14*t153*t60
            t155 = 2.473556743557577d-2*t1*t154*t81*t9*wght
            t156 = 1.1725275763095165d-1*t10*t62*t63*t64+3.4242190004576
     1         467d-1*t12*t14*t58
            t157 = 5.862637881547582d-2*t10*t58*t62*t63*t66+3.4242190004
     1         576467d-1*t12*t14*t60*t66-1.7121095002288234d-1*t10*t12*t
     2         134*t14*t156*t60
            t158 = t79**2
            t159 = t72**2
            t160 = 1/t33
            t161 = 1/t1**3
            t162 = -2*t161*t2
            t163 = 2*t69
            t164 = t163+t162
            t165 = t76**2
            t166 = 1/t34
            t167 = 2*t161*t2
            t168 = -2*t69
            t169 = t168+t167
            t170 = 3.333333333333333d-1*t169*t78+3.333333333333333d-1*t1
     1         64*t74-1.111111111111111d-1*t165*t166-1.111111111111111d-
     2         1*t159*t160
            t171 = 1/t67**2
            t172 = t140**2
            t173 = t1**3.333333333333335d-1
            t174 = 1.398222758520206d+0*t10*t14*t173*t60*t62*t66
            t175 = 1/t1**8.333333333333333d-1
            t176 = -6.658203612000984d-2*t10*t14*t175*t60*t66*t83
            t177 = 1/t65**3
            t178 = t139**2
            t179 = 1.027265700137294d+0*t10*t12*t158*t58*t63
            t180 = -3.4242190004576467d-1*t10*t12*t15*t170*t58
            t181 = 1.5979688668802353d+0*t10*t15*t58*t79*t82*t83
            t182 = 1.398222758520206d+0*t10*t14*t173*t58*t62
            t183 = -6.658203612000984d-2*t10*t14*t175*t58*t83
            t184 = exp(-8.085523023512741d+1*t15*t55)
            t185 = 1/t57**3
            t186 = t131**2
            t187 = 3.4242190004576467d-1*t10*t12*t14*t184*t185*t186
            t188 = -1.7121095002288234d-1*t10*t12*t14*t186*t56*t87
            t189 = 1/t1**2.3333333333333334d+0
            t190 = 1/t20**5
            t191 = 1/t91**2
            t192 = -1.2448480831567728d+0*t189*t190*t191
            t193 = 1/t20**3
            t194 = 3.289159980064472d-2*t189*t193*t92
            t195 = 1/t1**1.3333333333333336d+0
            t196 = 1/t17**5
            t197 = -3.1320428547321943d-2*t195*t196*t90*t92
            t198 = 1/t1**1.6666666666666669d+0
            t199 = -4.176057139642926d-2*t198*t89*t90*t92
            t200 = 9.690227711544375d-4*t27*t29*t94*t96*t98
            t201 = 5.011795824473985d-2*t100*t102*t27*t29*t96
            t202 = t96**2
            t203 = 1/t27**2
            t204 = 2.7571132928862224d-1/t1**2.333333333333333d+0
            t205 = 3.262020733413577d-1*t198*t89+t204+2.4465155500601823
     1         d-1*t195*t196
            t206 = 5.250822119331622d-1*t23*t29*t88*t89*t96*t97-1.0d+0*t
     1         205*t24*t29*t97+1.7502740397772074d-1*t198*t23*t29*t89+2.
     2         0d+0*t202*t203*t24*t29+1.3127055298329054d-1*t195*t196*t2
     3         3*t29+3.446391616107778d-2*t189*t29
            t207 = 9.690227711544375d-4*t206*t28*t94
            t208 = 1/t23**3
            t209 = 2.544083100456872d-4*t208*t28*t88*t89*t98
            t210 = 1/t1**2.6666666666666666d+0
            t211 = 4.135669939329334d-1*t100*t101*t29*t96*t97-6.20350490
     1         8994001d-1*t205*t29*t31*t97+1.2407009817988002d+0*t202*t2
     2         03*t29*t31+2.7571132928862224d-1*t100*t210*t29
            t212 = 5.011795824473985d-2*t100*t211*t28
            t213 = 1/t1**9.999999999999999d-1
            t214 = 1.670598608157995d-2*t100*t102*t213*t28
            t215 = 1/t36**5
            t216 = 1/t105**2
            t217 = 2.6730712388370664d-1*t189*t215*t216
            t218 = 1/t36**3
            t219 = -5.26831049669476d-3*t106*t189*t218
            t220 = 5.016652989727792d-3*t104*t106*t195*t196
            t221 = 6.68887065297039d-3*t104*t106*t198*t89
            t222 = -6.991732350764465d-6*t108*t109*t111*t40*t42
            t223 = -2.722148880047894d-2*t100*t109*t113*t40*t42
            t224 = t109**2
            t225 = 1/t40**2
            t226 = 9.89841229085403d-2*t198*t89+t204+7.423809218140521d-
     1         2*t195*t196
            t227 = 5.250822119331622d-1*t109*t110*t38*t42*t88*t89+1.7502
     1         740397772074d-1*t198*t38*t42*t89-1.0d+0*t110*t226*t39*t42
     2         +2.0d+0*t224*t225*t39*t42+1.3127055298329054d-1*t195*t196
     3         *t38*t42+3.446391616107778d-2*t189*t42
            t228 = -6.991732350764465d-6*t108*t227*t41
            t229 = 1/t38**3
            t230 = -1.8356171439920266d-6*t111*t229*t41*t88*t89
            t231 = -6.203504908994001d-1*t110*t226*t31*t42+1.24070098179
     1         88002d+0*t224*t225*t31*t42+2.7571132928862224d-1*t100*t21
     2         0*t42+4.135669939329334d-1*t100*t101*t109*t110*t42
            t232 = -2.722148880047894d-2*t100*t231*t41
            t233 = -9.073829600159646d-3*t100*t113*t213*t41
            t234 = -8*t123*t125*t45
            t235 = 1/t47**5
            t236 = 1/t116**2
            t237 = 1/t47**3
            t238 = t119**2
            t239 = 1/t50**2
            t240 = 6.178834917961894d-1*t198*t89+t204+4.63412618847142d-
     1         1*t195*t196
            t241 = 5.250822119331622d-1*t119*t120*t48*t52*t88*t89+1.7502
     1         740397772074d-1*t198*t48*t52*t89-1.0d+0*t120*t240*t49*t52
     2         +2.0d+0*t238*t239*t49*t52+1.3127055298329054d-1*t195*t196
     3         *t48*t52+3.446391616107778d-2*t189*t52
            t242 = 1/t48**3
            t243 = -6.203504908994001d-1*t120*t240*t31*t52+1.24070098179
     1         88002d+0*t238*t239*t31*t52+2.7571132928862224d-1*t100*t21
     2         0*t52+4.135669939329334d-1*t100*t101*t119*t120*t52
            t244 = 1.709920934161365d+0*(-9.690227711544375d-4*t27*t29*t
     1         94*t96*t98-2.544083100456872d-4*t208*t28*t88*t89*t98-5.01
     2         1795824473985d-2*t100*t102*t27*t29*t96-9.690227711544375d
     3         -4*t206*t28*t94+4.176057139642926d-2*t198*t89*t90*t92+3.1
     4         320428547321943d-2*t195*t196*t90*t92-3.289159980064472d-2
     5         *t189*t193*t92+5.901575133296435d-4*t121*t242*t51*t88*t89
     6         -4.3465070592240396d-2*t115*t117*t198*t89+2.5058979122369
     7         923d-2*t100*t119*t122*t50*t52+2.2478670955426108d-3*t118*
     8         t119*t121*t50*t52+2.5058979122369923d-2*t100*t243*t51+2.2
     9         478670955426108d-3*t118*t241*t51+8.352993040789976d-3*t10
     :         0*t122*t213*t51-1.670598608157995d-2*t100*t102*t213*t28-5
     ;         .011795824473985d-2*t100*t211*t28+3.4234103112606934d-2*t
     <         117*t189*t237-7.662163788798045d-1*t189*t235*t236-3.25988
     =         02944180294d-2*t115*t117*t195*t196+1.2448480831567728d+0*
     >         t189*t190*t191)+1.8356171439920266d-6*t111*t229*t41*t88*t
     ?         89-6.68887065297039d-3*t104*t106*t198*t89+2.7221488800478
     @         94d-2*t100*t109*t113*t40*t42+6.991732350764465d-6*t108*t1
     1         09*t111*t40*t42+2.722148880047894d-2*t100*t231*t41+6.9917
     2         32350764465d-6*t108*t227*t41+9.073829600159646d-3*t100*t1
     3         13*t213*t41+5.26831049669476d-3*t106*t189*t218-2.67307123
     4         88370664d-1*t189*t215*t216-5.016652989727792d-3*t104*t106
     5         *t195*t196
            t245 = t244*t45*t46
            t246 = 1/t1**6
            t247 = 20*t246*t45*t53
            t248 = t2**2
            t249 = 12*t248*t46*t53
            t250 = -32*t125*t127*t53+8*t123*t127*t46+t249+t247+t245+t234
     1         +t233+t232+t230+t228+t223+t222+t221+t220+t219+t217
            t251 = 1/t5
            t252 = 1/t7
            t253 = 1.3333333333333333d+0*t169*t77+1.3333333333333333d+0*
     1         t164*t73+4.444444444444444d-1*t165*t252+4.444444444444444
     2         d-1*t159*t251
            t254 = 1.1250000000000002d+0*t253*t54+1.1250000000000002d+0*
     1         t250*t35+t214+t212+t209+t207+t201+t200+t199+t197+t194+t19
     2         2+2.2500000000000003d+0*t128*t129
            t255 = 2.4256569070538223d+2*t130*t63*t79+1.2128284535269111
     1         d+2*t170*t55*t63-4.8513138141076445d+2*t135*t158*t55-4.04
     2         27615117563703d+1*t15*t254
            t256 = -1.7121095002288234d-1*t10*t12*t14*t255*t56*t87
            t257 = 6.848438000915293d-1*t10*t12*t131*t15*t56*t79*t87
            t258 = 7.989844334401176d-1*t10*t131*t14*t56*t82*t83*t87
            t259 = t258+t257+t256+t188+t187+t183+t182+t181+t180+t179
            t260 = 1/t8**6.0d+0
            t261 = 1/t11**6.0d+0
            t262 = 7.979701560995323d-1*t173*t261*t61*t63*t64
            t263 = -2.2799147317129503d-2*t136*t175*t61*t63*t64
            t264 = 1/t57**4.0d+0
            t265 = 1.0943590712222155d+0*t135*t136*t61*t64*t79*t82+5.471
     1         795356111078d-1*t131*t136*t138*t56*t61*t63*t82+4.69011030
     2         5238066d-1*t131*t135*t138*t56*t61*t62*t79+5.8626378815475
     3         82d-1*t158*t260*t61*t62*t64-1.1725275763095165d-1*t135*t1
     4         70*t61*t62*t64-5.862637881547582d-2*t138*t255*t56*t61*t62
     5         *t63-5.862637881547582d-2*t138*t186*t56*t61*t62*t63+1.758
     6         7913644642747d-1*t184*t186*t264*t61*t62*t63+t263+t262+t25
     7         8+t257+t256+t188+t187+t183+t182+t181+t180+t179
            t266 = 1.5979688668802353d+0*t10*t15*t60*t66*t79*t82*t83-7.9
     1         89844334401176d-1*t10*t133*t14*t66*t82*t83+7.989844334401
     2         176d-1*t10*t134*t139*t14*t60*t82*t83-6.848438000915293d-1
     3         *t10*t12*t133*t15*t66*t79+6.848438000915293d-1*t10*t12*t1
     4         34*t139*t15*t60*t79+1.027265700137294d+0*t10*t12*t158*t60
     5         *t63*t66-3.4242190004576467d-1*t10*t12*t15*t170*t60*t66+1
     6         .7121095002288234d-1*t10*t12*t14*t259*t66-1.7121095002288
     7         234d-1*t10*t12*t134*t14*t265*t60+3.4242190004576467d-1*t1
     8         0*t12*t14*t177*t178*t60+t176+t174-3.4242190004576467d-1*t
     9         10*t12*t133*t134*t139*t14
            t267 = 2.473556743557577d-2*t1*t266*t9*wght+4.94711348711515
     1         4d-2*t140*t9*wght+1.4841340461345462d-1*t1*t13*t140*t79*w
     2         ght
            t268 = 6.666666666666666d-1*t161*t2*t78-1.111111111111111d-1
     1         *t142*t166*t76-6.666666666666666d-1*t161*t2*t74-1.1111111
     2         11111111d-1*t141*t160*t72
            t269 = 1.027265700137294d+0*t10*t12*t143*t58*t63*t79
            t270 = -3.4242190004576467d-1*t10*t12*t15*t268*t58
            t271 = 7.989844334401176d-1*t10*t143*t15*t58*t82*t83
            t272 = 7.989844334401176d-1*t10*t15*t58*t79*t82*t83
            t273 = -12*t248*t46*t53+t247+t245+t234+t233+t232+t230+t228+t
     1         223+t222+t221+t220+t219+t217
            t274 = 2.6666666666666666d+0*t161*t2*t77+4.444444444444444d-
     1         1*t142*t252*t76-2.6666666666666666d+0*t161*t2*t73+4.44444
     2         4444444444d-1*t141*t251*t72
            t275 = 1.1250000000000002d+0*t274*t54+1.1250000000000002d+0*
     1         t273*t35+t214+t212+t209+t207+t201+t200+t199+t197+t194+t19
     2         2+1.1250000000000002d+0*t128*t146+1.1250000000000002d+0*t
     3         129*t145
            t276 = 1.2128284535269111d+2*t147*t63*t79-4.8513138141076445
     1         d+2*t135*t143*t55*t79+1.2128284535269111d+2*t268*t55*t63+
     2         1.2128284535269111d+2*t130*t143*t63-4.0427615117563703d+1
     3         *t15*t275
            t277 = -1.7121095002288234d-1*t10*t12*t14*t276*t56*t87
            t278 = 3.4242190004576467d-1*t10*t12*t148*t15*t56*t79*t87
            t279 = 3.994922167200588d-1*t10*t14*t148*t56*t82*t83*t87
            t280 = 3.4242190004576467d-1*t10*t12*t131*t143*t15*t56*t87
            t281 = 3.994922167200588d-1*t10*t131*t14*t56*t82*t83*t87
            t282 = 3.4242190004576467d-1*t10*t12*t131*t14*t148*t184*t185
            t283 = -1.7121095002288234d-1*t10*t12*t131*t14*t148*t56*t87
            t284 = t283+t282+t281+t280+t279+t278+t277+t272+t271+t270+t26
     1         9+t183+t182
            t285 = 5.471795356111078d-1*t135*t136*t61*t64*t79*t82+5.4717
     1         95356111078d-1*t135*t136*t143*t61*t64*t82+2.7358976780555
     2         39d-1*t136*t138*t148*t56*t61*t63*t82+2.735897678055539d-1
     3         *t131*t136*t138*t56*t61*t63*t82+5.862637881547582d-1*t143
     4         *t260*t61*t62*t64*t79+2.345055152619033d-1*t135*t138*t148
     5         *t56*t61*t62*t79-1.1725275763095165d-1*t135*t268*t61*t62*
     6         t64-5.862637881547582d-2*t138*t276*t56*t61*t62*t63-5.8626
     7         37881547582d-2*t131*t138*t148*t56*t61*t62*t63+1.758791364
     8         4642747d-1*t131*t148*t184*t264*t61*t62*t63+2.345055152619
     9         033d-1*t131*t135*t138*t143*t56*t61*t62+t283+t282+t281+t28
     :         0+t279+t278+t277+t272+t271+t270+t269+t263+t262+t183+t182
            t286 = 7.989844334401176d-1*t10*t15*t60*t66*t79*t82*t83+7.98
     1         9844334401176d-1*t10*t143*t15*t60*t66*t82*t83-3.994922167
     2         200588d-1*t10*t14*t150*t66*t82*t83-3.994922167200588d-1*t
     3         10*t133*t14*t66*t82*t83+3.994922167200588d-1*t10*t134*t14
     4         *t151*t60*t82*t83+3.994922167200588d-1*t10*t134*t139*t14*
     5         t60*t82*t83+1.027265700137294d+0*t10*t12*t143*t60*t63*t66
     6         *t79-3.4242190004576467d-1*t10*t12*t15*t150*t66*t79+3.424
     7         2190004576467d-1*t10*t12*t134*t15*t151*t60*t79-3.42421900
     8         04576467d-1*t10*t12*t15*t268*t60*t66+1.7121095002288234d-
     9         1*t10*t12*t14*t284*t66-3.4242190004576467d-1*t10*t12*t133
     :         *t143*t15*t66-1.7121095002288234d-1*t10*t12*t134*t14*t285
     ;         *t60+3.4242190004576467d-1*t10*t12*t139*t14*t151*t177*t60
     <         +3.4242190004576467d-1*t10*t12*t134*t139*t143*t15*t60+t17
     =         6+t174-1.7121095002288234d-1*t10*t12*t133*t134*t14*t151-1
     >         .7121095002288234d-1*t10*t12*t134*t139*t14*t150
            t287 = 2.473556743557577d-2*t1*t286*t9*wght+2.47355674355757
     1         7d-2*t152*t9*wght+2.473556743557577d-2*t140*t9*wght+7.420
     2         670230672731d-2*t1*t13*t152*t79*wght+7.420670230672731d-2
     3         *t1*t13*t140*t143*wght
            t288 = t143**2
            t289 = t141**2
            t290 = t168+t162
            t291 = t142**2
            t292 = t167+t163
            t293 = 3.333333333333333d-1*t292*t78+3.333333333333333d-1*t2
     1         90*t74-1.111111111111111d-1*t166*t291-1.111111111111111d-
     2         1*t160*t289
            t294 = t152**2
            t295 = t151**2
            t296 = 1.027265700137294d+0*t10*t12*t288*t58*t63
            t297 = -3.4242190004576467d-1*t10*t12*t15*t293*t58
            t298 = 1.5979688668802353d+0*t10*t143*t15*t58*t82*t83
            t299 = t148**2
            t300 = 3.4242190004576467d-1*t10*t12*t14*t184*t185*t299
            t301 = -1.7121095002288234d-1*t10*t12*t14*t299*t56*t87
            t302 = 32*t125*t127*t53-8*t123*t127*t46+t249+t247+t245+t234+
     1         t233+t232+t230+t228+t223+t222+t221+t220+t219+t217
            t303 = 1.3333333333333333d+0*t292*t77+1.3333333333333333d+0*
     1         t290*t73+4.444444444444444d-1*t252*t291+4.444444444444444
     2         d-1*t251*t289
            t304 = 1.1250000000000002d+0*t303*t54+1.1250000000000002d+0*
     1         t302*t35+t214+t212+t209+t207+t201+t200+t199+t197+t194+t19
     2         2+2.2500000000000003d+0*t145*t146
            t305 = 1.2128284535269111d+2*t293*t55*t63+2.4256569070538223
     1         d+2*t143*t147*t63-4.8513138141076445d+2*t135*t288*t55-4.0
     2         427615117563703d+1*t15*t304
            t306 = -1.7121095002288234d-1*t10*t12*t14*t305*t56*t87
            t307 = 6.848438000915293d-1*t10*t12*t143*t148*t15*t56*t87
            t308 = 7.989844334401176d-1*t10*t14*t148*t56*t82*t83*t87
            t309 = t308+t307+t306+t301+t300+t298+t297+t296+t183+t182
            t310 = 1.0943590712222155d+0*t135*t136*t143*t61*t64*t82+5.47
     1         1795356111078d-1*t136*t138*t148*t56*t61*t63*t82-1.1725275
     2         763095165d-1*t135*t293*t61*t62*t64+5.862637881547582d-1*t
     3         260*t288*t61*t62*t64-5.862637881547582d-2*t138*t305*t56*t
     4         61*t62*t63-5.862637881547582d-2*t138*t299*t56*t61*t62*t63
     5         +1.7587913644642747d-1*t184*t264*t299*t61*t62*t63+4.69011
     6         0305238066d-1*t135*t138*t143*t148*t56*t61*t62+t308+t307+t
     7         306+t301+t300+t298+t297+t296+t263+t262+t183+t182
            t311 = 1.5979688668802353d+0*t10*t143*t15*t60*t66*t82*t83-7.
     1         989844334401176d-1*t10*t14*t150*t66*t82*t83+7.98984433440
     2         1176d-1*t10*t134*t14*t151*t60*t82*t83+1.027265700137294d+
     3         0*t10*t12*t288*t60*t63*t66-3.4242190004576467d-1*t10*t12*
     4         t15*t293*t60*t66+1.7121095002288234d-1*t10*t12*t14*t309*t
     5         66-6.848438000915293d-1*t10*t12*t143*t15*t150*t66-1.71210
     6         95002288234d-1*t10*t12*t134*t14*t310*t60+3.42421900045764
     7         67d-1*t10*t12*t14*t177*t295*t60+6.848438000915293d-1*t10*
     8         t12*t134*t143*t15*t151*t60+t176+t174-3.4242190004576467d-
     9         1*t10*t12*t134*t14*t150*t151
            t312 = 2.473556743557577d-2*t1*t311*t9*wght+4.94711348711515
     1         4d-2*t152*t9*wght+1.4841340461345462d-1*t1*t13*t143*t152*
     2         wght
            t313 = 2.473556743557577d-2*t154*t9*wght
            t314 = 3.994922167200588d-1*t10*t134*t14*t153*t60*t82*t83
            t315 = -3.994922167200588d-1*t14*t60*t66*t82*t83
            t316 = -6.839744195138847d-2*t10*t136*t58*t63*t66*t82
            t317 = -3.4242190004576467d-1*t12*t15*t58*t79
            t318 = -3.994922167200588d-1*t14*t58*t82*t83
            t319 = -1.7121095002288234d-1*t12*t131*t14*t56*t87
            t320 = t319+t318+t317
            t321 = -2.735897678055539d-1*t10*t136*t63*t64*t82
            t322 = -2.345055152619033d-1*t10*t135*t62*t64*t79-1.17252757
     1         63095165d-1*t10*t131*t138*t56*t62*t63+t321+t319+t318+t317
            t323 = -5.862637881547582d-2*t10*t135*t58*t62*t66*t79-3.4242
     1         190004576467d-1*t12*t15*t60*t66*t79+3.4242190004576467d-1
     2         *t10*t12*t134*t15*t153*t60*t79+1.7121095002288234d-1*t10*
     3         t12*t14*t320*t66+1.7121095002288234d-1*t12*t133*t14*t66-2
     4         .931318940773791d-2*t10*t134*t139*t58*t62*t63-1.712109500
     5         2288234d-1*t10*t12*t134*t14*t322*t60+3.4242190004576467d-
     6         1*t10*t12*t139*t14*t153*t177*t60-1.7121095002288234d-1*t1
     7         2*t134*t139*t14*t60+t316+t315+t314-1.7121095002288234d-1*
     8         t10*t12*t133*t134*t14*t153
            t324 = 2.473556743557577d-2*t1*t323*t9*wght+7.42067023067273
     1         1d-2*t1*t13*t154*t79*wght+t313
            t325 = t324*t81-2.473556743557577d-2*t1*t140*t154*t171*t9*wg
     1         ht
            t326 = 2.473556743557577d-2*t157*t9*wght
            t327 = 3.994922167200588d-1*t10*t134*t14*t156*t60*t82*t83
            t328 = -7.989844334401176d-1*t14*t60*t66*t82*t83
            t329 = -1.3679488390277694d-1*t10*t136*t58*t63*t66*t82
            t330 = -6.848438000915293d-1*t12*t15*t58*t79
            t331 = -7.989844334401176d-1*t14*t58*t82*t83
            t332 = -3.4242190004576467d-1*t12*t131*t14*t56*t87
            t333 = t332+t331+t330
            t334 = -5.471795356111078d-1*t10*t136*t63*t64*t82
            t335 = -4.690110305238066d-1*t10*t135*t62*t64*t79-2.34505515
     1         2619033d-1*t10*t131*t138*t56*t62*t63+t334+t332+t331+t330
            t336 = -1.1725275763095165d-1*t10*t135*t58*t62*t66*t79-6.848
     1         438000915293d-1*t12*t15*t60*t66*t79+3.4242190004576467d-1
     2         *t10*t12*t134*t15*t156*t60*t79+1.7121095002288234d-1*t10*
     3         t12*t14*t333*t66+3.4242190004576467d-1*t12*t133*t14*t66-5
     4         .862637881547582d-2*t10*t134*t139*t58*t62*t63-1.712109500
     5         2288234d-1*t10*t12*t134*t14*t335*t60+3.4242190004576467d-
     6         1*t10*t12*t139*t14*t156*t177*t60-3.4242190004576467d-1*t1
     7         2*t134*t139*t14*t60+t329+t328+t327-1.7121095002288234d-1*
     8         t10*t12*t133*t134*t14*t156
            t337 = 2.473556743557577d-2*t1*t336*t9*wght+7.42067023067273
     1         1d-2*t1*t13*t157*t79*wght+t326
            t338 = -3.4242190004576467d-1*t12*t143*t15*t58
            t339 = -1.7121095002288234d-1*t12*t14*t148*t56*t87
            t340 = t339+t338+t318
            t341 = -2.345055152619033d-1*t10*t135*t143*t62*t64-1.1725275
     1         763095165d-1*t10*t138*t148*t56*t62*t63+t339+t338+t321+t31
     2         8
            t342 = -5.862637881547582d-2*t10*t135*t143*t58*t62*t66-3.424
     1         2190004576467d-1*t12*t143*t15*t60*t66+1.7121095002288234d
     2         -1*t10*t12*t14*t340*t66+1.7121095002288234d-1*t12*t14*t15
     3         0*t66-2.931318940773791d-2*t10*t134*t151*t58*t62*t63-1.71
     4         21095002288234d-1*t10*t12*t134*t14*t341*t60+3.42421900045
     5         76467d-1*t10*t12*t14*t151*t153*t177*t60+3.424219000457646
     6         7d-1*t10*t12*t134*t143*t15*t153*t60-1.7121095002288234d-1
     7         *t12*t134*t14*t151*t60+t316+t315+t314-1.7121095002288234d
     8         -1*t10*t12*t134*t14*t150*t153
            t343 = 2.473556743557577d-2*t1*t342*t9*wght+7.42067023067273
     1         1d-2*t1*t13*t143*t154*wght+t313
            t344 = t343*t81-2.473556743557577d-2*t1*t152*t154*t171*t9*wg
     1         ht
            t345 = -6.848438000915293d-1*t12*t143*t15*t58
            t346 = -3.4242190004576467d-1*t12*t14*t148*t56*t87
            t347 = t346+t345+t331
            t348 = -4.690110305238066d-1*t10*t135*t143*t62*t64-2.3450551
     1         52619033d-1*t10*t138*t148*t56*t62*t63+t346+t345+t334+t331
            t349 = -1.1725275763095165d-1*t10*t135*t143*t58*t62*t66-6.84
     1         8438000915293d-1*t12*t143*t15*t60*t66+1.7121095002288234d
     2         -1*t10*t12*t14*t347*t66+3.4242190004576467d-1*t12*t14*t15
     3         0*t66-5.862637881547582d-2*t10*t134*t151*t58*t62*t63-1.71
     4         21095002288234d-1*t10*t12*t134*t14*t348*t60+3.42421900045
     5         76467d-1*t10*t12*t14*t151*t156*t177*t60+3.424219000457646
     6         7d-1*t10*t12*t134*t143*t15*t156*t60-3.4242190004576467d-1
     7         *t12*t134*t14*t151*t60+t329+t328+t327-1.7121095002288234d
     8         -1*t10*t12*t134*t14*t150*t156
            t350 = 2.473556743557577d-2*t1*t349*t9*wght+7.42067023067273
     1         1d-2*t1*t13*t143*t157*wght+t326
            t351 = t154**2
            t352 = t153**2
            t353 = -3.4242190004576467d-1*t12*t134*t14*t153*t60
            t354 = -5.862637881547582d-2*t10*t134*t153*t58*t62*t63
            t355 = 5.862637881547582d-2*t58*t62*t63*t66-1.0037478013399d
     1         -2*t10*t134*t260*t261*t60*t64+3.4242190004576467d-1*t10*t
     2         12*t14*t177*t352*t60+t354+t353
            t356 = 2.473556743557577d-2*t1*t355*t81*t9*wght-2.4735567435
     1         57577d-2*t1*t171*t351*t9*wght
            t357 = 1.1725275763095165d-1*t58*t62*t63*t66-2.0074956026798
     1         d-2*t10*t134*t260*t261*t60*t64-2.931318940773791d-2*t10*t
     2         134*t156*t58*t62*t63+3.4242190004576467d-1*t10*t12*t14*t1
     3         53*t156*t177*t60-1.7121095002288234d-1*t12*t134*t14*t156*
     4         t60+t354+t353
            t358 = 2.473556743557577d-2*t1*t357*t81*t9*wght-2.4735567435
     1         57577d-2*t1*t154*t157*t171*t9*wght
            t359 = t157**2
            t360 = t156**2
            t361 = 2.345055152619033d-1*t58*t62*t63*t66-4.0149912053596d
     1         -2*t10*t134*t260*t261*t60*t64-1.1725275763095165d-1*t10*t
     2         134*t156*t58*t62*t63+3.4242190004576467d-1*t10*t12*t14*t1
     3         77*t360*t60-6.848438000915293d-1*t12*t134*t14*t156*t60
            t362 = t79**3
            t363 = t72**3
            t364 = 1/t4**2.3333333333333334d+0
            t365 = 6*t2*t46
            t366 = -6*t161
            t367 = t366+t365
            t368 = t76**3
            t369 = 1/t6**2.3333333333333334d+0
            t370 = -6*t2*t46
            t371 = 6*t161
            t372 = t371+t370
            t373 = 3.333333333333333d-1*t372*t78-3.333333333333333d-1*t1
     1         66*t169*t76+3.333333333333333d-1*t367*t74-3.3333333333333
     2         33d-1*t160*t164*t72+1.4814814814814814d-1*t368*t369+1.481
     3         4814814814814d-1*t363*t364
            t374 = 1/t67**3
            t375 = t1**5.000000000000002d-1
            t376 = -6.525039539760961d+0*t10*t136*t14*t375*t60*t66
            t377 = 1/t1**6.666666666666665d-1
            t378 = 6.991113792601032d-1*t10*t14*t377*t60*t62*t66
            t379 = 1/t1**1.8333333333333332d+0
            t380 = 5.548503010000818d-2*t10*t14*t379*t60*t66*t83
            t381 = 1/t65**4
            t382 = -4.109062800549176d+0*t10*t12*t135*t362*t58
            t383 = 3.081797100411882d+0*t10*t12*t170*t58*t63*t79
            t384 = -7.190859900961059d+0*t10*t158*t58*t63*t82*t83
            t385 = -3.4242190004576467d-1*t10*t12*t15*t373*t58
            t386 = 2.396953300320353d+0*t10*t15*t170*t58*t82*t83
            t387 = -8.389336551121236d+0*t10*t15*t173*t58*t62*t79
            t388 = 3.9949221672005897d-1*t10*t15*t175*t58*t79*t83
            t389 = -6.525039539760961d+0*t10*t136*t14*t375*t58
            t390 = 6.991113792601032d-1*t10*t14*t377*t58*t62
            t391 = 5.548503010000818d-2*t10*t14*t379*t58*t83
            t392 = -2.054531400274588d+0*t10*t12*t15*t184*t185*t186*t79
            t393 = -2.396953300320353d+0*t10*t14*t184*t185*t186*t82*t83
            t394 = 1.027265700137294d+0*t10*t12*t15*t186*t56*t79*t87
            t395 = 1.1984766501601765d+0*t10*t14*t186*t56*t82*t83*t87
            t396 = exp(-1.2128284535269111d+2*t15*t55)
            t397 = 1/t57**4
            t398 = t131**3
            t399 = -1.027265700137294d+0*t10*t12*t14*t396*t397*t398
            t400 = 3.4242190004576467d-1*t10*t12*t14*t184*t185*t398
            t401 = -1.7121095002288234d-1*t10*t12*t14*t398*t56*t87
            t402 = 1.027265700137294d+0*t10*t12*t15*t255*t56*t79*t87
            t403 = 1.1984766501601765d+0*t10*t14*t255*t56*t82*t83*t87
            t404 = -3.081797100411882d+0*t10*t12*t131*t158*t56*t63*t87
            t405 = 1.027265700137294d+0*t10*t12*t131*t15*t170*t56*t87
            t406 = -4.793906600640706d+0*t10*t131*t15*t56*t79*t82*t83*t8
     1         7
            t407 = -4.194668275560618d+0*t10*t131*t14*t173*t56*t62*t87
            t408 = 1.9974610836002948d-1*t10*t131*t14*t175*t56*t83*t87
            t409 = 1.027265700137294d+0*t10*t12*t131*t14*t184*t185*t255
            t410 = -5.13632850068647d-1*t10*t12*t131*t14*t255*t56*t87
            t411 = 2.4256569070538223d+2*t55*t63*t79-8.085523023512741d+
     1         1*t130*t15
            t412 = 3.4242190004576467d-1*t10*t12*t14*t184*t185*t186*t411
            t413 = 1/t1**3.0d+0
            t414 = 1/t20**8
            t415 = 1/t91**3
            t416 = 4.947718859586276d+1*t413*t414*t415*t89
            t417 = 1/t20**6
            t418 = -2.2877665475865033d+0*t191*t413*t417*t89
            t419 = 1/t1**3.3333333333333337d+0
            t420 = 4.3569682910487045d+0*t190*t191*t419
            t421 = 1/t20**4
            t422 = 2.590619096601433d-2*t413*t421*t89*t92
            t423 = -1.1512059930225654d-1*t193*t419*t92
            t424 = 1/t1**2.0d+0
            t425 = 1/t17**7
            t426 = 2.610035712276828d-2*t424*t425*t90*t92
            t427 = 6.26408570946439d-2*t189*t196*t90*t92
            t428 = 1/t1**2.666666666666667d+0
            t429 = 6.96009523273821d-2*t428*t89*t90*t92
            t430 = 1.938045542308875d-3*t206*t27*t29*t94*t96
            t431 = 5.088166200913744d-4*t208*t27*t29*t88*t89*t96*t98
            t432 = 9.690227711544375d-4*t205*t27*t29*t94*t98
            t433 = 1.002359164894797d-1*t100*t211*t27*t29*t96
            t434 = 5.011795824473985d-2*t100*t102*t205*t27*t29
            t435 = 3.34119721631599d-2*t100*t102*t213*t27*t29*t96
            t436 = t96**3
            t437 = 1/t27**3
            t438 = -6.433264350067851d-1/t1**3.333333333333333d+0
            t439 = -5.436701222355962d-1*t428*t89+t438-2.038762958383485
     1         1d-1*t424*t425-4.893031100120365d-1*t189*t196
            t440 = -5.250822119331622d-1*t198*t23*t29*t89*t96*t97-3.9381
     1         165894987163d-1*t195*t196*t23*t29*t96*t97-1.0339174848323
     2         335d-1*t189*t29*t96*t97+7.876233178997433d-1*t205*t23*t29
     3         *t88*t89*t97-1.0d+0*t24*t29*t439*t97+6.0d+0*t203*t205*t24
     4         *t29*t96-1.5752466357994865d+0*t202*t203*t23*t29*t88*t89-
     5         2.917123399628679d-1*t23*t29*t428*t89-6.0d+0*t24*t29*t436
     6         *t437-1.0939212748607545d-1*t23*t29*t424*t425-1.206237065
     7         6377225d-1*t29*t419-2.625411059665811d-1*t189*t196*t23*t2
     8         9
            t441 = 9.690227711544375d-4*t28*t440*t94
            t442 = 5.088166200913744d-4*t206*t208*t28*t88*t89
            t443 = 1/t23**4
            t444 = 1.0018895862972538d-4*t189*t28*t443*t98
            t445 = -1.272041550228436d-4*t195*t196*t208*t28*t98
            t446 = -1.696055400304582d-4*t198*t208*t28*t89*t98
            t447 = 1/t1**3.6666666666666664d+0
            t448 = -8.271339878658668d-1*t100*t210*t29*t96*t97-6.2035049
     1         08994001d-1*t29*t31*t439*t97+6.203504908994001d-1*t100*t1
     2         01*t205*t29*t97+3.7221029453964005d+0*t203*t205*t29*t31*t
     3         96-6.433264350067852d-1*t100*t29*t447-3.7221029453964005d
     4         +0*t29*t31*t436*t437-1.2407009817988002d+0*t100*t101*t202
     5         *t203*t29
            t449 = 5.011795824473985d-2*t100*t28*t448
            t450 = 3.34119721631599d-2*t100*t211*t213*t28
            t451 = -1.6705986081579946d-2*t100*t102*t28*t424
            t452 = 1/t1**1.9999999999999998d+0
            t453 = 5.568662027193316d-3*t100*t102*t28*t452
            t454 = 1/t4**1.6666666666666669d+0
            t455 = 1/t6**1.6666666666666669d+0
            t456 = 1/t36**8
            t457 = 1/t105**3
            t458 = -1.424318138513631d+1*t413*t456*t457*t89
            t459 = 1/t36**6
            t460 = 4.9125375556021966d-1*t216*t413*t459*t89
            t461 = -9.355749335929733d-1*t215*t216*t419
            t462 = 1/t36**4
            t463 = -4.1494441931327714d-3*t106*t413*t462*t89
            t464 = 1.8439086738431665d-2*t106*t218*t419
            t465 = -4.180544158106493d-3*t104*t106*t424*t425
            t466 = -1.0033305979455585d-2*t104*t106*t189*t196
            t467 = -1.114811775495065d-2*t104*t106*t428*t89
            t468 = -1.3983464701528928d-5*t108*t109*t227*t40*t42
            t469 = -3.671234287984053d-6*t109*t111*t229*t40*t42*t88*t89
            t470 = -6.991732350764465d-6*t108*t111*t226*t40*t42
            t471 = -5.444297760095788d-2*t100*t109*t231*t40*t42
            t472 = -2.722148880047894d-2*t100*t113*t226*t40*t42
            t473 = -1.8147659200319294d-2*t100*t109*t113*t213*t40*t42
            t474 = t109**3
            t475 = 1/t40**3
            t476 = -1.649735381809005d-1*t428*t89+t438-6.186507681783768
     1         d-2*t424*t425-1.4847618436281043d-1*t189*t196
            t477 = 7.876233178997433d-1*t110*t226*t38*t42*t88*t89-1.5752
     1         466357994865d+0*t224*t225*t38*t42*t88*t89-2.9171233996286
     2         79d-1*t38*t42*t428*t89-5.250822119331622d-1*t109*t110*t19
     3         8*t38*t42*t89-1.0d+0*t110*t39*t42*t476-6.0d+0*t39*t42*t47
     4         4*t475-1.0939212748607545d-1*t38*t42*t424*t425-1.20623706
     5         56377225d-1*t419*t42+6.0d+0*t109*t225*t226*t39*t42-3.9381
     6         165894987163d-1*t109*t110*t195*t196*t38*t42-2.62541105966
     7         5811d-1*t189*t196*t38*t42-1.0339174848323335d-1*t109*t110
     8         *t189*t42
            t478 = -6.991732350764465d-6*t108*t41*t477
            t479 = -3.671234287984053d-6*t227*t229*t41*t88*t89
            t480 = 1/t38**4
            t481 = -7.228874326723254d-7*t111*t189*t41*t480
            t482 = 9.178085719960132d-7*t111*t195*t196*t229*t41
            t483 = 1.2237447626613511d-6*t111*t198*t229*t41*t89
            t484 = -6.203504908994001d-1*t110*t31*t42*t476-3.72210294539
     1         64005d+0*t31*t42*t474*t475-6.433264350067852d-1*t100*t42*
     2         t447+3.7221029453964005d+0*t109*t225*t226*t31*t42+6.20350
     3         4908994001d-1*t100*t101*t110*t226*t42-1.2407009817988002d
     4         +0*t100*t101*t224*t225*t42-8.271339878658668d-1*t100*t109
     5         *t110*t210*t42
            t485 = -2.722148880047894d-2*t100*t41*t484
            t486 = -1.8147659200319294d-2*t100*t213*t231*t41
            t487 = 9.073829600159644d-3*t100*t113*t41*t424
            t488 = -3.024609866719882d-3*t100*t113*t41*t452
            t489 = 60*t123*t246*t45
            t490 = 36*t123*t248*t46
            t491 = t119**3
            t492 = 1/t50**3
            t493 = -1.0298058196603158d+0*t428*t89+t438-3.86177182372618
     1         33d-1*t424*t425-9.26825237694284d-1*t189*t196
            t494 = t45*t46*(1.709920934161365d+0*(-5.088166200913744d-4*
     1         t208*t27*t29*t88*t89*t96*t98-9.690227711544375d-4*t205*t2
     2         7*t29*t94*t98+1.696055400304582d-4*t198*t208*t28*t89*t98-
     3         1.0018895862972538d-4*t189*t28*t443*t98+1.272041550228436
     4         d-4*t195*t196*t208*t28*t98-1.938045542308875d-3*t206*t27*
     5         t29*t94*t96-3.34119721631599d-2*t100*t102*t213*t27*t29*t9
     6         6-1.002359164894797d-1*t100*t211*t27*t29*t96-9.6902277115
     7         44375d-4*t28*t440*t94-6.96009523273821d-2*t428*t89*t90*t9
     8         2-2.610035712276828d-2*t424*t425*t90*t92-6.26408570946439
     9         d-2*t189*t196*t90*t92-2.590619096601433d-2*t413*t421*t89*
     :         t92+1.1512059930225654d-1*t193*t419*t92+2.247867095542610
     ;         8d-3*t118*t51*(7.876233178997433d-1*t120*t240*t48*t52*t88
     <         *t89-1.5752466357994865d+0*t238*t239*t48*t52*t88*t89-2.91
     =         7123399628679d-1*t428*t48*t52*t89-5.250822119331622d-1*t1
     >         19*t120*t198*t48*t52*t89-1.0d+0*t120*t49*t493*t52-6.0d+0*
     ?         t49*t491*t492*t52+6.0d+0*t119*t239*t240*t49*t52-1.0939212
     @         748607545d-1*t424*t425*t48*t52-3.9381165894987163d-1*t119
     1         *t120*t195*t196*t48*t52-2.625411059665811d-1*t189*t196*t4
     2         8*t52-1.2062370656377225d-1*t419*t52-1.0339174848323335d-
     3         1*t119*t120*t189*t52)+1.1803150266592868d-3*t119*t121*t24
     4         2*t50*t52*t88*t89+1.1803150266592868d-3*t241*t242*t51*t88
     5         *t89-5.088166200913744d-4*t206*t208*t28*t88*t89-3.9343834
     6         22197623d-4*t121*t198*t242*t51*t89+2.69635778788734d-2*t1
     7         17*t413*t89/t47**4-1.4081430686456894d+0*t236*t413*t89/t4
     8         7**6+1.8009481522035156d+1*t413*t89/(t116**3*t47**8)+7.24
     9         4178432040066d-2*t115*t117*t428*t89+2.2877665475865033d+0
     :         *t191*t413*t417*t89-4.947718859586276d+1*t413*t414*t415*t
     ;         89+2.5058979122369923d-2*t100*t51*(-6.203504908994001d-1*
     <         t120*t31*t493*t52-3.7221029453964005d+0*t31*t491*t492*t52
     =         -6.433264350067852d-1*t100*t447*t52+3.7221029453964005d+0
     >         *t119*t239*t240*t31*t52+6.203504908994001d-1*t100*t101*t1
     ?         20*t240*t52-1.2407009817988002d+0*t100*t101*t238*t239*t52
     @         -8.271339878658668d-1*t100*t119*t120*t210*t52)+5.01179582
     1         4473985d-2*t100*t119*t243*t50*t52+4.4957341910852217d-3*t
     2         118*t119*t241*t50*t52+2.5058979122369923d-2*t100*t122*t24
     3         0*t50*t52+2.2478670955426108d-3*t118*t121*t240*t50*t52+1.
     4         670598608157995d-2*t100*t119*t122*t213*t50*t52+2.32410909
     5         36607786d-4*t121*t189*t51/t48**4+2.784331013596658d-3*t10
     6         0*t122*t452*t51-8.352993040789973d-3*t100*t122*t424*t51+1
     7         .670598608157995d-2*t100*t213*t243*t51-2.9507875666482175
     8         d-4*t121*t195*t196*t242*t51-5.568662027193316d-3*t100*t10
     9         2*t28*t452-5.011795824473985d-2*t100*t28*t448+2.716566912
     :         015024d-2*t115*t117*t424*t425+1.6705986081579946d-2*t100*
     ;         t102*t28*t424-1.1981936089412427d-1*t117*t237*t419+2.6817
     <         57326079316d+0*t235*t236*t419-4.3569682910487045d+0*t190*
     =         t191*t419-5.011795824473985d-2*t100*t102*t205*t27*t29-3.3
     >         4119721631599d-2*t100*t211*t213*t28+6.51976058883606d-2*t
     ?         115*t117*t189*t196)+3.671234287984053d-6*t109*t111*t229*t
     @         40*t42*t88*t89+3.671234287984053d-6*t227*t229*t41*t88*t89
     1         +4.1494441931327714d-3*t106*t413*t462*t89-4.9125375556021
     2         966d-1*t216*t413*t459*t89+1.424318138513631d+1*t413*t456*
     3         t457*t89+1.114811775495065d-2*t104*t106*t428*t89-1.223744
     4         7626613511d-6*t111*t198*t229*t41*t89+2.722148880047894d-2
     5         *t100*t41*t484+7.228874326723254d-7*t111*t189*t41*t480+6.
     6         991732350764465d-6*t108*t41*t477+3.024609866719882d-3*t10
     7         0*t113*t41*t452+4.180544158106493d-3*t104*t106*t424*t425-
     8         9.073829600159644d-3*t100*t113*t41*t424+5.444297760095788
     9         d-2*t100*t109*t231*t40*t42+1.3983464701528928d-5*t108*t10
     :         9*t227*t40*t42+2.722148880047894d-2*t100*t113*t226*t40*t4
     ;         2+6.991732350764465d-6*t108*t111*t226*t40*t42+1.814765920
     <         0319294d-2*t100*t109*t113*t213*t40*t42-1.8439086738431665
     =         d-2*t106*t218*t419+9.355749335929733d-1*t215*t216*t419+1.
     >         8147659200319294d-2*t100*t213*t231*t41-9.178085719960132d
     ?         -7*t111*t195*t196*t229*t41+1.0033305979455585d-2*t104*t10
     @         6*t189*t196)
            t495 = -12*t125*t244*t45
            t496 = -120*t45*t53/t1**7
            t497 = -144*t125*t248*t53
            t498 = 24*t2*t46*t53
            t499 = 3.638485360580734d+2*t254*t63*t79-1.4553941442322935d
     1         +3*t135*t170*t55*t79-4.0427615117563703d+1*t15*(1.1250000
     2         000000002d+0*t54*(1.3333333333333333d+0*t372*t77+1.333333
     3         3333333333d+0*t169*t252*t76+1.3333333333333333d+0*t367*t7
     4         3+1.3333333333333333d+0*t164*t251*t72-2.962962962962963d-
     5         1*t368*t455-2.962962962962963d-1*t363*t454)+1.12500000000
     6         00002d+0*t35*(240*t127*t246*t53+t498+t497+t496+t495+t494+
     7         t490+t489+t488+t487+t486+t485+t483+t482+t481+t479+t478+t4
     8         73+t472+t471+t470+t469+t468+t467+t466+t465+t464+t463+t461
     9         +t460+12*t127*t244*t46+t458-96*t123*t125*t127)+t453+t451+
     :         t450+t449+t446+t445+t444+t442+t441+t435+t434+t433+t432+t4
     ;         31+t430+t429+t427+t426+t423+t422+t420+t418+t416+3.3750000
     <         00000001d+0*t128*t253+3.375000000000001d+0*t129*t250)+1.2
     =         128284535269111d+2*t373*t55*t63+3.638485360580734d+2*t130
     >         *t170*t63+2.4256569070538223d+3*t260*t362*t55-1.455394144
     ?         2322935d+3*t130*t135*t158
            t500 = -1.7121095002288234d-1*t10*t12*t14*t499*t56*t87
            t501 = 1/t8**7.0d+0
            t502 = 1/t11**7.0d+0
            t503 = -5.585791092696726d+0*t375*t502*t61*t63*t64
            t504 = 3.9898507804976635d-1*t261*t377*t61*t63*t64
            t505 = 1.8999289430941252d-2*t136*t379*t61*t63*t64
            t506 = 1/t57**5.0d+0
            t507 = -2.473556743557577d-2*t172*t9*wght
            t508 = 2.9682680922690924d-1*t143*t68*t79*t8*wght
            t509 = 1.4841340461345462d-1*t13*t268*t68*wght
            t510 = t365-2*t161
            t511 = t370+2*t161
            t512 = 3.333333333333333d-1*t511*t78-4.444444444444444d-1*t1
     1         61*t166*t2*t76+3.333333333333333d-1*t510*t74+4.4444444444
     2         44444d-1*t160*t161*t2*t72+1.4814814814814814d-1*t142*t165
     3         *t369+1.4814814814814814d-1*t141*t159*t364-1.111111111111
     4         111d-1*t142*t166*t169-1.111111111111111d-1*t141*t160*t164
            t513 = 1.4841340461345462d-1*t13*t152*t79*wght
            t514 = 1.4841340461345462d-1*t13*t140*t143*wght
            t515 = 4.947113487115154d-2*t286*t9*wght
            t516 = -4.793906600640706d+0*t10*t143*t60*t63*t66*t79*t82*t8
     1         3
            t517 = 1.5979688668802353d+0*t10*t15*t268*t60*t66*t82*t83
            t518 = 1.5979688668802353d+0*t10*t15*t150*t66*t79*t82*t83
            t519 = -1.5979688668802353d+0*t10*t134*t15*t151*t60*t79*t82*
     1         t83
            t520 = 1.5979688668802353d+0*t10*t133*t143*t15*t66*t82*t83
            t521 = 7.989844334401176d-1*t10*t133*t134*t14*t151*t82*t83
            t522 = -1.5979688668802353d+0*t10*t134*t139*t143*t15*t60*t82
     1         *t83
            t523 = 7.989844334401176d-1*t10*t134*t139*t14*t150*t82*t83
            t524 = -1.5979688668802353d+0*t10*t139*t14*t151*t177*t60*t82
     1         *t83
            t525 = -7.989844334401176d-1*t10*t14*t284*t66*t82*t83
            t526 = 7.989844334401176d-1*t10*t134*t14*t285*t60*t82*t83
            t527 = -4.109062800549176d+0*t10*t12*t135*t143*t158*t58
            t528 = 1.027265700137294d+0*t10*t12*t143*t170*t58*t63
            t529 = 2.054531400274588d+0*t10*t12*t268*t58*t63*t79
            t530 = -4.793906600640706d+0*t10*t143*t58*t63*t79*t82*t83
            t531 = -2.396953300320353d+0*t10*t158*t58*t63*t82*t83
            t532 = 1.5979688668802353d+0*t10*t15*t268*t58*t82*t83
            t533 = -3.4242190004576467d-1*t10*t12*t15*t512*t58
            t534 = 7.989844334401176d-1*t10*t15*t170*t58*t82*t83
            t535 = -2.796445517040412d+0*t10*t143*t15*t173*t58*t62
            t536 = 1.3316407224001967d-1*t10*t143*t15*t175*t58*t83
            t537 = -5.592891034080824d+0*t10*t15*t173*t58*t62*t79
            t538 = 2.6632814448003933d-1*t10*t15*t175*t58*t79*t83
            t539 = -6.848438000915293d-1*t10*t12*t143*t15*t184*t185*t186
            t540 = -7.989844334401176d-1*t10*t14*t184*t185*t186*t82*t83
            t541 = 3.4242190004576467d-1*t10*t12*t143*t15*t186*t56*t87
            t542 = 3.994922167200588d-1*t10*t14*t186*t56*t82*t83*t87
            t543 = -1.027265700137294d+0*t10*t12*t14*t148*t186*t396*t397
            t544 = 3.4242190004576467d-1*t10*t12*t14*t148*t184*t185*t186
            t545 = -1.7121095002288234d-1*t10*t12*t14*t148*t186*t56*t87
            t546 = 2.4256569070538223d+2*t143*t55*t63-8.085523023512741d
     1         +1*t147*t15
            t547 = 3.4242190004576467d-1*t10*t12*t14*t184*t185*t186*t546
            t548 = 6.848438000915293d-1*t10*t12*t15*t276*t56*t79*t87
            t549 = 7.989844334401176d-1*t10*t14*t276*t56*t82*t83*t87
            t550 = 3.4242190004576467d-1*t10*t12*t143*t15*t255*t56*t87
            t551 = 3.994922167200588d-1*t10*t14*t255*t56*t82*t83*t87
            t552 = -1.027265700137294d+0*t10*t12*t148*t158*t56*t63*t87
            t553 = 3.4242190004576467d-1*t10*t12*t148*t15*t170*t56*t87
            t554 = -1.5979688668802353d+0*t10*t148*t15*t56*t79*t82*t83*t
     1         87
            t555 = -1.398222758520206d+0*t10*t14*t148*t173*t56*t62*t87
            t556 = 6.658203612000984d-2*t10*t14*t148*t175*t56*t83*t87
            t557 = 3.4242190004576467d-1*t10*t12*t14*t148*t184*t185*t255
            t558 = -1.7121095002288234d-1*t10*t12*t14*t148*t255*t56*t87
            t559 = -2.054531400274588d+0*t10*t12*t131*t143*t56*t63*t79*t
     1         87
            t560 = 6.848438000915293d-1*t10*t12*t131*t15*t268*t56*t87
            t561 = -1.5979688668802353d+0*t10*t131*t143*t15*t56*t82*t83*
     1         t87
            t562 = -1.5979688668802353d+0*t10*t131*t15*t56*t79*t82*t83*t
     1         87
            t563 = -2.796445517040412d+0*t10*t131*t14*t173*t56*t62*t87
            t564 = 1.3316407224001967d-1*t10*t131*t14*t175*t56*t83*t87
            t565 = 6.848438000915293d-1*t10*t12*t131*t14*t184*t185*t276
            t566 = -3.4242190004576467d-1*t10*t12*t131*t14*t276*t56*t87
            t567 = -1.3696876001830588d+0*t10*t12*t131*t148*t15*t184*t18
     1         5*t79
            t568 = -1.5979688668802353d+0*t10*t131*t14*t148*t184*t185*t8
     1         2*t83
            t569 = 6.848438000915293d-1*t10*t12*t131*t148*t15*t56*t79*t8
     1         7
            t570 = 7.989844334401176d-1*t10*t131*t14*t148*t56*t82*t83*t8
     1         7
            t571 = -12*t123*t248*t46
            t572 = 48*t125*t248*t53
            t573 = -24*t2*t46*t53
            t574 = 2.4256569070538223d+2*t275*t63*t79-9.702627628215289d
     1         +2*t135*t268*t55*t79-9.702627628215289d+2*t130*t135*t143*
     2         t79-4.0427615117563703d+1*t15*(1.1250000000000002d+0*t54*
     3         (1.3333333333333333d+0*t511*t77+1.7777777777777776d+0*t16
     4         1*t2*t252*t76+1.3333333333333333d+0*t510*t73-1.7777777777
     5         777776d+0*t161*t2*t251*t72-2.962962962962963d-1*t142*t165
     6         *t455-2.962962962962963d-1*t141*t159*t454+4.4444444444444
     7         44d-1*t142*t169*t252+4.444444444444444d-1*t141*t164*t251)
     8         +1.1250000000000002d+0*t35*(t573+t572+t571+80*t127*t246*t
     9         53+t496+t495+t494+t489+t488+t487+t486+t485+t483+t482+t481
     :         +t479+t478+t473+t472+t471+t470+t469+t468+t467+t466+t465+t
     ;         464+t463+t461+t460+4*t127*t244*t46+t458-32*t123*t125*t127
     <         )+t453+t451+t450+t449+t446+t445+t444+t442+t441+t435+t434+
     =         t433+t432+t431+t430+t429+t427+t426+t423+t422+t420+t418+t4
     >         16+2.2500000000000003d+0*t128*t274+2.2500000000000003d+0*
     ?         t129*t273+1.1250000000000002d+0*t145*t253+1.1250000000000
     @         002d+0*t146*t250)+1.2128284535269111d+2*t512*t55*t63+2.42
     1         56569070538223d+2*t130*t268*t63+1.2128284535269111d+2*t14
     2         3*t254*t63+1.2128284535269111d+2*t147*t170*t63+2.42565690
     3         70538223d+3*t143*t158*t260*t55-4.8513138141076445d+2*t135
     4         *t143*t170*t55-4.8513138141076445d+2*t135*t147*t158
            t575 = -1.7121095002288234d-1*t10*t12*t14*t56*t574*t87
            t576 = 1.0943590712222155d+0*t135*t136*t268*t61*t64*t82
            t577 = 5.471795356111078d-1*t136*t138*t276*t56*t61*t63*t82
            t578 = -2.188718142444431d+0*t135*t136*t138*t148*t56*t61*t79
     1         *t82
            t579 = -2.188718142444431d+0*t131*t135*t136*t138*t143*t56*t6
     1         1*t82
            t580 = -1.6415386068333232d+0*t131*t136*t148*t184*t264*t61*t
     1         63*t82
            t581 = 5.471795356111078d-1*t131*t136*t138*t148*t56*t61*t63*
     1         t82
            t582 = -2.0d+0*t2*t46*t78-6.666666666666666d-1*t161*t78+1.48
     1         14814814814814d-1*t291*t369*t76-1.111111111111111d-1*t166
     2         *t292*t76+2.0d+0*t2*t46*t74+6.666666666666666d-1*t161*t74
     3         +1.4814814814814814d-1*t289*t364*t72-1.111111111111111d-1
     4         *t160*t290*t72-4.444444444444444d-1*t142*t161*t166*t2+4.4
     5         44444444444444d-1*t141*t160*t161*t2
            t583 = -4.109062800549176d+0*t10*t12*t135*t288*t58*t79
            t584 = 2.054531400274588d+0*t10*t12*t143*t268*t58*t63
            t585 = 1.027265700137294d+0*t10*t12*t293*t58*t63*t79
            t586 = -2.396953300320353d+0*t10*t288*t58*t63*t82*t83
            t587 = -3.4242190004576467d-1*t10*t12*t15*t58*t582
            t588 = 7.989844334401176d-1*t10*t15*t293*t58*t82*t83
            t589 = -5.592891034080824d+0*t10*t143*t15*t173*t58*t62
            t590 = 2.6632814448003933d-1*t10*t143*t15*t175*t58*t83
            t591 = -2.796445517040412d+0*t10*t15*t173*t58*t62*t79
            t592 = 1.3316407224001967d-1*t10*t15*t175*t58*t79*t83
            t593 = -6.848438000915293d-1*t10*t12*t15*t184*t185*t299*t79
            t594 = -7.989844334401176d-1*t10*t14*t184*t185*t299*t82*t83
            t595 = 3.4242190004576467d-1*t10*t12*t15*t299*t56*t79*t87
            t596 = 3.994922167200588d-1*t10*t14*t299*t56*t82*t83*t87
            t597 = 6.848438000915293d-1*t10*t12*t143*t15*t276*t56*t87
            t598 = 3.4242190004576467d-1*t10*t12*t15*t305*t56*t79*t87
            t599 = 3.994922167200588d-1*t10*t14*t305*t56*t82*t83*t87
            t600 = -2.054531400274588d+0*t10*t12*t143*t148*t56*t63*t79*t
     1         87
            t601 = 6.848438000915293d-1*t10*t12*t148*t15*t268*t56*t87
            t602 = -1.5979688668802353d+0*t10*t143*t148*t15*t56*t82*t83*
     1         t87
            t603 = -2.796445517040412d+0*t10*t14*t148*t173*t56*t62*t87
            t604 = 1.3316407224001967d-1*t10*t14*t148*t175*t56*t83*t87
            t605 = 6.848438000915293d-1*t10*t12*t14*t148*t184*t185*t276
            t606 = -3.4242190004576467d-1*t10*t12*t14*t148*t276*t56*t87
            t607 = -1.027265700137294d+0*t10*t12*t131*t288*t56*t63*t87
            t608 = 3.4242190004576467d-1*t10*t12*t131*t15*t293*t56*t87
            t609 = -1.398222758520206d+0*t10*t131*t14*t173*t56*t62*t87
            t610 = 6.658203612000984d-2*t10*t131*t14*t175*t56*t83*t87
            t611 = -1.027265700137294d+0*t10*t12*t131*t14*t299*t396*t397
            t612 = 3.4242190004576467d-1*t10*t12*t131*t14*t184*t185*t299
            t613 = -1.7121095002288234d-1*t10*t12*t131*t14*t299*t56*t87
            t614 = 3.4242190004576467d-1*t10*t12*t131*t14*t184*t185*t305
            t615 = -1.7121095002288234d-1*t10*t12*t131*t14*t305*t56*t87
            t616 = -1.3696876001830588d+0*t10*t12*t131*t143*t148*t15*t18
     1         4*t185
            t617 = 6.848438000915293d-1*t10*t12*t131*t143*t148*t15*t56*t
     1         87
            t618 = 3.4242190004576467d-1*t10*t12*t131*t14*t148*t184*t185
     1         *t546
            t619 = 1.2128284535269111d+2*t304*t63*t79-4.8513138141076445
     1         d+2*t135*t293*t55*t79+2.4256569070538223d+3*t260*t288*t55
     2         *t79-9.702627628215289d+2*t135*t143*t147*t79-4.0427615117
     3         563703d+1*t15*(1.1250000000000002d+0*t54*(-8*t2*t46*t77-2
     4         .6666666666666666d+0*t161*t77-2.962962962962963d-1*t291*t
     5         455*t76+4.444444444444444d-1*t252*t292*t76+8*t2*t46*t73+2
     6         .6666666666666666d+0*t161*t73-2.962962962962963d-1*t289*t
     7         454*t72+4.444444444444444d-1*t251*t290*t72+1.777777777777
     8         7776d+0*t142*t161*t2*t252-1.7777777777777776d+0*t141*t161
     9         *t2*t251)+1.1250000000000002d+0*t35*(t572+t571-80*t127*t2
     :         46*t53+t498+t496+t495+t494+t489+t488+t487+t486+t485+t483+
     ;         t482+t481+t479+t478+t473+t472+t471+t470+t469+t468+t467+t4
     <         66+t465+t464+t463+t461+t460-4*t127*t244*t46+t458+32*t123*
     =         t125*t127)+t453+t451+t450+t449+t446+t445+t444+t442+t441+t
     >         435+t434+t433+t432+t431+t430+t429+t427+t426+t423+t422+t42
     ?         0+t418+t416+1.1250000000000002d+0*t128*t303+1.12500000000
     @         00002d+0*t129*t302+2.2500000000000003d+0*t145*t274+2.2500
     1         000000000003d+0*t146*t273)+1.2128284535269111d+2*t55*t582
     2         *t63+1.2128284535269111d+2*t130*t293*t63+2.42565690705382
     3         23d+2*t143*t275*t63+2.4256569070538223d+2*t147*t268*t63-9
     4         .702627628215289d+2*t135*t143*t268*t55-4.8513138141076445
     5         d+2*t130*t135*t288
            t620 = -1.7121095002288234d-1*t10*t12*t14*t56*t619*t87
            t621 = t143**3
            t622 = t141**3
            t623 = t371+t365
            t624 = t142**3
            t625 = t370+t366
            t626 = 3.333333333333333d-1*t625*t78+3.333333333333333d-1*t6
     1         23*t74+1.4814814814814814d-1*t369*t624+1.4814814814814814
     2         d-1*t364*t622-3.333333333333333d-1*t142*t166*t292-3.33333
     3         3333333333d-1*t141*t160*t290
            t627 = -4.109062800549176d+0*t10*t12*t135*t58*t621
            t628 = 3.081797100411882d+0*t10*t12*t143*t293*t58*t63
            t629 = -7.190859900961059d+0*t10*t288*t58*t63*t82*t83
            t630 = -3.4242190004576467d-1*t10*t12*t15*t58*t626
            t631 = 2.396953300320353d+0*t10*t15*t293*t58*t82*t83
            t632 = -8.389336551121236d+0*t10*t143*t15*t173*t58*t62
            t633 = 3.9949221672005897d-1*t10*t143*t15*t175*t58*t83
            t634 = -2.054531400274588d+0*t10*t12*t143*t15*t184*t185*t299
            t635 = -2.396953300320353d+0*t10*t14*t184*t185*t299*t82*t83
            t636 = 1.027265700137294d+0*t10*t12*t143*t15*t299*t56*t87
            t637 = 1.1984766501601765d+0*t10*t14*t299*t56*t82*t83*t87
            t638 = t148**3
            t639 = -1.027265700137294d+0*t10*t12*t14*t396*t397*t638
            t640 = 3.4242190004576467d-1*t10*t12*t14*t184*t185*t638
            t641 = -1.7121095002288234d-1*t10*t12*t14*t56*t638*t87
            t642 = 1.027265700137294d+0*t10*t12*t143*t15*t305*t56*t87
            t643 = 1.1984766501601765d+0*t10*t14*t305*t56*t82*t83*t87
            t644 = -3.081797100411882d+0*t10*t12*t148*t288*t56*t63*t87
            t645 = 1.027265700137294d+0*t10*t12*t148*t15*t293*t56*t87
            t646 = -4.793906600640706d+0*t10*t143*t148*t15*t56*t82*t83*t
     1         87
            t647 = -4.194668275560618d+0*t10*t14*t148*t173*t56*t62*t87
            t648 = 1.9974610836002948d-1*t10*t14*t148*t175*t56*t83*t87
            t649 = 1.027265700137294d+0*t10*t12*t14*t148*t184*t185*t305
            t650 = -5.13632850068647d-1*t10*t12*t14*t148*t305*t56*t87
            t651 = 3.4242190004576467d-1*t10*t12*t14*t184*t185*t299*t546
            t652 = -4.0427615117563703d+1*t15*(1.1250000000000002d+0*t54
     1         *(1.3333333333333333d+0*t625*t77+1.3333333333333333d+0*t6
     2         23*t73-2.962962962962963d-1*t455*t624-2.962962962962963d-
     3         1*t454*t622+1.3333333333333333d+0*t142*t252*t292+1.333333
     4         3333333333d+0*t141*t251*t290)+1.1250000000000002d+0*t35*(
     5         t573-240*t127*t246*t53+t497+t496+t495+t494+t490+t489+t488
     6         +t487+t486+t485+t483+t482+t481+t479+t478+t473+t472+t471+t
     7         470+t469+t468+t467+t466+t465+t464+t463+t461+t460-12*t127*
     8         t244*t46+t458+96*t123*t125*t127)+t453+t451+t450+t449+t446
     9         +t445+t444+t442+t441+t435+t434+t433+t432+t431+t430+t429+t
     :         427+t426+t423+t422+t420+t418+t416+3.375000000000001d+0*t1
     ;         45*t303+3.375000000000001d+0*t146*t302)+1.212828453526911
     <         1d+2*t55*t626*t63+3.638485360580734d+2*t143*t304*t63+3.63
     =         8485360580734d+2*t147*t293*t63+2.4256569070538223d+3*t260
     >         *t55*t621-1.4553941442322935d+3*t135*t143*t293*t55-1.4553
     ?         941442322935d+3*t135*t147*t288
            t653 = -1.7121095002288234d-1*t10*t12*t14*t56*t652*t87
            t654 = -1.398222758520206d+0*t10*t134*t14*t153*t173*t60*t62
            t655 = 6.658203612000984d-2*t10*t134*t14*t153*t175*t60*t83
            t656 = 1.5979688668802353d+0*t15*t60*t66*t79*t82*t83
            t657 = 1.398222758520206d+0*t14*t173*t60*t62*t66
            t658 = -6.658203612000984d-2*t14*t175*t60*t66*t83
            t659 = 2.735897678055539d-1*t10*t135*t136*t58*t66*t79*t82
            t660 = 2.3939104682985965d-1*t10*t173*t261*t58*t63*t66
            t661 = -1.1399573658564749d-2*t10*t136*t175*t58*t63*t66
            t662 = 1.027265700137294d+0*t12*t158*t58*t63
            t663 = -3.4242190004576467d-1*t12*t15*t170*t58
            t664 = 1.5979688668802353d+0*t15*t58*t79*t82*t83
            t665 = 1.398222758520206d+0*t14*t173*t58*t62
            t666 = -6.658203612000984d-2*t14*t175*t58*t83
            t667 = 3.4242190004576467d-1*t12*t14*t184*t185*t186
            t668 = -1.7121095002288234d-1*t12*t14*t186*t56*t87
            t669 = -1.7121095002288234d-1*t12*t14*t255*t56*t87
            t670 = 6.848438000915293d-1*t12*t131*t15*t56*t79*t87
            t671 = 7.989844334401176d-1*t131*t14*t56*t82*t83*t87
            t672 = 2.188718142444431d+0*t10*t135*t136*t64*t79*t82
            t673 = 1.5959403121990645d+0*t10*t173*t261*t63*t64
            t674 = -4.5598294634259007d-2*t10*t136*t175*t63*t64
            t675 = 1.0943590712222155d+0*t10*t131*t136*t138*t56*t63*t82
            t676 = -7.989844334401176d-1*t133*t14*t66*t82*t83
            t677 = 7.989844334401176d-1*t134*t139*t14*t60*t82*t83
            t678 = 1.3679488390277694d-1*t10*t134*t136*t139*t58*t63*t82
            t679 = t81*(2.473556743557577d-2*t1*(-1.5979688668802353d+0*
     1         t10*t134*t15*t153*t60*t79*t82*t83-7.989844334401176d-1*t1
     2         0*t14*t320*t66*t82*t83+7.989844334401176d-1*t10*t134*t14*
     3         t322*t60*t82*t83-1.5979688668802353d+0*t10*t139*t14*t153*
     4         t177*t60*t82*t83+7.989844334401176d-1*t10*t133*t134*t14*t
     5         153*t82*t83-1.7121095002288234d-1*t10*t12*t134*t14*t60*(9
     6         .380220610476132d-1*t10*t131*t135*t138*t56*t62*t79+t675+t
     7         674+t673+t672+t671+t670+t669+t668+t667+t666+t665+t664+t66
     8         3+t662+1.1725275763095164d+0*t10*t158*t260*t62*t64-2.3450
     9         55152619033d-1*t10*t135*t170*t62*t64-1.1725275763095165d-
     :         1*t10*t138*t255*t56*t62*t63-1.1725275763095165d-1*t10*t13
     ;         8*t186*t56*t62*t63+3.5175827289285494d-1*t10*t184*t186*t2
     <         64*t62*t63)-6.848438000915293d-1*t10*t12*t15*t320*t66*t79
     =         -6.848438000915293d-1*t12*t133*t15*t66*t79+1.172527576309
     >         5165d-1*t10*t134*t135*t139*t58*t62*t79+6.848438000915293d
     ?         -1*t10*t12*t134*t15*t322*t60*t79-1.3696876001830588d+0*t1
     @         0*t12*t139*t15*t153*t177*t60*t79+6.848438000915293d-1*t12
     1         *t134*t139*t15*t60*t79+6.848438000915293d-1*t10*t12*t133*
     2         t134*t15*t153*t79+t678+t677+t676+1.7121095002288234d-1*t1
     3         0*t12*t14*t66*(t671+t670+t669+t668+t667+t666+t665+t664+t6
     4         63+t662)+t661+t660+1.027265700137294d+0*t12*t158*t60*t63*
     5         t66+1.7587913644642747d-1*t10*t158*t260*t58*t62*t66-5.862
     6         637881547582d-2*t10*t135*t170*t58*t62*t66-3.4242190004576
     7         467d-1*t12*t15*t170*t60*t66+1.7121095002288234d-1*t12*t14
     8         *t259*t66+t659+t658+t657+t656+t655+t654-2.931318940773791
     9         d-2*t10*t134*t265*t58*t62*t63+5.862637881547582d-2*t10*t1
     :         77*t178*t58*t62*t63-1.027265700137294d+0*t10*t12*t134*t15
     ;         3*t158*t60*t63-1.027265700137294d+0*t10*t12*t14*t153*t178
     <         *t381*t60+6.848438000915293d-1*t10*t12*t139*t14*t177*t322
     =         *t60+3.4242190004576467d-1*t10*t12*t14*t153*t177*t265*t60
     >         -1.7121095002288234d-1*t12*t134*t14*t265*t60+3.4242190004
     ?         576467d-1*t12*t14*t177*t178*t60+3.4242190004576467d-1*t10
     @         *t12*t134*t15*t153*t170*t60-3.4242190004576467d-1*t10*t12
     1         *t133*t134*t14*t322-3.4242190004576467d-1*t10*t12*t134*t1
     2         39*t14*t320-1.7121095002288234d-1*t10*t12*t134*t14*t153*t
     3         259+6.848438000915293d-1*t10*t12*t133*t139*t14*t153*t177-
     4         3.4242190004576467d-1*t12*t133*t134*t139*t14)*t9*wght+4.9
     5         47113487115154d-2*t323*t9*wght+1.4841340461345462d-1*t1*t
     6         154*t158*t8*wght+1.4841340461345462d-1*t1*t13*t323*t79*wg
     7         ht+1.4841340461345462d-1*t13*t154*t79*wght+7.420670230672
     8         731d-2*t1*t13*t154*t170*wght)+t171*(-4.947113487115154d-2
     9         *t1*t140*t323*t9*wght-t154*t267)+4.947113487115154d-2*t1*
     :         t154*t172*t374*t9*wght
            t680 = -1.398222758520206d+0*t10*t134*t14*t156*t173*t60*t62
            t681 = 6.658203612000984d-2*t10*t134*t14*t156*t175*t60*t83
            t682 = 2.796445517040412d+0*t14*t173*t60*t62*t66
            t683 = -1.3316407224001967d-1*t14*t175*t60*t66*t83
            t684 = 4.787820936597193d-1*t10*t173*t261*t58*t63*t66
            t685 = -2.2799147317129498d-2*t10*t136*t175*t58*t63*t66
            t686 = 2.054531400274588d+0*t12*t158*t58*t63
            t687 = -6.848438000915293d-1*t12*t15*t170*t58
            t688 = 3.1959377337604705d+0*t15*t58*t79*t82*t83
            t689 = 2.796445517040412d+0*t14*t173*t58*t62
            t690 = -1.3316407224001967d-1*t14*t175*t58*t83
            t691 = 6.848438000915293d-1*t12*t14*t184*t185*t186
            t692 = -3.4242190004576467d-1*t12*t14*t186*t56*t87
            t693 = -3.4242190004576467d-1*t12*t14*t255*t56*t87
            t694 = 1.3696876001830588d+0*t12*t131*t15*t56*t79*t87
            t695 = 1.5979688668802353d+0*t131*t14*t56*t82*t83*t87
            t696 = 3.191880624398129d+0*t10*t173*t261*t63*t64
            t697 = -9.119658926851801d-2*t10*t136*t175*t63*t64
            t698 = 1.027265700137294d+0*t12*t143*t58*t63*t79
            t699 = -3.4242190004576467d-1*t12*t15*t268*t58
            t700 = 7.989844334401176d-1*t143*t15*t58*t82*t83
            t701 = 7.989844334401176d-1*t15*t58*t79*t82*t83
            t702 = -1.7121095002288234d-1*t12*t14*t276*t56*t87
            t703 = 3.4242190004576467d-1*t12*t148*t15*t56*t79*t87
            t704 = 3.994922167200588d-1*t14*t148*t56*t82*t83*t87
            t705 = 3.4242190004576467d-1*t12*t131*t143*t15*t56*t87
            t706 = 3.994922167200588d-1*t131*t14*t56*t82*t83*t87
            t707 = 3.4242190004576467d-1*t12*t131*t14*t148*t184*t185
            t708 = -1.7121095002288234d-1*t12*t131*t14*t148*t56*t87
            t709 = t81*(2.473556743557577d-2*t1*(7.989844334401176d-1*t1
     1         5*t60*t66*t79*t82*t83-7.989844334401176d-1*t10*t134*t15*t
     2         153*t60*t79*t82*t83+7.989844334401176d-1*t143*t15*t60*t66
     3         *t82*t83-3.994922167200588d-1*t10*t14*t340*t66*t82*t83-3.
     4         994922167200588d-1*t10*t14*t320*t66*t82*t83-3.99492216720
     5         0588d-1*t14*t150*t66*t82*t83-3.994922167200588d-1*t133*t1
     6         4*t66*t82*t83+3.994922167200588d-1*t10*t134*t14*t341*t60*
     7         t82*t83+3.994922167200588d-1*t10*t134*t14*t322*t60*t82*t8
     8         3-7.989844334401176d-1*t10*t14*t151*t153*t177*t60*t82*t83
     9         -7.989844334401176d-1*t10*t139*t14*t153*t177*t60*t82*t83-
     :         7.989844334401176d-1*t10*t134*t143*t15*t153*t60*t82*t83+3
     ;         .994922167200588d-1*t134*t14*t151*t60*t82*t83+3.994922167
     <         200588d-1*t134*t139*t14*t60*t82*t83+3.994922167200588d-1*
     =         t10*t134*t14*t150*t153*t82*t83+3.994922167200588d-1*t10*t
     >         133*t134*t14*t153*t82*t83-1.7121095002288234d-1*t10*t12*t
     ?         134*t14*t60*(1.0943590712222155d+0*t10*t135*t136*t64*t79*
     @         t82+1.0943590712222155d+0*t10*t135*t136*t143*t64*t82+5.47
     1         1795356111078d-1*t10*t136*t138*t148*t56*t63*t82+5.4717953
     2         56111078d-1*t10*t131*t136*t138*t56*t63*t82+1.172527576309
     3         5164d+0*t10*t143*t260*t62*t64*t79+4.690110305238066d-1*t1
     4         0*t135*t138*t148*t56*t62*t79+t708+t707+t706+t705+t704+t70
     5         3+t702+t701+t700+t699+t698+t674+t673+t666+t665-2.34505515
     6         2619033d-1*t10*t135*t268*t62*t64-1.1725275763095165d-1*t1
     7         0*t138*t276*t56*t62*t63-1.1725275763095165d-1*t10*t131*t1
     8         38*t148*t56*t62*t63+3.5175827289285494d-1*t10*t131*t148*t
     9         184*t264*t62*t63+4.690110305238066d-1*t10*t131*t135*t138*
     :         t143*t56*t62)+1.3679488390277694d-1*t10*t135*t136*t58*t66
     ;         *t79*t82+1.3679488390277694d-1*t10*t135*t136*t143*t58*t66
     <         *t82+6.839744195138847d-2*t10*t134*t136*t151*t58*t63*t82+
     =         6.839744195138847d-2*t10*t134*t136*t139*t58*t63*t82+1.027
     >         265700137294d+0*t12*t143*t60*t63*t66*t79+1.75879136446427
     ?         47d-1*t10*t143*t260*t58*t62*t66*t79-3.4242190004576467d-1
     @         *t10*t12*t15*t340*t66*t79-3.4242190004576467d-1*t12*t15*t
     1         150*t66*t79-1.027265700137294d+0*t10*t12*t134*t143*t153*t
     2         60*t63*t79+5.862637881547582d-2*t10*t134*t135*t151*t58*t6
     3         2*t79+3.4242190004576467d-1*t10*t12*t134*t15*t341*t60*t79
     4         -6.848438000915293d-1*t10*t12*t15*t151*t153*t177*t60*t79+
     5         3.4242190004576467d-1*t12*t134*t15*t151*t60*t79+3.4242190
     6         004576467d-1*t10*t12*t134*t15*t150*t153*t79+1.71210950022
     7         88234d-1*t10*t12*t14*t66*(t708+t707+t706+t705+t704+t703+t
     8         702+t701+t700+t699+t698+t666+t665)+t661+t660-5.8626378815
     9         47582d-2*t10*t135*t268*t58*t62*t66-3.4242190004576467d-1*
     :         t12*t15*t268*t60*t66-3.4242190004576467d-1*t10*t12*t143*t
     ;         15*t320*t66+1.7121095002288234d-1*t12*t14*t284*t66-3.4242
     <         190004576467d-1*t12*t133*t143*t15*t66+t658+t657+t655+t654
     =         -2.931318940773791d-2*t10*t134*t285*t58*t62*t63+5.8626378
     >         81547582d-2*t10*t139*t151*t177*t58*t62*t63+5.862637881547
     ?         582d-2*t10*t134*t135*t139*t143*t58*t62-1.027265700137294d
     @         +0*t10*t12*t139*t14*t151*t153*t381*t60+3.4242190004576467
     1         d-1*t10*t12*t139*t14*t177*t341*t60+3.4242190004576467d-1*
     2         t10*t12*t14*t151*t177*t322*t60+3.4242190004576467d-1*t10*
     3         t12*t134*t143*t15*t322*t60+3.4242190004576467d-1*t10*t12*
     4         t14*t153*t177*t285*t60-1.7121095002288234d-1*t12*t134*t14
     5         *t285*t60+3.4242190004576467d-1*t10*t12*t134*t15*t153*t26
     6         8*t60-6.848438000915293d-1*t10*t12*t139*t143*t15*t153*t17
     7         7*t60+3.4242190004576467d-1*t12*t139*t14*t151*t177*t60+3.
     8         4242190004576467d-1*t12*t134*t139*t143*t15*t60-1.71210950
     9         02288234d-1*t10*t12*t133*t134*t14*t341-1.7121095002288234
     :         d-1*t10*t12*t134*t139*t14*t340-1.7121095002288234d-1*t10*
     ;         t12*t134*t14*t150*t322-1.7121095002288234d-1*t10*t12*t134
     <         *t14*t151*t320-1.7121095002288234d-1*t10*t12*t134*t14*t15
     =         3*t284+3.4242190004576467d-1*t10*t12*t133*t14*t151*t153*t
     >         177+3.4242190004576467d-1*t10*t12*t139*t14*t150*t153*t177
     ?         +3.4242190004576467d-1*t10*t12*t133*t134*t143*t15*t153-1.
     @         7121095002288234d-1*t12*t133*t134*t14*t151-1.712109500228
     1         8234d-1*t12*t134*t139*t14*t150)*t9*wght+2.473556743557577
     2         d-2*t342*t9*wght+2.473556743557577d-2*t323*t9*wght+1.4841
     3         340461345462d-1*t1*t143*t154*t79*t8*wght+7.42067023067273
     4         1d-2*t1*t13*t342*t79*wght+7.420670230672731d-2*t13*t154*t
     5         79*wght+7.420670230672731d-2*t1*t13*t143*t323*wght+7.4206
     6         70230672731d-2*t1*t13*t154*t268*wght+7.420670230672731d-2
     7         *t13*t143*t154*wght)+t171*(-2.473556743557577d-2*t1*t140*
     8         t342*t9*wght-2.473556743557577d-2*t1*t152*t323*t9*wght-t1
     9         54*t287)+4.947113487115154d-2*t1*t140*t152*t154*t374*t9*w
     :         ght
            t710 = 1.5979688668802353d+0*t143*t15*t60*t66*t82*t83
            t711 = 2.735897678055539d-1*t10*t135*t136*t143*t58*t66*t82
            t712 = -7.989844334401176d-1*t14*t150*t66*t82*t83
            t713 = 7.989844334401176d-1*t134*t14*t151*t60*t82*t83
            t714 = 1.3679488390277694d-1*t10*t134*t136*t151*t58*t63*t82
            t715 = 2.054531400274588d+0*t12*t143*t58*t63*t79
            t716 = -6.848438000915293d-1*t12*t15*t268*t58
            t717 = 1.5979688668802353d+0*t143*t15*t58*t82*t83
            t718 = -3.4242190004576467d-1*t12*t14*t276*t56*t87
            t719 = 6.848438000915293d-1*t12*t148*t15*t56*t79*t87
            t720 = 7.989844334401176d-1*t14*t148*t56*t82*t83*t87
            t721 = 6.848438000915293d-1*t12*t131*t143*t15*t56*t87
            t722 = 6.848438000915293d-1*t12*t131*t14*t148*t184*t185
            t723 = -3.4242190004576467d-1*t12*t131*t14*t148*t56*t87
            t724 = 2.188718142444431d+0*t10*t135*t136*t143*t64*t82
            t725 = 1.0943590712222155d+0*t10*t136*t138*t148*t56*t63*t82
            t726 = 1.027265700137294d+0*t12*t288*t58*t63
            t727 = -3.4242190004576467d-1*t12*t15*t293*t58
            t728 = 3.4242190004576467d-1*t12*t14*t184*t185*t299
            t729 = -1.7121095002288234d-1*t12*t14*t299*t56*t87
            t730 = -1.7121095002288234d-1*t12*t14*t305*t56*t87
            t731 = 6.848438000915293d-1*t12*t143*t148*t15*t56*t87
            t732 = t81*(2.473556743557577d-2*t1*(-7.989844334401176d-1*t
     1         10*t14*t340*t66*t82*t83+7.989844334401176d-1*t10*t134*t14
     2         *t341*t60*t82*t83-1.5979688668802353d+0*t10*t14*t151*t153
     3         *t177*t60*t82*t83-1.5979688668802353d+0*t10*t134*t143*t15
     4         *t153*t60*t82*t83+7.989844334401176d-1*t10*t134*t14*t150*
     5         t153*t82*t83-1.7121095002288234d-1*t10*t12*t134*t14*t60*(
     6         t731+t730+t729+t728+t727+t726+t725+t724+t720+t717+t674+t6
     7         73+t666+t665-2.345055152619033d-1*t10*t135*t293*t62*t64+1
     8         .1725275763095164d+0*t10*t260*t288*t62*t64-1.172527576309
     9         5165d-1*t10*t138*t305*t56*t62*t63-1.1725275763095165d-1*t
     :         10*t138*t299*t56*t62*t63+3.5175827289285494d-1*t10*t184*t
     ;         264*t299*t62*t63+9.380220610476132d-1*t10*t135*t138*t143*
     <         t148*t56*t62)+1.7121095002288234d-1*t10*t12*t14*t66*(t731
     =         +t730+t729+t728+t727+t726+t720+t717+t666+t665)+t714+t713+
     >         t712+t711+t710+t661+t660+1.027265700137294d+0*t12*t288*t6
     ?         0*t63*t66-5.862637881547582d-2*t10*t135*t293*t58*t62*t66+
     @         1.7587913644642747d-1*t10*t260*t288*t58*t62*t66-3.4242190
     1         004576467d-1*t12*t15*t293*t60*t66-6.848438000915293d-1*t1
     2         0*t12*t143*t15*t340*t66+1.7121095002288234d-1*t12*t14*t30
     3         9*t66-6.848438000915293d-1*t12*t143*t15*t150*t66+t658+t65
     4         7+t655+t654-2.931318940773791d-2*t10*t134*t310*t58*t62*t6
     5         3+5.862637881547582d-2*t10*t177*t295*t58*t62*t63-1.027265
     6         700137294d+0*t10*t12*t134*t153*t288*t60*t63+1.17252757630
     7         95165d-1*t10*t134*t135*t143*t151*t58*t62-1.02726570013729
     8         4d+0*t10*t12*t14*t153*t295*t381*t60+6.848438000915293d-1*
     9         t10*t12*t14*t151*t177*t341*t60+6.848438000915293d-1*t10*t
     :         12*t134*t143*t15*t341*t60+3.4242190004576467d-1*t10*t12*t
     ;         14*t153*t177*t310*t60-1.7121095002288234d-1*t12*t134*t14*
     <         t310*t60+3.4242190004576467d-1*t12*t14*t177*t295*t60+3.42
     =         42190004576467d-1*t10*t12*t134*t15*t153*t293*t60-1.369687
     >         6001830588d+0*t10*t12*t143*t15*t151*t153*t177*t60+6.84843
     ?         8000915293d-1*t12*t134*t143*t15*t151*t60-3.42421900045764
     @         67d-1*t10*t12*t134*t14*t150*t341-3.4242190004576467d-1*t1
     1         0*t12*t134*t14*t151*t340-1.7121095002288234d-1*t10*t12*t1
     2         34*t14*t153*t309+6.848438000915293d-1*t10*t12*t14*t150*t1
     3         51*t153*t177+6.848438000915293d-1*t10*t12*t134*t143*t15*t
     4         150*t153-3.4242190004576467d-1*t12*t134*t14*t150*t151)*t9
     5         *wght+4.947113487115154d-2*t342*t9*wght+1.484134046134546
     6         2d-1*t1*t154*t288*t8*wght+1.4841340461345462d-1*t1*t13*t1
     7         43*t342*wght+7.420670230672731d-2*t1*t13*t154*t293*wght+1
     8         .4841340461345462d-1*t13*t143*t154*wght)+t171*(-4.9471134
     9         87115154d-2*t1*t152*t342*t9*wght-t154*t312)+4.94711348711
     :         5154d-2*t1*t154*t294*t374*t9*wght
            t733 = 2.054531400274588d+0*t12*t288*t58*t63
            t734 = -6.848438000915293d-1*t12*t15*t293*t58
            t735 = 3.1959377337604705d+0*t143*t15*t58*t82*t83
            t736 = 6.848438000915293d-1*t12*t14*t184*t185*t299
            t737 = -3.4242190004576467d-1*t12*t14*t299*t56*t87
            t738 = -3.4242190004576467d-1*t12*t14*t305*t56*t87
            t739 = 1.3696876001830588d+0*t12*t143*t148*t15*t56*t87
            t740 = 1.5979688668802353d+0*t14*t148*t56*t82*t83*t87
            t741 = 2.473556743557577d-2*t355*t9*wght
            t742 = -7.989844334401176d-1*t10*t14*t177*t352*t60*t82*t83
            t743 = 6.848438000915293d-1*t12*t134*t15*t153*t60*t79
            t744 = 7.989844334401176d-1*t134*t14*t153*t60*t82*t83
            t745 = 2.342078203126433d-2*t10*t134*t260*t502*t60*t64*t82
            t746 = 1.1725275763095165d-1*t10*t134*t135*t153*t58*t62*t79
            t747 = 1.3679488390277694d-1*t10*t134*t136*t153*t58*t63*t82
            t748 = -1.3679488390277694d-1*t136*t58*t63*t66*t82
            t749 = -2.735897678055539d-1*t136*t63*t64*t82
            t750 = 3.4242190004576467d-1*t12*t14*t320*t66
            t751 = -3.4242190004576467d-1*t12*t134*t14*t322*t60
            t752 = -5.862637881547582d-2*t10*t134*t322*t58*t62*t63
            t753 = -3.4242190004576467d-1*t12*t133*t134*t14*t153
            t754 = 6.848438000915293d-1*t12*t139*t14*t153*t177*t60
            t755 = 1.1725275763095165d-1*t10*t139*t153*t177*t58*t62*t63
            t756 = t81*(2.473556743557577d-2*t1*(-1.7121095002288234d-1*
     1         t10*t12*t134*t14*t60*(-2.345055152619033d-1*t135*t62*t64*
     2         t79+t749-1.1725275763095165d-1*t131*t138*t56*t62*t63)-1.1
     3         725275763095165d-1*t135*t58*t62*t66*t79+2.0074956026798d-
     4         2*t10*t134*t261*t501*t60*t64*t79-6.848438000915293d-1*t10
     5         *t12*t15*t177*t352*t60*t79+t755+t754+t753+t752+t751+t750+
     6         t748+t747+t746+t745+t744+t743+t742+2.0074956026798d-2*t10
     7         *t139*t177*t260*t261*t60*t64-1.0037478013399d-2*t10*t133*
     8         t134*t260*t261*t64-5.862637881547582d-2*t134*t139*t58*t62
     9         *t63-1.027265700137294d+0*t10*t12*t139*t14*t352*t381*t60+
     :         6.848438000915293d-1*t10*t12*t14*t153*t177*t322*t60+3.424
     ;         2190004576467d-1*t10*t12*t133*t14*t177*t352-3.42421900045
     <         76467d-1*t10*t12*t134*t14*t153*t320)*t9*wght+7.4206702306
     =         72731d-2*t1*t13*t355*t79*wght+t741)+t171*(-2.473556743557
     >         577d-2*t1*t140*t355*t9*wght-2.473556743557577d-2*t1*t154*
     ?         t323*t9*wght-t154*t324)+4.947113487115154d-2*t1*t140*t351
     @         *t374*t9*wght
            t757 = 4.947113487115154d-2*t1*t140*t154*t157*t374*t9*wght
            t758 = 2.473556743557577d-2*t357*t9*wght
            t759 = -7.989844334401176d-1*t10*t14*t153*t156*t177*t60*t82*
     1         t83
            t760 = 3.994922167200588d-1*t134*t14*t156*t60*t82*t83
            t761 = 4.684156406252866d-2*t10*t134*t260*t502*t60*t64*t82
            t762 = 6.839744195138847d-2*t10*t134*t136*t156*t58*t63*t82
            t763 = -2.735897678055539d-1*t136*t58*t63*t66*t82
            t764 = -5.471795356111078d-1*t136*t63*t64*t82
            t765 = t81*(2.473556743557577d-2*t1*(-1.7121095002288234d-1*
     1         t10*t12*t134*t14*t60*(-4.690110305238066d-1*t135*t62*t64*
     2         t79+t764-2.345055152619033d-1*t131*t138*t56*t62*t63)-2.34
     3         5055152619033d-1*t135*t58*t62*t66*t79+4.0149912053596d-2*
     4         t10*t134*t261*t501*t60*t64*t79+5.862637881547582d-2*t10*t
     5         134*t135*t156*t58*t62*t79-6.848438000915293d-1*t10*t12*t1
     6         5*t153*t156*t177*t60*t79+3.4242190004576467d-1*t12*t134*t
     7         15*t156*t60*t79+t763+t762+t761+t760+t759+t755+t754+t753+t
     8         752+t751+t750+t747+t746+t744+t743+1.7121095002288234d-1*t
     9         12*t14*t333*t66+4.0149912053596d-2*t10*t139*t177*t260*t26
     :         1*t60*t64-2.0074956026798d-2*t10*t133*t134*t260*t261*t64-
     ;         2.931318940773791d-2*t10*t134*t335*t58*t62*t63+5.86263788
     <         1547582d-2*t10*t139*t156*t177*t58*t62*t63-1.1725275763095
     =         165d-1*t134*t139*t58*t62*t63-1.027265700137294d+0*t10*t12
     >         *t139*t14*t153*t156*t381*t60+3.4242190004576467d-1*t10*t1
     ?         2*t14*t153*t177*t335*t60-1.7121095002288234d-1*t12*t134*t
     @         14*t335*t60+3.4242190004576467d-1*t10*t12*t14*t156*t177*t
     1         322*t60+3.4242190004576467d-1*t12*t139*t14*t156*t177*t60-
     2         1.7121095002288234d-1*t10*t12*t134*t14*t153*t333-1.712109
     3         5002288234d-1*t10*t12*t134*t14*t156*t320+3.42421900045764
     4         67d-1*t10*t12*t133*t14*t153*t156*t177-1.7121095002288234d
     5         -1*t12*t133*t134*t14*t156)*t9*wght+7.420670230672731d-2*t
     6         1*t13*t357*t79*wght+t758)
            t766 = -2.473556743557577d-2*t1*t140*t357*t9*wght
            t767 = 2.473556743557577d-2*t361*t9*wght
            t768 = -7.989844334401176d-1*t10*t14*t177*t360*t60*t82*t83
            t769 = 1.5979688668802353d+0*t134*t14*t156*t60*t82*t83
            t770 = 9.368312812505732d-2*t10*t134*t260*t502*t60*t64*t82
            t771 = 2.735897678055539d-1*t10*t134*t136*t156*t58*t63*t82
            t772 = -5.471795356111078d-1*t136*t58*t63*t66*t82
            t773 = -1.0943590712222155d+0*t136*t63*t64*t82
            t774 = 6.848438000915293d-1*t12*t134*t143*t15*t153*t60
            t775 = 1.1725275763095165d-1*t10*t134*t135*t143*t153*t58*t62
            t776 = 3.4242190004576467d-1*t12*t14*t340*t66
            t777 = -3.4242190004576467d-1*t12*t134*t14*t341*t60
            t778 = -5.862637881547582d-2*t10*t134*t341*t58*t62*t63
            t779 = -3.4242190004576467d-1*t12*t134*t14*t150*t153
            t780 = 6.848438000915293d-1*t12*t14*t151*t153*t177*t60
            t781 = 1.1725275763095165d-1*t10*t151*t153*t177*t58*t62*t63
            t782 = t81*(2.473556743557577d-2*t1*(t781+t780+t779+t778+t77
     1         7+t776+t775+t774-1.7121095002288234d-1*t10*t12*t134*t14*t
     2         60*(t749-2.345055152619033d-1*t135*t143*t62*t64-1.1725275
     3         763095165d-1*t138*t148*t56*t62*t63)+t748+t747+t745+t744+t
     4         742-1.1725275763095165d-1*t135*t143*t58*t62*t66+2.0074956
     5         026798d-2*t10*t134*t143*t261*t501*t60*t64+2.0074956026798
     6         d-2*t10*t151*t177*t260*t261*t60*t64-1.0037478013399d-2*t1
     7         0*t134*t150*t260*t261*t64-5.862637881547582d-2*t134*t151*
     8         t58*t62*t63-1.027265700137294d+0*t10*t12*t14*t151*t352*t3
     9         81*t60-6.848438000915293d-1*t10*t12*t143*t15*t177*t352*t6
     :         0+6.848438000915293d-1*t10*t12*t14*t153*t177*t341*t60+3.4
     ;         242190004576467d-1*t10*t12*t14*t150*t177*t352-3.424219000
     <         4576467d-1*t10*t12*t134*t14*t153*t340)*t9*wght+7.42067023
     =         0672731d-2*t1*t13*t143*t355*wght+t741)+t171*(-2.473556743
     >         557577d-2*t1*t152*t355*t9*wght-2.473556743557577d-2*t1*t1
     ?         54*t342*t9*wght-t154*t343)+4.947113487115154d-2*t1*t152*t
     @         351*t374*t9*wght
            t783 = 4.947113487115154d-2*t1*t152*t154*t157*t374*t9*wght
            t784 = t81*(2.473556743557577d-2*t1*(t781+t780+t779+t778+t77
     1         7+t776+t775+t774-1.7121095002288234d-1*t10*t12*t134*t14*t
     2         60*(t764-4.690110305238066d-1*t135*t143*t62*t64-2.3450551
     3         52619033d-1*t138*t148*t56*t62*t63)+t763+t762+t761+t760+t7
     4         59+t747+t744-2.345055152619033d-1*t135*t143*t58*t62*t66+1
     5         .7121095002288234d-1*t12*t14*t347*t66+4.0149912053596d-2*
     6         t10*t134*t143*t261*t501*t60*t64+4.0149912053596d-2*t10*t1
     7         51*t177*t260*t261*t60*t64-2.0074956026798d-2*t10*t134*t15
     8         0*t260*t261*t64-2.931318940773791d-2*t10*t134*t348*t58*t6
     9         2*t63+5.862637881547582d-2*t10*t151*t156*t177*t58*t62*t63
     :         -1.1725275763095165d-1*t134*t151*t58*t62*t63+5.8626378815
     ;         47582d-2*t10*t134*t135*t143*t156*t58*t62-1.02726570013729
     <         4d+0*t10*t12*t14*t151*t153*t156*t381*t60+3.42421900045764
     =         67d-1*t10*t12*t14*t153*t177*t348*t60-1.7121095002288234d-
     >         1*t12*t134*t14*t348*t60+3.4242190004576467d-1*t10*t12*t14
     ?         *t156*t177*t341*t60-6.848438000915293d-1*t10*t12*t143*t15
     @         *t153*t156*t177*t60+3.4242190004576467d-1*t12*t14*t151*t1
     1         56*t177*t60+3.4242190004576467d-1*t12*t134*t143*t15*t156*
     2         t60-1.7121095002288234d-1*t10*t12*t134*t14*t153*t347-1.71
     3         21095002288234d-1*t10*t12*t134*t14*t156*t340+3.4242190004
     4         576467d-1*t10*t12*t14*t150*t153*t156*t177-1.7121095002288
     5         234d-1*t12*t134*t14*t150*t156)*t9*wght+7.420670230672731d
     6         -2*t1*t13*t143*t357*wght+t758)
            t785 = -2.473556743557577d-2*t1*t152*t357*t9*wght
            t786 = 1/t11**8.0d+0
            t787 = 1/t8**8.0d+0
            t788 = 2.473556743557577d-2*t1*(-5.155578439523509d-3*t10*t1
     1         34*t138*t786*t787+6.0224868080394d-2*t10*t153*t177*t260*t
     2         261*t60*t64-3.0112434040197d-2*t134*t260*t261*t60*t64+1.7
     3         587913644642747d-1*t10*t177*t352*t58*t62*t63-1.7587913644
     4         642747d-1*t134*t153*t58*t62*t63-1.027265700137294d+0*t10*
     5         t12*t14*t153**3*t381*t60+1.027265700137294d+0*t12*t14*t17
     6         7*t352*t60)*t81*t9*wght+4.947113487115154d-2*t1*t154**3*t
     7         374*t9*wght-7.420670230672731d-2*t1*t154*t171*t355*t9*wgh
     8         t
            t789 = 8.0299824107192d-2*t10*t153*t177*t260*t261*t60*t64
            t790 = -2.345055152619033d-1*t134*t153*t58*t62*t63
            t791 = t171*(-4.947113487115154d-2*t1*t154*t357*t9*wght-2.47
     1         3556743557577d-2*t1*t157*t355*t9*wght)+2.473556743557577d
     2         -2*t1*(t790+t789-1.0311156879047018d-2*t10*t134*t138*t786
     3         *t787+2.0074956026798d-2*t10*t156*t177*t260*t261*t60*t64-
     4         6.0224868080394d-2*t134*t260*t261*t60*t64+1.1725275763095
     5         165d-1*t10*t177*t352*t58*t62*t63+1.1725275763095165d-1*t1
     6         0*t153*t156*t177*t58*t62*t63-5.862637881547582d-2*t134*t1
     7         56*t58*t62*t63-1.027265700137294d+0*t10*t12*t14*t156*t352
     8         *t381*t60+6.848438000915293d-1*t12*t14*t177*t352*t60+6.84
     9         8438000915293d-1*t12*t14*t153*t156*t177*t60)*t81*t9*wght+
     :         4.947113487115154d-2*t1*t157*t351*t374*t9*wght
            t792 = t171*(-2.473556743557577d-2*t1*t154*t361*t9*wght-4.94
     1         7113487115154d-2*t1*t157*t357*t9*wght)+2.473556743557577d
     2         -2*t1*(t790+t789-2.0622313758094035d-2*t10*t134*t138*t786
     3         *t787+8.0299824107192d-2*t10*t156*t177*t260*t261*t60*t64-
     4         1.20449736160788d-1*t134*t260*t261*t60*t64+5.862637881547
     5         582d-2*t10*t177*t360*t58*t62*t63+2.345055152619033d-1*t10
     6         *t153*t156*t177*t58*t62*t63-2.345055152619033d-1*t134*t15
     7         6*t58*t62*t63-1.027265700137294d+0*t10*t12*t14*t153*t360*
     8         t381*t60+3.4242190004576467d-1*t12*t14*t177*t360*t60+1.36
     9         96876001830588d+0*t12*t14*t153*t156*t177*t60)*t81*t9*wght
     :         +4.947113487115154d-2*t1*t154*t359*t374*t9*wght
            fnc(iq) = 2.473556743557577d-2*t1*t68*t9*wght+fnc(iq)
            Amat(iq,D1_RA) = 2.473556743557577d-2*t1*t140*t81*t9*wght+7.
     1         420670230672731d-2*t1*t13*t68*t79*wght+t80+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 2.473556743557577d-2*t1*t152*t81*t9*wght+7.
     1         420670230672731d-2*t1*t13*t143*t68*wght+t80+Amat(iq,D1_RB
     2         )
            Cmat(iq,D1_GAA) = t155+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = 2.473556743557577d-2*t1*t157*t81*t9*wght+C
     1         mat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = t155+Cmat(iq,D1_GBB)
            Amat2(iq,D2_RA_RA) = -2.473556743557577d-2*t1*t171*t172*t9*w
     1         ght+1.4841340461345462d-1*t1*t158*t68*t8*wght+1.484134046
     2         1345462d-1*t13*t68*t79*wght+7.420670230672731d-2*t1*t13*t
     3         170*t68*wght+t267*t81+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = -2.473556743557577d-2*t1*t140*t152*t171
     1         *t9*wght+1.4841340461345462d-1*t1*t143*t68*t79*t8*wght+7.
     2         420670230672731d-2*t13*t68*t79*wght+7.420670230672731d-2*
     3         t1*t13*t268*t68*wght+7.420670230672731d-2*t13*t143*t68*wg
     4         ht+t287*t81+Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = -2.473556743557577d-2*t1*t171*t294*t9*w
     1         ght+1.4841340461345462d-1*t1*t288*t68*t8*wght+7.420670230
     2         672731d-2*t1*t13*t293*t68*wght+1.4841340461345462d-1*t13*
     3         t143*t68*wght+t312*t81+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RA_GAA) = t325+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = -2.473556743557577d-2*t1*t140*t157*t17
     1         1*t9*wght+t337*t81+Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = t325+Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = t344+Cmat2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = -2.473556743557577d-2*t1*t152*t157*t17
     1         1*t9*wght+t350*t81+Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = t344+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = t356+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = t358+Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = t356+Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = 2.473556743557577d-2*t1*t361*t81*t9*w
     1         ght-2.473556743557577d-2*t1*t171*t359*t9*wght+Cmat2(iq,D2
     2         _GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = t358+Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = t356+Cmat2(iq,D2_GBB_GBB)
            Amat3(iq,D3_RA_RA_RA) = t81*(2.473556743557577d-2*t1*(4.7939
     1         06600640706d+0*t10*t133*t15*t66*t79*t82*t83-4.79390660064
     2         0706d+0*t10*t134*t139*t15*t60*t79*t82*t83-7.1908599009610
     3         59d+0*t10*t158*t60*t63*t66*t82*t83+2.396953300320353d+0*t
     4         10*t15*t170*t60*t66*t82*t83-1.1984766501601765d+0*t10*t14
     5         *t259*t66*t82*t83+1.1984766501601765d+0*t10*t134*t14*t265
     6         *t60*t82*t83-2.396953300320353d+0*t10*t14*t177*t178*t60*t
     7         82*t83+2.396953300320353d+0*t10*t133*t134*t139*t14*t82*t8
     8         3+3.9949221672005897d-1*t10*t15*t175*t60*t66*t79*t83-1.99
     9         74610836002948d-1*t10*t133*t14*t175*t66*t83+1.99746108360
     :         02948d-1*t10*t134*t139*t14*t175*t60*t83-1.712109500228823
     ;         4d-1*t10*t12*t134*t14*t60*(-6.566154427333293d+0*t131*t13
     <         5*t136*t138*t56*t61*t79*t82-8.207693034166617d+0*t136*t15
     =         8*t260*t61*t64*t82+1.6415386068333232d+0*t135*t136*t170*t
     >         61*t64*t82+8.207693034166617d-1*t136*t138*t255*t56*t61*t6
     ?         3*t82+8.207693034166617d-1*t136*t138*t186*t56*t61*t63*t82
     @         -2.4623079102499848d+0*t136*t184*t186*t264*t61*t63*t82+1.
     1         7587913644642747d+0*t170*t260*t61*t62*t64*t79-9.575641873
     2         194387d+0*t135*t173*t261*t61*t64*t79+2.73589767805554d-1*
     3         t135*t136*t175*t61*t64*t79+7.035165457857099d-1*t135*t138
     4         *t255*t56*t61*t62*t79+7.035165457857099d-1*t135*t138*t186
     5         *t56*t61*t62*t79-2.1105496373571295d+0*t135*t184*t186*t26
     6         4*t61*t62*t79-3.5175827289285494d+0*t362*t501*t61*t62*t64
     7         -1.1725275763095165d-1*t135*t373*t61*t62*t64-5.8626378815
     8         47582d-2*t138*t499*t56*t61*t62*t63-5.862637881547582d-2*t
     9         138*t398*t56*t61*t62*t63-1.7587913644642747d-1*t131*t138*
     :         t255*t56*t61*t62*t63-7.035165457857099d-1*t396*t398*t506*
     ;         t61*t62*t63+1.7587913644642747d-1*t184*t186*t264*t411*t61
     <         *t62*t63+1.7587913644642747d-1*t184*t264*t398*t61*t62*t63
     =         +5.276374093392824d-1*t131*t184*t255*t264*t61*t62*t63-4.7
     >         878209365971935d+0*t131*t138*t173*t261*t56*t61*t63+1.3679
     ?         4883902777d-1*t131*t136*t138*t175*t56*t61*t63-3.517582728
     @         9285494d+0*t131*t138*t158*t260*t56*t61*t62+7.035165457857
     1         099d-1*t131*t135*t138*t170*t56*t61*t62+t505+t504+t503+t50
     2         0+t412+t410+t409+t408+t407+t406+t405+t404+t403+t402+t401+
     3         t400+t399+t395+t394+t393+t392+t391+t390+t389+t388+t387+t3
     4         86+t385+t384+t383+t382)+3.081797100411882d+0*t10*t12*t170
     5         *t60*t63*t66*t79-8.389336551121236d+0*t10*t15*t173*t60*t6
     6         2*t66*t79-1.027265700137294d+0*t10*t12*t15*t259*t66*t79+1
     7         .027265700137294d+0*t10*t12*t134*t15*t265*t60*t79-2.05453
     8         1400274588d+0*t10*t12*t15*t177*t178*t60*t79+2.05453140027
     9         4588d+0*t10*t12*t133*t134*t139*t15*t79+3.081797100411882d
     :         +0*t10*t12*t133*t158*t63*t66+4.194668275560618d+0*t10*t13
     ;         3*t14*t173*t62*t66-3.4242190004576467d-1*t10*t12*t15*t373
     <         *t60*t66-4.109062800549176d+0*t10*t12*t135*t362*t60*t66+1
     =         .7121095002288234d-1*t10*t12*t14*(t500+t412+t410+t409+t40
     >         8+t407+t406+t405+t404+t403+t402+t401+t400+t399+t395+t394+
     ?         t393+t392+t391+t390+t389+t388+t387+t386+t385+t384+t383+t3
     @         82)*t66-1.027265700137294d+0*t10*t12*t133*t15*t170*t66-3.
     1         081797100411882d+0*t10*t12*t134*t139*t158*t60*t63-4.19466
     2         8275560618d+0*t10*t134*t139*t14*t173*t60*t62-1.0272657001
     3         37294d+0*t10*t12*t139**3*t14*t381*t60+1.027265700137294d+
     4         0*t10*t12*t139*t14*t177*t265*t60+1.027265700137294d+0*t10
     5         *t12*t134*t139*t15*t170*t60+t380+t378+t376-5.136328500686
     6         47d-1*t10*t12*t133*t134*t14*t265-5.13632850068647d-1*t10*
     7         t12*t134*t139*t14*t259+1.027265700137294d+0*t10*t12*t133*
     8         t14*t177*t178)*t9*wght+7.420670230672731d-2*t266*t9*wght+
     9         4.4524021384036383d-1*t1*t140*t158*t8*wght+2.226201069201
     :         8191d-1*t1*t13*t266*t79*wght+4.4524021384036383d-1*t13*t1
     ;         40*t79*wght+2.2262010692018191d-1*t1*t13*t140*t170*wght)+
     <         t171*(-4.947113487115154d-2*t1*t140*t266*t9*wght-7.420670
     =         230672731d-2*t1*t13*t172*t79*wght+t507-t140*t267)+4.94711
     >         3487115154d-2*t1*t140**3*t374*t9*wght+4.4524021384036383d
     ?         -1*t1*t170*t68*t79*t8*wght+4.4524021384036383d-1*t158*t68
     @         *t8*wght+7.420670230672731d-2*t1*t13*t373*t68*wght+1.4841
     1         340461345462d-1*t1*t362*t68*wght+2.2262010692018191d-1*t1
     2         3*t170*t68*wght+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = t81*(2.473556743557577d-2*t1*(1.5979
     1         688668802353d+0*t10*t133*t15*t66*t79*t82*t83-1.5979688668
     2         802353d+0*t10*t134*t139*t15*t60*t79*t82*t83-2.39695330032
     3         0353d+0*t10*t158*t60*t63*t66*t82*t83+7.989844334401176d-1
     4         *t10*t15*t170*t60*t66*t82*t83-3.994922167200588d-1*t10*t1
     5         4*t259*t66*t82*t83+3.994922167200588d-1*t10*t134*t14*t265
     6         *t60*t82*t83-7.989844334401176d-1*t10*t14*t177*t178*t60*t
     7         82*t83+7.989844334401176d-1*t10*t133*t134*t139*t14*t82*t8
     8         3+2.6632814448003933d-1*t10*t15*t175*t60*t66*t79*t83+1.33
     9         16407224001967d-1*t10*t143*t15*t175*t60*t66*t83-6.6582036
     :         12000984d-2*t10*t14*t150*t175*t66*t83-1.3316407224001967d
     ;         -1*t10*t133*t14*t175*t66*t83+6.658203612000984d-2*t10*t13
     <         4*t14*t151*t175*t60*t83+1.3316407224001967d-1*t10*t134*t1
     =         39*t14*t175*t60*t83-1.7121095002288234d-1*t10*t12*t134*t1
     >         4*t60*(-5.471795356111078d+0*t136*t143*t260*t61*t64*t79*t
     ?         82-2.188718142444431d+0*t131*t135*t136*t138*t56*t61*t79*t
     @         82-2.7358976780555383d+0*t136*t158*t260*t61*t64*t82+5.471
     1         795356111078d-1*t135*t136*t170*t61*t64*t82+2.735897678055
     2         539d-1*t136*t138*t255*t56*t61*t63*t82+2.735897678055539d-
     3         1*t136*t138*t186*t56*t61*t63*t82-8.207693034166615d-1*t13
     4         6*t184*t186*t264*t61*t63*t82+1.1725275763095164d+0*t260*t
     5         268*t61*t62*t64*t79-6.383761248796258d+0*t135*t173*t261*t
     6         61*t64*t79+1.8239317853703602d-1*t135*t136*t175*t61*t64*t
     7         79+4.690110305238066d-1*t135*t138*t276*t56*t61*t62*t79-2.
     8         3450551526190327d+0*t131*t138*t143*t260*t56*t61*t62*t79+4
     9         .690110305238066d-1*t131*t135*t138*t148*t56*t61*t62*t79-1
     :         .4070330915714196d+0*t131*t135*t148*t184*t264*t61*t62*t79
     ;         -1.1725275763095165d-1*t135*t512*t61*t62*t64-3.5175827289
     <         285494d+0*t143*t158*t501*t61*t62*t64+5.862637881547582d-1
     =         *t143*t170*t260*t61*t62*t64-3.191880624398129d+0*t135*t14
     >         3*t173*t261*t61*t64+9.119658926851801d-2*t135*t136*t143*t
     ?         175*t61*t64-5.862637881547582d-2*t138*t56*t574*t61*t62*t6
     @         3-1.1725275763095165d-1*t131*t138*t276*t56*t61*t62*t63-5.
     1         862637881547582d-2*t138*t148*t255*t56*t61*t62*t63-5.86263
     2         7881547582d-2*t138*t148*t186*t56*t61*t62*t63+1.7587913644
     3         642747d-1*t184*t186*t264*t546*t61*t62*t63-7.0351654578570
     4         99d-1*t148*t186*t396*t506*t61*t62*t63+3.5175827289285494d
     5         -1*t131*t184*t264*t276*t61*t62*t63+1.7587913644642747d-1*
     6         t148*t184*t255*t264*t61*t62*t63+1.7587913644642747d-1*t14
     7         8*t184*t186*t264*t61*t62*t63-1.5959403121990645d+0*t138*t
     8         148*t173*t261*t56*t61*t63-3.191880624398129d+0*t131*t138*
     9         t173*t261*t56*t61*t63+4.5598294634259007d-2*t136*t138*t14
     :         8*t175*t56*t61*t63+9.119658926851801d-2*t131*t136*t138*t1
     ;         75*t56*t61*t63+4.690110305238066d-1*t131*t135*t138*t268*t
     <         56*t61*t62-1.1725275763095164d+0*t138*t148*t158*t260*t56*
     =         t61*t62+2.345055152619033d-1*t135*t138*t143*t255*t56*t61*
     >         t62+2.345055152619033d-1*t135*t138*t143*t186*t56*t61*t62+
     ?         2.345055152619033d-1*t135*t138*t148*t170*t56*t61*t62-7.03
     @         5165457857099d-1*t135*t143*t184*t186*t264*t61*t62+t581+t5
     1         80+t579+t578+t577+t576+t575+t570+t569+t568+t567+t566+t565
     2         +t564+t563+t562+t561+t560+t559+t558+t557+t556+t555+t554+t
     3         553+t552+t551+t550+t549+t548+t547+t545+t544+t543+t542+t54
     4         1+t540+t539+t538+t537+t536+t535+t534+t533+t532+t531+t530+
     5         t529+t528+t527+t505+t504+t503+t391+t390+t389)+2.054531400
     6         274588d+0*t10*t12*t268*t60*t63*t66*t79+2.054531400274588d
     7         +0*t10*t12*t133*t143*t63*t66*t79-5.592891034080824d+0*t10
     8         *t15*t173*t60*t62*t66*t79-6.848438000915293d-1*t10*t12*t1
     9         5*t284*t66*t79-2.054531400274588d+0*t10*t12*t134*t139*t14
     :         3*t60*t63*t79+6.848438000915293d-1*t10*t12*t134*t15*t285*
     ;         t60*t79-1.3696876001830588d+0*t10*t12*t139*t15*t151*t177*
     <         t60*t79+6.848438000915293d-1*t10*t12*t133*t134*t15*t151*t
     =         79+6.848438000915293d-1*t10*t12*t134*t139*t15*t150*t79+1.
     >         027265700137294d+0*t10*t12*t143*t170*t60*t63*t66+1.027265
     ?         700137294d+0*t10*t12*t150*t158*t63*t66-2.796445517040412d
     @         +0*t10*t143*t15*t173*t60*t62*t66+1.398222758520206d+0*t10
     1         *t14*t150*t173*t62*t66+2.796445517040412d+0*t10*t133*t14*
     2         t173*t62*t66-3.4242190004576467d-1*t10*t12*t15*t512*t60*t
     3         66-4.109062800549176d+0*t10*t12*t135*t143*t158*t60*t66+1.
     4         7121095002288234d-1*t10*t12*t14*(t575+t570+t569+t568+t567
     5         +t566+t565+t564+t563+t562+t561+t560+t559+t558+t557+t556+t
     6         555+t554+t553+t552+t551+t550+t549+t548+t547+t545+t544+t54
     7         3+t542+t541+t540+t539+t538+t537+t536+t535+t534+t533+t532+
     8         t531+t530+t529+t528+t527+t391+t390+t389)*t66-6.8484380009
     9         15293d-1*t10*t12*t133*t15*t268*t66-3.4242190004576467d-1*
     :         t10*t12*t143*t15*t259*t66-3.4242190004576467d-1*t10*t12*t
     ;         15*t150*t170*t66-1.027265700137294d+0*t10*t12*t134*t151*t
     <         158*t60*t63-1.398222758520206d+0*t10*t134*t14*t151*t173*t
     =         60*t62-2.796445517040412d+0*t10*t134*t139*t14*t173*t60*t6
     >         2-1.027265700137294d+0*t10*t12*t14*t151*t178*t381*t60+6.8
     ?         48438000915293d-1*t10*t12*t139*t14*t177*t285*t60+6.848438
     @         000915293d-1*t10*t12*t134*t139*t15*t268*t60+3.42421900045
     1         76467d-1*t10*t12*t14*t151*t177*t265*t60+3.424219000457646
     2         7d-1*t10*t12*t134*t143*t15*t265*t60-6.848438000915293d-1*
     3         t10*t12*t143*t15*t177*t178*t60+3.4242190004576467d-1*t10*
     4         t12*t134*t15*t151*t170*t60+t526+t525+t524+t523+t522+t521+
     5         t520+t519+t518+t517+t516+t380+t378+t376-3.424219000457646
     6         7d-1*t10*t12*t133*t134*t14*t285-3.4242190004576467d-1*t10
     7         *t12*t134*t139*t14*t284-1.7121095002288234d-1*t10*t12*t13
     8         4*t14*t150*t265-1.7121095002288234d-1*t10*t12*t134*t14*t1
     9         51*t259+3.4242190004576467d-1*t10*t12*t14*t150*t177*t178+
     :         6.848438000915293d-1*t10*t12*t133*t139*t14*t151*t177+6.84
     ;         8438000915293d-1*t10*t12*t133*t134*t139*t143*t15)*t9*wght
     <         +2.473556743557577d-2*t266*t9*wght+2.9682680922690924d-1*
     =         t1*t140*t143*t79*t8*wght+1.4841340461345462d-1*t1*t152*t1
     >         58*t8*wght+1.4841340461345462d-1*t1*t13*t286*t79*wght+1.4
     ?         841340461345462d-1*t13*t140*t79*wght+1.4841340461345462d-
     @         1*t1*t13*t140*t268*wght+7.420670230672731d-2*t1*t13*t143*
     1         t266*wght+7.420670230672731d-2*t1*t13*t152*t170*wght+t515
     2         +t514+t513)+t171*(-4.947113487115154d-2*t1*t140*t286*t9*w
     3         ght-7.420670230672731d-2*t1*t13*t143*t172*wght+t507-t152*
     4         t267)+4.947113487115154d-2*t1*t152*t172*t374*t9*wght+2.96
     5         82680922690924d-1*t1*t268*t68*t79*t8*wght+1.4841340461345
     6         462d-1*t1*t143*t170*t68*t8*wght+1.4841340461345462d-1*t15
     7         8*t68*t8*wght+7.420670230672731d-2*t1*t13*t512*t68*wght+7
     8         .420670230672731d-2*t13*t170*t68*wght+1.4841340461345462d
     9         -1*t1*t143*t158*t68*wght+t509+t508+Amat3(iq,D3_RA_RA_RB)
            Amat3(iq,D3_RA_RB_RB) = t81*(2.473556743557577d-2*t1*(-2.396
     1         953300320353d+0*t10*t288*t60*t63*t66*t82*t83+7.9898443344
     2         01176d-1*t10*t15*t293*t60*t66*t82*t83-3.994922167200588d-
     3         1*t10*t14*t309*t66*t82*t83+1.5979688668802353d+0*t10*t143
     4         *t15*t150*t66*t82*t83+3.994922167200588d-1*t10*t134*t14*t
     5         310*t60*t82*t83-7.989844334401176d-1*t10*t14*t177*t295*t6
     6         0*t82*t83-1.5979688668802353d+0*t10*t134*t143*t15*t151*t6
     7         0*t82*t83+7.989844334401176d-1*t10*t134*t14*t150*t151*t82
     8         *t83+1.3316407224001967d-1*t10*t15*t175*t60*t66*t79*t83+2
     9         .6632814448003933d-1*t10*t143*t15*t175*t60*t66*t83-1.3316
     :         407224001967d-1*t10*t14*t150*t175*t66*t83-6.6582036120009
     ;         84d-2*t10*t133*t14*t175*t66*t83+1.3316407224001967d-1*t10
     <         *t134*t14*t151*t175*t60*t83+6.658203612000984d-2*t10*t134
     =         *t139*t14*t175*t60*t83-1.7121095002288234d-1*t10*t12*t134
     >         *t14*t60*(-5.471795356111077d+0*t136*t143*t260*t61*t64*t7
     ?         9*t82+5.471795356111078d-1*t135*t136*t293*t61*t64*t82-2.7
     @         35897678055539d+0*t136*t260*t288*t61*t64*t82+2.7358976780
     1         55539d-1*t136*t138*t305*t56*t61*t63*t82+2.735897678055539
     2         d-1*t136*t138*t299*t56*t61*t63*t82-8.207693034166617d-1*t
     3         136*t184*t264*t299*t61*t63*t82-2.188718142444431d+0*t135*
     4         t136*t138*t143*t148*t56*t61*t82-3.5175827289285494d+0*t28
     5         8*t501*t61*t62*t64*t79+5.862637881547582d-1*t260*t293*t61
     6         *t62*t64*t79-3.191880624398129d+0*t135*t173*t261*t61*t64*
     7         t79+9.119658926851801d-2*t135*t136*t175*t61*t64*t79+2.345
     8         055152619033d-1*t135*t138*t305*t56*t61*t62*t79+2.34505515
     9         2619033d-1*t135*t138*t299*t56*t61*t62*t79-2.3450551526190
     :         327d+0*t138*t143*t148*t260*t56*t61*t62*t79-7.035165457857
     ;         099d-1*t135*t184*t264*t299*t61*t62*t79-1.1725275763095165
     <         d-1*t135*t582*t61*t62*t64+1.1725275763095164d+0*t143*t260
     =         *t268*t61*t62*t64-6.383761248796258d+0*t135*t143*t173*t26
     >         1*t61*t64+1.8239317853703602d-1*t135*t136*t143*t175*t61*t
     ?         64-5.862637881547582d-2*t138*t56*t61*t619*t62*t63-5.86263
     @         7881547582d-2*t131*t138*t305*t56*t61*t62*t63-5.8626378815
     1         47582d-2*t131*t138*t299*t56*t61*t62*t63-1.172527576309516
     2         5d-1*t138*t148*t276*t56*t61*t62*t63+1.7587913644642747d-1
     3         *t131*t148*t184*t264*t546*t61*t62*t63-7.035165457857099d-
     4         1*t131*t299*t396*t506*t61*t62*t63+1.7587913644642747d-1*t
     5         131*t184*t264*t305*t61*t62*t63+1.7587913644642747d-1*t131
     6         *t184*t264*t299*t61*t62*t63+3.5175827289285494d-1*t148*t1
     7         84*t264*t276*t61*t62*t63-3.191880624398129d+0*t138*t148*t
     8         173*t261*t56*t61*t63-1.5959403121990645d+0*t131*t138*t173
     9         *t261*t56*t61*t63+9.119658926851801d-2*t136*t138*t148*t17
     :         5*t56*t61*t63+4.5598294634259007d-2*t131*t136*t138*t175*t
     ;         56*t61*t63+t620+2.345055152619033d-1*t131*t135*t138*t293*
     <         t56*t61*t62-1.1725275763095164d+0*t131*t138*t260*t288*t56
     =         *t61*t62+4.690110305238066d-1*t135*t138*t143*t276*t56*t61
     >         *t62+4.690110305238066d-1*t135*t138*t148*t268*t56*t61*t62
     ?         +4.690110305238066d-1*t131*t135*t138*t143*t148*t56*t61*t6
     @         2-1.4070330915714196d+0*t131*t135*t143*t148*t184*t264*t61
     1         *t62+t618+t617+t616+t615+t614+t613+t612+t611+t610+t609+t6
     2         08+t607+t606+t605+t604+t603+t602+t601+t600+t599+t598+t597
     3         +t596+t595+t594+t593+t592+t591+t590+t589+t588+t587+t586+t
     4         585+t584+t583+t581+t580+t579+t578+t577+t576+t570+t568+t56
     5         1+t554+t549+t532+t530+t505+t504+t503+t391+t390+t389)+1.02
     6         7265700137294d+0*t10*t12*t293*t60*t63*t66*t79+2.054531400
     7         274588d+0*t10*t12*t143*t150*t63*t66*t79-2.796445517040412
     8         d+0*t10*t15*t173*t60*t62*t66*t79-4.109062800549176d+0*t10
     9         *t12*t135*t288*t60*t66*t79-3.4242190004576467d-1*t10*t12*
     :         t15*t309*t66*t79-2.054531400274588d+0*t10*t12*t134*t143*t
     ;         151*t60*t63*t79+3.4242190004576467d-1*t10*t12*t134*t15*t3
     <         10*t60*t79-6.848438000915293d-1*t10*t12*t15*t177*t295*t60
     =         *t79+6.848438000915293d-1*t10*t12*t134*t15*t150*t151*t79+
     >         2.054531400274588d+0*t10*t12*t143*t268*t60*t63*t66+1.0272
     ?         65700137294d+0*t10*t12*t133*t288*t63*t66+1.71210950022882
     @         34d-1*t10*t12*t14*(t620+t618+t617+t616+t615+t614+t613+t61
     1         2+t611+t610+t609+t608+t607+t606+t605+t604+t603+t602+t601+
     2         t600+t599+t598+t597+t596+t595+t594+t593+t592+t591+t590+t5
     3         89+t588+t587+t586+t585+t584+t583+t570+t568+t561+t554+t549
     4         +t532+t530+t391+t390+t389)*t66-5.592891034080824d+0*t10*t
     5         143*t15*t173*t60*t62*t66+2.796445517040412d+0*t10*t14*t15
     6         0*t173*t62*t66+1.398222758520206d+0*t10*t133*t14*t173*t62
     7         *t66-3.4242190004576467d-1*t10*t12*t15*t582*t60*t66-3.424
     8         2190004576467d-1*t10*t12*t133*t15*t293*t66-6.848438000915
     9         293d-1*t10*t12*t143*t15*t284*t66-6.848438000915293d-1*t10
     :         *t12*t15*t150*t268*t66-1.027265700137294d+0*t10*t12*t134*
     ;         t139*t288*t60*t63-2.796445517040412d+0*t10*t134*t14*t151*
     <         t173*t60*t62-1.398222758520206d+0*t10*t134*t139*t14*t173*
     =         t60*t62-1.027265700137294d+0*t10*t12*t139*t14*t295*t381*t
     >         60+3.4242190004576467d-1*t10*t12*t139*t14*t177*t310*t60+3
     ?         .4242190004576467d-1*t10*t12*t134*t139*t15*t293*t60+6.848
     @         438000915293d-1*t10*t12*t14*t151*t177*t285*t60+6.84843800
     1         0915293d-1*t10*t12*t134*t143*t15*t285*t60+6.8484380009152
     2         93d-1*t10*t12*t134*t15*t151*t268*t60-1.3696876001830588d+
     3         0*t10*t12*t139*t143*t15*t151*t177*t60+t526+t525+t524+t523
     4         +t522+t521+t520+t519+t518+t517+t516+t380+t378+t376-1.7121
     5         095002288234d-1*t10*t12*t133*t134*t14*t310-1.712109500228
     6         8234d-1*t10*t12*t134*t139*t14*t309+3.4242190004576467d-1*
     7         t10*t12*t133*t14*t177*t295-3.4242190004576467d-1*t10*t12*
     8         t134*t14*t150*t285-3.4242190004576467d-1*t10*t12*t134*t14
     9         *t151*t284+6.848438000915293d-1*t10*t12*t139*t14*t150*t15
     :         1*t177+6.848438000915293d-1*t10*t12*t133*t134*t143*t15*t1
     ;         51+6.848438000915293d-1*t10*t12*t134*t139*t143*t15*t150)*
     <         t9*wght+2.473556743557577d-2*t311*t9*wght+2.9682680922690
     =         924d-1*t1*t143*t152*t79*t8*wght+1.4841340461345462d-1*t1*
     >         t140*t288*t8*wght+7.420670230672731d-2*t1*t13*t311*t79*wg
     ?         ht+7.420670230672731d-2*t1*t13*t140*t293*wght+1.484134046
     @         1345462d-1*t1*t13*t143*t286*wght+1.4841340461345462d-1*t1
     1         *t13*t152*t268*wght+1.4841340461345462d-1*t13*t143*t152*w
     2         ght+t515+t514+t513)+t171*(-2.473556743557577d-2*t1*t140*t
     3         311*t9*wght-2.473556743557577d-2*t1*t152*t286*t9*wght-2.4
     4         73556743557577d-2*t140*t152*t9*wght-7.420670230672731d-2*
     5         t1*t13*t140*t143*t152*wght-t152*t287)+4.947113487115154d-
     6         2*t1*t140*t294*t374*t9*wght+1.4841340461345462d-1*t1*t293
     7         *t68*t79*t8*wght+1.4841340461345462d-1*t288*t68*t8*wght+2
     8         .9682680922690924d-1*t1*t143*t268*t68*t8*wght+1.484134046
     9         1345462d-1*t1*t288*t68*t79*wght+7.420670230672731d-2*t1*t
     :         13*t582*t68*wght+7.420670230672731d-2*t13*t293*t68*wght+t
     ;         509+t508+Amat3(iq,D3_RA_RB_RB)
            Amat3(iq,D3_RB_RB_RB) = t81*(2.473556743557577d-2*t1*(-7.190
     1         859900961059d+0*t10*t288*t60*t63*t66*t82*t83+2.3969533003
     2         20353d+0*t10*t15*t293*t60*t66*t82*t83-1.1984766501601765d
     3         +0*t10*t14*t309*t66*t82*t83+4.793906600640706d+0*t10*t143
     4         *t15*t150*t66*t82*t83+1.1984766501601765d+0*t10*t134*t14*
     5         t310*t60*t82*t83-2.396953300320353d+0*t10*t14*t177*t295*t
     6         60*t82*t83-4.793906600640706d+0*t10*t134*t143*t15*t151*t6
     7         0*t82*t83+2.396953300320353d+0*t10*t134*t14*t150*t151*t82
     8         *t83+3.9949221672005897d-1*t10*t143*t15*t175*t60*t66*t83-
     9         1.9974610836002948d-1*t10*t14*t150*t175*t66*t83+1.9974610
     :         836002948d-1*t10*t134*t14*t151*t175*t60*t83-1.71210950022
     ;         88234d-1*t10*t12*t134*t14*t60*(1.6415386068333232d+0*t135
     <         *t136*t293*t61*t64*t82-8.207693034166617d+0*t136*t260*t28
     =         8*t61*t64*t82+8.207693034166617d-1*t136*t138*t305*t56*t61
     >         *t63*t82+8.207693034166617d-1*t136*t138*t299*t56*t61*t63*
     ?         t82-2.4623079102499848d+0*t136*t184*t264*t299*t61*t63*t82
     @         -6.566154427333293d+0*t135*t136*t138*t143*t148*t56*t61*t8
     1         2+t653-5.862637881547582d-2*t138*t56*t61*t62*t63*t652+t65
     2         1+t650+t649+t648+t647+t646+t645+t644+t643+t642+t641+t640-
     3         1.1725275763095165d-1*t135*t61*t62*t626*t64-3.51758272892
     4         85494d+0*t501*t61*t62*t621*t64+1.7587913644642747d+0*t143
     5         *t260*t293*t61*t62*t64-9.575641873194387d+0*t135*t143*t17
     6         3*t261*t61*t64+2.73589767805554d-1*t135*t136*t143*t175*t6
     7         1*t64+t639-5.862637881547582d-2*t138*t56*t61*t62*t63*t638
     8         -7.035165457857099d-1*t396*t506*t61*t62*t63*t638+1.758791
     9         3644642747d-1*t184*t264*t61*t62*t63*t638+t637+t636+t635+t
     :         634+t633+t632+t631+t630-1.7587913644642747d-1*t138*t148*t
     ;         305*t56*t61*t62*t63+1.7587913644642747d-1*t184*t264*t299*
     <         t546*t61*t62*t63+5.276374093392824d-1*t148*t184*t264*t305
     =         *t61*t62*t63-4.7878209365971935d+0*t138*t148*t173*t261*t5
     >         6*t61*t63+1.36794883902777d-1*t136*t138*t148*t175*t56*t61
     ?         *t63+t629+t628+t627+7.035165457857099d-1*t135*t138*t143*t
     @         305*t56*t61*t62+7.035165457857099d-1*t135*t138*t143*t299*
     1         t56*t61*t62+7.035165457857099d-1*t135*t138*t148*t293*t56*
     2         t61*t62-3.5175827289285494d+0*t138*t148*t260*t288*t56*t61
     3         *t62-2.1105496373571295d+0*t135*t143*t184*t264*t299*t61*t
     4         62+t505+t504+t503+t391+t390+t389)+1.7121095002288234d-1*t
     5         10*t12*t14*(t653+t651+t650+t649+t648+t647+t646+t645+t644+
     6         t643+t642+t641+t640+t639+t637+t636+t635+t634+t633+t632+t6
     7         31+t630+t629+t628+t627+t391+t390+t389)*t66+3.081797100411
     8         882d+0*t10*t12*t143*t293*t60*t63*t66+3.081797100411882d+0
     9         *t10*t12*t150*t288*t63*t66-3.4242190004576467d-1*t10*t12*
     :         t15*t60*t626*t66-4.109062800549176d+0*t10*t12*t135*t60*t6
     ;         21*t66-8.389336551121236d+0*t10*t143*t15*t173*t60*t62*t66
     <         +4.194668275560618d+0*t10*t14*t150*t173*t62*t66-1.0272657
     =         00137294d+0*t10*t12*t143*t15*t309*t66-1.027265700137294d+
     >         0*t10*t12*t15*t150*t293*t66-3.081797100411882d+0*t10*t12*
     ?         t134*t151*t288*t60*t63-4.194668275560618d+0*t10*t134*t14*
     @         t151*t173*t60*t62-1.027265700137294d+0*t10*t12*t14*t151**
     1         3*t381*t60+1.027265700137294d+0*t10*t12*t14*t151*t177*t31
     2         0*t60+1.027265700137294d+0*t10*t12*t134*t143*t15*t310*t60
     3         -2.054531400274588d+0*t10*t12*t143*t15*t177*t295*t60+1.02
     4         7265700137294d+0*t10*t12*t134*t15*t151*t293*t60+t380+t378
     5         +t376-5.13632850068647d-1*t10*t12*t134*t14*t150*t310-5.13
     6         632850068647d-1*t10*t12*t134*t14*t151*t309+1.027265700137
     7         294d+0*t10*t12*t14*t150*t177*t295+2.054531400274588d+0*t1
     8         0*t12*t134*t143*t15*t150*t151)*t9*wght+7.420670230672731d
     9         -2*t311*t9*wght+4.4524021384036383d-1*t1*t152*t288*t8*wgh
     :         t+2.2262010692018191d-1*t1*t13*t143*t311*wght+2.226201069
     ;         2018191d-1*t1*t13*t152*t293*wght+4.4524021384036383d-1*t1
     <         3*t143*t152*wght)+t171*(-4.947113487115154d-2*t1*t152*t31
     =         1*t9*wght-2.473556743557577d-2*t294*t9*wght-7.42067023067
     >         2731d-2*t1*t13*t143*t294*wght-t152*t312)+4.94711348711515
     ?         4d-2*t1*t152**3*t374*t9*wght+4.4524021384036383d-1*t1*t14
     @         3*t293*t68*t8*wght+4.4524021384036383d-1*t288*t68*t8*wght
     1         +7.420670230672731d-2*t1*t13*t626*t68*wght+1.484134046134
     2         5462d-1*t1*t621*t68*wght+2.2262010692018191d-1*t13*t293*t
     3         68*wght+Amat3(iq,D3_RB_RB_RB)
            Cmat3(iq,D3_RA_RA_GAA) = t679+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = t81*(2.473556743557577d-2*t1*(3.195
     1         9377337604705d+0*t15*t60*t66*t79*t82*t83-1.59796886688023
     2         53d+0*t10*t134*t15*t156*t60*t79*t82*t83-7.989844334401176
     3         d-1*t10*t14*t333*t66*t82*t83-1.5979688668802353d+0*t133*t
     4         14*t66*t82*t83+7.989844334401176d-1*t10*t134*t14*t335*t60
     5         *t82*t83-1.5979688668802353d+0*t10*t139*t14*t156*t177*t60
     6         *t82*t83+1.5979688668802353d+0*t134*t139*t14*t60*t82*t83+
     7         7.989844334401176d-1*t10*t133*t134*t14*t156*t82*t83-1.712
     8         1095002288234d-1*t10*t12*t134*t14*t60*(4.377436284888862d
     9         +0*t10*t135*t136*t64*t79*t82+2.188718142444431d+0*t10*t13
     :         1*t136*t138*t56*t63*t82+1.8760441220952265d+0*t10*t131*t1
     ;         35*t138*t56*t62*t79+t697+t696+t695+t694+t693+t692+t691+t6
     <         90+t689+t688+t687+t686+2.3450551526190327d+0*t10*t158*t26
     =         0*t62*t64-4.690110305238066d-1*t10*t135*t170*t62*t64-2.34
     >         5055152619033d-1*t10*t138*t255*t56*t62*t63-2.345055152619
     ?         033d-1*t10*t138*t186*t56*t62*t63+7.035165457857099d-1*t10
     @         *t184*t186*t264*t62*t63)+5.471795356111078d-1*t10*t135*t1
     1         36*t58*t66*t79*t82+2.735897678055539d-1*t10*t134*t136*t13
     2         9*t58*t63*t82-6.848438000915293d-1*t10*t12*t15*t333*t66*t
     3         79-1.3696876001830588d+0*t12*t133*t15*t66*t79+2.345055152
     4         619033d-1*t10*t134*t135*t139*t58*t62*t79+6.84843800091529
     5         3d-1*t10*t12*t134*t15*t335*t60*t79-1.3696876001830588d+0*
     6         t10*t12*t139*t15*t156*t177*t60*t79+1.3696876001830588d+0*
     7         t12*t134*t139*t15*t60*t79+6.848438000915293d-1*t10*t12*t1
     8         33*t134*t15*t156*t79+1.7121095002288234d-1*t10*t12*t14*t6
     9         6*(t695+t694+t693+t692+t691+t690+t689+t688+t687+t686)+t68
     :         5+t684+t683+t682+t681+t680+2.054531400274588d+0*t12*t158*
     ;         t60*t63*t66+3.5175827289285494d-1*t10*t158*t260*t58*t62*t
     <         66-1.1725275763095165d-1*t10*t135*t170*t58*t62*t66-6.8484
     =         38000915293d-1*t12*t15*t170*t60*t66+3.4242190004576467d-1
     >         *t12*t14*t259*t66-5.862637881547582d-2*t10*t134*t265*t58*
     ?         t62*t63+1.1725275763095165d-1*t10*t177*t178*t58*t62*t63-1
     @         .027265700137294d+0*t10*t12*t134*t156*t158*t60*t63-1.0272
     1         65700137294d+0*t10*t12*t14*t156*t178*t381*t60+6.848438000
     2         915293d-1*t10*t12*t139*t14*t177*t335*t60+3.42421900045764
     3         67d-1*t10*t12*t14*t156*t177*t265*t60-3.4242190004576467d-
     4         1*t12*t134*t14*t265*t60+6.848438000915293d-1*t12*t14*t177
     5         *t178*t60+3.4242190004576467d-1*t10*t12*t134*t15*t156*t17
     6         0*t60-3.4242190004576467d-1*t10*t12*t133*t134*t14*t335-3.
     7         4242190004576467d-1*t10*t12*t134*t139*t14*t333-1.71210950
     8         02288234d-1*t10*t12*t134*t14*t156*t259+6.848438000915293d
     9         -1*t10*t12*t133*t139*t14*t156*t177-6.848438000915293d-1*t
     :         12*t133*t134*t139*t14)*t9*wght+4.947113487115154d-2*t336*
     ;         t9*wght+1.4841340461345462d-1*t1*t157*t158*t8*wght+1.4841
     <         340461345462d-1*t1*t13*t336*t79*wght+1.4841340461345462d-
     =         1*t13*t157*t79*wght+7.420670230672731d-2*t1*t13*t157*t170
     >         *wght)+t171*(-4.947113487115154d-2*t1*t140*t336*t9*wght-t
     ?         157*t267)+4.947113487115154d-2*t1*t157*t172*t374*t9*wght+
     @         Cmat3(iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = t679+Cmat3(iq,D3_RA_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = t709+Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = t81*(2.473556743557577d-2*t1*(-7.98
     1         9844334401176d-1*t10*t134*t15*t156*t60*t79*t82*t83-3.9949
     2         22167200588d-1*t10*t14*t347*t66*t82*t83-3.994922167200588
     3         d-1*t10*t14*t333*t66*t82*t83+3.994922167200588d-1*t10*t13
     4         4*t14*t348*t60*t82*t83+3.994922167200588d-1*t10*t134*t14*
     5         t335*t60*t82*t83-7.989844334401176d-1*t10*t14*t151*t156*t
     6         177*t60*t82*t83-7.989844334401176d-1*t10*t139*t14*t156*t1
     7         77*t60*t82*t83-7.989844334401176d-1*t10*t134*t143*t15*t15
     8         6*t60*t82*t83+3.994922167200588d-1*t10*t134*t14*t150*t156
     9         *t82*t83+3.994922167200588d-1*t10*t133*t134*t14*t156*t82*
     :         t83-1.7121095002288234d-1*t10*t12*t134*t14*t60*(2.3450551
     ;         526190327d+0*t10*t143*t260*t62*t64*t79+9.380220610476132d
     <         -1*t10*t135*t138*t148*t56*t62*t79+t725+t724+t723+t722+t72
     =         1+t720+t719+t718+t717+t716+t715+t697+t696+t690+t689+t675+
     >         t672+t671+t664-4.690110305238066d-1*t10*t135*t268*t62*t64
     ?         -2.345055152619033d-1*t10*t138*t276*t56*t62*t63-2.3450551
     @         52619033d-1*t10*t131*t138*t148*t56*t62*t63+7.035165457857
     1         099d-1*t10*t131*t148*t184*t264*t62*t63+9.380220610476132d
     2         -1*t10*t131*t135*t138*t143*t56*t62)+2.054531400274588d+0*
     3         t12*t143*t60*t63*t66*t79+3.5175827289285494d-1*t10*t143*t
     4         260*t58*t62*t66*t79-3.4242190004576467d-1*t10*t12*t15*t34
     5         7*t66*t79-6.848438000915293d-1*t12*t15*t150*t66*t79-1.027
     6         265700137294d+0*t10*t12*t134*t143*t156*t60*t63*t79+1.1725
     7         275763095165d-1*t10*t134*t135*t151*t58*t62*t79+3.42421900
     8         04576467d-1*t10*t12*t134*t15*t348*t60*t79-6.8484380009152
     9         93d-1*t10*t12*t15*t151*t156*t177*t60*t79+6.84843800091529
     :         3d-1*t12*t134*t15*t151*t60*t79+3.4242190004576467d-1*t10*
     ;         t12*t134*t15*t150*t156*t79+1.7121095002288234d-1*t10*t12*
     <         t14*t66*(t723+t722+t721+t720+t719+t718+t717+t716+t715+t69
     =         0+t689+t671+t664)+t714+t713+t712+t711+t710+t685+t684+t683
     >         +t682+t681+t680+t678+t677+t676-1.1725275763095165d-1*t10*
     ?         t135*t268*t58*t62*t66-6.848438000915293d-1*t12*t15*t268*t
     @         60*t66-3.4242190004576467d-1*t10*t12*t143*t15*t333*t66+3.
     1         4242190004576467d-1*t12*t14*t284*t66-6.848438000915293d-1
     2         *t12*t133*t143*t15*t66+t659+t656-5.862637881547582d-2*t10
     3         *t134*t285*t58*t62*t63+1.1725275763095165d-1*t10*t139*t15
     4         1*t177*t58*t62*t63+1.1725275763095165d-1*t10*t134*t135*t1
     5         39*t143*t58*t62-1.027265700137294d+0*t10*t12*t139*t14*t15
     6         1*t156*t381*t60+3.4242190004576467d-1*t10*t12*t139*t14*t1
     7         77*t348*t60+3.4242190004576467d-1*t10*t12*t14*t151*t177*t
     8         335*t60+3.4242190004576467d-1*t10*t12*t134*t143*t15*t335*
     9         t60+3.4242190004576467d-1*t10*t12*t14*t156*t177*t285*t60-
     :         3.4242190004576467d-1*t12*t134*t14*t285*t60+3.42421900045
     ;         76467d-1*t10*t12*t134*t15*t156*t268*t60-6.848438000915293
     <         d-1*t10*t12*t139*t143*t15*t156*t177*t60+6.848438000915293
     =         d-1*t12*t139*t14*t151*t177*t60+6.848438000915293d-1*t12*t
     >         134*t139*t143*t15*t60-1.7121095002288234d-1*t10*t12*t133*
     ?         t134*t14*t348-1.7121095002288234d-1*t10*t12*t134*t139*t14
     @         *t347-1.7121095002288234d-1*t10*t12*t134*t14*t150*t335-1.
     1         7121095002288234d-1*t10*t12*t134*t14*t151*t333-1.71210950
     2         02288234d-1*t10*t12*t134*t14*t156*t284+3.4242190004576467
     3         d-1*t10*t12*t133*t14*t151*t156*t177+3.4242190004576467d-1
     4         *t10*t12*t139*t14*t150*t156*t177+3.4242190004576467d-1*t1
     5         0*t12*t133*t134*t143*t15*t156-3.4242190004576467d-1*t12*t
     6         133*t134*t14*t151-3.4242190004576467d-1*t12*t134*t139*t14
     7         *t150)*t9*wght+2.473556743557577d-2*t349*t9*wght+2.473556
     8         743557577d-2*t336*t9*wght+1.4841340461345462d-1*t1*t143*t
     9         157*t79*t8*wght+7.420670230672731d-2*t1*t13*t349*t79*wght
     :         +7.420670230672731d-2*t13*t157*t79*wght+7.420670230672731
     ;         d-2*t1*t13*t143*t336*wght+7.420670230672731d-2*t1*t13*t15
     <         7*t268*wght+7.420670230672731d-2*t13*t143*t157*wght)+t171
     =         *(-2.473556743557577d-2*t1*t140*t349*t9*wght-2.4735567435
     >         57577d-2*t1*t152*t336*t9*wght-t157*t287)+4.94711348711515
     ?         4d-2*t1*t140*t152*t157*t374*t9*wght+Cmat3(iq,D3_RA_RB_GAB
     @         )
            Cmat3(iq,D3_RA_RB_GBB) = t709+Cmat3(iq,D3_RA_RB_GBB)
            Cmat3(iq,D3_RB_RB_GAA) = t732+Cmat3(iq,D3_RB_RB_GAA)
            Cmat3(iq,D3_RB_RB_GAB) = t81*(2.473556743557577d-2*t1*(3.195
     1         9377337604705d+0*t143*t15*t60*t66*t82*t83-7.9898443344011
     2         76d-1*t10*t14*t347*t66*t82*t83-1.5979688668802353d+0*t14*
     3         t150*t66*t82*t83+7.989844334401176d-1*t10*t134*t14*t348*t
     4         60*t82*t83-1.5979688668802353d+0*t10*t14*t151*t156*t177*t
     5         60*t82*t83-1.5979688668802353d+0*t10*t134*t143*t15*t156*t
     6         60*t82*t83+1.5979688668802353d+0*t134*t14*t151*t60*t82*t8
     7         3+7.989844334401176d-1*t10*t134*t14*t150*t156*t82*t83-1.7
     8         121095002288234d-1*t10*t12*t134*t14*t60*(4.37743628488886
     9         2d+0*t10*t135*t136*t143*t64*t82+2.188718142444431d+0*t10*
     :         t136*t138*t148*t56*t63*t82+t740+t739+t738+t737+t736+t735+
     ;         t734+t733+t697+t696+t690+t689-4.690110305238066d-1*t10*t1
     <         35*t293*t62*t64+2.3450551526190327d+0*t10*t260*t288*t62*t
     =         64-2.345055152619033d-1*t10*t138*t305*t56*t62*t63-2.34505
     >         5152619033d-1*t10*t138*t299*t56*t62*t63+7.035165457857099
     ?         d-1*t10*t184*t264*t299*t62*t63+1.8760441220952265d+0*t10*
     @         t135*t138*t143*t148*t56*t62)+5.471795356111078d-1*t10*t13
     1         5*t136*t143*t58*t66*t82+2.735897678055539d-1*t10*t134*t13
     2         6*t151*t58*t63*t82+1.7121095002288234d-1*t10*t12*t14*t66*
     3         (t740+t739+t738+t737+t736+t735+t734+t733+t690+t689)+t685+
     4         t684+t683+t682+t681+t680+2.054531400274588d+0*t12*t288*t6
     5         0*t63*t66-1.1725275763095165d-1*t10*t135*t293*t58*t62*t66
     6         +3.5175827289285494d-1*t10*t260*t288*t58*t62*t66-6.848438
     7         000915293d-1*t12*t15*t293*t60*t66-6.848438000915293d-1*t1
     8         0*t12*t143*t15*t347*t66+3.4242190004576467d-1*t12*t14*t30
     9         9*t66-1.3696876001830588d+0*t12*t143*t15*t150*t66-5.86263
     :         7881547582d-2*t10*t134*t310*t58*t62*t63+1.172527576309516
     ;         5d-1*t10*t177*t295*t58*t62*t63-1.027265700137294d+0*t10*t
     <         12*t134*t156*t288*t60*t63+2.345055152619033d-1*t10*t134*t
     =         135*t143*t151*t58*t62-1.027265700137294d+0*t10*t12*t14*t1
     >         56*t295*t381*t60+6.848438000915293d-1*t10*t12*t14*t151*t1
     ?         77*t348*t60+6.848438000915293d-1*t10*t12*t134*t143*t15*t3
     @         48*t60+3.4242190004576467d-1*t10*t12*t14*t156*t177*t310*t
     1         60-3.4242190004576467d-1*t12*t134*t14*t310*t60+6.84843800
     2         0915293d-1*t12*t14*t177*t295*t60+3.4242190004576467d-1*t1
     3         0*t12*t134*t15*t156*t293*t60-1.3696876001830588d+0*t10*t1
     4         2*t143*t15*t151*t156*t177*t60+1.3696876001830588d+0*t12*t
     5         134*t143*t15*t151*t60-3.4242190004576467d-1*t10*t12*t134*
     6         t14*t150*t348-3.4242190004576467d-1*t10*t12*t134*t14*t151
     7         *t347-1.7121095002288234d-1*t10*t12*t134*t14*t156*t309+6.
     8         848438000915293d-1*t10*t12*t14*t150*t151*t156*t177+6.8484
     9         38000915293d-1*t10*t12*t134*t143*t15*t150*t156-6.84843800
     :         0915293d-1*t12*t134*t14*t150*t151)*t9*wght+4.947113487115
     ;         154d-2*t349*t9*wght+1.4841340461345462d-1*t1*t157*t288*t8
     <         *wght+1.4841340461345462d-1*t1*t13*t143*t349*wght+7.42067
     =         0230672731d-2*t1*t13*t157*t293*wght+1.4841340461345462d-1
     >         *t13*t143*t157*wght)+t171*(-4.947113487115154d-2*t1*t152*
     ?         t349*t9*wght-t157*t312)+4.947113487115154d-2*t1*t157*t294
     @         *t374*t9*wght+Cmat3(iq,D3_RB_RB_GAB)
            Cmat3(iq,D3_RB_RB_GBB) = t732+Cmat3(iq,D3_RB_RB_GBB)
            Cmat3(iq,D3_RA_GAA_GAA) = t756+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = t171*(-2.473556743557577d-2*t1*t15
     1         4*t336*t9*wght+t766-t157*t324)+t765+t757+Cmat3(iq,D3_RA_G
     2         AA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = t756+Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = t81*(2.473556743557577d-2*t1*(-1.7
     1         121095002288234d-1*t10*t12*t134*t14*t60*(-9.3802206104761
     2         32d-1*t135*t62*t64*t79+t773-4.690110305238066d-1*t131*t13
     3         8*t56*t62*t63)-4.690110305238066d-1*t135*t58*t62*t66*t79+
     4         8.0299824107192d-2*t10*t134*t261*t501*t60*t64*t79+2.34505
     5         5152619033d-1*t10*t134*t135*t156*t58*t62*t79-6.8484380009
     6         15293d-1*t10*t12*t15*t177*t360*t60*t79+1.3696876001830588
     7         d+0*t12*t134*t15*t156*t60*t79+t772+t771+t770+t769+t768+6.
     8         848438000915293d-1*t12*t14*t333*t66+8.0299824107192d-2*t1
     9         0*t139*t177*t260*t261*t60*t64-4.0149912053596d-2*t10*t133
     :         *t134*t260*t261*t64-1.1725275763095165d-1*t10*t134*t335*t
     ;         58*t62*t63+2.345055152619033d-1*t10*t139*t156*t177*t58*t6
     <         2*t63-2.345055152619033d-1*t134*t139*t58*t62*t63-1.027265
     =         700137294d+0*t10*t12*t139*t14*t360*t381*t60+6.84843800091
     >         5293d-1*t10*t12*t14*t156*t177*t335*t60-6.848438000915293d
     ?         -1*t12*t134*t14*t335*t60+1.3696876001830588d+0*t12*t139*t
     @         14*t156*t177*t60+3.4242190004576467d-1*t10*t12*t133*t14*t
     1         177*t360-3.4242190004576467d-1*t10*t12*t134*t14*t156*t333
     2         -6.848438000915293d-1*t12*t133*t134*t14*t156)*t9*wght+7.4
     3         20670230672731d-2*t1*t13*t361*t79*wght+t767)+t171*(-2.473
     4         556743557577d-2*t1*t140*t361*t9*wght-2.473556743557577d-2
     5         *t1*t157*t336*t9*wght-t157*t337)+4.947113487115154d-2*t1*
     6         t140*t359*t374*t9*wght+Cmat3(iq,D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = t171*(-2.473556743557577d-2*t1*t15
     1         7*t323*t9*wght+t766-t154*t337)+t765+t757+Cmat3(iq,D3_RA_G
     2         AB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = t756+Cmat3(iq,D3_RA_GBB_GBB)
            Cmat3(iq,D3_RB_GAA_GAA) = t782+Cmat3(iq,D3_RB_GAA_GAA)
            Cmat3(iq,D3_RB_GAA_GAB) = t171*(-2.473556743557577d-2*t1*t15
     1         4*t349*t9*wght+t785-t157*t343)+t784+t783+Cmat3(iq,D3_RB_G
     2         AA_GAB)
            Cmat3(iq,D3_RB_GAA_GBB) = t782+Cmat3(iq,D3_RB_GAA_GBB)
            Cmat3(iq,D3_RB_GAB_GAB) = t81*(2.473556743557577d-2*t1*(-1.7
     1         121095002288234d-1*t10*t12*t134*t14*t60*(t773-9.380220610
     2         476132d-1*t135*t143*t62*t64-4.690110305238066d-1*t138*t14
     3         8*t56*t62*t63)+t772+t771+t770+t769+t768-4.690110305238066
     4         d-1*t135*t143*t58*t62*t66+6.848438000915293d-1*t12*t14*t3
     5         47*t66+8.0299824107192d-2*t10*t134*t143*t261*t501*t60*t64
     6         +8.0299824107192d-2*t10*t151*t177*t260*t261*t60*t64-4.014
     7         9912053596d-2*t10*t134*t150*t260*t261*t64-1.1725275763095
     8         165d-1*t10*t134*t348*t58*t62*t63+2.345055152619033d-1*t10
     9         *t151*t156*t177*t58*t62*t63-2.345055152619033d-1*t134*t15
     :         1*t58*t62*t63+2.345055152619033d-1*t10*t134*t135*t143*t15
     ;         6*t58*t62-1.027265700137294d+0*t10*t12*t14*t151*t360*t381
     <         *t60-6.848438000915293d-1*t10*t12*t143*t15*t177*t360*t60+
     =         6.848438000915293d-1*t10*t12*t14*t156*t177*t348*t60-6.848
     >         438000915293d-1*t12*t134*t14*t348*t60+1.3696876001830588d
     ?         +0*t12*t14*t151*t156*t177*t60+1.3696876001830588d+0*t12*t
     @         134*t143*t15*t156*t60+3.4242190004576467d-1*t10*t12*t14*t
     1         150*t177*t360-3.4242190004576467d-1*t10*t12*t134*t14*t156
     2         *t347-6.848438000915293d-1*t12*t134*t14*t150*t156)*t9*wgh
     3         t+7.420670230672731d-2*t1*t13*t143*t361*wght+t767)+t171*(
     4         -2.473556743557577d-2*t1*t152*t361*t9*wght-2.473556743557
     5         577d-2*t1*t157*t349*t9*wght-t157*t350)+4.947113487115154d
     6         -2*t1*t152*t359*t374*t9*wght+Cmat3(iq,D3_RB_GAB_GAB)
            Cmat3(iq,D3_RB_GAB_GBB) = t171*(-2.473556743557577d-2*t1*t15
     1         7*t342*t9*wght+t785-t154*t350)+t784+t783+Cmat3(iq,D3_RB_G
     2         AB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = t782+Cmat3(iq,D3_RB_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = t788+Cmat3(iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = t791+Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = t788+Cmat3(iq,D3_GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = t792+Cmat3(iq,D3_GAA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = t791+Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAA_GBB_GBB) = t788+Cmat3(iq,D3_GAA_GBB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = 2.473556743557577d-2*t1*(-4.12446
     1         2751618807d-2*t10*t134*t138*t786*t787+2.40899472321576d-1
     2         *t10*t156*t177*t260*t261*t60*t64-2.40899472321576d-1*t134
     3         *t260*t261*t60*t64+3.5175827289285494d-1*t10*t177*t360*t5
     4         8*t62*t63-7.035165457857099d-1*t134*t156*t58*t62*t63-1.02
     5         7265700137294d+0*t10*t12*t14*t156**3*t381*t60+2.054531400
     6         274588d+0*t12*t14*t177*t360*t60)*t81*t9*wght+4.9471134871
     7         15154d-2*t1*t157**3*t374*t9*wght-7.420670230672731d-2*t1*
     8         t157*t171*t361*t9*wght+Cmat3(iq,D3_GAB_GAB_GAB)
            Cmat3(iq,D3_GAB_GAB_GBB) = t792+Cmat3(iq,D3_GAB_GAB_GBB)
            Cmat3(iq,D3_GAB_GBB_GBB) = t791+Cmat3(iq,D3_GAB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = t788+Cmat3(iq,D3_GBB_GBB_GBB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**1.1666666666666667d+0
            t2 = 1/t1**2.0d+0
            t3 = rhoa**3.333333333333333d-1
            t4 = t3**5.0d-1
            t5 = 1/t4
            t6 = 1/t3
            t7 = 6.203504908994001d-1*t6
            t8 = t7+2.935818660072219d+0*t5+1.29352d+1
            t9 = abs(t8)
            t10 = 1/t9
            t11 = abs(t6)
            t12 = log(6.203504908994001d-1*t10*t11)
            t13 = 7.876233178997433d-1*t5
            t14 = t13+1.0498d-1
            t15 = t14**2
            t16 = log(1.0d+0*t10*t15)
            t17 = 1.5752466357994865d+0*t5
            t18 = t17+3.72744d+0
            t19 = atan(6.15199081975908d+0/t18)
            t20 = t7+8.908571061768626d-1*t5+1.30045d+1
            t21 = abs(t20)
            t22 = 1/t21
            t23 = log(6.203504908994001d-1*t11*t22)
            t24 = t13+4.7584000000000004d-3
            t25 = t24**2
            t26 = log(1.0d+0*t22*t25)
            t27 = t17+1.13107d+0
            t28 = atan(7.123108917818117d+0/t27)
            t29 = t7+5.560951426165704d+0*t5+1.8057800000000002d+1
            t30 = abs(t29)
            t31 = 1/t30
            t32 = t13+3.25d-1
            t33 = t32**2
            t34 = t17+7.06042d+0
            t35 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(5.
     1         249139316978092d-2*atan(4.7309269095601136d+0/t34)+2.2478
     2         670955426108d-3*log(1.0d+0*t31*t33)+1.554535d-2*log(6.203
     3         504908994001d-1*t11*t31)-3.8783294878113006d-2*t19-9.6902
     4         27711544375d-4*t16-3.10907d-2*t12)+5.365091848883603d-3*t
     5         28+6.991732350764465d-6*t26+1.688686394038963d-2*t23)-5.3
     6         65091848883603d-3*t28-6.991732350764465d-6*t26-1.68868639
     7         4038963d-2*t23)+3.8783294878113006d-2*t19+9.6902277115443
     8         75d-4*t16+3.10907d-2*t12
            t36 = exp(-8.085523023512742d+1*t35)
            t37 = t36-1.0d+0
            t38 = 1/t37
            t39 = 2.7178044217479824d-1*gammaaa*t2*t38
            t40 = t39+1.0d+0
            t41 = gammaaa**2.0d+0
            t42 = 1/t1**4.0d+0
            t43 = 1/t37**2.0d+0
            t44 = 7.386460874872887d-2*t41*t42*t43+t39+1.0d+0
            t45 = 1/t44
            t46 = 2.7178044217479824d-1*gammaaa*t2*t40*t45+1.0d+0
            t47 = log(t46)
            t48 = 1/t46
            t49 = rhoa**1.6666666666666674d-1
            t50 = 1/t1**3.0d+0
            t51 = -6.341543650745293d-1*gammaaa*t38*t49*t50
            t52 = 1/t11
            t53 = -2.067834969664667d-1/rhoa**1.3333333333333333d+0
            t54 = 1/t4**3
            t55 = 1/rhoa**6.666666666666667d-1
            t56 = t53-4.8930311001203647d-1*t54*t55
            t57 = 1/t8
            t58 = 1/rhoa**1.6666666666666666d+0
            t59 = -2.067834969664667d-1*t10*t52*t58-6.203504908994001d-1
     1         *t10*t11*t56*t57
            t60 = 1/t18**2
            t61 = 3.784699104639999d+1*t60+1
            t62 = 1/t61
            t63 = 1/t15
            t64 = -1.0d+0*t10*t15*t56*t57-2.625411059665811d-1*t10*t14*t
     1         54*t55
            t65 = t53-1.4847618436281043d-1*t54*t55
            t66 = 1/t20
            t67 = -6.203504908994001d-1*t11*t22*t65*t66-2.06783496966466
     1         7d-1*t22*t52*t58
            t68 = 1/t27**2
            t69 = 5.07386806551d+1*t68+1
            t70 = 1/t69
            t71 = 1/t25
            t72 = -1.0d+0*t22*t25*t65*t66-2.625411059665811d-1*t22*t24*t
     1         54*t55
            t73 = t53-9.26825237694284d-1*t54*t55
            t74 = 1/t29
            t75 = -6.203504908994001d-1*t11*t31*t73*t74-2.06783496966466
     1         7d-1*t31*t52*t58
            t76 = 1/t34**2
            t77 = 2.238166942360001d+1*t76+1
            t78 = 1/t77
            t79 = 1/t33
            t80 = -1.0d+0*t31*t33*t73*t74-2.625411059665811d-1*t31*t32*t
     1         54*t55
            t81 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-9
     1         .690227711544375d-4*t63*t64*t9-5.011795824473985d-2*t52*t
     2         59*t9+2.2478670955426108d-3*t30*t79*t80+6.519760588836059
     3         d-2*t54*t55*t76*t78+2.5058979122369923d-2*t30*t52*t75-6.2
     4         64085709464389d-2*t54*t55*t60*t62)+6.991732350764465d-6*t
     5         21*t71*t72+1.0033305979455584d-2*t54*t55*t68*t70+2.722148
     6         880047894d-2*t21*t52*t67)-6.991732350764465d-6*t21*t71*t7
     7         2-1.0033305979455584d-2*t54*t55*t68*t70-2.722148880047894
     8         d-2*t21*t52*t67)+9.690227711544375d-4*t63*t64*t9+5.011795
     9         824473985d-2*t52*t59*t9+6.264085709464389d-2*t54*t55*t60*
     :         t62
            t82 = 1/t37**2
            t83 = 2.1974870225448048d+1*gammaaa*t2*t36*t81*t82
            t84 = t83+t51
            t85 = 1/t44**2
            t86 = 1/t1**5.0d+0
            t87 = 1/t37**3.0d+0
            t88 = 1.194467989321216d+1*t36*t41*t42*t81*t87-3.44701507494
     1         0681d-1*t41*t43*t49*t86+t83+t51
            t89 = -2.7178044217479824d-1*gammaaa*t2*t40*t85*t88+2.717804
     1         4217479824d-1*gammaaa*t2*t45*t84-6.341543650745293d-1*gam
     2         maaa*t40*t45*t49*t50
            t90 = 1.4772921749745774d-1*gammaaa*t42*t43+2.71780442174798
     1         24d-1*t2*t38
            t91 = -2.7178044217479824d-1*gammaaa*t2*t40*t85*t90+7.386460
     1         874872885d-2*gammaaa*t38*t42*t45+2.7178044217479824d-1*t2
     2         *t40*t45
            t92 = 1/t46**2
            t93 = t89**2
            t94 = rhoa**3.333333333333335d-1
            t95 = 1/rhoa**8.333333333333333d-1
            t96 = t81**2
            t97 = exp(-1.6171046047025484d+2*t35)
            t98 = 1/t37**3
            t99 = 3.553566382931297d+3*gammaaa*t2*t96*t97*t98
            t100 = 2.2195402777608525d+0*gammaaa*t38*t42*t94
            t101 = -1.0569239417908825d-1*gammaaa*t38*t50*t95
            t102 = -1.0254939438542422d+2*gammaaa*t36*t49*t50*t81*t82
            t103 = -1.7767831914656484d+3*gammaaa*t2*t36*t82*t96
            t104 = 1/t61**2
            t105 = 1/t18**5
            t106 = 1/rhoa**2.3333333333333334d+0
            t107 = 1/t18**3
            t108 = 1/rhoa**1.6666666666666669d+0
            t109 = t56**2
            t110 = 1/t8**2
            t111 = 2.7571132928862224d-1/rhoa**2.333333333333333d+0
            t112 = 1/t4**5
            t113 = 1/rhoa**1.3333333333333336d+0
            t114 = 3.262020733413577d-1*t108*t54+2.4465155500601823d-1*t
     1         112*t113+t111
            t115 = 1/rhoa**2.6666666666666666d+0
            t116 = 4.135669939329334d-1*t10*t52*t56*t57*t58-6.2035049089
     1         94001d-1*t10*t11*t114*t57+2.7571132928862224d-1*t10*t115*
     2         t52+1.2407009817988002d+0*t10*t109*t11*t110
            t117 = 1/rhoa**9.999999999999999d-1
            t118 = 1/t14**3
            t119 = 5.250822119331622d-1*t10*t14*t54*t55*t56*t57-1.0d+0*t
     1         10*t114*t15*t57+1.7502740397772074d-1*t10*t108*t14*t54+2.
     2         0d+0*t10*t109*t110*t15+1.3127055298329054d-1*t10*t112*t11
     3         3*t14+3.446391616107778d-2*t10*t106
            t120 = 1/t69**2
            t121 = 1/t27**5
            t122 = 1/t27**3
            t123 = t65**2
            t124 = 1/t20**2
            t125 = 9.89841229085403d-2*t108*t54+7.423809218140521d-2*t11
     1         2*t113+t111
            t126 = 4.135669939329334d-1*t22*t52*t58*t65*t66-6.2035049089
     1         94001d-1*t11*t125*t22*t66+2.7571132928862224d-1*t115*t22*
     2         t52+1.2407009817988002d+0*t11*t123*t124*t22
            t127 = 1/t24**3
            t128 = 5.250822119331622d-1*t22*t24*t54*t55*t65*t66-1.0d+0*t
     1         125*t22*t25*t66+1.7502740397772074d-1*t108*t22*t24*t54+2.
     2         0d+0*t123*t124*t22*t25+1.3127055298329054d-1*t112*t113*t2
     3         2*t24+3.446391616107778d-2*t106*t22
            t129 = 1/t77**2
            t130 = 1/t34**5
            t131 = 1/t34**3
            t132 = t73**2
            t133 = 1/t29**2
            t134 = 6.178834917961894d-1*t108*t54+4.63412618847142d-1*t11
     1         2*t113+t111
            t135 = 4.135669939329334d-1*t31*t52*t58*t73*t74-6.2035049089
     1         94001d-1*t11*t134*t31*t74+2.7571132928862224d-1*t115*t31*
     2         t52+1.2407009817988002d+0*t11*t132*t133*t31
            t136 = 1/t32**3
            t137 = 5.250822119331622d-1*t31*t32*t54*t55*t73*t74-1.0d+0*t
     1         134*t31*t33*t74+1.7502740397772074d-1*t108*t31*t32*t54+2.
     2         0d+0*t132*t133*t31*t33+1.3127055298329054d-1*t112*t113*t3
     3         1*t32+3.446391616107778d-2*t106*t31
            t138 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-
     1         2.544083100456872d-4*t118*t54*t55*t64*t9-9.69022771154437
     2         5d-4*t119*t63*t9-1.670598608157995d-2*t117*t52*t59*t9-5.0
     3         11795824473985d-2*t116*t52*t9+2.2478670955426108d-3*t29*t
     4         31*t73*t79*t80+5.901575133296435d-4*t136*t30*t54*t55*t80-
     5         9.690227711544375d-4*t10*t56*t63*t64*t8-5.011795824473985
     6         d-2*t10*t52*t56*t59*t8+2.2478670955426108d-3*t137*t30*t79
     7         -4.3465070592240396d-2*t108*t54*t76*t78-3.259880294418029
     8         4d-2*t112*t113*t76*t78+3.4234103112606934d-2*t106*t131*t7
     9         8+2.5058979122369923d-2*t29*t31*t52*t73*t75+8.35299304078
     :         9976d-3*t117*t30*t52*t75+4.176057139642926d-2*t108*t54*t6
     ;         0*t62+3.1320428547321943d-2*t112*t113*t60*t62-3.289159980
     <         064472d-2*t106*t107*t62+2.5058979122369923d-2*t135*t30*t5
     =         2-7.662163788798045d-1*t106*t129*t130+1.2448480831567728d
     >         +0*t104*t105*t106)+6.991732350764465d-6*t20*t22*t65*t71*t
     ?         72+1.8356171439920266d-6*t127*t21*t54*t55*t72+6.991732350
     @         764465d-6*t128*t21*t71-6.68887065297039d-3*t108*t54*t68*t
     1         70-5.016652989727792d-3*t112*t113*t68*t70+5.2683104966947
     2         6d-3*t106*t122*t70+2.722148880047894d-2*t20*t22*t52*t65*t
     3         67+9.073829600159646d-3*t117*t21*t52*t67+2.72214888004789
     4         4d-2*t126*t21*t52-2.6730712388370664d-1*t106*t120*t121)-6
     5         .991732350764465d-6*t20*t22*t65*t71*t72-1.835617143992026
     6         6d-6*t127*t21*t54*t55*t72-6.991732350764465d-6*t128*t21*t
     7         71+6.68887065297039d-3*t108*t54*t68*t70+5.016652989727792
     8         d-3*t112*t113*t68*t70-5.26831049669476d-3*t106*t122*t70-2
     9         .722148880047894d-2*t20*t22*t52*t65*t67-9.073829600159646
     :         d-3*t117*t21*t52*t67-2.722148880047894d-2*t126*t21*t52+2.
     ;         6730712388370664d-1*t106*t120*t121)+2.544083100456872d-4*
     <         t118*t54*t55*t64*t9+9.690227711544375d-4*t119*t63*t9+1.67
     =         0598608157995d-2*t117*t52*t59*t9+5.011795824473985d-2*t11
     >         6*t52*t9+9.690227711544375d-4*t10*t56*t63*t64*t8+5.011795
     ?         824473985d-2*t10*t52*t56*t59*t8-4.176057139642926d-2*t108
     @         *t54*t60*t62-3.1320428547321943d-2*t112*t113*t60*t62+3.28
     1         9159980064472d-2*t106*t107*t62-1.2448480831567728d+0*t104
     2         *t105*t106
            t139 = 2.1974870225448048d+1*gammaaa*t138*t2*t36*t82
            t140 = t99+t139+t103+t102+t101+t100
            t141 = 1/t37**4.0d+0
            t142 = 1/t1**6.0d+0
            t143 = t99+2.897369528551699d+3*t141*t41*t42*t96*t97-9.65789
     1         8428505663d+2*t36*t41*t42*t87*t96-5.745025124901137d-2*t4
     2         1*t43*t86*t95+2.0107587937153976d+0*t142*t41*t43*t94-1.11
     3         48367900331349d+2*t36*t41*t49*t81*t86*t87+1.1944679893212
     4         16d+1*t138*t36*t41*t42*t87+t139+t103+t102+t101+t100
            t144 = 1/t44**3
            t145 = t88**2
            t146 = -1.0569239417908825d-1*gammaaa*t40*t45*t50*t95+2.2195
     1         402777608525d+0*gammaaa*t40*t42*t45*t94-5.435608843495965
     2         d-1*gammaaa*t2*t84*t85*t88+1.2683087301490586d+0*gammaaa*
     3         t40*t49*t50*t85*t88-2.7178044217479824d-1*gammaaa*t143*t2
     4         *t40*t85-1.2683087301490586d+0*gammaaa*t45*t49*t50*t84+2.
     5         7178044217479824d-1*gammaaa*t140*t2*t45+5.435608843495965
     6         d-1*gammaaa*t144*t145*t2*t40
            t147 = 2.4735567435575762d-2*t89*wght+1.2367783717787881d-2*
     1         rhoa*t146*wght
            t148 = -6.341543650745293d-1*t38*t49*t50
            t149 = 2.1974870225448048d+1*t2*t36*t81*t82
            t150 = t149+t148
            t151 = 2.388935978642432d+1*gammaaa*t36*t42*t81*t87-6.894030
     1         149881362d-1*gammaaa*t43*t49*t86+t149+t148
            t152 = 5.435608843495965d-1*gammaaa*t144*t2*t40*t88*t90-2.71
     1         78044217479824d-1*gammaaa*t2*t84*t85*t90+6.34154365074529
     2         3d-1*gammaaa*t40*t49*t50*t85*t90-7.386460874872885d-2*gam
     3         maaa*t38*t42*t85*t88-2.7178044217479824d-1*t2*t40*t85*t88
     4         -1.7235075374703399d-1*gammaaa*t38*t45*t49*t86-2.71780442
     5         17479824d-1*gammaaa*t151*t2*t40*t85+2.7178044217479824d-1
     6         *t2*t45*t84-6.341543650745293d-1*t40*t45*t49*t50+2.717804
     7         4217479824d-1*gammaaa*t150*t2*t45
            t153 = 1.2367783717787881d-2*t91*wght+1.2367783717787881d-2*
     1         rhoa*t152*wght
            t154 = t91**2
            t155 = t90**2
            t156 = -1.477292174974577d-1*gammaaa*t38*t42*t85*t90-5.43560
     1         8843495965d-1*t2*t40*t85*t90-4.0149912053596004d-2*gammaa
     2         a*t142*t40*t43*t85+1.477292174974577d-1*t38*t42*t45+5.435
     3         608843495965d-1*gammaaa*t144*t155*t2*t40
            t157 = 1/t46**3
            t158 = rhoa**5.000000000000002d-1
            t159 = 1/rhoa**6.666666666666665d-1
            t160 = 1/rhoa**1.8333333333333332d+0
            t161 = t81**3
            t162 = exp(-2.4256569070538228d+2*t35)
            t163 = 8.61973284143157d+5*gammaaa*t161*t162*t2/t37**4
            t164 = -2.487496468051908d+4*gammaaa*t49*t50*t96*t97*t98
            t165 = -8.619732841431569d+5*gammaaa*t161*t2*t97*t98
            t166 = 1.0660699148793891d+4*gammaaa*t138*t2*t81*t97*t98
            t167 = -1.0357854629550646d+1*gammaaa*t158*t38*t86
            t168 = 1.1097701388804267d+0*gammaaa*t159*t38*t42
            t169 = 8.807699514924021d-2*gammaaa*t160*t38*t50
            t170 = 5.383843205234772d+2*gammaaa*t36*t42*t81*t82*t94
            t171 = -2.563734859635607d+1*gammaaa*t36*t50*t81*t82*t95
            t172 = 1.243748234025954d+4*gammaaa*t36*t49*t50*t82*t96
            t173 = -1.5382409157813634d+2*gammaaa*t138*t36*t49*t50*t82
            t174 = 1.4366221402385948d+5*gammaaa*t161*t2*t36*t82
            t175 = 1/rhoa**3.3333333333333337d+0
            t176 = 1/t61**3
            t177 = 1/t18**8
            t178 = 1/rhoa**3.0d+0
            t179 = 1/t18**6
            t180 = 1/t18**4
            t181 = 1/rhoa**2.666666666666667d+0
            t182 = 1/t14**4
            t183 = 1/t4**7
            t184 = 1/rhoa**2.0d+0
            t185 = 1/rhoa**1.9999999999999998d+0
            t186 = t56**3
            t187 = 1/t8**3
            t188 = -6.433264350067851d-1/rhoa**3.333333333333333d+0
            t189 = -5.436701222355962d-1*t181*t54+t188-2.038762958383485
     1         1d-1*t183*t184-4.893031100120365d-1*t106*t112
            t190 = 1/rhoa**3.6666666666666664d+0
            t191 = 6.203504908994001d-1*t10*t114*t52*t57*t58-1.240700981
     1         7988002d+0*t10*t109*t110*t52*t58-8.271339878658668d-1*t10
     2         *t115*t52*t56*t57-6.203504908994001d-1*t10*t11*t189*t57+3
     3         .7221029453964005d+0*t10*t11*t110*t114*t56-6.433264350067
     4         852d-1*t10*t190*t52-3.7221029453964005d+0*t10*t11*t186*t1
     5         87
            t192 = -5.250822119331622d-1*t10*t108*t14*t54*t56*t57-3.9381
     1         165894987163d-1*t10*t112*t113*t14*t56*t57-1.0339174848323
     2         335d-1*t10*t106*t56*t57+7.876233178997433d-1*t10*t114*t14
     3         *t54*t55*t57-1.0d+0*t10*t15*t189*t57+6.0d+0*t10*t110*t114
     4         *t15*t56-1.5752466357994865d+0*t10*t109*t110*t14*t54*t55-
     5         2.917123399628679d-1*t10*t14*t181*t54-6.0d+0*t10*t15*t186
     6         *t187-1.0939212748607545d-1*t10*t14*t183*t184-1.206237065
     7         6377223d-1*t10*t175-2.625411059665811d-1*t10*t106*t112*t1
     8         4
            t193 = 1/t69**3
            t194 = 1/t27**8
            t195 = 1/t27**6
            t196 = 1/t27**4
            t197 = 1/t24**4
            t198 = t65**3
            t199 = 1/t20**3
            t200 = -1.649735381809005d-1*t181*t54+t188-6.186507681783768
     1         d-2*t183*t184-1.4847618436281043d-1*t106*t112
            t201 = -8.271339878658668d-1*t115*t22*t52*t65*t66+6.20350490
     1         8994001d-1*t125*t22*t52*t58*t66-6.203504908994001d-1*t11*
     2         t200*t22*t66+3.7221029453964005d+0*t11*t124*t125*t22*t65-
     3         1.2407009817988002d+0*t123*t124*t22*t52*t58-6.43326435006
     4         7852d-1*t190*t22*t52-3.7221029453964005d+0*t11*t198*t199*
     5         t22
            t202 = -5.250822119331622d-1*t108*t22*t24*t54*t65*t66-3.9381
     1         165894987163d-1*t112*t113*t22*t24*t65*t66-1.0339174848323
     2         335d-1*t106*t22*t65*t66+7.876233178997433d-1*t125*t22*t24
     3         *t54*t55*t66-1.0d+0*t200*t22*t25*t66+6.0d+0*t124*t125*t22
     4         *t25*t65-1.5752466357994865d+0*t123*t124*t22*t24*t54*t55-
     5         2.917123399628679d-1*t181*t22*t24*t54-6.0d+0*t198*t199*t2
     6         2*t25-1.0939212748607545d-1*t183*t184*t22*t24-2.625411059
     7         665811d-1*t106*t112*t22*t24-1.2062370656377223d-1*t175*t2
     8         2
            t203 = t73**3
            t204 = 1/t29**3
            t205 = -1.0298058196603158d+0*t181*t54+t188-3.86177182372618
     1         33d-1*t183*t184-9.26825237694284d-1*t106*t112
            t206 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(1
     1         .696055400304582d-4*t108*t118*t54*t64*t9-1.00188958629725
     2         38d-4*t106*t182*t64*t9+1.272041550228436d-4*t112*t113*t11
     3         8*t64*t9-9.690227711544375d-4*t192*t63*t9-5.5686620271933
     4         16d-3*t185*t52*t59*t9+1.6705986081579946d-2*t184*t52*t59*
     5         t9-5.088166200913744d-4*t118*t119*t54*t55*t9-5.0117958244
     6         73985d-2*t191*t52*t9-3.34119721631599d-2*t116*t117*t52*t9
     7         +2.2478670955426108d-3*t134*t29*t31*t79*t80+1.18031502665
     8         92868d-3*t136*t29*t31*t54*t55*t73*t80-3.934383422197623d-
     9         4*t108*t136*t30*t54*t80+2.3241090936607786d-4*t106*t30*t8
     :         0/t32**4-2.9507875666482175d-4*t112*t113*t136*t30*t80-9.6
     ;         90227711544375d-4*t10*t114*t63*t64*t8-5.088166200913744d-
     <         4*t10*t118*t54*t55*t56*t64*t8-1.938045542308875d-3*t10*t1
     =         19*t56*t63*t8-3.34119721631599d-2*t10*t117*t52*t56*t59*t8
     >         -5.011795824473985d-2*t10*t114*t52*t59*t8-1.0023591648947
     ?         97d-1*t10*t116*t52*t56*t8+2.2478670955426108d-3*t30*(-5.2
     @         50822119331622d-1*t108*t31*t32*t54*t73*t74-3.938116589498
     1         7163d-1*t112*t113*t31*t32*t73*t74-1.0339174848323335d-1*t
     2         106*t31*t73*t74+7.876233178997433d-1*t134*t31*t32*t54*t55
     3         *t74-1.0d+0*t205*t31*t33*t74+6.0d+0*t133*t134*t31*t33*t73
     4         -1.5752466357994865d+0*t132*t133*t31*t32*t54*t55-2.917123
     5         399628679d-1*t181*t31*t32*t54-6.0d+0*t203*t204*t31*t33-1.
     6         0939212748607545d-1*t183*t184*t31*t32-2.625411059665811d-
     7         1*t106*t112*t31*t32-1.2062370656377223d-1*t175*t31)*t79+4
     8         .4957341910852217d-3*t137*t29*t31*t73*t79+7.2441784320400
     9         66d-2*t181*t54*t76*t78+2.716566912015024d-2*t183*t184*t76
     :         *t78+6.51976058883606d-2*t106*t112*t76*t78+2.696357787887
     ;         34d-2*t178*t54*t78/t34**4-1.1981936089412427d-1*t131*t175
     <         *t78+1.8009481522035156d+1*t178*t54/(t34**8*t77**3)+1.670
     =         598608157995d-2*t117*t29*t31*t52*t73*t75+2.50589791223699
     >         23d-2*t134*t29*t31*t52*t75+2.784331013596658d-3*t185*t30*
     ?         t52*t75-8.352993040789973d-3*t184*t30*t52*t75+2.505897912
     @         2369923d-2*t30*t52*(-8.271339878658668d-1*t115*t31*t52*t7
     1         3*t74+6.203504908994001d-1*t134*t31*t52*t58*t74-6.2035049
     2         08994001d-1*t11*t205*t31*t74+3.7221029453964005d+0*t11*t1
     3         33*t134*t31*t73-1.2407009817988002d+0*t132*t133*t31*t52*t
     4         58-6.433264350067852d-1*t190*t31*t52-3.7221029453964005d+
     5         0*t11*t203*t204*t31)+5.011795824473985d-2*t135*t29*t31*t5
     6         2*t73-6.96009523273821d-2*t181*t54*t60*t62-2.610035712276
     7         828d-2*t183*t184*t60*t62-6.26408570946439d-2*t106*t112*t6
     8         0*t62-2.590619096601433d-2*t178*t180*t54*t62+1.1512059930
     9         225654d-1*t107*t175*t62+1.1803150266592868d-3*t136*t137*t
     :         30*t54*t55-1.4081430686456894d+0*t129*t178*t54/t34**6+2.2
     ;         877665475865033d+0*t104*t178*t179*t54-4.947718859586276d+
     <         1*t176*t177*t178*t54+1.670598608157995d-2*t117*t135*t30*t
     =         52+2.681757326079316d+0*t129*t130*t175-4.356968291048705d
     >         +0*t104*t105*t175)+6.991732350764465d-6*t125*t20*t22*t71*
     ?         t72+3.671234287984053d-6*t127*t20*t22*t54*t55*t65*t72-1.2
     @         237447626613511d-6*t108*t127*t21*t54*t72+7.22887432672325
     1         4d-7*t106*t197*t21*t72-9.178085719960132d-7*t112*t113*t12
     2         7*t21*t72+1.3983464701528928d-5*t128*t20*t22*t65*t71+6.99
     3         1732350764465d-6*t202*t21*t71+1.114811775495065d-2*t181*t
     4         54*t68*t70+4.180544158106493d-3*t183*t184*t68*t70+1.00333
     5         05979455585d-2*t106*t112*t68*t70+4.1494441931327714d-3*t1
     6         78*t196*t54*t70-1.843908673843166d-2*t122*t175*t70+1.8147
     7         659200319294d-2*t117*t20*t22*t52*t65*t67+2.72214888004789
     8         4d-2*t125*t20*t22*t52*t67+3.024609866719882d-3*t185*t21*t
     9         52*t67-9.073829600159644d-3*t184*t21*t52*t67+5.4442977600
     :         95788d-2*t126*t20*t22*t52*t65+3.671234287984053d-6*t127*t
     ;         128*t21*t54*t55-4.9125375556021966d-1*t120*t178*t195*t54+
     <         1.424318138513631d+1*t178*t193*t194*t54+2.722148880047894
     =         d-2*t201*t21*t52+1.8147659200319294d-2*t117*t126*t21*t52+
     >         9.355749335929733d-1*t120*t121*t175)-6.991732350764465d-6
     ?         *t125*t20*t22*t71*t72-3.671234287984053d-6*t127*t20*t22*t
     @         54*t55*t65*t72+1.2237447626613511d-6*t108*t127*t21*t54*t7
     1         2-7.228874326723254d-7*t106*t197*t21*t72+9.17808571996013
     2         2d-7*t112*t113*t127*t21*t72-1.3983464701528928d-5*t128*t2
     3         0*t22*t65*t71-6.991732350764465d-6*t202*t21*t71-1.1148117
     4         75495065d-2*t181*t54*t68*t70-4.180544158106493d-3*t183*t1
     5         84*t68*t70-1.0033305979455585d-2*t106*t112*t68*t70-4.1494
     6         441931327714d-3*t178*t196*t54*t70+1.843908673843166d-2*t1
     7         22*t175*t70-1.8147659200319294d-2*t117*t20*t22*t52*t65*t6
     8         7-2.722148880047894d-2*t125*t20*t22*t52*t67-3.02460986671
     9         9882d-3*t185*t21*t52*t67+9.073829600159644d-3*t184*t21*t5
     :         2*t67-5.444297760095788d-2*t126*t20*t22*t52*t65-3.6712342
     ;         87984053d-6*t127*t128*t21*t54*t55+4.9125375556021966d-1*t
     <         120*t178*t195*t54-1.424318138513631d+1*t178*t193*t194*t54
     =         -2.722148880047894d-2*t201*t21*t52-1.8147659200319294d-2*
     >         t117*t126*t21*t52-9.355749335929733d-1*t120*t121*t175)-1.
     ?         696055400304582d-4*t108*t118*t54*t64*t9+1.001889586297253
     @         8d-4*t106*t182*t64*t9-1.272041550228436d-4*t112*t113*t118
     1         *t64*t9+9.690227711544375d-4*t192*t63*t9+5.56866202719331
     2         6d-3*t185*t52*t59*t9-1.6705986081579946d-2*t184*t52*t59*t
     3         9+5.088166200913744d-4*t118*t119*t54*t55*t9+5.01179582447
     4         3985d-2*t191*t52*t9+3.34119721631599d-2*t116*t117*t52*t9+
     5         9.690227711544375d-4*t10*t114*t63*t64*t8+5.08816620091374
     6         4d-4*t10*t118*t54*t55*t56*t64*t8+1.938045542308875d-3*t10
     7         *t119*t56*t63*t8+3.34119721631599d-2*t10*t117*t52*t56*t59
     8         *t8+5.011795824473985d-2*t10*t114*t52*t59*t8+1.0023591648
     9         94797d-1*t10*t116*t52*t56*t8+6.96009523273821d-2*t181*t54
     :         *t60*t62+2.610035712276828d-2*t183*t184*t60*t62+6.2640857
     ;         0946439d-2*t106*t112*t60*t62+2.590619096601433d-2*t178*t1
     <         80*t54*t62-1.1512059930225654d-1*t107*t175*t62-2.28776654
     =         75865033d+0*t104*t178*t179*t54+4.947718859586276d+1*t176*
     >         t177*t178*t54+4.356968291048705d+0*t104*t105*t175
            t207 = 2.1974870225448048d+1*gammaaa*t2*t206*t36*t82
            t208 = -5.330349574396945d+3*gammaaa*t138*t2*t36*t81*t82
            t209 = 1/t1**7.0d+0
            t210 = 1/t44**4
            t211 = 3.553566382931297d+3*t2*t96*t97*t98
            t212 = 2.2195402777608525d+0*t38*t42*t94
            t213 = -1.0569239417908825d-1*t38*t50*t95
            t214 = -1.0254939438542422d+2*t36*t49*t50*t81*t82
            t215 = -1.7767831914656484d+3*t2*t36*t82*t96
            t216 = 2.1974870225448048d+1*t138*t2*t36*t82
            fnc(iq) = 1.2367783717787881d-2*rhoa*t47*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.2367783717787881d-2*rhoa*t48*t89*wght+1.2
     1         367783717787881d-2*t47*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.2367783717787881d-2*rhoa*t48*t91*wght+Cm
     1         at(iq,D1_GAA)
            Amat2(iq,D2_RA_RA) = -1.2367783717787881d-2*rhoa*t92*t93*wgh
     1         t+t147*t48+Amat2(iq,D2_RA_RA)
            Cmat2(iq,D2_RA_GAA) = -1.2367783717787881d-2*rhoa*t89*t91*t9
     1         2*wght+t153*t48+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = -1.2367783717787881d-2*rhoa*t154*t92*
     1         wght+1.2367783717787881d-2*rhoa*t156*t48*wght+Cmat2(iq,D2
     2         _GAA_GAA)
            Amat3(iq,D3_RA_RA_RA) = t48*(1.2367783717787881d-2*rhoa*(-2.
     1         7178044217479824d-1*gammaaa*t2*t40*t85*(-4.05631733997237
     2         9d+4*t141*t41*t49*t86*t96*t97+8.692108585655098d+3*t138*t
     3         141*t41*t42*t81*t97-7.028024409218707d+5*t141*t161*t41*t4
     4         2*t97+1.3521057799907932d+4*t36*t41*t49*t86*t87*t96-2.787
     5         091975082838d+1*t36*t41*t81*t86*t87*t95+9.754821912789933
     6         d+2*t142*t36*t41*t81*t87*t94-1.6722551850497025d+2*t138*t
     7         36*t41*t49*t86*t87-2.897369528551699d+3*t138*t36*t41*t42*
     8         t81*t87+1.194467989321216d+1*t206*t36*t41*t42*t87+7.80891
     9         6010243008d+4*t161*t36*t41*t42*t87+4.787520937417614d-2*t
     :         160*t41*t43*t86-1.4075311556007783d+1*t158*t209*t41*t43+1
     ;         .0053793968576992d+0*t142*t159*t41*t43+9.37069921229161d+
     <         5*t161*t162*t41*t42/t37**5.0d+0+t208+t207+t174+t173+t172+
     =         t171+t170+t169+t168+t167+t166+t165+t164+t163)+3.170771825
     >         3726475d-1*gammaaa*t40*t50*t85*t88*t95-3.1707718253726475
     ?         d-1*gammaaa*t45*t50*t84*t95-6.658620833282557d+0*gammaaa*
     @         t40*t42*t85*t88*t94+6.658620833282557d+0*gammaaa*t42*t45*
     1         t84*t94-1.6306826530487895d+0*gammaaa*t2*t210*t40*t88**3+
     2         3.8049261904471754d+0*gammaaa*t49*t50*t84*t85*t88-8.15341
     3         3265243947d-1*gammaaa*t140*t2*t85*t88+1.6306826530487895d
     4         +0*gammaaa*t143*t144*t2*t40*t88-1.0357854629550646d+1*gam
     5         maaa*t158*t40*t45*t86-8.153413265243947d-1*gammaaa*t143*t
     6         2*t84*t85+1.9024630952235877d+0*gammaaa*t143*t40*t49*t50*
     7         t85+1.6306826530487895d+0*gammaaa*t144*t145*t2*t84-1.9024
     8         630952235877d+0*gammaaa*t140*t45*t49*t50-3.80492619044717
     9         54d+0*gammaaa*t144*t145*t40*t49*t50+8.807699514924021d-2*
     :         gammaaa*t160*t40*t45*t50+1.1097701388804267d+0*gammaaa*t1
     ;         59*t40*t42*t45+2.7178044217479824d-1*gammaaa*t2*(t208+t20
     <         7+t174+t173+t172+t171+t170+t169+t168+t167+t166+t165+t164+
     =         t163)*t45)*wght+3.710335115336365d-2*t146*wght)+t92*(-1.2
     >         367783717787881d-2*t93*wght-2.4735567435575762d-2*rhoa*t1
     ?         46*t89*wght-t147*t89)+2.4735567435575762d-2*rhoa*t157*t89
     @         **3*wght+Amat3(iq,D3_RA_RA_RA)
            Cmat3(iq,D3_RA_RA_GAA) = t48*(1.2367783717787881d-2*rhoa*(-2
     1         .7178044217479824d-1*gammaaa*t2*t40*t85*(5.79473905710339
     2         9d+3*gammaaa*t141*t42*t96*t97-1.9315796857011328d+3*gamma
     3         aa*t36*t42*t87*t96-1.1490050249802275d-1*gammaaa*t43*t86*
     4         t95+4.021517587430795d+0*gammaaa*t142*t43*t94-2.229673580
     5         0662698d+2*gammaaa*t36*t49*t81*t86*t87+2.388935978642432d
     6         +1*gammaaa*t138*t36*t42*t87+t216+t215+t214+t213+t212+t211
     7         )+1.0569239417908825d-1*gammaaa*t40*t50*t85*t90*t95-2.872
     8         5125624505676d-2*gammaaa*t38*t45*t86*t95-1.05692394179088
     9         25d-1*t40*t45*t50*t95-2.2195402777608525d+0*gammaaa*t40*t
     :         42*t85*t90*t94+2.2195402777608525d+0*t40*t42*t45*t94+6.03
     ;         227638114619d-1*gammaaa*t142*t38*t45*t94+1.08712176869919
     <         3d+0*gammaaa*t144*t2*t84*t88*t90-2.5366174602981173d+0*ga
     =         mmaaa*t144*t40*t49*t50*t88*t90+1.2683087301490586d+0*gamm
     >         aaa*t49*t50*t84*t85*t90-2.7178044217479824d-1*gammaaa*t14
     ?         0*t2*t85*t90-1.6306826530487895d+0*gammaaa*t145*t2*t210*t
     @         40*t90+5.435608843495965d-1*gammaaa*t143*t144*t2*t40*t90+
     1         3.4470150749406797d-1*gammaaa*t38*t49*t85*t86*t88-5.43560
     2         8843495965d-1*t2*t84*t85*t88+1.2683087301490586d+0*t40*t4
     3         9*t50*t85*t88-5.435608843495965d-1*gammaaa*t150*t2*t85*t8
     4         8+1.087121768699193d+0*gammaaa*t144*t151*t2*t40*t88-5.435
     5         608843495965d-1*gammaaa*t151*t2*t84*t85+1.268308730149058
     6         6d+0*gammaaa*t151*t40*t49*t50*t85-7.386460874872885d-2*ga
     7         mmaaa*t143*t38*t42*t85-2.7178044217479824d-1*t143*t2*t40*
     8         t85-1.2683087301490586d+0*t45*t49*t50*t84-1.2683087301490
     9         586d+0*gammaaa*t150*t45*t49*t50+2.7178044217479824d-1*gam
     :         maaa*t2*(t216+t215+t214+t213+t212+t211)*t45+2.71780442174
     ;         79824d-1*t140*t2*t45+1.477292174974577d-1*gammaaa*t144*t1
     <         45*t38*t42+5.435608843495965d-1*t144*t145*t2*t40)*wght+2.
     =         4735567435575762d-2*t152*wght)+t92*(-2.4735567435575762d-
     >         2*rhoa*t152*t89*wght-t147*t91)+2.4735567435575762d-2*rhoa
     ?         *t157*t91*t93*wght+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_GAA_GAA) = t92*(-1.2367783717787881d-2*rhoa*t
     1         152*t91*wght-1.2367783717787881d-2*rhoa*t156*t89*wght-t15
     2         3*t91)+t48*(1.2367783717787881d-2*rhoa*(2.954584349949154
     3         d-1*gammaaa*t144*t38*t42*t88*t90+1.087121768699193d+0*t14
     4         4*t2*t40*t88*t90+3.4470150749406797d-1*gammaaa*t38*t49*t8
     5         5*t86*t90-5.435608843495965d-1*t2*t84*t85*t90+1.268308730
     6         1490586d+0*t40*t49*t50*t85*t90-5.435608843495965d-1*gamma
     7         aa*t150*t2*t85*t90+1.087121768699193d+0*gammaaa*t144*t151
     8         *t2*t40*t90-1.477292174974577d-1*t38*t42*t85*t88+8.029982
     9         410719201d-2*gammaaa*t142*t144*t40*t43*t88-1.630682653048
     :         7895d+0*gammaaa*t155*t2*t210*t40*t88-2.7178044217479824d-
     ;         1*gammaaa*t2*t40*t85*(2.388935978642432d+1*t36*t42*t81*t8
     <         7-6.894030149881362d-1*t43*t49*t86)-3.4470150749406797d-1
     =         *t38*t45*t49*t86-4.0149912053596004d-2*gammaaa*t142*t43*t
     >         84*t85+9.368312812505736d-2*gammaaa*t209*t40*t43*t49*t85-
     ?         1.477292174974577d-1*gammaaa*t151*t38*t42*t85-5.435608843
     @         495965d-1*t151*t2*t40*t85+5.435608843495965d-1*gammaaa*t1
     1         44*t155*t2*t84-1.2683087301490586d+0*gammaaa*t144*t155*t4
     2         0*t49*t50+5.435608843495965d-1*t150*t2*t45)*wght+1.236778
     3         3717787881d-2*t156*wght)+2.4735567435575762d-2*rhoa*t154*
     4         t157*t89*wght+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAA) = -3.710335115336365d-2*rhoa*t156*t
     1         91*t92*wght+2.4735567435575762d-2*rhoa*t157*t91**3*wght+1
     2         .2367783717787881d-2*rhoa*t48*(-1.6306826530487895d+0*gam
     3         maaa*t2*t210*t40*t90**3-4.4318765249237313d-1*t38*t42*t85
     4         *t90+2.4089947232157605d-1*gammaaa*t142*t144*t40*t43*t90-
     5         3.273588255361676d-2*gammaaa*t85*t87/t1**8.0d+0-1.2044973
     6         616078802d-1*t142*t40*t43*t85+4.4318765249237313d-1*gamma
     7         aa*t144*t155*t38*t42+1.6306826530487895d+0*t144*t155*t2*t
     8         40)*wght+Cmat3(iq,D3_GAA_GAA_GAA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**1.1666666666666667d+0
            t2 = 1/t1**2.0d+0
            t3 = rhob**3.333333333333333d-1
            t4 = t3**5.0d-1
            t5 = 1/t4
            t6 = 1/t3
            t7 = 6.203504908994001d-1*t6
            t8 = t7+2.935818660072219d+0*t5+1.29352d+1
            t9 = abs(t8)
            t10 = 1/t9
            t11 = abs(t6)
            t12 = log(6.203504908994001d-1*t10*t11)
            t13 = 7.876233178997433d-1*t5
            t14 = t13+1.0498d-1
            t15 = t14**2
            t16 = log(1.0d+0*t10*t15)
            t17 = 1.5752466357994865d+0*t5
            t18 = t17+3.72744d+0
            t19 = atan(6.15199081975908d+0/t18)
            t20 = t7+8.908571061768626d-1*t5+1.30045d+1
            t21 = abs(t20)
            t22 = 1/t21
            t23 = log(6.203504908994001d-1*t11*t22)
            t24 = t13+4.7584000000000004d-3
            t25 = t24**2
            t26 = log(1.0d+0*t22*t25)
            t27 = t17+1.13107d+0
            t28 = atan(7.123108917818117d+0/t27)
            t29 = t7+5.560951426165704d+0*t5+1.8057800000000002d+1
            t30 = abs(t29)
            t31 = 1/t30
            t32 = t13+3.25d-1
            t33 = t32**2
            t34 = t17+7.06042d+0
            t35 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(5.
     1         249139316978092d-2*atan(4.7309269095601136d+0/t34)+2.2478
     2         670955426108d-3*log(1.0d+0*t31*t33)+1.554535d-2*log(6.203
     3         504908994001d-1*t11*t31)-3.8783294878113006d-2*t19-9.6902
     4         27711544375d-4*t16-3.10907d-2*t12)+5.365091848883603d-3*t
     5         28+6.991732350764465d-6*t26+1.688686394038963d-2*t23)-5.3
     6         65091848883603d-3*t28-6.991732350764465d-6*t26-1.68868639
     7         4038963d-2*t23)+3.8783294878113006d-2*t19+9.6902277115443
     8         75d-4*t16+3.10907d-2*t12
            t36 = exp(-8.085523023512742d+1*t35)
            t37 = t36-1.0d+0
            t38 = 1/t37
            t39 = 2.7178044217479824d-1*gammabb*t2*t38
            t40 = t39+1.0d+0
            t41 = gammabb**2.0d+0
            t42 = 1/t1**4.0d+0
            t43 = 1/t37**2.0d+0
            t44 = 7.386460874872887d-2*t41*t42*t43+t39+1.0d+0
            t45 = 1/t44
            t46 = 2.7178044217479824d-1*gammabb*t2*t40*t45+1.0d+0
            t47 = log(t46)
            t48 = 1/t46
            t49 = rhob**1.6666666666666674d-1
            t50 = 1/t1**3.0d+0
            t51 = -6.341543650745293d-1*gammabb*t38*t49*t50
            t52 = 1/t11
            t53 = -2.067834969664667d-1/rhob**1.3333333333333333d+0
            t54 = 1/t4**3
            t55 = 1/rhob**6.666666666666667d-1
            t56 = t53-4.8930311001203647d-1*t54*t55
            t57 = 1/t8
            t58 = 1/rhob**1.6666666666666666d+0
            t59 = -2.067834969664667d-1*t10*t52*t58-6.203504908994001d-1
     1         *t10*t11*t56*t57
            t60 = 1/t18**2
            t61 = 3.784699104639999d+1*t60+1
            t62 = 1/t61
            t63 = 1/t15
            t64 = -1.0d+0*t10*t15*t56*t57-2.625411059665811d-1*t10*t14*t
     1         54*t55
            t65 = t53-1.4847618436281043d-1*t54*t55
            t66 = 1/t20
            t67 = -6.203504908994001d-1*t11*t22*t65*t66-2.06783496966466
     1         7d-1*t22*t52*t58
            t68 = 1/t27**2
            t69 = 5.07386806551d+1*t68+1
            t70 = 1/t69
            t71 = 1/t25
            t72 = -1.0d+0*t22*t25*t65*t66-2.625411059665811d-1*t22*t24*t
     1         54*t55
            t73 = t53-9.26825237694284d-1*t54*t55
            t74 = 1/t29
            t75 = -6.203504908994001d-1*t11*t31*t73*t74-2.06783496966466
     1         7d-1*t31*t52*t58
            t76 = 1/t34**2
            t77 = 2.238166942360001d+1*t76+1
            t78 = 1/t77
            t79 = 1/t33
            t80 = -1.0d+0*t31*t33*t73*t74-2.625411059665811d-1*t31*t32*t
     1         54*t55
            t81 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-9
     1         .690227711544375d-4*t63*t64*t9-5.011795824473985d-2*t52*t
     2         59*t9+2.2478670955426108d-3*t30*t79*t80+6.519760588836059
     3         d-2*t54*t55*t76*t78+2.5058979122369923d-2*t30*t52*t75-6.2
     4         64085709464389d-2*t54*t55*t60*t62)+6.991732350764465d-6*t
     5         21*t71*t72+1.0033305979455584d-2*t54*t55*t68*t70+2.722148
     6         880047894d-2*t21*t52*t67)-6.991732350764465d-6*t21*t71*t7
     7         2-1.0033305979455584d-2*t54*t55*t68*t70-2.722148880047894
     8         d-2*t21*t52*t67)+9.690227711544375d-4*t63*t64*t9+5.011795
     9         824473985d-2*t52*t59*t9+6.264085709464389d-2*t54*t55*t60*
     :         t62
            t82 = 1/t37**2
            t83 = 2.1974870225448048d+1*gammabb*t2*t36*t81*t82
            t84 = t83+t51
            t85 = 1/t44**2
            t86 = 1/t1**5.0d+0
            t87 = 1/t37**3.0d+0
            t88 = 1.194467989321216d+1*t36*t41*t42*t81*t87-3.44701507494
     1         0681d-1*t41*t43*t49*t86+t83+t51
            t89 = -2.7178044217479824d-1*gammabb*t2*t40*t85*t88+2.717804
     1         4217479824d-1*gammabb*t2*t45*t84-6.341543650745293d-1*gam
     2         mabb*t40*t45*t49*t50
            t90 = 1.4772921749745774d-1*gammabb*t42*t43+2.71780442174798
     1         24d-1*t2*t38
            t91 = -2.7178044217479824d-1*gammabb*t2*t40*t85*t90+7.386460
     1         874872885d-2*gammabb*t38*t42*t45+2.7178044217479824d-1*t2
     2         *t40*t45
            t92 = 1/t46**2
            t93 = t89**2
            t94 = rhob**3.333333333333335d-1
            t95 = 1/rhob**8.333333333333333d-1
            t96 = t81**2
            t97 = exp(-1.6171046047025484d+2*t35)
            t98 = 1/t37**3
            t99 = 3.553566382931297d+3*gammabb*t2*t96*t97*t98
            t100 = 2.2195402777608525d+0*gammabb*t38*t42*t94
            t101 = -1.0569239417908825d-1*gammabb*t38*t50*t95
            t102 = -1.0254939438542422d+2*gammabb*t36*t49*t50*t81*t82
            t103 = -1.7767831914656484d+3*gammabb*t2*t36*t82*t96
            t104 = 1/t61**2
            t105 = 1/t18**5
            t106 = 1/rhob**2.3333333333333334d+0
            t107 = 1/t18**3
            t108 = 1/rhob**1.6666666666666669d+0
            t109 = t56**2
            t110 = 1/t8**2
            t111 = 2.7571132928862224d-1/rhob**2.333333333333333d+0
            t112 = 1/t4**5
            t113 = 1/rhob**1.3333333333333336d+0
            t114 = 3.262020733413577d-1*t108*t54+2.4465155500601823d-1*t
     1         112*t113+t111
            t115 = 1/rhob**2.6666666666666666d+0
            t116 = 4.135669939329334d-1*t10*t52*t56*t57*t58-6.2035049089
     1         94001d-1*t10*t11*t114*t57+2.7571132928862224d-1*t10*t115*
     2         t52+1.2407009817988002d+0*t10*t109*t11*t110
            t117 = 1/rhob**9.999999999999999d-1
            t118 = 1/t14**3
            t119 = 5.250822119331622d-1*t10*t14*t54*t55*t56*t57-1.0d+0*t
     1         10*t114*t15*t57+1.7502740397772074d-1*t10*t108*t14*t54+2.
     2         0d+0*t10*t109*t110*t15+1.3127055298329054d-1*t10*t112*t11
     3         3*t14+3.446391616107778d-2*t10*t106
            t120 = 1/t69**2
            t121 = 1/t27**5
            t122 = 1/t27**3
            t123 = t65**2
            t124 = 1/t20**2
            t125 = 9.89841229085403d-2*t108*t54+7.423809218140521d-2*t11
     1         2*t113+t111
            t126 = 4.135669939329334d-1*t22*t52*t58*t65*t66-6.2035049089
     1         94001d-1*t11*t125*t22*t66+2.7571132928862224d-1*t115*t22*
     2         t52+1.2407009817988002d+0*t11*t123*t124*t22
            t127 = 1/t24**3
            t128 = 5.250822119331622d-1*t22*t24*t54*t55*t65*t66-1.0d+0*t
     1         125*t22*t25*t66+1.7502740397772074d-1*t108*t22*t24*t54+2.
     2         0d+0*t123*t124*t22*t25+1.3127055298329054d-1*t112*t113*t2
     3         2*t24+3.446391616107778d-2*t106*t22
            t129 = 1/t77**2
            t130 = 1/t34**5
            t131 = 1/t34**3
            t132 = t73**2
            t133 = 1/t29**2
            t134 = 6.178834917961894d-1*t108*t54+4.63412618847142d-1*t11
     1         2*t113+t111
            t135 = 4.135669939329334d-1*t31*t52*t58*t73*t74-6.2035049089
     1         94001d-1*t11*t134*t31*t74+2.7571132928862224d-1*t115*t31*
     2         t52+1.2407009817988002d+0*t11*t132*t133*t31
            t136 = 1/t32**3
            t137 = 5.250822119331622d-1*t31*t32*t54*t55*t73*t74-1.0d+0*t
     1         134*t31*t33*t74+1.7502740397772074d-1*t108*t31*t32*t54+2.
     2         0d+0*t132*t133*t31*t33+1.3127055298329054d-1*t112*t113*t3
     3         1*t32+3.446391616107778d-2*t106*t31
            t138 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-
     1         2.544083100456872d-4*t118*t54*t55*t64*t9-9.69022771154437
     2         5d-4*t119*t63*t9-1.670598608157995d-2*t117*t52*t59*t9-5.0
     3         11795824473985d-2*t116*t52*t9+2.2478670955426108d-3*t29*t
     4         31*t73*t79*t80+5.901575133296435d-4*t136*t30*t54*t55*t80-
     5         9.690227711544375d-4*t10*t56*t63*t64*t8-5.011795824473985
     6         d-2*t10*t52*t56*t59*t8+2.2478670955426108d-3*t137*t30*t79
     7         -4.3465070592240396d-2*t108*t54*t76*t78-3.259880294418029
     8         4d-2*t112*t113*t76*t78+3.4234103112606934d-2*t106*t131*t7
     9         8+2.5058979122369923d-2*t29*t31*t52*t73*t75+8.35299304078
     :         9976d-3*t117*t30*t52*t75+4.176057139642926d-2*t108*t54*t6
     ;         0*t62+3.1320428547321943d-2*t112*t113*t60*t62-3.289159980
     <         064472d-2*t106*t107*t62+2.5058979122369923d-2*t135*t30*t5
     =         2-7.662163788798045d-1*t106*t129*t130+1.2448480831567728d
     >         +0*t104*t105*t106)+6.991732350764465d-6*t20*t22*t65*t71*t
     ?         72+1.8356171439920266d-6*t127*t21*t54*t55*t72+6.991732350
     @         764465d-6*t128*t21*t71-6.68887065297039d-3*t108*t54*t68*t
     1         70-5.016652989727792d-3*t112*t113*t68*t70+5.2683104966947
     2         6d-3*t106*t122*t70+2.722148880047894d-2*t20*t22*t52*t65*t
     3         67+9.073829600159646d-3*t117*t21*t52*t67+2.72214888004789
     4         4d-2*t126*t21*t52-2.6730712388370664d-1*t106*t120*t121)-6
     5         .991732350764465d-6*t20*t22*t65*t71*t72-1.835617143992026
     6         6d-6*t127*t21*t54*t55*t72-6.991732350764465d-6*t128*t21*t
     7         71+6.68887065297039d-3*t108*t54*t68*t70+5.016652989727792
     8         d-3*t112*t113*t68*t70-5.26831049669476d-3*t106*t122*t70-2
     9         .722148880047894d-2*t20*t22*t52*t65*t67-9.073829600159646
     :         d-3*t117*t21*t52*t67-2.722148880047894d-2*t126*t21*t52+2.
     ;         6730712388370664d-1*t106*t120*t121)+2.544083100456872d-4*
     <         t118*t54*t55*t64*t9+9.690227711544375d-4*t119*t63*t9+1.67
     =         0598608157995d-2*t117*t52*t59*t9+5.011795824473985d-2*t11
     >         6*t52*t9+9.690227711544375d-4*t10*t56*t63*t64*t8+5.011795
     ?         824473985d-2*t10*t52*t56*t59*t8-4.176057139642926d-2*t108
     @         *t54*t60*t62-3.1320428547321943d-2*t112*t113*t60*t62+3.28
     1         9159980064472d-2*t106*t107*t62-1.2448480831567728d+0*t104
     2         *t105*t106
            t139 = 2.1974870225448048d+1*gammabb*t138*t2*t36*t82
            t140 = t99+t139+t103+t102+t101+t100
            t141 = 1/t37**4.0d+0
            t142 = 1/t1**6.0d+0
            t143 = t99+2.897369528551699d+3*t141*t41*t42*t96*t97-9.65789
     1         8428505663d+2*t36*t41*t42*t87*t96-5.745025124901137d-2*t4
     2         1*t43*t86*t95+2.0107587937153976d+0*t142*t41*t43*t94-1.11
     3         48367900331349d+2*t36*t41*t49*t81*t86*t87+1.1944679893212
     4         16d+1*t138*t36*t41*t42*t87+t139+t103+t102+t101+t100
            t144 = 1/t44**3
            t145 = t88**2
            t146 = -1.0569239417908825d-1*gammabb*t40*t45*t50*t95+2.2195
     1         402777608525d+0*gammabb*t40*t42*t45*t94-5.435608843495965
     2         d-1*gammabb*t2*t84*t85*t88+1.2683087301490586d+0*gammabb*
     3         t40*t49*t50*t85*t88-2.7178044217479824d-1*gammabb*t143*t2
     4         *t40*t85-1.2683087301490586d+0*gammabb*t45*t49*t50*t84+2.
     5         7178044217479824d-1*gammabb*t140*t2*t45+5.435608843495965
     6         d-1*gammabb*t144*t145*t2*t40
            t147 = 2.4735567435575762d-2*t89*wght+1.2367783717787881d-2*
     1         rhob*t146*wght
            t148 = -6.341543650745293d-1*t38*t49*t50
            t149 = 2.1974870225448048d+1*t2*t36*t81*t82
            t150 = t149+t148
            t151 = 2.388935978642432d+1*gammabb*t36*t42*t81*t87-6.894030
     1         149881362d-1*gammabb*t43*t49*t86+t149+t148
            t152 = 5.435608843495965d-1*gammabb*t144*t2*t40*t88*t90-2.71
     1         78044217479824d-1*gammabb*t2*t84*t85*t90+6.34154365074529
     2         3d-1*gammabb*t40*t49*t50*t85*t90-7.386460874872885d-2*gam
     3         mabb*t38*t42*t85*t88-2.7178044217479824d-1*t2*t40*t85*t88
     4         -1.7235075374703399d-1*gammabb*t38*t45*t49*t86-2.71780442
     5         17479824d-1*gammabb*t151*t2*t40*t85+2.7178044217479824d-1
     6         *t2*t45*t84-6.341543650745293d-1*t40*t45*t49*t50+2.717804
     7         4217479824d-1*gammabb*t150*t2*t45
            t153 = 1.2367783717787881d-2*t91*wght+1.2367783717787881d-2*
     1         rhob*t152*wght
            t154 = t91**2
            t155 = t90**2
            t156 = -1.477292174974577d-1*gammabb*t38*t42*t85*t90-5.43560
     1         8843495965d-1*t2*t40*t85*t90-4.0149912053596004d-2*gammab
     2         b*t142*t40*t43*t85+1.477292174974577d-1*t38*t42*t45+5.435
     3         608843495965d-1*gammabb*t144*t155*t2*t40
            t157 = 1/t46**3
            t158 = rhob**5.000000000000002d-1
            t159 = 1/rhob**6.666666666666665d-1
            t160 = 1/rhob**1.8333333333333332d+0
            t161 = t81**3
            t162 = exp(-2.4256569070538228d+2*t35)
            t163 = 8.61973284143157d+5*gammabb*t161*t162*t2/t37**4
            t164 = -2.487496468051908d+4*gammabb*t49*t50*t96*t97*t98
            t165 = -8.619732841431569d+5*gammabb*t161*t2*t97*t98
            t166 = 1.0660699148793891d+4*gammabb*t138*t2*t81*t97*t98
            t167 = -1.0357854629550646d+1*gammabb*t158*t38*t86
            t168 = 1.1097701388804267d+0*gammabb*t159*t38*t42
            t169 = 8.807699514924021d-2*gammabb*t160*t38*t50
            t170 = 5.383843205234772d+2*gammabb*t36*t42*t81*t82*t94
            t171 = -2.563734859635607d+1*gammabb*t36*t50*t81*t82*t95
            t172 = 1.243748234025954d+4*gammabb*t36*t49*t50*t82*t96
            t173 = -1.5382409157813634d+2*gammabb*t138*t36*t49*t50*t82
            t174 = 1.4366221402385948d+5*gammabb*t161*t2*t36*t82
            t175 = 1/rhob**3.3333333333333337d+0
            t176 = 1/t61**3
            t177 = 1/t18**8
            t178 = 1/rhob**3.0d+0
            t179 = 1/t18**6
            t180 = 1/t18**4
            t181 = 1/rhob**2.666666666666667d+0
            t182 = 1/t14**4
            t183 = 1/t4**7
            t184 = 1/rhob**2.0d+0
            t185 = 1/rhob**1.9999999999999998d+0
            t186 = t56**3
            t187 = 1/t8**3
            t188 = -6.433264350067851d-1/rhob**3.333333333333333d+0
            t189 = -5.436701222355962d-1*t181*t54+t188-2.038762958383485
     1         1d-1*t183*t184-4.893031100120365d-1*t106*t112
            t190 = 1/rhob**3.6666666666666664d+0
            t191 = 6.203504908994001d-1*t10*t114*t52*t57*t58-1.240700981
     1         7988002d+0*t10*t109*t110*t52*t58-8.271339878658668d-1*t10
     2         *t115*t52*t56*t57-6.203504908994001d-1*t10*t11*t189*t57+3
     3         .7221029453964005d+0*t10*t11*t110*t114*t56-6.433264350067
     4         852d-1*t10*t190*t52-3.7221029453964005d+0*t10*t11*t186*t1
     5         87
            t192 = -5.250822119331622d-1*t10*t108*t14*t54*t56*t57-3.9381
     1         165894987163d-1*t10*t112*t113*t14*t56*t57-1.0339174848323
     2         335d-1*t10*t106*t56*t57+7.876233178997433d-1*t10*t114*t14
     3         *t54*t55*t57-1.0d+0*t10*t15*t189*t57+6.0d+0*t10*t110*t114
     4         *t15*t56-1.5752466357994865d+0*t10*t109*t110*t14*t54*t55-
     5         2.917123399628679d-1*t10*t14*t181*t54-6.0d+0*t10*t15*t186
     6         *t187-1.0939212748607545d-1*t10*t14*t183*t184-1.206237065
     7         6377223d-1*t10*t175-2.625411059665811d-1*t10*t106*t112*t1
     8         4
            t193 = 1/t69**3
            t194 = 1/t27**8
            t195 = 1/t27**6
            t196 = 1/t27**4
            t197 = 1/t24**4
            t198 = t65**3
            t199 = 1/t20**3
            t200 = -1.649735381809005d-1*t181*t54+t188-6.186507681783768
     1         d-2*t183*t184-1.4847618436281043d-1*t106*t112
            t201 = -8.271339878658668d-1*t115*t22*t52*t65*t66+6.20350490
     1         8994001d-1*t125*t22*t52*t58*t66-6.203504908994001d-1*t11*
     2         t200*t22*t66+3.7221029453964005d+0*t11*t124*t125*t22*t65-
     3         1.2407009817988002d+0*t123*t124*t22*t52*t58-6.43326435006
     4         7852d-1*t190*t22*t52-3.7221029453964005d+0*t11*t198*t199*
     5         t22
            t202 = -5.250822119331622d-1*t108*t22*t24*t54*t65*t66-3.9381
     1         165894987163d-1*t112*t113*t22*t24*t65*t66-1.0339174848323
     2         335d-1*t106*t22*t65*t66+7.876233178997433d-1*t125*t22*t24
     3         *t54*t55*t66-1.0d+0*t200*t22*t25*t66+6.0d+0*t124*t125*t22
     4         *t25*t65-1.5752466357994865d+0*t123*t124*t22*t24*t54*t55-
     5         2.917123399628679d-1*t181*t22*t24*t54-6.0d+0*t198*t199*t2
     6         2*t25-1.0939212748607545d-1*t183*t184*t22*t24-2.625411059
     7         665811d-1*t106*t112*t22*t24-1.2062370656377223d-1*t175*t2
     8         2
            t203 = t73**3
            t204 = 1/t29**3
            t205 = -1.0298058196603158d+0*t181*t54+t188-3.86177182372618
     1         33d-1*t183*t184-9.26825237694284d-1*t106*t112
            t206 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(1
     1         .696055400304582d-4*t108*t118*t54*t64*t9-1.00188958629725
     2         38d-4*t106*t182*t64*t9+1.272041550228436d-4*t112*t113*t11
     3         8*t64*t9-9.690227711544375d-4*t192*t63*t9-5.5686620271933
     4         16d-3*t185*t52*t59*t9+1.6705986081579946d-2*t184*t52*t59*
     5         t9-5.088166200913744d-4*t118*t119*t54*t55*t9-5.0117958244
     6         73985d-2*t191*t52*t9-3.34119721631599d-2*t116*t117*t52*t9
     7         +2.2478670955426108d-3*t134*t29*t31*t79*t80+1.18031502665
     8         92868d-3*t136*t29*t31*t54*t55*t73*t80-3.934383422197623d-
     9         4*t108*t136*t30*t54*t80+2.3241090936607786d-4*t106*t30*t8
     :         0/t32**4-2.9507875666482175d-4*t112*t113*t136*t30*t80-9.6
     ;         90227711544375d-4*t10*t114*t63*t64*t8-5.088166200913744d-
     <         4*t10*t118*t54*t55*t56*t64*t8-1.938045542308875d-3*t10*t1
     =         19*t56*t63*t8-3.34119721631599d-2*t10*t117*t52*t56*t59*t8
     >         -5.011795824473985d-2*t10*t114*t52*t59*t8-1.0023591648947
     ?         97d-1*t10*t116*t52*t56*t8+2.2478670955426108d-3*t30*(-5.2
     @         50822119331622d-1*t108*t31*t32*t54*t73*t74-3.938116589498
     1         7163d-1*t112*t113*t31*t32*t73*t74-1.0339174848323335d-1*t
     2         106*t31*t73*t74+7.876233178997433d-1*t134*t31*t32*t54*t55
     3         *t74-1.0d+0*t205*t31*t33*t74+6.0d+0*t133*t134*t31*t33*t73
     4         -1.5752466357994865d+0*t132*t133*t31*t32*t54*t55-2.917123
     5         399628679d-1*t181*t31*t32*t54-6.0d+0*t203*t204*t31*t33-1.
     6         0939212748607545d-1*t183*t184*t31*t32-2.625411059665811d-
     7         1*t106*t112*t31*t32-1.2062370656377223d-1*t175*t31)*t79+4
     8         .4957341910852217d-3*t137*t29*t31*t73*t79+7.2441784320400
     9         66d-2*t181*t54*t76*t78+2.716566912015024d-2*t183*t184*t76
     :         *t78+6.51976058883606d-2*t106*t112*t76*t78+2.696357787887
     ;         34d-2*t178*t54*t78/t34**4-1.1981936089412427d-1*t131*t175
     <         *t78+1.8009481522035156d+1*t178*t54/(t34**8*t77**3)+1.670
     =         598608157995d-2*t117*t29*t31*t52*t73*t75+2.50589791223699
     >         23d-2*t134*t29*t31*t52*t75+2.784331013596658d-3*t185*t30*
     ?         t52*t75-8.352993040789973d-3*t184*t30*t52*t75+2.505897912
     @         2369923d-2*t30*t52*(-8.271339878658668d-1*t115*t31*t52*t7
     1         3*t74+6.203504908994001d-1*t134*t31*t52*t58*t74-6.2035049
     2         08994001d-1*t11*t205*t31*t74+3.7221029453964005d+0*t11*t1
     3         33*t134*t31*t73-1.2407009817988002d+0*t132*t133*t31*t52*t
     4         58-6.433264350067852d-1*t190*t31*t52-3.7221029453964005d+
     5         0*t11*t203*t204*t31)+5.011795824473985d-2*t135*t29*t31*t5
     6         2*t73-6.96009523273821d-2*t181*t54*t60*t62-2.610035712276
     7         828d-2*t183*t184*t60*t62-6.26408570946439d-2*t106*t112*t6
     8         0*t62-2.590619096601433d-2*t178*t180*t54*t62+1.1512059930
     9         225654d-1*t107*t175*t62+1.1803150266592868d-3*t136*t137*t
     :         30*t54*t55-1.4081430686456894d+0*t129*t178*t54/t34**6+2.2
     ;         877665475865033d+0*t104*t178*t179*t54-4.947718859586276d+
     <         1*t176*t177*t178*t54+1.670598608157995d-2*t117*t135*t30*t
     =         52+2.681757326079316d+0*t129*t130*t175-4.356968291048705d
     >         +0*t104*t105*t175)+6.991732350764465d-6*t125*t20*t22*t71*
     ?         t72+3.671234287984053d-6*t127*t20*t22*t54*t55*t65*t72-1.2
     @         237447626613511d-6*t108*t127*t21*t54*t72+7.22887432672325
     1         4d-7*t106*t197*t21*t72-9.178085719960132d-7*t112*t113*t12
     2         7*t21*t72+1.3983464701528928d-5*t128*t20*t22*t65*t71+6.99
     3         1732350764465d-6*t202*t21*t71+1.114811775495065d-2*t181*t
     4         54*t68*t70+4.180544158106493d-3*t183*t184*t68*t70+1.00333
     5         05979455585d-2*t106*t112*t68*t70+4.1494441931327714d-3*t1
     6         78*t196*t54*t70-1.843908673843166d-2*t122*t175*t70+1.8147
     7         659200319294d-2*t117*t20*t22*t52*t65*t67+2.72214888004789
     8         4d-2*t125*t20*t22*t52*t67+3.024609866719882d-3*t185*t21*t
     9         52*t67-9.073829600159644d-3*t184*t21*t52*t67+5.4442977600
     :         95788d-2*t126*t20*t22*t52*t65+3.671234287984053d-6*t127*t
     ;         128*t21*t54*t55-4.9125375556021966d-1*t120*t178*t195*t54+
     <         1.424318138513631d+1*t178*t193*t194*t54+2.722148880047894
     =         d-2*t201*t21*t52+1.8147659200319294d-2*t117*t126*t21*t52+
     >         9.355749335929733d-1*t120*t121*t175)-6.991732350764465d-6
     ?         *t125*t20*t22*t71*t72-3.671234287984053d-6*t127*t20*t22*t
     @         54*t55*t65*t72+1.2237447626613511d-6*t108*t127*t21*t54*t7
     1         2-7.228874326723254d-7*t106*t197*t21*t72+9.17808571996013
     2         2d-7*t112*t113*t127*t21*t72-1.3983464701528928d-5*t128*t2
     3         0*t22*t65*t71-6.991732350764465d-6*t202*t21*t71-1.1148117
     4         75495065d-2*t181*t54*t68*t70-4.180544158106493d-3*t183*t1
     5         84*t68*t70-1.0033305979455585d-2*t106*t112*t68*t70-4.1494
     6         441931327714d-3*t178*t196*t54*t70+1.843908673843166d-2*t1
     7         22*t175*t70-1.8147659200319294d-2*t117*t20*t22*t52*t65*t6
     8         7-2.722148880047894d-2*t125*t20*t22*t52*t67-3.02460986671
     9         9882d-3*t185*t21*t52*t67+9.073829600159644d-3*t184*t21*t5
     :         2*t67-5.444297760095788d-2*t126*t20*t22*t52*t65-3.6712342
     ;         87984053d-6*t127*t128*t21*t54*t55+4.9125375556021966d-1*t
     <         120*t178*t195*t54-1.424318138513631d+1*t178*t193*t194*t54
     =         -2.722148880047894d-2*t201*t21*t52-1.8147659200319294d-2*
     >         t117*t126*t21*t52-9.355749335929733d-1*t120*t121*t175)-1.
     ?         696055400304582d-4*t108*t118*t54*t64*t9+1.001889586297253
     @         8d-4*t106*t182*t64*t9-1.272041550228436d-4*t112*t113*t118
     1         *t64*t9+9.690227711544375d-4*t192*t63*t9+5.56866202719331
     2         6d-3*t185*t52*t59*t9-1.6705986081579946d-2*t184*t52*t59*t
     3         9+5.088166200913744d-4*t118*t119*t54*t55*t9+5.01179582447
     4         3985d-2*t191*t52*t9+3.34119721631599d-2*t116*t117*t52*t9+
     5         9.690227711544375d-4*t10*t114*t63*t64*t8+5.08816620091374
     6         4d-4*t10*t118*t54*t55*t56*t64*t8+1.938045542308875d-3*t10
     7         *t119*t56*t63*t8+3.34119721631599d-2*t10*t117*t52*t56*t59
     8         *t8+5.011795824473985d-2*t10*t114*t52*t59*t8+1.0023591648
     9         94797d-1*t10*t116*t52*t56*t8+6.96009523273821d-2*t181*t54
     :         *t60*t62+2.610035712276828d-2*t183*t184*t60*t62+6.2640857
     ;         0946439d-2*t106*t112*t60*t62+2.590619096601433d-2*t178*t1
     <         80*t54*t62-1.1512059930225654d-1*t107*t175*t62-2.28776654
     =         75865033d+0*t104*t178*t179*t54+4.947718859586276d+1*t176*
     >         t177*t178*t54+4.356968291048705d+0*t104*t105*t175
            t207 = 2.1974870225448048d+1*gammabb*t2*t206*t36*t82
            t208 = -5.330349574396945d+3*gammabb*t138*t2*t36*t81*t82
            t209 = 1/t1**7.0d+0
            t210 = 1/t44**4
            t211 = 3.553566382931297d+3*t2*t96*t97*t98
            t212 = 2.2195402777608525d+0*t38*t42*t94
            t213 = -1.0569239417908825d-1*t38*t50*t95
            t214 = -1.0254939438542422d+2*t36*t49*t50*t81*t82
            t215 = -1.7767831914656484d+3*t2*t36*t82*t96
            t216 = 2.1974870225448048d+1*t138*t2*t36*t82
            fnc(iq) = 1.2367783717787881d-2*rhob*t47*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.2367783717787881d-2*rhob*t48*t89*wght+1.2
     1         367783717787881d-2*t47*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.2367783717787881d-2*rhob*t48*t91*wght+Cm
     1         at(iq,D1_GBB)
            Amat2(iq,D2_RB_RB) = -1.2367783717787881d-2*rhob*t92*t93*wgh
     1         t+t147*t48+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RB_GBB) = -1.2367783717787881d-2*rhob*t89*t91*t9
     1         2*wght+t153*t48+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = -1.2367783717787881d-2*rhob*t154*t92*
     1         wght+1.2367783717787881d-2*rhob*t156*t48*wght+Cmat2(iq,D2
     2         _GBB_GBB)
            Amat3(iq,D3_RB_RB_RB) = t48*(1.2367783717787881d-2*rhob*(-2.
     1         7178044217479824d-1*gammabb*t2*t40*t85*(-4.05631733997237
     2         9d+4*t141*t41*t49*t86*t96*t97+8.692108585655098d+3*t138*t
     3         141*t41*t42*t81*t97-7.028024409218707d+5*t141*t161*t41*t4
     4         2*t97+1.3521057799907932d+4*t36*t41*t49*t86*t87*t96-2.787
     5         091975082838d+1*t36*t41*t81*t86*t87*t95+9.754821912789933
     6         d+2*t142*t36*t41*t81*t87*t94-1.6722551850497025d+2*t138*t
     7         36*t41*t49*t86*t87-2.897369528551699d+3*t138*t36*t41*t42*
     8         t81*t87+1.194467989321216d+1*t206*t36*t41*t42*t87+7.80891
     9         6010243008d+4*t161*t36*t41*t42*t87+4.787520937417614d-2*t
     :         160*t41*t43*t86-1.4075311556007783d+1*t158*t209*t41*t43+1
     ;         .0053793968576992d+0*t142*t159*t41*t43+9.37069921229161d+
     <         5*t161*t162*t41*t42/t37**5.0d+0+t208+t207+t174+t173+t172+
     =         t171+t170+t169+t168+t167+t166+t165+t164+t163)+3.170771825
     >         3726475d-1*gammabb*t40*t50*t85*t88*t95-3.1707718253726475
     ?         d-1*gammabb*t45*t50*t84*t95-6.658620833282557d+0*gammabb*
     @         t40*t42*t85*t88*t94+6.658620833282557d+0*gammabb*t42*t45*
     1         t84*t94-1.6306826530487895d+0*gammabb*t2*t210*t40*t88**3+
     2         3.8049261904471754d+0*gammabb*t49*t50*t84*t85*t88-8.15341
     3         3265243947d-1*gammabb*t140*t2*t85*t88+1.6306826530487895d
     4         +0*gammabb*t143*t144*t2*t40*t88-1.0357854629550646d+1*gam
     5         mabb*t158*t40*t45*t86-8.153413265243947d-1*gammabb*t143*t
     6         2*t84*t85+1.9024630952235877d+0*gammabb*t143*t40*t49*t50*
     7         t85+1.6306826530487895d+0*gammabb*t144*t145*t2*t84-1.9024
     8         630952235877d+0*gammabb*t140*t45*t49*t50-3.80492619044717
     9         54d+0*gammabb*t144*t145*t40*t49*t50+8.807699514924021d-2*
     :         gammabb*t160*t40*t45*t50+1.1097701388804267d+0*gammabb*t1
     ;         59*t40*t42*t45+2.7178044217479824d-1*gammabb*t2*(t208+t20
     <         7+t174+t173+t172+t171+t170+t169+t168+t167+t166+t165+t164+
     =         t163)*t45)*wght+3.710335115336365d-2*t146*wght)+t92*(-1.2
     >         367783717787881d-2*t93*wght-2.4735567435575762d-2*rhob*t1
     ?         46*t89*wght-t147*t89)+2.4735567435575762d-2*rhob*t157*t89
     @         **3*wght+Amat3(iq,D3_RB_RB_RB)
            Cmat3(iq,D3_RB_RB_GBB) = t48*(1.2367783717787881d-2*rhob*(-2
     1         .7178044217479824d-1*gammabb*t2*t40*t85*(5.79473905710339
     2         9d+3*gammabb*t141*t42*t96*t97-1.9315796857011328d+3*gamma
     3         bb*t36*t42*t87*t96-1.1490050249802275d-1*gammabb*t43*t86*
     4         t95+4.021517587430795d+0*gammabb*t142*t43*t94-2.229673580
     5         0662698d+2*gammabb*t36*t49*t81*t86*t87+2.388935978642432d
     6         +1*gammabb*t138*t36*t42*t87+t216+t215+t214+t213+t212+t211
     7         )+1.0569239417908825d-1*gammabb*t40*t50*t85*t90*t95-2.872
     8         5125624505676d-2*gammabb*t38*t45*t86*t95-1.05692394179088
     9         25d-1*t40*t45*t50*t95-2.2195402777608525d+0*gammabb*t40*t
     :         42*t85*t90*t94+2.2195402777608525d+0*t40*t42*t45*t94+6.03
     ;         227638114619d-1*gammabb*t142*t38*t45*t94+1.08712176869919
     <         3d+0*gammabb*t144*t2*t84*t88*t90-2.5366174602981173d+0*ga
     =         mmabb*t144*t40*t49*t50*t88*t90+1.2683087301490586d+0*gamm
     >         abb*t49*t50*t84*t85*t90-2.7178044217479824d-1*gammabb*t14
     ?         0*t2*t85*t90-1.6306826530487895d+0*gammabb*t145*t2*t210*t
     @         40*t90+5.435608843495965d-1*gammabb*t143*t144*t2*t40*t90+
     1         3.4470150749406797d-1*gammabb*t38*t49*t85*t86*t88-5.43560
     2         8843495965d-1*t2*t84*t85*t88+1.2683087301490586d+0*t40*t4
     3         9*t50*t85*t88-5.435608843495965d-1*gammabb*t150*t2*t85*t8
     4         8+1.087121768699193d+0*gammabb*t144*t151*t2*t40*t88-5.435
     5         608843495965d-1*gammabb*t151*t2*t84*t85+1.268308730149058
     6         6d+0*gammabb*t151*t40*t49*t50*t85-7.386460874872885d-2*ga
     7         mmabb*t143*t38*t42*t85-2.7178044217479824d-1*t143*t2*t40*
     8         t85-1.2683087301490586d+0*t45*t49*t50*t84-1.2683087301490
     9         586d+0*gammabb*t150*t45*t49*t50+2.7178044217479824d-1*gam
     :         mabb*t2*(t216+t215+t214+t213+t212+t211)*t45+2.71780442174
     ;         79824d-1*t140*t2*t45+1.477292174974577d-1*gammabb*t144*t1
     <         45*t38*t42+5.435608843495965d-1*t144*t145*t2*t40)*wght+2.
     =         4735567435575762d-2*t152*wght)+t92*(-2.4735567435575762d-
     >         2*rhob*t152*t89*wght-t147*t91)+2.4735567435575762d-2*rhob
     ?         *t157*t91*t93*wght+Cmat3(iq,D3_RB_RB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = t92*(-1.2367783717787881d-2*rhob*t
     1         152*t91*wght-1.2367783717787881d-2*rhob*t156*t89*wght-t15
     2         3*t91)+t48*(1.2367783717787881d-2*rhob*(2.954584349949154
     3         d-1*gammabb*t144*t38*t42*t88*t90+1.087121768699193d+0*t14
     4         4*t2*t40*t88*t90+3.4470150749406797d-1*gammabb*t38*t49*t8
     5         5*t86*t90-5.435608843495965d-1*t2*t84*t85*t90+1.268308730
     6         1490586d+0*t40*t49*t50*t85*t90-5.435608843495965d-1*gamma
     7         bb*t150*t2*t85*t90+1.087121768699193d+0*gammabb*t144*t151
     8         *t2*t40*t90-1.477292174974577d-1*t38*t42*t85*t88+8.029982
     9         410719201d-2*gammabb*t142*t144*t40*t43*t88-1.630682653048
     :         7895d+0*gammabb*t155*t2*t210*t40*t88-2.7178044217479824d-
     ;         1*gammabb*t2*t40*t85*(2.388935978642432d+1*t36*t42*t81*t8
     <         7-6.894030149881362d-1*t43*t49*t86)-3.4470150749406797d-1
     =         *t38*t45*t49*t86-4.0149912053596004d-2*gammabb*t142*t43*t
     >         84*t85+9.368312812505736d-2*gammabb*t209*t40*t43*t49*t85-
     ?         1.477292174974577d-1*gammabb*t151*t38*t42*t85-5.435608843
     @         495965d-1*t151*t2*t40*t85+5.435608843495965d-1*gammabb*t1
     1         44*t155*t2*t84-1.2683087301490586d+0*gammabb*t144*t155*t4
     2         0*t49*t50+5.435608843495965d-1*t150*t2*t45)*wght+1.236778
     3         3717787881d-2*t156*wght)+2.4735567435575762d-2*rhob*t154*
     4         t157*t89*wght+Cmat3(iq,D3_RB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = -3.710335115336365d-2*rhob*t156*t
     1         91*t92*wght+2.4735567435575762d-2*rhob*t157*t91**3*wght+1
     2         .2367783717787881d-2*rhob*t48*(-1.6306826530487895d+0*gam
     3         mabb*t2*t210*t40*t90**3-4.4318765249237313d-1*t38*t42*t85
     4         *t90+2.4089947232157605d-1*gammabb*t142*t144*t40*t43*t90-
     5         3.273588255361676d-2*gammabb*t85*t87/t1**8.0d+0-1.2044973
     6         616078802d-1*t142*t40*t43*t85+4.4318765249237313d-1*gamma
     7         bb*t144*t155*t38*t42+1.6306826530487895d+0*t144*t155*t2*t
     8         40)*wght+Cmat3(iq,D3_GBB_GBB_GBB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> @} 
