!****************************************************************************************
SUBROUTINE oasis3_decomp(dim_paral, mype, npes, w_unit, nlon, nlat, il_paral)
  !**************************************************************************************
  !
  USE mod_prism_proto
  !
  IMPLICIT NONE
  !
  INTEGER, INTENT(in)     :: dim_paral,w_unit,mype,npes, nlon, nlat
  INTEGER, INTENT(out)    :: il_paral(dim_paral)
  !
#ifdef DECOMP_SERIAL
  !
  WRITE(w_unit,*) 'SERIAL = 1 partition only'
  !
  if (npes .ne. 1) then
     write(w_unit,*) ' Pb with the  decomposition npes > 1 !!!!'
     CALL flush(w_unit)
  endif
  !
  il_paral ( 1 ) = clim_serial
  il_paral ( 2 ) = 0
  il_paral ( 3 ) = nlon*nlat
  !
  WRITE(w_unit,*) 'il_paral (:) :',il_paral
  CALL flush(w_unit)
  !
#elif defined DECOMP_APPLE
  !
  WRITE(w_unit,*) 'APPLE: 1D partitioning'
  ! il_paral ( 1 ) = partition type
  il_paral ( 1 ) = clim_apple
  ! il_paral (2) the segment global offset in the total domain size
  il_paral ( 2 ) = mype*(nlat/npes)*nlon
  ! il_paral(3) the segment local size
  if (mype .lt. (npes-1)) then
     il_paral ( 3 ) = (nlat/npes)*nlon
  else
     il_paral ( 3 ) = nlon*nlat-(mype*(nlat/npes)*nlon)
     !
  endif
  !
  WRITE(w_unit,*) 'il_paral (:) :',il_paral
  CALL flush(w_unit)
  !
#elif defined DECOMP_BOX
  !
  WRITE(w_unit,*) 'BOX: 2D partitoning'
  il_paral ( 1 ) = clim_box
  ! il_paral (2) the segment global offset in the total domain size
  il_paral ( 2 ) = mype*(nlat/npes)*nlon
  ! il_paral (3) local extent in X
  il_paral ( 3 ) = nlon  
  ! il_paral(4) local extent in Y
  if (mype .lt. (npes-1)) then
     il_paral ( 4 ) = (nlat/npes)
  ELSE
     il_paral ( 4 ) = nlat-mype*(nlat/npes) 
  ENDIF
  ! il_paral (5) global extent in X here = local extent in X as no partition in I
  il_paral ( 5 ) = nlon
  !
  WRITE(w_unit,*) 'il_paral (:) :',il_paral
  CALL flush(w_unit) 
  !
#endif
  !
END SUBROUTINE oasis3_decomp
