/*
    Copyright (c) 2008-2013 NetAllied Systems GmbH

    This file is part of COLLADASaxFrameworkLoader.

    Licensed under the MIT Open Source License,
    for details please see LICENSE file or the website
    http://www.opensource.org/licenses/mit-license.php
*/

#include "COLLADASaxFWLStableHeaders.h"
#include "COLLADASaxFWLColladaParserAutoGen14Private.h"


// disable warning "unused variable"
#if defined(__INTEL_COMPILER) && !defined(WIN32)
template <typename T>
inline void disable_warning_unused(T &x) { (void)x; }
#    define DISABLE_WARNING_UNUSED(x) disable_warning_unused(x);
#else
#    define DISABLE_WARNING_UNUSED(x) (void)x;
#endif



namespace COLLADASaxFWL14
{


#ifdef GENERATEDSAXPARSER_VALIDATION


//---------------------------------------------------------------------
const int PCRE_OVECCOUNT = 30;    /* should be a multiple of 3 */

//---------------------------------------------------------------------
ParserError::ErrorType validate__VersionType( ParserString value )
{
    return validate__VersionType( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__VersionType( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__VersionType__stream( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__VersionType__streamEnd( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__COLLADA( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        COLLADA__ValidationData* validationData = (COLLADA__ValidationData*)mValidationDataStack.newObject(sizeof(COLLADA__ValidationData));
        memset(validationData, 0, sizeof(COLLADA__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__COLLADA()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        COLLADA__ValidationData* validationData = (COLLADA__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_ASSET) || (validationData->validation_current_state == HASH_ELEMENT_EXTRA) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATIONS) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_CAMERAS) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_CONTROLLERS) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_EFFECTS) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_FORCE_FIELDS) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_GEOMETRIES) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_IMAGES) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_LIGHTS) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_MATERIALS) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_NODES) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MATERIALS) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MODELS) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_SCENES) || (validationData->validation_current_state == HASH_ELEMENT_LIBRARY_VISUAL_SCENES) || (validationData->validation_current_state == HASH_ELEMENT_SCENE) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_COLLADA, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__asset( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 188:
        {
        COLLADA__ValidationData* parentValidationData = (COLLADA__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 23:
        {
        animation__ValidationData* parentValidationData = (animation__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 402:
        {
        animation_clip__ValidationData* parentValidationData = (animation_clip__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->instance_animation != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: instance_animation" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 475:
        {
        camera__ValidationData* parentValidationData = (camera__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->optics != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: optics" ) )
                return false;
        }
        if ( parentValidationData->imager != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: imager" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 290:
        {
        controller__ValidationData* parentValidationData = (controller__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 487:
        {
        effect__ValidationData* parentValidationData = (effect__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->annotate != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: annotate" ) )
                return false;
        }
        if ( parentValidationData->image != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: image" ) )
                return false;
        }
        if ( parentValidationData->newparam != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: newparam" ) )
                return false;
        }
        if ( parentValidationData->fx_profile_abstract != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: fx_profile_abstract" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 515:
        {
        extra__ValidationData* parentValidationData = (extra__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: technique" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 505:
        {
        force_field__ValidationData* parentValidationData = (force_field__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: technique" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 183:
        {
        geometry__ValidationData* parentValidationData = (geometry__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 28:
        {
        image__ValidationData* parentValidationData = (image__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 222:
        {
        library_animation_clips__ValidationData* parentValidationData = (library_animation_clips__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->animation_clip != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: animation_clip" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 354:
        {
        library_animations__ValidationData* parentValidationData = (library_animations__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->animation != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: animation" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 172:
        {
        library_cameras__ValidationData* parentValidationData = (library_cameras__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->camera != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: camera" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 513:
        {
        library_controllers__ValidationData* parentValidationData = (library_controllers__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->controller != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: controller" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 494:
        {
        library_effects__ValidationData* parentValidationData = (library_effects__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->effect != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: effect" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 173:
        {
        library_force_fields__ValidationData* parentValidationData = (library_force_fields__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->force_field != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: force_field" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 129:
        {
        library_geometries__ValidationData* parentValidationData = (library_geometries__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->geometry != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: geometry" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 73:
        {
        library_images__ValidationData* parentValidationData = (library_images__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->image != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: image" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 178:
        {
        library_lights__ValidationData* parentValidationData = (library_lights__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->light != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: light" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 207:
        {
        library_materials__ValidationData* parentValidationData = (library_materials__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->material != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: material" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 433:
        {
        library_nodes__ValidationData* parentValidationData = (library_nodes__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->node != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: node" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 599:
        {
        library_physics_materials__ValidationData* parentValidationData = (library_physics_materials__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->physics_material != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: physics_material" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 97:
        {
        library_physics_models__ValidationData* parentValidationData = (library_physics_models__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->physics_model != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: physics_model" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 105:
        {
        library_physics_scenes__ValidationData* parentValidationData = (library_physics_scenes__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->physics_scene != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: physics_scene" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 584:
        {
        library_visual_scenes__ValidationData* parentValidationData = (library_visual_scenes__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->visual_scene != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: visual_scene" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 81:
        {
        light__ValidationData* parentValidationData = (light__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->technique != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: technique" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 394:
        {
        material__ValidationData* parentValidationData = (material__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->instance_effect != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: instance_effect" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 87:
        {
        node__ValidationData* parentValidationData = (node__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 179:
        {
        physics_material__ValidationData* parentValidationData = (physics_material__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->technique != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: technique" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 586:
        {
        physics_model__ValidationData* parentValidationData = (physics_model__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->rigid_body != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: rigid_body" ) )
                return false;
        }
        if ( parentValidationData->rigid_constraint != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: rigid_constraint" ) )
                return false;
        }
        if ( parentValidationData->instance_physics_model != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: instance_physics_model" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 532:
        {
        physics_scene__ValidationData* parentValidationData = (physics_scene__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->instance_force_field != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: instance_force_field" ) )
                return false;
        }
        if ( parentValidationData->instance_physics_model != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: instance_physics_model" ) )
                return false;
        }
        if ( parentValidationData->technique_common != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->technique != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: technique" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        case 534:
        {
        profile_CG__ValidationData* parentValidationData = (profile_CG__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 460:
        {
        profile_COMMON__ValidationData* parentValidationData = (profile_COMMON__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 393:
        {
        profile_GLES__ValidationData* parentValidationData = (profile_GLES__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 286:
        {
        profile_GLSL__ValidationData* parentValidationData = (profile_GLSL__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 130:
        {
        source__ValidationData* parentValidationData = (source__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 317:
        {
        profile_CG__technique__ValidationData* parentValidationData = (profile_CG__technique__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 318:
        {
        profile_COMMON__technique__ValidationData* parentValidationData = (profile_COMMON__technique__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 319:
        {
        profile_GLES__technique__ValidationData* parentValidationData = (profile_GLES__technique__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASSET;
        }
//        parentValidationData->asset++;

        break;
        }

        case 506:
        {
        visual_scene__ValidationData* parentValidationData = (visual_scene__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->node != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: node" ) )
                return false;
        }
        if ( parentValidationData->evaluate_scene != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: evaluate_scene" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ASSET, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->asset >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ASSET, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->asset++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        asset__ValidationData* validationData = (asset__ValidationData*)mValidationDataStack.newObject(sizeof(asset__ValidationData));
        memset(validationData, 0, sizeof(asset__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__asset()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        asset__ValidationData* validationData = (asset__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->created < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_ASSET, (const ParserChar*)0, "child: created" ) )
                return false;
        }
        if ( validationData->modified < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_ASSET, (const ParserChar*)0, "child: modified" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__contributor( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        asset__ValidationData* parentValidationData = (asset__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->created != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONTRIBUTOR, (const ParserChar*)0, "sibling: created" ) )
                return false;
        }
        if ( parentValidationData->keywords != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONTRIBUTOR, (const ParserChar*)0, "sibling: keywords" ) )
                return false;
        }
        if ( parentValidationData->modified != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONTRIBUTOR, (const ParserChar*)0, "sibling: modified" ) )
                return false;
        }
        if ( parentValidationData->revision != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONTRIBUTOR, (const ParserChar*)0, "sibling: revision" ) )
                return false;
        }
        if ( parentValidationData->subject != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONTRIBUTOR, (const ParserChar*)0, "sibling: subject" ) )
                return false;
        }
        if ( parentValidationData->title != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONTRIBUTOR, (const ParserChar*)0, "sibling: title" ) )
                return false;
        }
        if ( parentValidationData->unit != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONTRIBUTOR, (const ParserChar*)0, "sibling: unit" ) )
                return false;
        }
        if ( parentValidationData->up_axis != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONTRIBUTOR, (const ParserChar*)0, "sibling: up_axis" ) )
                return false;
        }
        parentValidationData->contributor++;

        contributor__ValidationData* validationData = (contributor__ValidationData*)mValidationDataStack.newObject(sizeof(contributor__ValidationData));
        memset(validationData, 0, sizeof(contributor__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__contributor()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        contributor__ValidationData* validationData = (contributor__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__author( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        contributor__ValidationData* parentValidationData = (contributor__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->authoring_tool != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHOR, (const ParserChar*)0, "sibling: authoring_tool" ) )
                return false;
        }
        if ( parentValidationData->comments != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHOR, (const ParserChar*)0, "sibling: comments" ) )
                return false;
        }
        if ( parentValidationData->copyright != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHOR, (const ParserChar*)0, "sibling: copyright" ) )
                return false;
        }
        if ( parentValidationData->source_data != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHOR, (const ParserChar*)0, "sibling: source_data" ) )
                return false;
        }
        if ( parentValidationData->author >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_AUTHOR, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->author++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__author()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__authoring_tool( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        contributor__ValidationData* parentValidationData = (contributor__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->comments != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHORING_TOOL, (const ParserChar*)0, "sibling: comments" ) )
                return false;
        }
        if ( parentValidationData->copyright != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHORING_TOOL, (const ParserChar*)0, "sibling: copyright" ) )
                return false;
        }
        if ( parentValidationData->source_data != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_AUTHORING_TOOL, (const ParserChar*)0, "sibling: source_data" ) )
                return false;
        }
        if ( parentValidationData->authoring_tool >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_AUTHORING_TOOL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->authoring_tool++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__authoring_tool()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__comments( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        contributor__ValidationData* parentValidationData = (contributor__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->copyright != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_COMMENTS, (const ParserChar*)0, "sibling: copyright" ) )
                return false;
        }
        if ( parentValidationData->source_data != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_COMMENTS, (const ParserChar*)0, "sibling: source_data" ) )
                return false;
        }
        if ( parentValidationData->comments >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_COMMENTS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->comments++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__comments()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__copyright( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        contributor__ValidationData* parentValidationData = (contributor__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source_data != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_COPYRIGHT, (const ParserChar*)0, "sibling: source_data" ) )
                return false;
        }
        if ( parentValidationData->copyright >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_COPYRIGHT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->copyright++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__copyright()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__source_data( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        contributor__ValidationData* parentValidationData = (contributor__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source_data >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SOURCE_DATA, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->source_data++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__source_data()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__created( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        asset__ValidationData* parentValidationData = (asset__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->keywords != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CREATED, (const ParserChar*)0, "sibling: keywords" ) )
                return false;
        }
        if ( parentValidationData->modified != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CREATED, (const ParserChar*)0, "sibling: modified" ) )
                return false;
        }
        if ( parentValidationData->revision != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CREATED, (const ParserChar*)0, "sibling: revision" ) )
                return false;
        }
        if ( parentValidationData->subject != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CREATED, (const ParserChar*)0, "sibling: subject" ) )
                return false;
        }
        if ( parentValidationData->title != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CREATED, (const ParserChar*)0, "sibling: title" ) )
                return false;
        }
        if ( parentValidationData->unit != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CREATED, (const ParserChar*)0, "sibling: unit" ) )
                return false;
        }
        if ( parentValidationData->up_axis != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CREATED, (const ParserChar*)0, "sibling: up_axis" ) )
                return false;
        }
        if ( parentValidationData->created >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_CREATED, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->created++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__created()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__keywords( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        asset__ValidationData* parentValidationData = (asset__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->created < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_KEYWORDS, (const ParserChar*)0, "sibling: created" ) )
                return false;
        }
        if ( parentValidationData->modified != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_KEYWORDS, (const ParserChar*)0, "sibling: modified" ) )
                return false;
        }
        if ( parentValidationData->revision != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_KEYWORDS, (const ParserChar*)0, "sibling: revision" ) )
                return false;
        }
        if ( parentValidationData->subject != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_KEYWORDS, (const ParserChar*)0, "sibling: subject" ) )
                return false;
        }
        if ( parentValidationData->title != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_KEYWORDS, (const ParserChar*)0, "sibling: title" ) )
                return false;
        }
        if ( parentValidationData->unit != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_KEYWORDS, (const ParserChar*)0, "sibling: unit" ) )
                return false;
        }
        if ( parentValidationData->up_axis != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_KEYWORDS, (const ParserChar*)0, "sibling: up_axis" ) )
                return false;
        }
        if ( parentValidationData->keywords >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_KEYWORDS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->keywords++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__keywords()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__modified( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        asset__ValidationData* parentValidationData = (asset__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->created < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MODIFIED, (const ParserChar*)0, "sibling: created" ) )
                return false;
        }
        if ( parentValidationData->revision != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MODIFIED, (const ParserChar*)0, "sibling: revision" ) )
                return false;
        }
        if ( parentValidationData->subject != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MODIFIED, (const ParserChar*)0, "sibling: subject" ) )
                return false;
        }
        if ( parentValidationData->title != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MODIFIED, (const ParserChar*)0, "sibling: title" ) )
                return false;
        }
        if ( parentValidationData->unit != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MODIFIED, (const ParserChar*)0, "sibling: unit" ) )
                return false;
        }
        if ( parentValidationData->up_axis != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MODIFIED, (const ParserChar*)0, "sibling: up_axis" ) )
                return false;
        }
        if ( parentValidationData->modified >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MODIFIED, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->modified++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__modified()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__revision( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        asset__ValidationData* parentValidationData = (asset__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->modified < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_REVISION, (const ParserChar*)0, "sibling: modified" ) )
                return false;
        }
        if ( parentValidationData->subject != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_REVISION, (const ParserChar*)0, "sibling: subject" ) )
                return false;
        }
        if ( parentValidationData->title != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_REVISION, (const ParserChar*)0, "sibling: title" ) )
                return false;
        }
        if ( parentValidationData->unit != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_REVISION, (const ParserChar*)0, "sibling: unit" ) )
                return false;
        }
        if ( parentValidationData->up_axis != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_REVISION, (const ParserChar*)0, "sibling: up_axis" ) )
                return false;
        }
        if ( parentValidationData->revision >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_REVISION, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->revision++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__revision()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__subject( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        asset__ValidationData* parentValidationData = (asset__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->modified < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_SUBJECT, (const ParserChar*)0, "sibling: modified" ) )
                return false;
        }
        if ( parentValidationData->title != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SUBJECT, (const ParserChar*)0, "sibling: title" ) )
                return false;
        }
        if ( parentValidationData->unit != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SUBJECT, (const ParserChar*)0, "sibling: unit" ) )
                return false;
        }
        if ( parentValidationData->up_axis != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SUBJECT, (const ParserChar*)0, "sibling: up_axis" ) )
                return false;
        }
        if ( parentValidationData->subject >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SUBJECT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->subject++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__subject()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__title( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        asset__ValidationData* parentValidationData = (asset__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->modified < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_TITLE, (const ParserChar*)0, "sibling: modified" ) )
                return false;
        }
        if ( parentValidationData->unit != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TITLE, (const ParserChar*)0, "sibling: unit" ) )
                return false;
        }
        if ( parentValidationData->up_axis != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TITLE, (const ParserChar*)0, "sibling: up_axis" ) )
                return false;
        }
        if ( parentValidationData->title >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_TITLE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->title++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__title()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__NMTOKEN( ParserString value )
{
    return validate__NMTOKEN( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__NMTOKEN( const ParserChar* value, size_t length )
{
// regular expression: "^([A-Z]|[_]|[a-z]|[:]|[-]|[.]|[0-9])+$"
static const COLLADABU::PcreCompiledPattern compiledPattern("^([A-Z]|[_]|[a-z]|[:]|[-]|[.]|[0-9])+$");
pcre* pattern = compiledPattern.getCompiledPattern();
int ovector[ PCRE_OVECCOUNT ];
int pcre_result = pcre_exec(
    pattern,
    0,
    value,
    (int)length,
    0,
    0,
    ovector,
    PCRE_OVECCOUNT);
if (pcre_result < 0)
    return ParserError::ERROR_VALIDATION_PATTERN;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__NMTOKEN__stream( const ParserChar* value, size_t length )
{

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__NMTOKEN__streamEnd( const ParserChar* value, size_t length )
{

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__unit( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        asset__ValidationData* parentValidationData = (asset__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->modified < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_UNIT, (const ParserChar*)0, "sibling: modified" ) )
                return false;
        }
        if ( parentValidationData->up_axis != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_UNIT, (const ParserChar*)0, "sibling: up_axis" ) )
                return false;
        }
        if ( parentValidationData->unit >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_UNIT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->unit++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__unit()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__UpAxisType( ParserString value )
{
    return validate__UpAxisType( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__UpAxisType( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__UpAxisType__stream( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__UpAxisType__streamEnd( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__up_axis( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        asset__ValidationData* parentValidationData = (asset__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->modified < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_UP_AXIS, (const ParserChar*)0, "sibling: modified" ) )
                return false;
        }
        if ( parentValidationData->up_axis >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_UP_AXIS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->up_axis++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__up_axis()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__NCName( ParserString value )
{
    return validate__NCName( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__NCName( const ParserChar* value, size_t length )
{
// regular expression: "^([A-Z]|[_]|[a-z])([A-Z]|[_]|[a-z]|[-]|[.]|[0-9])*$"
static const COLLADABU::PcreCompiledPattern compiledPattern("^([A-Z]|[_]|[a-z])([A-Z]|[_]|[a-z]|[-]|[.]|[0-9])*$");
pcre* pattern = compiledPattern.getCompiledPattern();
int ovector[ PCRE_OVECCOUNT ];
int pcre_result = pcre_exec(
    pattern,
    0,
    value,
    (int)length,
    0,
    0,
    ovector,
    PCRE_OVECCOUNT);
if (pcre_result < 0)
    return ParserError::ERROR_VALIDATION_PATTERN;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__NCName__stream( const ParserChar* value, size_t length )
{

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__NCName__streamEnd( const ParserChar* value, size_t length )
{

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__library_animations( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        COLLADA__ValidationData* parentValidationData = (COLLADA__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATIONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CAMERAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CONTROLLERS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_EFFECTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_FORCE_FIELDS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_GEOMETRIES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_IMAGES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_LIGHTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_NODES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MODELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_SCENES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_VISUAL_SCENES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_LIBRARY_ANIMATIONS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_LIBRARY_ANIMATIONS;
        }
//        parentValidationData->library_animations++;

        library_animations__ValidationData* validationData = (library_animations__ValidationData*)mValidationDataStack.newObject(sizeof(library_animations__ValidationData));
        memset(validationData, 0, sizeof(library_animations__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__library_animations()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        library_animations__ValidationData* validationData = (library_animations__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->animation < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_LIBRARY_ANIMATIONS, (const ParserChar*)0, "child: animation" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__animation( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 23:
        {
        animation__ValidationData* parentValidationData = (animation__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANIMATION) || (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_CHANNEL) || (parentValidationData->validation_current_state == HASH_ELEMENT_SOURCE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANIMATION, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANIMATION;
        }
//        parentValidationData->animation++;

        break;
        }

        case 354:
        {
        library_animations__ValidationData* parentValidationData = (library_animations__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANIMATION, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->animation++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        animation__ValidationData* validationData = (animation__ValidationData*)mValidationDataStack.newObject(sizeof(animation__ValidationData));
        memset(validationData, 0, sizeof(animation__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__animation()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        animation__ValidationData* validationData = (animation__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_ANIMATION) || (validationData->validation_current_state == HASH_ELEMENT_CHANNEL) || (validationData->validation_current_state == HASH_ELEMENT_EXTRA) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_ANIMATION, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__source( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 23:
        {
        animation__ValidationData* parentValidationData = (animation__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_SOURCE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SOURCE;
        }
//        parentValidationData->source++;

        break;
        }

        case 297:
        {
        convex_mesh__ValidationData* parentValidationData = (convex_mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_SOURCE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SOURCE;
        }
//        parentValidationData->source++;

        break;
        }

        case 266:
        {
        mesh__ValidationData* parentValidationData = (mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_SOURCE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SOURCE;
        }
//        parentValidationData->source++;

        break;
        }

        case 591:
        {
        morph__ValidationData* parentValidationData = (morph__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->targets != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: targets" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        case 576:
        {
        skin__ValidationData* parentValidationData = (skin__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->joints != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: joints" ) )
                return false;
        }
        if ( parentValidationData->vertex_weights != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: vertex_weights" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        case 185:
        {
        spline__ValidationData* parentValidationData = (spline__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->control_vertices != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: control_vertices" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        source__ValidationData* validationData = (source__ValidationData*)mValidationDataStack.newObject(sizeof(source__ValidationData));
        memset(validationData, 0, sizeof(source__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__source()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        source__ValidationData* validationData = (source__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_ASSET) || (validationData->validation_current_state == HASH_ELEMENT_BOOL_ARRAY) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT_ARRAY) || (validationData->validation_current_state == HASH_ELEMENT_IDREF_ARRAY) || (validationData->validation_current_state == HASH_ELEMENT_INT_ARRAY) || (validationData->validation_current_state == HASH_ELEMENT_NAME_ARRAY) || (validationData->validation_current_state == HASH_ELEMENT_TECHNIQUE) || (validationData->validation_current_state == HASH_ELEMENT_TECHNIQUE_COMMON) || (validationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__IDREFS( const ParserString*value, size_t length )
{
    if( length < 1 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__IDREFS__stream( const ParserString*value, size_t length )
{

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__IDREFS__streamEnd( const ParserString*value, size_t length )
{
    if( length < 1 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__IDREF_array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        source__ValidationData* parentValidationData = (source__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_IDREF_ARRAY, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_IDREF_ARRAY;
        }
//        parentValidationData->IDREF_array++;

        IDREF_array__ValidationData* validationData = (IDREF_array__ValidationData*)mValidationDataStack.newObject(sizeof(IDREF_array__ValidationData));
        memset(validationData, 0, sizeof(IDREF_array__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__IDREF_array()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__Name( ParserString value )
{
    return validate__Name( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__Name( const ParserChar* value, size_t length )
{
// regular expression: "^([A-Z]|[_]|[a-z]|[:])([A-Z]|[_]|[a-z]|[:]|[-]|[.]|[0-9])*$"
static const COLLADABU::PcreCompiledPattern compiledPattern("^([A-Z]|[_]|[a-z]|[:])([A-Z]|[_]|[a-z]|[:]|[-]|[.]|[0-9])*$");
pcre* pattern = compiledPattern.getCompiledPattern();
int ovector[ PCRE_OVECCOUNT ];
int pcre_result = pcre_exec(
    pattern,
    0,
    value,
    (int)length,
    0,
    0,
    ovector,
    PCRE_OVECCOUNT);
if (pcre_result < 0)
    return ParserError::ERROR_VALIDATION_PATTERN;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__Name__stream( const ParserChar* value, size_t length )
{

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__Name__streamEnd( const ParserChar* value, size_t length )
{

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__Name_array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        source__ValidationData* parentValidationData = (source__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_NAME_ARRAY, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_NAME_ARRAY;
        }
//        parentValidationData->Name_array++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__Name_array()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__bool_array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        source__ValidationData* parentValidationData = (source__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL_ARRAY, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL_ARRAY;
        }
//        parentValidationData->bool_array++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__bool_array()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__float_array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        source__ValidationData* parentValidationData = (source__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT_ARRAY, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT_ARRAY;
        }
//        parentValidationData->float_array++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__float_array()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__int_array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        source__ValidationData* parentValidationData = (source__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT_ARRAY, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT_ARRAY;
        }
//        parentValidationData->int_array++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__int_array()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__animation__source__technique_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        source__ValidationData* parentValidationData = (source__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_IDREF_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_NAME_ARRAY) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_TECHNIQUE_COMMON, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_TECHNIQUE_COMMON;
        }
//        parentValidationData->technique_common++;

        animation__source__technique_common__ValidationData* validationData = (animation__source__technique_common__ValidationData*)mValidationDataStack.newObject(sizeof(animation__source__technique_common__ValidationData));
        memset(validationData, 0, sizeof(animation__source__technique_common__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__animation__source__technique_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        animation__source__technique_common__ValidationData* validationData = (animation__source__technique_common__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->accessor < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_TECHNIQUE_COMMON, (const ParserChar*)0, "child: accessor" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__accessor( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        animation__source__technique_common__ValidationData* parentValidationData = (animation__source__technique_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->accessor >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ACCESSOR, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->accessor++;

        accessor__ValidationData* validationData = (accessor__ValidationData*)mValidationDataStack.newObject(sizeof(accessor__ValidationData));
        memset(validationData, 0, sizeof(accessor__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__accessor()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        accessor__ValidationData* validationData = (accessor__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__param( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 406:
        {
        accessor__ValidationData* parentValidationData = (accessor__ValidationData*)mValidationDataStack.top();
        parentValidationData->param++;

        break;
        }

        case 562:
        {
        bind_material__ValidationData* parentValidationData = (bind_material__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_PARAM, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->technique != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_PARAM, (const ParserChar*)0, "sibling: technique" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_PARAM, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->param++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__param()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__technique( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 562:
        {
        bind_material__ValidationData* parentValidationData = (bind_material__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->technique++;

        break;
        }

        case 515:
        {
        extra__ValidationData* parentValidationData = (extra__ValidationData*)mValidationDataStack.top();
        parentValidationData->technique++;

        break;
        }

        case 505:
        {
        force_field__ValidationData* parentValidationData = (force_field__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->technique++;

        break;
        }

        case 596:
        {
        imager__ValidationData* parentValidationData = (imager__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->technique++;

        break;
        }

        case 201:
        {
        instance_rigid_body__ValidationData* parentValidationData = (instance_rigid_body__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->technique++;

        break;
        }

        case 81:
        {
        light__ValidationData* parentValidationData = (light__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->technique++;

        break;
        }

        case 230:
        {
        optics__ValidationData* parentValidationData = (optics__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->technique++;

        break;
        }

        case 179:
        {
        physics_material__ValidationData* parentValidationData = (physics_material__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->technique++;

        break;
        }

        case 532:
        {
        physics_scene__ValidationData* parentValidationData = (physics_scene__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->technique++;

        break;
        }

        case 92:
        {
        rigid_body__ValidationData* parentValidationData = (rigid_body__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->technique++;

        break;
        }

        case 19:
        {
        rigid_constraint__ValidationData* parentValidationData = (rigid_constraint__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->technique++;

        break;
        }

        case 130:
        {
        source__ValidationData* parentValidationData = (source__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_IDREF_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_NAME_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_TECHNIQUE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TECHNIQUE_COMMON) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_TECHNIQUE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_TECHNIQUE;
        }
//        parentValidationData->technique++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        technique__ValidationData* validationData = (technique__ValidationData*)mValidationDataStack.newObject(sizeof(technique__ValidationData));
        memset(validationData, 0, sizeof(technique__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__technique()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        technique__ValidationData* validationData = (technique__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__sampler( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        animation__ValidationData* parentValidationData = (animation__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SOURCE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SAMPLER, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SAMPLER;
        }
//        parentValidationData->sampler++;

        sampler__ValidationData* validationData = (sampler__ValidationData*)mValidationDataStack.newObject(sizeof(sampler__ValidationData));
        memset(validationData, 0, sizeof(sampler__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__sampler()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        sampler__ValidationData* validationData = (sampler__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->input < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SAMPLER, (const ParserChar*)0, "child: input" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__URIFragmentType( ParserString value )
{
    return validate__URIFragmentType( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__URIFragmentType( const ParserChar* value, size_t length )
{
// regular expression: "^(#(.*))$"
static const COLLADABU::PcreCompiledPattern compiledPattern("^(#(.*))$");
pcre* pattern = compiledPattern.getCompiledPattern();
int ovector[ PCRE_OVECCOUNT ];
int pcre_result = pcre_exec(
    pattern,
    0,
    value,
    (int)length,
    0,
    0,
    ovector,
    PCRE_OVECCOUNT);
if (pcre_result < 0)
    return ParserError::ERROR_VALIDATION_PATTERN;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__URIFragmentType__stream( const ParserChar* value, size_t length )
{

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__URIFragmentType__streamEnd( const ParserChar* value, size_t length )
{

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__input____InputLocal( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 516:
        {
        control_vertices__ValidationData* parentValidationData = (control_vertices__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 421:
        {
        joints__ValidationData* parentValidationData = (joints__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 86:
        {
        sampler__ValidationData* parentValidationData = (sampler__ValidationData*)mValidationDataStack.top();
        parentValidationData->input++;

        break;
        }

        case 50:
        {
        targets__ValidationData* parentValidationData = (targets__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 332:
        {
        vertices__ValidationData* parentValidationData = (vertices__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__input____InputLocal()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__channel( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        animation__ValidationData* parentValidationData = (animation__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_CHANNEL) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_CHANNEL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_CHANNEL;
        }
//        parentValidationData->channel++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__channel()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__extra( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 188:
        {
        COLLADA__ValidationData* parentValidationData = (COLLADA__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATIONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CAMERAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CONTROLLERS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_EFFECTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_FORCE_FIELDS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_GEOMETRIES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_IMAGES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_LIGHTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_NODES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MODELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_SCENES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_VISUAL_SCENES) || (parentValidationData->validation_current_state == HASH_ELEMENT_SCENE) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 23:
        {
        animation__ValidationData* parentValidationData = (animation__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANIMATION) || (parentValidationData->validation_current_state == HASH_ELEMENT_CHANNEL) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 402:
        {
        animation_clip__ValidationData* parentValidationData = (animation_clip__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->instance_animation < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: instance_animation" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 478:
        {
        attachment__ValidationData* parentValidationData = (attachment__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 562:
        {
        bind_material__ValidationData* parentValidationData = (bind_material__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 140:
        {
        box__ValidationData* parentValidationData = (box__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->half_extents < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: half_extents" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 475:
        {
        camera__ValidationData* parentValidationData = (camera__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->optics < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: optics" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 231:
        {
        capsule__ValidationData* parentValidationData = (capsule__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->radius < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: radius" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 516:
        {
        control_vertices__ValidationData* parentValidationData = (control_vertices__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->input < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: input" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 290:
        {
        controller__ValidationData* parentValidationData = (controller__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_MORPH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SKIN) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 297:
        {
        convex_mesh__ValidationData* parentValidationData = (convex_mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 436:
        {
        cylinder__ValidationData* parentValidationData = (cylinder__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->radius < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: radius" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 487:
        {
        effect__ValidationData* parentValidationData = (effect__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->fx_profile_abstract < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: fx_profile_abstract" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 505:
        {
        force_field__ValidationData* parentValidationData = (force_field__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 183:
        {
        geometry__ValidationData* parentValidationData = (geometry__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_CONVEX_MESH) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_MESH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SPLINE) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 28:
        {
        image__ValidationData* parentValidationData = (image__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_DATA) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 596:
        {
        imager__ValidationData* parentValidationData = (imager__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 251:
        {
        instance_controller__ValidationData* parentValidationData = (instance_controller__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 578:
        {
        instance_effect__ValidationData* parentValidationData = (instance_effect__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 285:
        {
        instance_geometry__ValidationData* parentValidationData = (instance_geometry__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 116:
        {
        instance_material__ValidationData* parentValidationData = (instance_material__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 585:
        {
        instance_physics_model__ValidationData* parentValidationData = (instance_physics_model__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 201:
        {
        instance_rigid_body__ValidationData* parentValidationData = (instance_rigid_body__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 176:
        {
        instance_rigid_constraint__ValidationData* parentValidationData = (instance_rigid_constraint__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 421:
        {
        joints__ValidationData* parentValidationData = (joints__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->input < 2 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: input" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 222:
        {
        library_animation_clips__ValidationData* parentValidationData = (library_animation_clips__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->animation_clip < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: animation_clip" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 354:
        {
        library_animations__ValidationData* parentValidationData = (library_animations__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->animation < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: animation" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 172:
        {
        library_cameras__ValidationData* parentValidationData = (library_cameras__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->camera < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: camera" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 513:
        {
        library_controllers__ValidationData* parentValidationData = (library_controllers__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->controller < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: controller" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 494:
        {
        library_effects__ValidationData* parentValidationData = (library_effects__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->effect < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: effect" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 173:
        {
        library_force_fields__ValidationData* parentValidationData = (library_force_fields__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->force_field < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: force_field" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 129:
        {
        library_geometries__ValidationData* parentValidationData = (library_geometries__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->geometry < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: geometry" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 73:
        {
        library_images__ValidationData* parentValidationData = (library_images__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->image < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: image" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 178:
        {
        library_lights__ValidationData* parentValidationData = (library_lights__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->light < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: light" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 207:
        {
        library_materials__ValidationData* parentValidationData = (library_materials__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->material < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: material" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 433:
        {
        library_nodes__ValidationData* parentValidationData = (library_nodes__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->node < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: node" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 599:
        {
        library_physics_materials__ValidationData* parentValidationData = (library_physics_materials__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->physics_material < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: physics_material" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 97:
        {
        library_physics_models__ValidationData* parentValidationData = (library_physics_models__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->physics_model < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: physics_model" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 105:
        {
        library_physics_scenes__ValidationData* parentValidationData = (library_physics_scenes__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->physics_scene < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: physics_scene" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 584:
        {
        library_visual_scenes__ValidationData* parentValidationData = (library_visual_scenes__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->visual_scene < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: visual_scene" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 81:
        {
        light__ValidationData* parentValidationData = (light__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 38:
        {
        lines__ValidationData* parentValidationData = (lines__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 48:
        {
        linestrips__ValidationData* parentValidationData = (linestrips__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 394:
        {
        material__ValidationData* parentValidationData = (material__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->instance_effect < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: instance_effect" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 266:
        {
        mesh__ValidationData* parentValidationData = (mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 591:
        {
        morph__ValidationData* parentValidationData = (morph__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->targets < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: targets" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 87:
        {
        node__ValidationData* parentValidationData = (node__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_CAMERA) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_CONTROLLER) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_GEOMETRY) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_LIGHT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_NODE) || (parentValidationData->validation_current_state == HASH_ELEMENT_LOOKAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_MATRIX) || (parentValidationData->validation_current_state == HASH_ELEMENT_NODE) || (parentValidationData->validation_current_state == HASH_ELEMENT_ROTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SCALE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SKEW) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRANSLATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 230:
        {
        optics__ValidationData* parentValidationData = (optics__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 300:
        {
        profile_CG__technique__pass__ValidationData* parentValidationData = (profile_CG__technique__pass__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ALPHA_FUNC) || (parentValidationData->validation_current_state == HASH_ELEMENT_ALPHA_TEST_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_AUTO_NORMAL_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_BLEND_COLOR) || (parentValidationData->validation_current_state == HASH_ELEMENT_BLEND_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_BLEND_EQUATION) || (parentValidationData->validation_current_state == HASH_ELEMENT_BLEND_EQUATION_SEPARATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_BLEND_FUNC) || (parentValidationData->validation_current_state == HASH_ELEMENT_BLEND_FUNC_SEPARATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_CLEAR_COLOR) || (parentValidationData->validation_current_state == HASH_ELEMENT_CLEAR_DEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_CLEAR_STENCIL) || (parentValidationData->validation_current_state == HASH_ELEMENT_CLIP_PLANE) || (parentValidationData->validation_current_state == HASH_ELEMENT_CLIP_PLANE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_COLOR_LOGIC_OP_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_COLOR_MASK) || (parentValidationData->validation_current_state == HASH_ELEMENT_COLOR_MATERIAL) || (parentValidationData->validation_current_state == HASH_ELEMENT_COLOR_MATERIAL_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_CULL_FACE) || (parentValidationData->validation_current_state == HASH_ELEMENT_CULL_FACE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_DEPTH_BOUNDS) || (parentValidationData->validation_current_state == HASH_ELEMENT_DEPTH_BOUNDS_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_DEPTH_CLAMP_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_DEPTH_FUNC) || (parentValidationData->validation_current_state == HASH_ELEMENT_DEPTH_MASK) || (parentValidationData->validation_current_state == HASH_ELEMENT_DEPTH_RANGE) || (parentValidationData->validation_current_state == HASH_ELEMENT_DEPTH_TEST_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_DITHER_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_FOG_COLOR) || (parentValidationData->validation_current_state == HASH_ELEMENT_FOG_COORD_SRC) || (parentValidationData->validation_current_state == HASH_ELEMENT_FOG_DENSITY) || (parentValidationData->validation_current_state == HASH_ELEMENT_FOG_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_FOG_END) || (parentValidationData->validation_current_state == HASH_ELEMENT_FOG_MODE) || (parentValidationData->validation_current_state == HASH_ELEMENT_FOG_START) || (parentValidationData->validation_current_state == HASH_ELEMENT_FRONT_FACE) || (parentValidationData->validation_current_state == HASH_ELEMENT_GL_HOOK_ABSTRACT) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHTING_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_AMBIENT) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_CONSTANT_ATTENUATION) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_DIFFUSE) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_LINEAR_ATTENUATION) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_MODEL_AMBIENT) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_MODEL_COLOR_CONTROL) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_MODEL_LOCAL_VIEWER_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_MODEL_TWO_SIDE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_POSITION) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_QUADRATIC_ATTENUATION) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_SPECULAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_SPOT_CUTOFF) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_SPOT_DIRECTION) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_SPOT_EXPONENT) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINE_SMOOTH_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINE_STIPPLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINE_STIPPLE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINE_WIDTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_LOGIC_OP) || (parentValidationData->validation_current_state == HASH_ELEMENT_LOGIC_OP_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MATERIAL_AMBIENT) || (parentValidationData->validation_current_state == HASH_ELEMENT_MATERIAL_DIFFUSE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MATERIAL_EMISSION) || (parentValidationData->validation_current_state == HASH_ELEMENT_MATERIAL_SHININESS) || (parentValidationData->validation_current_state == HASH_ELEMENT_MATERIAL_SPECULAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODEL_VIEW_MATRIX) || (parentValidationData->validation_current_state == HASH_ELEMENT_MULTISAMPLE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_NORMALIZE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_POINT_DISTANCE_ATTENUATION) || (parentValidationData->validation_current_state == HASH_ELEMENT_POINT_FADE_THRESHOLD_SIZE) || (parentValidationData->validation_current_state == HASH_ELEMENT_POINT_SIZE) || (parentValidationData->validation_current_state == HASH_ELEMENT_POINT_SIZE_MAX) || (parentValidationData->validation_current_state == HASH_ELEMENT_POINT_SIZE_MIN) || (parentValidationData->validation_current_state == HASH_ELEMENT_POINT_SMOOTH_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGON_MODE) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGON_OFFSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGON_OFFSET_FILL_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGON_OFFSET_LINE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGON_OFFSET_POINT_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGON_SMOOTH_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGON_STIPPLE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_PROJECTION_MATRIX) || (parentValidationData->validation_current_state == HASH_ELEMENT_RESCALE_NORMAL_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLE_ALPHA_TO_COVERAGE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLE_ALPHA_TO_ONE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLE_COVERAGE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SCISSOR) || (parentValidationData->validation_current_state == HASH_ELEMENT_SCISSOR_TEST_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SHADER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SHADE_MODEL) || (parentValidationData->validation_current_state == HASH_ELEMENT_STENCIL_FUNC) || (parentValidationData->validation_current_state == HASH_ELEMENT_STENCIL_FUNC_SEPARATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_STENCIL_MASK) || (parentValidationData->validation_current_state == HASH_ELEMENT_STENCIL_MASK_SEPARATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_STENCIL_OP) || (parentValidationData->validation_current_state == HASH_ELEMENT_STENCIL_OP_SEPARATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_STENCIL_TEST_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURE1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURE1D_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURE2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURE2D_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURE3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURE3D_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURECUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURECUBE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTUREDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTUREDEPTH_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURERECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURERECT_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURE_ENV_COLOR) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURE_ENV_MODE) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 301:
        {
        profile_GLES__technique__pass__ValidationData* parentValidationData = (profile_GLES__technique__pass__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ALPHA_FUNC) || (parentValidationData->validation_current_state == HASH_ELEMENT_ALPHA_TEST_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_BLEND_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_BLEND_FUNC) || (parentValidationData->validation_current_state == HASH_ELEMENT_CLEAR_COLOR) || (parentValidationData->validation_current_state == HASH_ELEMENT_CLEAR_DEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_CLEAR_STENCIL) || (parentValidationData->validation_current_state == HASH_ELEMENT_CLIP_PLANE) || (parentValidationData->validation_current_state == HASH_ELEMENT_CLIP_PLANE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_COLOR_CLEAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_COLOR_LOGIC_OP_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_COLOR_MASK) || (parentValidationData->validation_current_state == HASH_ELEMENT_COLOR_MATERIAL_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_COLOR_TARGET) || (parentValidationData->validation_current_state == HASH_ELEMENT_CULL_FACE) || (parentValidationData->validation_current_state == HASH_ELEMENT_CULL_FACE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_DEPTH_CLEAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_DEPTH_FUNC) || (parentValidationData->validation_current_state == HASH_ELEMENT_DEPTH_MASK) || (parentValidationData->validation_current_state == HASH_ELEMENT_DEPTH_RANGE) || (parentValidationData->validation_current_state == HASH_ELEMENT_DEPTH_TARGET) || (parentValidationData->validation_current_state == HASH_ELEMENT_DEPTH_TEST_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_DITHER_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_DRAW) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_FOG_COLOR) || (parentValidationData->validation_current_state == HASH_ELEMENT_FOG_DENSITY) || (parentValidationData->validation_current_state == HASH_ELEMENT_FOG_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_FOG_END) || (parentValidationData->validation_current_state == HASH_ELEMENT_FOG_MODE) || (parentValidationData->validation_current_state == HASH_ELEMENT_FOG_START) || (parentValidationData->validation_current_state == HASH_ELEMENT_FRONT_FACE) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHTING_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_AMBIENT) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_CONSTANT_ATTENUATION) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_DIFFUSE) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_LINEAR_ATTENUTATION) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_MODEL_AMBIENT) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_MODEL_TWO_SIDE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_POSITION) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_QUADRATIC_ATTENUATION) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_SPECULAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_SPOT_CUTOFF) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_SPOT_DIRECTION) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_SPOT_EXPONENT) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINE_SMOOTH_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINE_WIDTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_LOGIC_OP) || (parentValidationData->validation_current_state == HASH_ELEMENT_MATERIAL_AMBIENT) || (parentValidationData->validation_current_state == HASH_ELEMENT_MATERIAL_DIFFUSE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MATERIAL_EMISSION) || (parentValidationData->validation_current_state == HASH_ELEMENT_MATERIAL_SHININESS) || (parentValidationData->validation_current_state == HASH_ELEMENT_MATERIAL_SPECULAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODEL_VIEW_MATRIX) || (parentValidationData->validation_current_state == HASH_ELEMENT_MULTISAMPLE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_NORMALIZE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_POINT_DISTANCE_ATTENUATION) || (parentValidationData->validation_current_state == HASH_ELEMENT_POINT_FADE_THRESHOLD_SIZE) || (parentValidationData->validation_current_state == HASH_ELEMENT_POINT_SIZE) || (parentValidationData->validation_current_state == HASH_ELEMENT_POINT_SIZE_MAX) || (parentValidationData->validation_current_state == HASH_ELEMENT_POINT_SIZE_MIN) || (parentValidationData->validation_current_state == HASH_ELEMENT_POINT_SMOOTH_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGON_OFFSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGON_OFFSET_FILL_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_PROJECTION_MATRIX) || (parentValidationData->validation_current_state == HASH_ELEMENT_RESCALE_NORMAL_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLE_ALPHA_TO_COVERAGE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLE_ALPHA_TO_ONE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLE_COVERAGE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SCISSOR) || (parentValidationData->validation_current_state == HASH_ELEMENT_SCISSOR_TEST_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SHADE_MODEL) || (parentValidationData->validation_current_state == HASH_ELEMENT_STENCIL_CLEAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_STENCIL_FUNC) || (parentValidationData->validation_current_state == HASH_ELEMENT_STENCIL_MASK) || (parentValidationData->validation_current_state == HASH_ELEMENT_STENCIL_OP) || (parentValidationData->validation_current_state == HASH_ELEMENT_STENCIL_TARGET) || (parentValidationData->validation_current_state == HASH_ELEMENT_STENCIL_TEST_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURE_PIPELINE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURE_PIPELINE_ENABLE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 302:
        {
        profile_GLSL__technique__pass__ValidationData* parentValidationData = (profile_GLSL__technique__pass__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ALPHA_FUNC) || (parentValidationData->validation_current_state == HASH_ELEMENT_ALPHA_TEST_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_AUTO_NORMAL_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_BLEND_COLOR) || (parentValidationData->validation_current_state == HASH_ELEMENT_BLEND_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_BLEND_EQUATION) || (parentValidationData->validation_current_state == HASH_ELEMENT_BLEND_EQUATION_SEPARATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_BLEND_FUNC) || (parentValidationData->validation_current_state == HASH_ELEMENT_BLEND_FUNC_SEPARATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_CLEAR_COLOR) || (parentValidationData->validation_current_state == HASH_ELEMENT_CLEAR_DEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_CLEAR_STENCIL) || (parentValidationData->validation_current_state == HASH_ELEMENT_CLIP_PLANE) || (parentValidationData->validation_current_state == HASH_ELEMENT_CLIP_PLANE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_COLOR_LOGIC_OP_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_COLOR_MASK) || (parentValidationData->validation_current_state == HASH_ELEMENT_COLOR_MATERIAL) || (parentValidationData->validation_current_state == HASH_ELEMENT_COLOR_MATERIAL_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_CULL_FACE) || (parentValidationData->validation_current_state == HASH_ELEMENT_CULL_FACE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_DEPTH_BOUNDS) || (parentValidationData->validation_current_state == HASH_ELEMENT_DEPTH_BOUNDS_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_DEPTH_CLAMP_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_DEPTH_FUNC) || (parentValidationData->validation_current_state == HASH_ELEMENT_DEPTH_MASK) || (parentValidationData->validation_current_state == HASH_ELEMENT_DEPTH_RANGE) || (parentValidationData->validation_current_state == HASH_ELEMENT_DEPTH_TEST_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_DITHER_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_FOG_COLOR) || (parentValidationData->validation_current_state == HASH_ELEMENT_FOG_COORD_SRC) || (parentValidationData->validation_current_state == HASH_ELEMENT_FOG_DENSITY) || (parentValidationData->validation_current_state == HASH_ELEMENT_FOG_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_FOG_END) || (parentValidationData->validation_current_state == HASH_ELEMENT_FOG_MODE) || (parentValidationData->validation_current_state == HASH_ELEMENT_FOG_START) || (parentValidationData->validation_current_state == HASH_ELEMENT_FRONT_FACE) || (parentValidationData->validation_current_state == HASH_ELEMENT_GL_HOOK_ABSTRACT) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHTING_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_AMBIENT) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_CONSTANT_ATTENUATION) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_DIFFUSE) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_LINEAR_ATTENUATION) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_MODEL_AMBIENT) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_MODEL_COLOR_CONTROL) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_MODEL_LOCAL_VIEWER_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_MODEL_TWO_SIDE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_POSITION) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_QUADRATIC_ATTENUATION) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_SPECULAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_SPOT_CUTOFF) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_SPOT_DIRECTION) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIGHT_SPOT_EXPONENT) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINE_SMOOTH_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINE_STIPPLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINE_STIPPLE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINE_WIDTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_LOGIC_OP) || (parentValidationData->validation_current_state == HASH_ELEMENT_LOGIC_OP_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MATERIAL_AMBIENT) || (parentValidationData->validation_current_state == HASH_ELEMENT_MATERIAL_DIFFUSE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MATERIAL_EMISSION) || (parentValidationData->validation_current_state == HASH_ELEMENT_MATERIAL_SHININESS) || (parentValidationData->validation_current_state == HASH_ELEMENT_MATERIAL_SPECULAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODEL_VIEW_MATRIX) || (parentValidationData->validation_current_state == HASH_ELEMENT_MULTISAMPLE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_NORMALIZE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_POINT_DISTANCE_ATTENUATION) || (parentValidationData->validation_current_state == HASH_ELEMENT_POINT_FADE_THRESHOLD_SIZE) || (parentValidationData->validation_current_state == HASH_ELEMENT_POINT_SIZE) || (parentValidationData->validation_current_state == HASH_ELEMENT_POINT_SIZE_MAX) || (parentValidationData->validation_current_state == HASH_ELEMENT_POINT_SIZE_MIN) || (parentValidationData->validation_current_state == HASH_ELEMENT_POINT_SMOOTH_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGON_MODE) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGON_OFFSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGON_OFFSET_FILL_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGON_OFFSET_LINE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGON_OFFSET_POINT_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGON_SMOOTH_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGON_STIPPLE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_PROJECTION_MATRIX) || (parentValidationData->validation_current_state == HASH_ELEMENT_RESCALE_NORMAL_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLE_ALPHA_TO_COVERAGE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLE_ALPHA_TO_ONE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLE_COVERAGE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SCISSOR) || (parentValidationData->validation_current_state == HASH_ELEMENT_SCISSOR_TEST_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SHADER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SHADE_MODEL) || (parentValidationData->validation_current_state == HASH_ELEMENT_STENCIL_FUNC) || (parentValidationData->validation_current_state == HASH_ELEMENT_STENCIL_FUNC_SEPARATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_STENCIL_MASK) || (parentValidationData->validation_current_state == HASH_ELEMENT_STENCIL_MASK_SEPARATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_STENCIL_OP) || (parentValidationData->validation_current_state == HASH_ELEMENT_STENCIL_OP_SEPARATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_STENCIL_TEST_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURE1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURE1D_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURE2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURE2D_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURE3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURE3D_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURECUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURECUBE_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTUREDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTUREDEPTH_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURERECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURERECT_ENABLE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURE_ENV_COLOR) || (parentValidationData->validation_current_state == HASH_ELEMENT_TEXTURE_ENV_MODE) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 179:
        {
        physics_material__ValidationData* parentValidationData = (physics_material__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 586:
        {
        physics_model__ValidationData* parentValidationData = (physics_model__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 532:
        {
        physics_scene__ValidationData* parentValidationData = (physics_scene__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 217:
        {
        plane__ValidationData* parentValidationData = (plane__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->equation < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: equation" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 540:
        {
        polygons__ValidationData* parentValidationData = (polygons__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_INPUT) || (parentValidationData->validation_current_state == HASH_ELEMENT_P) || (parentValidationData->validation_current_state == HASH_ELEMENT_PH) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 604:
        {
        polylist__ValidationData* parentValidationData = (polylist__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 534:
        {
        profile_CG__ValidationData* parentValidationData = (profile_CG__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_TECHNIQUE) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 460:
        {
        profile_COMMON__ValidationData* parentValidationData = (profile_COMMON__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_TECHNIQUE) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 393:
        {
        profile_GLES__ValidationData* parentValidationData = (profile_GLES__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_TECHNIQUE) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 286:
        {
        profile_GLSL__ValidationData* parentValidationData = (profile_GLSL__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_TECHNIQUE) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 25:
        {
        ref_attachment__ValidationData* parentValidationData = (ref_attachment__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 92:
        {
        rigid_body__ValidationData* parentValidationData = (rigid_body__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 19:
        {
        rigid_constraint__ValidationData* parentValidationData = (rigid_constraint__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique_common < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: technique_common" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 193:
        {
        scene__ValidationData* parentValidationData = (scene__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 588:
        {
        instance_rigid_body__technique_common__shape__ValidationData* parentValidationData = (instance_rigid_body__technique_common__shape__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_BOX) || (parentValidationData->validation_current_state == HASH_ELEMENT_CAPSULE) || (parentValidationData->validation_current_state == HASH_ELEMENT_CYLINDER) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_GEOMETRY) || (parentValidationData->validation_current_state == HASH_ELEMENT_PLANE) || (parentValidationData->validation_current_state == HASH_ELEMENT_ROTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SPHERE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TAPERED_CAPSULE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TAPERED_CYLINDER) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRANSLATE) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 589:
        {
        rigid_body__technique_common__shape__ValidationData* parentValidationData = (rigid_body__technique_common__shape__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_BOX) || (parentValidationData->validation_current_state == HASH_ELEMENT_CAPSULE) || (parentValidationData->validation_current_state == HASH_ELEMENT_CYLINDER) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_INSTANCE_GEOMETRY) || (parentValidationData->validation_current_state == HASH_ELEMENT_PLANE) || (parentValidationData->validation_current_state == HASH_ELEMENT_ROTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SPHERE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TAPERED_CAPSULE) || (parentValidationData->validation_current_state == HASH_ELEMENT_TAPERED_CYLINDER) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRANSLATE) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 576:
        {
        skin__ValidationData* parentValidationData = (skin__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vertex_weights < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: vertex_weights" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 529:
        {
        sphere__ValidationData* parentValidationData = (sphere__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->radius < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: radius" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 185:
        {
        spline__ValidationData* parentValidationData = (spline__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->control_vertices < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: control_vertices" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 514:
        {
        tapered_capsule__ValidationData* parentValidationData = (tapered_capsule__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->radius2 < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: radius2" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 254:
        {
        tapered_cylinder__ValidationData* parentValidationData = (tapered_cylinder__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->radius2 < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: radius2" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 50:
        {
        targets__ValidationData* parentValidationData = (targets__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->input < 2 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: input" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 317:
        {
        profile_CG__technique__ValidationData* parentValidationData = (profile_CG__technique__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_PASS) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 318:
        {
        profile_COMMON__technique__ValidationData* parentValidationData = (profile_COMMON__technique__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_BLINN) || (parentValidationData->validation_current_state == HASH_ELEMENT_CONSTANT) || (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_LAMBERT) || (parentValidationData->validation_current_state == HASH_ELEMENT_PHONG) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 319:
        {
        profile_GLES__technique__ValidationData* parentValidationData = (profile_GLES__technique__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_PASS) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 320:
        {
        profile_GLSL__technique__ValidationData* parentValidationData = (profile_GLSL__technique__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_PASS) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 24:
        {
        texture__ValidationData* parentValidationData = (texture__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 548:
        {
        triangles__ValidationData* parentValidationData = (triangles__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 618:
        {
        trifans__ValidationData* parentValidationData = (trifans__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 76:
        {
        tristrips__ValidationData* parentValidationData = (tristrips__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 296:
        {
        vertex_weights__ValidationData* parentValidationData = (vertex_weights__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->input < 2 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: input" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 332:
        {
        vertices__ValidationData* parentValidationData = (vertices__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->input < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: input" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 506:
        {
        visual_scene__ValidationData* parentValidationData = (visual_scene__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->node < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: node" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 52:
        {
        instance_animation__ValidationData* parentValidationData = (instance_animation__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 592:
        {
        sampler1D____cg_sampler1D__ValidationData* parentValidationData = (sampler1D____cg_sampler1D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 608:
        {
        sampler2D____cg_sampler2D__ValidationData* parentValidationData = (sampler2D____cg_sampler2D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 616:
        {
        sampler3D____cg_sampler3D__ValidationData* parentValidationData = (sampler3D____cg_sampler3D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 370:
        {
        samplerCUBE____cg_samplerCUBE__ValidationData* parentValidationData = (samplerCUBE____cg_samplerCUBE__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 55:
        {
        samplerDEPTH____cg_samplerDEPTH__ValidationData* parentValidationData = (samplerDEPTH____cg_samplerDEPTH__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 597:
        {
        samplerRECT____cg_samplerRECT__ValidationData* parentValidationData = (samplerRECT____cg_samplerRECT__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 496:
        {
        surface____cg_surface_type__ValidationData* parentValidationData = (surface____cg_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT_HINT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_NULL) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_TARGET) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_CUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_PLANAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_VOLUME) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIPMAP_GENERATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_LEVELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_SIZE) || (parentValidationData->validation_current_state == HASH_ELEMENT_VIEWPORT_RATIO) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 593:
        {
        sampler1D____fx_sampler1D_common__ValidationData* parentValidationData = (sampler1D____fx_sampler1D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 609:
        {
        sampler2D____fx_sampler2D_common__ValidationData* parentValidationData = (sampler2D____fx_sampler2D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 617:
        {
        sampler3D____fx_sampler3D_common__ValidationData* parentValidationData = (sampler3D____fx_sampler3D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 371:
        {
        samplerCUBE____fx_samplerCUBE_common__ValidationData* parentValidationData = (samplerCUBE____fx_samplerCUBE_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 56:
        {
        samplerDEPTH____fx_samplerDEPTH_common__ValidationData* parentValidationData = (samplerDEPTH____fx_samplerDEPTH_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 598:
        {
        samplerRECT____fx_samplerRECT_common__ValidationData* parentValidationData = (samplerRECT____fx_samplerRECT_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 497:
        {
        surface____fx_surface_common__ValidationData* parentValidationData = (surface____fx_surface_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT_HINT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_NULL) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_TARGET) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_CUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_PLANAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_VOLUME) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIPMAP_GENERATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_LEVELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_SIZE) || (parentValidationData->validation_current_state == HASH_ELEMENT_VIEWPORT_RATIO) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        case 59:
        {
        format_hint__ValidationData* parentValidationData = (format_hint__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->range < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: range" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 257:
        {
        sampler1D____gl_sampler1D__ValidationData* parentValidationData = (sampler1D____gl_sampler1D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 258:
        {
        sampler2D____gl_sampler2D__ValidationData* parentValidationData = (sampler2D____gl_sampler2D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 259:
        {
        sampler3D____gl_sampler3D__ValidationData* parentValidationData = (sampler3D____gl_sampler3D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 260:
        {
        samplerCUBE____gl_samplerCUBE__ValidationData* parentValidationData = (samplerCUBE____gl_samplerCUBE__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 57:
        {
        samplerDEPTH____gl_samplerDEPTH__ValidationData* parentValidationData = (samplerDEPTH____gl_samplerDEPTH__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 261:
        {
        samplerRECT____gl_samplerRECT__ValidationData* parentValidationData = (samplerRECT____gl_samplerRECT__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        parentValidationData->extra++;

        break;
        }

        case 538:
        {
        sampler_state____gles_sampler_state__ValidationData* parentValidationData = (sampler_state____gles_sampler_state__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 187:
        {
        texture_pipeline____gles_texture_pipeline__ValidationData* parentValidationData = (texture_pipeline____gles_texture_pipeline__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 60:
        {
        texture_unit__ValidationData* parentValidationData = (texture_unit__ValidationData*)mValidationDataStack.top();
        parentValidationData->extra++;

        break;
        }

        case 498:
        {
        surface____glsl_surface_type__ValidationData* parentValidationData = (surface____glsl_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_EXTRA) || (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT_HINT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_NULL) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_TARGET) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_CUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_PLANAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_VOLUME) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIPMAP_GENERATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_LEVELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_SIZE) || (parentValidationData->validation_current_state == HASH_ELEMENT_VIEWPORT_RATIO) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_EXTRA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_EXTRA;
        }
//        parentValidationData->extra++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        extra__ValidationData* validationData = (extra__ValidationData*)mValidationDataStack.newObject(sizeof(extra__ValidationData));
        memset(validationData, 0, sizeof(extra__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__extra()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        extra__ValidationData* validationData = (extra__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->technique < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_EXTRA, (const ParserChar*)0, "child: technique" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__library_animation_clips( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        COLLADA__ValidationData* parentValidationData = (COLLADA__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATIONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CAMERAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CONTROLLERS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_EFFECTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_FORCE_FIELDS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_GEOMETRIES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_IMAGES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_LIGHTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_NODES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MODELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_SCENES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_VISUAL_SCENES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS;
        }
//        parentValidationData->library_animation_clips++;

        library_animation_clips__ValidationData* validationData = (library_animation_clips__ValidationData*)mValidationDataStack.newObject(sizeof(library_animation_clips__ValidationData));
        memset(validationData, 0, sizeof(library_animation_clips__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__library_animation_clips()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        library_animation_clips__ValidationData* validationData = (library_animation_clips__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->animation_clip < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS, (const ParserChar*)0, "child: animation_clip" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__animation_clip( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        library_animation_clips__ValidationData* parentValidationData = (library_animation_clips__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANIMATION_CLIP, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->animation_clip++;

        animation_clip__ValidationData* validationData = (animation_clip__ValidationData*)mValidationDataStack.newObject(sizeof(animation_clip__ValidationData));
        memset(validationData, 0, sizeof(animation_clip__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__animation_clip()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        animation_clip__ValidationData* validationData = (animation_clip__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->instance_animation < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_ANIMATION_CLIP, (const ParserChar*)0, "child: instance_animation" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__instance_animation( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        animation_clip__ValidationData* parentValidationData = (animation_clip__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INSTANCE_ANIMATION, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->instance_animation++;

        instance_animation__ValidationData* validationData = (instance_animation__ValidationData*)mValidationDataStack.newObject(sizeof(instance_animation__ValidationData));
        memset(validationData, 0, sizeof(instance_animation__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__instance_animation()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        instance_animation__ValidationData* validationData = (instance_animation__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__library_cameras( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        COLLADA__ValidationData* parentValidationData = (COLLADA__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATIONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CAMERAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CONTROLLERS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_EFFECTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_FORCE_FIELDS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_GEOMETRIES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_IMAGES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_LIGHTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_NODES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MODELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_SCENES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_VISUAL_SCENES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_LIBRARY_CAMERAS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_LIBRARY_CAMERAS;
        }
//        parentValidationData->library_cameras++;

        library_cameras__ValidationData* validationData = (library_cameras__ValidationData*)mValidationDataStack.newObject(sizeof(library_cameras__ValidationData));
        memset(validationData, 0, sizeof(library_cameras__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__library_cameras()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        library_cameras__ValidationData* validationData = (library_cameras__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->camera < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_LIBRARY_CAMERAS, (const ParserChar*)0, "child: camera" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__camera( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        library_cameras__ValidationData* parentValidationData = (library_cameras__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CAMERA, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->camera++;

        camera__ValidationData* validationData = (camera__ValidationData*)mValidationDataStack.newObject(sizeof(camera__ValidationData));
        memset(validationData, 0, sizeof(camera__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__camera()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        camera__ValidationData* validationData = (camera__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->optics < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_CAMERA, (const ParserChar*)0, "child: optics" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__optics( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        camera__ValidationData* parentValidationData = (camera__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->imager != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_OPTICS, (const ParserChar*)0, "sibling: imager" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_OPTICS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->optics >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_OPTICS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->optics++;

        optics__ValidationData* validationData = (optics__ValidationData*)mValidationDataStack.newObject(sizeof(optics__ValidationData));
        memset(validationData, 0, sizeof(optics__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__optics()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        optics__ValidationData* validationData = (optics__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->technique_common < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_OPTICS, (const ParserChar*)0, "child: technique_common" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__optics__technique_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        optics__ValidationData* parentValidationData = (optics__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->technique != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE_COMMON, (const ParserChar*)0, "sibling: technique" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TECHNIQUE_COMMON, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->technique_common >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_TECHNIQUE_COMMON, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->technique_common++;

        optics__technique_common__ValidationData* validationData = (optics__technique_common__ValidationData*)mValidationDataStack.newObject(sizeof(optics__technique_common__ValidationData));
        memset(validationData, 0, sizeof(optics__technique_common__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__optics__technique_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        optics__technique_common__ValidationData* validationData = (optics__technique_common__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->orthographic != 0 )
            if ( validationData->orthographic < 1 ) // children minOccurs
                if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_TECHNIQUE_COMMON, (const ParserChar*)0, "child: orthographic" ) )
                    return false;
        if ( validationData->perspective != 0 )
            if ( validationData->perspective < 1 ) // children minOccurs
                if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_TECHNIQUE_COMMON, (const ParserChar*)0, "child: perspective" ) )
                    return false;
        if ( validationData->orthographic == 0 && validationData->perspective == 0 ) // no child present
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_NO_CHILD_PRESENT, HASH_ELEMENT_TECHNIQUE_COMMON, (const ParserChar*)0, 0 ) )
                return false;

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__orthographic( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        optics__technique_common__ValidationData* parentValidationData = (optics__technique_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->perspective != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ORTHOGRAPHIC, (const ParserChar*)0, "sibling: perspective" ) )
                return false;
        }
        if ( parentValidationData->orthographic >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ORTHOGRAPHIC, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->orthographic++;

        orthographic__ValidationData* validationData = (orthographic__ValidationData*)mValidationDataStack.newObject(sizeof(orthographic__ValidationData));
        memset(validationData, 0, sizeof(orthographic__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__orthographic()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        orthographic__ValidationData* validationData = (orthographic__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_ZFAR) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_ORTHOGRAPHIC, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__xmag( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        orthographic__ValidationData* parentValidationData = (orthographic__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_XMAG, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_XMAG;
        }
//        parentValidationData->xmag++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__xmag()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__ymag( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        orthographic__ValidationData* parentValidationData = (orthographic__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_XMAG) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_YMAG, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_YMAG;
        }
//        parentValidationData->ymag++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__ymag()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__aspect_ratio( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 565:
        {
        orthographic__ValidationData* parentValidationData = (orthographic__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_XMAG) || (parentValidationData->validation_current_state == HASH_ELEMENT_YMAG) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASPECT_RATIO, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASPECT_RATIO;
        }
//        parentValidationData->aspect_ratio++;

        break;
        }

        case 80:
        {
        perspective__ValidationData* parentValidationData = (perspective__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_XFOV) || (parentValidationData->validation_current_state == HASH_ELEMENT_YFOV) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ASPECT_RATIO, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ASPECT_RATIO;
        }
//        parentValidationData->aspect_ratio++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__aspect_ratio()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__znear( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 565:
        {
        orthographic__ValidationData* parentValidationData = (orthographic__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASPECT_RATIO) || (parentValidationData->validation_current_state == HASH_ELEMENT_XMAG) || (parentValidationData->validation_current_state == HASH_ELEMENT_YMAG) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ZNEAR, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ZNEAR;
        }
//        parentValidationData->znear++;

        break;
        }

        case 80:
        {
        perspective__ValidationData* parentValidationData = (perspective__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASPECT_RATIO) || (parentValidationData->validation_current_state == HASH_ELEMENT_XFOV) || (parentValidationData->validation_current_state == HASH_ELEMENT_YFOV) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ZNEAR, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ZNEAR;
        }
//        parentValidationData->znear++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__znear()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__zfar( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 565:
        {
        orthographic__ValidationData* parentValidationData = (orthographic__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ZNEAR) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ZFAR, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ZFAR;
        }
//        parentValidationData->zfar++;

        break;
        }

        case 80:
        {
        perspective__ValidationData* parentValidationData = (perspective__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ZNEAR) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ZFAR, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ZFAR;
        }
//        parentValidationData->zfar++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__zfar()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__perspective( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        optics__technique_common__ValidationData* parentValidationData = (optics__technique_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->orthographic != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_PERSPECTIVE, (const ParserChar*)0, "sibling: orthographic" ) )
                return false;
        }
        if ( parentValidationData->perspective >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_PERSPECTIVE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->perspective++;

        perspective__ValidationData* validationData = (perspective__ValidationData*)mValidationDataStack.newObject(sizeof(perspective__ValidationData));
        memset(validationData, 0, sizeof(perspective__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__perspective()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        perspective__ValidationData* validationData = (perspective__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_ZFAR) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_PERSPECTIVE, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__xfov( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        perspective__ValidationData* parentValidationData = (perspective__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_XFOV, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_XFOV;
        }
//        parentValidationData->xfov++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__xfov()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__yfov( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        perspective__ValidationData* parentValidationData = (perspective__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_XFOV) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_YFOV, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_YFOV;
        }
//        parentValidationData->yfov++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__yfov()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__imager( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        camera__ValidationData* parentValidationData = (camera__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->optics < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_IMAGER, (const ParserChar*)0, "sibling: optics" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_IMAGER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->imager >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_IMAGER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->imager++;

        imager__ValidationData* validationData = (imager__ValidationData*)mValidationDataStack.newObject(sizeof(imager__ValidationData));
        memset(validationData, 0, sizeof(imager__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__imager()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        imager__ValidationData* validationData = (imager__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->technique < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_IMAGER, (const ParserChar*)0, "child: technique" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__library_controllers( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        COLLADA__ValidationData* parentValidationData = (COLLADA__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATIONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CAMERAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CONTROLLERS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_EFFECTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_FORCE_FIELDS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_GEOMETRIES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_IMAGES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_LIGHTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_NODES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MODELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_SCENES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_VISUAL_SCENES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_LIBRARY_CONTROLLERS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_LIBRARY_CONTROLLERS;
        }
//        parentValidationData->library_controllers++;

        library_controllers__ValidationData* validationData = (library_controllers__ValidationData*)mValidationDataStack.newObject(sizeof(library_controllers__ValidationData));
        memset(validationData, 0, sizeof(library_controllers__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__library_controllers()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        library_controllers__ValidationData* validationData = (library_controllers__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->controller < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_LIBRARY_CONTROLLERS, (const ParserChar*)0, "child: controller" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__controller( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        library_controllers__ValidationData* parentValidationData = (library_controllers__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONTROLLER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->controller++;

        controller__ValidationData* validationData = (controller__ValidationData*)mValidationDataStack.newObject(sizeof(controller__ValidationData));
        memset(validationData, 0, sizeof(controller__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__controller()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        controller__ValidationData* validationData = (controller__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_EXTRA) || (validationData->validation_current_state == HASH_ELEMENT_MORPH) || (validationData->validation_current_state == HASH_ELEMENT_SKIN) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_CONTROLLER, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__skin( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        controller__ValidationData* parentValidationData = (controller__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SKIN, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SKIN;
        }
//        parentValidationData->skin++;

        skin__ValidationData* validationData = (skin__ValidationData*)mValidationDataStack.newObject(sizeof(skin__ValidationData));
        memset(validationData, 0, sizeof(skin__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__skin()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        skin__ValidationData* validationData = (skin__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->source < 3 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SKIN, (const ParserChar*)0, "child: source" ) )
                return false;
        }
        if ( validationData->joints < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SKIN, (const ParserChar*)0, "child: joints" ) )
                return false;
        }
        if ( validationData->vertex_weights < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SKIN, (const ParserChar*)0, "child: vertex_weights" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float4x4( const float* value, size_t length )
{
    if( length < 16 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 16 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float4x4__stream( const float* value, size_t length )
{

    if( length > 16 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float4x4__streamEnd( const float* value, size_t length )
{
    if( length < 16 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 16 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__bind_shape_matrix( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        skin__ValidationData* parentValidationData = (skin__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BIND_SHAPE_MATRIX, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->joints != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BIND_SHAPE_MATRIX, (const ParserChar*)0, "sibling: joints" ) )
                return false;
        }
        if ( parentValidationData->vertex_weights != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BIND_SHAPE_MATRIX, (const ParserChar*)0, "sibling: vertex_weights" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BIND_SHAPE_MATRIX, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->bind_shape_matrix >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_BIND_SHAPE_MATRIX, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->bind_shape_matrix++;

        bind_shape_matrix__ValidationData* validationData = (bind_shape_matrix__ValidationData*)mValidationDataStack.newObject(sizeof(bind_shape_matrix__ValidationData));
        memset(validationData, 0, sizeof(bind_shape_matrix__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__bind_shape_matrix()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__joints( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        skin__ValidationData* parentValidationData = (skin__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 3 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_JOINTS, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->vertex_weights != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_JOINTS, (const ParserChar*)0, "sibling: vertex_weights" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_JOINTS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->joints >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_JOINTS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->joints++;

        joints__ValidationData* validationData = (joints__ValidationData*)mValidationDataStack.newObject(sizeof(joints__ValidationData));
        memset(validationData, 0, sizeof(joints__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__joints()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        joints__ValidationData* validationData = (joints__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->input < 2 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_JOINTS, (const ParserChar*)0, "child: input" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__vertex_weights( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        skin__ValidationData* parentValidationData = (skin__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->joints < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_VERTEX_WEIGHTS, (const ParserChar*)0, "sibling: joints" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VERTEX_WEIGHTS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->vertex_weights >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_VERTEX_WEIGHTS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->vertex_weights++;

        vertex_weights__ValidationData* validationData = (vertex_weights__ValidationData*)mValidationDataStack.newObject(sizeof(vertex_weights__ValidationData));
        memset(validationData, 0, sizeof(vertex_weights__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__vertex_weights()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        vertex_weights__ValidationData* validationData = (vertex_weights__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->input < 2 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_VERTEX_WEIGHTS, (const ParserChar*)0, "child: input" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__input____InputLocalOffset( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 38:
        {
        lines__ValidationData* parentValidationData = (lines__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 48:
        {
        linestrips__ValidationData* parentValidationData = (linestrips__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 540:
        {
        polygons__ValidationData* parentValidationData = (polygons__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_INPUT) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INPUT;
        }
//        parentValidationData->input++;

        break;
        }

        case 604:
        {
        polylist__ValidationData* parentValidationData = (polylist__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vcount != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: vcount" ) )
                return false;
        }
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 548:
        {
        triangles__ValidationData* parentValidationData = (triangles__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 618:
        {
        trifans__ValidationData* parentValidationData = (trifans__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 76:
        {
        tristrips__ValidationData* parentValidationData = (tristrips__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        case 296:
        {
        vertex_weights__ValidationData* parentValidationData = (vertex_weights__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->vcount != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: vcount" ) )
                return false;
        }
        if ( parentValidationData->v != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: v" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_INPUT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->input++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__input____InputLocalOffset()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__vcount( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 604:
        {
        polylist__ValidationData* parentValidationData = (polylist__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->vcount >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->vcount++;

        break;
        }

        case 296:
        {
        vertex_weights__ValidationData* parentValidationData = (vertex_weights__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->input < 2 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: input" ) )
                return false;
        }
        if ( parentValidationData->v != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: v" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->vcount >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_VCOUNT, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->vcount++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__vcount()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__v( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        vertex_weights__ValidationData* parentValidationData = (vertex_weights__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->input < 2 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_V, (const ParserChar*)0, "sibling: input" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_V, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->v >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_V, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->v++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__v()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__MorphMethodType( ParserString value )
{
    return validate__MorphMethodType( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__MorphMethodType( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__MorphMethodType__stream( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__MorphMethodType__streamEnd( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__morph( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        controller__ValidationData* parentValidationData = (controller__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_MORPH, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_MORPH;
        }
//        parentValidationData->morph++;

        morph__ValidationData* validationData = (morph__ValidationData*)mValidationDataStack.newObject(sizeof(morph__ValidationData));
        memset(validationData, 0, sizeof(morph__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__morph()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        morph__ValidationData* validationData = (morph__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->source < 2 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_MORPH, (const ParserChar*)0, "child: source" ) )
                return false;
        }
        if ( validationData->targets < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_MORPH, (const ParserChar*)0, "child: targets" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__targets( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        morph__ValidationData* parentValidationData = (morph__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 2 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_TARGETS, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_TARGETS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->targets >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_TARGETS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->targets++;

        targets__ValidationData* validationData = (targets__ValidationData*)mValidationDataStack.newObject(sizeof(targets__ValidationData));
        memset(validationData, 0, sizeof(targets__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__targets()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        targets__ValidationData* validationData = (targets__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->input < 2 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_TARGETS, (const ParserChar*)0, "child: input" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__library_geometries( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        COLLADA__ValidationData* parentValidationData = (COLLADA__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATIONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CAMERAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CONTROLLERS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_EFFECTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_FORCE_FIELDS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_GEOMETRIES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_IMAGES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_LIGHTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_NODES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MODELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_SCENES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_VISUAL_SCENES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_LIBRARY_GEOMETRIES, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_LIBRARY_GEOMETRIES;
        }
//        parentValidationData->library_geometries++;

        library_geometries__ValidationData* validationData = (library_geometries__ValidationData*)mValidationDataStack.newObject(sizeof(library_geometries__ValidationData));
        memset(validationData, 0, sizeof(library_geometries__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__library_geometries()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        library_geometries__ValidationData* validationData = (library_geometries__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->geometry < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_LIBRARY_GEOMETRIES, (const ParserChar*)0, "child: geometry" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__geometry( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        library_geometries__ValidationData* parentValidationData = (library_geometries__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_GEOMETRY, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->geometry++;

        geometry__ValidationData* validationData = (geometry__ValidationData*)mValidationDataStack.newObject(sizeof(geometry__ValidationData));
        memset(validationData, 0, sizeof(geometry__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__geometry()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        geometry__ValidationData* validationData = (geometry__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_CONVEX_MESH) || (validationData->validation_current_state == HASH_ELEMENT_EXTRA) || (validationData->validation_current_state == HASH_ELEMENT_MESH) || (validationData->validation_current_state == HASH_ELEMENT_SPLINE) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_GEOMETRY, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__convex_mesh( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        geometry__ValidationData* parentValidationData = (geometry__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_CONVEX_MESH, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_CONVEX_MESH;
        }
//        parentValidationData->convex_mesh++;

        convex_mesh__ValidationData* validationData = (convex_mesh__ValidationData*)mValidationDataStack.newObject(sizeof(convex_mesh__ValidationData));
        memset(validationData, 0, sizeof(convex_mesh__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__convex_mesh()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        convex_mesh__ValidationData* validationData = (convex_mesh__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_EXTRA) || (validationData->validation_current_state == HASH_ELEMENT_LINES) || (validationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (validationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (validationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (validationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (validationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (validationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (validationData->validation_current_state == HASH_ELEMENT_VERTICES) || (validationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_CONVEX_MESH, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__vertices( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 297:
        {
        convex_mesh__ValidationData* parentValidationData = (convex_mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_SOURCE) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_VERTICES, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_VERTICES;
        }
//        parentValidationData->vertices++;

        break;
        }

        case 266:
        {
        mesh__ValidationData* parentValidationData = (mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_SOURCE) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_VERTICES, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_VERTICES;
        }
//        parentValidationData->vertices++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        vertices__ValidationData* validationData = (vertices__ValidationData*)mValidationDataStack.newObject(sizeof(vertices__ValidationData));
        memset(validationData, 0, sizeof(vertices__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__vertices()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        vertices__ValidationData* validationData = (vertices__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->input < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_VERTICES, (const ParserChar*)0, "child: input" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__lines( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 297:
        {
        convex_mesh__ValidationData* parentValidationData = (convex_mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_LINES, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_LINES;
        }
//        parentValidationData->lines++;

        break;
        }

        case 266:
        {
        mesh__ValidationData* parentValidationData = (mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_LINES, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_LINES;
        }
//        parentValidationData->lines++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        lines__ValidationData* validationData = (lines__ValidationData*)mValidationDataStack.newObject(sizeof(lines__ValidationData));
        memset(validationData, 0, sizeof(lines__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__lines()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        lines__ValidationData* validationData = (lines__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__p( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 38:
        {
        lines__ValidationData* parentValidationData = (lines__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->p >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_P, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->p++;

        break;
        }

        case 48:
        {
        linestrips__ValidationData* parentValidationData = (linestrips__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->p++;

        break;
        }

        case 197:
        {
        ph__ValidationData* parentValidationData = (ph__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->h != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: h" ) )
                return false;
        }
        if ( parentValidationData->p >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_P, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->p++;

        break;
        }

        case 540:
        {
        polygons__ValidationData* parentValidationData = (polygons__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_INPUT) || (parentValidationData->validation_current_state == HASH_ELEMENT_P) || (parentValidationData->validation_current_state == HASH_ELEMENT_PH) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_P, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_P;
        }
//        parentValidationData->p++;

        break;
        }

        case 604:
        {
        polylist__ValidationData* parentValidationData = (polylist__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->p >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_P, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->p++;

        break;
        }

        case 548:
        {
        triangles__ValidationData* parentValidationData = (triangles__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->p >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_P, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->p++;

        break;
        }

        case 618:
        {
        trifans__ValidationData* parentValidationData = (trifans__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->p++;

        break;
        }

        case 76:
        {
        tristrips__ValidationData* parentValidationData = (tristrips__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_P, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->p++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__p()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__linestrips( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 297:
        {
        convex_mesh__ValidationData* parentValidationData = (convex_mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_LINESTRIPS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_LINESTRIPS;
        }
//        parentValidationData->linestrips++;

        break;
        }

        case 266:
        {
        mesh__ValidationData* parentValidationData = (mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_LINESTRIPS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_LINESTRIPS;
        }
//        parentValidationData->linestrips++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        linestrips__ValidationData* validationData = (linestrips__ValidationData*)mValidationDataStack.newObject(sizeof(linestrips__ValidationData));
        memset(validationData, 0, sizeof(linestrips__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__linestrips()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        linestrips__ValidationData* validationData = (linestrips__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__polygons( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 297:
        {
        convex_mesh__ValidationData* parentValidationData = (convex_mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_POLYGONS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_POLYGONS;
        }
//        parentValidationData->polygons++;

        break;
        }

        case 266:
        {
        mesh__ValidationData* parentValidationData = (mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_POLYGONS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_POLYGONS;
        }
//        parentValidationData->polygons++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        polygons__ValidationData* validationData = (polygons__ValidationData*)mValidationDataStack.newObject(sizeof(polygons__ValidationData));
        memset(validationData, 0, sizeof(polygons__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__polygons()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        polygons__ValidationData* validationData = (polygons__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_EXTRA) || (validationData->validation_current_state == HASH_ELEMENT_INPUT) || (validationData->validation_current_state == HASH_ELEMENT_P) || (validationData->validation_current_state == HASH_ELEMENT_PH) || (validationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_POLYGONS, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__ph( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        polygons__ValidationData* parentValidationData = (polygons__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_INPUT) || (parentValidationData->validation_current_state == HASH_ELEMENT_P) || (parentValidationData->validation_current_state == HASH_ELEMENT_PH) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_PH, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_PH;
        }
//        parentValidationData->ph++;

        ph__ValidationData* validationData = (ph__ValidationData*)mValidationDataStack.newObject(sizeof(ph__ValidationData));
        memset(validationData, 0, sizeof(ph__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__ph()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        ph__ValidationData* validationData = (ph__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->p < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_PH, (const ParserChar*)0, "child: p" ) )
                return false;
        }
        if ( validationData->h < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_PH, (const ParserChar*)0, "child: h" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__h( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        ph__ValidationData* parentValidationData = (ph__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->p < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_H, (const ParserChar*)0, "sibling: p" ) )
                return false;
        }
        parentValidationData->h++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__h()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__polylist( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 297:
        {
        convex_mesh__ValidationData* parentValidationData = (convex_mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_POLYLIST, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_POLYLIST;
        }
//        parentValidationData->polylist++;

        break;
        }

        case 266:
        {
        mesh__ValidationData* parentValidationData = (mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_POLYLIST, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_POLYLIST;
        }
//        parentValidationData->polylist++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        polylist__ValidationData* validationData = (polylist__ValidationData*)mValidationDataStack.newObject(sizeof(polylist__ValidationData));
        memset(validationData, 0, sizeof(polylist__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__polylist()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        polylist__ValidationData* validationData = (polylist__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__triangles( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 297:
        {
        convex_mesh__ValidationData* parentValidationData = (convex_mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_TRIANGLES, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_TRIANGLES;
        }
//        parentValidationData->triangles++;

        break;
        }

        case 266:
        {
        mesh__ValidationData* parentValidationData = (mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_TRIANGLES, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_TRIANGLES;
        }
//        parentValidationData->triangles++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        triangles__ValidationData* validationData = (triangles__ValidationData*)mValidationDataStack.newObject(sizeof(triangles__ValidationData));
        memset(validationData, 0, sizeof(triangles__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__triangles()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        triangles__ValidationData* validationData = (triangles__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__trifans( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 297:
        {
        convex_mesh__ValidationData* parentValidationData = (convex_mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_TRIFANS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_TRIFANS;
        }
//        parentValidationData->trifans++;

        break;
        }

        case 266:
        {
        mesh__ValidationData* parentValidationData = (mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_TRIFANS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_TRIFANS;
        }
//        parentValidationData->trifans++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        trifans__ValidationData* validationData = (trifans__ValidationData*)mValidationDataStack.newObject(sizeof(trifans__ValidationData));
        memset(validationData, 0, sizeof(trifans__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__trifans()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        trifans__ValidationData* validationData = (trifans__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__tristrips( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 297:
        {
        convex_mesh__ValidationData* parentValidationData = (convex_mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_TRISTRIPS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_TRISTRIPS;
        }
//        parentValidationData->tristrips++;

        break;
        }

        case 266:
        {
        mesh__ValidationData* parentValidationData = (mesh__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_LINES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (parentValidationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_TRISTRIPS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_TRISTRIPS;
        }
//        parentValidationData->tristrips++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        tristrips__ValidationData* validationData = (tristrips__ValidationData*)mValidationDataStack.newObject(sizeof(tristrips__ValidationData));
        memset(validationData, 0, sizeof(tristrips__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__tristrips()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        tristrips__ValidationData* validationData = (tristrips__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__mesh( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        geometry__ValidationData* parentValidationData = (geometry__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_MESH, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_MESH;
        }
//        parentValidationData->mesh++;

        mesh__ValidationData* validationData = (mesh__ValidationData*)mValidationDataStack.newObject(sizeof(mesh__ValidationData));
        memset(validationData, 0, sizeof(mesh__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__mesh()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        mesh__ValidationData* validationData = (mesh__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_EXTRA) || (validationData->validation_current_state == HASH_ELEMENT_LINES) || (validationData->validation_current_state == HASH_ELEMENT_LINESTRIPS) || (validationData->validation_current_state == HASH_ELEMENT_POLYGONS) || (validationData->validation_current_state == HASH_ELEMENT_POLYLIST) || (validationData->validation_current_state == HASH_ELEMENT_TRIANGLES) || (validationData->validation_current_state == HASH_ELEMENT_TRIFANS) || (validationData->validation_current_state == HASH_ELEMENT_TRISTRIPS) || (validationData->validation_current_state == HASH_ELEMENT_VERTICES) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_MESH, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__spline( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        geometry__ValidationData* parentValidationData = (geometry__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SPLINE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SPLINE;
        }
//        parentValidationData->spline++;

        spline__ValidationData* validationData = (spline__ValidationData*)mValidationDataStack.newObject(sizeof(spline__ValidationData));
        memset(validationData, 0, sizeof(spline__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__spline()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        spline__ValidationData* validationData = (spline__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->source < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SPLINE, (const ParserChar*)0, "child: source" ) )
                return false;
        }
        if ( validationData->control_vertices < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SPLINE, (const ParserChar*)0, "child: control_vertices" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__control_vertices( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        spline__ValidationData* parentValidationData = (spline__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_CONTROL_VERTICES, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CONTROL_VERTICES, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->control_vertices >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_CONTROL_VERTICES, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->control_vertices++;

        control_vertices__ValidationData* validationData = (control_vertices__ValidationData*)mValidationDataStack.newObject(sizeof(control_vertices__ValidationData));
        memset(validationData, 0, sizeof(control_vertices__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__control_vertices()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        control_vertices__ValidationData* validationData = (control_vertices__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->input < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_CONTROL_VERTICES, (const ParserChar*)0, "child: input" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__library_effects( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        COLLADA__ValidationData* parentValidationData = (COLLADA__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATIONS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CAMERAS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_CONTROLLERS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_EFFECTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_FORCE_FIELDS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_GEOMETRIES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_IMAGES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_LIGHTS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_NODES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MATERIALS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_MODELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_PHYSICS_SCENES) || (parentValidationData->validation_current_state == HASH_ELEMENT_LIBRARY_VISUAL_SCENES) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_LIBRARY_EFFECTS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_LIBRARY_EFFECTS;
        }
//        parentValidationData->library_effects++;

        library_effects__ValidationData* validationData = (library_effects__ValidationData*)mValidationDataStack.newObject(sizeof(library_effects__ValidationData));
        memset(validationData, 0, sizeof(library_effects__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__library_effects()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        library_effects__ValidationData* validationData = (library_effects__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->effect < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_LIBRARY_EFFECTS, (const ParserChar*)0, "child: effect" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__effect( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        library_effects__ValidationData* parentValidationData = (library_effects__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_EFFECT, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->effect++;

        effect__ValidationData* validationData = (effect__ValidationData*)mValidationDataStack.newObject(sizeof(effect__ValidationData));
        memset(validationData, 0, sizeof(effect__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__effect()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        effect__ValidationData* validationData = (effect__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->fx_profile_abstract < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_EFFECT, (const ParserChar*)0, "child: fx_profile_abstract" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__annotate( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 487:
        {
        effect__ValidationData* parentValidationData = (effect__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->image != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: image" ) )
                return false;
        }
        if ( parentValidationData->newparam != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: newparam" ) )
                return false;
        }
        if ( parentValidationData->fx_profile_abstract != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: fx_profile_abstract" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->annotate++;

        break;
        }

        case 298:
        {
        cg_surface_type____generator__ValidationData* parentValidationData = (cg_surface_type____generator__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANNOTATE;
        }
//        parentValidationData->annotate++;

        break;
        }

        case 299:
        {
        glsl_surface_type____generator__ValidationData* parentValidationData = (glsl_surface_type____generator__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANNOTATE;
        }
//        parentValidationData->annotate++;

        break;
        }

        case 300:
        {
        profile_CG__technique__pass__ValidationData* parentValidationData = (profile_CG__technique__pass__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANNOTATE;
        }
//        parentValidationData->annotate++;

        break;
        }

        case 301:
        {
        profile_GLES__technique__pass__ValidationData* parentValidationData = (profile_GLES__technique__pass__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANNOTATE;
        }
//        parentValidationData->annotate++;

        break;
        }

        case 302:
        {
        profile_GLSL__technique__pass__ValidationData* parentValidationData = (profile_GLSL__technique__pass__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANNOTATE;
        }
//        parentValidationData->annotate++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANNOTATE;
        }
//        parentValidationData->annotate++;

        break;
        }

        case 180:
        {
        profile_CG__technique__pass__shader__ValidationData* parentValidationData = (profile_CG__technique__pass__shader__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANNOTATE;
        }
//        parentValidationData->annotate++;

        break;
        }

        case 181:
        {
        profile_GLSL__technique__pass__shader__ValidationData* parentValidationData = (profile_GLSL__technique__pass__shader__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANNOTATE;
        }
//        parentValidationData->annotate++;

        break;
        }

        case 317:
        {
        profile_CG__technique__ValidationData* parentValidationData = (profile_CG__technique__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANNOTATE;
        }
//        parentValidationData->annotate++;

        break;
        }

        case 319:
        {
        profile_GLES__technique__ValidationData* parentValidationData = (profile_GLES__technique__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANNOTATE;
        }
//        parentValidationData->annotate++;

        break;
        }

        case 320:
        {
        profile_GLSL__technique__ValidationData* parentValidationData = (profile_GLSL__technique__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANNOTATE;
        }
//        parentValidationData->annotate++;

        break;
        }

        case 147:
        {
        newparam____cg_newparam__ValidationData* parentValidationData = (newparam____cg_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANNOTATE;
        }
//        parentValidationData->annotate++;

        break;
        }

        case 472:
        {
        setparam____cg_setparam_simple__ValidationData* parentValidationData = (setparam____cg_setparam_simple__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANNOTATE;
        }
//        parentValidationData->annotate++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANNOTATE;
        }
//        parentValidationData->annotate++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANNOTATE;
        }
//        parentValidationData->annotate++;

        break;
        }

        case 151:
        {
        newparam____glsl_newparam__ValidationData* parentValidationData = (newparam____glsl_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANNOTATE;
        }
//        parentValidationData->annotate++;

        break;
        }

        case 473:
        {
        setparam____glsl_setparam__ValidationData* parentValidationData = (setparam____glsl_setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANNOTATE;
        }
//        parentValidationData->annotate++;

        break;
        }

        case 474:
        {
        setparam____glsl_setparam_simple__ValidationData* parentValidationData = (setparam____glsl_setparam_simple__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_ANNOTATE;
        }
//        parentValidationData->annotate++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        annotate__ValidationData* validationData = (annotate__ValidationData*)mValidationDataStack.newObject(sizeof(annotate__ValidationData));
        memset(validationData, 0, sizeof(annotate__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__annotate()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        annotate__ValidationData* validationData = (annotate__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_BOOL) || (validationData->validation_current_state == HASH_ELEMENT_BOOL2) || (validationData->validation_current_state == HASH_ELEMENT_BOOL3) || (validationData->validation_current_state == HASH_ELEMENT_BOOL4) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (validationData->validation_current_state == HASH_ELEMENT_INT) || (validationData->validation_current_state == HASH_ELEMENT_INT2) || (validationData->validation_current_state == HASH_ELEMENT_INT3) || (validationData->validation_current_state == HASH_ELEMENT_INT4) || (validationData->validation_current_state == HASH_ELEMENT_STRING) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_ANNOTATE, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__bool____bool( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL;
        }
//        parentValidationData->_bool++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL;
        }
//        parentValidationData->_bool++;

        break;
        }

        case 126:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL;
        }
//        parentValidationData->_bool++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL;
        }
//        parentValidationData->_bool++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL;
        }
//        parentValidationData->_bool++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__bool____bool()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__bool2( const bool* value, size_t length )
{
    if( length < 2 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 2 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__bool2__stream( const bool* value, size_t length )
{

    if( length > 2 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__bool2__streamEnd( const bool* value, size_t length )
{
    if( length < 2 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 2 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__bool2____bool2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL2;
        }
//        parentValidationData->bool2++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL2;
        }
//        parentValidationData->bool2++;

        break;
        }

        case 126:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL2;
        }
//        parentValidationData->bool2++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL2;
        }
//        parentValidationData->bool2++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL2;
        }
//        parentValidationData->bool2++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        bool2____bool2__ValidationData* validationData = (bool2____bool2__ValidationData*)mValidationDataStack.newObject(sizeof(bool2____bool2__ValidationData));
        memset(validationData, 0, sizeof(bool2____bool2__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__bool2____bool2()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__bool3( const bool* value, size_t length )
{
    if( length < 3 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 3 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__bool3__stream( const bool* value, size_t length )
{

    if( length > 3 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__bool3__streamEnd( const bool* value, size_t length )
{
    if( length < 3 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 3 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__bool3____bool3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL3;
        }
//        parentValidationData->bool3++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL3;
        }
//        parentValidationData->bool3++;

        break;
        }

        case 126:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL3;
        }
//        parentValidationData->bool3++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL3;
        }
//        parentValidationData->bool3++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL3;
        }
//        parentValidationData->bool3++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        bool3____bool3__ValidationData* validationData = (bool3____bool3__ValidationData*)mValidationDataStack.newObject(sizeof(bool3____bool3__ValidationData));
        memset(validationData, 0, sizeof(bool3____bool3__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__bool3____bool3()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__bool4( const bool* value, size_t length )
{
    if( length < 4 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__bool4__stream( const bool* value, size_t length )
{

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__bool4__streamEnd( const bool* value, size_t length )
{
    if( length < 4 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__bool4____bool4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL4;
        }
//        parentValidationData->bool4++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL4;
        }
//        parentValidationData->bool4++;

        break;
        }

        case 126:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL4;
        }
//        parentValidationData->bool4++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL4;
        }
//        parentValidationData->bool4++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_BOOL4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_BOOL4;
        }
//        parentValidationData->bool4++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        bool4____bool4__ValidationData* validationData = (bool4____bool4__ValidationData*)mValidationDataStack.newObject(sizeof(bool4____bool4__ValidationData));
        memset(validationData, 0, sizeof(bool4____bool4__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__bool4____bool4()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__int____int( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT;
        }
//        parentValidationData->_int++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT;
        }
//        parentValidationData->_int++;

        break;
        }

        case 126:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT;
        }
//        parentValidationData->_int++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT;
        }
//        parentValidationData->_int++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT;
        }
//        parentValidationData->_int++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__int____int()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__int2( const sint64* value, size_t length )
{
    if( length < 2 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 2 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__int2__stream( const sint64* value, size_t length )
{

    if( length > 2 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__int2__streamEnd( const sint64* value, size_t length )
{
    if( length < 2 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 2 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__int2____int2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT2;
        }
//        parentValidationData->int2++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT2;
        }
//        parentValidationData->int2++;

        break;
        }

        case 126:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT2;
        }
//        parentValidationData->int2++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT2;
        }
//        parentValidationData->int2++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT2;
        }
//        parentValidationData->int2++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        int2____int2__ValidationData* validationData = (int2____int2__ValidationData*)mValidationDataStack.newObject(sizeof(int2____int2__ValidationData));
        memset(validationData, 0, sizeof(int2____int2__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__int2____int2()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__int3( const sint64* value, size_t length )
{
    if( length < 3 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 3 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__int3__stream( const sint64* value, size_t length )
{

    if( length > 3 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__int3__streamEnd( const sint64* value, size_t length )
{
    if( length < 3 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 3 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__int3____int3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT3;
        }
//        parentValidationData->int3++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT3;
        }
//        parentValidationData->int3++;

        break;
        }

        case 126:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT3;
        }
//        parentValidationData->int3++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT3;
        }
//        parentValidationData->int3++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT3;
        }
//        parentValidationData->int3++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        int3____int3__ValidationData* validationData = (int3____int3__ValidationData*)mValidationDataStack.newObject(sizeof(int3____int3__ValidationData));
        memset(validationData, 0, sizeof(int3____int3__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__int3____int3()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__int4( const sint64* value, size_t length )
{
    if( length < 4 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__int4__stream( const sint64* value, size_t length )
{

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__int4__streamEnd( const sint64* value, size_t length )
{
    if( length < 4 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__int4____int4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT4;
        }
//        parentValidationData->int4++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT4;
        }
//        parentValidationData->int4++;

        break;
        }

        case 126:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT4;
        }
//        parentValidationData->int4++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT4;
        }
//        parentValidationData->int4++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INT4;
        }
//        parentValidationData->int4++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        int4____int4__ValidationData* validationData = (int4____int4__ValidationData*)mValidationDataStack.newObject(sizeof(int4____int4__ValidationData));
        memset(validationData, 0, sizeof(int4____int4__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__int4____int4()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__float____float( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT;
        }
//        parentValidationData->_float++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT;
        }
//        parentValidationData->_float++;

        break;
        }

        case 148:
        {
        newparam____common_newparam_type__ValidationData* parentValidationData = (newparam____common_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT;
        }
//        parentValidationData->_float++;

        break;
        }

        case 126:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT;
        }
//        parentValidationData->_float++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT;
        }
//        parentValidationData->_float++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT;
        }
//        parentValidationData->_float++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__float____float()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float2( const float* value, size_t length )
{
    if( length < 2 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 2 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float2__stream( const float* value, size_t length )
{

    if( length > 2 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float2__streamEnd( const float* value, size_t length )
{
    if( length < 2 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 2 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__float2____float2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2;
        }
//        parentValidationData->float2++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2;
        }
//        parentValidationData->float2++;

        break;
        }

        case 148:
        {
        newparam____common_newparam_type__ValidationData* parentValidationData = (newparam____common_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2;
        }
//        parentValidationData->float2++;

        break;
        }

        case 126:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2;
        }
//        parentValidationData->float2++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2;
        }
//        parentValidationData->float2++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2;
        }
//        parentValidationData->float2++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        float2____float2__ValidationData* validationData = (float2____float2__ValidationData*)mValidationDataStack.newObject(sizeof(float2____float2__ValidationData));
        memset(validationData, 0, sizeof(float2____float2__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__float2____float2()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float3( const float* value, size_t length )
{
    if( length < 3 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 3 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float3__stream( const float* value, size_t length )
{

    if( length > 3 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float3__streamEnd( const float* value, size_t length )
{
    if( length < 3 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 3 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__float3____float3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3;
        }
//        parentValidationData->float3++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3;
        }
//        parentValidationData->float3++;

        break;
        }

        case 148:
        {
        newparam____common_newparam_type__ValidationData* parentValidationData = (newparam____common_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3;
        }
//        parentValidationData->float3++;

        break;
        }

        case 126:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3;
        }
//        parentValidationData->float3++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3;
        }
//        parentValidationData->float3++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3;
        }
//        parentValidationData->float3++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.newObject(sizeof(float3____float3__ValidationData));
        memset(validationData, 0, sizeof(float3____float3__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__float3____float3()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float4( const float* value, size_t length )
{
    if( length < 4 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float4__stream( const float* value, size_t length )
{

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float4__streamEnd( const float* value, size_t length )
{
    if( length < 4 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__float4____float4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4;
        }
//        parentValidationData->float4++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4;
        }
//        parentValidationData->float4++;

        break;
        }

        case 148:
        {
        newparam____common_newparam_type__ValidationData* parentValidationData = (newparam____common_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4;
        }
//        parentValidationData->float4++;

        break;
        }

        case 126:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4;
        }
//        parentValidationData->float4++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4;
        }
//        parentValidationData->float4++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4;
        }
//        parentValidationData->float4++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        float4____float4__ValidationData* validationData = (float4____float4__ValidationData*)mValidationDataStack.newObject(sizeof(float4____float4__ValidationData));
        memset(validationData, 0, sizeof(float4____float4__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__float4____float4()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float2x2( const float* value, size_t length )
{
    if( length < 4 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float2x2__stream( const float* value, size_t length )
{

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float2x2__streamEnd( const float* value, size_t length )
{
    if( length < 4 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__float2x2____float2x2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X2;
        }
//        parentValidationData->float2x2++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X2;
        }
//        parentValidationData->float2x2++;

        break;
        }

        case 126:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X2;
        }
//        parentValidationData->float2x2++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X2;
        }
//        parentValidationData->float2x2++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X2;
        }
//        parentValidationData->float2x2++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        float2x2____float2x2__ValidationData* validationData = (float2x2____float2x2__ValidationData*)mValidationDataStack.newObject(sizeof(float2x2____float2x2__ValidationData));
        memset(validationData, 0, sizeof(float2x2____float2x2__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__float2x2____float2x2()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float3x3( const float* value, size_t length )
{
    if( length < 9 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 9 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float3x3__stream( const float* value, size_t length )
{

    if( length > 9 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float3x3__streamEnd( const float* value, size_t length )
{
    if( length < 9 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 9 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__float3x3____float3x3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X3;
        }
//        parentValidationData->float3x3++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X3;
        }
//        parentValidationData->float3x3++;

        break;
        }

        case 126:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X3;
        }
//        parentValidationData->float3x3++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X3;
        }
//        parentValidationData->float3x3++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X3;
        }
//        parentValidationData->float3x3++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        float3x3____float3x3__ValidationData* validationData = (float3x3____float3x3__ValidationData*)mValidationDataStack.newObject(sizeof(float3x3____float3x3__ValidationData));
        memset(validationData, 0, sizeof(float3x3____float3x3__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__float3x3____float3x3()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__float4x4____float4x4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X4;
        }
//        parentValidationData->float4x4++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X4;
        }
//        parentValidationData->float4x4++;

        break;
        }

        case 126:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X4;
        }
//        parentValidationData->float4x4++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X4;
        }
//        parentValidationData->float4x4++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X4;
        }
//        parentValidationData->float4x4++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        bind_shape_matrix__ValidationData* validationData = (bind_shape_matrix__ValidationData*)mValidationDataStack.newObject(sizeof(bind_shape_matrix__ValidationData));
        memset(validationData, 0, sizeof(bind_shape_matrix__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__float4x4____float4x4()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__string( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 143:
        {
        profile_CG__technique__pass__shader__bind__ValidationData* parentValidationData = (profile_CG__technique__pass__shader__bind__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_STRING, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_STRING;
        }
//        parentValidationData->string++;

        break;
        }

        case 39:
        {
        array____cg_newarray_type__ValidationData* parentValidationData = (array____cg_newarray_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL1X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL1X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL1X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL1X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_CONNECT_PARAM) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED1X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED1X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED1X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED1X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT1X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT1X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT1X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT1X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF1X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF1X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF1X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF1X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT1X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT1X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT1X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT1X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_STRING) || (parentValidationData->validation_current_state == HASH_ELEMENT_SURFACE) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_STRING, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_STRING;
        }
//        parentValidationData->string++;

        break;
        }

        case 147:
        {
        newparam____cg_newparam__ValidationData* parentValidationData = (newparam____cg_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_STRING, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_STRING;
        }
//        parentValidationData->string++;

        break;
        }

        case 40:
        {
        array____cg_setarray_type__ValidationData* parentValidationData = (array____cg_setarray_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL1X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL1X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL1X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL1X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED1X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED1X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED1X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED1X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT1X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT1X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT1X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT1X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF1X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF1X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF1X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF1X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT1X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT1X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT1X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT1X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_STRING) || (parentValidationData->validation_current_state == HASH_ELEMENT_SURFACE) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_STRING, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_STRING;
        }
//        parentValidationData->string++;

        break;
        }

        case 471:
        {
        setparam____cg_setparam__ValidationData* parentValidationData = (setparam____cg_setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_STRING, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_STRING;
        }
//        parentValidationData->string++;

        break;
        }

        case 472:
        {
        setparam____cg_setparam_simple__ValidationData* parentValidationData = (setparam____cg_setparam_simple__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_STRING, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_STRING;
        }
//        parentValidationData->string++;

        break;
        }

        case 389:
        {
        usertype__ValidationData* parentValidationData = (usertype__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ARRAY) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL1X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL1X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL1X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL1X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_BOOL4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_CONNECT_PARAM) || (parentValidationData->validation_current_state == HASH_ELEMENT_ENUM) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED1X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED1X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED1X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED1X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FIXED4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT1X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT1X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT1X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT1X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF1X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF1X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF1X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF1X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_HALF4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT1X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT1X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT1X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT1X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT2X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT3X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X1) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X2) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X3) || (parentValidationData->validation_current_state == HASH_ELEMENT_INT4X4) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (parentValidationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (parentValidationData->validation_current_state == HASH_ELEMENT_STRING) || (parentValidationData->validation_current_state == HASH_ELEMENT_SURFACE) || (parentValidationData->validation_current_state == HASH_ELEMENT_USERTYPE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_STRING, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_STRING;
        }
//        parentValidationData->string++;

        break;
        }

        case 126:
        {
        annotate__ValidationData* parentValidationData = (annotate__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_STRING, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_STRING;
        }
//        parentValidationData->string++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__string()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__image( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 487:
        {
        effect__ValidationData* parentValidationData = (effect__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->newparam != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_IMAGE, (const ParserChar*)0, "sibling: newparam" ) )
                return false;
        }
        if ( parentValidationData->fx_profile_abstract != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_IMAGE, (const ParserChar*)0, "sibling: fx_profile_abstract" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_IMAGE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->image++;

        break;
        }

        case 73:
        {
        library_images__ValidationData* parentValidationData = (library_images__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_IMAGE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->image++;

        break;
        }

        case 534:
        {
        profile_CG__ValidationData* parentValidationData = (profile_CG__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_CODE) || (parentValidationData->validation_current_state == HASH_ELEMENT_IMAGE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INCLUDE) || (parentValidationData->validation_current_state == HASH_ELEMENT_NEWPARAM) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_IMAGE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_IMAGE;
        }
//        parentValidationData->image++;

        break;
        }

        case 460:
        {
        profile_COMMON__ValidationData* parentValidationData = (profile_COMMON__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_IMAGE) || (parentValidationData->validation_current_state == HASH_ELEMENT_NEWPARAM) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_IMAGE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_IMAGE;
        }
//        parentValidationData->image++;

        break;
        }

        case 393:
        {
        profile_GLES__ValidationData* parentValidationData = (profile_GLES__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_IMAGE) || (parentValidationData->validation_current_state == HASH_ELEMENT_NEWPARAM) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_IMAGE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_IMAGE;
        }
//        parentValidationData->image++;

        break;
        }

        case 286:
        {
        profile_GLSL__ValidationData* parentValidationData = (profile_GLSL__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_CODE) || (parentValidationData->validation_current_state == HASH_ELEMENT_IMAGE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INCLUDE) || (parentValidationData->validation_current_state == HASH_ELEMENT_NEWPARAM) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_IMAGE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_IMAGE;
        }
//        parentValidationData->image++;

        break;
        }

        case 317:
        {
        profile_CG__technique__ValidationData* parentValidationData = (profile_CG__technique__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_CODE) || (parentValidationData->validation_current_state == HASH_ELEMENT_IMAGE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INCLUDE) || (parentValidationData->validation_current_state == HASH_ELEMENT_NEWPARAM) || (parentValidationData->validation_current_state == HASH_ELEMENT_SETPARAM) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_IMAGE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_IMAGE;
        }
//        parentValidationData->image++;

        break;
        }

        case 318:
        {
        profile_COMMON__technique__ValidationData* parentValidationData = (profile_COMMON__technique__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_IMAGE) || (parentValidationData->validation_current_state == HASH_ELEMENT_NEWPARAM) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_IMAGE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_IMAGE;
        }
//        parentValidationData->image++;

        break;
        }

        case 319:
        {
        profile_GLES__technique__ValidationData* parentValidationData = (profile_GLES__technique__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == HASH_ELEMENT_IMAGE) || (parentValidationData->validation_current_state == HASH_ELEMENT_NEWPARAM) || (parentValidationData->validation_current_state == HASH_ELEMENT_SETPARAM) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_IMAGE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_IMAGE;
        }
//        parentValidationData->image++;

        break;
        }

        case 320:
        {
        profile_GLSL__technique__ValidationData* parentValidationData = (profile_GLSL__technique__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_CODE) || (parentValidationData->validation_current_state == HASH_ELEMENT_IMAGE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INCLUDE) || (parentValidationData->validation_current_state == HASH_ELEMENT_NEWPARAM) || (parentValidationData->validation_current_state == HASH_ELEMENT_SETPARAM) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_IMAGE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_IMAGE;
        }
//        parentValidationData->image++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        image__ValidationData* validationData = (image__ValidationData*)mValidationDataStack.newObject(sizeof(image__ValidationData));
        memset(validationData, 0, sizeof(image__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__image()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        image__ValidationData* validationData = (image__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_DATA) || (validationData->validation_current_state == HASH_ELEMENT_EXTRA) || (validationData->validation_current_state == HASH_ELEMENT_INIT_FROM) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_IMAGE, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__data( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        image__ValidationData* parentValidationData = (image__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_DATA, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_DATA;
        }
//        parentValidationData->data++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__data()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__init_from____anyURI( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        image__ValidationData* parentValidationData = (image__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ASSET) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INIT_FROM, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INIT_FROM;
        }
//        parentValidationData->init_from++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__init_from____anyURI()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__newparam____fx_newparam_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        effect__ValidationData* parentValidationData = (effect__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->fx_profile_abstract != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_NEWPARAM, (const ParserChar*)0, "sibling: fx_profile_abstract" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_NEWPARAM, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->newparam++;

        newparam____fx_newparam_common__ValidationData* validationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.newObject(sizeof(newparam____fx_newparam_common__ValidationData));
        memset(validationData, 0, sizeof(newparam____fx_newparam_common__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__newparam____fx_newparam_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        newparam____fx_newparam_common__ValidationData* validationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_BOOL) || (validationData->validation_current_state == HASH_ELEMENT_BOOL2) || (validationData->validation_current_state == HASH_ELEMENT_BOOL3) || (validationData->validation_current_state == HASH_ELEMENT_BOOL4) || (validationData->validation_current_state == HASH_ELEMENT_ENUM) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT1X1) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT1X2) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT1X3) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT1X4) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT2) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT2X1) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT2X2) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT2X3) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT2X4) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT3) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT3X1) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT3X2) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT3X3) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT3X4) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT4) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT4X1) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT4X2) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT4X3) || (validationData->validation_current_state == HASH_ELEMENT_FLOAT4X4) || (validationData->validation_current_state == HASH_ELEMENT_INT) || (validationData->validation_current_state == HASH_ELEMENT_INT2) || (validationData->validation_current_state == HASH_ELEMENT_INT3) || (validationData->validation_current_state == HASH_ELEMENT_INT4) || (validationData->validation_current_state == HASH_ELEMENT_SAMPLER1D) || (validationData->validation_current_state == HASH_ELEMENT_SAMPLER2D) || (validationData->validation_current_state == HASH_ELEMENT_SAMPLER3D) || (validationData->validation_current_state == HASH_ELEMENT_SAMPLERCUBE) || (validationData->validation_current_state == HASH_ELEMENT_SAMPLERDEPTH) || (validationData->validation_current_state == HASH_ELEMENT_SAMPLERRECT) || (validationData->validation_current_state == HASH_ELEMENT_SURFACE) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_NEWPARAM, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__semantic( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 147:
        {
        newparam____cg_newparam__ValidationData* parentValidationData = (newparam____cg_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SEMANTIC, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SEMANTIC;
        }
//        parentValidationData->semantic++;

        break;
        }

        case 148:
        {
        newparam____common_newparam_type__ValidationData* parentValidationData = (newparam____common_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SEMANTIC, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SEMANTIC;
        }
//        parentValidationData->semantic++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SEMANTIC, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SEMANTIC;
        }
//        parentValidationData->semantic++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SEMANTIC, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SEMANTIC;
        }
//        parentValidationData->semantic++;

        break;
        }

        case 151:
        {
        newparam____glsl_newparam__ValidationData* parentValidationData = (newparam____glsl_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SEMANTIC, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SEMANTIC;
        }
//        parentValidationData->semantic++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__semantic()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_modifier_enum_common( ParserString value )
{
    return validate__fx_modifier_enum_common( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_modifier_enum_common( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_modifier_enum_common__stream( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_modifier_enum_common__streamEnd( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__modifier( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 147:
        {
        newparam____cg_newparam__ValidationData* parentValidationData = (newparam____cg_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_MODIFIER, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_MODIFIER;
        }
//        parentValidationData->modifier++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_MODIFIER, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_MODIFIER;
        }
//        parentValidationData->modifier++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_MODIFIER, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_MODIFIER;
        }
//        parentValidationData->modifier++;

        break;
        }

        case 151:
        {
        newparam____glsl_newparam__ValidationData* parentValidationData = (newparam____glsl_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_MODIFIER, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_MODIFIER;
        }
//        parentValidationData->modifier++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__modifier()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__float1x1____float( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT1X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT1X1;
        }
//        parentValidationData->float1x1++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT1X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT1X1;
        }
//        parentValidationData->float1x1++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT1X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT1X1;
        }
//        parentValidationData->float1x1++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT1X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT1X1;
        }
//        parentValidationData->float1x1++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__float1x1____float()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__float1x2____float2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT1X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT1X2;
        }
//        parentValidationData->float1x2++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT1X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT1X2;
        }
//        parentValidationData->float1x2++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT1X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT1X2;
        }
//        parentValidationData->float1x2++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT1X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT1X2;
        }
//        parentValidationData->float1x2++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        float2____float2__ValidationData* validationData = (float2____float2__ValidationData*)mValidationDataStack.newObject(sizeof(float2____float2__ValidationData));
        memset(validationData, 0, sizeof(float2____float2__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__float1x2____float2()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__float1x3____float3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT1X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT1X3;
        }
//        parentValidationData->float1x3++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT1X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT1X3;
        }
//        parentValidationData->float1x3++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT1X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT1X3;
        }
//        parentValidationData->float1x3++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT1X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT1X3;
        }
//        parentValidationData->float1x3++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.newObject(sizeof(float3____float3__ValidationData));
        memset(validationData, 0, sizeof(float3____float3__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__float1x3____float3()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__float1x4____float4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT1X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT1X4;
        }
//        parentValidationData->float1x4++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT1X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT1X4;
        }
//        parentValidationData->float1x4++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT1X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT1X4;
        }
//        parentValidationData->float1x4++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT1X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT1X4;
        }
//        parentValidationData->float1x4++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        float4____float4__ValidationData* validationData = (float4____float4__ValidationData*)mValidationDataStack.newObject(sizeof(float4____float4__ValidationData));
        memset(validationData, 0, sizeof(float4____float4__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__float1x4____float4()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__float2x1____float2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X1;
        }
//        parentValidationData->float2x1++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X1;
        }
//        parentValidationData->float2x1++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X1;
        }
//        parentValidationData->float2x1++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X1;
        }
//        parentValidationData->float2x1++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        float2____float2__ValidationData* validationData = (float2____float2__ValidationData*)mValidationDataStack.newObject(sizeof(float2____float2__ValidationData));
        memset(validationData, 0, sizeof(float2____float2__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__float2x1____float2()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float2x3( const float* value, size_t length )
{
    if( length < 6 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 6 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float2x3__stream( const float* value, size_t length )
{

    if( length > 6 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float2x3__streamEnd( const float* value, size_t length )
{
    if( length < 6 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 6 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__float2x3____float2x3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X3;
        }
//        parentValidationData->float2x3++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X3;
        }
//        parentValidationData->float2x3++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X3;
        }
//        parentValidationData->float2x3++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X3;
        }
//        parentValidationData->float2x3++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        float2x3____float2x3__ValidationData* validationData = (float2x3____float2x3__ValidationData*)mValidationDataStack.newObject(sizeof(float2x3____float2x3__ValidationData));
        memset(validationData, 0, sizeof(float2x3____float2x3__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__float2x3____float2x3()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float2x4( const float* value, size_t length )
{
    if( length < 8 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 8 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float2x4__stream( const float* value, size_t length )
{

    if( length > 8 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float2x4__streamEnd( const float* value, size_t length )
{
    if( length < 8 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 8 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__float2x4____float2x4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X4;
        }
//        parentValidationData->float2x4++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X4;
        }
//        parentValidationData->float2x4++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X4;
        }
//        parentValidationData->float2x4++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT2X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT2X4;
        }
//        parentValidationData->float2x4++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        float2x4____float2x4__ValidationData* validationData = (float2x4____float2x4__ValidationData*)mValidationDataStack.newObject(sizeof(float2x4____float2x4__ValidationData));
        memset(validationData, 0, sizeof(float2x4____float2x4__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__float2x4____float2x4()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__float3x1____float3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X1;
        }
//        parentValidationData->float3x1++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X1;
        }
//        parentValidationData->float3x1++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X1;
        }
//        parentValidationData->float3x1++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X1;
        }
//        parentValidationData->float3x1++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        float3____float3__ValidationData* validationData = (float3____float3__ValidationData*)mValidationDataStack.newObject(sizeof(float3____float3__ValidationData));
        memset(validationData, 0, sizeof(float3____float3__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__float3x1____float3()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float3x2( const float* value, size_t length )
{
    if( length < 6 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 6 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float3x2__stream( const float* value, size_t length )
{

    if( length > 6 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float3x2__streamEnd( const float* value, size_t length )
{
    if( length < 6 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 6 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__float3x2____float3x2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X2;
        }
//        parentValidationData->float3x2++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X2;
        }
//        parentValidationData->float3x2++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X2;
        }
//        parentValidationData->float3x2++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X2;
        }
//        parentValidationData->float3x2++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        float3x2____float3x2__ValidationData* validationData = (float3x2____float3x2__ValidationData*)mValidationDataStack.newObject(sizeof(float3x2____float3x2__ValidationData));
        memset(validationData, 0, sizeof(float3x2____float3x2__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__float3x2____float3x2()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float3x4( const float* value, size_t length )
{
    if( length < 12 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 12 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float3x4__stream( const float* value, size_t length )
{

    if( length > 12 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float3x4__streamEnd( const float* value, size_t length )
{
    if( length < 12 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 12 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__float3x4____float3x4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X4;
        }
//        parentValidationData->float3x4++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X4;
        }
//        parentValidationData->float3x4++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X4;
        }
//        parentValidationData->float3x4++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT3X4, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT3X4;
        }
//        parentValidationData->float3x4++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        float3x4____float3x4__ValidationData* validationData = (float3x4____float3x4__ValidationData*)mValidationDataStack.newObject(sizeof(float3x4____float3x4__ValidationData));
        memset(validationData, 0, sizeof(float3x4____float3x4__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__float3x4____float3x4()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__float4x1____float4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X1;
        }
//        parentValidationData->float4x1++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X1;
        }
//        parentValidationData->float4x1++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X1;
        }
//        parentValidationData->float4x1++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X1, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X1;
        }
//        parentValidationData->float4x1++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        float4____float4__ValidationData* validationData = (float4____float4__ValidationData*)mValidationDataStack.newObject(sizeof(float4____float4__ValidationData));
        memset(validationData, 0, sizeof(float4____float4__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__float4x1____float4()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float4x2( const float* value, size_t length )
{
    if( length < 8 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 8 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float4x2__stream( const float* value, size_t length )
{

    if( length > 8 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float4x2__streamEnd( const float* value, size_t length )
{
    if( length < 8 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 8 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__float4x2____float4x2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X2;
        }
//        parentValidationData->float4x2++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X2;
        }
//        parentValidationData->float4x2++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X2;
        }
//        parentValidationData->float4x2++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X2, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X2;
        }
//        parentValidationData->float4x2++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        float4x2____float4x2__ValidationData* validationData = (float4x2____float4x2__ValidationData*)mValidationDataStack.newObject(sizeof(float4x2____float4x2__ValidationData));
        memset(validationData, 0, sizeof(float4x2____float4x2__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__float4x2____float4x2()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float4x3( const float* value, size_t length )
{
    if( length < 12 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 12 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float4x3__stream( const float* value, size_t length )
{

    if( length > 12 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__float4x3__streamEnd( const float* value, size_t length )
{
    if( length < 12 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 12 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__float4x3____float4x3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X3;
        }
//        parentValidationData->float4x3++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X3;
        }
//        parentValidationData->float4x3++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X3;
        }
//        parentValidationData->float4x3++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FLOAT4X3, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FLOAT4X3;
        }
//        parentValidationData->float4x3++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        float4x3____float4x3__ValidationData* validationData = (float4x3____float4x3__ValidationData*)mValidationDataStack.newObject(sizeof(float4x3____float4x3__ValidationData));
        memset(validationData, 0, sizeof(float4x3____float4x3__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__float4x3____float4x3()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_surface_type_enum( ParserString value )
{
    return validate__fx_surface_type_enum( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_surface_type_enum( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_surface_type_enum__stream( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_surface_type_enum__streamEnd( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__surface____fx_surface_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SURFACE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SURFACE;
        }
//        parentValidationData->surface++;

        break;
        }

        case 470:
        {
        profile_GLES__technique__setparam__ValidationData* parentValidationData = (profile_GLES__technique__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SURFACE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SURFACE;
        }
//        parentValidationData->surface++;

        break;
        }

        case 148:
        {
        newparam____common_newparam_type__ValidationData* parentValidationData = (newparam____common_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SURFACE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SURFACE;
        }
//        parentValidationData->surface++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SURFACE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SURFACE;
        }
//        parentValidationData->surface++;

        break;
        }

        case 150:
        {
        newparam____gles_newparam__ValidationData* parentValidationData = (newparam____gles_newparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SURFACE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SURFACE;
        }
//        parentValidationData->surface++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        surface____fx_surface_common__ValidationData* validationData = (surface____fx_surface_common__ValidationData*)mValidationDataStack.newObject(sizeof(surface____fx_surface_common__ValidationData));
        memset(validationData, 0, sizeof(surface____fx_surface_common__ValidationData));
        validationData->validation_current_state = STATE_MACHINE_ROOT;


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__surface____fx_surface_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        surface____fx_surface_common__ValidationData* validationData = (surface____fx_surface_common__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( !( (validationData->validation_current_state == HASH_ELEMENT_EXTRA) || (validationData->validation_current_state == HASH_ELEMENT_FORMAT) || (validationData->validation_current_state == HASH_ELEMENT_FORMAT_HINT) || (validationData->validation_current_state == HASH_ELEMENT_INIT_AS_NULL) || (validationData->validation_current_state == HASH_ELEMENT_INIT_AS_TARGET) || (validationData->validation_current_state == HASH_ELEMENT_INIT_CUBE) || (validationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (validationData->validation_current_state == HASH_ELEMENT_INIT_PLANAR) || (validationData->validation_current_state == HASH_ELEMENT_INIT_VOLUME) || (validationData->validation_current_state == HASH_ELEMENT_MIPMAP_GENERATE) || (validationData->validation_current_state == HASH_ELEMENT_MIP_LEVELS) || (validationData->validation_current_state == HASH_ELEMENT_SIZE) || (validationData->validation_current_state == HASH_ELEMENT_VIEWPORT_RATIO) || (validationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_CLOSING_TAG, HASH_ELEMENT_SURFACE, (const ParserChar*)0, 0) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__init_as_null( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 496:
        {
        surface____cg_surface_type__ValidationData* parentValidationData = (surface____cg_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INIT_AS_NULL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INIT_AS_NULL;
        }
//        parentValidationData->init_as_null++;

        break;
        }

        case 497:
        {
        surface____fx_surface_common__ValidationData* parentValidationData = (surface____fx_surface_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INIT_AS_NULL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INIT_AS_NULL;
        }
//        parentValidationData->init_as_null++;

        break;
        }

        case 498:
        {
        surface____glsl_surface_type__ValidationData* parentValidationData = (surface____glsl_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INIT_AS_NULL, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INIT_AS_NULL;
        }
//        parentValidationData->init_as_null++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        init_as_null__ValidationData* validationData = (init_as_null__ValidationData*)mValidationDataStack.newObject(sizeof(init_as_null__ValidationData));
        memset(validationData, 0, sizeof(init_as_null__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__init_as_null()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        init_as_null__ValidationData* validationData = (init_as_null__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__init_as_target( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 496:
        {
        surface____cg_surface_type__ValidationData* parentValidationData = (surface____cg_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INIT_AS_TARGET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INIT_AS_TARGET;
        }
//        parentValidationData->init_as_target++;

        break;
        }

        case 497:
        {
        surface____fx_surface_common__ValidationData* parentValidationData = (surface____fx_surface_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INIT_AS_TARGET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INIT_AS_TARGET;
        }
//        parentValidationData->init_as_target++;

        break;
        }

        case 498:
        {
        surface____glsl_surface_type__ValidationData* parentValidationData = (surface____glsl_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INIT_AS_TARGET, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INIT_AS_TARGET;
        }
//        parentValidationData->init_as_target++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        init_as_null__ValidationData* validationData = (init_as_null__ValidationData*)mValidationDataStack.newObject(sizeof(init_as_null__ValidationData));
        memset(validationData, 0, sizeof(init_as_null__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__init_as_target()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        init_as_null__ValidationData* validationData = (init_as_null__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__init_cube( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 496:
        {
        surface____cg_surface_type__ValidationData* parentValidationData = (surface____cg_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INIT_CUBE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INIT_CUBE;
        }
//        parentValidationData->init_cube++;

        break;
        }

        case 497:
        {
        surface____fx_surface_common__ValidationData* parentValidationData = (surface____fx_surface_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INIT_CUBE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INIT_CUBE;
        }
//        parentValidationData->init_cube++;

        break;
        }

        case 498:
        {
        surface____glsl_surface_type__ValidationData* parentValidationData = (surface____glsl_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INIT_CUBE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INIT_CUBE;
        }
//        parentValidationData->init_cube++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        init_cube__ValidationData* validationData = (init_cube__ValidationData*)mValidationDataStack.newObject(sizeof(init_cube__ValidationData));
        memset(validationData, 0, sizeof(init_cube__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__init_cube()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        init_cube__ValidationData* validationData = (init_cube__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->all != 0 )
            if ( validationData->all < 1 ) // children minOccurs
                if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_INIT_CUBE, (const ParserChar*)0, "child: all" ) )
                    return false;
        if ( validationData->primary != 0 )
            if ( validationData->primary < 1 ) // children minOccurs
                if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_INIT_CUBE, (const ParserChar*)0, "child: primary" ) )
                    return false;
        if ( validationData->face != 0 )
            if ( validationData->face < 6 ) // children minOccurs
                if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_INIT_CUBE, (const ParserChar*)0, "child: face" ) )
                    return false;
        if ( validationData->all == 0 && validationData->primary == 0 && validationData->face == 0 ) // no child present
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_NO_CHILD_PRESENT, HASH_ELEMENT_INIT_CUBE, (const ParserChar*)0, 0 ) )
                return false;

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__fx_surface_init_cube_common____all( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        init_cube__ValidationData* parentValidationData = (init_cube__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->primary != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ALL, (const ParserChar*)0, "sibling: primary" ) )
                return false;
        }
        if ( parentValidationData->face != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ALL, (const ParserChar*)0, "sibling: face" ) )
                return false;
        }
        if ( parentValidationData->all >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ALL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->all++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__fx_surface_init_cube_common____all()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__fx_surface_init_cube_common____primary( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        init_cube__ValidationData* parentValidationData = (init_cube__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->all != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_PRIMARY, (const ParserChar*)0, "sibling: all" ) )
                return false;
        }
        if ( parentValidationData->face != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_PRIMARY, (const ParserChar*)0, "sibling: face" ) )
                return false;
        }
        if ( parentValidationData->primary >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_PRIMARY, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->primary++;

        fx_surface_init_cube_common____primary__ValidationData* validationData = (fx_surface_init_cube_common____primary__ValidationData*)mValidationDataStack.newObject(sizeof(fx_surface_init_cube_common____primary__ValidationData));
        memset(validationData, 0, sizeof(fx_surface_init_cube_common____primary__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__fx_surface_init_cube_common____primary()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        fx_surface_init_cube_common____primary__ValidationData* validationData = (fx_surface_init_cube_common____primary__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->order < 6 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_PRIMARY, (const ParserChar*)0, "child: order" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_surface_face_enum( ParserString value )
{
    return validate__fx_surface_face_enum( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_surface_face_enum( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_surface_face_enum__stream( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_surface_face_enum__streamEnd( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__order( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        fx_surface_init_cube_common____primary__ValidationData* parentValidationData = (fx_surface_init_cube_common____primary__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->order >= 6 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ORDER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->order++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__order()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__fx_surface_init_cube_common____face( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        init_cube__ValidationData* parentValidationData = (init_cube__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->all != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FACE, (const ParserChar*)0, "sibling: all" ) )
                return false;
        }
        if ( parentValidationData->primary != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_FACE, (const ParserChar*)0, "sibling: primary" ) )
                return false;
        }
        if ( parentValidationData->face >= 6 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_FACE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->face++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__fx_surface_init_cube_common____face()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__init_volume( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 496:
        {
        surface____cg_surface_type__ValidationData* parentValidationData = (surface____cg_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INIT_VOLUME, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INIT_VOLUME;
        }
//        parentValidationData->init_volume++;

        break;
        }

        case 497:
        {
        surface____fx_surface_common__ValidationData* parentValidationData = (surface____fx_surface_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INIT_VOLUME, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INIT_VOLUME;
        }
//        parentValidationData->init_volume++;

        break;
        }

        case 498:
        {
        surface____glsl_surface_type__ValidationData* parentValidationData = (surface____glsl_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INIT_VOLUME, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INIT_VOLUME;
        }
//        parentValidationData->init_volume++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        init_volume__ValidationData* validationData = (init_volume__ValidationData*)mValidationDataStack.newObject(sizeof(init_volume__ValidationData));
        memset(validationData, 0, sizeof(init_volume__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__init_volume()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        init_volume__ValidationData* validationData = (init_volume__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->all != 0 )
            if ( validationData->all < 1 ) // children minOccurs
                if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_INIT_VOLUME, (const ParserChar*)0, "child: all" ) )
                    return false;
        if ( validationData->primary != 0 )
            if ( validationData->primary < 1 ) // children minOccurs
                if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_INIT_VOLUME, (const ParserChar*)0, "child: primary" ) )
                    return false;
        if ( validationData->all == 0 && validationData->primary == 0 ) // no child present
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_NO_CHILD_PRESENT, HASH_ELEMENT_INIT_VOLUME, (const ParserChar*)0, 0 ) )
                return false;

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__fx_surface_init_volume_common____all( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        init_volume__ValidationData* parentValidationData = (init_volume__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->primary != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_ALL, (const ParserChar*)0, "sibling: primary" ) )
                return false;
        }
        if ( parentValidationData->all >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ALL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->all++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__fx_surface_init_volume_common____all()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__fx_surface_init_volume_common____primary( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        init_volume__ValidationData* parentValidationData = (init_volume__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->all != 0 ) // sibling in choice
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_PRIMARY, (const ParserChar*)0, "sibling: all" ) )
                return false;
        }
        if ( parentValidationData->primary >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_PRIMARY, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->primary++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__fx_surface_init_volume_common____primary()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__init_planar( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 496:
        {
        surface____cg_surface_type__ValidationData* parentValidationData = (surface____cg_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INIT_PLANAR, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INIT_PLANAR;
        }
//        parentValidationData->init_planar++;

        break;
        }

        case 497:
        {
        surface____fx_surface_common__ValidationData* parentValidationData = (surface____fx_surface_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INIT_PLANAR, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INIT_PLANAR;
        }
//        parentValidationData->init_planar++;

        break;
        }

        case 498:
        {
        surface____glsl_surface_type__ValidationData* parentValidationData = (surface____glsl_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INIT_PLANAR, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INIT_PLANAR;
        }
//        parentValidationData->init_planar++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        init_planar__ValidationData* validationData = (init_planar__ValidationData*)mValidationDataStack.newObject(sizeof(init_planar__ValidationData));
        memset(validationData, 0, sizeof(init_planar__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__init_planar()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        init_planar__ValidationData* validationData = (init_planar__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->all != 0 )
            if ( validationData->all < 1 ) // children minOccurs
                if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_INIT_PLANAR, (const ParserChar*)0, "child: all" ) )
                    return false;
        if ( validationData->all == 0 ) // no child present
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_CHOICE_NO_CHILD_PRESENT, HASH_ELEMENT_INIT_PLANAR, (const ParserChar*)0, 0 ) )
                return false;

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__fx_surface_init_planar_common____all( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        init_planar__ValidationData* parentValidationData = (init_planar__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->all >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_ALL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->all++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__fx_surface_init_planar_common____all()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__unsignedInt( const uint32 value )
{
    if( value > 4294967295 )
        return ParserError::ERROR_VALIDATION_MAX_INCLUSIVE;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__init_from____fx_surface_init_from_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 496:
        {
        surface____cg_surface_type__ValidationData* parentValidationData = (surface____cg_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INIT_FROM, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INIT_FROM;
        }
//        parentValidationData->init_from++;

        break;
        }

        case 497:
        {
        surface____fx_surface_common__ValidationData* parentValidationData = (surface____fx_surface_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INIT_FROM, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INIT_FROM;
        }
//        parentValidationData->init_from++;

        break;
        }

        case 498:
        {
        surface____glsl_surface_type__ValidationData* parentValidationData = (surface____glsl_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_INIT_FROM, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_INIT_FROM;
        }
//        parentValidationData->init_from++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__init_from____fx_surface_init_from_common()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__format( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 496:
        {
        surface____cg_surface_type__ValidationData* parentValidationData = (surface____cg_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_NULL) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_TARGET) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_CUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_PLANAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_VOLUME) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FORMAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FORMAT;
        }
//        parentValidationData->format++;

        break;
        }

        case 497:
        {
        surface____fx_surface_common__ValidationData* parentValidationData = (surface____fx_surface_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_NULL) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_TARGET) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_CUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_PLANAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_VOLUME) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FORMAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FORMAT;
        }
//        parentValidationData->format++;

        break;
        }

        case 498:
        {
        surface____glsl_surface_type__ValidationData* parentValidationData = (surface____glsl_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_NULL) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_TARGET) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_CUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_PLANAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_VOLUME) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FORMAT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FORMAT;
        }
//        parentValidationData->format++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__format()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__format_hint( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 496:
        {
        surface____cg_surface_type__ValidationData* parentValidationData = (surface____cg_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_NULL) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_TARGET) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_CUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_PLANAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_VOLUME) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FORMAT_HINT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FORMAT_HINT;
        }
//        parentValidationData->format_hint++;

        break;
        }

        case 497:
        {
        surface____fx_surface_common__ValidationData* parentValidationData = (surface____fx_surface_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_NULL) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_TARGET) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_CUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_PLANAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_VOLUME) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FORMAT_HINT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FORMAT_HINT;
        }
//        parentValidationData->format_hint++;

        break;
        }

        case 498:
        {
        surface____glsl_surface_type__ValidationData* parentValidationData = (surface____glsl_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_NULL) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_TARGET) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_CUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_PLANAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_VOLUME) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_FORMAT_HINT, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_FORMAT_HINT;
        }
//        parentValidationData->format_hint++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        format_hint__ValidationData* validationData = (format_hint__ValidationData*)mValidationDataStack.newObject(sizeof(format_hint__ValidationData));
        memset(validationData, 0, sizeof(format_hint__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__format_hint()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        format_hint__ValidationData* validationData = (format_hint__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->channels < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_FORMAT_HINT, (const ParserChar*)0, "child: channels" ) )
                return false;
        }
        if ( validationData->range < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_FORMAT_HINT, (const ParserChar*)0, "child: range" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_surface_format_hint_channels_enum( ParserString value )
{
    return validate__fx_surface_format_hint_channels_enum( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_surface_format_hint_channels_enum( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_surface_format_hint_channels_enum__stream( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_surface_format_hint_channels_enum__streamEnd( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__channels( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        format_hint__ValidationData* parentValidationData = (format_hint__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->range != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CHANNELS, (const ParserChar*)0, "sibling: range" ) )
                return false;
        }
        if ( parentValidationData->precision != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CHANNELS, (const ParserChar*)0, "sibling: precision" ) )
                return false;
        }
        if ( parentValidationData->option != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CHANNELS, (const ParserChar*)0, "sibling: option" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_CHANNELS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->channels >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_CHANNELS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->channels++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__channels()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_surface_format_hint_range_enum( ParserString value )
{
    return validate__fx_surface_format_hint_range_enum( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_surface_format_hint_range_enum( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_surface_format_hint_range_enum__stream( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_surface_format_hint_range_enum__streamEnd( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__range( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        format_hint__ValidationData* parentValidationData = (format_hint__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->channels < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_RANGE, (const ParserChar*)0, "sibling: channels" ) )
                return false;
        }
        if ( parentValidationData->precision != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_RANGE, (const ParserChar*)0, "sibling: precision" ) )
                return false;
        }
        if ( parentValidationData->option != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_RANGE, (const ParserChar*)0, "sibling: option" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_RANGE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->range >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_RANGE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->range++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__range()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_surface_format_hint_precision_enum( ParserString value )
{
    return validate__fx_surface_format_hint_precision_enum( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_surface_format_hint_precision_enum( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_surface_format_hint_precision_enum__stream( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_surface_format_hint_precision_enum__streamEnd( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__precision( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        format_hint__ValidationData* parentValidationData = (format_hint__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->range < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_PRECISION, (const ParserChar*)0, "sibling: range" ) )
                return false;
        }
        if ( parentValidationData->option != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_PRECISION, (const ParserChar*)0, "sibling: option" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_PRECISION, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->precision >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_PRECISION, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->precision++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__precision()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_surface_format_hint_option_enum( ParserString value )
{
    return validate__fx_surface_format_hint_option_enum( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_surface_format_hint_option_enum( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_surface_format_hint_option_enum__stream( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_surface_format_hint_option_enum__streamEnd( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__option( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        format_hint__ValidationData* parentValidationData = (format_hint__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->range < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_OPTION, (const ParserChar*)0, "sibling: range" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_OPTION, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        parentValidationData->option++;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__option()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__size____int3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 496:
        {
        surface____cg_surface_type__ValidationData* parentValidationData = (surface____cg_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT_HINT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_NULL) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_TARGET) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_CUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_PLANAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_VOLUME) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SIZE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SIZE;
        }
//        parentValidationData->size++;

        break;
        }

        case 497:
        {
        surface____fx_surface_common__ValidationData* parentValidationData = (surface____fx_surface_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT_HINT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_NULL) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_TARGET) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_CUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_PLANAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_VOLUME) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SIZE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SIZE;
        }
//        parentValidationData->size++;

        break;
        }

        case 498:
        {
        surface____glsl_surface_type__ValidationData* parentValidationData = (surface____glsl_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT_HINT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_NULL) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_TARGET) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_CUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_PLANAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_VOLUME) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SIZE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SIZE;
        }
//        parentValidationData->size++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        int3____int3__ValidationData* validationData = (int3____int3__ValidationData*)mValidationDataStack.newObject(sizeof(int3____int3__ValidationData));
        memset(validationData, 0, sizeof(int3____int3__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__size____int3()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__viewport_ratio( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 496:
        {
        surface____cg_surface_type__ValidationData* parentValidationData = (surface____cg_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT_HINT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_NULL) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_TARGET) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_CUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_PLANAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_VOLUME) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_VIEWPORT_RATIO, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_VIEWPORT_RATIO;
        }
//        parentValidationData->viewport_ratio++;

        break;
        }

        case 497:
        {
        surface____fx_surface_common__ValidationData* parentValidationData = (surface____fx_surface_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT_HINT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_NULL) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_TARGET) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_CUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_PLANAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_VOLUME) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_VIEWPORT_RATIO, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_VIEWPORT_RATIO;
        }
//        parentValidationData->viewport_ratio++;

        break;
        }

        case 498:
        {
        surface____glsl_surface_type__ValidationData* parentValidationData = (surface____glsl_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT_HINT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_NULL) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_TARGET) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_CUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_PLANAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_VOLUME) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_VIEWPORT_RATIO, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_VIEWPORT_RATIO;
        }
//        parentValidationData->viewport_ratio++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        float2____float2__ValidationData* validationData = (float2____float2__ValidationData*)mValidationDataStack.newObject(sizeof(float2____float2__ValidationData));
        memset(validationData, 0, sizeof(float2____float2__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__viewport_ratio()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__mip_levels( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 496:
        {
        surface____cg_surface_type__ValidationData* parentValidationData = (surface____cg_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT_HINT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_NULL) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_TARGET) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_CUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_PLANAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_VOLUME) || (parentValidationData->validation_current_state == HASH_ELEMENT_SIZE) || (parentValidationData->validation_current_state == HASH_ELEMENT_VIEWPORT_RATIO) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_MIP_LEVELS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_MIP_LEVELS;
        }
//        parentValidationData->mip_levels++;

        break;
        }

        case 497:
        {
        surface____fx_surface_common__ValidationData* parentValidationData = (surface____fx_surface_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT_HINT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_NULL) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_TARGET) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_CUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_PLANAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_VOLUME) || (parentValidationData->validation_current_state == HASH_ELEMENT_SIZE) || (parentValidationData->validation_current_state == HASH_ELEMENT_VIEWPORT_RATIO) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_MIP_LEVELS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_MIP_LEVELS;
        }
//        parentValidationData->mip_levels++;

        break;
        }

        case 498:
        {
        surface____glsl_surface_type__ValidationData* parentValidationData = (surface____glsl_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT_HINT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_NULL) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_TARGET) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_CUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_PLANAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_VOLUME) || (parentValidationData->validation_current_state == HASH_ELEMENT_SIZE) || (parentValidationData->validation_current_state == HASH_ELEMENT_VIEWPORT_RATIO) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_MIP_LEVELS, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_MIP_LEVELS;
        }
//        parentValidationData->mip_levels++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__mip_levels()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__mipmap_generate( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 496:
        {
        surface____cg_surface_type__ValidationData* parentValidationData = (surface____cg_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT_HINT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_NULL) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_TARGET) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_CUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_PLANAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_VOLUME) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_LEVELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_SIZE) || (parentValidationData->validation_current_state == HASH_ELEMENT_VIEWPORT_RATIO) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_MIPMAP_GENERATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_MIPMAP_GENERATE;
        }
//        parentValidationData->mipmap_generate++;

        break;
        }

        case 497:
        {
        surface____fx_surface_common__ValidationData* parentValidationData = (surface____fx_surface_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT_HINT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_NULL) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_TARGET) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_CUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_PLANAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_VOLUME) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_LEVELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_SIZE) || (parentValidationData->validation_current_state == HASH_ELEMENT_VIEWPORT_RATIO) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_MIPMAP_GENERATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_MIPMAP_GENERATE;
        }
//        parentValidationData->mipmap_generate++;

        break;
        }

        case 498:
        {
        surface____glsl_surface_type__ValidationData* parentValidationData = (surface____glsl_surface_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT) || (parentValidationData->validation_current_state == HASH_ELEMENT_FORMAT_HINT) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_NULL) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_AS_TARGET) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_CUBE) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_FROM) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_PLANAR) || (parentValidationData->validation_current_state == HASH_ELEMENT_INIT_VOLUME) || (parentValidationData->validation_current_state == HASH_ELEMENT_MIP_LEVELS) || (parentValidationData->validation_current_state == HASH_ELEMENT_SIZE) || (parentValidationData->validation_current_state == HASH_ELEMENT_VIEWPORT_RATIO) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_MIPMAP_GENERATE, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_MIPMAP_GENERATE;
        }
//        parentValidationData->mipmap_generate++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__mipmap_generate()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__sampler1D____fx_sampler1D_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SAMPLER1D, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SAMPLER1D;
        }
//        parentValidationData->sampler1D++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SAMPLER1D, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SAMPLER1D;
        }
//        parentValidationData->sampler1D++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        sampler1D____fx_sampler1D_common__ValidationData* validationData = (sampler1D____fx_sampler1D_common__ValidationData*)mValidationDataStack.newObject(sizeof(sampler1D____fx_sampler1D_common__ValidationData));
        memset(validationData, 0, sizeof(sampler1D____fx_sampler1D_common__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__sampler1D____fx_sampler1D_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        sampler1D____fx_sampler1D_common__ValidationData* validationData = (sampler1D____fx_sampler1D_common__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->source < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SAMPLER1D, (const ParserChar*)0, "child: source" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__source____NCName( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 592:
        {
        sampler1D____cg_sampler1D__ValidationData* parentValidationData = (sampler1D____cg_sampler1D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->wrap_s != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_s" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->source >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        case 608:
        {
        sampler2D____cg_sampler2D__ValidationData* parentValidationData = (sampler2D____cg_sampler2D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->wrap_s != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_s" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->source >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        case 616:
        {
        sampler3D____cg_sampler3D__ValidationData* parentValidationData = (sampler3D____cg_sampler3D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->wrap_s != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_s" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->wrap_p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_p" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->source >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        case 370:
        {
        samplerCUBE____cg_samplerCUBE__ValidationData* parentValidationData = (samplerCUBE____cg_samplerCUBE__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->wrap_s != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_s" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->wrap_p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_p" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->source >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        case 55:
        {
        samplerDEPTH____cg_samplerDEPTH__ValidationData* parentValidationData = (samplerDEPTH____cg_samplerDEPTH__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->wrap_s != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_s" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->source >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        case 597:
        {
        samplerRECT____cg_samplerRECT__ValidationData* parentValidationData = (samplerRECT____cg_samplerRECT__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->wrap_s != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_s" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->source >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        case 593:
        {
        sampler1D____fx_sampler1D_common__ValidationData* parentValidationData = (sampler1D____fx_sampler1D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->wrap_s != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_s" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->source >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        case 609:
        {
        sampler2D____fx_sampler2D_common__ValidationData* parentValidationData = (sampler2D____fx_sampler2D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->wrap_s != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_s" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->source >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        case 617:
        {
        sampler3D____fx_sampler3D_common__ValidationData* parentValidationData = (sampler3D____fx_sampler3D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->wrap_s != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_s" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->wrap_p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_p" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->source >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        case 371:
        {
        samplerCUBE____fx_samplerCUBE_common__ValidationData* parentValidationData = (samplerCUBE____fx_samplerCUBE_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->wrap_s != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_s" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->wrap_p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_p" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->source >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        case 56:
        {
        samplerDEPTH____fx_samplerDEPTH_common__ValidationData* parentValidationData = (samplerDEPTH____fx_samplerDEPTH_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->wrap_s != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_s" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->source >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        case 598:
        {
        samplerRECT____fx_samplerRECT_common__ValidationData* parentValidationData = (samplerRECT____fx_samplerRECT_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->wrap_s != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_s" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->source >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        case 257:
        {
        sampler1D____gl_sampler1D__ValidationData* parentValidationData = (sampler1D____gl_sampler1D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->wrap_s != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_s" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->source >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        case 258:
        {
        sampler2D____gl_sampler2D__ValidationData* parentValidationData = (sampler2D____gl_sampler2D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->wrap_s != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_s" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->source >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        case 259:
        {
        sampler3D____gl_sampler3D__ValidationData* parentValidationData = (sampler3D____gl_sampler3D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->wrap_s != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_s" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->wrap_p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_p" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->source >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        case 260:
        {
        samplerCUBE____gl_samplerCUBE__ValidationData* parentValidationData = (samplerCUBE____gl_samplerCUBE__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->wrap_s != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_s" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->wrap_p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_p" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->source >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        case 57:
        {
        samplerDEPTH____gl_samplerDEPTH__ValidationData* parentValidationData = (samplerDEPTH____gl_samplerDEPTH__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->wrap_s != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_s" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->source >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        case 261:
        {
        samplerRECT____gl_samplerRECT__ValidationData* parentValidationData = (samplerRECT____gl_samplerRECT__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->wrap_s != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_s" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_SOURCE, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->source >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_SOURCE, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->source++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__source____NCName()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_sampler_wrap_common( ParserString value )
{
    return validate__fx_sampler_wrap_common( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_sampler_wrap_common( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_sampler_wrap_common__stream( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_sampler_wrap_common__streamEnd( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__wrap_s____fx_sampler_wrap_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 592:
        {
        sampler1D____cg_sampler1D__ValidationData* parentValidationData = (sampler1D____cg_sampler1D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->wrap_s >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->wrap_s++;

        break;
        }

        case 608:
        {
        sampler2D____cg_sampler2D__ValidationData* parentValidationData = (sampler2D____cg_sampler2D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->wrap_s >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->wrap_s++;

        break;
        }

        case 616:
        {
        sampler3D____cg_sampler3D__ValidationData* parentValidationData = (sampler3D____cg_sampler3D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->wrap_p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: wrap_p" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->wrap_s >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->wrap_s++;

        break;
        }

        case 370:
        {
        samplerCUBE____cg_samplerCUBE__ValidationData* parentValidationData = (samplerCUBE____cg_samplerCUBE__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->wrap_p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: wrap_p" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->wrap_s >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->wrap_s++;

        break;
        }

        case 55:
        {
        samplerDEPTH____cg_samplerDEPTH__ValidationData* parentValidationData = (samplerDEPTH____cg_samplerDEPTH__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->wrap_s >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->wrap_s++;

        break;
        }

        case 597:
        {
        samplerRECT____cg_samplerRECT__ValidationData* parentValidationData = (samplerRECT____cg_samplerRECT__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->wrap_s >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->wrap_s++;

        break;
        }

        case 593:
        {
        sampler1D____fx_sampler1D_common__ValidationData* parentValidationData = (sampler1D____fx_sampler1D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->wrap_s >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->wrap_s++;

        break;
        }

        case 609:
        {
        sampler2D____fx_sampler2D_common__ValidationData* parentValidationData = (sampler2D____fx_sampler2D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->wrap_s >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->wrap_s++;

        break;
        }

        case 617:
        {
        sampler3D____fx_sampler3D_common__ValidationData* parentValidationData = (sampler3D____fx_sampler3D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->wrap_p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: wrap_p" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->wrap_s >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->wrap_s++;

        break;
        }

        case 371:
        {
        samplerCUBE____fx_samplerCUBE_common__ValidationData* parentValidationData = (samplerCUBE____fx_samplerCUBE_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->wrap_p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: wrap_p" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->wrap_s >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->wrap_s++;

        break;
        }

        case 56:
        {
        samplerDEPTH____fx_samplerDEPTH_common__ValidationData* parentValidationData = (samplerDEPTH____fx_samplerDEPTH_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->wrap_s >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->wrap_s++;

        break;
        }

        case 598:
        {
        samplerRECT____fx_samplerRECT_common__ValidationData* parentValidationData = (samplerRECT____fx_samplerRECT_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->wrap_s >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->wrap_s++;

        break;
        }

        case 257:
        {
        sampler1D____gl_sampler1D__ValidationData* parentValidationData = (sampler1D____gl_sampler1D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->wrap_s >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->wrap_s++;

        break;
        }

        case 258:
        {
        sampler2D____gl_sampler2D__ValidationData* parentValidationData = (sampler2D____gl_sampler2D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->wrap_s >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->wrap_s++;

        break;
        }

        case 259:
        {
        sampler3D____gl_sampler3D__ValidationData* parentValidationData = (sampler3D____gl_sampler3D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->wrap_p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: wrap_p" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->wrap_s >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->wrap_s++;

        break;
        }

        case 260:
        {
        samplerCUBE____gl_samplerCUBE__ValidationData* parentValidationData = (samplerCUBE____gl_samplerCUBE__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->wrap_p != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: wrap_p" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->wrap_s >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->wrap_s++;

        break;
        }

        case 57:
        {
        samplerDEPTH____gl_samplerDEPTH__ValidationData* parentValidationData = (samplerDEPTH____gl_samplerDEPTH__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->wrap_s >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->wrap_s++;

        break;
        }

        case 261:
        {
        samplerRECT____gl_samplerRECT__ValidationData* parentValidationData = (samplerRECT____gl_samplerRECT__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->wrap_t != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: wrap_t" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->wrap_s >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->wrap_s++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__wrap_s____fx_sampler_wrap_common()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_sampler_filter_common( ParserString value )
{
    return validate__fx_sampler_filter_common( value.str, value.length );
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_sampler_filter_common( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_sampler_filter_common__stream( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_sampler_filter_common__streamEnd( const ParserChar* value, size_t length )
{
    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__minfilter( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 592:
        {
        sampler1D____cg_sampler1D__ValidationData* parentValidationData = (sampler1D____cg_sampler1D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->minfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->minfilter++;

        break;
        }

        case 608:
        {
        sampler2D____cg_sampler2D__ValidationData* parentValidationData = (sampler2D____cg_sampler2D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->minfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->minfilter++;

        break;
        }

        case 616:
        {
        sampler3D____cg_sampler3D__ValidationData* parentValidationData = (sampler3D____cg_sampler3D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->minfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->minfilter++;

        break;
        }

        case 370:
        {
        samplerCUBE____cg_samplerCUBE__ValidationData* parentValidationData = (samplerCUBE____cg_samplerCUBE__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->minfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->minfilter++;

        break;
        }

        case 55:
        {
        samplerDEPTH____cg_samplerDEPTH__ValidationData* parentValidationData = (samplerDEPTH____cg_samplerDEPTH__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->minfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->minfilter++;

        break;
        }

        case 597:
        {
        samplerRECT____cg_samplerRECT__ValidationData* parentValidationData = (samplerRECT____cg_samplerRECT__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->minfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->minfilter++;

        break;
        }

        case 593:
        {
        sampler1D____fx_sampler1D_common__ValidationData* parentValidationData = (sampler1D____fx_sampler1D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->minfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->minfilter++;

        break;
        }

        case 609:
        {
        sampler2D____fx_sampler2D_common__ValidationData* parentValidationData = (sampler2D____fx_sampler2D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->minfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->minfilter++;

        break;
        }

        case 617:
        {
        sampler3D____fx_sampler3D_common__ValidationData* parentValidationData = (sampler3D____fx_sampler3D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->minfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->minfilter++;

        break;
        }

        case 371:
        {
        samplerCUBE____fx_samplerCUBE_common__ValidationData* parentValidationData = (samplerCUBE____fx_samplerCUBE_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->minfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->minfilter++;

        break;
        }

        case 56:
        {
        samplerDEPTH____fx_samplerDEPTH_common__ValidationData* parentValidationData = (samplerDEPTH____fx_samplerDEPTH_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->minfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->minfilter++;

        break;
        }

        case 598:
        {
        samplerRECT____fx_samplerRECT_common__ValidationData* parentValidationData = (samplerRECT____fx_samplerRECT_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->minfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->minfilter++;

        break;
        }

        case 257:
        {
        sampler1D____gl_sampler1D__ValidationData* parentValidationData = (sampler1D____gl_sampler1D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->minfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->minfilter++;

        break;
        }

        case 258:
        {
        sampler2D____gl_sampler2D__ValidationData* parentValidationData = (sampler2D____gl_sampler2D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->minfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->minfilter++;

        break;
        }

        case 259:
        {
        sampler3D____gl_sampler3D__ValidationData* parentValidationData = (sampler3D____gl_sampler3D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->minfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->minfilter++;

        break;
        }

        case 260:
        {
        samplerCUBE____gl_samplerCUBE__ValidationData* parentValidationData = (samplerCUBE____gl_samplerCUBE__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->minfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->minfilter++;

        break;
        }

        case 57:
        {
        samplerDEPTH____gl_samplerDEPTH__ValidationData* parentValidationData = (samplerDEPTH____gl_samplerDEPTH__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->minfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->minfilter++;

        break;
        }

        case 261:
        {
        samplerRECT____gl_samplerRECT__ValidationData* parentValidationData = (samplerRECT____gl_samplerRECT__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->minfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->minfilter++;

        break;
        }

        case 538:
        {
        sampler_state____gles_sampler_state__ValidationData* parentValidationData = (sampler_state____gles_sampler_state__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->minfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->minfilter++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__minfilter()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__magfilter( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 592:
        {
        sampler1D____cg_sampler1D__ValidationData* parentValidationData = (sampler1D____cg_sampler1D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->magfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->magfilter++;

        break;
        }

        case 608:
        {
        sampler2D____cg_sampler2D__ValidationData* parentValidationData = (sampler2D____cg_sampler2D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->magfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->magfilter++;

        break;
        }

        case 616:
        {
        sampler3D____cg_sampler3D__ValidationData* parentValidationData = (sampler3D____cg_sampler3D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->magfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->magfilter++;

        break;
        }

        case 370:
        {
        samplerCUBE____cg_samplerCUBE__ValidationData* parentValidationData = (samplerCUBE____cg_samplerCUBE__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->magfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->magfilter++;

        break;
        }

        case 55:
        {
        samplerDEPTH____cg_samplerDEPTH__ValidationData* parentValidationData = (samplerDEPTH____cg_samplerDEPTH__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->magfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->magfilter++;

        break;
        }

        case 597:
        {
        samplerRECT____cg_samplerRECT__ValidationData* parentValidationData = (samplerRECT____cg_samplerRECT__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->magfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->magfilter++;

        break;
        }

        case 593:
        {
        sampler1D____fx_sampler1D_common__ValidationData* parentValidationData = (sampler1D____fx_sampler1D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->magfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->magfilter++;

        break;
        }

        case 609:
        {
        sampler2D____fx_sampler2D_common__ValidationData* parentValidationData = (sampler2D____fx_sampler2D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->magfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->magfilter++;

        break;
        }

        case 617:
        {
        sampler3D____fx_sampler3D_common__ValidationData* parentValidationData = (sampler3D____fx_sampler3D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->magfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->magfilter++;

        break;
        }

        case 371:
        {
        samplerCUBE____fx_samplerCUBE_common__ValidationData* parentValidationData = (samplerCUBE____fx_samplerCUBE_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->magfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->magfilter++;

        break;
        }

        case 56:
        {
        samplerDEPTH____fx_samplerDEPTH_common__ValidationData* parentValidationData = (samplerDEPTH____fx_samplerDEPTH_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->magfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->magfilter++;

        break;
        }

        case 598:
        {
        samplerRECT____fx_samplerRECT_common__ValidationData* parentValidationData = (samplerRECT____fx_samplerRECT_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->magfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->magfilter++;

        break;
        }

        case 257:
        {
        sampler1D____gl_sampler1D__ValidationData* parentValidationData = (sampler1D____gl_sampler1D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->magfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->magfilter++;

        break;
        }

        case 258:
        {
        sampler2D____gl_sampler2D__ValidationData* parentValidationData = (sampler2D____gl_sampler2D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->magfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->magfilter++;

        break;
        }

        case 259:
        {
        sampler3D____gl_sampler3D__ValidationData* parentValidationData = (sampler3D____gl_sampler3D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->magfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->magfilter++;

        break;
        }

        case 260:
        {
        samplerCUBE____gl_samplerCUBE__ValidationData* parentValidationData = (samplerCUBE____gl_samplerCUBE__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->magfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->magfilter++;

        break;
        }

        case 57:
        {
        samplerDEPTH____gl_samplerDEPTH__ValidationData* parentValidationData = (samplerDEPTH____gl_samplerDEPTH__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->magfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->magfilter++;

        break;
        }

        case 261:
        {
        samplerRECT____gl_samplerRECT__ValidationData* parentValidationData = (samplerRECT____gl_samplerRECT__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->magfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->magfilter++;

        break;
        }

        case 538:
        {
        sampler_state____gles_sampler_state__ValidationData* parentValidationData = (sampler_state____gles_sampler_state__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipfilter" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->magfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->magfilter++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__magfilter()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__mipfilter( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 592:
        {
        sampler1D____cg_sampler1D__ValidationData* parentValidationData = (sampler1D____cg_sampler1D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipfilter++;

        break;
        }

        case 608:
        {
        sampler2D____cg_sampler2D__ValidationData* parentValidationData = (sampler2D____cg_sampler2D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipfilter++;

        break;
        }

        case 616:
        {
        sampler3D____cg_sampler3D__ValidationData* parentValidationData = (sampler3D____cg_sampler3D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipfilter++;

        break;
        }

        case 370:
        {
        samplerCUBE____cg_samplerCUBE__ValidationData* parentValidationData = (samplerCUBE____cg_samplerCUBE__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipfilter++;

        break;
        }

        case 597:
        {
        samplerRECT____cg_samplerRECT__ValidationData* parentValidationData = (samplerRECT____cg_samplerRECT__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipfilter++;

        break;
        }

        case 593:
        {
        sampler1D____fx_sampler1D_common__ValidationData* parentValidationData = (sampler1D____fx_sampler1D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipfilter++;

        break;
        }

        case 609:
        {
        sampler2D____fx_sampler2D_common__ValidationData* parentValidationData = (sampler2D____fx_sampler2D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipfilter++;

        break;
        }

        case 617:
        {
        sampler3D____fx_sampler3D_common__ValidationData* parentValidationData = (sampler3D____fx_sampler3D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipfilter++;

        break;
        }

        case 371:
        {
        samplerCUBE____fx_samplerCUBE_common__ValidationData* parentValidationData = (samplerCUBE____fx_samplerCUBE_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipfilter++;

        break;
        }

        case 598:
        {
        samplerRECT____fx_samplerRECT_common__ValidationData* parentValidationData = (samplerRECT____fx_samplerRECT_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipfilter++;

        break;
        }

        case 257:
        {
        sampler1D____gl_sampler1D__ValidationData* parentValidationData = (sampler1D____gl_sampler1D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipfilter++;

        break;
        }

        case 258:
        {
        sampler2D____gl_sampler2D__ValidationData* parentValidationData = (sampler2D____gl_sampler2D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipfilter++;

        break;
        }

        case 259:
        {
        sampler3D____gl_sampler3D__ValidationData* parentValidationData = (sampler3D____gl_sampler3D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipfilter++;

        break;
        }

        case 260:
        {
        samplerCUBE____gl_samplerCUBE__ValidationData* parentValidationData = (samplerCUBE____gl_samplerCUBE__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipfilter++;

        break;
        }

        case 261:
        {
        samplerRECT____gl_samplerRECT__ValidationData* parentValidationData = (samplerRECT____gl_samplerRECT__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->border_color != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: border_color" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipfilter++;

        break;
        }

        case 538:
        {
        sampler_state____gles_sampler_state__ValidationData* parentValidationData = (sampler_state____gles_sampler_state__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipfilter >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipfilter++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__mipfilter()
{
    return true;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_color_common( const float* value, size_t length )
{
    if( length < 4 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_color_common__stream( const float* value, size_t length )
{

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
ParserError::ErrorType validate__fx_color_common__streamEnd( const float* value, size_t length )
{
    if( length < 4 )
        return ParserError::ERROR_VALIDATION_MIN_LENGTH;

    if( length > 4 )
        return ParserError::ERROR_VALIDATION_MAX_LENGTH;

    return ParserError::SIMPLE_TYPE_VALIDATION_OK;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__border_color( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 592:
        {
        sampler1D____cg_sampler1D__ValidationData* parentValidationData = (sampler1D____cg_sampler1D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->border_color >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->border_color++;

        break;
        }

        case 608:
        {
        sampler2D____cg_sampler2D__ValidationData* parentValidationData = (sampler2D____cg_sampler2D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->border_color >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->border_color++;

        break;
        }

        case 616:
        {
        sampler3D____cg_sampler3D__ValidationData* parentValidationData = (sampler3D____cg_sampler3D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->border_color >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->border_color++;

        break;
        }

        case 370:
        {
        samplerCUBE____cg_samplerCUBE__ValidationData* parentValidationData = (samplerCUBE____cg_samplerCUBE__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->border_color >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->border_color++;

        break;
        }

        case 597:
        {
        samplerRECT____cg_samplerRECT__ValidationData* parentValidationData = (samplerRECT____cg_samplerRECT__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->border_color >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->border_color++;

        break;
        }

        case 593:
        {
        sampler1D____fx_sampler1D_common__ValidationData* parentValidationData = (sampler1D____fx_sampler1D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->border_color >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->border_color++;

        break;
        }

        case 609:
        {
        sampler2D____fx_sampler2D_common__ValidationData* parentValidationData = (sampler2D____fx_sampler2D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->border_color >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->border_color++;

        break;
        }

        case 617:
        {
        sampler3D____fx_sampler3D_common__ValidationData* parentValidationData = (sampler3D____fx_sampler3D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->border_color >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->border_color++;

        break;
        }

        case 371:
        {
        samplerCUBE____fx_samplerCUBE_common__ValidationData* parentValidationData = (samplerCUBE____fx_samplerCUBE_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->border_color >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->border_color++;

        break;
        }

        case 598:
        {
        samplerRECT____fx_samplerRECT_common__ValidationData* parentValidationData = (samplerRECT____fx_samplerRECT_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->border_color >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->border_color++;

        break;
        }

        case 257:
        {
        sampler1D____gl_sampler1D__ValidationData* parentValidationData = (sampler1D____gl_sampler1D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->border_color >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->border_color++;

        break;
        }

        case 258:
        {
        sampler2D____gl_sampler2D__ValidationData* parentValidationData = (sampler2D____gl_sampler2D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->border_color >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->border_color++;

        break;
        }

        case 259:
        {
        sampler3D____gl_sampler3D__ValidationData* parentValidationData = (sampler3D____gl_sampler3D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->border_color >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->border_color++;

        break;
        }

        case 260:
        {
        samplerCUBE____gl_samplerCUBE__ValidationData* parentValidationData = (samplerCUBE____gl_samplerCUBE__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->border_color >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->border_color++;

        break;
        }

        case 261:
        {
        samplerRECT____gl_samplerRECT__ValidationData* parentValidationData = (samplerRECT____gl_samplerRECT__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_maxlevel" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->border_color >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_BORDER_COLOR, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->border_color++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        border_color__ValidationData* validationData = (border_color__ValidationData*)mValidationDataStack.newObject(sizeof(border_color__ValidationData));
        memset(validationData, 0, sizeof(border_color__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__border_color()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__mipmap_maxlevel( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 592:
        {
        sampler1D____cg_sampler1D__ValidationData* parentValidationData = (sampler1D____cg_sampler1D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_maxlevel++;

        break;
        }

        case 608:
        {
        sampler2D____cg_sampler2D__ValidationData* parentValidationData = (sampler2D____cg_sampler2D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_maxlevel++;

        break;
        }

        case 616:
        {
        sampler3D____cg_sampler3D__ValidationData* parentValidationData = (sampler3D____cg_sampler3D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_maxlevel++;

        break;
        }

        case 370:
        {
        samplerCUBE____cg_samplerCUBE__ValidationData* parentValidationData = (samplerCUBE____cg_samplerCUBE__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_maxlevel++;

        break;
        }

        case 597:
        {
        samplerRECT____cg_samplerRECT__ValidationData* parentValidationData = (samplerRECT____cg_samplerRECT__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_maxlevel++;

        break;
        }

        case 593:
        {
        sampler1D____fx_sampler1D_common__ValidationData* parentValidationData = (sampler1D____fx_sampler1D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_maxlevel++;

        break;
        }

        case 609:
        {
        sampler2D____fx_sampler2D_common__ValidationData* parentValidationData = (sampler2D____fx_sampler2D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_maxlevel++;

        break;
        }

        case 617:
        {
        sampler3D____fx_sampler3D_common__ValidationData* parentValidationData = (sampler3D____fx_sampler3D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_maxlevel++;

        break;
        }

        case 371:
        {
        samplerCUBE____fx_samplerCUBE_common__ValidationData* parentValidationData = (samplerCUBE____fx_samplerCUBE_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_maxlevel++;

        break;
        }

        case 598:
        {
        samplerRECT____fx_samplerRECT_common__ValidationData* parentValidationData = (samplerRECT____fx_samplerRECT_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_maxlevel++;

        break;
        }

        case 257:
        {
        sampler1D____gl_sampler1D__ValidationData* parentValidationData = (sampler1D____gl_sampler1D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_maxlevel++;

        break;
        }

        case 258:
        {
        sampler2D____gl_sampler2D__ValidationData* parentValidationData = (sampler2D____gl_sampler2D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_maxlevel++;

        break;
        }

        case 259:
        {
        sampler3D____gl_sampler3D__ValidationData* parentValidationData = (sampler3D____gl_sampler3D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_maxlevel++;

        break;
        }

        case 260:
        {
        samplerCUBE____gl_samplerCUBE__ValidationData* parentValidationData = (samplerCUBE____gl_samplerCUBE__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_maxlevel++;

        break;
        }

        case 261:
        {
        samplerRECT____gl_samplerRECT__ValidationData* parentValidationData = (samplerRECT____gl_samplerRECT__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_maxlevel++;

        break;
        }

        case 538:
        {
        sampler_state____gles_sampler_state__ValidationData* parentValidationData = (sampler_state____gles_sampler_state__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->mipmap_bias != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: mipmap_bias" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_maxlevel >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_MAXLEVEL, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_maxlevel++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__mipmap_maxlevel()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__mipmap_bias( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 592:
        {
        sampler1D____cg_sampler1D__ValidationData* parentValidationData = (sampler1D____cg_sampler1D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_bias++;

        break;
        }

        case 608:
        {
        sampler2D____cg_sampler2D__ValidationData* parentValidationData = (sampler2D____cg_sampler2D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_bias++;

        break;
        }

        case 616:
        {
        sampler3D____cg_sampler3D__ValidationData* parentValidationData = (sampler3D____cg_sampler3D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_bias++;

        break;
        }

        case 370:
        {
        samplerCUBE____cg_samplerCUBE__ValidationData* parentValidationData = (samplerCUBE____cg_samplerCUBE__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_bias++;

        break;
        }

        case 597:
        {
        samplerRECT____cg_samplerRECT__ValidationData* parentValidationData = (samplerRECT____cg_samplerRECT__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_bias++;

        break;
        }

        case 593:
        {
        sampler1D____fx_sampler1D_common__ValidationData* parentValidationData = (sampler1D____fx_sampler1D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_bias++;

        break;
        }

        case 609:
        {
        sampler2D____fx_sampler2D_common__ValidationData* parentValidationData = (sampler2D____fx_sampler2D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_bias++;

        break;
        }

        case 617:
        {
        sampler3D____fx_sampler3D_common__ValidationData* parentValidationData = (sampler3D____fx_sampler3D_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_bias++;

        break;
        }

        case 371:
        {
        samplerCUBE____fx_samplerCUBE_common__ValidationData* parentValidationData = (samplerCUBE____fx_samplerCUBE_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_bias++;

        break;
        }

        case 598:
        {
        samplerRECT____fx_samplerRECT_common__ValidationData* parentValidationData = (samplerRECT____fx_samplerRECT_common__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_bias++;

        break;
        }

        case 257:
        {
        sampler1D____gl_sampler1D__ValidationData* parentValidationData = (sampler1D____gl_sampler1D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_bias++;

        break;
        }

        case 258:
        {
        sampler2D____gl_sampler2D__ValidationData* parentValidationData = (sampler2D____gl_sampler2D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_bias++;

        break;
        }

        case 259:
        {
        sampler3D____gl_sampler3D__ValidationData* parentValidationData = (sampler3D____gl_sampler3D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_bias++;

        break;
        }

        case 260:
        {
        samplerCUBE____gl_samplerCUBE__ValidationData* parentValidationData = (samplerCUBE____gl_samplerCUBE__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_bias++;

        break;
        }

        case 261:
        {
        samplerRECT____gl_samplerRECT__ValidationData* parentValidationData = (samplerRECT____gl_samplerRECT__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_bias++;

        break;
        }

        case 538:
        {
        sampler_state____gles_sampler_state__ValidationData* parentValidationData = (sampler_state____gles_sampler_state__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->extra != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, "sibling: extra" ) )
                return false;
        }
        if ( parentValidationData->mipmap_bias >= 1 ) // maxOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MAX_OCCURS_EXCEEDED, HASH_ELEMENT_MIPMAP_BIAS, (const ParserChar*)0, 0 ) )
                return false;
        }
        parentValidationData->mipmap_bias++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__mipmap_bias()
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__sampler2D____fx_sampler2D_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 469:
        {
        instance_effect__setparam__ValidationData* parentValidationData = (instance_effect__setparam__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SAMPLER2D, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SAMPLER2D;
        }
//        parentValidationData->sampler2D++;

        break;
        }

        case 148:
        {
        newparam____common_newparam_type__ValidationData* parentValidationData = (newparam____common_newparam_type__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SAMPLER2D, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SAMPLER2D;
        }
//        parentValidationData->sampler2D++;

        break;
        }

        case 149:
        {
        newparam____fx_newparam_common__ValidationData* parentValidationData = (newparam____fx_newparam_common__ValidationData*)mValidationDataStack.top();
        if ( !( (parentValidationData->validation_current_state == HASH_ELEMENT_ANNOTATE) || (parentValidationData->validation_current_state == HASH_ELEMENT_MODIFIER) || (parentValidationData->validation_current_state == HASH_ELEMENT_SEMANTIC) || (parentValidationData->validation_current_state == STATE_MACHINE_ROOT) ) )
        {
            if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_UNEXPECTED_ELEMENT, HASH_ELEMENT_SAMPLER2D, (const ParserChar*)0, 0) )
                return false;
        }
        else
        {
            parentValidationData->validation_current_state = HASH_ELEMENT_SAMPLER2D;
        }
//        parentValidationData->sampler2D++;

        break;
        }

        default:
            // TODO we could throw some error here
            break;
        }
        sampler2D____fx_sampler2D_common__ValidationData* validationData = (sampler2D____fx_sampler2D_common__ValidationData*)mValidationDataStack.newObject(sizeof(sampler2D____fx_sampler2D_common__ValidationData));
        memset(validationData, 0, sizeof(sampler2D____fx_sampler2D_common__ValidationData));


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateEnd__sampler2D____fx_sampler2D_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        sampler2D____fx_sampler2D_common__ValidationData* validationData = (sampler2D____fx_sampler2D_common__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
        if ( validationData->source < 1 ) // children minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_MIN_OCCURS_UNMATCHED, HASH_ELEMENT_SAMPLER2D, (const ParserChar*)0, "child: source" ) )
                return false;
        }

        mValidationDataStack.deleteObject();


    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen14Private::_validateBegin__wrap_t____fx_sampler_wrap_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        switch ( mElementDataStack.back().typeID )
        {
        case 608:
        {
        sampler2D____cg_sampler2D__ValidationData* parentValidationData = (sampler2D____cg_sampler2D__ValidationData*)mValidationDataStack.top();
        if ( parentValidationData->source < 1 ) // previous sibling minOccurs
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_PREVIOUS_SIBLING_NOT_PRESENT, HASH_ELEMENT_WRAP_T, (const ParserChar*)0, "sibling: source" ) )
                return false;
        }
        if ( parentValidationData->minfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_T, (const ParserChar*)0, "sibling: minfilter" ) )
                return false;
        }
        if ( parentValidationData->magfilter != 0 ) // following sibling
        {
            if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_VALIDATION_SEQUENCE_NEXT_SIBLING_ALREADY_PRESENT, HASH_ELEMENT_WRAP_T, (const ParserChar*)0, "sibling: magfilter" ) )
                return false;
        }
        if ( parentValidationData->mipfilter != 0 ) // following sibling
        {
     