/*################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################*/

#include "OpenDRIM_GroupOnSystemAccess.h"

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(Simple_Identity_Management_CIM_Collection_load(broker, errorMessage));
	CF_assert(Simple_Identity_Management_CIM_ManagedElement_load(broker, errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_unload(string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(Simple_Identity_Management_CIM_Collection_unload(errorMessage));
	CF_assert(Simple_Identity_Management_CIM_ManagedElement_unload(errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_isAssociated(const Instance& OwnedElement, const Instance& OwningElement, bool& isAssociated, string& errorMessage) {
	_E_;
	// TODO Determine if the association can be established or not
	isAssociated=true;
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_GroupOnSystem>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> subjects;
	// Only get the instance names
	CF_assert(Simple_Identity_Management_OpenDRIM_GroupOnSystem_enumerateOwnedElements(broker, ctx, subjects, NULL, true, errorMessage));
	// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
	// CF_assert(Simple_Identity_Management_OpenDRIM_GroupOnSystem_enumerateOwnedElements(broker, ctx, subjects, NULL, false, errorMessage));
	vector<Instance>::iterator c = subjects.begin();
	vector<Instance>::iterator end = subjects.end();
	for (; c != end; ++c) {
		bool leftToRight = true;
		vector<Instance> associatedInstances;
		Simple_Identity_Management_OpenDRIM_GroupOnSystem_associator(broker, ctx,
			(*c).getObjectpath().getHdl(), (*c),
			OwnedElement_classnames[0], OwningElement_classnames[0],
			OwnedElement_role.c_str(), OwningElement_role.c_str(), NULL,
			associatedInstances, leftToRight, errorMessage, "an");

		string ref_discriminant = discriminant == "ein" ? "rn" : "r";
		CF_assert(Simple_Identity_Management_OpenDRIM_GroupOnSystem_referenceOwnedElementToOwningElement(broker, ctx, (*c), associatedInstances, result, NULL, errorMessage, ref_discriminant));
	}
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_GroupOnSystem& instance, const char** properties, string& errorMessage) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	Objectpath OwnedElement_objectpath;
	instance.getOwnedElement(OwnedElement_objectpath);
	Instance OwnedElement_instance;
	CF_assert(Simple_Identity_Management_OpenDRIM_GroupOnSystem_getOwnedElement(broker, ctx, OwnedElement_objectpath, OwnedElement_instance, NULL, errorMessage));
	
	Objectpath OwningElement_objectpath;
	instance.getOwningElement(OwningElement_objectpath);
	Instance OwningElement_instance;
	CF_assert(Simple_Identity_Management_OpenDRIM_GroupOnSystem_getOwningElement(broker, ctx, OwningElement_objectpath, OwningElement_instance, NULL, errorMessage));

	bool isAssociated = false;
	CF_assert(Simple_Identity_Management_OpenDRIM_GroupOnSystem_isAssociated(OwnedElement_instance, OwningElement_instance, isAssociated, errorMessage));
	if (!isAssociated)
	{
		if(errorMessage.empty())
			errorMessage = "No instance";
		
		return NOT_FOUND;
	}
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_GroupOnSystem& newInstance, const OpenDRIM_GroupOnSystem& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_GroupOnSystem& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_GroupOnSystem& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_associatorOwnedElementToOwningElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& OwnedElement_instance, const char** properties, vector<Instance>& OwningElement_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> OwningElement_instances;
	if (discriminant=="a")
		CF_assert(Simple_Identity_Management_OpenDRIM_GroupOnSystem_enumerateOwningElements(broker, ctx, OwningElement_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(Simple_Identity_Management_OpenDRIM_GroupOnSystem_enumerateOwningElements(broker, ctx, OwningElement_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(Simple_Identity_Management_OpenDRIM_GroupOnSystem_enumerateOwningElements(broker, ctx, OwningElement_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<OwningElement_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(Simple_Identity_Management_OpenDRIM_GroupOnSystem_isAssociated(OwnedElement_instance, OwningElement_instances[i], isAssociated, errorMessage));
		if (isAssociated)
			OwningElement_associatedInstances.push_back(OwningElement_instances[i]);
	}
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_associatorOwningElementToOwnedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& OwningElement_instance, const char** properties, vector<Instance>& OwnedElement_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> OwnedElement_instances;
	if (discriminant=="a")
		CF_assert(Simple_Identity_Management_OpenDRIM_GroupOnSystem_enumerateOwnedElements(broker, ctx, OwnedElement_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(Simple_Identity_Management_OpenDRIM_GroupOnSystem_enumerateOwnedElements(broker, ctx, OwnedElement_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(Simple_Identity_Management_OpenDRIM_GroupOnSystem_enumerateOwnedElements(broker, ctx, OwnedElement_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<OwnedElement_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(Simple_Identity_Management_OpenDRIM_GroupOnSystem_isAssociated(OwnedElement_instances[i], OwningElement_instance, isAssociated, errorMessage));
		if (isAssociated)
			OwnedElement_associatedInstances.push_back(OwnedElement_instances[i]);
	}
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_referenceOwnedElementToOwningElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& OwnedElement_instance, const vector<Instance>& OwningElement_instances, vector<OpenDRIM_GroupOnSystem>& OpenDRIM_GroupOnSystem_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < OwningElement_instances.size(); i++) {
		OpenDRIM_GroupOnSystem instance;
		instance.setOwnedElement(((Instance) OwnedElement_instance).getObjectpath());
		instance.setOwningElement(((Instance) OwningElement_instances[i]).getObjectpath());
		
		OpenDRIM_GroupOnSystem_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_referenceOwningElementToOwnedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& OwningElement_instance, const vector<Instance>& OwnedElement_instances, vector<OpenDRIM_GroupOnSystem>& OpenDRIM_GroupOnSystem_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < OwnedElement_instances.size(); i++) {
		OpenDRIM_GroupOnSystem instance;
		instance.setOwnedElement(((Instance) OwnedElement_instances[i]).getObjectpath());
		instance.setOwningElement(((Instance) OwningElement_instance).getObjectpath());
		
		OpenDRIM_GroupOnSystem_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int Simple_Identity_Management_OpenDRIM_GroupOnSystem_populate(OpenDRIM_GroupOnSystem& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

