/******************************************************************************
 * Author:   Laurent Kneip                                                    *
 * Contact:  kneip.laurent@gmail.com                                          *
 * License:  Copyright (c) 2013 Laurent Kneip, ANU. All rights reserved.      *
 *                                                                            *
 * Redistribution and use in source and binary forms, with or without         *
 * modification, are permitted provided that the following conditions         *
 * are met:                                                                   *
 * * Redistributions of source code must retain the above copyright           *
 *   notice, this list of conditions and the following disclaimer.            *
 * * Redistributions in binary form must reproduce the above copyright        *
 *   notice, this list of conditions and the following disclaimer in the      *
 *   documentation and/or other materials provided with the distribution.     *
 * * Neither the name of ANU nor the names of its contributors may be         *
 *   used to endorse or promote products derived from this software without   *
 *   specific prior written permission.                                       *
 *                                                                            *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"*
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE  *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE *
 * ARE DISCLAIMED. IN NO EVENT SHALL ANU OR THE CONTRIBUTORS BE LIABLE        *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR *
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER *
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT         *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY  *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF     *
 * SUCH DAMAGE.                                                               *
 ******************************************************************************/


#include <opengv/absolute_pose/modules/gpnp4/modules.hpp>


void
opengv::absolute_pose::modules::gpnp4::init(
    Eigen::Matrix<double,25,37> & groebnerMatrix,
    const Eigen::Matrix<double,12,1> & a,
    Eigen::Matrix<double,12,1> & n,
    Eigen::Matrix<double,12,1> & m,
    Eigen::Matrix<double,12,1> & k,
    Eigen::Matrix<double,12,1> & l,
    Eigen::Vector3d & c0,
    Eigen::Vector3d & c1,
    Eigen::Vector3d & c2,
    Eigen::Vector3d & c3 )
{
  Eigen::Vector3d temp = c0-c1;
  double c01w = temp.norm()*temp.norm();
  temp = c0-c2;
  double c02w = temp.norm()*temp.norm();
  temp = c0-c3;
  double c03w = temp.norm()*temp.norm();
  temp = c1-c2;
  double c12w = temp.norm()*temp.norm();
  temp = c1-c3;
  double c13w = temp.norm()*temp.norm();

  groebnerMatrix(0,22) = ((((((((-2*l(0,0)*l(3,0)-2*l(1,0)*l(4,0))-2*l(2,0)*l(5,0))+pow(l(0,0),2))+pow(l(3,0),2))+pow(l(1,0),2))+pow(l(4,0),2))+pow(l(2,0),2))+pow(l(5,0),2));
  groebnerMatrix(0,23) = (((((((((((2*k(0,0)*l(0,0)-2*k(0,0)*l(3,0))-2*l(0,0)*k(3,0))+2*k(3,0)*l(3,0))+2*k(1,0)*l(1,0))-2*k(1,0)*l(4,0))-2*l(1,0)*k(4,0))+2*k(4,0)*l(4,0))+2*k(2,0)*l(2,0))-2*k(2,0)*l(5,0))-2*l(2,0)*k(5,0))+2*k(5,0)*l(5,0));
  groebnerMatrix(0,24) = ((((((((-2*k(0,0)*k(3,0)-2*k(1,0)*k(4,0))-2*k(2,0)*k(5,0))+pow(k(0,0),2))+pow(k(3,0),2))+pow(k(1,0),2))+pow(k(4,0),2))+pow(k(2,0),2))+pow(k(5,0),2));
  groebnerMatrix(0,25) = (((((((((((2*m(2,0)*l(2,0)+2*m(0,0)*l(0,0))-2*m(0,0)*l(3,0))-2*l(0,0)*m(3,0))+2*m(3,0)*l(3,0))+2*m(1,0)*l(1,0))-2*m(1,0)*l(4,0))-2*l(1,0)*m(4,0))+2*m(4,0)*l(4,0))-2*m(2,0)*l(5,0))-2*l(2,0)*m(5,0))+2*m(5,0)*l(5,0));
  groebnerMatrix(0,26) = (((((((((((2*m(2,0)*k(2,0)+2*m(0,0)*k(0,0))-2*m(0,0)*k(3,0))-2*k(0,0)*m(3,0))+2*m(3,0)*k(3,0))+2*m(1,0)*k(1,0))-2*m(1,0)*k(4,0))-2*k(1,0)*m(4,0))+2*m(4,0)*k(4,0))-2*m(2,0)*k(5,0))-2*k(2,0)*m(5,0))+2*m(5,0)*k(5,0));
  groebnerMatrix(0,27) = ((((((((-2*m(0,0)*m(3,0)-2*m(1,0)*m(4,0))-2*m(2,0)*m(5,0))+pow(m(0,0),2))+pow(m(3,0),2))+pow(m(1,0),2))+pow(m(4,0),2))+pow(m(2,0),2))+pow(m(5,0),2));
  groebnerMatrix(0,28) = (((((((((((2*n(0,0)*l(0,0)-2*n(0,0)*l(3,0))-2*l(0,0)*n(3,0))+2*n(3,0)*l(3,0))+2*n(1,0)*l(1,0))-2*n(1,0)*l(4,0))-2*l(1,0)*n(4,0))+2*n(4,0)*l(4,0))+2*n(2,0)*l(2,0))-2*n(2,0)*l(5,0))-2*l(2,0)*n(5,0))+2*n(5,0)*l(5,0));
  groebnerMatrix(0,29) = (((((((((((2*n(0,0)*k(0,0)-2*n(0,0)*k(3,0))-2*k(0,0)*n(3,0))+2*n(3,0)*k(3,0))+2*n(1,0)*k(1,0))-2*n(1,0)*k(4,0))-2*k(1,0)*n(4,0))+2*n(4,0)*k(4,0))+2*n(2,0)*k(2,0))-2*n(2,0)*k(5,0))-2*k(2,0)*n(5,0))+2*n(5,0)*k(5,0));
  groebnerMatrix(0,30) = (((((((((((2*n(0,0)*m(0,0)-2*n(0,0)*m(3,0))-2*m(0,0)*n(3,0))+2*n(3,0)*m(3,0))+2*n(1,0)*m(1,0))-2*n(1,0)*m(4,0))-2*m(1,0)*n(4,0))+2*n(4,0)*m(4,0))+2*n(2,0)*m(2,0))-2*n(2,0)*m(5,0))-2*m(2,0)*n(5,0))+2*n(5,0)*m(5,0));
  groebnerMatrix(0,31) = ((((((((-2*n(0,0)*n(3,0)-2*n(1,0)*n(4,0))-2*n(2,0)*n(5,0))+pow(n(0,0),2))+pow(n(3,0),2))+pow(n(1,0),2))+pow(n(4,0),2))+pow(n(2,0),2))+pow(n(5,0),2));
  groebnerMatrix(0,32) = (((((((((((2*a(0,0)*l(0,0)-2*a(0,0)*l(3,0))-2*l(0,0)*a(3,0))+2*a(3,0)*l(3,0))+2*a(1,0)*l(1,0))-2*a(1,0)*l(4,0))-2*l(1,0)*a(4,0))+2*a(4,0)*l(4,0))+2*a(2,0)*l(2,0))-2*a(2,0)*l(5,0))-2*l(2,0)*a(5,0))+2*a(5,0)*l(5,0));
  groebnerMatrix(0,33) = (((((((((((2*a(0,0)*k(0,0)-2*a(0,0)*k(3,0))-2*k(0,0)*a(3,0))+2*a(3,0)*k(3,0))+2*a(1,0)*k(1,0))-2*a(1,0)*k(4,0))-2*k(1,0)*a(4,0))+2*a(4,0)*k(4,0))+2*a(2,0)*k(2,0))-2*a(2,0)*k(5,0))-2*k(2,0)*a(5,0))+2*a(5,0)*k(5,0));
  groebnerMatrix(0,34) = (((((((((((2*a(0,0)*m(0,0)-2*a(0,0)*m(3,0))-2*m(0,0)*a(3,0))+2*a(3,0)*m(3,0))+2*a(1,0)*m(1,0))-2*a(1,0)*m(4,0))-2*m(1,0)*a(4,0))+2*a(4,0)*m(4,0))+2*a(2,0)*m(2,0))-2*a(2,0)*m(5,0))-2*m(2,0)*a(5,0))+2*a(5,0)*m(5,0));
  groebnerMatrix(0,35) = (((((((((((2*a(0,0)*n(0,0)-2*a(0,0)*n(3,0))-2*n(0,0)*a(3,0))+2*a(3,0)*n(3,0))+2*a(1,0)*n(1,0))-2*a(1,0)*n(4,0))-2*n(1,0)*a(4,0))+2*a(4,0)*n(4,0))+2*a(2,0)*n(2,0))-2*a(2,0)*n(5,0))-2*n(2,0)*a(5,0))+2*a(5,0)*n(5,0));
  groebnerMatrix(0,36) = (((((((((-c01w+pow(a(0,0),2))-2*a(0,0)*a(3,0))+pow(a(3,0),2))+pow(a(1,0),2))-2*a(1,0)*a(4,0))+pow(a(4,0),2))+pow(a(2,0),2))-2*a(2,0)*a(5,0))+pow(a(5,0),2));
  groebnerMatrix(1,22) = ((((((((-2*l(0,0)*l(6,0)-2*l(1,0)*l(7,0))-2*l(2,0)*l(8,0))+pow(l(0,0),2))+pow(l(1,0),2))+pow(l(2,0),2))+pow(l(6,0),2))+pow(l(7,0),2))+pow(l(8,0),2));
  groebnerMatrix(1,23) = (((((((((((2*k(0,0)*l(0,0)+2*k(1,0)*l(1,0))+2*k(2,0)*l(2,0))-2*k(0,0)*l(6,0))-2*l(0,0)*k(6,0))+2*k(6,0)*l(6,0))-2*k(1,0)*l(7,0))-2*l(1,0)*k(7,0))+2*k(7,0)*l(7,0))-2*k(2,0)*l(8,0))-2*l(2,0)*k(8,0))+2*k(8,0)*l(8,0));
  groebnerMatrix(1,24) = ((((((((-2*k(0,0)*k(6,0)-2*k(1,0)*k(7,0))-2*k(2,0)*k(8,0))+pow(k(0,0),2))+pow(k(1,0),2))+pow(k(2,0),2))+pow(k(6,0),2))+pow(k(7,0),2))+pow(k(8,0),2));
  groebnerMatrix(1,25) = (((((((((((2*m(2,0)*l(2,0)+2*m(0,0)*l(0,0))+2*m(1,0)*l(1,0))-2*m(0,0)*l(6,0))-2*l(0,0)*m(6,0))+2*m(6,0)*l(6,0))-2*m(1,0)*l(7,0))-2*l(1,0)*m(7,0))+2*m(7,0)*l(7,0))-2*m(2,0)*l(8,0))-2*l(2,0)*m(8,0))+2*m(8,0)*l(8,0));
  groebnerMatrix(1,26) = (((((((((((2*m(2,0)*k(2,0)+2*m(0,0)*k(0,0))+2*m(1,0)*k(1,0))-2*m(0,0)*k(6,0))-2*k(0,0)*m(6,0))+2*m(6,0)*k(6,0))-2*m(1,0)*k(7,0))-2*k(1,0)*m(7,0))+2*m(7,0)*k(7,0))-2*m(2,0)*k(8,0))-2*k(2,0)*m(8,0))+2*m(8,0)*k(8,0));
  groebnerMatrix(1,27) = ((((((((-2*m(0,0)*m(6,0)-2*m(1,0)*m(7,0))-2*m(2,0)*m(8,0))+pow(m(0,0),2))+pow(m(1,0),2))+pow(m(2,0),2))+pow(m(6,0),2))+pow(m(7,0),2))+pow(m(8,0),2));
  groebnerMatrix(1,28) = (((((((((((2*n(0,0)*l(0,0)+2*n(1,0)*l(1,0))+2*n(2,0)*l(2,0))-2*n(0,0)*l(6,0))-2*l(0,0)*n(6,0))+2*n(6,0)*l(6,0))-2*n(1,0)*l(7,0))-2*l(1,0)*n(7,0))+2*n(7,0)*l(7,0))-2*n(2,0)*l(8,0))-2*l(2,0)*n(8,0))+2*n(8,0)*l(8,0));
  groebnerMatrix(1,29) = (((((((((((2*n(0,0)*k(0,0)+2*n(1,0)*k(1,0))+2*n(2,0)*k(2,0))-2*n(0,0)*k(6,0))-2*k(0,0)*n(6,0))+2*n(6,0)*k(6,0))-2*n(1,0)*k(7,0))-2*k(1,0)*n(7,0))+2*n(7,0)*k(7,0))-2*n(2,0)*k(8,0))-2*k(2,0)*n(8,0))+2*n(8,0)*k(8,0));
  groebnerMatrix(1,30) = (((((((((((2*n(0,0)*m(0,0)+2*n(1,0)*m(1,0))+2*n(2,0)*m(2,0))-2*n(0,0)*m(6,0))-2*m(0,0)*n(6,0))+2*n(6,0)*m(6,0))-2*n(1,0)*m(7,0))-2*m(1,0)*n(7,0))+2*n(7,0)*m(7,0))-2*n(2,0)*m(8,0))-2*m(2,0)*n(8,0))+2*n(8,0)*m(8,0));
  groebnerMatrix(1,31) = ((((((((-2*n(0,0)*n(6,0)-2*n(1,0)*n(7,0))-2*n(2,0)*n(8,0))+pow(n(0,0),2))+pow(n(1,0),2))+pow(n(2,0),2))+pow(n(6,0),2))+pow(n(7,0),2))+pow(n(8,0),2));
  groebnerMatrix(1,32) = (((((((((((-2*a(0,0)*l(6,0)+2*a(0,0)*l(0,0))+2*a(1,0)*l(1,0))+2*a(2,0)*l(2,0))-2*l(0,0)*a(6,0))+2*a(6,0)*l(6,0))-2*a(1,0)*l(7,0))-2*l(1,0)*a(7,0))+2*a(7,0)*l(7,0))-2*a(2,0)*l(8,0))-2*l(2,0)*a(8,0))+2*a(8,0)*l(8,0));
  groebnerMatrix(1,33) = (((((((((((-2*a(0,0)*k(6,0)+2*a(0,0)*k(0,0))+2*a(1,0)*k(1,0))+2*a(2,0)*k(2,0))-2*k(0,0)*a(6,0))+2*a(6,0)*k(6,0))-2*a(1,0)*k(7,0))-2*k(1,0)*a(7,0))+2*a(7,0)*k(7,0))-2*a(2,0)*k(8,0))-2*k(2,0)*a(8,0))+2*a(8,0)*k(8,0));
  groebnerMatrix(1,34) = (((((((((((-2*a(0,0)*m(6,0)-2*m(0,0)*a(6,0))+2*a(0,0)*m(0,0))+2*a(1,0)*m(1,0))+2*a(2,0)*m(2,0))+2*a(6,0)*m(6,0))-2*a(1,0)*m(7,0))-2*m(1,0)*a(7,0))+2*a(7,0)*m(7,0))-2*a(2,0)*m(8,0))-2*m(2,0)*a(8,0))+2*a(8,0)*m(8,0));
  groebnerMatrix(1,35) = (((((((((((-2*a(0,0)*n(6,0)-2*n(0,0)*a(6,0))+2*a(0,0)*n(0,0))+2*a(1,0)*n(1,0))+2*a(2,0)*n(2,0))+2*a(6,0)*n(6,0))-2*a(1,0)*n(7,0))-2*n(1,0)*a(7,0))+2*a(7,0)*n(7,0))-2*a(2,0)*n(8,0))-2*n(2,0)*a(8,0))+2*a(8,0)*n(8,0));
  groebnerMatrix(1,36) = (((((((((-c02w+pow(a(0,0),2))+pow(a(1,0),2))+pow(a(2,0),2))-2*a(0,0)*a(6,0))+pow(a(6,0),2))-2*a(1,0)*a(7,0))+pow(a(7,0),2))-2*a(2,0)*a(8,0))+pow(a(8,0),2));
  groebnerMatrix(2,22) = ((((((((pow(l(0,0),2)+pow(l(1,0),2))+pow(l(2,0),2))-2*l(0,0)*l(9,0))-2*l(1,0)*l(10,0))-2*l(2,0)*l(11,0))+pow(l(9,0),2))+pow(l(10,0),2))+pow(l(11,0),2));
  groebnerMatrix(2,23) = (((((((((((2*k(0,0)*l(0,0)+2*k(1,0)*l(1,0))+2*k(2,0)*l(2,0))-2*k(0,0)*l(9,0))-2*l(0,0)*k(9,0))+2*k(9,0)*l(9,0))-2*k(1,0)*l(10,0))-2*l(1,0)*k(10,0))+2*k(10,0)*l(10,0))-2*k(2,0)*l(11,0))-2*l(2,0)*k(11,0))+2*k(11,0)*l(11,0));
  groebnerMatrix(2,24) = ((((((((pow(k(0,0),2)+pow(k(1,0),2))+pow(k(2,0),2))-2*k(0,0)*k(9,0))-2*k(1,0)*k(10,0))-2*k(2,0)*k(11,0))+pow(k(9,0),2))+pow(k(10,0),2))+pow(k(11,0),2));
  groebnerMatrix(2,25) = (((((((((((2*m(2,0)*l(2,0)+2*m(0,0)*l(0,0))+2*m(1,0)*l(1,0))-2*m(0,0)*l(9,0))-2*l(0,0)*m(9,0))+2*m(9,0)*l(9,0))-2*m(1,0)*l(10,0))-2*l(1,0)*m(10,0))+2*m(10,0)*l(10,0))-2*m(2,0)*l(11,0))-2*l(2,0)*m(11,0))+2*m(11,0)*l(11,0));
  groebnerMatrix(2,26) = (((((((((((2*m(2,0)*k(2,0)+2*m(0,0)*k(0,0))+2*m(1,0)*k(1,0))-2*m(0,0)*k(9,0))-2*k(0,0)*m(9,0))+2*m(9,0)*k(9,0))-2*m(1,0)*k(10,0))-2*k(1,0)*m(10,0))+2*m(10,0)*k(10,0))-2*m(2,0)*k(11,0))-2*k(2,0)*m(11,0))+2*m(11,0)*k(11,0));
  groebnerMatrix(2,27) = ((((((((pow(m(0,0),2)+pow(m(1,0),2))+pow(m(2,0),2))-2*m(0,0)*m(9,0))-2*m(1,0)*m(10,0))-2*m(2,0)*m(11,0))+pow(m(9,0),2))+pow(m(10,0),2))+pow(m(11,0),2));
  groebnerMatrix(2,28) = (((((((((((2*n(0,0)*l(0,0)+2*n(1,0)*l(1,0))+2*n(2,0)*l(2,0))-2*n(0,0)*l(9,0))-2*l(0,0)*n(9,0))+2*n(9,0)*l(9,0))-2*n(1,0)*l(10,0))-2*l(1,0)*n(10,0))+2*n(10,0)*l(10,0))-2*n(2,0)*l(11,0))-2*l(2,0)*n(11,0))+2*n(11,0)*l(11,0));
  groebnerMatrix(2,29) = (((((((((((2*n(0,0)*k(0,0)+2*n(1,0)*k(1,0))+2*n(2,0)*k(2,0))-2*n(0,0)*k(9,0))-2*k(0,0)*n(9,0))+2*n(9,0)*k(9,0))-2*n(1,0)*k(10,0))-2*k(1,0)*n(10,0))+2*n(10,0)*k(10,0))-2*n(2,0)*k(11,0))-2*k(2,0)*n(11,0))+2*n(11,0)*k(11,0));
  groebnerMatrix(2,30) = (((((((((((2*n(0,0)*m(0,0)+2*n(1,0)*m(1,0))+2*n(2,0)*m(2,0))-2*n(0,0)*m(9,0))-2*m(0,0)*n(9,0))+2*n(9,0)*m(9,0))-2*n(1,0)*m(10,0))-2*m(1,0)*n(10,0))+2*n(10,0)*m(10,0))-2*n(2,0)*m(11,0))-2*m(2,0)*n(11,0))+2*n(11,0)*m(11,0));
  groebnerMatrix(2,31) = ((((((((pow(n(0,0),2)+pow(n(1,0),2))+pow(n(2,0),2))-2*n(0,0)*n(9,0))-2*n(1,0)*n(10,0))-2*n(2,0)*n(11,0))+pow(n(9,0),2))+pow(n(10,0),2))+pow(n(11,0),2));
  groebnerMatrix(2,32) = (((((((((((2*a(0,0)*l(0,0)+2*a(1,0)*l(1,0))+2*a(2,0)*l(2,0))-2*a(0,0)*l(9,0))-2*l(0,0)*a(9,0))+2*a(9,0)*l(9,0))-2*a(1,0)*l(10,0))-2*l(1,0)*a(10,0))+2*a(10,0)*l(10,0))-2*a(2,0)*l(11,0))-2*l(2,0)*a(11,0))+2*a(11,0)*l(11,0));
  groebnerMatrix(2,33) = (((((((((((2*a(0,0)*k(0,0)+2*a(1,0)*k(1,0))+2*a(2,0)*k(2,0))-2*a(0,0)*k(9,0))-2*k(0,0)*a(9,0))+2*a(9,0)*k(9,0))-2*a(1,0)*k(10,0))-2*k(1,0)*a(10,0))+2*a(10,0)*k(10,0))-2*a(2,0)*k(11,0))-2*k(2,0)*a(11,0))+2*a(11,0)*k(11,0));
  groebnerMatrix(2,34) = (((((((((((2*a(0,0)*m(0,0)+2*a(1,0)*m(1,0))+2*a(2,0)*m(2,0))-2*a(0,0)*m(9,0))-2*m(0,0)*a(9,0))+2*a(9,0)*m(9,0))-2*a(1,0)*m(10,0))-2*m(1,0)*a(10,0))+2*a(10,0)*m(10,0))-2*a(2,0)*m(11,0))-2*m(2,0)*a(11,0))+2*a(11,0)*m(11,0));
  groebnerMatrix(2,35) = (((((((((((2*a(0,0)*n(0,0)+2*a(1,0)*n(1,0))+2*a(2,0)*n(2,0))-2*a(0,0)*n(9,0))-2*n(0,0)*a(9,0))+2*a(9,0)*n(9,0))-2*a(1,0)*n(10,0))-2*n(1,0)*a(10,0))+2*a(10,0)*n(10,0))-2*a(2,0)*n(11,0))-2*n(2,0)*a(11,0))+2*a(11,0)*n(11,0));
  groebnerMatrix(2,36) = (((((((((-c03w+pow(a(0,0),2))+pow(a(1,0),2))+pow(a(2,0),2))-2*a(0,0)*a(9,0))+pow(a(9,0),2))-2*a(1,0)*a(10,0))+pow(a(10,0),2))-2*a(2,0)*a(11,0))+pow(a(11,0),2));
  groebnerMatrix(3,22) = ((((((((pow(l(3,0),2)+pow(l(4,0),2))+pow(l(5,0),2))+pow(l(6,0),2))+pow(l(7,0),2))+pow(l(8,0),2))-2*l(3,0)*l(6,0))-2*l(4,0)*l(7,0))-2*l(5,0)*l(8,0));
  groebnerMatrix(3,23) = (((((((((((2*k(3,0)*l(3,0)+2*k(4,0)*l(4,0))-2*k(4,0)*l(7,0))-2*l(4,0)*k(7,0))+2*k(5,0)*l(5,0))+2*k(6,0)*l(6,0))+2*k(7,0)*l(7,0))+2*k(8,0)*l(8,0))-2*k(3,0)*l(6,0))-2*l(3,0)*k(6,0))-2*k(5,0)*l(8,0))-2*l(5,0)*k(8,0));
  groebnerMatrix(3,24) = ((((((((pow(k(3,0),2)+pow(k(4,0),2))+pow(k(5,0),2))+pow(k(6,0),2))+pow(k(7,0),2))+pow(k(8,0),2))-2*k(3,0)*k(6,0))-2*k(4,0)*k(7,0))-2*k(5,0)*k(8,0));
  groebnerMatrix(3,25) = (((((((((((2*m(3,0)*l(3,0)+2*m(4,0)*l(4,0))-2*m(4,0)*l(7,0))-2*l(4,0)*m(7,0))+2*m(5,0)*l(5,0))+2*m(6,0)*l(6,0))+2*m(7,0)*l(7,0))+2*m(8,0)*l(8,0))-2*m(3,0)*l(6,0))-2*l(3,0)*m(6,0))-2*m(5,0)*l(8,0))-2*l(5,0)*m(8,0));
  groebnerMatrix(3,26) = (((((((((((2*m(3,0)*k(3,0)+2*m(4,0)*k(4,0))-2*m(4,0)*k(7,0))-2*k(4,0)*m(7,0))+2*m(5,0)*k(5,0))+2*m(6,0)*k(6,0))+2*m(7,0)*k(7,0))+2*m(8,0)*k(8,0))-2*m(3,0)*k(6,0))-2*k(3,0)*m(6,0))-2*m(5,0)*k(8,0))-2*k(5,0)*m(8,0));
  groebnerMatrix(3,27) = ((((((((pow(m(3,0),2)+pow(m(4,0),2))+pow(m(5,0),2))+pow(m(6,0),2))+pow(m(7,0),2))+pow(m(8,0),2))-2*m(3,0)*m(6,0))-2*m(4,0)*m(7,0))-2*m(5,0)*m(8,0));
  groebnerMatrix(3,28) = (((((((((((2*n(3,0)*l(3,0)+2*n(4,0)*l(4,0))-2*l(4,0)*n(7,0))+2*n(5,0)*l(5,0))+2*n(6,0)*l(6,0))+2*n(7,0)*l(7,0))+2*n(8,0)*l(8,0))-2*n(3,0)*l(6,0))-2*l(3,0)*n(6,0))-2*n(4,0)*l(7,0))-2*n(5,0)*l(8,0))-2*l(5,0)*n(8,0));
  groebnerMatrix(3,29) = (((((((((((2*n(3,0)*k(3,0)+2*n(4,0)*k(4,0))-2*k(4,0)*n(7,0))+2*n(5,0)*k(5,0))+2*n(6,0)*k(6,0))+2*n(7,0)*k(7,0))+2*n(8,0)*k(8,0))-2*n(3,0)*k(6,0))-2*k(3,0)*n(6,0))-2*n(4,0)*k(7,0))-2*n(5,0)*k(8,0))-2*k(5,0)*n(8,0));
  groebnerMatrix(3,30) = (((((((((((2*n(3,0)*m(3,0)+2*n(4,0)*m(4,0))-2*m(4,0)*n(7,0))+2*n(5,0)*m(5,0))+2*n(6,0)*m(6,0))+2*n(7,0)*m(7,0))+2*n(8,0)*m(8,0))-2*n(3,0)*m(6,0))-2*m(3,0)*n(6,0))-2*n(4,0)*m(7,0))-2*n(5,0)*m(8,0))-2*m(5,0)*n(8,0));
  groebnerMatrix(3,31) = ((((((((-2*n(3,0)*n(6,0)+pow(n(3,0),2))+pow(n(4,0),2))+pow(n(5,0),2))+pow(n(6,0),2))+pow(n(7,0),2))+pow(n(8,0),2))-2*n(4,0)*n(7,0))-2*n(5,0)*n(8,0));
  groebnerMatrix(3,32) = (((((((((((-2*a(3,0)*l(6,0)+2*a(3,0)*l(3,0))+2*a(4,0)*l(4,0))+2*a(5,0)*l(5,0))+2*a(6,0)*l(6,0))+2*a(7,0)*l(7,0))+2*a(8,0)*l(8,0))-2*l(3,0)*a(6,0))-2*a(4,0)*l(7,0))-2*l(4,0)*a(7,0))-2*a(5,0)*l(8,0))-2*l(5,0)*a(8,0));
  groebnerMatrix(3,33) = (((((((((((-2*a(3,0)*k(6,0)+2*a(3,0)*k(3,0))+2*a(4,0)*k(4,0))+2*a(5,0)*k(5,0))+2*a(6,0)*k(6,0))+2*a(7,0)*k(7,0))+2*a(8,0)*k(8,0))-2*k(3,0)*a(6,0))-2*a(4,0)*k(7,0))-2*k(4,0)*a(7,0))-2*a(5,0)*k(8,0))-2*k(5,0)*a(8,0));
  groebnerMatrix(3,34) = (((((((((((-2*a(3,0)*m(6,0)+2*a(3,0)*m(3,0))+2*a(4,0)*m(4,0))+2*a(5,0)*m(5,0))+2*a(6,0)*m(6,0))+2*a(7,0)*m(7,0))+2*a(8,0)*m(8,0))-2*m(3,0)*a(6,0))-2*a(4,0)*m(7,0))-2*m(4,0)*a(7,0))-2*a(5,0)*m(8,0))-2*m(5,0)*a(8,0));
  groebnerMatrix(3,35) = (((((((((((-2*n(3,0)*a(6,0)-2*a(3,0)*n(6,0))+2*a(3,0)*n(3,0))+2*a(4,0)*n(4,0))+2*a(5,0)*n(5,0))+2*a(6,0)*n(6,0))+2*a(7,0)*n(7,0))+2*a(8,0)*n(8,0))-2*a(4,0)*n(7,0))-2*n(4,0)*a(7,0))-2*a(5,0)*n(8,0))-2*n(5,0)*a(8,0));
  groebnerMatrix(3,36) = (((((((((-c12w+pow(a(3,0),2))+pow(a(4,0),2))+pow(a(5,0),2))+pow(a(6,0),2))+pow(a(7,0),2))+pow(a(8,0),2))-2*a(3,0)*a(6,0))-2*a(4,0)*a(7,0))-2*a(5,0)*a(8,0));
  groebnerMatrix(4,22) = ((((((((pow(l(3,0),2)+pow(l(4,0),2))+pow(l(5,0),2))-2*l(3,0)*l(9,0))-2*l(4,0)*l(10,0))-2*l(5,0)*l(11,0))+pow(l(9,0),2))+pow(l(10,0),2))+pow(l(11,0),2));
  groebnerMatrix(4,23) = (((((((((((2*k(3,0)*l(3,0)+2*k(4,0)*l(4,0))+2*k(5,0)*l(5,0))+2*k(9,0)*l(9,0))+2*k(10,0)*l(10,0))+2*k(11,0)*l(11,0))-2*k(3,0)*l(9,0))-2*l(3,0)*k(9,0))-2*k(4,0)*l(10,0))-2*l(4,0)*k(10,0))-2*k(5,0)*l(11,0))-2*l(5,0)*k(11,0));
  groebnerMatrix(4,24) = ((((((((pow(k(3,0),2)+pow(k(4,0),2))+pow(k(5,0),2))-2*k(3,0)*k(9,0))-2*k(4,0)*k(10,0))-2*k(5,0)*k(11,0))+pow(k(9,0),2))+pow(k(10,0),2))+pow(k(11,0),2));
  groebnerMatrix(4,25) = (((((((((((2*m(3,0)*l(3,0)+2*m(4,0)*l(4,0))+2*m(5,0)*l(5,0))+2*m(9,0)*l(9,0))+2*m(10,0)*l(10,0))+2*m(11,0)*l(11,0))-2*m(3,0)*l(9,0))-2*l(3,0)*m(9,0))-2*m(4,0)*l(10,0))-2*l(4,0)*m(10,0))-2*m(5,0)*l(11,0))-2*l(5,0)*m(11,0));
  groebnerMatrix(4,26) = (((((((((((2*m(3,0)*k(3,0)+2*m(4,0)*k(4,0))+2*m(5,0)*k(5,0))+2*m(9,0)*k(9,0))+2*m(10,0)*k(10,0))+2*m(11,0)*k(11,0))-2*m(3,0)*k(9,0))-2*k(3,0)*m(9,0))-2*m(4,0)*k(10,0))-2*k(4,0)*m(10,0))-2*m(5,0)*k(11,0))-2*k(5,0)*m(11,0));
  groebnerMatrix(4,27) = ((((((((pow(m(3,0),2)+pow(m(4,0),2))+pow(m(5,0),2))-2*m(3,0)*m(9,0))-2*m(4,0)*m(10,0))-2*m(5,0)*m(11,0))+pow(m(9,0),2))+pow(m(10,0),2))+pow(m(11,0),2));
  groebnerMatrix(4,28) = (((((((((((2*n(3,0)*l(3,0)+2*n(4,0)*l(4,0))+2*n(5,0)*l(5,0))+2*n(9,0)*l(9,0))+2*n(10,0)*l(10,0))+2*n(11,0)*l(11,0))-2*n(3,0)*l(9,0))-2*l(3,0)*n(9,0))-2*n(4,0)*l(10,0))-2*l(4,0)*n(10,0))-2*n(5,0)*l(11,0))-2*l(5,0)*n(11,0));
  groebnerMatrix(4,29) = (((((((((((2*n(3,0)*k(3,0)+2*n(4,0)*k(4,0))+2*n(5,0)*k(5,0))+2*n(9,0)*k(9,0))+2*n(10,0)*k(10,0))+2*n(11,0)*k(11,0))-2*n(3,0)*k(9,0))-2*k(3,0)*n(9,0))-2*n(4,0)*k(10,0))-2*k(4,0)*n(10,0))-2*n(5,0)*k(11,0))-2*k(5,0)*n(11,0));
  groebnerMatrix(4,30) = (((((((((((2*n(3,0)*m(3,0)+2*n(4,0)*m(4,0))+2*n(5,0)*m(5,0))+2*n(9,0)*m(9,0))+2*n(10,0)*m(10,0))+2*n(11,0)*m(11,0))-2*n(3,0)*m(9,0))-2*m(3,0)*n(9,0))-2*n(4,0)*m(10,0))-2*m(4,0)*n(10,0))-2*n(5,0)*m(11,0))-2*m(5,0)*n(11,0));
  groebnerMatrix(4,31) = ((((((((pow(n(3,0),2)+pow(n(4,0),2))+pow(n(5,0),2))-2*n(3,0)*n(9,0))-2*n(4,0)*n(10,0))-2*n(5,0)*n(11,0))+pow(n(9,0),2))+pow(n(10,0),2))+pow(n(11,0),2));
  groebnerMatrix(4,32) = (((((((((((2*a(3,0)*l(3,0)+2*a(4,0)*l(4,0))+2*a(5,0)*l(5,0))+2*a(9,0)*l(9,0))+2*a(10,0)*l(10,0))+2*a(11,0)*l(11,0))-2*a(3,0)*l(9,0))-2*l(3,0)*a(9,0))-2*a(4,0)*l(10,0))-2*l(4,0)*a(10,0))-2*a(5,0)*l(11,0))-2*l(5,0)*a(11,0));
  groebnerMatrix(4,33) = (((((((((((2*a(3,0)*k(3,0)+2*a(4,0)*k(4,0))+2*a(5,0)*k(5,0))+2*a(9,0)*k(9,0))+2*a(10,0)*k(10,0))+2*a(11,0)*k(11,0))-2*a(3,0)*k(9,0))-2*k(3,0)*a(9,0))-2*a(4,0)*k(10,0))-2*k(4,0)*a(10,0))-2*a(5,0)*k(11,0))-2*k(5,0)*a(11,0));
  groebnerMatrix(4,34) = (((((((((((2*a(3,0)*m(3,0)+2*a(4,0)*m(4,0))+2*a(5,0)*m(5,0))+2*a(9,0)*m(9,0))+2*a(10,0)*m(10,0))+2*a(11,0)*m(11,0))-2*a(3,0)*m(9,0))-2*m(3,0)*a(9,0))-2*a(4,0)*m(10,0))-2*m(4,0)*a(10,0))-2*a(5,0)*m(11,0))-2*m(5,0)*a(11,0));
  groebnerMatrix(4,35) = (((((((((((2*a(3,0)*n(3,0)+2*a(4,0)*n(4,0))+2*a(5,0)*n(5,0))+2*a(9,0)*n(9,0))+2*a(10,0)*n(10,0))+2*a(11,0)*n(11,0))-2*a(3,0)*n(9,0))-2*n(3,0)*a(9,0))-2*a(4,0)*n(10,0))-2*n(4,0)*a(10,0))-2*a(5,0)*n(11,0))-2*n(5,0)*a(11,0));
  groebnerMatrix(4,36) = (((((((((-c13w+pow(a(3,0),2))+pow(a(4,0),2))+pow(a(5,0),2))+pow(a(9,0),2))+pow(a(10,0),2))+pow(a(11,0),2))-2*a(3,0)*a(9,0))-2*a(4,0)*a(10,0))-2*a(5,0)*a(11,0));
}
