# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-10633 (ocaml-postgresql)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66257);
 script_cve_id("CVE-2009-2943");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 script_name("Fedora Core 11 FEDORA-2009-10633 (ocaml-postgresql)");

 desc = "The remote host is missing an update to ocaml-postgresql
announced via advisory FEDORA-2009-10633.

Update Information:

- New upstream version 1.12.3.  - This contains a SECURITY fix for:
https://bugzilla.redhat.com/show_bug.cgi?id=529325
CVE-2009-2943 ocaml-postgresql: Missing escape function (DSA-1909-1)
HOWEVER you are not protected until you change your code to  use the
new connection#escape_string method.

ChangeLog:

* Fri Oct 16 2009 Richard W.M. Jones  - 1.12.3-1.fc11.2
- Fix build process for new upstream tarball layout.
* Fri Oct 16 2009 Richard W.M. Jones  - 1.12.3-1
- New upstream version 1.12.3.
- This contains a SECURITY fix for:
https://bugzilla.redhat.com/show_bug.cgi?id=529325
CVE-2009-2943 ocaml-postgresql: Missing escape function (DSA-1909-1)
HOWEVER you are not protected until you change your code to
use the new connection#escape_string method.

References:

[ 1 ] Bug #529325 - CVE-2009-2943 ocaml-postgresql: Missing escape function (DSA-1909-1)
https://bugzilla.redhat.com/show_bug.cgi?id=529325

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update ocaml-postgresql' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-10633

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-10633 (ocaml-postgresql)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"ocaml-postgresql", rpm:"ocaml-postgresql~1.12.3~1.fc11.2", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ocaml-postgresql-devel", rpm:"ocaml-postgresql-devel~1.12.3~1.fc11.2", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
