/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import sun.net.ProgressEvent;
import sun.net.ProgressListener;
import sun.plugin.util.GrayBoxPanel;
import sun.plugin.util.ProgressMonitor;

public class GrayBoxPainter
implements ProgressListener {
    private Color boxBGColor = Color.white;
    private Color boxFGColor = Color.black;
    private String waitingMessage = null;
    private Image customImage;
    private URL customImageURL;
    private URL codebaseURL;
    private URL[] jarURLs = new URL[0];
    private HashMap downloadInProgressMap = new HashMap();
    private boolean progressBarEnabled = true;
    private Container container;
    private ThreadGroup threadGroup;
    private MediaTracker tracker;
    private boolean appletErrorOccurred = false;
    private boolean animationReady = false;
    private boolean progressBarReady = false;
    private boolean paintingSuspended = false;
    private GrayBoxPanel m_grayboxPanel = null;
    private int currentProgress = 0;
    private int maximumProgress = 10000;
    private int numJarTotal = 0;
    private int numberOfJarLoaded = 0;
    private ArrayList progressSourceFilterList = new ArrayList();

    public GrayBoxPainter(Container container) {
        this.container = container;
    }

    public synchronized void beginPainting(ThreadGroup threadGroup) {
        Object object;
        this.threadGroup = threadGroup;
        this.tracker = new MediaTracker(this.container);
        this.loadCustomImage();
        if (this.progressBarEnabled && this.customImageURL == null) {
            object = (ProgressMonitor)sun.net.ProgressMonitor.getDefault();
            ((ProgressMonitor)((Object)object)).addProgressListener(this.threadGroup, this);
        }
        object = this;
        this.paintingSuspended = false;
        new Thread(new Runnable((GrayBoxPainter)object){
            final /* synthetic */ GrayBoxPainter val$painter;
            {
                this.val$painter = grayBoxPainter2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Thread.sleep(1500L);
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.val$painter.setAnimationReady();
                    this.val$painter.setProgressBarReady();
                    this.val$painter.repaintGrayBox();
                    throw throwable;
                }
            }
        }).start();
    }

    public synchronized void finishPainting() {
        if (this.m_grayboxPanel != null) {
            this.m_grayboxPanel.stop();
            this.container.remove(this.m_grayboxPanel);
            this.m_grayboxPanel = null;
        }
        if (this.progressBarEnabled) {
            ProgressMonitor progressMonitor = (ProgressMonitor)sun.net.ProgressMonitor.getDefault();
            progressMonitor.removeProgressListener(this.threadGroup, this);
        }
        this.paintingSuspended = false;
    }

    public void showLoadingError() {
        this.appletErrorOccurred = true;
        this.repaintGrayBox();
    }

    private void loadCustomImage() {
        if (this.customImageURL != null) {
            try {
                this.customImage = Toolkit.getDefaultToolkit().getImage(this.customImageURL);
                this.tracker.addImage(this.customImage, 1);
                this.tracker.waitForID(1);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public void setProgressFilter(URL uRL, String string) {
        this.codebaseURL = uRL;
        if (string != null) {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            URL[] uRLArray = new URL[]{};
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                try {
                    object = new URL(uRL, string2);
                    arrayList.add(object);
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
            uRLArray = new URL[arrayList.size()];
            int n = 0;
            object = arrayList.iterator();
            while (object.hasNext()) {
                uRLArray[n] = (URL)object.next();
                ++n;
            }
            this.jarURLs = uRLArray;
            this.numJarTotal = uRLArray.length;
        }
    }

    public void setCustomImageURL(URL uRL) {
        this.progressBarEnabled = false;
        this.customImageURL = uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressStart(ProgressEvent progressEvent) {
        ArrayList arrayList = this.progressSourceFilterList;
        synchronized (arrayList) {
            if (this.progressSourceFilterList.contains(progressEvent.getSource())) {
                return;
            }
            if (this.numJarTotal > 0) {
                for (int i = 0; i < this.jarURLs.length; ++i) {
                    if (!progressEvent.getURL().equals(this.jarURLs[i])) continue;
                    this.progressSourceFilterList.add(progressEvent.getSource());
                    HashMap hashMap = this.downloadInProgressMap;
                    synchronized (hashMap) {
                        this.downloadInProgressMap.put(progressEvent.getURL(), progressEvent);
                        break;
                    }
                }
            } else if (progressEvent.getURL().toString().startsWith(this.codebaseURL.toString())) {
                this.progressSourceFilterList.add(progressEvent.getSource());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressUpdate(ProgressEvent progressEvent) {
        Cloneable cloneable = this.progressSourceFilterList;
        synchronized (cloneable) {
            if (this.progressSourceFilterList.size() == 0) {
                this.progressStart(progressEvent);
            }
            if (!this.progressSourceFilterList.contains(progressEvent.getSource())) {
                return;
            }
        }
        if (this.numJarTotal > 0) {
            cloneable = this.downloadInProgressMap;
            synchronized (cloneable) {
                this.downloadInProgressMap.put(progressEvent.getURL(), progressEvent);
                this.currentProgress = this.getCurrentProgress();
            }
            this.repaintGrayBox();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressFinish(ProgressEvent progressEvent) {
        Cloneable cloneable = this.progressSourceFilterList;
        synchronized (cloneable) {
            if (!this.progressSourceFilterList.contains(progressEvent.getSource())) {
                return;
            }
            this.progressSourceFilterList.remove(progressEvent.getSource());
        }
        if (progressEvent.getProgress() == 0) {
            this.downloadInProgressMap.remove(progressEvent.getURL());
            return;
        }
        if (this.numJarTotal > 0) {
            cloneable = this.downloadInProgressMap;
            synchronized (cloneable) {
                this.downloadInProgressMap.remove(progressEvent.getURL());
                ++this.numberOfJarLoaded;
                this.currentProgress = this.numJarTotal == this.numberOfJarLoaded ? this.maximumProgress : this.getCurrentProgress();
            }
        } else {
            int n = (this.maximumProgress - this.currentProgress) / 2;
            this.currentProgress += n;
        }
        this.repaintGrayBox();
    }

    private int getCurrentProgress() {
        int n = this.maximumProgress / this.numJarTotal;
        int n2 = n * this.numberOfJarLoaded;
        for (ProgressEvent progressEvent : this.downloadInProgressMap.values()) {
            if (progressEvent.getExpected() != -1) {
                n2 = (int)((double)n2 + (double)n / (double)progressEvent.getExpected() * (double)progressEvent.getProgress());
                continue;
            }
            n2 += n / 2;
        }
        return n2;
    }

    public void setBoxBGColor(Color color) {
        this.boxBGColor = color;
        if (this.m_grayboxPanel != null) {
            this.m_grayboxPanel.setBgColor(color);
        }
    }

    public Color getBoxBGColor() {
        return this.boxBGColor;
    }

    public void setBoxFGColor(Color color) {
        this.boxFGColor = color;
    }

    public void setWaitingMessage(String string) {
        this.waitingMessage = string;
    }

    public synchronized void suspendPainting() {
        if (!this.paintingSuspended) {
            if (this.m_grayboxPanel != null) {
                this.m_grayboxPanel.stop();
                this.container.remove(this.m_grayboxPanel);
            }
            this.paintingSuspended = true;
            this.container.validate();
        }
    }

    public synchronized void resumePainting() {
        if (this.paintingSuspended) {
            if (this.m_grayboxPanel != null) {
                this.m_grayboxPanel.start();
                this.container.add((Component)this.m_grayboxPanel, "Center");
            }
            this.paintingSuspended = false;
            this.container.validate();
        }
    }

    public void setAnimationReady() {
        this.animationReady = true;
    }

    public void setProgressBarReady() {
        this.progressBarReady = true;
    }

    private void repaintGrayBox() {
        this.paintGrayBox(this.container, this.container.getGraphics());
    }

    private synchronized GrayBoxPanel getGrayBoxPanel() {
        if (this.m_grayboxPanel == null) {
            this.m_grayboxPanel = new GrayBoxPanel(this.container, this.boxBGColor);
            this.container.add((Component)this.m_grayboxPanel, "Center");
            if (!this.appletErrorOccurred) {
                if (this.customImage == null) {
                    this.m_grayboxPanel.setMaxProgressValue(this.maximumProgress);
                    this.m_grayboxPanel.start();
                } else {
                    this.m_grayboxPanel.setCustomImage(this.customImage);
                }
            } else {
                this.m_grayboxPanel.setError();
            }
            this.container.validate();
        }
        return this.m_grayboxPanel;
    }

    public synchronized void paintGrayBox(Container container, Graphics graphics) {
        if (this.paintingSuspended || graphics == null) {
            return;
        }
        Dimension dimension = this.container.getSize();
        if (!this.animationReady && !this.appletErrorOccurred) {
            if (dimension.width > 0 && dimension.height > 0) {
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, dimension.width, dimension.height);
            }
            return;
        }
        if (dimension.width > 0 && dimension.height > 0) {
            GrayBoxPanel grayBoxPanel = this.getGrayBoxPanel();
            if (this.appletErrorOccurred) {
                grayBoxPanel.setError();
                grayBoxPanel.paint(graphics);
            } else {
                grayBoxPanel.progress(this.currentProgress);
            }
        }
    }
}

