///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __ANIM_SETTINGS_DIALOG_H
#define __ANIM_SETTINGS_DIALOG_H

#include <core/scene/animation/AnimManager.h>
#include <core/gui/SpinnerWidget.h>

namespace Core {

/******************************************************************************
* This dialog box lets the user manage the animation settings.
******************************************************************************/
class AnimationSettingsDialog : public QDialog
{
	Q_OBJECT
	
public:
	/// Constructor.
	AnimationSettingsDialog(QWidget* parentWindow = NULL);
	
	/// Destructor.
	virtual ~AnimationSettingsDialog();
	
private Q_SLOTS:	

	/// Event handler for the CANCEL button.
	void OnCancel();

	/// Is called when the user has selected a new value for the frames per seconds.
	void OnFramesPerSecondChanged(int index);
	
	/// Is called when the user has selected a new value for the playback speed.
	void OnPlaybackSpeedChanged(int index);
	
private:
	
	/// Updates the values shown in the dialog.
	void UpdateValues();

	QComboBox* fpsBox;
	SpinnerWidget* animStartSpinner;
	SpinnerWidget* animEndSpinner;	
	QComboBox* playbackSpeedBox;
};

};

#endif // __ANIM_SETTINGS_DIALOG_H
