// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtAUXFileFileFormat.h                         //
// ************************************************************************* //

#ifndef AVT_AUX_FILE_FORMAT_H
#define AVT_AUX_FILE_FORMAT_H

#include <avtSTSDFileFormat.h>
#include <vtkFloatArray.h>

#include <string>

// ****************************************************************************
//  Class: avtAUXFileFileFormat
//
//  Purpose:
//      Reads in AUXFile files as a plugin to VisIt.
//
//  Programmer: miller -- generated by xml2avt
//  Creation:   Tue Mar 15 08:29:20 PDT 2005
//
//  Modifications:
//    Jeremy Meredith, Thu Jan  7 12:32:12 EST 2010
//    Refactored out file reading code to a separate function.
//
// ****************************************************************************

class avtAUXFileFileFormat : public avtSTSDFileFormat
{
  public:
                       avtAUXFileFileFormat(const char *filename);
    virtual           ~avtAUXFileFileFormat() {;};

    virtual const char    *GetType(void)   { return "AUXFile"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(const char *);
    virtual vtkDataArray  *GetVar(const char *);

  protected:
    void                   ReadFile();
    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *);

    bool                   fileRead;
    std::string            fileName;
    char *                 fileBuf;

    int                    sizeX, sizeY;

    vtkFloatArray         *fluence;

};


#endif
