# Learning

The VTK [textbook](https://book.vtk.org) offers thorough descriptions of important visualization algorithms and techniques that can be found in VTK
along with some examples.

More examples and how-to guides can be found at the [examples](https://examples.vtk.org/site) website.
Check also
[this](https://examples.vtk.org/site/Python/Utilities/SelectExamples) script for
getting examples focused around specific classes.

Community discussion takes place on the [VTK Discourse](https://discourse.vtk.org) forum.

Commercial [support and training](https://kitware.com/support) are available from [Kitware](https://kitware.com).

There is also a collection of technical guides related to VTK that have been
published as blog-posts in the past:

 - [Improved VTK - numpy integration (part 1)](https://www.kitware.com/improved-vtk-numpy-integration)
 - [Improved VTK - numpy integration (part 2)](https://www.kitware.com/improved-vtk-numpy-integration-part-2)
 - [Improved VTK - numpy integration (part 3)](https://www.kitware.com/improved-vtk-numpy-integration-part-3)
 - [Improved VTK - numpy integration (part 4)](https://www.kitware.com/improved-vtk-numpy-integration-part-4)
 - [Improved VTK - numpy integration (part 5)](https://www.kitware.com/improved-vtk-numpy-integration-part-5)
 - [vtkProgrammableFilter](https://www.kitware.com/vtkprogrammablefilter-aint-so-bad)
 - [vtkPythonAlgorithm](https://www.kitware.com//vtkpythonalgorithm-is-great)
 - [A VTK pipeline primer (part 1) ](https://www.kitware.com/a-vtk-pipeline-primer-part-1/)
 - [A VTK pipeline primer (part 2) ](https://www.kitware.com/a-vtk-pipeline-primer-part-2/)
 - [A VTK pipeline primer (part 3) ](https://www.kitware.com/a-vtk-pipeline-primer-part-3/)
 - [Streaming in VTK: Time](https://www.kitware.com/streaming-in-vtk-time/)
 - [Streaming in VTK: Spatial](https://www.kitware.com/streaming-in-vtk-spatial/)
 - [Spatial Streaming and Compositing](https://www.kitware.com/spatial-streaming-and-compositing/)

 For more posts related to VTK see [here](https://www.kitware.com/tag/vtk).
